use strict;
use utf8;
use warnings;

package noris::Ticket::API::OTRS::Connection;

use Carp qw(confess);
use Cf qw($OTRS_TICKET_SERVER);
use JSON;
use Moose;
use noris::Ticket::API::OTRS::SelectResult;
use noris::Ticket::API::OTRS::Connection::Socket;

has 'socket' => (is => 'ro', isa => 'IO::Socket', default => sub {
    my $socket;
    for ( split ' ', $OTRS_TICKET_SERVER ) {
        eval {
            local $SIG{ALRM} = sub { die "TIMEOUT\n" };
            alarm 3;
            $socket = noris::Ticket::API::OTRS::Connection::Socket->new( 
                    PeerAddr => $_, 
                    Timeout => 2,
                );
            alarm 0;
        };
        return $socket unless length $@;
    }
    confess(
        "Konnte keine Verbindung zu OTRS ($OTRS_TICKET_SERVER) aufbauen: $@");
});

sub change_user {
    my ($self, $user_name) = @_;
    my $socket = $self->socket;
    $socket->print("user $user_name\n");
    $socket->getline_expect(qr/\AOK\z/);
}

sub is_open {
    my ($self) = @_;
    my $socket = $self->socket;
    my $response;
    eval {
        local $SIG{ALRM} = sub { die "TIMEOUT\n" };
        alarm 2;
        $socket->print("ping\n") and $response = $socket->getline();
        alarm 0;
    };
    return defined $response && $response =~ /\AOK\b/;
}

sub select_tickets {
    my ($self, %param) = @_;
    my $socket = $self->socket;
    my $attributes = $param{attributes};
    $socket->print("select_ticket @$attributes\n");
    $socket->print(JSON->new->objToJson($param{query}) . "\n\n" );
    return noris::Ticket::API::OTRS::SelectResult->new(
        connection => $self, 
        attributes => $attributes, 
        buffer_id => $socket->get_number(),
    );
}

sub DEMOLISH {
    my ($self, %param) = @_;
    my $socket = $self->socket;
    return if !defined $socket || $socket->has_error;
    $socket->print("quit\n") or return;
    local $@;    # vgl. Ticket #10017164
    eval {
        $socket->getline_expect(qr/\AOK\z/);
    };
    my $err = $@;
    shutdown($socket, 2);  # stopped using this socket
    die "Unerwartete Antwort auf quit: $err" if $err;
}

1;
