use strict;
use utf8;
use warnings;

package noris::CSV;

use base qw(Text::CSV_XS);

use UTFkram qw(decode_anything);

our @ISA;

sub as_decoded_string {
    my $self = shift;
    $self->combine(@_) or die $self->error_input;
    defined( my $string = $self->string ) or die $self->error_input;
    decode_anything($string);
}

sub new {
    my ( $package, $options, @rest ) = @_;
    $options ||= {};
    $options->{binary} = 1  unless defined $options->{binary};
    $options->{eol}    = $/ unless defined $options->{eol};
    bless $ISA[0]->new( $options, @rest ), $package;
}

1;

__END__

=head1 NAME

noris::CSV - CSV-Ausgabe leicht gemacht

=head1 BESCHREIBUNG

Dieses Modul ist von L<Text::CSV_XS> abgeleitet.

=head1 ÄNDERUNGEN BEI ->new

=over 4

=item *

Die C<binary>-Option wird per Default angeschaltet.

=item *

C<eol> wird per Default auf C<$/> gesetzt.

=back

=head1 ZUSÄTZLICHE METHODEN

=over 4

=item ->as_decoded_string( FELDER )

Aus den angegebenen Werten wird eine CSV-Zeichenkette inklusive
Zeilenendkennung gebastelt und zurückgegeben.
Bei Fehlern wird automatisch eine Exception geworfen.

=back

