package Net::DNS::Cache::Slot;

use utf8;
use warnings;
use strict;

use Carp;

sub new {
    my $package = shift;
    $package = ref $package if length ref $package;
    die 'USAGE: ' . __PACKAGE__ . '->new({<method> => <value>}*)' if @_ & 1;
    my $self = bless {}, $package;
    while (@_) {
        my ( $method, $value ) = splice @_, 0, 2;
        $self->$method($value);
    }
    $self;
}

sub answerfrom {
    my ( $self, $value ) = @_;
    die 'USAGE: ' . __PACKAGE__ . '->answerfrom([<host>])'
      unless length ref $self && $self->isa(__PACKAGE__)
      and @_ == 1 || @_ == 2 && defined $value;
    $self->{answerfrom} = $value if @_ == 2;
    $self->{answerfrom};
}

sub expires {
    my ( $self, $value ) = @_;
    die 'USAGE: ' . __PACKAGE__ . '->expires([<time>])'
      unless length ref $self && $self->isa(__PACKAGE__)
      and @_ == 1 || @_ == 2 && defined $value;
    $self->{expires} = $value if @_ == 2;
    $self->{expires};
}

sub timestamp {
    my ( $self, $value ) = @_;
    die 'USAGE: ' . __PACKAGE__ . '->timestamp([<time>])'
      unless length ref $self && $self->isa(__PACKAGE__)
      and @_ == 1 || @_ == 2;
    if (@_ == 2) { $self->{timestamp} = defined $value ? $value : time }
    elsif (!defined $self->{timestamp}) { $self->{timestamp} = time }
    $self->{timestamp}
}

sub ttl {
    my ( $self, $value ) = @_;
    die 'USAGE: ' . __PACKAGE__ . '->ttl([<seconds>])'
      unless length ref $self && $self->isa(__PACKAGE__)
      and @_ == 1 || @_ == 2 && defined $value;
    $self->expires( $self->timestamp + $value ) if @_ == 2;
    $self->expires - $self->timestamp;
}

sub data {
    my $self = shift;
    die 'USAGE: ' . __PACKAGE__ . '->data(...)'
      unless length ref $self && $self->isa(__PACKAGE__);
    for (@_) {
        if (defined) { push @{ $self->{data} }, $_ }
        else { @{ $self->{data} } = [] }
    }
    @{ $self->{data} };
}

1
