package Docushare;

require Exporter;
use utf8;
use warnings;
use strict;
use Cf qw($DOCUSHARE $DOCUCOOKIE $DOCUHOST $MAILDOM);
our @EXPORT_OK = qw(propget propset link_ticket unlink_ticket propxget
		acltest readonly);
use Carp;
use Loader qw(get_mailadr);
use Dbase::Help qw(DoFn);
use Fehler qw(problem fehler);

sub get_xml($) {
	my($txt) = @_;

	$txt = $txt->content;

	#$txt =~ s/ä/ae/g;
	#$txt =~ s/ö/oe/g;
	#$txt =~ s/ü/ue/g;
	#$txt =~ s/Ä/Ae/g;
	#$txt =~ s/Ö/Oe/g;
	#$txt =~ s/Ü/Ue/g;
	#$txt =~ s/ß/ss/g;
	$txt =~ s/([\x80-\xff])/sprintf("\\x%02x",ord($1))/eg;

	$txt;
}

use XML::Grove;
sub _build {
	my($data) = @_;
	fehler "Build didn't get an array ref" unless UNIVERSAL::isa($data,"ARRAY");
	my(@dat) = @$data;
	shift @dat if UNIVERSAL::isa($dat[0],"HASH");
	fehler "Build with odd-sized array" if @dat % 2;
	my @res;
	while(@dat) {
		my $tag = shift @dat;
		my $val = shift @dat;
		my $attr = {};
		$attr = $val->[0] if UNIVERSAL::isa($val,"ARRAY") and UNIVERSAL::isa($val->[0],"HASH");
		if(ref $val) {
			push(@res, XML::Grove::Element->new(Name=>$tag,
												Attributes=>$attr,
												Contents=>_build($val)));
		} elsif($tag) {
			push(@res, XML::Grove::Element->new(Name=>$tag,
												Attributes=>$attr,
												Contents=>[XML::Grove::Characters->new(Data =>$val)]));
		} else {
			push(@res, XML::Grove::Characters->new(Data => $val));
		}
	}
	\@res;
}
sub build {
	XML::Grove::Document->new (Contents => _build(@_));
}

# Extrahiere aus der verqueren Datenstruktur, die da zurückkommt,
# gewisse Attribute.
sub grab($@) {
	my($r,@what) = @_;
	my @rr = ($r);
	my $rh;
	my $cnt = @what;
	nw: foreach my $w(@what) {
		--$cnt;
		if(UNIVERSAL::isa($r,"HASH")) {
			@rr = $r = $r->{$w};
			next nw;
		}
		return undef unless UNIVERSAL::isa($r,"ARRAY");
		if($w eq "%") {
			$r = $rh;
			next nw;
		}
		my @r = @$r;
		@rr = ();
		while(@r) {
			my $tag = shift @r;
			my $val = shift @r;
			if($tag eq $w) {
				if(UNIVERSAL::isa($val,"ARRAY")) {
					$r = [ @$val ];
					$rh = shift @$r;
				} else {
					$r = $val;
				}
				next nw if $cnt or not wantarray;
				push(@rr,$r);
			}
		}
		return wantarray ? () : undef unless @rr;
	}
	wantarray ? @rr : $r;
}

#my $doc; # = build(["foo",[{bar=>"baz"},0,"two","bro",[{},0,"Test"]]]);
#$doc = build([authorization=>[username=>$DOCUUSER,password=>$DOCUPASS]]);
#use Data::Dumper;
#print "foo\n",Dumper($doc->as_canon_xml);
#exit 0;

BEGIN {
	package XMLreq;
	our @ISA = qw(HTTP::Request);

	use XML::Grove::AsCanonXML;
	sub new {
		my $class = shift @_;
		my $type = shift @_;
		my $url = shift @_;

		my $req = $class->SUPER::new($type => $url);
		$req->content_type('text/xml');
		$req->header(Accept => "text/xml");
		$req->content(<<'END'.(Docushare::build([@_]))->as_canon_xml) if @_;
<?xml version="1.0" ?>

END
		$req;
	}

}

my $ua;
my $ua_age;

sub init() {
	return if $ua; # and time-$ua_age < 600; ## für auto-reLogin

	use LWP::UserAgent;
	$ua = new LWP::UserAgent;

	use HTTP::Cookies;

	# $ua->agent("RT/@RPM_PACKAGE_VERSION@-@RPM_PACKAGE_RELEASE@");
	$ua->agent("RT/noris"); # vorläufig

	$ua->timeout(90);
	# $ua->from(get_mailadr());
	$ua->from("rt\@$MAILDOM");
	my $jar = HTTP::Cookies->new;
	$jar->set_cookie(0, 'AmberUser', $DOCUCOOKIE, '/', $DOCUHOST, undef, 1, undef, undef, 1, {});
	
	$ua->cookie_jar($jar);

#	my $req = new XMLreq POST => "$DOCUSHARE/Login",
#		authorization=>[username=>$DOCUUSER,password=>$DOCUPASS];
#
#	my $resp = $ua->request($req);
#	$ua_age=time;
#	$resp;
}

use XML::Parser;
my $parser = new XML::Parser(Style => 'Tree');

# Gegeben eine Dockushare-ID, holt eine Property (zweites Argument
# angegeben) bzw. die ganze Property-Liste (ohne weitere Argumente).
sub propget($@) {
	init;
	my($prop,@what) = @_;
	my $full;
	if(@what and $what[0] eq "") {
		$full = 1;
		shift @what;
	}

	$prop =~ s/^File-//i;
	return problem "Keine Datei-ID angegeben" unless $prop =~ /^\d+$/;

	my $req = new XMLreq POST => "$DOCUSHARE/dscgi/ds.py/PROPFIND/File-$prop",
		propfind=>[prop=>[map { ( (UNIVERSAL::isa($_,"ARRAY") ? $_->[0] : $_) => undef) } @what]];
	my $resp = $ua->request($req);
	fehler "No response" unless ref $resp;
	fehler $resp->message unless $resp->is_success;

	$resp = eval { $parser->parse(get_xml($resp)); };
	fehler $@ if $@;
	fehler "Return not parseable" unless ref $resp;
	$resp = grab($resp,"multistatus","response","propstat");
	return problem "Return status ".grab($resp,"status",0) unless grab($resp,"status",0) =~ /^\S+ 2/;
	$resp = grab($resp,"prop");
	return problem "No props" unless ref $resp;
	return $resp unless @what;
	my @res;
	foreach my $wha(@what) {
		my @args = UNIVERSAL::isa($wha,"ARRAY") ? @$wha : ($wha);
		push(@args,"0") unless $full;
		push(@res,scalar grab($resp,@args));
	}
	wantarray ? @res : $res[0];
}

# wie propget, aber via speziellem Dienst
# wird für GetLastVersion benötigt
# und _könnte_ man mit propget verheiraten
sub propxget($$@) {
	init;
	my($prop,$serv,@what) = @_;
	my $full;
	if(@what and $what[0] eq "") {
		$full = 1;
		shift @what;
	}

	$prop =~ s/^File-//i;
	return problem "Keine Datei-ID angegeben" unless $prop =~ /^\d+$/;

	my $req = new XMLreq POST => "$DOCUSHARE/dscgi/ds.py/$serv/File-$prop";
#	my $req = new XMLreq POST => "$DOCUSHARE/dscgi/ds.py/$serv/File-$prop",
#		propfind=>[prop=>[map { ( (UNIVERSAL::isa($_,"ARRAY") ? $_->[0] : $_) => undef) } @what]];
	my $resp = $ua->request($req);
	fehler "No response" unless ref $resp;
	fehler $resp->message unless $resp->is_success;

	$resp = eval { $parser->parse(get_xml($resp)); };
	fehler $@ if $@;
	fehler "Return not parseable" unless ref $resp;
	$resp = grab($resp,"multistatus","response","propstat");
	# return problem "Return status ".grab($resp,"status",0) unless grab($resp,"status",0) =~ /^\S+ 2/;
	$resp = grab($resp,"prop");
	return problem "No props" unless ref $resp;
	return $resp unless @what;
	my @res;
	foreach my $wha(@what) {
		my @args = UNIVERSAL::isa($wha,"ARRAY") ? @$wha : ($wha);
		push(@args,"0") unless $full;
		push(@res,scalar grab($resp,@args));
	}
	wantarray ? @res : $res[0];
}

# Property setzen, key/value-Paare im Hash
# und liefere die Resultate (die aktuell aber alle Aufrufer ignorieren)
sub propset($%) {
	init;
	my($prop,%what) = @_;

	$prop =~ s/^File-//i;
	return problem "Keine Datei-ID angegeben" unless $prop =~ /^\d+$/;

	my $req = new XMLreq POST => "$DOCUSHARE/dscgi/ds.py/PROPPATCH/File-$prop",
		propertyupdate=>[set=>[prop=>[map { ($_ => $what{$_}) } keys %what]]];
	my $resp = $ua->request($req);
	fehler "No response" unless ref $resp;
	fehler $resp->message unless $resp->is_success;

	$resp = eval { $parser->parse(get_xml($resp)); };
	fehler $@ if $@;
	fehler "Return not parseable" unless ref $resp;
	$resp = grab($resp,"multistatus","response","propstat");
	return problem "Return status ".grab($resp,"status",0) unless grab($resp,"status",0) =~ /^\S+ 2/;
	$resp = grab($resp,"prop");
	return problem "No props" unless ref $resp;
	my @res;
	foreach my $wha(keys %what) {
		push(@res, grab($resp,$wha));
	}
	wantarray ? @res : $res[0];
}

# Dokushare-Dokument A mit Ticket B verheiraten
sub link_ticket($$;$) {
	my($file,$ticket,$ticketsub) = @_;
	my($this,$knd) = propget($file,"RTTickets","Kunde");
	$ticketsub = 0 unless $ticketsub;
	my($vers) = propxget($file,"GetLastversion","lastversion") || "";
	if($vers and $this =~ /\b$vers:$ticket-(\d+)\b/) {
		return problem "Bereits in dieses Ticket gelinkt" unless $ticketsub and not $1;
		$this =~ s/\b$vers:$ticket-0\b/$vers:$ticket-$ticketsub/;
		propset($file,RTTickets=>$this);
		return $file;
	}
	$this .= ";" if $this ne "";
	propset($file,
	        RTTickets=>"$this$vers:$ticket-".($ticketsub||0),
	        Kunde=>DoFn("select kunde from ticket where id = $ticket")||$knd||0);
	wantarray ? ($file,$vers) : $vers;
}

# Link wieder aufheben
sub unlink_ticket($$) {
	my($file,$ticket) = @_;
	my $this = propget($file,"RTTickets");
	return undef unless $this; # already cleared
	$this =~ s/\b\d+:$ticket-\d+\b//g;
	$this =~ s/(?:^;|;$|;(;))/$1/;
	propset($file,RTTickets=>$this);
	$ticket;
}

#print Dumper(init());
#print Dumper($ua->cookie_jar);
#print Dumper(prop(69,["RTNumber","displayname"]));
#print Dumper propset(69,RTNumber=>1234);
#print Dumper link_ticket(69,1234,45);

use Data::Dumper;
my @groupcache;
sub members($) {
	init;
	my($prop) = @_;

	return problem "Keine Group-ID angegeben" unless $prop =~ /^\d+$/;
	return @{$groupcache[$prop]} if $groupcache[$prop];

	my $req = new XMLreq POST => "$DOCUSHARE/dscgi/ds.py/PROPFIND/Group-$prop",
		propfind=>[prop=>[children=>undef]];
	my $resp = $ua->request($req);
	fehler "No response" unless ref $resp;
	fehler $resp->message unless $resp->is_success;

	$resp = eval { $parser->parse(get_xml($resp)); };
	fehler $@ if $@;
	fehler "Return not parseable" unless ref $resp;
	$groupcache[$prop] = [ map { grab ($_,"username",0) } grab($resp,"multistatus","response","propstat","prop","children","dsref") ];
	@{$groupcache[$prop]};
}

my @usercache;
sub username($) {
	init;
	my($prop) = @_;

	return problem "Keine User-ID angegeben" unless $prop =~ /^\d+$/;
	return $usercache[$prop] if $usercache[$prop];

	my $req = new XMLreq POST => "$DOCUSHARE/dscgi/ds.py/PROPFIND/User-$prop",
		propfind=>[prop=>[username=>undef]];
	my $resp = $ua->request($req);
	fehler "No response" unless ref $resp;
	fehler $resp->message unless $resp->is_success;

	$resp = eval { $parser->parse(get_xml($resp)); };
	fehler $@ if $@;
	fehler "Return not parseable" unless ref $resp;
	$resp = grab($resp,"multistatus","response","propstat");
	return problem "Return status ".grab($resp,"status",0) unless grab($resp,"status",0) =~ /^\S+ 2/;
	$usercache[$prop] = grab($resp,"prop","username",0);
}

# Finde raus ob Dokument A etwas ist, das User B anfassen darf
# (sonst dürfte er/sie/es auch nicht darauf verlinken)
sub acltest($$;$) {
	init;
	my($prop,$who,$what) = @_;
	$what = "readers" unless $what;

	$prop =~ s/^File-//i;
	return problem "Keine Datei-ID angegeben" unless $prop =~ /^\d+$/;

	{
		my $own = propget($prop,["entityowner","dsref","username"]);
		return 1 if $own eq $who;
	}

	my $req = new XMLreq GET => "$DOCUSHARE/dscgi/ds.py/ACL/File-$prop";
#		propfind=>[prop=>[map { ($_ => undef) } @what]];
	my $resp = $ua->request($req);
	fehler "No response" unless ref $resp;
	fehler $resp->message unless $resp->is_success;

	$resp = eval { $parser->parse(get_xml($resp)); };
	fehler $@ if $@;
	fehler "Return not parseable" unless ref $resp;
	foreach my $r(grab($resp,"acl","ace")) {
		next unless grab($r,"grant",$what);
		my $h = grab($r,"principal","dsref","%","handle");
		next unless $h;
		my @h;
		if($h =~ s/^User-//i) {
			@h = username($h);
		} elsif($h =~ s/^Group-//i) {
			@h = members($h);
		} else {
			next;
		}
		foreach $h(@h) {
			return 1 if $h eq $who;
		}
	}
	0;
}
1;

__END__

$Data::Dumper::Indent=1;
#propset(69,owner => "User-19");
#print Dumper( find($DOCUUSER,"User","username"));
print Dumper( find_collection("RT 2000"));

__END__
use XML::Grove::Builder;
use XML::Parser::PerlSAX;

my $document = $parser->parse ( Source => { String => <<END });
<?xml version="1.0" ?>

<foo bar="baz"> two <bazz/><bumm/><bro>Test</bro></foo>
END
print ref($document),"\n";
print Dumper($document->as_canon_xml);

#print Dumper($p1->parse($document->as_canon_xml));


