package Dbase::WebLogin;

use utf8;
use warnings;
use strict;
use Dbase::Help;
use Dbase::Globals;
use Apache::Constants qw(:common);

=head1 Dbase::WebLogin -- Passwortüberprüfung via Datenbank

Setzt die Environmentvariable C<$USER> auf einen (via Personenliste der
Datenbank überprüften) Usernamen.

	<Location "/">
		AuthName Noris-Intranet
		AuthType Basic
		PerlAuthenHandler Dbase::WebLogin
		AuthAuthoritative off
	</Location>

=cut

my %user;
my %userchk;

sub handler {
	my $time = time;
	my $r = shift;
	my ($res,$pw) = $r->get_basic_auth_pw;
	my $user = $r->connection->user;
	unless ($user and $pw) {
		$r->note_basic_auth_failure;
		$r->log_reason("Username and password are required.",$r->filename);
		return AUTH_REQUIRED;
	}
	$userchk{$user}=$time and return OK
		if defined $user{$user} and $userchk{$user} > $time-60 and $user{$user} eq $pw;

	$user = quote($user);
	my $xpw = DoFn("select pass from person where user = ${\qquote $user}");
	unless($xpw) {
		$r->note_basic_auth_failure;
		$r->log_reason("Password not found '$user'.",$r->filename);
		return AUTH_REQUIRED;
	}
	unless($xpw eq $pw) {
		$r->note_basic_auth_failure;
		$r->log_reason("Password incorrect '$user'.",$r->filename);
		return AUTH_REQUIRED;
	}
	$user{$user} = $pw;
	$userchk{$user} = $time;
	$r->subprocess_env(USER => $user);
	return OK;
}
1;
