package Dbase::Help;
require Exporter;

###
# Dieses Modul existiert, um Importreihenfolgeprobleme zwischen Cf.pm
# und Dbase::Help zu umgehen.

use utf8;
use strict;
use warnings;
use Dbase;

our @ISA;
use Dbase::_Help qw(
  date_add_ymd
  dbtime
  DelSeq
  Do
  DoAtCommit
  DoBinary
  DoCopy
  DoFn
  DoFree
  DoN
  DoNonFatal
  DoPing
  DoReadOnly
  DoSel
  DoSelect
  DoSeq
  DoT
  DoTime
  DoTrans
  DoTransExit
  DoTransFail
  DoTransSuspend
  hash
  in_list
  in_range
  in_test
  isodate
  isotime
  like_list
  qquote
  quote
  sisodate
  text_only
  unixdate
  unixtime
);
BEGIN { @ISA = qw(Exporter); }

our @EXPORT = qw(Do DoN DoT DoFn DoSeq isotime unixtime in_test date_add_ymd
	sisodate isodate unixdate dbtime hash DelSeq qquote quote text_only
	DoSelect DoSel DoCopy DoFree DoAtCommit DoTrans DoPing );
our @EXPORT_OK = qw(
  DoBinary
  DoNonFatal
  DoReadOnly
  DoTime
  DoTransExit
  DoTransFail
  DoTransSuspend
  in_list
  in_range
  like_list
);

sub import {
	my @arg;
	foreach my $arg(@_) {
		if($arg eq ":readonly") {
			Dbase::db_handle(no_write => 1) unless $ENV{'TESTING'};
		} else {
			push(@arg,$arg);
		}
	}
	Dbase::Help->export_to_level(1, @arg);
}

=head1 Datenbank-Helper

Dieses Modul ist ein Wrapper für Dbase::_Help, um Probleme mit zirkulären
Imports zu vermeiden. Weitere Doku siehe dort.

=cut
