##
## Einlesen von Konfigurationsvariablen
##

package Cf;
require Exporter;
use utf8;
use IO::File;
use strict;
use warnings;
use Fehler qw(fehler);

use vars qw(@ISA);
@ISA = qw(Exporter);

=head1 Variablen aus C<@POPCONFIG@>

Dieses Modul liest C<@POPCONFIG@> und exportiert alle darin enthaltenen
Variablen, bzw. nur die angeforderten.

=head2 Beispiel

	use Cf qw($POPCONFIG);

	print "Die Konfigdatei ist in der Datei '$POPCONFIG'.\n";

=head2 Environment

Alle exportierten Variablen werden durch Environmentvariablen desselben
Namens überschrieben. Insbesondere gibt C<POPCONFIG> den Namen der
Konfigurationsdatei an, die von diesem Modul gelesen wird.

=cut

my %VAL;

BEGIN {
	# Es ist zwar Unsinn, hier Environmentvariablen zu setzen,
	# aber einen besseren Platz um das global zu machen hab ich nicht.
	# ;-)
	$ENV{"LANG"}="de_DE" unless defined $ENV{"LANG"};
}
# Außerdem ist es Unsinn, hier das I/O-Encoding zu setzen, aber was
# Besseres fällt mir auch nicht ein.
use Umlaut;


sub FETCH {
	my $me = shift;
	$VAL{$$me} = $ENV{$$me} if defined $ENV{$$me};
	$VAL{$$me};
}

sub STORE {
	my $me = shift;
	fehler "$$me ist read-only";
}

sub TIESCALAR {
	my($class,$name)=@_;
	bless \$name,$class;
}

our @EXPORT;

sub set_var($$) {
	my ( $name, $wert ) = @_;

	$VAL{$name} = $wert;

	no strict 'refs';
	no warnings 'once';
	tie $$name, 'Cf', $name;
	push @EXPORT, '$' . $name;
}

BEGIN {
	@EXPORT = ();
	my $fn = $ENV{'POPCONFIG'} || '@POPCONFIG@';
	my $fh = IO::File->new($fn);
	if($fh) {
		local $/ = "\n";
		while(defined(my $entry = <$fh>)) {
			$entry =~ s/\s*#.*//;
			next if $entry =~ /^\s*$/;

			if ( my ( $name, $wert ) = $entry =~ /^([^=]+)=(.*)$/ ) {
				$wert =~ s/^(["'])(.*)\1\s*$/$2/;
				set_var( $name, $wert );
			}
			else {
				warn "Konfig: Zeile $.: '$entry' verstehe ich nicht.\n"
				  unless $entry =~ /^\s*export\s/;
			}
		}
		$fh->close;
	} else {
		die "Cf.pm: Konfigdatei '$fn': $!\n";
	}
}

my $db;
sub read_db() {
	if($Cf::delay_read) {
		$Cf::delay_read++;
		return;
	}
	require Dbase::_Help and Dbase::_Help->import(qw(DoSelect in_list qquote));
	require Dbase;

	my $suchliste = $ENV{'KONFIG_SUCHLISTE'} || $Cf::KONFIG_SUCHLISTE;
	die 'In der @POPCONFIG@ muss eine $KONFIG_SUCHLISTE definiert sein.' . "\n"
		unless defined $suchliste;

	if(not defined $db) {
		if(defined $ENV{'POPCONFIGDB'}) {
			$db = Dbase->new(DBDATABASE=>$ENV{'POPCONFIGDB'});
		} else {
			$db = Dbase::db_handle();
		}
	}

	$db->DoSelect( \&set_var, <<_ ) for split ' ', $suchliste;
		SELECT V.name, W.wert
		FROM   konfig_wert W
		JOIN   konfig_namensraum N ON N.id = W.namensraum
		JOIN   konfig_variable   V ON V.id = W.variable
		WHERE  N.name = ${\ qquote($_) }
		AND ${\ in_list( 'V.name', NOT => map /^\$(.+)/ ? $1 : (), @EXPORT ) }
_
}

read_db() unless $db or $VAL{LOCAL_CF_ONLY} or
                 $ENV{'DbLocalCf'} or $ENV{'TESTING'};

unless ( defined $VAL{BGCOLOR} ) {
	our $BGCOLOR = $VAL{BGCOLOR} =
	  defined $Cf::MODE && lc $Cf::MODE ne 'production' ? '#99ff99' : 'white';
	push @EXPORT, '$BGCOLOR';
}

1;
