package ThresholdExt;

use warnings;
use strict;

use 5.006_000; use 5.6.0; 
use bignum; #me
use Carp;
use Data::Dumper;
use NagTools2 qw( debug i $BLANK commify one_of $BYTES_per_GBYTE);


#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

our $VERSION = '2.1.0';	 	              


#me
#me
#me
#me	 	              
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

our ($DEFAULT_UOM, $UOM);

sub new {
    my $class = shift;              #me
    my $self = {};                  #me
    bless($self, $class);
    $self->_set_limits();
    return $self;
}

sub _set_limits {
    my $self = shift;

    $self->{'limits'}{'%'}{'lower'} = 0;
    $self->{'limits'}{'%'}{'upper'} = 100;

    $self->{'limits'}{'GB'}{'lower'}   = 0;
    $self->{'limits'}{'GB'}{'upper'}   = (10**32 - 1) / $BYTES_per_GBYTE; 
        #me
    
    $self->{'limits'}{'kB/s'}{'lower'}   = 0;
    $self->{'limits'}{'kB/s'}{'upper'}   = 10**12 / 10**3 / 8; #me
    
    $self->{'limits'}{'/s'}{'lower'}   = 0;
    $self->{'limits'}{'/s'}{'upper'}   = 2**31  - 1 ; #me
    
    $self->{'limits'}{'µs'}{'lower'}   = 0;
    $self->{'limits'}{'µs'}{'upper'}   = 2**31  - 1 ; #me
    
    
    #me
    #me
    
}

sub set_allowed_uoms {
    my $self = shift;
    $self->{'allowed_uoms'} = shift;

    return $self;
}

sub set_default_uom {
    my $self = shift;
    my $strg = shift;
    my $found = undef;	 	              
    foreach (@{$self->{'allowed_uoms'}}) {
        if ($_ eq $strg) {
            $found = 1;
            last;
        }
    }
    if ($found) {
        $self->{'default_uom'} = $strg;
    } else {
        croak '>' . "$strg" . '<' . ' is not one of the allowed uoms';
    }
    return $self;
}

sub get_allowed_uoms {

#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $args = shift;
    my $text;
    if (defined $args->{'format'}) {
        if ($args->{'format'} eq 'commified_text') {
            $text = commify(@{$self->{'allowed_uoms'}});
        } else {
            croak 'undefined format ' . $args->{'format'}; #me
        }
        return $text;
    } else {
        return $self->{'allowed_uoms'};
    }
}

sub get_default_uom {
    my $self = shift;
    return $self->{'default_uom'};
}

sub get_uom {
    my $self = shift;
    return $self->{'uom'};
}

sub _check_limits {
    #me
    # nagios->die if out of limits (see set_limits() )
    my $self = shift;
    my $val  = shift;    #me
    
    my $uom = $self->{'uom'};
    my $p = $self->{'_p'}; #me
    
    if (defined $self->{'limits'}{"$uom"}) {
        if (   ( $val < $self->{'limits'}{"$uom"}{'lower'} )
            or ( $val > $self->{'limits'}{"$uom"}{'upper'} ) )
        {
            my $errmsg = ('Thresholds are in '
                  . "$uom"
                  . '. Allowed range is from '
                  . $self->{'limits'}{"$uom"}{'lower'} 
                  . ' to '
                  . $self->{'limits'}{"$uom"}{'upper'}
                  . '.' );
            $p->nagios_die("$errmsg");
            croak 'FATAL ERROR';
        }
    }
    return 'OK: Grenzwerte sind im Rahmen';    #me
}

sub set_thresholds {
    my $debug = $main::DEBUG;
    my $self = shift;
    $self->{'_p'} = shift;  #me
    croak 'undefined N::P object' if not defined $self->{'_p'};
    my $p = $self->{'_p'};
    my ( %t_in, %uom_out );
    $t_in{'warn'} = $p->opts->warning;  #me
    $t_in{'crit'} = $p->opts->critical; #me

    foreach ( 'warn', 'crit' ) {    # Fall 1: mit 'uom', z.B. 70%
        my $special = qr{%°/µ}; #me
        if ($t_in{$_} =~ s{ ([${special}a-zA-Z]+)$  
                                    #me
                                    #me
                                    #me
                                    #me
                           }
                           {}x     #me
            ) {
            $uom_out{$_} = $1;     #me
            debug(1, "Found this uom behind $_: $uom_out{$_}");
        } else {                   #me
            if ($debug > 0) {
                print {*STDERR} 
                    "No uom behind $_ found, trying default ... "
                     . $self->{'default_uom'} . "\n" 
            };
            if (defined $self->{'default_uom'}) {
                $uom_out{$_} = $self->{'default_uom'};
                debug(1, "uom for $_ is now $uom_out{$_} due to default in ThresholdExt-object.")
            } else {
                $p->nagios_die('Threshold needs an uom!');
            }
            
        }


        
        #me
        #me
        #me

        if ( $t_in{$_} =~ m{                #me
                            ^[@]?           #me
                            \d*[:]?\d*      #me
                            }x 
            ) {

            $self->{'thresholds'}{$_} = $t_in{$_};
        } else {
            $p->nagios_die( 
                'Wrong format of threshold - must be either of 12, 12:34uom, :34uom, 12:uom, @10:20uom! Examples: 10:20GB, 10:30%, :5%, 23:GB'
            );
            croak 'FATAL ERROR';
        }
    }
    if (defined $uom_out{'warn'} and defined $uom_out{'crit'}) {
        if ( $uom_out{'warn'} ne $uom_out{'crit'} ) {
               $p->nagios_die(
                   "Units of critical and warning threshold must be the same!");
               croak 'FATAL ERROR';
         }
        if ( not one_of($uom_out{'warn'}, $self->{'allowed_uoms'})  ) {
               $p->nagios_die(
                   $uom_out{'warn'} . $BLANK
                   . 'is not a valid uom for the thresholds.' . $BLANK
                   . 'Allowed uoms are: ' . commify(@{$self->{'allowed_uoms'}})
                );
               croak 'FATAL ERROR';
         }
         $self->{'uom'} = $uom_out{'warn'};

    } else {

        $self->{'uom'} = 'none';        # uom ('none') im Objekt gespeichert
    }

    foreach my $val (   $self->{'thresholds'}{'warn'}, 
                        $self->{'thresholds'}{'crit'} 
                    ) {
        if ( $val =~ /(\d*):(\d*)/ ) {        #me
            foreach ( $1, $2 ) {
                next if ( $_ eq '' );
                $self->_check_limits->($_);
            }
        }
        elsif ( $val =~ /\d+/ ) {             #me
            $self->_check_limits($val);
        }
    }
    $p->set_thresholds(
      warning => $self->{'thresholds'}{'warn'},
      critical => $self->{'thresholds'}{'crit'}
    );

    return $self;
}

1; #me
__END__

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me


#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me



