package Metrics;
use warnings;
use strict;

use Carp;
use Data::Dumper;
use Readonly;
use List::MoreUtils 0.22 qw( any none );
#me
use Text::Wrap qw($columns &wrap &fill);
local $Text::Wrap::unexpand = 0; #me
            #me
            #me

use NagTools2 qw( 
    :debug 
    :special_chars
    :nagios 
    commify dump_mock 
);

use Output 2.3.1; #me

#me
#me	 	              
#me
#me
#me
#me
#me
#me	 	              
#me

use version; our $VERSION = qv('2.3.1');


#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me	 	              
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me


sub new {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my ($class, %args) = @_;
    
    my $self = {};
    bless $self, $class;
    foreach my $metric (keys %{$args{'metrics'}}) {
        $self->_add($metric, $args{'metrics'}{"$metric"});
    }
    $self->_set_default_metric($args{'default'});
    $self->_set_allowed_prefixes();
    $self->{'_p'} = $args{'p'} || croak ('missing argument p (ref to N::P-object)');
    $self->_add_args($self->{'_p'});
    return $self;
}

#me
#me
#me

sub get_metrics {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my ($self, %args) = @_;
    
    my @metrics;
    foreach (keys %{$self->{'_metrics'}}) {
        push @metrics, $_;
    }
    my $txt;
    if (defined $args{'format'}) {
        if ($args{'format'} eq 'commified_text') {
            $txt = commify(@metrics);
        } else {
            croak 'undefined format ' . $args{'format'};
        }
        return $txt;
    } else {
        return \@metrics;
    }
    
}

sub select_metric {

#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $p    = shift || $self->{'_p'};
    


    if ($p->opts->metric) {
        my $metr_on_commandline = $p->opts->metric;

        my @ALLOWED_METRICS;
        foreach (keys %{$self->{'_metrics'}}) { push @ALLOWED_METRICS, $_};
        if (not any {/^$metr_on_commandline$/} @ALLOWED_METRICS)  {
            $p->nagios_die( 
                'Unknown metric' . " $metr_on_commandline. "
                . 'Must be one of' . $COLON . $BLANK . commify(@ALLOWED_METRICS) 
            );
        }
        
        $self->{'_selected'}{'metric'} = $p->opts->metric;
    } else {
        $self->{'_selected'}{'metric'} = $self->{'_default_metric'};
    }
    my $mtr = $self->{'_selected'}{'metric'};

    return $self;
}

sub get_selected {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $type = shift;
    #me
    my @allowed_types = qw( metric unit prefix perf_data_prefix );

    if ( not any {/^$type$/} @allowed_types ) {
        croak 'invalid type' . $BLANK . "$type" . $DOT 
        . 'Allowed types are: ' . commify(@allowed_types);
    }
    
    my $s =  $self->{'_selected'}{"$type"};
    if (defined $s) {
        return $s;
    } else {

        return $EMPTY;
    }
    croak 'FATAL197 - this line should not get executed';
}

sub set_vars {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me


    my ($self, %args) = @_;
    foreach my $var_name (keys %args) {
        $self->{'_vars'}{"$var_name"} = $args{$var_name};
    }

    return $self;
}

sub set_thresholds {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $p    = shift || $self->{'_p'};
    my $pout = shift; #me
    
    my $mtr = $self->{'_selected'}{'metric'};

    

    if ($p->opts->unit) {
        if ( not any {$p->opts->unit eq $_} @{$self->get_units("$mtr")} ) {
            $p->nagios_die('Invalid unit for this metric.' . $BLANK
                . 'Allowed units: ' . commify( @{$self->get_units("$mtr")} )
            )
        }
        else {
            $self->{'_selected'}{'unit'} = $p->opts->unit;
        }
    } else {
        $self->{'_selected'}{'unit'} = 
            $self->{'_metrics'}{"$mtr"}{'defaults'}{'unit'};
    }




    foreach my $pfx_type ('prefix', 'perf_data_prefix') {
        my $cmd_pfx = $p->opts->$pfx_type;
        if ($cmd_pfx) {
            my $pfx = $cmd_pfx;

            if ( any {/^$pfx$/} @{$self->_get_allowed_prefixes()} ) {

                if ($pfx eq 'none') {

                    $self->{'_selected'}{"$pfx_type"} = $EMPTY;
                } else {

                    $self->{'_selected'}{"$pfx_type"} = $pfx;

                }
            }
            else {
                $p->nagios_die('Invalid prefix.' . $BLANK
                    . 'Allowed prefixes:' . $BLANK 
                    . $self->_get_allowed_prefixes(format => 'commified_text') 
                )

            }
        } else {

            $self->{'_selected'}{"$pfx_type"} = 
                $self->{'_metrics'}{"$mtr"}{'defaults'}{"$pfx_type"};
        }
        
    }



    foreach my $th ('warning', 'critical')  {
        if (defined $p->opts->$th) {

            $self->_set_threshold($p->opts->$th, "$th");
        } elsif ( defined $self->{'_metrics'}{"$mtr"}{'defaults'}{"$th"} ) {

            $self->_set_threshold(
                $self->{'_metrics'}{"$mtr"}{'defaults'}{"$th"}, 
                "$th"
            );
        } else {

        }
        if (defined $self->{'_thresholds'}{"$th"}) {
            if ( not $self->{'_thresholds'}{"$th"} =~ /:$/) { #me

                if (defined $self->{'_metrics'}{"$mtr"}{'min'}) {
                    my $min = $self->{'_metrics'}{"$mtr"}{'min'};
                    if ( $self->{'_thresholds'}{"$th"} < $min ) {
                        $p->nagios_die("Threshold for $th must not be below $min.")
                    }
                }
                if (defined $self->{'_metrics'}{"$mtr"}{'max'}) {
                    my $max = $self->{'_metrics'}{"$mtr"}{'max'};
                    if ( $self->{'_thresholds'}{"$th"} > $max ) {
                        $p->nagios_die("Threshold for $th must not be over $max.")
                    }
                }
            } else {

                if (defined $pout) {

                    $pout->max_in_summary(0); #me
                }
                if (defined $p->opts->prefix) {
                    $p->nagios_die('Only normal thresholds can use SI-prefixes.')
                }
            }
        }
    }

    $p->set_thresholds(
        warning => $self->{'_thresholds'}{'warning'},
        critical => $self->{'_thresholds'}{'critical'},
    );
    return $p;
}
sub _set_threshold {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $val = shift;
    my $label = shift;
    if (! defined $val) {
        croak 'undefined value for threshold';
    }
    if (! $label =~ /warning|critical/) {
        croak 'wrong label, must be either warning or critical';
    }

    $self->{'_thresholds'}{"$label"} = $self->_parse_threshold("$val");
    return $self;
}
sub factor {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $arg = shift;
    my $prefix;
    if (defined $arg) {
        if ($arg eq 'perf_data') {
            $prefix = $self->get_selected('perf_data_prefix');

        } else {
            croak 'invalid data for arg - must be \'perf_data\' or undef';
        }
    } else {
        $prefix = $self->get_selected('prefix');
    }
    

    my $factor;
    if ( "$prefix" ne "$EMPTY" ) {
        $factor = $self->{'_allowed_prefixes'}{"$prefix"};
    } else {

        $factor = 1;
    }
    return $factor;
}


#me
#me
#me

sub _add_args {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $p = shift || croak 'undefined p (N::P-object)';
    #me
    my $ai = "$BLANK" x $NAGIOS_ARG_INDENT;  #me

    $p->add_arg(
        spec => 'metric|m=s',
        default => $self->{'_default_metric'},
        help => wrap($EMPTY, $ai, 
            q{Metric, possible metrics are: }
            . $self->get_metrics(format => 'commified_text') . "\n"
            . q{Default: } . $self->{'_default_metric'}
            ) #me
        , #me
    );
    $p->add_arg(
        spec => 'warning|w=s',
        help => wrap($EMPTY, $ai, q{warning threshold} . $BLANK
            . q{Default depends on metric: } 
            . $self->_get_defaults('warning')
            . "\n"
            . q{A colon-postfixed threshold means 'less-than'. e.g. '-c 12:' means 'critical if less than 12'.}
            . q{ Setting a less-than threshold may suppress the output of the max-summary (e.g. 'most occupied volume').}
            . q{ Other Nagios-threshold-formats are not supported yet.}
            . q{ SI-prefixes and VARs are not supported for less-than-thresholds.}
            ) #me
        , #me
    );
    $p->add_arg(
        spec => 'critical|c=s',
        help =>
        wrap($EMPTY, $ai, q{critical threshold} . $BLANK
            . q{Default depends on metric: } 
            . $self->_get_defaults('critical')
            ) #me
        , #me
    );
    $p->add_arg(
        spec => 'unit|uom=s',
        help => wrap($EMPTY, $ai, q{Unit for thresholds. }
            . q{Default depends on metric: } 
            . $self->_get_defaults('unit')
            ) #me
        , #me
    );
    $p->add_arg(
        spec => 'prefix|multiplicator|factor=s',
        #me
        help => wrap($EMPTY, $ai, q{SI-prefix for threshold-unit} . $BLANK
            . q{Default depends on metric: } 
            . $self->_get_defaults('prefix') . "\n"
            . q{Allowed prefixes are: } 
            . $self->_get_allowed_prefixes(format => 'commified_text'). "\n"
            . 'Further information about SI-prefixes ' . "\n"
            . 'Binary http://physics.nist.gov/cuu/Units/binary.html' . "\n"
            . 'Standard http://physics.nist.gov/cuu/Units/prefixes.html'. "\n"
            . 'The prefix \'none\' can be used to overide a default-set prefix'
            . ' and results in a factor of 1'
            ) #me
        , #me
    );
    $p->add_arg(
        spec => 'perf_data_prefix|perf_data_multiplicator|perf_data_factor=s',
        default => $EMPTY,
        help => wrap($EMPTY, $ai, q{SI-prefix for perfdata-unit.} . $BLANK
            . q{Default depends on metric: } 
            . $self->_get_defaults('perf_data_prefix') . "\n"
            . q{Allowed prefixes are: } 
            . $self->_get_allowed_prefixes(format => 'commified_text'). "\n"
            . 'See also --prefix' . "\n"
            . 'WARNING: The perf_data_prefix will change the value, min and max'
            . ' but *not* the warning- and critical thresholds in the perf-data!'
            . 'So using this option will result in partially inconsistent perf-data.'
            ) #me
        , #me
    );

    return $self;
}

sub _set_default_metric {

#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $default = shift;
    croak 'no default-metric defined' if not defined $default;
    foreach my $metric (keys %{$self->{'_metrics'}}) {
        if ("$metric" eq "$default") {
            $self->{'_default_metric'} = $default;
            return $self;
        }
    }
    croak "default-metric $default is none of the registered metrics " 
        . $self->get_metrics(format => 'comifified_text');
    ;  
}

sub _parse_threshold {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $th_string = shift;
    if (not defined $th_string) {
        croak 'missing argument for threshold-string'
    };
    my $p = $self->{'_p'};
    if ( $th_string =~ m{
            ^=     #me
            (.+)    #me
            }x ) {
        $th_string = $1;    #me


        #me
        foreach my $var_name1 ( keys %{$self->{'_vars'}} ) {
            foreach my $var_name2 ( keys %{$self->{'_vars'}} ) {
                if ($var_name1 =~ /$var_name2/ and $var_name1 ne $var_name2) {
                    croak 'These var-names exculude each other. Choose names which are not part of an other var: '
                        . "$var_name1 <-x-> $var_name2";
                }
            }
        }

        foreach my $var_name ( keys %{$self->{'_vars'}} ) {
            $th_string =~ s/$var_name/${$self->{'_vars'}}{$var_name}/g;
        }
        my $th_val = eval $th_string; #me
        if (not defined $th_val) {
            $p->nagios_die(qq{The threshold-formula '$th_string' evalues to nothing.})
        }

        return $th_val;
    } elsif ($th_string =~ /^(\d+(\.\d+)?(e\d+)?)$/ #me
            ) {   

        return $th_string * $self->factor();
    } elsif ($th_string =~ /^(\d+(\.\d+)?(e\d+)?):?$/ #me
            ) {   

        return $th_string;
    } else {
        $p->nagios_die('Threshold is neither formula nor number nor a nagios-threshold - can not continue.'
            . q{ Formulas must start with a '=', f.e. '-w =MAX/100*80'}
        
        );
    }
}

sub _get_allowed_prefixes {

#me
#me
#me
#me
#me
#me
#me
#me

    my ($self, %args) = @_;
    my @allowed_prefixes;
    croak 'no prefixes set' if not defined $self->{'_allowed_prefixes'};
    foreach (sort keys %{$self->{'_allowed_prefixes'}}) {
        push @allowed_prefixes, $_;
    }
    my $text;
    if (defined $args{'format'}) {
        if ($args{'format'} eq 'commified_text') {
            $text = commify(@allowed_prefixes);
        } else {
            croak 'undefined format ' . $args{'format'};
        }
        return $text;
    } else {
        return \@allowed_prefixes;
    }
}

sub _add {
    my $self     = shift;
    my $metric   = shift || croak('undefined metric');
    my $prop_ref = shift || croak('missing properties for metric ' . $metric);
    $self->{'_metrics'}{"$metric"} = $prop_ref;
    return $metric;
}

#me
#me
#me
#me
#       :               join( ", ", @_[ 0 .. ($#_) ] );
#me

sub _get_defaults {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $type = shift; #me
    my @allowed_types = qw( unit warning critical prefix perf_data_prefix);

    if ( not any {/^$type$/} @allowed_types ) {
        croak 'invalid type' . $BLANK . "$type" . $DOT 
        . 'Allowed types are: ' . commify(@allowed_types);
    }
    
    my $txt;
    my $n = 0;
    debug(3, 'Dump of $self->{_metrics}' . "\n" 
        . Dumper($self->{'_metrics'}));

    foreach my $metr ( keys %{$self->{'_metrics'}} ) {

        $txt .= q{,} . $BLANK if $n++; #me
        $txt .= "$metr" . '(';
        if (not defined $self->{'_metrics'}{"$metr"}{'defaults'}{"$type"}) {
            $txt .= 'no default'
        } else {
            $txt .= $self->{'_metrics'}{"$metr"}{'defaults'}{"$type"};
        };
        $txt .= ')';
    }

    return $txt;
}
sub get_units {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $self = shift;
    my $metric = shift || croak('Need to know the metric!');

    return $self->{'_metrics'}{"$metric"}{'units'}; 
}

sub _set_allowed_prefixes {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
    
    my $self = shift;
    $self->{'_allowed_prefixes'} = {
        'none' => 1, #me
                     #me
                     #me
                     #me
                     #me
                     #me
        
        ki => 2**10,
        Mi => (2**10)**2,
        Gi => (2**10)**3,
        Ti => (2**10)**4,
        Pi => (2**10)**5,
        Ei => (2**10)**6,
        
        k  => 10**3,
        M  => 10**6,
        G  => 10**9,
        T  => 10**12,
        P  => 10**15,
        E  => 10**18,
    };
}

sub format_perf_data {

#me
#me
#me
#me
#me

    my $self = shift;
    my $val = shift;
    debug(1, 'Got $val: ' . $val);
    if (not defined $val) { croak 'missing value'};
    my $perf_dp = $self->{'_perf_dp'};
    my $rounded_factored_val = sprintf ( 
        "%.${perf_dp}f", 
        $val / $self->factor('perf_data')
    );
    return $rounded_factored_val;
}

sub set_perf_dp {

#me
#me
#me
#me
#me

    my $self = shift;
    my $dp = shift;
    if (not defined $dp) { croak 'digital precison value'};
    if ($dp =~ /[0-9+]/) {
        if ($dp < 0) {croak 'must be a positive value'};
        $self->{'_perf_dp'} = $dp;
    } else {
        croak 'must be a number'
    }
    
}

1;
__END__

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

