#!/usr/bin/perl
use strict;
use DBI;
use DBD::mysql;
use Getopt::Std;

my %opts;
getopts ":-u:-h:-p:",\%opts;

if (!defined $opts{'h'}) {
	print &usage;
	exit 3;
} elsif (!defined $opts{'u'}) {
	print &usage;
	exit 3;
}

sub usage () {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
}

my $driver = "mysql";
my $dsn = "DBI:$driver:database=;hostname=$opts{'h'}";
my $dbh = DBI->connect($dsn,$opts{'u'},"$opts{'p'}");

unless (defined $dbh) {
	print "Can't connect to mysql Server: $@\n";
	exit 2;
}

my $sth = $dbh->prepare("show master status");
$sth->execute();

my $file = "";
my $pos = "";

while (my @arg = $sth->fetchrow_array()) {
	$file = $arg[0];
	$pos = $arg[1];
}

$sth->finish();
$dbh->disconnect();

if (!defined $file or $file eq "") {
	print "Der Masterprozess laeuft nicht mehr !!!\n";
	exit 2;
} elsif (!defined $pos or $pos eq "") {
	print "Der Masterprozess laeuft nicht mehr !!!\n";
} else {
	print "Der Master laeuft\n";
	exit 0;
}
