#!/usr/bin/perl -w
package noris::Date::Calendar::Profiles;

use strict;
# kein UTF-8 - Datei latin1 codiert lassen
# da die originallen Profile auf lati1 sind und Perl beim den HashKeys
# sonst durcheinander kommt
#use utf8;
use vars qw( @ISA @EXPORT @EXPORT_OK $VERSION $Profiles );

require Exporter;
@ISA       = qw(Exporter);
@EXPORT    = qw();
@EXPORT_OK = qw( $Profiles );
$VERSION   = '0.2';

use Date::Calendar::Profiles;    # depends: libdate-calc-perl
$Profiles = $Date::Calendar::Profiles::Profiles;
$Profiles->{'DE-BY-noris'} = {    # noris Kalender
    %{ $Profiles->{'DE-BY'} },    # Bayern
    "Nikolaus"          => "#06.12.",
    "Heiligabend"       => ":24.12.",
    "Sylvester"         => ":31.12.",
    "Mari Himmelfahrt" => "#15.08.",
};

1;

__END__

=head1 NAME

noris::Date::Calendar::Profiles - Noris Kalender

=head1 SYNOPSE

 use noris::Date::Calendar::Profiles;
 my $prof = $noris::Date::Calendar::Profiles::Profiles->{'DE-BY-noris'};

=head1 BESCHREIBUNG

Nachdem das offiziele Paket bestimmte Feiertage bzw. halbe Tage nicht als
solche wertet, haben wir unseren eigenen Kalender erzeugt. Dieser behebt
die "Fehler" des Original Pakets

=head1 RCKGABEWERT

Hashref $Profiles mit den Feiertagen wird exportiert.

=head1 AUTOR

 Stelios Gikas <entwicklung@noris.net>
 Stelios Gikas <10083446@ticket.noris.net>
