
SuspendAllVMs()
{

echo "Suspending all running VMs on the VMWare ESX server $HOST:"
echo "=================================="

#First we prepare the list of running VMs which should be resumed later in the postexec script.
if [ -s $LIST_RUNNING_VMS_TO_SUSPEND ]; then
    rm $LIST_RUNNING_VMS_TO_SUSPEND
fi

#Now, we identify all the running VMs and suspend them.
for VMS in `vmware-cmd -l` ; do
   running=`vmware-cmd $VMS getstate | awk '{print $3}'`
   echo
   echo "VM $VMS is in <$running> state"
   if [ "$running" = "on" ]; then
       echo "Let's suspend the VM $VMS"
   else
       echo "No need to suspend the VM $VMS"
   fi
   if [ "$running" = "on" ] ; then
      #If a VM is running then we put it in the list of running VMs and suspend it.
      echo "${VMS}" >> $LIST_RUNNING_VMS_TO_SUSPEND 2> /dev/null
      /usr/bin/vmware-cmd $VMS suspend hard
      sleep 1
      echo "VM $VMS suspended"
   fi
done
echo
echo "=================================="
echo
}




SuspendSelectedVMs()
{

echo "Suspending the selected VMs on the VMWare ESX server $HOST:"
echo "=================================="
for VMS_SELECTED in $VMS_TO_SUSPEND
do
echo ${VMS_SELECTED}
done
echo "=================================="

#First we prepare the list of running VMs which should be resumed later in the postexec script.
if [ -s $LIST_RUNNING_VMS_TO_SUSPEND ]; then
    rm $LIST_RUNNING_VMS_TO_SUSPEND
fi

#Now, we identify all the running VMs and suspend them.
for VMS in `vmware-cmd -l` ; do
   running=`vmware-cmd $VMS getstate | awk '{print $3}'`
   for VMS_SELECTED in $VMS_TO_SUSPEND
   do
      if [ "${VMS}" = "${VMS_SELECTED}" ]; then
         echo
         echo "VM $VMS is in <$running> state"
         if [ "$running" = "on" ]; then
             echo "Let's suspend the VM $VMS"
         else
             echo "No need to suspend the VM $VMS"
         fi
      fi
      if [ "$running" = "on" ] && \
         [ "${VMS}" = "${VMS_SELECTED}" ]; then
         #If a VM is running then we put it in the list of running VMs and suspend it.
         echo "${VMS}" >> $LIST_RUNNING_VMS_TO_SUSPEND 2> /dev/null
         /usr/bin/vmware-cmd $VMS suspend hard
         sleep 1
         echo "VM $VMS suspended"
      fi
   done
done
echo
echo "=================================="
echo
}


PutInHotAllVMs()
{

echo "Putting in hot mode all running VMs on the VMWare ESX server $HOST:"
echo "=================================="

if [ -s $LIST_RUNNING_VMS_TO_PUT_IN_HOT ]; then
    rm $LIST_RUNNING_VMS_TO_PUT_IN_HOT
fi

#Now, we identify all the running VMs and call the DPvmware_addredo.pl script which puts them in the hot mode.
for VMS in `vmware-cmd -l` ; do
   running=`vmware-cmd $VMS getstate | awk '{print $3}'`
   echo
   echo "VM $VMS is in <$running> state"
   if [ "$running" = "on" ]; then
       echo "Let's put the VM $VMS in hot mode"
   else
       echo "No need to put the VM $VMS in hot mode"
   fi
   if [ "$running" = "on" ] ; then
      #If a VM is running then we put it in the hot mode.
      $SCRIPT_DIR/DPvmware_addredo.pl $VMS
      RETURN_VALUE=$?
      if [ $RETURN_VALUE -ne 0 ]; then
              echo " DPvmware_addredo.pl Script failed. Not proceeding with the DP session."
              #QXCM1000358754 - exiting with status = 1
	      exit 1;
      fi 
      sleep 1
      echo "VM $VMS is now in hot mode"
   fi
done
echo
echo "=================================="
echo
}


PutInHotSelectedVMs()
{

echo "Putting in hot mode the selected running VMs on the VMWare ESX server $HOST:"
echo "=================================="
for VMS_SELECTED in $VMS_IN_HOT_MODE
do
echo ${VMS_SELECTED}
done
echo "=================================="

if [ -s $LIST_RUNNING_VMS_TO_PUT_IN_HOT ]; then
    rm $LIST_RUNNING_VMS_TO_PUT_IN_HOT
fi

#Now, we identify all the running VMs and call the DPvmware_addredo.pl script which puts them in the hot mode.
for VMS in `vmware-cmd -l` ; do
   running=`vmware-cmd $VMS getstate | awk '{print $3}'`
   for VMS_SELECTED in $VMS_IN_HOT_MODE
   do
      if [ "${VMS}" = "${VMS_SELECTED}" ]; then
         echo
         echo "VM $VMS is in <$running> state"
         if [ "$running" = "on" ]; then
             echo "Let's put the VM $VMS in hot mode"
         else
             echo "No need to put the VM $VMS in hot mode"
         fi
      fi
      if [ "$running" = "on" ] && \
         [ "${VMS}" = "${VMS_SELECTED}" ]; then
         #If a VM is running then we put it in the hot mode.
         $SCRIPT_DIR/DPvmware_addredo.pl $VMS
         if [ $RETURN_VALUE -ne 0 ]; then
              echo " DPvmware_addredo.pl Script failed. Not proceeding with the DP session."
              #QXCM1000358754 - exiting with status = 1 
	      exit 1;
         fi
         sleep 1
         echo "VM $VMS is now in hot mode."
      fi
   done
done
echo
echo "=================================="
echo
}


SCRIPT_DIR=/opt/omni/bin
HOST=`/bin/hostname`
LIST_RUNNING_VMS_TO_SUSPEND="/tmp/list_running_vms_to_suspend.tmp"
LIST_RUNNING_VMS_TO_PUT_IN_HOT="/tmp/list_running_vms_to_put_in_hot.tmp"

. ${SCRIPT_DIR}/DPvmware_config.sh



if  [ "${SUSPEND_ALL_VMS}" = "YES" ]; then
    SuspendAllVMs
else
    if [ -n "$VMS_TO_SUSPEND" ]; then
    SuspendSelectedVMs
    else
    echo "No VMs to suspend entered in the DPvmware_config.sh file"
    fi
fi


if  [ "${PUT_ALL_VMS_IN_HOT_MODE}" = "YES" ]; then
    PutInHotAllVMs
else
    if [ -n "$VMS_IN_HOT_MODE" ]; then
    PutInHotSelectedVMs
    else
    echo "No VMs to put in hot mode entered in the DPvmware_config.sh file"
    fi
fi


