package Omniback;

# (c) Copyright Hewlett-Packard Company 2006, all rights reserved














































use English;
use strict;
use Symbol;

my $BUILD_WHAT = "@(#) HP OpenView Storage Data Protector A.06.00; internal build 331, built on Tue Jul  4 06:39:07 2006";


my $filename = __FILE__;
our $RCS = { $filename => {
	source   => '$Source: /src/integ/perl/Omniback.pm $',
	revision => '$Revision: /main/dp56/81 $',
	header   => '$Header: /src/integ/perl/Omniback.pm /main/dp56/81 2006-05-31 11:49:48 markolj $',
} };


our %PAN = ();



sub DbgPlain;
sub DbgStamp;
sub DbgLog;
sub DbgFcnIn;
sub DbgFcnOut;
sub ErhThrow;
sub NlsGetMessage;
sub CmnHostName;
sub CmnRegOpen;


our %info = (
	USERNAME   => undef,
	GROUPNAME  => undef,
	HOSTNAME   => undef,
	PROGNAME   => undef,
	BUILD_VERSION => 'A.06.00',
	BUILD_NUMBER  => '331',
);


our %PROG = (
	UTILCMD     => undef,
	OMNIGETMSG  => undef,
	OMNIRESOLVE => undef,
	OB2SMBSPLIT => undef,
	DMA         => undef,
	TESTBAR     => undef,
);


use constant {
	DEBUG_CIRCULAR_DEFAULT => 1024*1024,
	DEBUG_CIRCULAR_MINIMUM => 4*1024,
	DEBUG_CIRCULAR_FACTOR  => 4,
	DEBUG_STACK_SIZE       => 99,
	DEBUG_AUTOFLUSH        => 1,


	DEBUG_ENCODING         => 'ucs2le',


	OB2ERROR               => 1,
	APPERROR               => 2,
	OSERROR                => 4,
	CHILDERROR             => 8,


	NLS_SET_ERRNO          => 12,


	DBG_ALWAYS             => -1,
	DBG_UNEXPECTED         => -2,
	DBG_MAIN_ACTION        => 30,
	DBG_DETAIL_PROGTRACE   => 199,


	ERH_NO_HEADER  => -1,
	ERH_WARNING    =>  0,
	ERH_MINOR      =>  1,
	ERH_MAJOR      =>  2,
	ERH_CRITICAL   =>  3,
	ERH_NORMAL     =>  4,


	REG_KEY_READ   =>  0x20019,


	REG_KEY_WOW64_64KEY => 0x0100,
};



BEGIN
{
	use Exporter ();
	our @ISA = qw(Exporter);
	our @EXPORT = qw(
		DBG_MAIN_ACTION DBG_DETAIL_PROGTRACE
		OB2ERROR OSERROR APPERROR CHILDERROR
		ERH_NO_HEADER ERH_WARNING ERH_MINOR ERH_MAJOR ERH_CRITICAL ERH_NORMAL
		ErhThrow ErhCatch ErhConsoleReport ErhClear ErhAgentReport ErhPeek ErhWas ErhBegin ErhEnd
		DbgInit DbgPlain DbgFcnIn DbgFcnOut DbgStamp DbgExit DbgDump
		%PAN %PROG $RCS
		NlsGetMessage NLS_SET_ERRNO
		CmnQuotePath CmnCleanPath CmnUnpackPath CmnTempFileName CmnRegOpen
		StrFromUserSessionId StrToUserSessionId
		REG_KEY_READ REG_KEY_WOW64_64KEY);
}


INIT
{
	$info{PROGNAME} = uc(CmnUnpackPath($PROGRAM_NAME)->{barename});


	$ENV{OB2PROGRAMNAME} = lc($info{PROGNAME});



	$PAN{DBG} = $PAN{LOG} = $ENV{TEMP} || $ENV{TMP};

































	$PAN{BASE} = q(/opt/omni);
	$PAN{BIN}  = q(/opt/omni/bin);
	$PAN{LBIN} = q(/opt/omni/lbin);
	$PAN{LIBPERL} = qq($PAN{BASE}/lib/perl);
	$PAN{LIB}  = q(/opt/omni/lib);
	$PAN{TMP}  = q(/var/opt/omni/tmp);
	$PAN{DBG}  = q(/tmp);
	$PAN{LOG}  = q(/var/opt/omni/log);











	$info{USERNAME}  = ( getpwuid($EFFECTIVE_USER_ID ) )[0];
	$info{GROUPNAME} = ( getgrgid($EFFECTIVE_GROUP_ID) )[0];
	$info{HOSTNAME}  = CmnHostName;











	$PROG{UTILCMD}     = qq(${PAN{LBIN}}/util_cmd);
	$PROG{OMNIGETMSG}  = qq(${PAN{LBIN}}/omnigetmsg);
	$PROG{OMNIRESOLVE} = qq(${PAN{LBIN}}/omniresolve);
	$PROG{OB2SMBSPLIT} = qq(${PAN{LBIN}}/ob2smbsplit);
	$PROG{DMA}         = qq(${PAN{LBIN}}/dma);
	$PROG{TESTBAR}     = qq(${PAN{BIN}}/testbar);


	return 1;
}








my $cmnHostname;
sub CmnHostName
{

	return $cmnHostname if $cmnHostname;




	my $host = qx(hostname);
	chomp $host;

	
	my ($name,$alias) = gethostbyname ($host);
	$name =~ m{\..+} or do {
		($alias) = grep /^$name\..+/i, split /\s+/, $alias;
		$name = $alias if $alias;
	};

	return $cmnHostname = $name;
}


sub CmnQuotePath ($)
{



	return qq("$_[0]");

}


sub CmnCleanPath ($)
{
	my $path = shift;
	$path =~ s|\\+|/|g;
	$path =~ s|/$||;
	return $path;
}


sub CmnUnpackPath ($)
{
	my $path = shift;

	my $p = {};





	$path =~ s|\\|/|g;
	$p->{basename} = $1 if $path =~ s|([^/]+)$||;
	$p->{dirname}  = $path;
	($p->{barename}, $p->{extname}) = $p->{basename} =~ m|(^[^\.]+)\.+(.*)$|;


	$p->{absolute} = $path =~ m|^/|;


	return $p;
}


sub CmnTempFileName
{
	my ($prefix, $postfix) = @_;
	my $rnd = sprintf ("%04x", int(rand(0xFFFF)));
	return qq($PAN{TMP}/ob2.$prefix.${PROCESS_ID}.$rnd.$postfix);
}


sub CmnRegOpen ($$;$)
{
	my ($hive, $keyname, $param) = @_;
	$param = ref $param eq 'HASH'? $param : {};
	my $key32 = $hive->Open($keyname);
	my $key64 = $hive->Open($keyname, {Access=>REG_KEY_READ|REG_KEY_WOW64_64KEY});
	
	my $key = 
		$param->{type} == 32? $key32 : 
		$param->{type} == 64? $key64 :
		$ENV{PROCESSOR_ARCHITEW6432} eq "IA64"? $key64 : 
		($key32 || $key64);

	$key or do {
			ErhThrow OSERROR, "Can not open registry key '$keyname'";
	};
	
	return $key;
}


sub CmnFileOpen ($;$)
{
	my ($mode, $file) = @_;
	my $fd;
	if ( ! defined($file) ) { ( $mode, $file ) = ( $_[0] =~ m|(\+?[<>]{1,2})\s*(.+)| ) }
	$mode =~ s/(\+?[<>]{1,2}).*$/$1 :raw/;
	open $fd, "$mode", "$file" or return undef;











	binmode $fd, ':utf8';

	return $fd;
}


sub StrFromUserSessionId ($)
{
	my $sessId = shift;
	my ($date, $count) = ( $sessId =~ m|(\d+/\d+/\d+)-(\d+)| );
	return sprintf("%s %04s", $date, $count);
}


sub StrToUserSessionId ($)
{
	my $str = shift;
	my ($date, $count) = ( $str =~ m|(\d+/\d+/\d+)\s+(\d+)| );
	return sprintf("%s-%d", $date, $count);
}




sub HashMatch ($$)
{
	my ($a,$b) = @_;

	return undef unless ref $a eq 'HASH' && ref $b eq 'HASH';
	my %b; $b{+uc($_)} = $b->{$_} foreach keys %$b;

	foreach (keys %$a) {
		return undef unless $a->{$_} eq $b{+uc($_)};
	};
	return 1;
}



sub Hashify ($)
{
	my $list = shift;
	my $hash = {};
	return $hash unless $list;
	for (my $i=0; $i <= $#$list; ++$i)
	{
		$hash->{$list->[$i]} = $i;
	}
	return $hash;
}







sub array_last($)
{
	my $a = shift;
	return undef unless ref $a eq 'ARRAY';
	my $len = scalar(@$a);
	return $len? $a->[$len-1] : undef;
}



my $erhContext = [];
my $erhStack   = [];
my $erhThrowDisabled = 0;








sub ErhBegin ()
{
	push @$erhContext, $erhStack;
	return $erhStack = [];
}


sub ErhEnd ()
{
	my $stack = pop @$erhContext or return $erhStack;
	push @$stack, @$erhStack;
	return $erhStack = $stack;
}




















sub ErhGetExceptionStack ()
{
	return $erhStack;
}


sub ErhDump ($$)
{
	my ($level, $rpt) = @_;
	ref $rpt eq 'HASH' or return;
	DbgPlain $level, "Exception dump:", DbgDump($rpt), "\n";
	1;
}


sub ErhThrow ($;@)
{
	return if $erhThrowDisabled;
	$erhThrowDisabled = 1;

	my $type = shift;
	my $function = (caller (1))[3] || 'main';
	my ($package, $filename, $line) = caller (0);
	my $report = {
		PACKAGE   => $package,
		FUNCTION  => $function,
		TYPE      => $type,
		LINE      => $line,
	};

	if ($type == OSERROR)
	{
		$report->{ERRNO}                  = int($OS_ERROR) || $?;
		$report->{ERRSTR}                 = $OS_ERROR;
		$report->{EXTENDED_OS_ERROR}      = int($EXTENDED_OS_ERROR);
		$report->{EXTENDED_OS_ERROR_TEXT} = $EXTENDED_OS_ERROR;
	}
	elsif ($type == CHILDERROR)
	{
		$report->{EXITCODE} = $CHILD_ERROR>>8;
		$report->{SIGNAL}   = $CHILD_ERROR & 127;
	}
	elsif ($type == OB2ERROR)
	{
		my ($msgset, $msgnum) = split(/:/, shift);
		$msgnum or do {
			$msgnum = $msgset;
			$msgset = NLS_SET_ERRNO;
		};
		$report->{ERRNO}  = $msgnum;
		$report->{ERRSET} = $msgset;


		$report->{ERRSTR} = NlsGetMessage($msgset, $msgnum);
	}

	my @args  = grep {$_ and !ref} @_;
	my %merge = map %$_, grep {ref eq 'HASH'} @_;
	$report = { %$report, %merge };
	$report->{INFO} = \@args;


	ErhDump DBG_MAIN_ACTION, $report;
	push @$erhStack, $report;


	$erhThrowDisabled = 0;
	return $report;
}












sub ErhCatch
{
	my %filter = @_;
	if (wantarray)
	{
		my (@catch, @stack);
		foreach (@$erhStack)
		{
			HashMatch(\%filter,$_)? push @catch, $_ : push @stack, $_;
		}
		$erhStack = \@stack;
		return @catch;
	}
	return HashMatch(\%filter, array_last($erhStack))?
		pop @$erhStack :
		undef;
}



sub ErhPeek
{
	my %filter = @_;
	return 
		wantarray? grep { HashMatch (\%filter, $_) } @$erhStack :
		HashMatch(\%filter, array_last($erhStack)) ? array_last($erhStack) :
		undef;
}


sub ErhClear
{
	my %filter = @_;
	$erhStack = [ grep { !HashMatch(\%filter, $_) } @$erhStack ];
}


sub ErhFullReport ($;@)
{
	my $level = shift;
	my $args = join "", @_;
	my $msg = NlsGetMessage("-report $level \"$args\"");
	$msg =~ s|^\t+||gm;
	$msg =~ s|\n+$||;
	$msg =~ s|\n|\n\t|g;
	print STDOUT $msg, "\n\n";
}


sub ErhWas ()
{
	return scalar (@$erhStack);
}












sub ErhConsoleReport (;$)
{
	my $retval = shift;
	defined $retval and do {
		print "*RETVAL*$retval\n";
		$retval = 1;
	};
	while (my $rpt=ErhCatch())
	{
		$rpt->{TYPE} eq OB2ERROR and do {
			chomp $rpt->{ERRSTR};
			$retval? 
				printf "OB2ERR:%d %s\n", $rpt->{ERRNO}, $rpt->{ERRSTR} :
				printf "*RETVAL*%d\n",   $rpt->{ERRNO};
		};

		$rpt->{TYPE} eq OSERROR and do {
			$retval? 
				printf "OSERROR:%d %s\n",  $rpt->{ERRNO}, $rpt->{ERRSTR} :
				printf "*RETVAL*%d\n(%d) %s\n", 1026, $rpt->{ERRNO}, $rpt->{ERRSTR};
		};

		$rpt->{TYPE} eq CHILDERROR and do {
			$retval?
				printf "CHILDERROR:%d\n", $rpt->{EXITCODE} :
				printf "*RETVAL*%d\n", 1026;
			printf "Process exit code: %d, Signal: %d\n", $rpt->{EXITCODE}, $rpt->{SIGNAL};
		};

		$rpt->{TYPE} eq APPERROR and do {
			$retval?
				printf "APPERROR:\n" :
				printf "*RETVAL*%d\n", 8100;
		};
		
		my @info = @{ $rpt->{INFO} };
		@info and do {
			chomp foreach @info;
			printf "%s\n", join "\n", @info;
		};
		printf "\n";
		$retval = 1;
	}
	printf "*RETVAL*0\n" unless $retval;
}



sub ErhAgentReport ($)
{
	my $level = shift;
	while (my $rpt=ErhCatch())
	{
		ErhDump DBG_DETAIL_PROGTRACE, $rpt;

		$rpt->{TYPE} eq OB2ERROR and do {
			ErhFullReport $level, $rpt->{ERRSTR};
		};

		$rpt->{TYPE} eq OSERROR and do {
			ErhFullReport $level, NlsGetMessage(NLS_SET_ERRNO, 1026), "\n", $rpt->{ERRSTR};
		};

		$rpt->{TYPE} eq CHILDERROR and do {
			my $info = join "\n\t", @{$rpt->{INFO}}, qq(Exit code: $rpt->{EXITCODE}, Signal: $rpt->{SIGNAL});

			ErhFullReport $level, NlsGetMessage(NLS_SET_ERRNO, 8100), "\n", $info;
		};

		$rpt->{TYPE} eq APPERROR and do {
			my $info = join ("\n", @{$rpt->{INFO}});
			ErhFullReport $level, NlsGetMessage(NLS_SET_ERRNO, 8100), "\n", $info;
		};
	}
}









my %debug = (
	RANGES  => [],
	STACK   => [],
	SESSION => "",
	FILENAME => "",
);

sub RcsUnpack ($)
{
	$_[0] =~ m|^\$[^:]+:\s*([^\$\s]+)\s*\$$|;
	return $1;
}

sub DbgMatch ($)
{
	my $level = shift;
	return $level<0? 1 : vec($debug{RANGELIST}, $level, 1);
}

sub DbgDump ($)
{
	sub D ($$$)
	{
		my ($x, $level, $r) = @_;
		my $ref = ref $x;
		my $tab = "   ";
		my $ident = $tab x $level;

		$ref eq 'ARRAY' and do {
			$$r .= "[\n";
			foreach (@$x) { $$r .= "$ident$tab"; D($_,$level+1,$r); $$r .= ",\n"; }
			$$r .= "$ident]";
			return;
		};

		$ref eq 'HASH' and do {
			$$r .= "{\n";
			foreach (keys %$x) { $$r .= "$ident$tab$_ => "; D ($x->{$_}, $level+1, $r); $$r .= ",\n"; }
			$$r .= "$ident}";
			return;
		};

		$ref eq 'REF' and do {
			$$r .= '\\';
			D ($$x, $level, $r);
			return;
		};

		$$r .= $x;
		return;
	}
	my $r = '';
	D ($_[0], 0, \$r);
	return "$r\n";
}


sub DbgDumpEnv
{





	return DbgDump \%ENV;

}



















sub DbgUnpackRanges ()
{
	my @elems  = split(/[\s,]+/, $debug{RANGES});
	foreach my $elem (@elems)
	{
		my ($keyword, $value) = ($elem =~ m|(\w+):(.*)|);
		if (!$keyword)
		{
			my ($left, $right) = split (/-+/, $elem);
			$right = $left  if $left  && not defined $right;
			$left  = $right if $right && not defined $left;
			$left  = 0 if $left<0;
			$right = 0 if $right<0;
			vec($debug{RANGELIST}, $_, 1)=1 foreach ($left ... $right);
		}
		elsif ( grep (/^$keyword$/i, qw(ID SESSION C T U)) )
		{
			$debug{$keyword} = $value;
		}
	}


	$debug{ID} ||= $PROCESS_ID;
	$debug{SESSION} =~ s|[/\\]|-|g;
	if (exists $debug{C})
	{
		my $size = int($debug{C}) * 1024;
		$size = DEBUG_CIRCULAR_DEFAULT if $size == 0;
		$size = DEBUG_CIRCULAR_MINIMUM if $size < DEBUG_CIRCULAR_MINIMUM;
		$debug{C} = $size;
	}
}


sub DbgUnpackString ($)
{
	my @all = split /\s+/, $_[0];
	shift @all if $all[0] =~ m/^-debug/i;
	return @all;
}


sub DbgDumpHeader ()
{
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"==================================================================",
		"\n",
		"  DEBUGGING STARTED\n",
		"     PROGNAME: ${info{PROGNAME}}\n",
		"     VERSION:  ${info{BUILD_VERSION}} Build ${info{BUILD_NUMBER}}\n",
		"     RANGES:   ${debug{RANGES}}\n",
		"     SELECT:   ${debug{SELECT}}\n",
		"     FILE:     ${debug{FILENAME}}\n",
		"     PID:      ${PROCESS_ID}\n",
		"     USER:     ${info{USERNAME}}\n",
		"     GROUP:    ${info{GROUPNAME}}\n",
		"     PROGRAM:  ${info{PROGNAME}}\n",
		"     MACHINE:  OS $^O. Perl $]. Debugging flags: $PERLDB. Unicode: ${^UNICODE}\n",
		"\n",
		"==================================================================\n\n";
}


sub DbgCircularCheck()
{
	return unless exists $debug{C} and (tell $debug{FILE} > $debug{C});
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"==================================================================\n",
		"  *** CIRCULAR DEBUG TRACE END MARKER ***\n",
		"  \n",
		"  Debug output continues at \"CIRCULAR DEBUG TRACE START MARKER\"\n",
		"  End of trace is in the middle of the file and is marked by the\n",
		"  \"DEBUGGING ENDED PROPERLY\" banner, unless the process\n",
		"  terminated unexpectedly.\n",
		"==================================================================\n";

	truncate { $debug{FILE} }, 0;
	seek $debug{FILE}, $debug{C}/DEBUG_CIRCULAR_FACTOR, 0;

	DbgPlain DBG_ALWAYS, "...\n\n...\n\n...\n\n...\n";
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"==================================================================\n",
		"  *** CIRCULAR DEBUG TRACE START MARKER ***\n",
		"  \n",
		"  Some debug output has already been overwritten. Output just\n",
		"  prior to the output that follows can be found at the end of the\n",
		"  file. End of trace is in the middle of the file and can be found\n",
		"  by searching for the banner or by checking the time stamps.\n",
		"==================================================================\n";
}


sub DbgInit
{
	my ($ranges, $postfix, $select) = @_;


	($ranges, $postfix, $select) = DbgUnpackString($ENV{OB2DBG})  unless $ranges;
	($ranges, $postfix, $select) = DbgUnpackString($ENV{OB2OPTS}) unless $ranges;


	$ENV{OB2OPTS} = qq(-debug $ranges $postfix $select) if ( $ranges );


	$debug{RANGES} = $ranges;
	DbgUnpackRanges();


	return 1 if exists $debug{FILE};


	return 1 unless $ranges;


	my $path = CmnUnpackPath ($postfix);
	my $debugDir = $path->{dirname} if $path->{absolute};
	$debugDir ||= $ENV{OB2DBGDIR} || $PAN{DBG};

	$debug{POSTFIX} = $path->{basename};
	$debug{SELECT}  = $select;


	my $program = $info{PROGNAME};
	my $host    = $info{HOSTNAME};
	return 1 if $select and not grep (/$program(\@$host)?/i, split (/[\s,]/, $select));

	if ($debug{POSTFIX})
	{









		$debug{FILENAME} = sprintf ("%s/OB2DBG_%s_%s_%s_%s_%d_%s",
			$debugDir,
			$debug{ID},
			$debug{SESSION},
			$info{PROGNAME},
			$info{HOSTNAME},
			$PROCESS_ID,
			$debug{POSTFIX}
		);

		open $debug{FILE}, '> :raw', $debug{FILENAME} or do {
			ErhThrow OSERROR, qq(Unable to open file '$debug{FILENAME}');
			return;
		};
	}
	else
	{
		$debug{FILE}     = *STDERR;
		$debug{FILENAME} = '<stderr>';
	}

	my $fd = $debug{FILE};


	if (DEBUG_AUTOFLUSH)
	{
		my $oldfd = select($fd); $| = 1; select($oldfd);
	}


	if (exists $debug{U})
	{
		print   $fd  "\x{FF}\x{FE}";
		binmode $fd, sprintf (":encoding(%s)", DEBUG_ENCODING);
	}
	else
	{
		binmode $fd, ':utf8';
	}


	DbgDumpHeader();


	DbgPlain DBG_MAIN_ACTION, '%ENV = ', DbgDumpEnv;


	DbgPlain DBG_MAIN_ACTION, '@ARGV = ', DbgDump(\@ARGV);


	DbgPlain DBG_MAIN_ACTION, 'Exceptions = ', DbgDump(ErhGetExceptionStack());

	1;
}


sub DbgTime
{
	my ($sec,$min,$hour,$mday,$mon,$year) = localtime(time);
	return sprintf "%04d-%02d-%02d %02d:%02d:%02d",
		$year+1900, $mon+1, $mday, $hour, $min, $sec;
}





sub DbgLog (@)
{

	my $logfile = qq($PAN{LOG}/debug.log);
	my $fd;
	open $fd, ">>$logfile" and do {
		my ($package, $file, $line) = caller (0);
		printf $fd "%s %s.%d ('%s %s':%d) %s b%s\n",
			DbgTime(),
			$info{PROGNAME},
			$PROCESS_ID,
			RcsUnpack ($RCS->{$file}->{source}),
			RcsUnpack ($RCS->{$file}->{revision}),
			$line,
			$info{BUILD_VERSION},
			$info{BUILD_NUMBER};
		print $fd @_, "\n";
	};
	close $fd;
}

sub DbgPlain ($;@)
{
	my $level = shift;
	my $fd = $debug{FILE};
	local $\;
	local $,;

	return unless $debug{FILE};
	return unless DbgMatch ($level);

	DbgLog(@_)                    if $level == DBG_UNEXPECTED;
	DbgCircularCheck()            if $level > 0;
	printf ($fd "[%3d] ", $level) if $level != DBG_ALWAYS;
	print  $fd @_, "\n";
	1;
}


sub DbgStamp ($)
{
	my $level = shift;
	my ($package, $file, $line) = caller;
	DbgPlain ($level, sprintf (
		"%s ('%s %s':%d) %s b%s",
		DbgTime(),
		RcsUnpack ($RCS->{$file}->{source}),
		RcsUnpack ($RCS->{$file}->{revision}),
		$line,
		$info{BUILD_VERSION},
		$info{BUILD_NUMBER} )
	);
}


sub DbgFcnIn()
{
	my $function = ( caller (1) )[3] || 'main';
	DbgPlain 99, "===>> $function {";
}


sub DbgFcnOut
{
	my $retval = shift;
	my $function = ( caller (1) )[3] || 'main';
	my ($package, $file, $line) = caller;
	DbgPlain (99, sprintf (
		"%s ('%s %s':%d) %s b%s",
		DbgTime(),
		RcsUnpack ($RCS->{$file}->{source}),
		RcsUnpack ($RCS->{$file}->{revision}),
		$line,
		$info{BUILD_VERSION},
		$info{BUILD_NUMBER} )
	);
	DbgPlain (99, "retval = ", DbgDump($retval)) if $retval;
	DbgPlain 99, "<<=== }  /* $function */\n";
}


sub DbgExit ()
{
	return unless $debug{FILE};
	DbgStamp DBG_ALWAYS;
	DbgPlain DBG_ALWAYS,
		"\n",
		"==================================================================\n",
		"  DEBUGGING ENDED PROPERLY\n",
		"==================================================================\n";
	close $debug{FILE};
}
















sub iUnpackConfig ($)
{
	my $buf  = shift;
	my $hash = {};
	return $hash unless ref $buf eq 'SCALAR';

	my $reText = qr(\s*\'([^\']*)\'\s*);

	while ($$buf)
	{
		my $key=$1 if $$buf =~ s|^[\s;]*([^\}\s=]+)\s*=\s*||;


		$$buf =~ s|^$reText[;\s]+|| and do {
			$hash->{$key} = $1;
			next;
		};


		$$buf =~ s|^(\d+)[;\s]+|| and do {
			$hash->{$key} = int($1);
			next;
		};


		$$buf =~ s|^\(|| and do {
			while ($$buf =~ s|^$reText,?||)
			{
				push @{ $hash->{$key} }, $1;
			}
			$$buf =~ s|^[\s;)]+||;
			next;
		};


		$$buf =~ s|^\{|| and do {
			my $sublist = {};
			$hash->{$key} = iUnpackConfig ($buf);
			next;
		};


		return $hash if $$buf =~ s|^\s*\}[\s;]*||;


		ErhThrow OB2ERROR, 1008, $$buf;
		return undef;
	}
	return $hash;
}


sub UnpackConfig ($)
{
	my $buf = shift;
	return iUnpackConfig(\$buf);
}




sub iPackConfig ($$)
{
	my ($buf, $cfg) = @_;

	DbgPlain DBG_DETAIL_PROGTRACE, DbgDump($cfg);

	while (my ($key, $val) = each %$cfg)
	{
		ref $val eq 'ARRAY' and do {
			$$buf .= "$key=(";
			$$buf .= join ',', map {"'$_'"} @$val;
			$$buf .= ");\n";
			next;
		};

		ref $val eq 'HASH' and do {
			$$buf .= "$key={\n";
			iPackConfig ($buf, $val);
			$$buf .= "\n};\n";
			next;
		};

		$$buf .= "$key='$val';\n";
	}
}

sub PackConfig ($)
{
	my $cfg = shift;
	my $buf = "";
	iPackConfig (\$buf, $cfg);
	return $buf;
}












sub GetConfigName (@)
{
	my %args = @_;
	my $host = $args{host} || $ENV{OB2BARHOSTNAME} || CmnHostName();
	return $args{name} || qq($host\%$args{instance});
}








sub GetConfig (@)
{
	DbgFcnIn();
	my %param = @_;
	my $cfg;

	DbgPlain DBG_MAIN_ACTION, "GetConfig: ", DbgDump(\%param);

	$param{type} or do {
		ErhThrow (OB2ERROR, 1007, "Missing application type");
		goto out;
	};

	my $name = GetConfigName(%param);

	my $buf = RunRetval (CmnQuotePath($PROG{UTILCMD}), "-getmethod", $param{type}, $name) or do {
		goto out;
	};

	$cfg = iUnpackConfig (\$buf);
	DbgPlain DBG_DETAIL_PROGTRACE, "GetConfig = ", DbgDump($cfg);

out:
	DbgFcnOut();
	return $cfg;
}









sub PutConfig (@)
{
	DbgFcnIn();
	my $oldErrors = ErhWas();

	my %param = @_;
	my $rnd = sprintf ("%04x", int(rand(0xFFFF)));
	my $tmpfile = $param{localfile} || qq($PAN{TMP}/ob2.putconfig.${PROCESS_ID}.$rnd.tmp);

	DbgPlain DBG_MAIN_ACTION, "PutConfig: ", DbgDump(\%param);

	my $fd;
	open $fd, ">$tmpfile" or do {
		ErhThrow (OSERROR, { filename => "$tmpfile" });
		DbgFcnOut();
		return undef;
	};

	print $fd PackConfig ($param{config});
	close ($fd);
	goto out if $param{localfile};

	$param{type} or do {
		ErhThrow (OB2ERROR, 1007, "Missing application type");
		goto out;
	};

	my $name = GetConfigName (%param);

	RunRetval (CmnQuotePath($PROG{UTILCMD}), qq(-putmethod $param{type} "$name" -local "$tmpfile"));

out:
	unlink $tmpfile unless $param{localfile};
	my $retval = ErhWas() == $oldErrors;
	DbgFcnOut($retval);
	return $retval;
}


sub Encode ($)
{
	my $text = shift or return undef;
	my $out = RunRetval (CmnQuotePath($PROG{UTILCMD}), "-encode $text", { hideargs=> 1} );
	return $out;
}


sub Decode ($)
{
	my $text = shift or return;
	my $out = RunRetval (CmnQuotePath($PROG{UTILCMD}), "-decode $text", { hide => 1 });
	return $out;
}





















































my $yaclip_config = {
	case => undef,
	auto => undef,
};


sub yaclip_config
{
	my $opts = lc (join " ", @_);
	foreach (split /[:\s]+/, $opts)
	{
		next unless $_;
		my $negate = $_ =~ s|^no||;
		$yaclip_config->{$_} = $negate? undef : 1;
	}
}	













sub yaclip_match_auto ($;$)
{
	my ($rules, $arg) = @_;
	my $match = undef;
	foreach my $pattern (keys %$rules)
	{
		my @patterns = split (/\|/, $pattern);


		grep /^$arg$/i, @patterns and return $pattern;

		next unless $yaclip_config->{auto};


		grep /^$arg/i, @patterns or next;
		return undef if $match;
		$match = $pattern;
	}
	return $match;
}









sub yaclip_r ($$$)
{
	my ($rules, $argv, $result) = @_;
	while (my $arg = shift @$argv)
	{

		$arg =~ m|^([^:=]+)[:=](.*)| and do {
			$arg = $1;
			unshift @$argv, $2;
		};


		my $switch = yaclip_match_auto($rules, $arg) or do {
			$result->{unknown} = $arg;
			unshift @$argv, $arg;
			return $result;
		};
		my $rule = $rules->{$switch};
		my ($cleanSwitch) = $switch =~ m|([^-/]+)|;


		defined $rule or do {
			$result->{$cleanSwitch} ++;
			next;
		};




		$rule = [ $rule ] unless ref $rule eq 'ARRAY';



		my $store;


		if ( $rule->[scalar(@$rule)-1] eq '...' )
		{
			push @{ $result->{$cleanSwitch} }, ($store = {});
		}

		elsif ( grep { ref eq 'HASH' } @$rule )
		{
			$store = $result->{$cleanSwitch} = {};
		}
		else
		{
			$store = $result;
		}



		foreach my $name (@$rule)
		{
			last if $name eq '...';
	
			ref $name eq 'HASH' and do {
				yaclip_r ($name, $argv, $store);
				next;
			};

			my $optional = $name =~ s|^\[([^\]]+)\]|$1|;
			scalar (@$argv) or do {
				$store->{missing} = qq($cleanSwitch/$name) unless $optional;
				last;
			};


			$optional and do {
				last if yaclip_match_auto($rules, $argv->[0]);
			};

			$store->{$name} = shift @$argv;
		}

		$result->{$cleanSwitch} = 1 unless exists $result->{$cleanSwitch};

	}
	return $result;
}


sub yaclip ($;@)
{
	my $opts = shift;
	return yaclip_r ($opts, \@_, {});
}


sub yaclip_valid ($;@)
{
	my ($argv, @required) = @_;
	my $required = join '|', grep /\S/, @required;
	return 
		ref $argv ne 'HASH' || $argv->{unknown} || $argv->{missing}? undef :
		!$required? 1 :
		grep /^$required$/, keys(%$argv);
}
















sub CloseExecHandle ($)
{
	my $handle = shift;
	my $retval = close $handle or do {








		DbgStamp DBG_DETAIL_PROGTRACE;
		DbgPlain DBG_DETAIL_PROGTRACE, "CloseExecHandle failed.";
	};
	return $retval;
}









sub CmnExpandHashBang ($)
{
	my $cmd = shift;

	DbgFcnIn();






































	DbgFcnOut();
	return $cmd;
}

sub Run (@)
{
	my $cmd    = join " ", grep {!ref} @_;
	my %params = map %$_, grep {ref eq 'HASH'} @_;

	DbgFcnIn();
	my ($exe) = $cmd =~ m{((^'[^']+')|(^"[^"]+")|(^\S+))};
	$exe = $params{hideargs}? "$exe ****" : $cmd;
	DbgPlain DBG_DETAIL_PROGTRACE, "Executing: '$exe'";
	DbgPlain DBG_DETAIL_PROGTRACE, "Parameters:", DbgDump(\%params);

	$cmd = CmnExpandHashBang($cmd);

	if ($params{noout})
	{
		system($cmd) == 0 or do {
			ErhThrow (OSERROR, "While starting: '$exe'");
		};
		DbgFcnOut;
		return undef;
	}

	my $output;
	my @output;
	my $fd = gensym;

	open $fd, "$cmd | " or do {
		ErhThrow (OSERROR, "While starting: '$exe'");
		DbgFcnOut;
		return undef;
	};

	binmode $fd, ":utf8" if $params{utf8};

	while (!eof($fd))
	{
		my $line = <$fd> or last;
		DbgPlain DBG_DETAIL_PROGTRACE, "Read line: ", ($params{hide}? '****' : $line);
		if (wantarray)
		{
			chomp $line;
			push @output, $line;
		}
		else
		{
			$output .= $line;
		}
	}

	CloseExecHandle ($fd) or do {
		ErhThrow(OSERROR,    "Process exited: $exe") if $OS_ERROR    != 0;
		ErhThrow(CHILDERROR, "Process exited: $exe") if $CHILD_ERROR != 0;
	};

	DbgFcnOut();
	return wantarray? @output : $output;
}












sub RunRetval (@)
{
	DbgFcnIn();
	my $result;
	my @result;

	my @output = Run(@_, {utf8=>1}) or do {
		DbgFcnOut();
		return undef;
	};
	while (scalar(@output))
	{
		my $line = shift @output or next;

		$line =~ m|^\*RETVAL\*(\d+)$| or do {
			wantarray? push (@result, $line) : ($result .= $line);
			next;
		};
		my $retval = int($1);
		DbgPlain DBG_MAIN_ACTION, 'Got *RETVAL*', $retval;
		$retval != 0 and do {
			ErhThrow (OB2ERROR, $retval, @output);
			last;
		};
	}
	DbgFcnOut();
	return wantarray? @result : $result;
}


sub NlsGetMessage ($$;@)
{
	my ($msgset, $msgnum, @args) = @_;
	my $msg = Run CmnQuotePath($PROG{OMNIGETMSG}), $msgset, $msgnum, @args;
	return $msg;
}






my @recordObject = qw(objectname objecttype);

my @recordVersion = qw(ovid related_ovid starttime endtime reltime sizelo sizehi
	status flags backuptype prottype prottime catprottype catprottime accesstype accessvalue
	nfiles nwarnings nerrors diskagentid vertype mediaclass backupdevice
	dftype dfsubtype opt);

my @recordFile = qw(name id type uid gid mode sizelo sizehi mtime flags);

my @recordSession = qw(name longname description owner user datalist type
	starttime endtime status flags nerrors nwarnings backuptype quetime opt);

my %queryDefinition = (
	FUN_LISTOVEROFSESSION   => [ @recordObject, @recordVersion ],
	FUN_LISTOVEROFAPPBACKUP => [ @recordObject, @recordVersion ],
	FUN_LISTCATALOG         => [ @recordFile ],
	FUN_LISTOBJECTS         => [ @recordObject ],
	FUN_LISTVEROFOBJECT     => [ @recordVersion, 'sessionname' ],
);

sub Query ($;@)
{
	DbgFcnIn();

	my $fun = shift;
	my @select = map @$_, grep {ref eq 'ARRAY'} @_;
	my $args = join " ", map qq('$_'), grep {!ref} @_;

	$args = qq("$args");

	DbgPlain DBG_MAIN_ACTION, "Select: ", DbgDump \@select;

	my $columnNames = $queryDefinition{$fun};
	my $columnIds;

	if ($columnNames && @select)
	{
		my $tmp = Hashify($columnNames);
		$columnIds = join ",", map { $tmp->{$_} + 1 } (@select);
		$columnIds = "-query_columns $columnIds";
		$columnNames = \@select;
	}
	DbgPlain DBG_DETAIL_PROGTRACE, "Record definition: ", DbgDump $columnNames;

	my @list = RunRetval
		CmnQuotePath($PROG{UTILCMD}), '-query', $fun, $args, $columnIds;

	my $out = [];
	foreach (@list)
	{
		my $record;
		if ($columnNames)
		{
			my @columns = split /\|/, $_;
			for (my $i=0; $i <= $#columns; ++$i)
			{
				$record->{$columnNames->[$i]} = $columns[$i];
			}
			push @$out, $record;
			DbgPlain DBG_DETAIL_PROGTRACE, "Record: ", DbgDump ($record);
		}
		else
		{
			push @$out, $_;
			DbgPlain DBG_DETAIL_PROGTRACE, "Record: ", $_;
		}
	}
	DbgFcnOut();
	return $out;
}


1;

__END__
























































































