#!/bin/sh
# #############################################################################
#
#     (c) Copyright 1993, Hewlett-Packard NSMD, all rights reserved.
#
#     PACKAGE      HP OpenView OmniBackII
#     FILE         omni_rinst.sh
#     RCS          $Header: /src/shell/inst/remote/sup/omni_rinst.sh /main/hsl_dp61/hsl_hpit2_2/5 2009-04-22 15:00:14 seidh $
#
#     USAGE
#        omni_rinst.sh   <tmpdir>/pkg.Z <packet> <vers> <series> <homedir>
#                        <logdir> <port>
#        <tmpdir>/packet.Z   name of packet compressed fileset (as tape image)
#        <packet>          'DiskAgent' 'CellConsole' 'MediaAgent'
#        <vers>            version of DiskAgent or MediaAgent or CellConsole  
#        <series>          ibm/rs6000/aix, sun/spar/s*, dec/alpha/osf1 
#                          sgi/mips/irix, siemens/r400/sinix
#                          sco/i386/sco_sv ...
#        <homedir>         OmniBackII HOME directory 
#        <cell_server>     Cell server for installation
#        <port>            Port number (write to socket.dat)
#
#                    
#     DESCRIPTION
#        Uncompress and install the specified package.
#
# #############################################################################
#
#     RETURNS    
# 
# Exit values of this script
#                                                             stdout
#   0  OmniBackII software package successfully installed
#   1  WILL NEVER BE SET EXPLICTLY !!!
#   2  WILL NEVER BE SET EXPLICTLY !!!
#   3  unexpected uncompress or tar problem
#   4  usage error
#   5  unsupported arch specified
#   6  unexpected customize problem
#   7  software was already installed from other CellServer
#==============================================================================

#Debug="set -x"
Debug=""
$Debug

AWK=awk
PRODUCT="DATA-PROTECTOR"
SUBPRODUCT=""

echo
TOMNI=/tmp/omni_tmp

OS_VER=`uname`

# file containing the name of the Cell Server
# this file does only exist, if this script is called bu omni_inst.sh 
# ###################################################################

# Write port number to socket.dat
# (binary master used to do it, but once upon the time CmnLib restricted
# access to commands executed via omniinet, so echo <port> 2> socket.dat
# works no more. Hence, we'll do it here. Unconditionally.
#
# NOTE: do not attempt to skip socket.dat file - it may only work for
#       non-HP UX, non-Solaris clients. HP and Solaris use socket.dat
#       in swinstall, pkgadd scripts.
#
# 09.may 2002 jozem
########################################################################
echo $7 >${TOMNI}/socket.dat

# Socket number for inetd 
# #######################
SOCKET_NUMBER_F=${TOMNI}/socket.dat
if [ -f "${SOCKET_NUMBER_F}" ]; then
    SOCKET_NUMBER=`$AWK '{print}' ${SOCKET_NUMBER_F}`
else 
    SOCKET_NUMBER=5555
fi

# The service file, inet service will be included
# ###############################################
SERVICES=/etc/services            

# Configuration file for inetd 
# ############################
if [ -f /etc/inetd.conf ]; then
    INETDCONF=/etc/inetd.conf     
fi

if [ -f /etc/xinetd.conf ]; then
  XINETDFILE=`cat /etc/xinetd.conf | grep includedir | $AWK '{ print $2 }'`
  if [ "${XINETDFILE}" != "" ]; then
    XINETDFILE=${XINETDFILE}/omni
    if [ -f "${XINETDFILE}" ]; then
      XINETDOMNIEXISTS="Yes"
    fi
  else
    XINETDFILE="/etc/xinetd.conf"
  fi
fi

SERVICE=omni

# Temporary files 
# ###############
TMP=${TOMNI}/inst.tmp      

# local functions
# ###############

standalone_run_msg ()
{ $Debug
  MSG="$*"
  echo ${MSG} 1>&2
}

clean ()
{ $Debug
if [ "$XINETDOMNIEXISTS" != "Yes" ]; then
  for file in ${SERVICES} ${INETDCONF}; do
    $AWK '{if(($1 != "omni_" && $1 != SERV) && $2 != "DATA-PROTECTOR") {print}} ' SERV=${SERVICE} ${file} > ${TMP}
    cp ${TMP} ${file}
    rm ${TMP}
  done

  if [ ${XINETDFILE} ]; then
    if [ "${XINETDFILE}" != "/etc/xinetd.conf" ]; then
      rm ${XINETDFILE} 2>/dev/null
    else
      sed /^"service omni"$/,/^$/d ${XINETDFILE} > /${TOMNI}/new.xinetd.conf
      mv /${TOMNI}/new.xinetd.conf ${XINETDFILE}
    fi
  fi
fi
}

copy_newconfig()
{ $Debug
  NEWCONFIG=${OMNI_HOME}/newconfig/

  if [ -d "${NEWCONFIG}/" ]; then

    cd ${NEWCONFIG}/
    for dir in `find . -type d -print`; do
        cd /
        if [ ! -d $dir ]; then
            mkdir -p $dir
            if [ "${OS_VER}" != "OSF1" ]; then
                chown root:sys $dir
            else
                chown root:mem $dir
            fi

            if [ "`basename $dir`" = "log" -o "`basename $dir`" = "tmp" ]; then
                chmod 777 $dir
            else
                chmod 755 $dir
            fi
        fi
    done

    cd ${NEWCONFIG}/
    for file in `find . -type f -print`; do
      cd /
      if [ ! -r $file ]; then
        cp -p ${NEWCONFIG}/$file $file
        # if file has log extension change premission to 666
        if [ "`echo $file | grep '\.log$'`" != "" ]; then
          chmod 666 $file
        fi
      fi
    done
  else
    standalone_run_msg "ERROR:   Directoy ${NEWCONFIG} does not exist" 
  fi
}

CheckInstalledOBDP()
{ $Debug

if [ -f ${OMNI_HOME}/bin/omnicc ]
then
  DPOBVersion=`${OMNI_HOME}/bin/omnicc -ver 2>/dev/null | $AWK '{for(i=1;i<=NF;i+=1) {print $i}}' | grep "A\.[0-9]" | tr -d ": "`
  DPOBProduct=`${OMNI_HOME}/bin/omnicc -ver 2>/dev/null | $AWK '{sub(" +A.[0-9].*",""); sub("HP +",""); sub("(OpenView|StorageWorks) +",""); sub("Storage +", ""); sub(" +software",""); print}'`
else
  DPOBVersion=0
  DPOBProduct=""
fi
  
  case $DPOBVersion in
    0)
      #      standalone_run_msg "  No Data Protector found on system"
      ;;
    A\.05\.50|A\.06\.00|A\.06\.10|A\.06\.11*)
      #      standalone_run_msg "  $DPOBProduct version $DPOBVersion found"
      ;;
    *)
      standalone_run_msg "  Setup has detected version $DPOBVersion of $DPOBProduct."
      standalone_run_msg "  Upgrade from this version is not supported. Exiting..."
      exit 1
      ;;
  esac
}

CheckDatabase()
{ $Debug

  OMNI_CDB=/var${OMNI_HOME}/db/cdb
  DB_VERS=/var${OMNI_HOME}/db/catalog/version.txt
  DB_VERS40=/var${OMNI_HOME}/db40/datafiles/catalog/version.txt
  DB_VERS55=/var${OMNI_HOME}/server/db40/datafiles/catalog/version.txt

  # version.txt has hardcoded (not branded!) product strings (see CC:/ob/src/lib/cmn/defines.h)
  # For DP:    "HP OpenView OmniBack II"
  # For APPRM: "HP Application Recovery Manager"
  # after this the version string follows: "A.06.10"

  # check for current database version
  if [ -f "$DB_VERS55" ]; then
    DB_PRODUCT=`$AWK '{sub(" +A.[0-9].*",""); sub("HP +",""); sub("(OpenView|StorageWorks) +",""); sub(" +software",""); sub("OmniBack II", "Data Protector"); print}' $DB_VERS55`
    DB_VERSION_STR=`$AWK '{sub("HP OpenView OmniBack II +",""); sub("HP( StorageWorks | )Application Recovery Manager +",""); print}' $DB_VERS55`
    DB_VERSION=`echo $DB_VERSION_STR | $AWK -F"." '{ print $2 "." $3 }'`
#   standalone_run_msg "NOTE:    $DB_PRODUCT database version $DB_VERSION_STR found."

  else
    # detect older database version 4.00 4.10 5.00 5.10
    if [ -f "$DB_VERS40" ]; then
      DB_PRODUCT=`$AWK '{sub(" +A.[0-9].*",""); sub("HP +",""); sub("(OpenView|StorageWorks) +",""); sub(" +software",""); sub("OmniBack II", "Data Protector"); print}' $DB_VERS40`
      DB_VERSION_STR=`$AWK '{sub("HP OpenView OmniBack II +",""); sub("HP( StorageWorks | )Application Recovery Manager +",""); print}' $DB_VERS40`
      DB_VERSION=`echo $DB_VERSION_STR | $AWK -F"." '{ print $2 "." $3 }'`
#     standalone_run_msg "NOTE:    $DB_PRODUCT database version $DB_VERSION_STR found."

    else
      # detect very old database version 3.51 3.50 3.10 3.00 2.55
      if [ -d "$OMNI_CDB" ]; then
        if [ -f "$DB_VERS" ]; then
          DB_PRODUCT=`$AWK '{sub(" +A.[0-9].*",""); sub("HP +",""); sub("(OpenView|StorageWorks) +",""); sub(" +software",""); sub("OmniBack II", "Data Protector"); print}' $DB_VERS`
          DB_VERSION_STR=`$AWK '{sub("HP OpenView OmniBack II +",""); sub("HP( StorageWorks | )Application Recovery Manager +",""); print}' $DB_VERS`
          DB_VERSION=`echo $DB_VERSION_STR | $AWK -F"." '{ print $2 "." $3 }'`
#         standalone_run_msg "NOTE:    $DB_PRODUCT database version $DB_VERSION_STR found."

        else
          DB_PRODUCT=OmniBack
          DB_VERSION=OLD
        fi

      else
        DB_PRODUCT=""
        DB_VERSION=0
      fi
    fi
  fi

  case $DB_VERSION in
    0)
      # OK (fresh install)
      ;;

    05.50|06.00|06.10|06.11)
      if [ "$SUBPRODUCT" = "AppRM" ]; then
        if [ "$DB_PRODUCT" != "Application Recovery Manager" ]; then
          standalone_run_msg "Data Protector software package installation failed"
          standalone_run_msg "Installation of AppRM has detected Data Protector database/configuration on the"
          standalone_run_msg "system. Upgrade of database/configuration from Data Protector is not supported."
          standalone_run_msg "Please check it and remove it before continuing with AppRM installation."
          exit 3
        fi
      fi
      ;;
    *)
       # Unsupported version
       standalone_run_msg "Unknown/unsupported $DB_PRODUCT database version $DB_VERSION_STR detected."
       standalone_run_msg "Data Protector software can not function properly with this"
       standalone_run_msg "database. Refer to documentation for manual upgrade procedure."
       exit 1
      ;;
  esac
}

InstallGeneric()
{ $Debug
  INET=${OMNI_LBIN}/inet
  
  # uncompress product package
  #---------------------------
  PKG=`echo ${UPD_PCKG} | sed -e 's/\.Z$//'`
  rm -f ${PKG}            # remove previous package, if still available
  
  case ${ARCH} in
    sgi/mips/irix*)
      /usr/bsd/uncompress ${UPD_PCKG}
      ;;
  
    *)
      uncompress ${UPD_PCKG} > /dev/null 2>&1
      if [ $? -gt 0 ]; then	  # in case that uncompress is not available use gunzip instead.
        gunzip ${UPD_PCKG} > /dev/null 2>&1	   
      fi
      ;;
  esac
  
  if [ $? -ne 0 ]; then
    rm -f ${UPD_PCKG}
    rm -f ${PKG}
    standalone_run_msg "Unexpected uncompress problem"
    exit 3
  fi
  
  # remove product package
  # ######################
  rm -f ${UPD_PCKG}
  if [ ! -d "${OMNI_HOME}" ]; then
    mkdir -p ${OMNI_HOME}
    chmod 755 ${OMNI_HOME} 
  fi
  
  cd ${OMNI_HOME}
  
  # Move busy inet if this is Core
  #########################
  if [ "$PACKET" = "Core" ]
  then
  CheckInstalledOBDP
  if [ "${ARCH}" = "ibm/rs6000/aix-43" -o "${ARCH}" = "ibm/rs6000/aix-51" ]; then
    rm -f ${OMNI_HOME}/lib/libde.a
    rm -f ${OMNI_HOME}/lib/libdc.a
    rm -f ${OMNI_HOME}/lib/libBrandChg.a
    rm -f ${OMNI_HOME}/lib/libBrandChg_64bit.a
  fi
    if [ "${ARCH}" = "siemens/r400/sinix" ]; then
    rm -f ${OMNI_HOME}/lib/libde.so
    rm -f ${OMNI_HOME}/lib/libdc.so
    rm -f ${OMNI_HOME}/lib/libBrandChg.so
  fi
  
  if [ -x ${INET} ]
  then
    mv ${INET} ${OMNI_LBIN}/'#inet'
  fi
  fi
  
  # Move busy libob2oracle8.a if this is oracle8
  #########################
  if [ "$PACKET" = "oracle8" ]
  then
  if [ "${ARCH}" = ibm/rs6000/aix-43 ]; then
    rm -f ${OMNI_HOME}/lib/libob2oracle8.a
  fi
  fi
  
  # Move busy libob2informix*.a if this is informix
  #########################
  if [ "$PACKET" = "informix" ]
  then
  if [ "${ARCH}" = ibm/rs6000/aix-43 ]; then
    rm -f ${OMNI_HOME}/lib/libob2informix.a
    rm -f ${OMNI_HOME}/lib/libob2informix_64bit.a
  fi
  fi

  tar ${TAR_SWITCHES} ${PKG}
  if [ $? -ne 0 ]
  then
    rm -f ${PKG}
    standalone_run_msg "Unexpected untar problem"
    exit 3
  fi    
  
  rm -f ${PKG}
  
  if [ "$PACKET" = "Core" ]
  then
    OMNISITEPERL=${OMNI_HOME}/lib/perl
    if [ -d ${OMNISITEPERL} ]; then 
      MY_C_PATH=`pwd`
      cd ${OMNISITEPERL}
      if [ -f ./site_perl.tar ]; then
        tar ${TAR_SWITCHES} ./site_perl.tar 1>/dev/null 2>/dev/null
      fi
      cd ${MY_C_PATH}
    fi
  fi
  
  # removing OmniBack II entries
  # ############################  
  clean
  
  # determine whether socket is already busy
  # ########################################
  NUMBER=`egrep -c "^[^#]* ${SOCKET_NUMBER}\/tcp" ${SERVICES}` 

if [ "$XINETDOMNIEXISTS" != "Yes" ]; then

  if [ "${NUMBER}" -ne 0 ]
  then
    standalone_run_msg "Inet socket ${SOCKET_NUMBER} is already busy"
    exit 1
  else  
    # changes should be made
    # ######################
    echo "${SERVICE}  ${SOCKET_NUMBER}/tcp     # DATA-PROTECTOR" >> ${SERVICES}
  
    if [ "${INETDCONF}" != "" ]; then
      echo "${SERVICE} stream tcp nowait root ${INET} inet  -log ${OMNI_LOG}/inet.log" >> ${INETDCONF}
    fi
    if [ "${XINETDFILE}" != "" ]; then
      echo "service omni
  {
          socket_type             = stream
          protocol                = tcp
          wait                    = no
          user                    = root
          server                  = /usr/omni/bin/inet
          server_args             = inet -log /usr/omni/log/inet.log
          disable                 = no
  }
  " >> ${XINETDFILE}

    fi
  fi

fi
    
  # ##########################################################
  # kill -HUP <inetd.pid> is used for the inetd to re-read the
  # configuration files
  # ##########################################################
  case ${ARCH} in
    ibm/rs6000/aix*)
       INETDPID=`ps -e | egrep '[/ ]*inetd'| grep -v grep | $AWK '{print $1}'`
       ;;
    dec/alpha/osf1*|sgi/mips/irix*|siemens/r400/sinix*|sco/i386/sco_sv|sco/i386/unixware)
       INETDPID=`ps -e | egrep '[/ ]*inetd'| grep -v grep | $AWK '{print $1}'`
       ;;
  esac 
  
  if [ "${INETDPID}" -a "$PACKET" = "Core" ]
  then
    kill -HUP ${INETDPID}
    kill -HUP ${INETDPID}
  fi
  
  if [ "${XINETDPID}" ]
  then
    kill -SIGUSR1 ${INETDPID}
    kill -SIGUSR1 ${INETDPID}
  fi
  
  STRING=${PACKET}
  copy_newconfig

  if [ -f /usr/omni/config/cell/allow_hosts ]
  then
    cp -p /usr/omni/config/cell/allow_hosts /usr/omni/config/client 2> /dev/null
    if [ $? -ne 0 ]
    then
      echo "ERROR: Copy of allow_hosts failed"
    fi
  fi

  if [ -f /usr/omni/config/cell/deny_hosts ]
  then
    cp -p /usr/omni/config/cell/deny_hosts /usr/omni/config/client 2> /dev/null
    if [ $? -ne 0 ]
    then
      echo "ERROR: Copy of deny_hosts failed"
    fi
  fi

  rm -rf /usr/omni/config/cell 2>/dev/null

  case ${PACKET} in
    ndmp|NDMP)
      STRING2="ma"
      ;;
  esac
  
  if [ ! -d ${OMNI_LOG} ]
  then
    mkdir -p ${OMNI_LOG}
    if [ "${OS_VER}" != "OSF1" ]; then
        chown root:sys ${OMNI_LOG}
    else
        chown root:mem ${OMNI_LOG}
    fi
    chmod 777 ${OMNI_LOG}
  fi
  
  if [ ! -f ${OMNI_LOG}/debug.log ]
  then
    > ${OMNI_LOG}/debug.log
    if [ "${OS_VER}" != "OSF1" ]; then
        chown root:sys ${OMNI_LOG}/debug.log
    else
        chown root:mem ${OMNI_LOG}/debug.log
    fi
    chmod 666 ${OMNI_LOG}/debug.log
  fi
    
  # #######################
  # Updating omni_info file
  # #######################
  if [ ! -d "${INFO_DIR}" ]
  then
    mkdir -p ${INFO_DIR}
  fi
  
  if [ "${STRING}" = "Core" ]; then
    STRING="core"
  fi

  if [ "${STRING}" = "core_intg" ]; then
    STRING="integ"
  fi
  
    if [ -n "${STRING}" ]
    then
         ${OMNI_BIN}/omnicc -put_component_str $STRING client/omni_format client/omni_info ${VERS} 1>/dev/null 2>/dev/null
    fi
    if [ $? -ne 0 ]
    then
         standalone_run_msg "WARNING: Update of the omni_info file failed for $STRING!"
    fi
    if [ -n "${STRING2}" ]
    then 
         ${OMNI_BIN}/omnicc -put_component_str $STRING2 client/omni_format client/omni_info ${VERS} 1>/dev/null 2>/dev/null
    fi
    if [ $? -ne 0 ]
    then
         standalone_run_msg "WARNING: Update of the omni_info file failed for $STRING!"
    fi
  
  chmod 755 ${OMNI_HOME}

  standalone_run_msg "Data Protector software package successfully installed"
}

PKGExitError()
{ $Debug
  if [ $1 -le $2 ];
  then
    RETCODE=$2
  else
    RETCODE=$1
  fi
  case $RETCODE in
    0)
      standalone_run_msg "Data Protector software package successfully installed"
      ;;
    2)
# "...with errors" at the end of message was removed.  Oracle and sap always give warnings.  That's why we'll always write success.
      standalone_run_msg "Data Protector software package successfully installed"
      ;;
    *)
      standalone_run_msg "Data Protector software package installation failed"
      standalone_run_msg "Check the log file /var/tmp/$PACKET-pkgadd.log"
      rm -f ${PKG}
      exit 3
      ;;
  esac
}

RPMExitError()
{ $Debug
  if [ $1 -le $2 ];
  then
    RETCODE=$2
  else
    RETCODE=$1
  fi
  case $RETCODE in
    0)
      standalone_run_msg "Data Protector software package successfully installed"
      ;;
    2)
# "...with errors" at the end of message was removed.  Oracle and sap always give warnings.  That's why we'll always write success.
      standalone_run_msg "Data Protector software package successfully installed"
      ;;
    *)
      standalone_run_msg "Data Protector software package installation failed"
      standalone_run_msg "Check the log file /tmp/$PACKET-rpm.log"
      rm -f ${PKG}
      exit 3
      ;;
  esac
}

####################################################################
####################################################################
InstallLinux()
{ $Debug
  umask 022
  # Debug file
  # ---------------
  DEBUG_FILE=/tmp/omni.debug
 
  if [ "$OPTS" = "erase_cell_server" -a ! -f /etc/opt/omni/server/cell/cell_info ]; then
    mv /etc/opt/omni/client/cell_server /etc/opt/omni/client/cell_server.tmp 2>/dev/null
  fi

  rpm -qa > /dev/null 2>&1
  if [ $? != 0 ]; then
    standalone_run_msg "RPM Package Manager is not installed or configured properly."
    exit 3
  fi

  # uncompress product package
  #---------------------------
  PKG=`echo ${UPD_PCKG} | /bin/sed -e 's/\.Z$//'`
  rm -f ${PKG}            # remove previous package, if still available
  uncompress ${UPD_PCKG} > /dev/null 2>&1
  if [ $? -gt 0 ]; then       # in case that uncompress is not available use gunzip instead.
    gunzip ${UPD_PCKG} > /dev/null 2>&1        
  fi
  if [ $? -ne 0 ]; then       # In some Linux variants both uncompress and gunzip are absent. Hence 'gzip -d' is used.
    gzip -d ${UPD_PCKG} > /dev/null 2>&1  
  fi
  if [ $? -ne 0 ]
  then
    rm -f ${UPD_PCKG}
    rm -f ${PKG}
    standalone_run_msg "Unexpected uncompress problem"
    exit 3
  fi

  epkg=`rpm -qp ${PKG} | $AWK -F"[-]" '{ if ($1~/OB2/) { if ($3~/A./)  {print $1  "-"  $2 } else {print $1  "-"  $2 "-" $3 }}}'`

  # remove product package
  #--------------------------
  rm -f ${UPD_PCKG}
  if [ ! -d "${OMNI_HOME}" ]
  then
    mkdir -p "${OMNI_HOME}"
    chmod 755 "${OMNI_HOME}"
  fi

  if [ -f ${DEBUG_FILE} ]
  then
    OPTIONS="-nv"
  else
    OPTIONS="-n"
  fi

  cd /
 
#Check if selinux is on... must flip to permissive mode
if [ -f /usr/sbin/sestatus ]
then
  se_enforce=`/usr/sbin/sestatus | grep -c "^Current mode.*enforcing"` 
  if [ "$se_enforce" -ge 1 ]; then
     /usr/sbin/setenforce 0 2>&1 > /dev/null
  fi
fi
 
  case ${PACKET} in

  Core)
    CheckInstalledOBDP
    CheckDatabase
    INSTALLED_REV=`/opt/omni/bin/omnicc -ver 2>/dev/null | $AWK '{for(i=1;i<=NF;i+=1) {print $i}}' | grep "A\.[0-9]" | tr -d ": "`
    INSTALLED_PATCH=`cat /opt/omni/.patch_core 2>/dev/null`
    cd ${TOMNI}
    rpm2cpio ${PKG} | cpio -id ./opt/omni/bin/omnicc ./opt/omni/.patch_core 2>/dev/null 1>&2
    RETCODE1=$?
    cd - 2>/dev/null 1>&2
    if [ $RETCODE1 -eq 0 ]
    then
      DEPOT_PATCH=`cat ${TOMNI}/opt/omni/.patch_core 2>/dev/null`
      if [ -f /opt/omni/bin/omnicc ]
      then
        DEPOT_REV=`${TOMNI}/opt/omni/bin/omnicc -ver 2>/dev/null | $AWK '{for(i=1;i<=NF;i+=1) {print $i}}' | grep "A\.[0-9]" | tr -d ": "`
      fi
    fi
    rm -rf ${TOMNI}/opt/omni/bin/omnicc ${TOMNI}/opt/omni/.patch_core
    RETCODE1=0
    if [ "${INSTALLED_REV}" = "${DEPOT_REV}" -a "${INSTALLED_PATCH}" = "${DEPOT_PATCH}" ]
    then
      rpm -V --nodeps OB2-CORE > /tmp/$PACKET-rpm.log 2>&1
      RETCODE2=$?
      if [ $RETCODE2 -ne 0 ]
      then
	rpm -Uvh --replacepkgs --replacefiles --nodeps ${PKG} >> /tmp/$PACKET-rpm.log 2>&1
      fi
    else
      rpm -ev --noscripts --nodeps ${epkg} > /tmp/$PACKET-rpm.log 2>&1
      rpm -Uvh --replacepkgs --replacefiles --nodeps ${PKG} >> /tmp/$PACKET-rpm.log 2>&1
    fi
    RETCODE1=$?
    RPMExitError $RETCODE1 $RETCODE1
   ;;
 
  *)
      rpm -ev --noscripts --nodeps ${epkg} > /tmp/$PACKET-rpm.log 2>&1
      rpm -Uvh --replacepkgs --replacefiles --nodeps ${PKG} >> /tmp/$PACKET-rpm.log 2>&1
    RETCODE1=$?
    RPMExitError $RETCODE1 $RETCODE1
   ;;

  esac

#If necessary, flip selinux back to enforcing
if [ -f /usr/sbin/sestatus ]
then
  if [ "$se_enforce" -ge 1 ]; then
     /usr/sbin/setenforce 1 2>&1 > /dev/null
  fi
fi
  
  if [ "$OPTS" = "erase_cell_server" -a ! -f /etc/opt/omni/server/cell/cell_info ]; then
    mv /etc/opt/omni/client/cell_server.tmp /etc/opt/omni/client/cell_server 2>/dev/null
  fi

  rm -f ${PKG}
}
####################################################################
####################################################################

InstallSolaris()
{ $Debug
  umask 022
  # Admin file
  # ---------------
  ADMIN_FILE=${TOMNI}/admin
  
  # Debug file
  # ---------------
  DEBUG_FILE=/tmp/omni.debug
  
  # in the case of push installation which is not targetted to CM: 
  # rename the cell_server file so the SD, pkgadd and rpm installation scripts do not 
  # try to update info on the cell manager by themselves (IS will do that instead)
  if [ "$OPTS" = "erase_cell_server" -a ! -f /etc/opt/omni/server/cell/cell_info ]; then
    mv /etc/opt/omni/client/cell_server /etc/opt/omni/client/cell_server.tmp 2>/dev/null
  fi

  # uncompress product package
  #---------------------------
  PKG=`echo ${UPD_PCKG} | /usr/bin/sed -e 's/\.Z$//'`
  rm -f ${PKG}            # remove previous package, if still available
  /usr/bin/uncompress ${UPD_PCKG}
  if [ $? -ne 0 ]
  then
    rm -f ${UPD_PCKG}
    rm -f ${PKG}
    standalone_run_msg "Unexpected uncompress problem"
    exit 3
  fi
  
  # remove product package
  #--------------------------
  rm -f ${UPD_PCKG}
  if [ ! -d "${OMNI_HOME}" ]
  then
    mkdir -p "${OMNI_HOME}"
    chmod 755 "${OMNI_HOME}"
  fi
  
  if [ -f ${DEBUG_FILE} ]
  then
    OPTIONS="-nv"
  else
    OPTIONS="-n"
  fi
 
  cd /
  
  case ${PACKET} in

  ndmp|NDMP)
    /usr/sbin/pkgadd ${OPTIONS} -a ${ADMIN_FILE} -d ${PKG} OB2-MA > /var/tmp/$PACKET-pkgadd.log 2>&1 
    RETCODE1=$? 
    /usr/sbin/pkgadd ${OPTIONS} -a ${ADMIN_FILE} -d ${PKG} OB2-NDMP >> /var/tmp/$PACKET-pkgadd.log 2>&1 
    RETCODE2=$?
    PKGExitError $RETCODE1 $RETCODE2
   ;;

  Core)
    CheckInstalledOBDP
    CheckDatabase
    INSTALLED_REV=`/opt/omni/bin/omnicc -ver 2>/dev/null | $AWK '{for(i=1;i<=NF;i+=1) {print $i}}' | grep "A\.[0-9]" | tr -d ": "`
    INSTALLED_PATCH=`cat /opt/omni/.patch_core 2>/dev/null`
    mkdir -p ${TOMNI}/depot
    pkgtrans ${PKG} ${TOMNI}/depot all
    RETCODE1=$?
    if [ $RETCODE1 -eq 0 ]
    then
      DEPOT_PATCH=`cat ${TOMNI}/depot/OB2-CORE/root/opt/omni/.patch_core 2>/dev/null`
      if [ -f /opt/omni/bin/omnicc ]
      then
        DEPOT_REV=`${TOMNI}/depot/OB2-CORE/root/opt/omni/bin/omnicc -ver 2>/dev/null | $AWK '{for(i=1;i<=NF;i+=1) {print $i}}' | grep "A\.[0-9]" | tr -d ": "`
      fi
    fi
    rm -rf ${TOMNI}/depot
    RETCODE1=0
    if [ "${INSTALLED_REV}" = "${DEPOT_REV}" -a "${INSTALLED_PATCH}" = "${DEPOT_PATCH}" ]
    then
      /usr/sbin/pkgchk OB2-CORE > /var/tmp/$PACKET-pkgadd.log 2>&1
      if [ $? -ne 0 ]
      then
        /usr/sbin/pkgadd ${OPTIONS} -a ${ADMIN_FILE} -d ${PKG} all >> /var/tmp/$PACKET-pkgadd.log 2>&1
      fi
    else
      /usr/sbin/pkgadd ${OPTIONS} -a ${ADMIN_FILE} -v -d ${PKG} all > /var/tmp/$PACKET-pkgadd.log 2>&1
    fi
    RETCODE1=$?
    PKGExitError $RETCODE1 $RETCODE1
   ;;
  
  *)
    /usr/sbin/pkgadd ${OPTIONS} -a ${ADMIN_FILE} -d ${PKG} all > /var/tmp/$PACKET-pkgadd.log 2>&1 
    RETCODE1=$? 
    PKGExitError $RETCODE1 $RETCODE1
   ;;

  esac

  if [ "$OPTS" = "erase_cell_server" -a ! -f /etc/opt/omni/server/cell/cell_info ]; then
    mv /etc/opt/omni/client/cell_server.tmp /etc/opt/omni/client/cell_server 2>/dev/null
  fi

  rm -f ${PKG}
}

InstallHPUX()
{ $Debug
  # Create socket.dat file
  ###############################
  echo ${PORT} > ${TOMNI}/socket.dat

  if [ "$OPTS" = "erase_cell_server" -a ! -f /etc/opt/omni/server/cell/cell_info ]; then
    mv /etc/opt/omni/client/cell_server /etc/opt/omni/client/cell_server.tmp 2>/dev/null
  fi

  # uncompress product package
  #---------------------------
  PKG=`echo ${UPD_PCKG} | /usr/bin/sed -e 's/\.Z$//'`
  rm -f ${PKG}            # remove previous package, if still available
  /usr/bin/uncompress ${UPD_PCKG}
  if [ $? -ne 0 ]
  then
    rm -f ${UPD_PCKG}
    rm -f ${PKG}
    standalone_run_msg "Unexpected uncompress problem"
    exit 3
  fi

  # remove product package
  #--------------------------
  rm -f ${UPD_PCKG}
  if [ ! -d "${OMNI_HOME}" ]
  then
    mkdir -p "${OMNI_HOME}"
    chmod 755 "${OMNI_HOME}"
  fi

  rm -rf $OMNI_HOME/lib/nls/de.iso88591 2>/dev/null

  if [ "${PACKET}" = "Core" ]
  then
    CheckInstalledOBDP
    CheckDatabase
    INSTALLED_REV=`/opt/omni/bin/omnicc -ver 2>/dev/null | $AWK '{for(i=1;i<=NF;i+=1) {print $i}}' | grep "A\.[0-9]" | tr -d ": "`
    INSTALLED_PATCH=`cat /opt/omni/.patch_core 2>/dev/null`
    # get core revision from depot
    cd ${TOMNI}
    tar xf ${PKG} DATA-PROTECTOR/OMNI-CORE/opt/omni/.patch_core DATA-PROTECTOR/OMNI-CORE/opt/omni/bin/omnicc
    if [ -f /opt/omni/bin/omnicc ]
    then
      DEPOT_REV=`./DATA-PROTECTOR/OMNI-CORE/opt/omni/bin/omnicc -ver 2>/dev/null | $AWK '{for(i=1;i<=NF;i+=1) {print $i}}' | grep "A\.[0-9]" | tr -d ": "`
    fi
    DEPOT_PATCH=`cat DATA-PROTECTOR/OMNI-CORE/opt/omni/.patch_core 2>/dev/null`
    rm -rf DATA-PROTECTOR/OMNI-CORE/opt/omni/.patch_core

    if [ "${INSTALLED_REV}" = "${DEPOT_REV}" -a "${INSTALLED_PATCH}" = "${DEPOT_PATCH}" ]
    then
      /usr/sbin/swverify -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR.OMNI-CORE >/dev/null
      if [ $? -ne 0 ]
      then
       if [ "$SUBPRODUCT" = "AppRM" ]; then #AppRM
          /usr/sbin/swinstall -s ${PKG} -x reinstall=true -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR >/dev/null
       else #DP
          /usr/sbin/swinstall -s ${PKG} -x reinstall=true -x enforce_dependencies=false -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR >/dev/null
       fi
      fi
    else
       if [ "$SUBPRODUCT" = "AppRM" ]; then #AppRM
          /usr/sbin/swinstall -s ${PKG} -x reinstall=true -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR >/dev/null
       else #DP
          /usr/sbin/swinstall -s ${PKG} -x reinstall=true -x enforce_dependencies=false -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR >/dev/null
       fi
    fi
  elif [ "${PACKET}" = "emc" ]
  then
    if [ "`uname -a | grep "ia"`" ]
    then
      if [ ! -d /usr/lib/hpux64 ] || [ ! -d /usr/symcli/shlib ]
      then
        standalone_run_msg  "The EMC Symmetrix Agent cannot be properly installed and configured."
        standalone_run_msg  "Please ensure that EMC SYMAPI library is installed on the system and"
        standalone_run_msg  "restart the installation."
        exit 1
      else
        /usr/sbin/swinstall -s ${PKG} -x reinstall=true -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR >/dev/null
      fi
    else
      if [ ! -d /usr/lib ] || [ ! -d /usr/symcli/shlib ]
      then
        standalone_run_msg  "The EMC Symmetrix Agent cannot be properly installed and configured."
        standalone_run_msg  "Please ensure that EMC SYMAPI library is installed on the system and"
        standalone_run_msg  "restart the installation."
        exit  1
      else
        /usr/sbin/swinstall -s ${PKG} -x reinstall=true -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR >/dev/null
      fi
    fi
  else
    /usr/sbin/swinstall -s ${PKG} -x reinstall=true -x mount_all_filesystems=false -x logfile=/tmp/$PACKET-sd.log DATA-PROTECTOR >/dev/null
  fi

  if [ $? -eq 0 ]; then 
     standalone_run_msg "Data Protector software package successfully installed"
     rm -f ${PKG}
  else
     standalone_run_msg "Data Protector software package installation failed"
     standalone_run_msg "Check the log file /tmp/$PACKET-sd.log"
     rm -f ${PKG}
     exit 3
  fi

  if [ "$OPTS" = "erase_cell_server" -a ! -f /etc/opt/omni/server/cell/cell_info ]; then
    mv /etc/opt/omni/client/cell_server.tmp /etc/opt/omni/client/cell_server 2>/dev/null
  fi
}

EraseObsoleteFiles()
{ $Debug
  ObsoleteComponents="ACS FXMA FASTRAX DAS ORACLE"

  for Component in $ObsoleteComponents; do
    rm $OMNI_HOME/.CII_$Component 2>/dev/null
    rm $OMNI_HOME/.Version$Component 2>/dev/null
    rm $OMNI_HOME/${Component}.fileset 2>/dev/null
    Component=`echo "$Component" | tr [A-Z] [a-z]` 2>/dev/null
    rm $OMNI_HOME/.patch_$Component 2>/dev/null
  done

}

# ############################################################################
# script body
# ############################################################################
CMD=$0

if [ $# -lt 5 ]
then
  # usage error
  standalone_run_msg \
    "Usage: ${CMD} <omni_tmpdir>/packet.Z <packet> <version> <series> <home_dir> <cell_server> <port>"
  exit 4
fi

UPD_PCKG=$1   # name of ordinary tar fileset 
PACKET=$2     # packet name 
VERS=$3       # packet version
ARCH=$4       # supported architecture of fileset
OMNI_HOME=$5  # OmniBackII HOME directory
MGMT_SV=$6    # Cell server
PORT=$7       # Port number used by Data protector cell
OPTS=$8       # other options

EraseObsoleteFiles


#added by jozeand (user can write component info as he wants, no key sensitive anymore)
if [ "$PACKET" = "CORE" ] || [ "$PACKET" = "core" ];then
    PACKET="Core"
fi

if [ "$PACKET" = "ORACLE8" ] || [ "$PACKET" = "Oracle8" ];then
    PACKET="oracle8"
fi

if [ "$PACKET" = "CC" ] || [ "$PACKET" = "Cc" ];then
    PACKET="cc"
fi

if [ "$PACKET" = "MA" ] || [ "$PACKET" = "Ma" ];then
    PACKET="ma"
fi

if [ "$PACKET" = "DA" ] || [ "$PACKET" = "Da" ];then
    PACKET="da"
fi

# determine series and name of fileset
# ####################################
case ${ARCH} in
    ibm/rs6000/aix*|sgi/mips/irix*|siemens/r400/sinix*|sco/i386/sco_sv|sco/i386/unixware|hp/*)
    INFO_DIR=${OMNI_HOME}/bin/install
    OMNI_LBIN=${OMNI_HOME}/bin
    OMNI_BIN=${OMNI_HOME}/bin
    OMNI_LOG=${OMNI_HOME}/log
    TAR_SWITCHES="-xf"
    ;;

    sun/*)
    INFO_DIR=${OMNI_HOME}/bin/install
    OMNI_LBIN=${OMNI_HOME}/bin
    OMNI_BIN=${OMNI_HOME}/bin
    OMNI_LOG=${OMNI_HOME}/log
    TAR_SWITCHES="-xf"
    AWK=nawk
    ;;

    dec/alpha/osf1*)
    INFO_DIR=${OMNI_HOME}/bin/install
    OMNI_LBIN=${OMNI_HOME}/bin
    OMNI_BIN=${OMNI_HOME}/bin
    OMNI_LOG=${OMNI_HOME}/log
    TAR_SWITCHES="xpf"
    ;;

    gpl/i386/linux*|gpl/ia64/linux*|gpl/x86_64/linux*)
    INFO_DIR=${OMNI_HOME}/bin/install
    OMNI_LBIN=${OMNI_HOME}/bin
    OMNI_BIN=${OMNI_HOME}/bin
    OMNI_LOG=${OMNI_HOME}/log
    TAR_SWITCHES="-xpf"
    ;;

  *) # unexpected series
    standalone_run_msg "Unexpected series ${ARCH}"
    exit 5
    ;;
esac

if [ "$PACKET" = "Core" ]; then
  rm $OMNI_HOME/bin/omniamo 2>/dev/null
  rm $OMNI_HOME/bin/omnihealthcheck 2>/dev/null
  if [ ! -f $OMNI_HOME/.patch_cs ]; then
    rm -f $OMNI_HOME/bin/omnikeytool 2>/dev/null
  fi
fi

case ${ARCH} in 
  sun/*)
    InstallSolaris
    ;;
  gpl/*)
    InstallLinux
    ;;
  hp/*)
    InstallHPUX
    ;;
  *)
    InstallGeneric
    ;;
esac

exit 0

#==============================================================================
# End of file: omni_rinst.sh
#==============================================================================
