#!/sbin/sh
###############################################################################
#
#     (c) Copyright 1993, Hewlett-Packard NSMD, all rights reserved.
#
#     PACKAGE      HP OpenView OmniBackII
#     FILE         omni_de_rinst.sh
#     RCS          $Header: /ob/src/shell/inst/remote/sup/omni_de_inst.sh /main/hsl_dp61/8 2008-07-28 15:58:54 seidh $
#
#     USAGE
#        omni_de_inst.sh   <series> <homedir> 
#        <series>          ibm/rs6000/aix  sun/sparc/solaris sun/sparc/sunos
#                          dec/alpha/irix  sgi/mips/irix siemens/r400/sinix
#                          sco/i386/sco_sv ...
#        <homedir>         OmniBackII HOME directory 
# 
#     DESCRIPTION
#        Deinstall OmniBack II software from the host
#
###############################################################################
#
#     RETURNS    
# 
# Exit values of this script
# ##########################
#   0  OmniBackII software package successfully installed
#   1  WILL NEVER BE SET EXPLICTLY !!!
#   2  WILL NEVER BE SET EXPLICTLY !!!
#   3  usage error
#   4  unsupported arch specified
# #############################################################################
#set -x
# OmniBackII tmp directory
# ########################
TOMNI=/tmp/omni_tmp

standalone_run_msg()
{
  MSG="$*"
  echo ${MSG} 1>&2
}

# Generic deinst script
clean()
{
  for file in ${SERVICES} ${INETDCONF}; do
    awk '{if(($1 != "omni_" && $1 != SERV) && $2 != "DATA-PROTECTOR") {print}} ' SERV=${SERVICE} ${file} > ${TMP}
    cp ${TMP} ${file}
    rm ${TMP}
  done
  if [ ${XINETDFILE} ]; then
    if [ "${XINETDFILE}" != "/etc/xinetd.conf" ]; then
      rm ${XINETDFILE}
    else
      sed /^"service omni"$/,/^$/d ${XINETDFILE} > /${TOMNI}/new.xinetd.conf
      mv /${TOMNI}/new.xinetd.conf ${XINETDFILE}
    fi
  fi
}

# Solaris deinst function
select_packages()
{ 
  to_remove=""

  for pkg in `/usr/bin/pkginfo -c omniback | awk '{ print $2 }'`
  do
    if [ "${pkg}" != "OB2-CORE" ]; then
      if [ "${pkg}" = "OB2-INTG" ]; then
        RemoveInteg=1
      else
        if [ "${pkg}" = "OB2-PEGASUS" ]; then
          RemovePegasus=1
        else
          if [ "${pkg}" = "OB2-CC" ]; then
            RemoveCC=1
          else
            if [ "${pkg}" = "OB2-MA" ]; then
              RemoveMA=1
            else
              if [ "${pkg}" = "OB2-C-IS" ]; then
                RemoveCIS=1
              else
                if [ "${pkg}" = "OB2-INTGP" ]; then
                  RemoveINTEGP=1
                else
                  if [ "${pkg}" = "OB2-PEGP" ]; then
                    RemovePEGP=1
                  else
                    to_remove="${to_remove} ${pkg}"
                  fi
                fi
              fi
            fi
          fi
        fi
      fi
    else
       RemoveCore=1
    fi
  done
    if [ "${RemovePEGP}" = "1" ]; then
      to_remove="${to_remove} OB2-PEGP"
    fi
    if [ "${RemoveINTEGP}" = "1" ]; then
      to_remove="${to_remove} OB2-INTGP"
    fi
    if [ "${RemoveCIS}" = "1" ]; then
      to_remove="${to_remove} OB2-C-IS"
    fi
    if [ "${RemoveMA}" = "1" ]; then
      to_remove="${to_remove} OB2-MA"
    fi
    if [ "${RemovePegasus}" = "1" ]; then
      to_remove="${to_remove} OB2-PEGASUS"
    fi
    if [ "${RemoveInteg}" = "1" ]; then
      to_remove="${to_remove} OB2-INTG"
    fi
    if [ "${RemoveCC}" = "1" ]; then
      to_remove="${to_remove} OB2-CC"
    fi
    if [ "${RemoveCore}" = "1" ]; then
      to_remove="${to_remove} OB2-CORE"
    fi
  echo ${to_remove}
}


# Linux deinst function
Linux_select_packages()
{
  to_remove=""
  for pkg in `rpm -qg Data-Protector`
  do
  pkg=`echo ${pkg} | awk -F"[\-]" '{ if ($3~/A./)  {print $1  "-"  $2 } else {print $1  "-"  $2 "-" $3 }}'`
    if [ "${pkg}" != "OB2-CORE" ]; then
      if [ "${pkg}" = "OB2-INTEG" ]; then
        RemoveInteg=1
      else
        if [ "${pkg}" = "OB2-PEGASUS" ]; then
          RemovePegasus=1
        else
          if [ "${pkg}" = "OB2-CC" ]; then
            RemoveCC=1
          else
            if [ "${pkg}" = "OB2-MA" ]; then
              RemoveMA=1
            else
              if [ "${pkg}" = "OB2-CORE-IS" ]; then
                RemoveCIS=1
              else
                if [ "${pkg}" = "OB2-INTEGP" ]; then
                  RemoveINTEGP=1
                else
                  if [ "${pkg}" = "OB2-PEGP" ]; then
                    RemovePEGP=1
                  else
                    to_remove="${to_remove} ${pkg}"
                  fi
                fi
              fi
            fi
          fi
        fi
      fi
    else
       RemoveCore=1
    fi
  done
    if [ "${RemovePEGP}" = "1" ]; then
      to_remove="${to_remove} OB2-PEGP"
    fi
    if [ "${RemoveINTEGP}" = "1" ]; then
      to_remove="${to_remove} OB2-INTEGP"
    fi
    if [ "${RemoveCIS}" = "1" ]; then
      to_remove="${to_remove} OB2-CORE-IS"
    fi
    if [ "${RemovePegasus}" = "1" ]; then
      to_remove="${to_remove} OB2-PEGASUS"
    fi
    if [ "${RemoveMA}" = "1" ]; then
      to_remove="${to_remove} OB2-MA"
    fi
    if [ "${RemoveInteg}" = "1" ]; then
      to_remove="${to_remove} OB2-INTEG"
    fi
    if [ "${RemoveCC}" = "1" ]; then
      to_remove="${to_remove} OB2-CC"
    fi
    if [ "${RemoveCore}" = "1" ]; then
      to_remove="${to_remove} OB2-CORE"
    fi
        echo ${to_remove}
}

Deinstall_Generic()
{
  # The service file
  # ################
  SERVICES=/etc/services            
  
  # Configuration file for inetd 
  # ############################
  if [ -f /etc/inetd.conf ]; then
    INETDCONF=/etc/inetd.conf
  fi
  
  if [ -f /etc/xinetd.conf ]; then
    XINETDFILE=`cat /etc/xinetd.conf | grep includedir | awk '{ print $2 }'`
    if [ "${XINETDFILE}" != "" ]; then
      XINETDFILE=${XINETDFILE}/omni
    else
      XINETDFILE="/etc/xinetd.conf"
    fi
  fi
  
  SERVICE=omni
  
  # Temporary files 
  # ###############
  TMP=${TOMNI}/inst.tmp      
  
  if [ $# -lt 2 ]
  then
    # usage error
    standalone_run_msg \
      "Usage: ${CMD} <series> <home_dir>" 
    exit 3
  fi
  
  OMNI_CONFIG=${OMNI_HOME}/config
  if [ -f ${OMNI_CONFIG}/cell/omni_info ]; then
    VERS_FILE=${OMNI_CONFIG}/cell/omni_info
  else
    VERS_FILE=${OMNI_CONFIG}/client/omni_info    
  fi
  
  # determine which packets are installed
  # #####################################
  
  LISTFILES=`ls ${OMNI_HOME}/*.fileset`
  
  cd ${OMNI_HOME} 
  
  # just files in filelist will be removed
  # ######################################
  if [ -d ${OMNI_HOME} -a "$LISTFILES" != "" ]
  then
    cat ${LISTFILES} | xargs rm -rf
  fi
  
  # remove cell_server file
  # ########################
  if [ -f ${OMNI_CONFIG}/client/cell_server ] 
  then
    rm -f ${OMNI_CONFIG}/client/cell_server
  elif [ -f {OMNI_CONFIG}/cell/cell_server ]; then
    rm -f {OMNI_CONFIG}/cell/cell_server
  fi
  
  cd /
  
  # remove omni_info file
  # #####################
  if [ -f "${VERS_FILE}" ]
  then
    rm ${VERS_FILE}
  fi
  
  clean   # cleaning /etc/services and /etc/inetd.conf 
  
  # remove omnibackII home dir 
  # ##########################
  rm -rf ${OMNI_HOME}/*
  rm -rf ${OMNI_HOME}/.[A-Z]*
  rm -rf ${OMNI_HOME}/.[a-z]*
  
  standalone_run_msg "Data Protector software package successfully deinstalled"
  exit 0
}

Deinstall_Solaris()
{
  # Admin file
  # ---------------
  ADMIN_FILE=${TOMNI}/admin
  
  # Debug file
  # ---------------
  DEBUG_FILE=/var/tmp/omni.debug
  
  if [ -f ${DEBUG_FILE} ]
  then
    OPTIONS="-nv"
  else
    OPTIONS="-n"
  fi

  PKGS=`select_packages`
  retCode=0
  if [ "${PKGS}" != "" ]; then
    /usr/sbin/pkgrm ${OPTIONS} -a ${ADMIN_FILE} ${PKGS} > /var/tmp/OmniBack_pkgrm.log 2>&1
    retCode=$?
  fi
  
  if [ ${retCode} -eq 0 ]; then
     standalone_run_msg "Data Protector software successfully deinstalled"
     exit 0
  else
     standalone_run_msg "Data Protector software deinstallation failed" 
     standalone_run_msg "Check file /var/tmp/OmniBack_pkgrm.log"
     exit 3
  fi
}

Deinstall_Linux()
{
  # Debug file
  # ---------------
  DEBUG_FILE=/var/tmp/omni.debug
  if [ -f ${DEBUG_FILE} ]
  then
    OPTIONS="-nv"
  else
    OPTIONS="-n"
  fi
  PKGS=`Linux_select_packages`

  #This code is to check if the PKGS contain meaningful
  #rpm packages. If not it is made as null.
  echo ${PKGS} > ${TOMNI}/ob2_packages
  grep -i ob2 ${TOMNI}/ob2_packages
  if [ $? -ne 0 ]
  then
    PKGS=""
  fi
  rm -f ${TOMNI}/ob2_packages

  retCode=0
  if [ "${PKGS}" != "" ]; then
  echo  "Removing ${PKGS}" > /tmp/OmniBack_rpmrm.log
   for i in ${PKGS}; do
    echo  "Removing ${i}" >> /tmp/OmniBack_rpmrm.log
    rpm -e ${i} >> /tmp/OmniBack_rpmrm.log 2>&1
   done
   retCode=$?
  fi

  if [ ${retCode} -eq 0 ]; then
     # Delete DP 5.5 /usr/omni
     if [ -d /usr/omni ]
     then
        OMNI_HOME=/usr/omni
        Deinstall_Generic $*
     fi
     standalone_run_msg "Data Protector software successfully deinstalled"
     exit 0
  else
     standalone_run_msg "Data Protector software deinstallation failed"
     standalone_run_msg "Check file /tmp/OmniBack_rpmrm.log"
     exit 3
  fi
}

Deinstall_HPUX()
{
  /usr/sbin/swremove -x logfile=/tmp/OmniBack_sd.log -x mount_all_filesystems=false DATA-PROTECTOR 1>/dev/null 2>&1
  if [ $? -eq 0 ]; then
    standalone_run_msg "Data Protector software successfully deinstalled"
  else
    standalone_run_msg "Data Protector software deinstallation failed"
    standalone_run_msg "Check file /tmp/OmniBack_sd.log"
  fi

  exit ${EXIT}
}



#==============================================================================
# script body
#==============================================================================


CMD=$0
ARCH=$1       # supported architecture of fileset
OMNI_HOME=$2   # OmniBackII HOME directory

case "${ARCH}" in
  sun/*)
    Deinstall_Solaris
    ;;
  hp/*)
    Deinstall_HPUX
    ;;
  gpl/*)
    Deinstall_Linux $*
    ;;
  *)
    Deinstall_Generic $*
    ;;
esac


#==============================================================================
# End of file: omni_de_inst.sh
#==============================================================================

