#!/bin/sh
# /usr/sbin/noris-apt.sh

# This script informs you about available updates. It performs a simple
# ordering simulation.
# See the apt-get(8), sources.list(5) and apt.conf(5) manual
# pages for more information and options.
# It is invoked by /etc/cron.d/noris-dedicated-common
# Original written by Hardy Kestin <hardy@noris.net>
# mse changes by Markus Laube <laubi@noris.net>

PATH=/usr/bin:/bin:/usr/sbin:/sbin
RCPT="managed-root@noris.net"

HOST=`hostname -f`
MSECONF="/etc/update-ticket.conf"

function noris_mailheader() {
		
	echo "From: <root@${HOST}>"
	echo "To: ${RCPT}"
	echo "Subject: ${SUBJECT}"
	echo "X-noris-Ticket-Autoreply: no"
	[ -n "${OTRSTYPE}" ] && echo "X-noris-Ticket-Type: ${OTRSTYPE}"
	[ -n "${OTRSVIEW}" ] && echo "X-noris-Ticket-ArticleType: ${OTRSVIEW}"
	[ -n "${OTRSMSID}" ] && echo "${OTRSMSID}"
}

function noris_apt_default () {
	apt-get update -qq > /dev/null 2>&1 && \
	apt-get upgrade -qqs 2>&1 | grep -v Conf | mail -e -s "Update info for $HOST" "$RCPT"
	exit 0
}


function noris_apt_mse () {

	MASTER="`grep ^MASTER ${MSECONF} | awk '{print$2}'`" &> /dev/null	; [ -n "${MASTER}" ] || MASTER="${HOST}"
	HOSTGROUP="`grep ^GROUP ${MSECONF} | awk '{print$2}'`" &> /dev/null	; [ -n "${HOSTGROUP}" ] || HOSTGROUP="${HOST}"
	TICKETID="cron.updatejob-`date +%Y%m%d%H%M`@${MASTER}"
	OTRSTYPE="`grep ^OTRSTYPE ${MSECONF} | awk '{print$2}'`" &> /dev/null 	; [ -n "${OTRSTYPE}" ] || OTRSTYPE="change::noris"
	OTRSVIEW="`grep ^OTRSVIEW ${MSECONF} | awk '{print$2}'`" &> /dev/null	; [ "extern" = "${OTRSVIEW}" ] || OTRSVIEW="intern"
	MSEFILE="`grep ^TEMPFILE ${MSECONF} | awk '{print$2}'`" &> /dev/null	; [ -n "${MSEFILE}" ] || MSEFILE="/var/tmp/$(basename $0).temp"

	[ ${MASTER} = ${HOST} ]                && OTRSMSID="Message-ID: <${TICKETID}>"  && SUBJECT="Update Info for ${HOSTGROUP}"
	[ ${MASTER} != ${HOST} ] && sleep 100  && OTRSMSID="In-Reply-To: <${TICKETID}>" && SUBJECT="Update Info for ${HOST}" ;

	errput=$(apt-get update -qq 2>&1 1>/dev/null)
	output=$(apt-get upgrade -qqs 2>&1 | grep -v Conf)
	md5old=$(cat ${MSEFILE} 2> /dev/null)
	md5new=$(echo "${output}" | md5sum)

	# Mail versenden

        if [ "${md5old}" != "${md5new}" ] ; then
		echo "${md5new}" > ${MSEFILE}
		[ -n "$output" ] && var_header="$(noris_mailheader)" && echo -e "${var_header}\n\n${output}" | sendmail -t
	fi
	
	# Fehlerbericht versenden
	SUBJECT="Fehlerausgabe for $(basename $0) on ${HOSTGROUP}"
	[ -n "$errput" ] && var_header="$(noris_mailheader)" && echo -e "${var_header}\n\n${errput}" | sendmail -t
	exit 0

}


if [ -f ${MSECONF} ]; then
	noris_apt_mse
else
	noris_apt_default
fi
