use Test::More tests => 7; $|=1;

use Algorithm::Diff::Cheap;

sub _test($$$$) {
	my($a,$b,$lim,$res) = @_;
	my @a = split(//,$a);
	my @b = split(//,$b);
	my $na = sub {
		return undef unless @a;
		shift @a;
	};
	my $nb = sub {
		return undef unless @b;
		shift @b;
	};
	my $di = Algorithm::Diff::Cheap->new($na,$nb, Blocksize=>$lim);
	my $rres = "";
	while(my($k,$v) = $di->Next()) {
		my $nk = shift @res;
		my $nv = shift @res;
		$rres .= $k.$v;
	}
	is $rres,$res,"$a / $b";
}
sub testrun {
	_test("abc","abc",1," a b c");
	_test("xyabc","abcde",1,"-x-y a b c+d+e");
	_test("abcde","xyabc",1,"+x+y a b c-d-e");
	_test("..a..b..c..d..e..","..a..b..c..d..e..",3," . . a . . b . . c . . d . . e . .");
	_test("..a..c..d..e..","..a..b..c..d..x..y..e..",1," . . a . .-c+b . .-d+c . .-e+d . .+x+.+.+y+.+.+e+.+.");
	_test("..a..c..d..e..","..a..b..c..d..x..y..e..",3," . . a . .+b+.+. c . . d . .+x+.+.+y+.+. e . .");
	_test("abcde","axcde",1," a-b+x c d e");
}

testrun();
