/* Generated By:JavaCC: Do not edit this line. ScriptParser.java */
package devmgr.v1035api01.sam.scriptengine;

import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;
import devmgr.trace.*;
import devmgr.v1035api01.symbol.*;
import devmgr.v1035api01.sam.jal.*;
import devmgr.v1035api01.sam.util.*;
import devmgr.v1035api01.sam.scriptengine.ParseException;

public class ScriptParser implements ScriptParserConstants {
   private static final String CLI_LOW_OVERHEAD_MODE = "CLI_LOW_OVERHEAD_MODE";

   // Used to build up attribute/value pairs for set commands.
   private Vector                m_AttributePairList = new Vector();

   // Used to build up attribute list for show commnds.
   private  Vector               m_AttributeList = new Vector();

   // Used for list of drives in drive commands.
   private Vector                m_DriveList = new Vector();

   // Used for list of drives in drive commands.
   private Vector                m_ReplacementDriveList = new Vector();

   // Used for list of drive channels in drive channel commands.
   private Vector                m_DriveChannelList = new Vector();

   // Used for list of user labels/names of volumes in volumes commands.
   private Vector                m_NameSpecList = new Vector();


   // Used for a list of tray IDs separated by space.
   private Vector                m_TrayIdList = new Vector();

   // Used for executing commands
   private ExecutorUtils                 m_ExecutorUtils;
   private SnapshotExecutor              m_SnapshotExecutor;
   private VolumeGroupExecutor           m_VolumeGroupExecutor;
   private DriveExecutor                 m_DriveExecutor;
   private TrayExecutor                  m_TrayExecutor;
   private VolumeExecutor                m_VolumeExecutor;
   private ControllerExecutor            m_ControllerExecutor;
   private SArrayExecutor                m_SArrayExecutor;
   private HostTopologyExecutor          m_HostTopologyExecutor;
   private RVMExecutor                   m_RVMExecutor;
   private IscsiExecutor                 m_IscsiExecutor;

   private StorageArrayFacade            m_Facade;


   // If this is true then no actions will be performed, only syntax checking will occur.
   private boolean               m_SyntaxCheckOnly = false;

   private boolean               m_ScriptCanceled = false;
   private ASCII_CharStream      m_CharStream = null;

   ParseException                m_ParseException = null;

   private VolumeMapping         m_VolumeMapping = new VolumeMapping();

   private boolean               m_IsLowOverheadMode = false;
   private boolean               m_IsFaultIsolationDiagnosticsRun = false;

   // Static constants for legal percentage value ranges.
   private static final int      WARNING_THRESH_PERCENT_MIN = 1;
   private static final int      WARNING_THRESH_PERCENT_MAX = 100;
   private static final int      REPOSITORY_PERCENT_BASE_MIN = 1;
   private static final int      REPOSITORY_PERCENT_BASE_MAX = 120;
   private static final int      PERF_MON_INTERVAL_MIN = 3;
   private static final int      PERF_MON_INTERVAL_MAX = 3600;
   private static final int      PERF_MON_ITERATIONS_MIN = 1;
   private static final int      PERF_MON_ITERATIONS_MAX = 3600;
   private static final int      DELETE_ALL_VOLUMES = 1;
   private static final int      DELETE_ONE_VOLUME = 2;
   private static final int      DELETE_LIST_VOLUMES = 3;

   // Static final string for the hex prefix.
   private static final String   HEX_PREFIX = "0x";

   //Drive download mode
   private static final int      DRIVE_DOWNLOAD_MODE_FAILEDONLY = 1;

   //mixed drive - auto config support
   private static final int              AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE = -1;

   /**
   DESCRIPTION: <BR>
   Public constructor used by the ScriptEngine object to create a ScriptParser
   object. Calls the constructor in the generated file ScriptParser.java.
   <BR><BR>

   @param stream     Character stream used by the ScriptParserTokenManager for input.
   @param executor   CommandExecutor to use for communication with storage array.
   */
   public ScriptParser(CharStream stream, StorageArrayFacade facade, Writer writer,
         ExecutorUtils executorUtils)
   {
      // Call constructor in generated code with the CharStream
      this( stream );

      m_IsLowOverheadMode = System.getProperty(CLI_LOW_OVERHEAD_MODE) != null;

      m_CharStream = (ASCII_CharStream) stream;
      m_Facade = facade;
      m_ExecutorUtils = executorUtils;
      m_ExecutorUtils.setStorageArrayFacade(m_Facade);
      m_ExecutorUtils.setWriter(writer);
      m_ExecutorUtils.setParser(this);
      m_SnapshotExecutor = new SnapshotExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_VolumeGroupExecutor = new VolumeGroupExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_DriveExecutor = new DriveExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_TrayExecutor = new TrayExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_VolumeExecutor = new VolumeExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_ControllerExecutor = new ControllerExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_SArrayExecutor = new SArrayExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_HostTopologyExecutor = new HostTopologyExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_RVMExecutor = new RVMExecutor(m_Facade, this, writer, m_ExecutorUtils);
      m_IscsiExecutor = new IscsiExecutor(m_Facade, this, writer, m_ExecutorUtils);

      // If we're running on CLI low overhead mode, prevent reloading the object bundle before the 
      //first command.  We should be up to date with the bundle fetch from the coupler startup.
      if (m_IsLowOverheadMode)
      {
         m_ExecutorUtils.setNoRefreshNeeded(true);
      }
   }


   /**
   DESCRIPTION: <BR>
   Returns the current SnapshotExecutor. <BR>
   
   @return SnapshotExecutor the snapshot executor.
   */
   SnapshotExecutor getSnapshotExecutor()
   {
      return m_SnapshotExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current VolumeGroupExecutor. <BR>
   
   @return VolumeGroupExecutor the volumegroup executor.
   */
   VolumeGroupExecutor getVolumeGroupExecutor()
   {
      return m_VolumeGroupExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current DriveExecutor. <BR>
   
   @return DriveExecutor the Drive executor.
   */
   DriveExecutor getDriveExecutor()
   {
      return m_DriveExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current TrayExecutor. <BR>
   
   @return TrayExecutor the Tray executor.
   */
   TrayExecutor getTrayExecutor()
   {
      return m_TrayExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current VolumeExecutor. <BR>
   
   @return VolumeExecutor the Volume executor.
   */
   VolumeExecutor getVolumeExecutor()
   {
      return m_VolumeExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current ControllerExecutor. <BR>
   
   @return ControllerExecutor the controller executor.
   */
   ControllerExecutor getControllerExecutor()
   {
      return m_ControllerExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current SArrayExecutor. <BR>
   
   @return SArrayExecutor the SArray executor.
   */
   SArrayExecutor getSArrayExecutor()
   {
      return m_SArrayExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current RVMExecutor. <BR>
   
   @return RVMExecutor the RVM executor.
   */
   RVMExecutor getRVMExecutor()
   {
      return m_RVMExecutor;
   }
   /**
   DESCRIPTION: <BR>
   Returns the current HostTopologyExecutor. <BR>
   
   @return HostTopologyExecutor the Host topology executor.
   */
   HostTopologyExecutor getHostTopologyExecutor()
   {
      return m_HostTopologyExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current IscsiExecutor. <BR>
   
   @return IscsiExecutor the Iscsi topology executor.
   */
   IscsiExecutor getIscsiExecutor()
   {
      return m_IscsiExecutor;
   }

   /**
   DESCRIPTION: <BR>
   Returns the current line from the CharStream that is being parsed. It is
   added here to allow the CommandExecutor to call back and get the line number
   for error reporting.
   <BR><BR>

   @return int       Current line number of input being parsed.
   */
   int getLine()
   {
      return m_CharStream.getEndLine();
   }


   /**
   DESCRIPTION: <BR>
   Returns the last complete command parsed from the input character stream.  Used
   so that the CommandExecutor can access the command context to print after an 
   execution error.
   <BR><BR>

   @return String   The last command executed.
   */
   public String getLastCommand()
   {
      return m_CharStream.getLastCommand();
   }


   /**
   DESCRIPTION: <BR>
   Called to reset the ScriptParser to valid values for script execution or parsing.
   Calls the ReInit(stream) method in the generated code.  Resets the global list
   vectors to eliminate any stale data from a previous parse or execution.
   <BR><BR>

   @param stream     CharStream to pass on the ScriptParserTokenManager for reading input.
   */
   public void initialize(CharStream stream)
   {
     m_SyntaxCheckOnly = false;
     m_ScriptCanceled = false;
     m_CharStream = (ASCII_CharStream) stream;
     ReInit(stream);
   }


   /**
   DESCRIPTION: <BR>
   Cancels script execution. Setting m_ScriptCanceled to false cancels script
   execution after the current command has completed.  This value is checked
   after each "statement" is parsed. If it is true the statement() method returns
   stopping further commands from executing.
   <BR><BR>
   */
   public void cancel()
   {
      m_ScriptCanceled = true;
      if (m_IsFaultIsolationDiagnosticsRun)
      {
         if ( !m_SyntaxCheckOnly )
         {
       /*  
            try
            {
               m_Facade.stopChannelDiagnostics();
            }
            catch (Exception e)
            {
               //do nothing, all we can do is to try to cancel the operation
               //cannot show any message at this point
            }
      */
         }
      }
   }


   /**
   DESCRIPTION: <BR>
   Created to catch any lexical errors.  Sets the m_SyntaxCheckOnly and m_ScriptCanceled
   flags. Sets the setStopOnError flag of the executor to false which is the default
   state for script execution.

   @param flag   Flag to set the m_SyntaxCheckOnly variable to.
   @return int   Returns status of canceled or not canceled.
   <BR><BR>
   */
   public int execute(boolean flag) throws ScriptException
   {
      int      returnCode = ScriptEngine.SCRIPT_COMPLETE;

      m_SyntaxCheckOnly = flag;
      m_ScriptCanceled = false;
      m_ExecutorUtils.setStopOnError(false);

      try
      {
         returnCode = execute();
      }
      catch (TokenMgrError e)
      {
         if (token_source.curLexState == LOCKDOWN)
         {
            throw new ParseException(Resource.getString("SE_LOCKDOWN_TOKEN_ERROR"));
         }
         else
         {
            throw new ParseException(e.getMessage());
         }
      }
      finally
      {
         // Clear the global vectors after each statement is parsed.
         m_AttributePairList.clear();
         m_AttributeList.clear();
         m_DriveList.clear();
         m_TrayIdList.clear();
         m_NameSpecList.clear();
         m_DriveChannelList.clear();
         m_VolumeMapping = new VolumeMapping();
      }

      return returnCode;
   }


   /**
   DESCRIPTION: <BR>
   Maps a double to the appropriate cache flush modifier value.  Returns -1 of
   the value is not valid.

   @param val     Double to map to a cache flush modifier value.
   @return int    Cache flush modifier value or -1 if not valid.
   <BR><BR>
   */
   private int getCacheFlushModifierValue(double val)
   {
      int         returnVal = 0;

      if ( val == 0 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_IMMEDIATE;
      }
      else if ( val == .25 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_250_MSEC;
      }
      else if ( val == .5 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_500_MSEC;
      }
      else if ( val == .75 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_750_MSEC;
      }
      else if ( val == 1 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_1_SEC;
      }
      else if ( val == 1.5 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_1500_MSEC;
      }
      else if ( val == 2 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_2_SEC;
      }
      else if ( val == 5 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_5_SEC;
      }
      else if ( val == 10 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_10_SEC;
      }
      else if ( val == 20 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_20_SEC;
      }
      else if ( val == 60 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_60_SEC;
      }
      else if ( val == 120 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_120_SEC;
      }
      else if ( val == 300 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_300_SEC;
      }
      else if ( val == 1200 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_1200_SEC;
      }
      else if ( val == 3600 )
      {
         returnVal = CacheFlushModifier.CACHE_FLUSH_3600_SEC;
      }
      else
      {
         returnVal = -1;
      }

      return returnVal;
   }

   /**
   User defined label should not contain special
   characters except dash and underscore.

   @param string     string to be checked for the allowed characters
   */
   private String userDefinedLabel(String string) throws ParseException
   {
      Object[]    args = new Object[2];
      String      errorString = null;

      //Ck for a 0x00 (Null) thru 0x22 (")
      for (int i = 0x00; i <= 0x22; i++)
      {
         if (string.indexOf(i) >=0)
         {
                args[0] = Integer.toString(getLine());
                args[1] = new Character(string.charAt(string.indexOf(i))).toString();
                errorString = MessageFormat.format(
                Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_ILLEGAL_CHARACTER"), args);
                m_ParseException = new ParseException(errorString);
                      throw m_ParseException;
         }
      }

      //skip 0x23 character (#)

      //Ck for a 0x24($) thru 0x2c (,)
      for (int i = 0x24; i <= 0x2c; i++)
      {
         if (string.indexOf(i) >=0)
         {
                args[0] = Integer.toString(getLine());
                args[1] = new Character(string.charAt(string.indexOf(i))).toString();
                errorString = MessageFormat.format(
                Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_ILLEGAL_CHARACTER"), args);
                m_ParseException = new ParseException(errorString);
                      throw m_ParseException;
         }
      }

      //skip ox2d character dash(-)

      //Ck for a 0x2e (.) thru 0x2f (/)
      for (int i = 0x2e; i <= 0x2f; i++)
      {
         if (string.indexOf(i) >=0)
         {
                args[0] = Integer.toString(getLine());
                args[1] = new Character(string.charAt(string.indexOf(i))).toString();
                errorString = MessageFormat.format(
                Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_ILLEGAL_CHARACTER"), args);
                m_ParseException = new ParseException(errorString);
                      throw m_ParseException;
         }
      }

      //Ck for a 0x3a (;) thru 0x40 (@)
      for (int i = 0x3a; i <= 0x40; i++)
      {
         if (string.indexOf(i) >=0)
         {
            args[0] = Integer.toString(getLine());
                args[1] = new Character(string.charAt(string.indexOf(i))).toString();
                errorString = MessageFormat.format(
                Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_ILLEGAL_CHARACTER"), args);
                m_ParseException = new ParseException(errorString);
                      throw m_ParseException;
         }
      }

      //Ck for a 0x5b ([) thru 0x5e (^)
      for (int i = 0x5b; i <= 0x5e; i++)
      {
         if (string.indexOf(i) >=0)
         {
                args[0] = Integer.toString(getLine());
                args[1] = new Character(string.charAt(string.indexOf(i))).toString();
                errorString = MessageFormat.format(
                Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_ILLEGAL_CHARACTER"), args);
                m_ParseException = new ParseException(errorString);
                      throw m_ParseException;
         }
      }

      //skip 0x5f character underscore(_)

      //Ck 0x60 (`)
      if (string.indexOf(0x60) >=0)
      {
        args[0] = Integer.toString(getLine());
         args[1] = new Character(string.charAt(string.indexOf(0x60))).toString();
         errorString = MessageFormat.format(
         Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_ILLEGAL_CHARACTER"), args);
         m_ParseException = new ParseException(errorString);
                   throw m_ParseException;
      }

      //Ck for a 0x7b ({) thru 0x7f (DEL)
      for (int i = 0x7b; i <= 0x7f; i++)
      {
         if (string.indexOf(i) >=0)
         {
                args[0] = Integer.toString(getLine());
                args[1] = new Character(string.charAt(string.indexOf(i))).toString();
                errorString = MessageFormat.format(
                Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_ILLEGAL_CHARACTER"), args);
                m_ParseException = new ParseException(errorString);
                    throw m_ParseException;
         }
      }
      return string;
   }

   /**
   DESCRIPTION: <BR>
   Update the lexical state based on current controller state.
   <BR><BR>

   NOTES/ASSUMPTIONS: <BR>
   Care must be taken when calling this method.  We must ensure that it is called
   before or after a complete command has been parsed as changing lexical states from parser code 
   while reading tokens can cause unwanted behavior in the presence of large lookaheads.
   <BR><BR>
   */
   void updateLexicalState()
   {
      if (token_source.curLexState != LOCKDOWN && m_Facade.isLockedDown())
      {
         Trace.println(Trace.SCRIPT, "Switching to LOCKDOWN lexical state");
         token_source.SwitchTo(LOCKDOWN);
      }
      else if (token_source.curLexState != DEFAULT && !m_Facade.isLockedDown())
      {
         Trace.println(Trace.SCRIPT, "Switching to DEFAULT lexical state");
         token_source.SwitchTo(DEFAULT);
      }
   }

/**
DESCRIPTION: <BR>
Main construct for grammar. Called by the ScriptEngine to start parsing or execution.
The value of the boolean flag will determine whether we are syntax checking or executing.
<BR><BR>
*/
  final public int execute() throws ParseException, ScriptException {
   int   returnCode = ScriptEngine.SCRIPT_COMPLETE;
    returnCode = statementList();
      {if (true) return returnCode;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
A statementList is one or more statements followed by and EOF.
<BR><BR>

NOTES/ASSUMPTIONS: <BR>
Care must be taken with the updateLexicalState method call.  We must ensure that it is called
before or after a complete command has been parsed as changing lexical states from parser code while
reading tokens can cause unwanted behavior in the presence of large lookaheads.
<BR><BR>
*/
  final public int statementList() throws ParseException, ScriptException {
   // Update the lexical state based on current controller state
   updateLexicalState();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOWNLOAD:
      case SHOW:
      case DELETE:
      case UPLOAD:
      case CREATE:
      case SET:
      case RESET:
      case ON:
      case USE:
      case START:
      case STOP:
      case REMOVE:
      case DISABLE:
      case ENABLE:
      case SAVE:
      case CLEAR:
      case DIAGNOSE:
      case REVIVE:
      case ACTIVATE:
      case DEACTIVATE:
      case RECOPY:
      case RECREATE:
      case AUTOCONFIGURE:
      case SUSPEND:
      case RESUME:
      case RECOVER:
      case CHECK:
      case REPAIR:
      case ACCEPT:
      case REPLACE:
      case DISABLE_SNAPSHOT:
      case RECREATE_SNAPSHOT:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      statement();
         // Clear the global vectors after each statement is parsed.
         m_AttributePairList.clear();
         m_AttributeList.clear();
         m_DriveList.clear();
         m_ReplacementDriveList.clear();
         m_TrayIdList.clear();
         m_NameSpecList.clear();
         m_DriveChannelList.clear();
         m_VolumeMapping = new VolumeMapping();
         // Checks after each statement is successfully parsed for script cancellation.
         // If script it cancels it returns causing the parser to stop.
         if ( m_ScriptCanceled == true )
         {
            {if (true) return ScriptEngine.SCRIPT_CANCELED;}
         }

         // set pointer for the next command parsed in the input character stream
         m_CharStream.setNextCommand();

         // Update the lexical state based on current controller state
         updateLexicalState();

         // Sleep if we are not checking syntax and we haven't 
         // made a call to the controller that requires us to refresh the facade.
         // We need to sleep to keep from overloading the controller with configuration changes.
         if (!m_SyntaxCheckOnly && m_ExecutorUtils.isFacadeRefreshNeeded() && !m_IsLowOverheadMode)
         {
            try
            {
                Thread.sleep(1000);
            }
            catch (Exception exception)
            {
                // do nothing;
            }
         }
    }
    jj_consume_token(0);
      {if (true) return ScriptEngine.SCRIPT_COMPLETE;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
A statement is currently defined as a simple statement.  The concept of the simple
statement was left in to allow for the expansion of the granmmar to support more complex
statement types, such as, iteration or boolean.
<BR><BR>
*/
  final public void statement() throws ParseException, ScriptException {
    simpleStatement();
  }

/**
DESCRIPTION: <BR>
A statement is currently defined as a simple statement.  The following list defines the
current list of supported simple statements.
<BR><BR>
*/
  final public void simpleStatement() throws ParseException, ScriptException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DELETE:
      deleteStatement();
      break;
    case CREATE:
      createStatement();
      break;
    case DOWNLOAD:
      downloadStatement();
      break;
    case SET:
      setStatement();
      break;
    case RESET:
      resetStatement();
      break;
    case SHOW:
      showStatement();
      break;
    case ON:
      onErrorStatement();
      break;
    case START:
      startStatement();
      break;
    case UPLOAD:
      uploadStatement();
      break;
    case USE:
      useStatement();
      break;
    case STOP:
      stopStatement();
      break;
    case REMOVE:
      removeStatement();
      break;
    case RECOPY:
      recopyStatement();
      break;
    case DISABLE:
    case DISABLE_SNAPSHOT:
      disableStatement();
      break;
    case ENABLE:
      enableStatement();
      break;
    case SAVE:
      saveStatement();
      break;
    case CLEAR:
      clearStatement();
      break;
    case DIAGNOSE:
      diagnoseStatement();
      break;
    case REVIVE:
      reviveStatement();
      break;
    case ACTIVATE:
      activateStatement();
      break;
    case DEACTIVATE:
      deactivateStatement();
      break;
    case AUTOCONFIGURE:
      autoConfigureStatement();
      break;
    case SUSPEND:
      suspendStatement();
      break;
    case RESUME:
      resumeStatement();
      break;
    case RECREATE:
    case RECREATE_SNAPSHOT:
      recreateStatement();
      break;
    case RECOVER:
      recoverStatement();
      break;
    case CHECK:
      checkStatement();
      break;
    case REPAIR:
      repairStatement();
      break;
    case ACCEPT:
      acceptStatement();
      break;
    case REPLACE:
      replaceStatement();
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
There is currently only one use statement defined.  The use password statement.
<BR><BR>
*/
  final public void useStatement() throws ParseException, ScriptException {
    usePasswordStatement();
  }

/**
DESCRIPTION: <BR>
This statement modifies a flag kept by the CommandExecutor which determines the
CommandExecutor's behavior when an execution error is encountered.  If the flag
is set to true the script will continue execution.  If it is false it will throw
an exception back to the ScriptParser.  There are two valid values for this
statement's argument, "continue" and "stop".
<BR><BR>

EXAMPLE: <BR>
on error continue;
<BR><BR>
*/
  final public void onErrorStatement() throws ParseException {
   boolean     stopOnError = false;
    jj_consume_token(ON);
    jj_consume_token(ERROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STOP:
      jj_consume_token(STOP);
        stopOnError = true;
      break;
    case CONTINUE:
      jj_consume_token(CONTINUE);
        stopOnError = false;
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
        m_ExecutorUtils.setStopOnError(stopOnError);
  }

/**
DESCRIPTION: <BR>
There are currently three delete statements defined.  The delete volume, the delete
volume group and delete mapping statements.
<BR><BR>
*/
  final public void deleteStatement() throws ParseException, ScriptException {
    if (jj_2_1(2)) {
      deleteVolumeStatement();
    } else if (jj_2_2(2)) {
      deleteVolumeGroupStatement();
    } else if (jj_2_3(2)) {
      deleteIscsiInitiatorStatement();
    } else if (jj_2_4(2)) {
      deleteHostStatement();
    } else if (jj_2_5(2)) {
      deleteHostPortStatement();
    } else if (jj_2_6(2)) {
      deleteHostGroupStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DELETE:
        deleteMappingStatement();
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
There are five types of create statements supported. Create manual volume
allows the user to specify a drive list.  Create volume free extent allows the user
to create a volume on an existing volume group.  And auto create allows the user to
have the controller create a volume based on the drive count supplied by the user.
Create snapshot allows the user to create a snapshot volume similar to the create
volume statements.  Create mapping allows creation of LUN to host mappings for a 
specified volume.
<BR><BR>
*/
  final public void createStatement() throws ParseException, ScriptException {
    if (jj_2_7(3)) {
      createManualVolumeStatement();
    } else if (jj_2_8(3)) {
      createManualVolumeGroupStatement();
    } else if (jj_2_9(3)) {
      createFreeExtentVolumeStatement();
    } else if (jj_2_10(2)) {
      createAutoVolumeStatement();
    } else if (jj_2_11(2)) {
      createSnapshotVolumeStatement();
    } else if (jj_2_12(2)) {
      createHostStatement();
    } else if (jj_2_13(2)) {
      createHostGroupStatement();
    } else if (jj_2_14(2)) {
      createHostPortStatement();
    } else if (jj_2_15(3)) {
      createMappingStatement();
    } else if (jj_2_16(2)) {
      createRVMStatement();
    } else if (jj_2_17(2)) {
      createIscsiInitiatorStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CREATE:
        createVolumeCopyStatement();
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The types of recover volume statements supported. Recover volume
allows the user to specify a drive list.  Recover volume free extent allows the user
to create/recover a volume in an existing volume group.  
<BR><BR>
*/
  final public void recoverStatement() throws ParseException, ScriptException {
    if (jj_2_18(3)) {
      recoverVolumeStatement();
    } else if (jj_2_19(3)) {
      recoverFreeExtentVolumeStatement();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Currently four types of download statements are supported. Storage array firmware,
controller firmware, drive firmware, ESM firmware. Controller firmware support
may be dropped in favor of letting the controller handle code synchronization.
<BR><BR>
*/
  final public void downloadStatement() throws ParseException, ScriptException {
    if (jj_2_20(2)) {
      downloadSArrayStatement();
    } else if (jj_2_21(2)) {
      downloadDriveStatement();
    } else if (jj_2_22(2)) {
      downloadTrayStatement();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
We support the set command on storage arrays, controllers, drives, volumes snapshot volumes and
volume groups.
<BR><BR>
*/
  final public void setStatement() throws ParseException, ScriptException {
    if (jj_2_23(2)) {
      setSArrayStatement();
    } else if (jj_2_24(2)) {
      setControllerStatement();
    } else if (jj_2_25(2)) {
      setVolumeStatement();
    } else if (jj_2_26(2)) {
      setVolumeGroupStatement();
    } else if (jj_2_27(2)) {
      setPerformanceStatsStatement();
    } else if (jj_2_28(2)) {
      setDriveStatement();
    } else if (jj_2_29(2)) {
      setVolumeCopyStatement();
    } else if (jj_2_30(2)) {
      setVolumeUserLabel();
    } else if (jj_2_31(2)) {
      setHostStatement();
    } else if (jj_2_32(2)) {
      setHostGroupStatement();
    } else if (jj_2_33(2)) {
      setSessionStatement();
    } else if (jj_2_34(2)) {
      setRemoteMirrorStatement();
    } else if (jj_2_35(2)) {
      setDriveChannelStatusStatement();
    } else if (jj_2_36(2)) {
      setTrayStatement();
    } else if (jj_2_37(2)) {
      setAllTraysStatement();
    } else if (jj_2_38(2)) {
      setIscsiInitiatorStatement();
    } else if (jj_2_39(2)) {
      setIscsiTargetStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SET:
        setHostPortStatement();
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The reset command.
<BR><BR>
*/
  final public void resetStatement() throws ParseException, ScriptException {
    if (jj_2_40(2)) {
      resetControllerStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESET:
        resetSArrayStatement();
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
We presently have show commands for storage arrays, controllers, volumes, host 
topology and arbitrary strings.
<BR><BR>
*/
  final public void showStatement() throws ParseException, ScriptException {
    if (jj_2_41(3)) {
      showSArrayStatement();
    } else if (jj_2_42(3)) {
      showSArrayUnreadableSectors();
    } else if (jj_2_43(3)) {
      showSArrayAutoConfigStatement();
    } else if (jj_2_44(3)) {
      showSArrayHostTopologyStatement();
    } else if (jj_2_45(3)) {
      showSArrayLunMappings();
    } else if (jj_2_46(3)) {
      showSArrayConnections();
    } else if (jj_2_47(3)) {
      showSArrayPendingTopologyStatement();
    } else if (jj_2_48(3)) {
      showSArrayAutoSupportConfigStatement();
    } else if (jj_2_49(2)) {
      showControllerStatement();
    } else if (jj_2_50(2)) {
      showVolumeGroupStatement();
    } else if (jj_2_51(2)) {
      showStringStatement();
    } else if (jj_2_52(7)) {
      showVolumeCopyStatement();
    } else if (jj_2_53(2)) {
      showHostPortsStatement();
    } else if (jj_2_54(2)) {
      showVolumeStatement();
    } else if (jj_2_55(3)) {
      showRemoteMirrorCandidatesStatement();
    } else if (jj_2_56(3)) {
      showRemoteMirrorProgressStatement();
    } else if (jj_2_57(2)) {
      showDriveStatement();
    } else if (jj_2_58(3)) {
      showVolumeCopyCandidatesSource();
    } else if (jj_2_59(7)) {
      showVolumeCopyTargetCandidates();
    } else if (jj_2_60(2)) {
      showDriveChannelStatsStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHOW:
        showIscsiSessionStatement();
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The start command.
<BR><BR>
NOTES/ASSUMPTIONS: <BR>
For now, it is safe to remove the entire startVolumeStatement for a Data Retention
client because the only start volume command is for initialize. But if another
option is added for startVolumeStatement, this needs to be re-evaluated.
*/
  final public void startStatement() throws ParseException, ScriptException {
    if (jj_2_61(2)) {
      startIncreaseVolumeCapacityStatement();
    } else if (jj_2_62(2)) {
      startVolumeCopyStatement();
    } else if (jj_2_63(2)) {
      startSArrayStatement();
    } else if (jj_2_64(2)) {
      startControllerStatement();
    } else if (jj_2_65(2)) {
      startDriveChannelStatement();
    } else if (jj_2_66(2)) {
      startDriveStatement();
    } else if (jj_2_67(2)) {
      startTrayStatement();
    } else if (jj_2_68(2)) {
      startVolumeGroupStatement();
    } else if (jj_2_69(2)) {
      startVolumeStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case START:
        startRemoteMirrorStatement();
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The save command.
<BR><BR>
*/
  final public void saveStatement() throws ParseException, ScriptException {
    if (jj_2_70(2)) {
      saveDrivesLogStatement();
    } else if (jj_2_71(2)) {
      saveStorageArrayStatement();
    } else if (jj_2_72(2)) {
      saveTrayLogStatement();
    } else if (jj_2_73(2)) {
      saveDriveChannelFaultDiagnosticsStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SAVE:
        saveControllerNVSRAMStatement();
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The stop command.
<BR><BR>
*/
  final public void stopStatement() throws ParseException, ScriptException {
    if (jj_2_74(2)) {
      stopVolumeCopyStatement();
    } else if (jj_2_75(2)) {
      stopSArrayStatement();
    } else if (jj_2_76(2)) {
      stopDriveChannelStatement();
    } else if (jj_2_77(2)) {
      stopDriveStatement();
    } else if (jj_2_78(2)) {
      stopVolumeGroupStatement();
    } else if (jj_2_79(2)) {
      stopSnapshotStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STOP:
        stopTrayStatement();
        break;
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The remove command.
<BR><BR>
*/
  final public void removeStatement() throws ParseException, ScriptException {
    if (jj_2_80(2)) {
      removeVolumeCopyStatement();
    } else if (jj_2_81(2)) {
      removeVolumeAttributeStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REMOVE:
        removeRemoteMirrorStatement();
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The disable command.
<BR><BR>
*/
  final public void disableStatement() throws ParseException, ScriptException {
    if (jj_2_82(2)) {
      disableSArrayStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISABLE_SNAPSHOT:
        disableSnapshotStatement();
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The enable command.
<BR><BR>
*/
  final public void enableStatement() throws ParseException, ScriptException {
    if (jj_2_83(2)) {
      enableSArrayStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENABLE:
        enableControllerStatement();
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The clear command.
<BR><BR>
*/
  final public void clearStatement() throws ParseException, ScriptException {
    if (jj_2_84(2)) {
      clearSArrayStatement();
    } else if (jj_2_85(2)) {
      clearDriveChannelStatsStatement();
    } else if (jj_2_86(2)) {
      clearVolumeStatement();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
The recreate command.
<BR><BR>
*/
  final public void recreateStatement() throws ParseException, ScriptException {
    if (jj_2_87(2)) {
      recreateSnapshotStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RECREATE:
        recreateMirrorRepositoryStatement();
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The diagnose command.
<BR><BR>
*/
  final public void diagnoseStatement() throws ParseException, ScriptException {
    if (jj_2_88(6)) {
      diagnoseControllerStatement();
    } else if (jj_2_89(6)) {
      diagnoseDiscreteLinesStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIAGNOSE:
        diagnoseMirrorStatement();
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The revive command.
<BR><BR>
*/
  final public void reviveStatement() throws ParseException, ScriptException {
    if (jj_2_90(2)) {
      reviveDriveStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REVIVE:
        reviveVolumeGroupStatement();
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The autoConfigure command.  We have two variations: 
autoConfigure of the entire storage array or 
auto assignment of hot spares with the existing configuration.
<BR><BR>
*/
  final public void autoConfigureStatement() throws ParseException, ScriptException {
    if (jj_2_91(3)) {
      autoConfigureSArrayHotSparesStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTOCONFIGURE:
        autoConfigureSArrayStatement();
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The activate command.
<BR><BR>
*/
  final public void activateStatement() throws ParseException, ScriptException {
    if (jj_2_92(3)) {
      activateStagedFirmwareStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ACTIVATE:
        activateSArrayStatement();
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*
The replace command.
<BR><BR>
*/
  final public void replaceStatement() throws ParseException, ScriptException {
    replaceDriveStatement();
  }

/**
DESCRIPTION: <BR>
The deactivate command.
<BR><BR>
*/
  final public void deactivateStatement() throws ParseException, ScriptException {
    deactivateSArrayStatement();
  }

/**
DESCRIPTION: <BR>
The Suspend command.
<BR><BR>
*/
  final public void suspendStatement() throws ParseException, ScriptException {
    suspendMirrorStatement();
  }

/**
DESCRIPTION: <BR>
The Resume command.
<BR><BR>
*/
  final public void resumeStatement() throws ParseException, ScriptException {
    resumeMirrorStatement();
  }

/**
DESCRIPTION: <BR>
The Check command.
<BR><BR>
*/
  final public void checkStatement() throws ParseException, ScriptException {
    if (jj_2_93(2)) {
      checkVolumeParityStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHECK:
        checkRemoteMirrorStatus();
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The Repair command.
<BR><BR>
*/
  final public void repairStatement() throws ParseException, ScriptException {
    repairVolumeParityStatement();
  }

/**
DESCRIPTION: <BR>
Accept statement.
<BR><BR>
*/
  final public void acceptStatement() throws ParseException, ScriptException {
    acceptPendingTopologyStatement();
  }

/**
DESCRIPTION: <BR>
The Diagnose Mirror statement.
<BR><BR>
*/
  final public void diagnoseMirrorStatement() throws ParseException, ScriptException {
    jj_consume_token(DIAGNOSE);
    jj_consume_token(REMOTE_MIRROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      break;
    case PRIMARIES:
      jj_consume_token(PRIMARIES);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    jj_consume_token(TEST_ID);
    jj_consume_token(EQUALS);
    jj_consume_token(CONNECTIVITY);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_RVMExecutor.performPingTest(m_NameSpecList);
      }
  }

/**
DESCRIPTION: <BR>
The clear storage array statement.
<BR><BR>
*/
  final public void clearSArrayStatement() throws ParseException, ScriptException {
    jj_consume_token(CLEAR);
    jj_consume_token(STORAGE_ARRAY);
    if (jj_2_94(2)) {
      jj_consume_token(CONFIGURATION);
      jj_consume_token(SEMICOLON);
           if (!m_SyntaxCheckOnly)
           {
               m_SArrayExecutor.resetConfiguration();
           }
    } else if (jj_2_95(2)) {
      jj_consume_token(CONFIGURATION);
      jj_consume_token(ALL_DEVICES);
      jj_consume_token(SEMICOLON);
           if (!m_SyntaxCheckOnly)
           {
              m_SArrayExecutor.deleteStorageArrayConfiguration();
           }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONFIGURATION:
        jj_consume_token(CONFIGURATION);
        jj_consume_token(VOLUME_GROUPS);
        jj_consume_token(SEMICOLON);
           if (!m_SyntaxCheckOnly)
           {
              m_SArrayExecutor.clearVolumeGroupConfiguration();
           }
        break;
      case EVENT_LOG:
        jj_consume_token(EVENT_LOG);
        jj_consume_token(SEMICOLON);
           if (!m_SyntaxCheckOnly)
           {
               m_SArrayExecutor.resetEventLog();
           }
        break;
      case FIRMWARE_PENDING_AREA:
        jj_consume_token(FIRMWARE_PENDING_AREA);
        jj_consume_token(SEMICOLON);
           if (! m_SyntaxCheckOnly)
           {
               m_SArrayExecutor.clearStagedFirmware();
           }
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
The activate command to activate storageArray's staged firmware.   <BR>
command syntax:  activate storageArray firmware
<BR><BR>
*/
  final public void activateStagedFirmwareStatement() throws ParseException, ScriptException {
    jj_consume_token(ACTIVATE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FIRMWARE);
    jj_consume_token(SEMICOLON);
       if ( ! m_SyntaxCheckOnly )
       {
            m_ControllerExecutor.activateStagedFirmware();
       }
  }

/**
Disables storage array premium features or feature packs.
<BR><BR>
*/
  final public void disableSArrayStatement() throws ParseException, ScriptException {
    if (jj_2_96(3)) {
      disablePremiumFeatureStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DISABLE:
        disableFeaturePackStatement();
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
Disables storage array premium features.
<BR><BR>
*/
  final public void disablePremiumFeatureStatement() throws ParseException, ScriptException {
    jj_consume_token(DISABLE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FEATURE);
    jj_consume_token(EQUALS);
    premiumFeatureAttributeList();
    jj_consume_token(SEMICOLON);
        if (!m_SyntaxCheckOnly)
        {
            m_SArrayExecutor.disableFeature(m_AttributeList);
        }
  }

/**
Disables storage array feature packs
<BR><BR>
*/
  final public void disableFeaturePackStatement() throws ParseException, ScriptException {
    jj_consume_token(DISABLE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FEATUREPACK);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.disableFeatureBundles();
      }
  }

/**
Enables storage array premium features or feature packs.
<BR><BR>
*/
  final public void enableSArrayStatement() throws ParseException, ScriptException {
    if (jj_2_97(3)) {
      enablePremiumFeatureStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENABLE:
        enableFeaturePackStatement();
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
Enables storage array premium features
<BR><BR>
*/
  final public void enablePremiumFeatureStatement() throws ParseException, ScriptException {
    String fileName = null;
    jj_consume_token(ENABLE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FEATURE);
    jj_consume_token(FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
    jj_consume_token(SEMICOLON);
        if (! m_SyntaxCheckOnly)
        {
            m_SArrayExecutor.downloadFeatureKeys(fileName);
        }
  }

/**
Enables storage array feature pack
<BR><BR>
*/
  final public void enableFeaturePackStatement() throws ParseException, ScriptException {
   String fileName = null;
    jj_consume_token(ENABLE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FEATUREPACK);
    jj_consume_token(FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.downloadFeatureBundle(fileName);
      }
  }

/**
DESCRIPTION: <BR>
Enable controller statement. Only support enable controller data transfer at this moment.
<BR><BR>
*/
  final public void enableControllerStatement() throws ParseException, ScriptException {
    String controllerSlot = null;
    jj_consume_token(ENABLE);
    jj_consume_token(CONTROLLER);
    jj_consume_token(LBRACKET);
    controllerSlot = controllerSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(DATA_TRANSFER);
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
        m_ControllerExecutor.enableCtlrDataTransfer(controllerSlot);
      }
  }

/**
DESCRIPTION: <BR>
Tells the StorageArrayFacade what password to use for destructive operations.
<BR><BR>
*/
  final public void usePasswordStatement() throws ParseException, ScriptException {
   String      password = null;
    jj_consume_token(USE);
    jj_consume_token(PASSWORD);
    password = stringLiteral();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.specifyPassword( password );
      }
  }

/**
DESCRIPTION: <BR>
The delete volume deletes the specified volume from the storage array.  The user specifies
the volume by user name.  If the name is ambiguous it will not be deleted.
<BR><BR>
*/
  final public void deleteVolumeStatement() throws ParseException, ScriptException {
    String           volumeWWN = null;
    boolean          removeVolumeGroup = false; //default
    int              commandToCall = DELETE_ALL_VOLUMES;
    jj_consume_token(DELETE);
    if (jj_2_98(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLUME:
        jj_consume_token(VOLUME);
        break;
      case VOLUMES:
        jj_consume_token(VOLUMES);
        break;
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LBRACKET);
      nameSpecList();
      jj_consume_token(RBRACKET);
         commandToCall = DELETE_LIST_VOLUMES;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLUME:
        jj_consume_token(VOLUME);
        jj_consume_token(LESS_THAN);
        volumeWWN = wwnStringSpec();
        jj_consume_token(GREATER_THAN);
        commandToCall = DELETE_ONE_VOLUME;
        break;
      case ALL_VOLUMES:
        jj_consume_token(ALL_VOLUMES);
         commandToCall = DELETE_ALL_VOLUMES;
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REMOVE_VOLUME_GROUP:
      jj_consume_token(REMOVE_VOLUME_GROUP);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
                removeVolumeGroup = true;
        break;
      case FALSE:
        jj_consume_token(FALSE);
                removeVolumeGroup = false;
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            switch (commandToCall)
            {
               case DELETE_ONE_VOLUME:
                  m_VolumeExecutor.deleteVolumeWithWWN(volumeWWN, removeVolumeGroup);
                  break;
               case DELETE_LIST_VOLUMES:
                  m_VolumeExecutor.deleteVolumes(m_NameSpecList, removeVolumeGroup);
                  break;
               case DELETE_ALL_VOLUMES:
               default:
                  m_VolumeExecutor.deleteAllVolumes(removeVolumeGroup);
                  break;
            }
         }
  }

/**
DESCRIPTION: <BR>
Delete volume group will iterate over all volumes in a group and delete them.
<BR><BR>
*/
  final public void deleteVolumeGroupStatement() throws ParseException, ScriptException {
   int         volumeGroup = -1;
   String      volumeGroupName = null;
    jj_consume_token(DELETE);
    jj_consume_token(VOLUME_GROUP);
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
    case IDENTIFIER:
      volumeGroupName = nameSpec();
      break;
    case INTEGER_LITERAL:
    case 469:
      volumeGroup = integerLiteral();
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if (volumeGroupName == null)
      {
          volumeGroupName = Integer.toString(volumeGroup);
      }

      if (! m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.deleteVolumeGroup(volumeGroupName);
      }
  }

/**
DESCRIPTION: <BR>
Delete host will delete the the specified host.
command syntax:  delete host[user-label]
<BR><BR>
*/
  final public void deleteHostStatement() throws ParseException, ScriptException {
   String               hostName = null;
    jj_consume_token(DELETE);
    jj_consume_token(HOST);
    jj_consume_token(LBRACKET);
    hostName = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.deleteHost( hostName );
      }
  }

/**
DESCRIPTION: <BR>
Delete hostGroup will delete the the specified host group.
command syntax:  delete hostGroup[user-label]
<BR><BR>
*/
  final public void deleteHostGroupStatement() throws ParseException, ScriptException {
   String               hostGroupName = null;
    jj_consume_token(DELETE);
    jj_consume_token(HOST_GROUP);
    jj_consume_token(LBRACKET);
    hostGroupName = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.deleteHostGroup( hostGroupName );
      }
  }

/**
DESCRIPTION: <BR>
Delete hostPort will delete the the specified host port.
command syntax:  delete hostPort[userLabel]
<BR><BR>
*/
  final public void deleteHostPortStatement() throws ParseException, ScriptException {
   String               hostPortName = null;
    jj_consume_token(DELETE);
    jj_consume_token(HOST_PORT);
    jj_consume_token(LBRACKET);
    hostPortName = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.deleteHostPort( hostPortName );
      }
  }

/**
DESCRIPTION: <BR>
This will delete the specified iscsi initiator(s) or all initiators.

<BR><BR>
*/
  final public void deleteIscsiInitiatorStatement() throws ParseException, ScriptException {
   String       name = null;
   boolean      isViaIscsiName = false;
    jj_consume_token(DELETE);
    jj_consume_token(ISCSI_INITIATOR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      name = userLabelLiteral();
      jj_consume_token(RBRACKET);
      break;
    case LESS_THAN:
      jj_consume_token(LESS_THAN);
      name = stringLiteral();
      jj_consume_token(GREATER_THAN);
         isViaIscsiName = true;
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_IscsiExecutor.deleteIscsiInitiator(name, isViaIscsiName);
      }
  }

/**
DESCRIPTION: <BR>
Create a volume based on a list of one or more drives supplied by the user.  A
list of parameters and values can be specified for manual volume creation.
<BR><BR>
*/
  final public void createManualVolumeStatement() throws ParseException, ScriptException {
   int integerLiteral;
   String stringLiteral;
    jj_consume_token(CREATE);
    jj_consume_token(VOLUME);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DRIVE:
      jj_consume_token(DRIVE);
      break;
    case DRIVES:
      jj_consume_token(DRIVES);
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      driveList();
      jj_consume_token(RBRACKET);
      break;
    case EQUALS:
      jj_consume_token(EQUALS);
      jj_consume_token(LPAREN);
      driveList();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAPPING:
    case USER_LABEL:
    case VOLUME_GROUP_USER_LABEL:
    case CAPACITY:
    case OWNER:
    case CACHE_READ_PREFETCH:
    case READ_AHEAD_MULTIPLIER:
    case SEGMENT_SIZE:
    case RAID_LEVEL:
    case USAGE_HINT:
    case ENFORCESOFTLIMIT:
    case DRIVE_TYPE:
    case TRAY_LOSS_PROTECT:
    case FREE_CAPACITY_AREA:
    case DSS_PREALLOCATE:
      createVolumeAttributeValueList();
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.createVolumeManual(m_DriveList, m_AttributePairList );
      }
  }

/**
DESCRIPTION: <BR>
Recover a volume based on a list of one or more drives or a volume group supplied by the user.  A
list of parameters and values can be specified for manual volume creation/recovery.
<BR><BR>
*/
  final public void recoverVolumeStatement() throws ParseException, ScriptException {
   String                                    stringLiteral;
   int                           integerLiteral = 0;
   CapacityAttributeValuePair    capacityPair = null;
   CapacityAttributeValuePair    offsetPair = null;
   Object[]                      formatArgs = new Object[3];
   String                        errorString = null;
   Double                        capacity = null;
   Double                        offset = null;
   int                           volumeGroup = -1;
   String                        volumeGroupName = null;
   String                        newVolumeGroupName = null;
    jj_consume_token(RECOVER);
    jj_consume_token(VOLUME);
    if (jj_2_99(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DRIVE:
        jj_consume_token(DRIVE);
        break;
      case DRIVES:
        jj_consume_token(DRIVES);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LBRACKET);
      driveList();
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DRIVE:
      case DRIVES:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DRIVE:
          jj_consume_token(DRIVE);
          break;
        case DRIVES:
          jj_consume_token(DRIVES);
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(EQUALS);
        jj_consume_token(LPAREN);
        driveList();
        jj_consume_token(RPAREN);
        break;
      case VOLUME_GROUP:
        jj_consume_token(VOLUME_GROUP);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
        case IDENTIFIER:
          volumeGroupName = nameSpec();
          break;
        case INTEGER_LITERAL:
        case 469:
          volumeGroup = integerLiteral();
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      if (volumeGroupName == null)
      {
          volumeGroupName = Integer.toString(volumeGroup);
      }
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEW_VOLUME_GROUP:
      jj_consume_token(NEW_VOLUME_GROUP);
      jj_consume_token(EQUALS);
      newVolumeGroupName = nameSpec();
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(USER_LABEL);
    jj_consume_token(EQUALS);
    stringLiteral = userLabelLiteral();
      m_AttributePairList.addElement(new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral));
    jj_consume_token(CAPACITY);
      capacityPair = new CapacityAttributeValuePair(Attribute.CAPACITY);
    jj_consume_token(EQUALS);
    jj_consume_token(INTEGER_LITERAL);
      if ( token.image.toLowerCase().startsWith(HEX_PREFIX) )
      {
         try
         {
            integerLiteral = Integer.parseInt(token.image.substring(2), 16);
         }
         catch(NumberFormatException nfe)
         {
             formatArgs[0] = Integer.toString(getLine());
             formatArgs[1] = HEX_PREFIX + Integer.toHexString(Integer.MIN_VALUE);
             formatArgs[2] = HEX_PREFIX + Integer.toHexString(Integer.MAX_VALUE);
             errorString = MessageFormat.format(Resource.getString(
                        "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                        formatArgs);
             m_ParseException = new ParseException(errorString);
             {if (true) throw m_ParseException;}
         }
         capacity = new Double(integerLiteral);
      }
      else // Doesn't start with "0x" so treat as decimal
      {
           capacity = new Double(token.image);
      }
      capacityPair.setValue(capacity.doubleValue());
      capacityPair.setCapacityModifier(Resource.getString("SE_CAPACITY_MODIFIER_BYTES"));
      m_AttributePairList.addElement(capacityPair);
    jj_consume_token(OFFSET);
         offsetPair = new CapacityAttributeValuePair(Attribute.OFFSET);
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
         if ( token.image.toLowerCase().startsWith(HEX_PREFIX) )
         {
            try
            {
               integerLiteral = Integer.parseInt(token.image.substring(2), 16);
            }
            catch(NumberFormatException nfe)
            {
                formatArgs[0] = Integer.toString(getLine());
                formatArgs[1] = HEX_PREFIX + Integer.toHexString(Integer.MIN_VALUE);
                formatArgs[2] = HEX_PREFIX + Integer.toHexString(Integer.MAX_VALUE);
                errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           formatArgs);
                m_ParseException = new ParseException(errorString);
                {if (true) throw m_ParseException;}
            }
            offset = new Double(integerLiteral);
         }
         else // Doesn't start with "0x" so treat as decimal
         {
           offset = new Double(token.image);
         }
         offsetPair.setValue(offset.doubleValue());
         offsetPair.setCapacityModifier(Resource.getString("SE_CAPACITY_MODIFIER_BYTES"));
         m_AttributePairList.addElement(offsetPair);
    jj_consume_token(RAID_LEVEL);
    jj_consume_token(EQUALS);
    integerLiteral = raidLevel();
         m_AttributePairList.addElement( new IntegerAttributeValuePair(Attribute.RAID_LEVEL, integerLiteral ) );
    jj_consume_token(SEGMENT_SIZE);
    jj_consume_token(EQUALS);
    jj_consume_token(INTEGER_LITERAL);
         try
         {
            m_AttributePairList.addElement( new IntegerAttributeValuePair(
               Attribute.SEGMENT_SIZE, Integer.parseInt(token.image)) );
         }
         catch(NumberFormatException e)
         {
           formatArgs[0] = Integer.toString(getLine());
           formatArgs[1] = Integer.toString(Integer.MIN_VALUE);
           formatArgs[2] = Integer.toString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           formatArgs);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OWNER:
    case CACHE_READ_PREFETCH:
    case READ_AHEAD_MULTIPLIER:
      recoverVolumeAttributeValueList();
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.recoverVolume(m_AttributePairList, m_DriveList, volumeGroupName, newVolumeGroupName);
      }
  }

/**
DESCRIPTION: <BR>
Recover a volume based on a volume group number supplied by the user.  A
list of parameters and values can be specified for manual volume creation/recovery.
Some values can be invalid for this case, such as RAID level.
<BR><BR>
*/
  final public void recoverFreeExtentVolumeStatement() throws ParseException, ScriptException {
   int      volumeGroup = -1;
   String   volumeGroupName = null;
    jj_consume_token(RECOVER);
    jj_consume_token(VOLUME);
    if (jj_2_100(2)) {
      jj_consume_token(VOLUME_GROUP);
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case IDENTIFIER:
        volumeGroupName = nameSpec();
        break;
      case INTEGER_LITERAL:
      case 469:
        volumeGroup = integerLiteral();
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLUME_GROUP:
        jj_consume_token(VOLUME_GROUP);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
        case IDENTIFIER:
          volumeGroupName = nameSpec();
          break;
        case INTEGER_LITERAL:
        case 469:
          volumeGroup = integerLiteral();
          break;
        default:
          jj_la1[41] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    recoverVolumeAttributeValueList();
    jj_consume_token(SEMICOLON);
       if (volumeGroupName == null)
       {
          volumeGroupName = Integer.toString(volumeGroup);
       }

       if (! m_SyntaxCheckOnly)
       {
          m_VolumeExecutor.recoverVolume(m_AttributePairList, null, volumeGroupName, null);
       }
  }

/**
DESCRIPTION: <BR>
Create a volume based on a volume group number supplied by the user.  A
list of parameters and values can be specified for manual volume creation.
Some values can be invalid for this case, such as RAID level.
<BR><BR>
*/
  final public void createFreeExtentVolumeStatement() throws ParseException, ScriptException {
   int      volumeGroup = -1;
   String   volumeGroupName = null;
    jj_consume_token(CREATE);
    jj_consume_token(VOLUME);
    if (jj_2_101(2)) {
      jj_consume_token(VOLUME_GROUP);
      jj_consume_token(LBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case IDENTIFIER:
        volumeGroupName = nameSpec();
        break;
      case INTEGER_LITERAL:
      case 469:
        volumeGroup = integerLiteral();
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RBRACKET);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLUME_GROUP:
        jj_consume_token(VOLUME_GROUP);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
        case IDENTIFIER:
          volumeGroupName = nameSpec();
          break;
        case INTEGER_LITERAL:
        case 469:
          volumeGroup = integerLiteral();
          break;
        default:
          jj_la1[44] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    createVolumeAttributeValueList();
    jj_consume_token(SEMICOLON);
       if (volumeGroupName == null)
       {
          volumeGroupName = Integer.toString(volumeGroup);
       }

       if ( ! m_SyntaxCheckOnly )
       {
          m_VolumeExecutor.createVolumeOnExistingGroup(volumeGroupName, m_AttributePairList);
       }
  }

/**
DESCRIPTION: <BR>
This command is used for the setting of an iSCSI initiator's parameters.
<BR><BR>
*/
  final public void setIscsiInitiatorStatement() throws ParseException, ScriptException {
   String      initiator = null;
   boolean     isViaIscsiName = false;
    jj_consume_token(SET);
    jj_consume_token(ISCSI_INITIATOR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      initiator = userLabelLiteral();
      jj_consume_token(RBRACKET);
      break;
    case LESS_THAN:
      jj_consume_token(LESS_THAN);
      initiator = stringLiteral();
      jj_consume_token(GREATER_THAN);
         isViaIscsiName = true;
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    iscsiInitiatorAttributeValueList();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_IscsiExecutor.setIscsiInitiatorProperties(initiator,
                m_AttributePairList, isViaIscsiName);
      }
  }

/**
DESCRIPTION: <BR>
This command is used for the setting of an iSCSI target's parameters.
<BR><BR>
*/
  final public void setIscsiTargetStatement() throws ParseException, ScriptException {
   String      target = null;
   boolean     isViaIscsiName = false;
    jj_consume_token(SET);
    jj_consume_token(ISCSI_TARGET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      target = userLabelLiteral();
      jj_consume_token(RBRACKET);
      break;
    case LESS_THAN:
      jj_consume_token(LESS_THAN);
      target = stringLiteral();
      jj_consume_token(GREATER_THAN);
         isViaIscsiName = true;
      break;
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    iscsiTargetAttributeValueList();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_IscsiExecutor.setIscsiTargetProperties(target, m_AttributePairList, isViaIscsiName);
      }
  }

/**
DESCRIPTION: <BR>
This command creates an iSCSI initiator.
<BR><BR>
*/
  final public void createIscsiInitiatorStatement() throws ParseException, ScriptException {
    String stringLiteral;
    IscsiAuthenticationAttribute authAttribute = null;
    jj_consume_token(CREATE);
    jj_consume_token(ISCSI_INITIATOR);
    jj_consume_token(ISCSI_NAME);
    jj_consume_token(EQUALS);
    stringLiteral = stringLiteral();
       m_AttributePairList.addElement(
                         new StringAttributeValuePair(Attribute.ISCSI_NAME, stringLiteral));
    jj_consume_token(USER_LABEL);
    jj_consume_token(EQUALS);
    stringLiteral = userLabelLiteral();
      m_AttributePairList.addElement(
                         new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral));
    jj_consume_token(HOST);
    jj_consume_token(EQUALS);
    stringLiteral = userLabelLiteral();
      m_AttributePairList.addElement(
                         new StringAttributeValuePair(Attribute.HOST_NAME, stringLiteral));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAP_SECRET:
      jj_consume_token(CHAP_SECRET);
      jj_consume_token(EQUALS);
      stringLiteral = stringLiteral();
      authAttribute = new IscsiAuthenticationAttribute(
         AuthenticationMethod.AUTH_METHOD_CHAP, stringLiteral.toCharArray());
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_IscsiExecutor.createIscsiInitiator(m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Create an arbitrary volume based on a number of drives supplied by the user.  A
list of parameters and values can be specified for manual volume creation.
Some values can be invalid for this case, such as RAID level.
<BR><BR>
*/
  final public void createAutoVolumeStatement() throws ParseException, ScriptException {
   int             driveCount = 0;
    jj_consume_token(CREATE);
    jj_consume_token(VOLUME);
    jj_consume_token(DRIVE_COUNT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      driveCount = integerLiteral();
      jj_consume_token(RBRACKET);
      break;
    case EQUALS:
      jj_consume_token(EQUALS);
      driveCount = integerLiteral();
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAPPING:
    case USER_LABEL:
    case VOLUME_GROUP_USER_LABEL:
    case CAPACITY:
    case OWNER:
    case CACHE_READ_PREFETCH:
    case READ_AHEAD_MULTIPLIER:
    case SEGMENT_SIZE:
    case RAID_LEVEL:
    case USAGE_HINT:
    case ENFORCESOFTLIMIT:
    case DRIVE_TYPE:
    case TRAY_LOSS_PROTECT:
    case FREE_CAPACITY_AREA:
    case DSS_PREALLOCATE:
      createVolumeAttributeValueList();
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.createVolumeAuto(driveCount, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Create a snapshot volume.  This production will parse out any valid syntax for
creating a snapshot volume.  
<BR><BR>
*/
  final public void createSnapshotVolumeStatement() throws ParseException, ScriptException {
   String baseVolume;
    jj_consume_token(CREATE);
    jj_consume_token(SNAPSHOT_VOLUME);
    jj_consume_token(BASE_VOLUME);
    jj_consume_token(EQUALS);
    baseVolume = nameSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REPOSITORY_VOLUME_GROUP:
    case REPOSITORY_RAID_LEVEL:
      createRepositorySpec();
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER_LABEL:
    case REPOSITORY_PERCENT_OF_BASE:
    case REPOSITORY_FULL_POLICY:
    case REPOSITORY_USER_LABEL:
    case WARNING_THRESHOLD_PERCENT:
    case ENFORCESOFTLIMIT:
      createSnapshotAttributeList();
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
   if (!m_SyntaxCheckOnly)
      {
         m_SnapshotExecutor.createSnapshotVolume(baseVolume, m_AttributePairList, m_DriveList );
      }
  }

/**
DESCRIPTION: <BR>
Create a LUN to host mapping for a volume.  If the host is not specified
the default host group is used for the mapping.
<BR><BR>
*/
  final public void createMappingStatement() throws ParseException, ScriptException {
   String      volume = "";
    jj_consume_token(CREATE);
    jj_consume_token(MAPPING);
    jj_consume_token(VOLUME);
    jj_consume_token(EQUALS);
    volume = nameSpec();
    if (jj_2_102(4)) {
      LUNSpec();
      hostOrHostGroupNameSpec();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOST:
      case HOST_GROUP:
        hostOrHostGroupNameSpec();
        LUNSpec();
        jj_consume_token(SEMICOLON);
        break;
      case LUN:
        LUNSpec();
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      m_VolumeMapping.setVolume (volume);

      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.createMappingCommand( m_VolumeMapping );
      }
  }

/**
DESCRIPTION: <BR>
Create a remote mirroring relationship.
<BR><BR>
*/
  final public void createRVMStatement() throws ParseException, ScriptException {
   String      primaryVolume = null;
   String      secondaryVolume = null;
   String      remoteArray = null;
    jj_consume_token(CREATE);
    jj_consume_token(REMOTE_MIRROR);
    jj_consume_token(PRIMARY);
    jj_consume_token(EQUALS);
    primaryVolume = nameSpec();
    jj_consume_token(SECONDARY);
    jj_consume_token(EQUALS);
    secondaryVolume = nameSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REMOTE_ARRAY_NAME:
      jj_consume_token(REMOTE_ARRAY_NAME);
      jj_consume_token(EQUALS);
      remoteArray = nameSpec();
      m_AttributePairList.addElement(new StringAttributeValuePair(
                              Attribute.REMOTE_ARRAY_NAME, remoteArray));
      break;
    case REMOTE_ARRAY_WWID:
      jj_consume_token(REMOTE_ARRAY_WWID);
      jj_consume_token(EQUALS);
      remoteArray = wwnStringSpec();
      m_AttributePairList.addElement(new StringAttributeValuePair(
                              Attribute.REMOTE_ARRAY_WWID, remoteArray));
      break;
    case REMOTE_ARRAY_WWN:
      jj_consume_token(REMOTE_ARRAY_WWN);
      jj_consume_token(EQUALS);
      remoteArray = wwnStringSpec();
      m_AttributePairList.addElement(new StringAttributeValuePair(
                              Attribute.REMOTE_ARRAY_WWN, remoteArray));
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REMOTE_PASSWORD:
    case ROLE:
    case FORCE:
    case SYNC_PRIORITY:
    case WRITE_ORDER:
    case WRITE_MODE:
    case AUTO_RESYNC:
      remoteMirrorAttributeValueList();
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_RVMExecutor.createRemoteMirror(primaryVolume,
               secondaryVolume, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid RVM attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void remoteMirrorAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_2:
    while (true) {
      pair = remoteMirrorAttributeValuePair();
         m_AttributePairList.addElement( pair );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REMOTE_PASSWORD:
      case ROLE:
      case FORCE:
      case SYNC_PRIORITY:
      case WRITE_ORDER:
      case WRITE_MODE:
      case AUTO_RESYNC:
        ;
        break;
      default:
        jj_la1[56] = jj_gen;
        break label_2;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid RVM attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute remoteMirrorAttributeValuePair() throws ParseException {
   String   remotePassword = null;
   int      syncPriority;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REMOTE_PASSWORD:
      jj_consume_token(REMOTE_PASSWORD);
      jj_consume_token(EQUALS);
      remotePassword = stringLiteral();
      {if (true) return new StringAttributeValuePair(Attribute.REMOTE_PASSWORD, remotePassword);}
      break;
    case SYNC_PRIORITY:
      jj_consume_token(SYNC_PRIORITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOWEST:
        jj_consume_token(LOWEST);
         syncPriority = 0;
        break;
      case LOW:
        jj_consume_token(LOW);
         syncPriority = 1;
        break;
      case MEDIUM:
        jj_consume_token(MEDIUM);
         syncPriority = 2;
        break;
      case HIGH:
        jj_consume_token(HIGH);
         syncPriority = 3;
        break;
      case HIGHEST:
        jj_consume_token(HIGHEST);
         syncPriority = 4;
        break;
      default:
        jj_la1[57] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new IntegerAttributeValuePair(Attribute.SYNC_PRIORITY, syncPriority);}
      break;
    case WRITE_ORDER:
      jj_consume_token(WRITE_ORDER);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRESERVED:
        jj_consume_token(PRESERVED);
            {if (true) return new BooleanAttributeValuePair(Attribute.WRITE_ORDER, true);}
        break;
      case NOT_PRESERVED:
        jj_consume_token(NOT_PRESERVED);
            {if (true) return new BooleanAttributeValuePair(Attribute.WRITE_ORDER, false);}
        break;
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case WRITE_MODE:
      jj_consume_token(WRITE_MODE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SYNCHRONOUS:
        jj_consume_token(SYNCHRONOUS);
            {if (true) return new BooleanAttributeValuePair(Attribute.WRITE_MODE, true);}
        break;
      case ASYNCHRONOUS:
        jj_consume_token(ASYNCHRONOUS);
            {if (true) return new BooleanAttributeValuePair(Attribute.WRITE_MODE, false);}
        break;
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case AUTO_RESYNC:
      jj_consume_token(AUTO_RESYNC);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENABLED:
        jj_consume_token(ENABLED);
            {if (true) return new BooleanAttributeValuePair(Attribute.MIRROR_AUTO_RESYNC, true);}
        break;
      case DISABLED:
        jj_consume_token(DISABLED);
            {if (true) return new BooleanAttributeValuePair(Attribute.MIRROR_AUTO_RESYNC, false);}
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case ROLE:
      jj_consume_token(ROLE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIMARY:
        jj_consume_token(PRIMARY);
        break;
      case SECONDARY:
        jj_consume_token(SECONDARY);
        break;
      default:
        jj_la1[61] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair(Attribute.MIRROR_ROLE, token.image);}
      break;
    case FORCE:
      jj_consume_token(FORCE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.MIRROR_FORCE, token.image);}
      break;
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid Parity Check attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void volumeParityAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_3:
    while (true) {
      pair = volumeParityAttributeValuePair();
         m_AttributePairList.addElement( pair );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PARITY_ERROR_FILE:
      case MEDIA_ERROR_FILE:
      case STARTING_LBA:
      case ENDING_LBA:
      case PRIORITY:
      case VERBOSE:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_3;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid Parity Check attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute volumeParityAttributeValuePair() throws ParseException {
   String   parityErrorFile = null;
   String       mediaErrorFile = null;
   int      priority = VolumeScanPriority.VOLUME_SCAN_PRIORITY_2;
   long         startingLBA;
   long         endingLBA;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARITY_ERROR_FILE:
      jj_consume_token(PARITY_ERROR_FILE);
      jj_consume_token(EQUALS);
      parityErrorFile = stringLiteral();
      {if (true) return new StringAttributeValuePair(Attribute.PARITY_ERROR_FILE, parityErrorFile);}
      break;
    case MEDIA_ERROR_FILE:
      jj_consume_token(MEDIA_ERROR_FILE);
      jj_consume_token(EQUALS);
      mediaErrorFile = stringLiteral();
       {if (true) return new StringAttributeValuePair(Attribute.MEDIA_ERROR_FILE, mediaErrorFile);}
      break;
    case PRIORITY:
      jj_consume_token(PRIORITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOWEST:
        jj_consume_token(LOWEST);
         priority = VolumeScanPriority.VOLUME_SCAN_PRIORITY_4;
        break;
      case LOW:
        jj_consume_token(LOW);
         priority = VolumeScanPriority.VOLUME_SCAN_PRIORITY_3;
        break;
      case MEDIUM:
        jj_consume_token(MEDIUM);
         priority = VolumeScanPriority.VOLUME_SCAN_PRIORITY_2;
        break;
      case HIGH:
        jj_consume_token(HIGH);
         priority = VolumeScanPriority.VOLUME_SCAN_PRIORITY_1;
        break;
      case HIGHEST:
        jj_consume_token(HIGHEST);
         priority = VolumeScanPriority.VOLUME_SCAN_PRIORITY_0;
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new IntegerAttributeValuePair(Attribute.SCAN_PRIORITY, priority);}
      break;
    case STARTING_LBA:
      jj_consume_token(STARTING_LBA);
      jj_consume_token(EQUALS);
      startingLBA = longLiteral();
        {if (true) return new LongAttributeValuePair(Attribute.STARTING_LBA, startingLBA);}
      break;
    case ENDING_LBA:
      jj_consume_token(ENDING_LBA);
      jj_consume_token(EQUALS);
      endingLBA = longLiteral();
        {if (true) return new LongAttributeValuePair(Attribute.ENDING_LBA, endingLBA);}
      break;
    case VERBOSE:
      jj_consume_token(VERBOSE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.VERBOSE, token.image);}
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Delete a volume mapping for a LUN host combination.  If the LUN and host are not specified
ALL mappings are deleted for this volume.
<BR><BR>
*/
  final public void deleteMappingStatement() throws ParseException, ScriptException {
   String      volume;
    jj_consume_token(DELETE);
    jj_consume_token(MAPPING);
    jj_consume_token(VOLUME);
    jj_consume_token(EQUALS);
    volume = nameSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOST:
    case HOST_GROUP:
      hostOrHostGroupNameSpec();
      break;
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      m_VolumeMapping.setVolume (volume);

      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.deleteVolumeMapping( m_VolumeMapping, true );

      }
  }

/**
DESCRIPTION: <BR>
Create host will create the the specified host.
command syntax:  create host userLabel=user-label [hostGroup=host-group-spec]
<BR><BR>
*/
  final public void createHostStatement() throws ParseException, ScriptException {
    jj_consume_token(CREATE);
    jj_consume_token(HOST);
    hostAttributeValueList();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.createHost( m_AttributePairList );
      }
  }

/**
DESCRIPTION: <BR>
Create hostGroup will create the the specified host group.  
command syntax:  create hostGroup userLabel=user-label
<BR><BR>
*/
  final public void createHostGroupStatement() throws ParseException, ScriptException {
   String               hostGroupName = null;
    jj_consume_token(CREATE);
    jj_consume_token(HOST_GROUP);
    jj_consume_token(USER_LABEL);
    jj_consume_token(EQUALS);
    hostGroupName = userLabelLiteral();
    jj_consume_token(SEMICOLON);
     if ( ! m_SyntaxCheckOnly )
     {
        m_HostTopologyExecutor.createHostGroup( hostGroupName );
     }
  }

/**
DESCRIPTION: <BR>
Create hostPort will create the the specified host port.
create hostPort identifier=www userlabel=<userLabel> {attr-setting}
      attr-setting -> (hostType=type-string | host=host-spec)
<BR><BR>
*/
  final public void createHostPortStatement() throws ParseException, ScriptException {
    jj_consume_token(CREATE);
    jj_consume_token(HOST_PORT);
    hostPortAttributeValueList();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.createHostPort(m_AttributePairList );
      }
  }

/**
DESCRIPTION: <BR>
Download drive firmware.
<BR><BR>
*/
  final public void downloadDriveStatement() throws ParseException, ScriptException {
    jj_consume_token(DOWNLOAD);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DRIVE:
      jj_consume_token(DRIVE);
      break;
    case DRIVES:
      jj_consume_token(DRIVES);
      break;
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    driveList();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRMWARE:
      jj_consume_token(FIRMWARE);
      drivePackageAttributeList();
      break;
    case FILE:
      drivePackageAttributeList();
      jj_consume_token(CONTENT);
      jj_consume_token(EQUALS);
      jj_consume_token(FIRMWARE);
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
                m_DriveExecutor.downloadDriveFirmwareParallel(m_AttributePairList, m_DriveList);
      }
  }

/**
DESCRIPTION: <BR>
Download ESM firmware to one or all trays.
<BR><BR>
*/
  final public void downloadTrayStatement() throws ParseException, ScriptException {
    String  fileName;
    int     trayId;
    jj_consume_token(DOWNLOAD);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL_TRAYS:
      jj_consume_token(ALL_TRAYS);
         trayId = -1;
      break;
    case TRAY:
      jj_consume_token(TRAY);
      jj_consume_token(LBRACKET);
      trayId = integerLiteral();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRMWARE:
      jj_consume_token(FIRMWARE);
      jj_consume_token(FILE);
      jj_consume_token(EQUALS);
      fileName = stringLiteral();
      break;
    case FILE:
      jj_consume_token(FILE);
      jj_consume_token(EQUALS);
      fileName = stringLiteral();
      jj_consume_token(CONTENT);
      jj_consume_token(EQUALS);
      jj_consume_token(FIRMWARE);
      break;
    default:
      jj_la1[72] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_TrayExecutor.downloadESMFirmware(trayId, fileName);
      }
  }

/**
DESCRIPTION: <BR>
Download the specified firmware or feature keys to the storage array.  
This command will throw a ScriptException of type RESTART_EXCEPTION when the management
class changed during the operation.  
This will cause the ScriptEngine to be regenerated and script execution to resume 
where it left off with the new ScriptEngine.
<BR><BR>
*/
  final public void downloadSArrayStatement() throws ParseException, ScriptException {
   String      string = null;
   String      stringNvsram = null;
   int         fileType = -1;
   boolean     isFeatureKey = false;
   boolean     allowDowngrade = false;
   boolean     withNVSRAM = false;
   boolean     activateNow = true;
   boolean     isParallelDriveDownload = false;
    jj_consume_token(DOWNLOAD);
    jj_consume_token(STORAGE_ARRAY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NVSRAM_FILE:
    case FIRMWARE_FILE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FIRMWARE_FILE:
        jj_consume_token(FIRMWARE_FILE);
               fileType = CompatibilityChecker.FIRMWARE;
        break;
      case NVSRAM_FILE:
        jj_consume_token(NVSRAM_FILE);
               fileType = CompatibilityChecker.NVSRAM;
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(EQUALS);
      string = stringLiteral();
      break;
    case FILE:
      jj_consume_token(FILE);
      jj_consume_token(EQUALS);
      string = stringLiteral();
      jj_consume_token(CONTENT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FIRMWARE:
        jj_consume_token(FIRMWARE);
               fileType = CompatibilityChecker.FIRMWARE;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOWNGRADE:
          jj_consume_token(DOWNGRADE);
          jj_consume_token(EQUALS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TRUE:
            jj_consume_token(TRUE);
                     allowDowngrade = true;
            break;
          case FALSE:
            jj_consume_token(FALSE);
                     allowDowngrade = false;
            break;
          default:
            jj_la1[74] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[75] = jj_gen;
          ;
        }
        break;
      case NVSRAM:
        jj_consume_token(NVSRAM);
               fileType = CompatibilityChecker.NVSRAM;
        break;
      case FEATURE_KEY:
        jj_consume_token(FEATURE_KEY);
               isFeatureKey = true;
        break;
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case FIRMWARE:
    case NVSRAM:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FIRMWARE:
        jj_consume_token(FIRMWARE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          jj_consume_token(NVSRAM);
                   withNVSRAM = true;
          break;
        default:
          jj_la1[77] = jj_gen;
          ;
        }
        jj_consume_token(FILE);
        jj_consume_token(EQUALS);
        string = stringLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          stringNvsram = stringLiteral();
          break;
        default:
          jj_la1[78] = jj_gen;
          ;
        }
                   fileType = CompatibilityChecker.FIRMWARE;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOWNGRADE:
          jj_consume_token(DOWNGRADE);
          jj_consume_token(EQUALS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TRUE:
            jj_consume_token(TRUE);
                            allowDowngrade = true;
            break;
          case FALSE:
            jj_consume_token(FALSE);
                            allowDowngrade = false;
            break;
          default:
            jj_la1[79] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[80] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ACTIVATE_NOW:
          jj_consume_token(ACTIVATE_NOW);
          jj_consume_token(EQUALS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TRUE:
            jj_consume_token(TRUE);
                            activateNow = true;
            break;
          case FALSE:
            jj_consume_token(FALSE);
                            activateNow = false;
            break;
          default:
            jj_la1[81] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[82] = jj_gen;
          ;
        }
        break;
      case NVSRAM:
        jj_consume_token(NVSRAM);
                  fileType = CompatibilityChecker.NVSRAM;
        jj_consume_token(FILE);
        jj_consume_token(EQUALS);
        string = stringLiteral();
        break;
      default:
        jj_la1[83] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case DRIVEFIRMWARE:
      jj_consume_token(DRIVEFIRMWARE);
            isParallelDriveDownload = true;
      drivePackageAttributeList();
      break;
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         if (!isFeatureKey)
         {
            if (!isParallelDriveDownload)
            {
               try
               {
                  m_ControllerExecutor.downloadControllerFirmware(
                  string, stringNvsram,
                  fileType, allowDowngrade,
                  withNVSRAM, activateNow);
               }
               catch (ScriptException e)
               {
                  cancel();
                  // Note: Line number is set in the CommandExecutor
                  e.setColumn(m_CharStream.getEndColumn());
                  {if (true) throw e;}
               }
            }
            else
            {
               m_DriveExecutor.downloadDriveFirmwareParallel(m_AttributePairList, null);
            }
         }
         else
         {
            // Download a set of feature keys
            m_SArrayExecutor.downloadFeatureKeys( string);
         }
      }
  }

/**
DESCRIPTION: <BR>
Sets the list of attributes provided on the specified controller.
<BR><BR>
*/
  final public void setControllerStatement() throws ParseException, ScriptException {
   int         preferredId;
   int         iscsiHostPort;
   String      controller = null;
   String[]    hostChannel = null;
    jj_consume_token(SET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOST_CHANNEL:
      jj_consume_token(HOST_CHANNEL);
      jj_consume_token(LBRACKET);
      hostChannel = driveSpec();
      jj_consume_token(RBRACKET);
      jj_consume_token(PREFERRED_ID);
      jj_consume_token(EQUALS);
      preferredId = integerLiteral();
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_ControllerExecutor.sethostChannel(hostChannel, preferredId);
      }
      break;
    case CONTROLLER:
      jj_consume_token(CONTROLLER);
      jj_consume_token(LBRACKET);
      controller = controllerSpec();
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AVAILABILITY:
      case NVSRAM_BYTE:
      case BATTERY_INSTALL_DATE:
      case GLOBAL_NVSRAM_BYTE:
      case HOST_NVSRAM_BYTE:
      case REMOTE_ACCESS_ENABLED:
      case ETHERNET_PORT:
      case SERVICE_MODE:
      case SERVICE_ALLOWED_INDICATOR:
      case GATEWAY_IP:
      case IPV4_GATEWAY_IP:
      case IPV6_ROUTER_ADDRESS:
        contAttributeValueList();
        jj_consume_token(SEMICOLON);
         if ( ! m_SyntaxCheckOnly )
         {
            m_ControllerExecutor.setController(controller, m_AttributePairList);
         }
        break;
      case ISCSI_HOST_PORT:
        jj_consume_token(ISCSI_HOST_PORT);
        jj_consume_token(LBRACKET);
        iscsiHostPort = integerLiteral();
        jj_consume_token(RBRACKET);
        iscsiPortAttributeValueList();
        jj_consume_token(SEMICOLON);
         if ( ! m_SyntaxCheckOnly )
         {
            m_ControllerExecutor.setControllerIscsiPort(controller, iscsiHostPort, m_AttributePairList);
         }
        break;
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Sets the list of attributes provided on the storage array.  Also allows
the "base line" to be set for Read Link Status Diagnostics on a 
storage array.
<BR><BR>
*/
  final public void setSArrayStatement() throws ParseException, ScriptException {
   String       ipAddress;
   int          isnsTcpPort;
   boolean  enable = false;
   String   path = null;
   int      daysToInterval=-1;
   String   day = null;
   String   time = null;
    jj_consume_token(SET);
    jj_consume_token(STORAGE_ARRAY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER_LABEL:
    case TIME_OF_DAY:
    case BATTERY_INSTALL_DATE:
    case CACHE_BLOCK_SIZE:
    case CLEAR_EVENT_LOG:
    case DEMAND_FLUSH_AMOUNT:
    case DEMAND_FLUSH_THRESHOLD:
    case MEDIA_SCAN_RATE:
    case PASSWORD:
    case RESET_CONFIG:
    case DEFAULT_HOST_TYPE:
    case FAILOVER_ALERT_DELAY:
    case ALARM:
    case REDUNDANCYMODE:
      sArrayAttributeValueList();
      jj_consume_token(SEMICOLON);
         if ( ! m_SyntaxCheckOnly )
         {
            m_SArrayExecutor.setSArray(m_AttributePairList);
         }
      break;
    case TIME:
      jj_consume_token(TIME);
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setTime();
         }
      break;
    case TRAY_POSITIONS:
      jj_consume_token(TRAY_POSITIONS);
      jj_consume_token(EQUALS);
      jj_consume_token(LPAREN);
      trayIdList();
      jj_consume_token(RPAREN);
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setTrayPositions(m_TrayIdList);
         }
      break;
    case RLS_BASELINE:
      jj_consume_token(RLS_BASELINE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUALS:
        jj_consume_token(EQUALS);
        jj_consume_token(CURRENT_TIME);
        break;
      default:
        jj_la1[87] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
         if ( ! m_SyntaxCheckOnly )
         {
            m_SArrayExecutor.setReadLinkStatusBaseline();
         }
      break;
    case SOC_BASELINE:
      jj_consume_token(SOC_BASELINE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUALS:
        jj_consume_token(EQUALS);
        jj_consume_token(CURRENT_TIME);
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
         if ( ! m_SyntaxCheckOnly )
         {
            m_SArrayExecutor.setSOCBaseline();
         }
      break;
    case ICMP_PING_RESPONSE:
      jj_consume_token(ICMP_PING_RESPONSE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[89] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         m_AttributePairList.addElement(new BooleanAttributeValuePair(Attribute.ICMP_PING_RESPONSE,
            token.image));
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setIsnsServerSettings(m_AttributePairList);
         }
      break;
    case ISNS_IPV4_CONFIGURATION_METHOD:
      jj_consume_token(ISNS_IPV4_CONFIGURATION_METHOD);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DHCP:
        jj_consume_token(DHCP);
        break;
      case STATIC:
        jj_consume_token(STATIC);
        break;
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         m_AttributePairList.addElement(new StringAttributeValuePair(
                                        Attribute.ISNS_IPV4_CONFIGURATION_METHOD, token.image));
      jj_consume_token(ISNS_IPV4_ADDRESS);
      jj_consume_token(EQUALS);
      ipAddress = ipSpec();
      jj_consume_token(SEMICOLON);
         m_AttributePairList.addElement(new StringAttributeValuePair(Attribute.ISNS_IPV4_ADDRESS,
            ipAddress));

         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setIsnsServerSettings(m_AttributePairList);
         }
      break;
    case ISNS_IPV6_ADDRESS:
      jj_consume_token(ISNS_IPV6_ADDRESS);
      jj_consume_token(EQUALS);
      ipAddress = ipv6Spec();
      jj_consume_token(SEMICOLON);
         m_AttributePairList.addElement(new StringAttributeValuePair(Attribute.ISNS_IPV6_ADDRESS,
            ipAddress));

         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setIsnsServerSettings(m_AttributePairList);
         }
      break;
    case ISNS_LISTENING_PORT:
      jj_consume_token(ISNS_LISTENING_PORT);
      jj_consume_token(EQUALS);
      isnsTcpPort = integerLiteral();
      jj_consume_token(SEMICOLON);
         m_AttributePairList.addElement(new IntegerAttributeValuePair(Attribute.ISNS_LISTENING_PORT,
           isnsTcpPort));

         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setIsnsServerSettings(m_AttributePairList);
         }
      break;
    case UNNAMED_DISCOVERY_SESSION:
      jj_consume_token(UNNAMED_DISCOVERY_SESSION);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[91] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         m_AttributePairList.addElement(new BooleanAttributeValuePair(
            Attribute.UNNAMED_DISCOVERY_SESSION, token.image));
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setIsnsServerSettings(m_AttributePairList);
         }
      break;
    case ISNS_REGISTRATION:
      jj_consume_token(ISNS_REGISTRATION);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[92] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         m_AttributePairList.addElement(
            new BooleanAttributeValuePair(Attribute.ISNS_REGISTRATION, token.image));
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setIsnsServerSettings(m_AttributePairList);
         }
      break;
    case AUTO_SUPPORT_CONFIG:
      jj_consume_token(AUTO_SUPPORT_CONFIG);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENABLE:
        jj_consume_token(ENABLE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PATH:
          jj_consume_token(PATH);
          jj_consume_token(EQUALS);
          path = stringLiteral();
          break;
        default:
          jj_la1[93] = jj_gen;
          ;
        }
         enable = true;
        break;
      case DISABLE:
        jj_consume_token(DISABLE);
        break;
      default:
        jj_la1[94] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_SArrayExecutor.setAutoDataCollection(enable, path);
         }
      break;
    case LEARN_CYCLE_DATE:
      jj_consume_token(LEARN_CYCLE_DATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DAYS_TO_NEXT_LEARNCYCLE:
        jj_consume_token(DAYS_TO_NEXT_LEARNCYCLE);
        jj_consume_token(EQUALS);
        daysToInterval = integerLiteral();
        break;
      case DAY:
        jj_consume_token(DAY);
        jj_consume_token(EQUALS);
        day = daySpec();
        break;
      default:
        jj_la1[95] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIME:
        jj_consume_token(TIME);
        jj_consume_token(EQUALS);
        time = timeSpec();
        break;
      default:
        jj_la1[96] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
                   if (!m_SyntaxCheckOnly)
                   {
                      m_SArrayExecutor.setBatteryLearnCycles(daysToInterval, day, time);
                   }
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Sets session related attributes.
<BR><BR>
*/
  final public void setSessionStatement() throws ParseException, ScriptException {
    jj_consume_token(SET);
    jj_consume_token(SESSION);
    sArraySessionAttributeValueList();
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.setSArraySession(m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Sets volume related attributes.
<BR><BR>
*/
  final public void setVolumeStatement() throws ParseException, ScriptException {
    if (jj_2_103(2)) {
      setSingleVolStatement();
    } else if (jj_2_104(2)) {
      setMultiVolStatement();
    } else if (jj_2_105(2)) {
      setAllVolsStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SET:
        setAccessVolStatement();
        break;
      default:
        jj_la1[98] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
Sets volume attributes for a single volume.
<BR><BR>
*/
  final public void setSingleVolStatement() throws ParseException, ScriptException {
   String      volume = null;
   boolean     isViaWwn = false;
    jj_consume_token(SET);
    jj_consume_token(VOLUME);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      volume = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    case LESS_THAN:
      jj_consume_token(LESS_THAN);
      volume = nameSpec();
      jj_consume_token(GREATER_THAN);
         isViaWwn = true;
      break;
    default:
      jj_la1[99] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    volumeAttributeValueList();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         if (!isViaWwn)
         {
            m_VolumeExecutor.setVolumeByName(volume, m_AttributePairList);
         }
         else
         {
            m_VolumeExecutor.setVolumeByWwn(volume, m_AttributePairList);
         }
      }
  }

/**
DESCRIPTION: <BR>
Sets volume attributes for a set of volumes.
<BR><BR>
*/
  final public void setMultiVolStatement() throws ParseException, ScriptException {
    jj_consume_token(SET);
    jj_consume_token(VOLUMES);
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    multipleVolumeAttributeValueList();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.setVolumeCommand(m_NameSpecList, m_AttributePairList, true);
      }
  }

/**
DESCRIPTION: <BR>
Sets volume attributes for all of the volumes in this storage array.
<BR><BR>
*/
  final public void setAllVolsStatement() throws ParseException, ScriptException {
    jj_consume_token(SET);
    jj_consume_token(ALL_VOLUMES);
    multipleVolumeAttributeValueList();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.setAllVolumes(m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Sets alarm properties for all trays in a storage array.
<BR><BR>
*/
  final public void setAllTraysStatement() throws ParseException, ScriptException {
   int alarmControl;
    jj_consume_token(SET);
    jj_consume_token(ALL_TRAYS);
    jj_consume_token(ALARM);
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENABLE:
      jj_consume_token(ENABLE);
                                alarmControl = AlarmControl.ALARM_CONTROL_ENABLE;
      break;
    case DISABLE:
      jj_consume_token(DISABLE);
                                alarmControl = AlarmControl.ALARM_CONTROL_DISABLE;
      break;
    case MUTE:
      jj_consume_token(MUTE);
                                alarmControl = AlarmControl.ALARM_CONTROL_MUTE;
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
                 if (!m_SyntaxCheckOnly)
                 {
                        m_TrayExecutor.setAllTraysAlarm(alarmControl);
                 }
  }

/**
DESCRIPTION: <BR>
Sets volume attributes for an access volume, only support set lun mapping.
<BR><BR>
*/
  final public void setAccessVolStatement() throws ParseException, ScriptException {
    jj_consume_token(SET);
    jj_consume_token(ACCESS_VOLUME);
    LUNSpec();
    hostOrHostGroupNameSpec();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeMapping.setAccessVolumeMapping();
         m_VolumeExecutor.setAccessVolumeMapping(m_VolumeMapping);
      }
  }

/**
DESCRIPTION: <BR>
Sets the list of attributes provided on the specified volume group.
<BR><BR>
*/
  final public void setVolumeGroupStatement() throws ParseException, ScriptException {
   int      volumeGroup = -1;
   String   volumeGroupName = null;
    jj_consume_token(SET);
    jj_consume_token(VOLUME_GROUP);
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
    case IDENTIFIER:
      volumeGroupName = nameSpec();
      break;
    case INTEGER_LITERAL:
    case 469:
      volumeGroup = integerLiteral();
      break;
    default:
      jj_la1[101] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
      if (volumeGroupName == null)
      {
          volumeGroupName = Integer.toString(volumeGroup);
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AVAILABILITY:
    case USER_LABEL:
    case OWNER:
    case RAID_LEVEL:
    case STATE:
      volGroupAttributeValueList();
      jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.setVolumeGroup(volumeGroupName, m_AttributePairList);
      }
      break;
    case ADD_DRIVES:
      jj_consume_token(ADD_DRIVES);
      jj_consume_token(EQUALS);
      jj_consume_token(LPAREN);
      driveList();
      jj_consume_token(RPAREN);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.addDrives(volumeGroupName, m_DriveList);
      }
      break;
    case FORCED_STATE:
      jj_consume_token(FORCED_STATE);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.setVolumeGroupImportForceState(volumeGroupName);
      }
      break;
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Sets the list of attributes provided on the specified drive(s).
<BR><BR>
*/
  final public void setDriveStatement() throws ParseException, ScriptException {
   String[] sourceDrive = null;
   boolean  allDrives = false;
   boolean  attributesForDrive = false;
   boolean  attributesForDrives = false;
    jj_consume_token(SET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL_DRIVES:
      jj_consume_token(ALL_DRIVES);
      jj_consume_token(NATIVE_STATE);
            allDrives = true;
      break;
    case DRIVES:
      jj_consume_token(DRIVES);
      jj_consume_token(LBRACKET);
      driveList();
      jj_consume_token(RBRACKET);
      driveAttributeValueList();
             attributesForDrives = true;
      break;
    case DRIVE:
      jj_consume_token(DRIVE);
      jj_consume_token(LBRACKET);
      sourceDrive = driveSpec();
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NATIVE_STATE:
        jj_consume_token(NATIVE_STATE);
        break;
      case HOT_SPARE:
      case OPERATIONAL_STATE:
      case SERVICE_ALLOWED_INDICATOR:
        driveAttributeValueList();
            attributesForDrive = true;
        break;
      default:
        jj_la1[103] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[104] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {

         if( allDrives == true )
         {
            m_DriveExecutor.setDrivesToNative();
         }
         else if( attributesForDrive == true )
         {
             m_DriveExecutor.setDrive(sourceDrive, m_AttributePairList);
         }
         else if( attributesForDrives == true)
         {
             m_DriveExecutor.setDrives(m_DriveList, m_AttributePairList);
         }
         else
         {
            m_DriveExecutor.setDriveToNative(sourceDrive);
         }
       }
  }

/**
DESCRIPTION: <BR>
Sets the list of attributes provided for performance stats sampling.
If this command is not used, default will be 5 second sample, 1 time.
<BR><BR>
*/
  final public void setPerformanceStatsStatement() throws ParseException, ScriptException {
   Object[]       formatArgs = new Object[3];
   String         errorString = null;
   int            setInterval;
   int            setIterations;
    jj_consume_token(SET);
    jj_consume_token(PERFORMANCE_MONITOR);
    jj_consume_token(SAMPLE_INTERVAL);
    jj_consume_token(EQUALS);
    setInterval = integerLiteral();
    jj_consume_token(SAMPLE_ITERATIONS);
    jj_consume_token(EQUALS);
    setIterations = integerLiteral();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         if( setInterval < PERF_MON_INTERVAL_MIN || setInterval > PERF_MON_INTERVAL_MAX )
         {
            formatArgs[0] = Integer.toString(getLine());
            formatArgs[1] = Integer.toString(PERF_MON_INTERVAL_MIN);
            formatArgs[2] = Integer.toString(PERF_MON_INTERVAL_MAX);
            errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           formatArgs);
            m_ParseException = new ParseException(errorString);
            {if (true) throw m_ParseException;}
         }
         else if( (setIterations < PERF_MON_ITERATIONS_MIN) ||
                     (setIterations > PERF_MON_ITERATIONS_MAX ))
         {
            formatArgs[0] = Integer.toString(getLine());
            formatArgs[1] = Integer.toString(PERF_MON_ITERATIONS_MIN);
            formatArgs[2] = Integer.toString(PERF_MON_ITERATIONS_MAX);
            errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           formatArgs);
            m_ParseException = new ParseException(errorString);
            {if (true) throw m_ParseException;}
         }
         else
         {
            m_SArrayExecutor.setPerfMonValues(setInterval, setIterations);
         }
      }
  }

/**
DESCRIPTION: <BR>
Reboot the specified controller.
<BR><BR>
*/
  final public void resetControllerStatement() throws ParseException, ScriptException {
    String controllerSlot = null;
    jj_consume_token(RESET);
    jj_consume_token(CONTROLLER);
    jj_consume_token(LBRACKET);
    controllerSlot = controllerSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_ControllerExecutor.resetController(controllerSlot);
      }
  }

/**
DESCRIPTION: <BR>
The reset command for storage arrays.
<BR><BR>
*/
  final public void resetSArrayStatement() throws ParseException, ScriptException {
   String controllerSlot = null;
   String batterySlot = null;
    jj_consume_token(RESET);
    jj_consume_token(STORAGE_ARRAY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BATTERY_INSTALL_DATE:
      jj_consume_token(BATTERY_INSTALL_DATE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONTROLLER:
      case BATTERY_PACK:
        if (jj_2_106(2)) {
          jj_consume_token(CONTROLLER);
          jj_consume_token(EQUALS);
          controllerSlot = controllerSpec();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CONTROLLER:
            jj_consume_token(CONTROLLER);
            jj_consume_token(LBRACKET);
            controllerSlot = controllerSpec();
            jj_consume_token(RBRACKET);
            break;
          case BATTERY_PACK:
            jj_consume_token(BATTERY_PACK);
            jj_consume_token(LBRACKET);
            batterySlot = batterySlotSpec();
            jj_consume_token(RBRACKET);
            break;
          default:
            jj_la1[105] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[106] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
        m_SArrayExecutor.resetBatteryAgeSA(controllerSlot, batterySlot);
      }
      break;
    case RLS_BASELINE:
      jj_consume_token(RLS_BASELINE);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.setReadLinkStatusBaseline();
      }
      break;
    case SOC_BASELINE:
      jj_consume_token(SOC_BASELINE);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.setSOCBaseline();
      }
      break;
    case VOLUME_DISTRIBUTION:
      jj_consume_token(VOLUME_DISTRIBUTION);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.volumeDistribution();
      }
      break;
    case DIAGNOSTIC_DATA:
      jj_consume_token(DIAGNOSTIC_DATA);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.resetDiagnosticData();
      }
      break;
    case SAS_PHYBASELINE:
      jj_consume_token(SAS_PHYBASELINE);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.resetSasPhyBaseline();
      }
      break;
    case ISCSI_STATISTICS_BASELINE:
      jj_consume_token(ISCSI_STATISTICS_BASELINE);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.resetIscsiStatsBaseline();
      }
      break;
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Shows the list of attributes provided on the storage array.
<BR><BR>
*/
  final public void showSArrayStatement() throws ParseException, ScriptException {
   boolean isShowSummary = false;
    jj_consume_token(SHOW);
    jj_consume_token(STORAGE_ARRAY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEALTH_STATUS:
    case PROFILE:
    case BATTERY_AGE:
    case VOLUME_DISTRIBUTION:
    case HOT_SPARE_COVERAGE:
    case HOST_TYPE_TABLE:
    case DEFAULT_HOST_TYPE:
    case PREFERRED_VOLUME_OWNERS:
    case FEATURES:
    case TIME:
    case ISCSI_NEGOTIATION_DEFAULTS:
    case UNCONFIGURED_ISCSI_INITIATORS:
      sArrayAttributeList();
      break;
    default:
      jj_la1[108] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SUMMARY:
      jj_consume_token(SUMMARY);
      isShowSummary = true;
      break;
    default:
      jj_la1[109] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.showSArray(m_AttributeList, isShowSummary);
      }
  }

/**
DESCRIPTION: <BR>
Shows the list of attributes provided on the specified controller.
<BR><BR>
*/
  final public void showControllerStatement() throws ParseException, ScriptException {
   String   cont = null;
   boolean  isShowSummary = false;
    jj_consume_token(SHOW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONTROLLER:
      jj_consume_token(CONTROLLER);
      jj_consume_token(LBRACKET);
      cont = controllerSpec();
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NVSRAM_BYTE:
      case NVSRAM:
      case GLOBAL_NVSRAM_BYTE:
      case HOST_NVSRAM_BYTE:
        contAttributeList();
        break;
      default:
        jj_la1[110] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUMMARY:
        jj_consume_token(SUMMARY);
            isShowSummary = true;
        break;
      default:
        jj_la1[111] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
         if ( ! m_SyntaxCheckOnly )
         {
            m_ControllerExecutor.showController(cont, m_AttributeList, isShowSummary);
         }
      break;
    case ALL_CONTROLLERS:
      jj_consume_token(ALL_CONTROLLERS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NVSRAM_BYTE:
      case NVSRAM:
      case GLOBAL_NVSRAM_BYTE:
      case HOST_NVSRAM_BYTE:
        contAttributeList();
        break;
      default:
        jj_la1[112] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUMMARY:
        jj_consume_token(SUMMARY);
            isShowSummary = true;
        break;
      default:
        jj_la1[113] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
         if ( ! m_SyntaxCheckOnly )
         {
            m_ControllerExecutor.showAllControllers(m_AttributeList, isShowSummary);
         }
      break;
    default:
      jj_la1[114] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Displays the storage array host topology.
<BR><BR>
*/
  final public void showSArrayHostTopologyStatement() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOST_TOPOLOGY:
      jj_consume_token(HOST_TOPOLOGY);
      break;
    case STORAGE_ARRAY:
      jj_consume_token(STORAGE_ARRAY);
      jj_consume_token(HOST_TOPOLOGY);
      break;
    default:
      jj_la1[115] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.showHostTopology();
      }
  }

/**
DESCRIPTION: <BR>
Displays the storage array lunMappings.
<BR><BR>
*/
  final public void showSArrayLunMappings() throws ParseException, ScriptException {
   String       hostName = null;
   String       hostGroupName = null;
    jj_consume_token(SHOW);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(LUN_MAPPINGS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOST:
    case HOST_GROUP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOST:
        jj_consume_token(HOST);
        jj_consume_token(LBRACKET);
        hostName = stringLiteral();
        jj_consume_token(RBRACKET);
        break;
      case HOST_GROUP:
        jj_consume_token(HOST_GROUP);
        jj_consume_token(LBRACKET);
        hostGroupName = stringLiteral();
        jj_consume_token(RBRACKET);
        break;
      default:
        jj_la1[116] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[117] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.showSArrayLunMappings(hostName, hostGroupName);
      }
  }

/**
DESCRIPTION: <BR>
Displays the storage array connections
<P>
*/
  final public void showSArrayConnections() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(CONNECTIONS);
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.showConnections();
      }
  }

/**
DESCRIPTION: <BR>
Shows information for a specific volume group.
<BR><BR>
*/
  final public void showVolumeGroupStatement() throws ParseException, ScriptException {
   int      volumeGroup = -1;
   String   volumeGroupName = null;
   boolean  cancelImport = false;
    jj_consume_token(SHOW);
    jj_consume_token(VOLUME_GROUP);
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
    case IDENTIFIER:
      volumeGroupName = nameSpec();
      break;
    case INTEGER_LITERAL:
    case 469:
      volumeGroup = integerLiteral();
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      if (volumeGroupName == null)
      {
         volumeGroupName = Integer.toString(volumeGroup);
      }

      if (!m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.showVolumeGroup(volumeGroupName);
      }
      break;
    case IMPORT_DEPENDENCIES:
      jj_consume_token(IMPORT_DEPENDENCIES);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CANCEL_IMPORT:
        jj_consume_token(CANCEL_IMPORT);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRUE:
          jj_consume_token(TRUE);
                   cancelImport = true;
          break;
        case FALSE:
          jj_consume_token(FALSE);
                   cancelImport = false;
          break;
        default:
          jj_la1[119] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[120] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
      if (volumeGroupName == null)
      {
         volumeGroupName = Integer.toString(volumeGroup);
      }

      if (!m_SyntaxCheckOnly)
      {
         if (cancelImport)
         {
                m_VolumeGroupExecutor.cancelVolumeGroupImport(volumeGroupName);
         }
         else
         {
            m_VolumeGroupExecutor.showVolumeGroupImportDependencies(volumeGroupName);
         }
      }
      break;
    case EXPORT_DEPENDENCIES:
      jj_consume_token(EXPORT_DEPENDENCIES);
      jj_consume_token(SEMICOLON);
      if (volumeGroupName == null)
      {
         volumeGroupName = Integer.toString(volumeGroup);
      }

      if (!m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.showVolumeGroupExportDependencies(volumeGroupName);
      }
      break;
    default:
      jj_la1[121] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Shows properties for a list or all of the volumes.
<BR><BR>
*/
  final public void showVolumeStatement() throws ParseException, ScriptException {
   boolean  isShowSummary = false;
   String   volume = null;
    if (jj_2_108(3)) {
      jj_consume_token(SHOW);
      jj_consume_token(VOLUMES);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLUME:
        jj_consume_token(VOLUME);
        jj_consume_token(LBRACKET);
        nameSpecList();
        jj_consume_token(RBRACKET);
        break;
      default:
        jj_la1[122] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.showVolumes(m_NameSpecList, isShowSummary);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHOW:
        if (jj_2_107(6)) {
          jj_consume_token(SHOW);
          jj_consume_token(VOLUME);
          jj_consume_token(LBRACKET);
          volume = nameSpec();
          jj_consume_token(RBRACKET);
          jj_consume_token(ACTION_PROGRESS);
          jj_consume_token(SEMICOLON);
         if (! m_SyntaxCheckOnly)
         {
            m_VolumeExecutor.showVolumeActionProgress(volume);
         }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SHOW:
            jj_consume_token(SHOW);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case ALL_VOLUMES:
              jj_consume_token(ALL_VOLUMES);
              break;
            case VOLUME:
            case VOLUMES:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case VOLUME:
                jj_consume_token(VOLUME);
                break;
              case VOLUMES:
                jj_consume_token(VOLUMES);
                break;
              default:
                jj_la1[123] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
              jj_consume_token(LBRACKET);
              nameSpecList();
              jj_consume_token(RBRACKET);
              break;
            default:
              jj_la1[124] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case SUMMARY:
            case SEMICOLON:
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case SUMMARY:
                jj_consume_token(SUMMARY);
            isShowSummary = true;
                break;
              default:
                jj_la1[125] = jj_gen;
                ;
              }
              jj_consume_token(SEMICOLON);
            if ( ! m_SyntaxCheckOnly )
            {
               m_VolumeExecutor.showVolumes(m_NameSpecList, isShowSummary);
            }
              break;
            case PERFORMANCE_STATS:
              jj_consume_token(PERFORMANCE_STATS);
              jj_consume_token(SEMICOLON);
            if ( ! m_SyntaxCheckOnly )
            {
               m_VolumeExecutor.showVolumePerformanceStats(m_NameSpecList);
            }
              break;
            case RESERVATIONS:
              jj_consume_token(RESERVATIONS);
              jj_consume_token(SEMICOLON);
            if ( ! m_SyntaxCheckOnly )
            {
               m_VolumeExecutor.showVolumeReservations(m_NameSpecList);
            }
              break;
            default:
              jj_la1[126] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
          default:
            jj_la1[127] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
Shows properties for a list or all of the drives.
<BR><BR>
*/
  final public void showDriveStatement() throws ParseException, ScriptException {
   boolean isShowSummary = false;
   boolean isShowDownloadProgress = false;
   boolean isShowReplaceable = false;
   int     physicalDriveType = PhysicalDriveType.PHY_DRIVE_TYPE_ALL;
    jj_consume_token(SHOW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL_DRIVES:
      jj_consume_token(ALL_DRIVES);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DRIVE_TYPE:
        jj_consume_token(DRIVE_TYPE);
        jj_consume_token(EQUALS);
        physicalDriveType = physicalDriveType();
        break;
      default:
        jj_la1[129] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUMMARY:
      case DOWNLOADPROGRESS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOWNLOADPROGRESS:
          jj_consume_token(DOWNLOADPROGRESS);
               isShowDownloadProgress = true;
          break;
        case SUMMARY:
          jj_consume_token(SUMMARY);
                  isShowSummary = true;
          break;
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[131] = jj_gen;
        ;
      }
      break;
    case DRIVE:
    case DRIVES:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DRIVE:
        jj_consume_token(DRIVE);
        break;
      case DRIVES:
        jj_consume_token(DRIVES);
        break;
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LBRACKET);
      driveList();
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUMMARY:
        jj_consume_token(SUMMARY);
              isShowSummary = true;
        break;
      default:
        jj_la1[133] = jj_gen;
        ;
      }
      break;
    case REPLACEABLE_DRIVES:
      jj_consume_token(REPLACEABLE_DRIVES);
              isShowReplaceable = true;
      break;
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            if (isShowReplaceable)
            {
               m_DriveExecutor.showReplaceableDrives();
            }
            else if (isShowDownloadProgress)
            {
               m_DriveExecutor.showParallelDriveDownloadProgress();
            }
            else
            {
               m_DriveExecutor.showDrives(m_DriveList, physicalDriveType, isShowSummary);
            }
         }
  }

/**
DESCRIPTION: <BR>
Shows remote mirror candidates.
<BR><BR>
*/
  final public void showRemoteMirrorCandidatesStatement() throws ParseException, ScriptException {
   String                        volumeLabel;
   String                        remoteArray;
   StringAttributeValuePair      stringAttribute;
    jj_consume_token(SHOW);
    jj_consume_token(REMOTE_MIRROR);
    jj_consume_token(CANDIDATES);
    jj_consume_token(PRIMARY);
    jj_consume_token(EQUALS);
    volumeLabel = stringLiteral();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REMOTE_ARRAY_NAME:
      jj_consume_token(REMOTE_ARRAY_NAME);
      jj_consume_token(EQUALS);
      remoteArray = nameSpec();
      stringAttribute = new StringAttributeValuePair(Attribute.REMOTE_ARRAY_NAME, remoteArray);
      break;
    case REMOTE_ARRAY_WWID:
      jj_consume_token(REMOTE_ARRAY_WWID);
      jj_consume_token(EQUALS);
      remoteArray = wwnStringSpec();
      stringAttribute = new StringAttributeValuePair(Attribute.REMOTE_ARRAY_WWID, remoteArray);
      break;
    case REMOTE_ARRAY_WWN:
      jj_consume_token(REMOTE_ARRAY_WWN);
      jj_consume_token(EQUALS);
      remoteArray = wwnStringSpec();
      stringAttribute = new StringAttributeValuePair(Attribute.REMOTE_ARRAY_WWN, remoteArray);
      break;
    default:
      jj_la1[135] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_RVMExecutor.showRVMCandidates(volumeLabel, stringAttribute);
      }
  }

/**
DESCRIPTION: <BR>
Shows currently active iscsi sessions.
<BR><BR>
*/
  final public void showIscsiSessionStatement() throws ParseException, ScriptException {
   boolean   targetViaIqn = false;
   boolean   initiatorViaIqn = false;
   String    target = null;
   String    initiator = null;
   int       filter = GetIscsiSessionsType.GET_ISCSI_SESSIONS_ALL;
    jj_consume_token(SHOW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ISCSI_INITIATOR:
    case ISCSI_TARGET:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ISCSI_INITIATOR:
        jj_consume_token(ISCSI_INITIATOR);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          jj_consume_token(LBRACKET);
          initiator = userLabelLiteral();
          jj_consume_token(RBRACKET);
          break;
        case LESS_THAN:
          jj_consume_token(LESS_THAN);
          initiator = stringLiteral();
          jj_consume_token(GREATER_THAN);
           initiatorViaIqn = true;
          break;
        default:
          jj_la1[136] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
         filter = GetIscsiSessionsType.GET_ISCSI_SESSIONS_BY_INITIATOR;
        break;
      case ISCSI_TARGET:
        jj_consume_token(ISCSI_TARGET);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
          jj_consume_token(LBRACKET);
          target = userLabelLiteral();
          jj_consume_token(RBRACKET);
          break;
        case LESS_THAN:
          jj_consume_token(LESS_THAN);
          target = stringLiteral();
          jj_consume_token(GREATER_THAN);
            targetViaIqn = true;
          break;
        default:
          jj_la1[137] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        filter = GetIscsiSessionsType.GET_ISCSI_SESSIONS_BY_TARGET;
        break;
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[139] = jj_gen;
      ;
    }
    jj_consume_token(ISCSI_SESSIONS);
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_IscsiExecutor.showIscsiSessions(initiator, initiatorViaIqn, target, targetViaIqn,
                                              filter);
      }
  }

/**
DESCRIPTION: <BR>
Shows synchronization progress on the selected remote mirrors.
<BR><BR>
*/
  final public void showRemoteMirrorProgressStatement() throws ParseException, ScriptException {
   String                        volumeLabel = null;
    jj_consume_token(SHOW);
    jj_consume_token(REMOTE_MIRROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCAL_VOLUME:
      jj_consume_token(LOCAL_VOLUME);
      jj_consume_token(LBRACKET);
      volumeLabel = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    case LOCAL_VOLUMES:
      jj_consume_token(LOCAL_VOLUMES);
      jj_consume_token(LBRACKET);
      nameSpecList();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[140] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SYNCHRONIZATION_PROGRESS);
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         if (volumeLabel != null)
         {
            m_NameSpecList.addElement(volumeLabel);
         }

         m_RVMExecutor.showMirrorSynchronizationProgress(m_NameSpecList);
      }
  }

/**
DESCRIPTION: <BR>
Displays a string literal to the output area with the quotes stripped off.
<BR> <BR>

EXAMPLE: <BR>
show "string";
*/
  final public void showStringStatement() throws ParseException, ScriptException {
   String   string;
    jj_consume_token(SHOW);
    string = stringLiteral();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
      m_SArrayExecutor.showString(string);
      }
  }

/**
Currently we support stateCapture, saveConfig, performanceStats, RLScounts, SOCCounts in upload statement.
<P>
NOTE: This command was deprecated in Yuma 1.0 (see OLBS doc 349-1032680).
*/
  final public void uploadStatement() throws ParseException, ScriptException {
   String fileName;
    jj_consume_token(UPLOAD);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
    jj_consume_token(CONTENT);
    jj_consume_token(EQUALS);
    uploadContentAttributeList();
    jj_consume_token(SEMICOLON);
       if (! m_SyntaxCheckOnly)
       {
          m_SArrayExecutor.performUploadOperation(fileName, m_AttributeList);
       }
  }

/**
DESCRIPTION: <BR>
This method uses  SArrayExecutor.performUploadOperation to save DCFIDiagnostics
<BR><BR>
*/
  final public void saveDriveChannelFaultDiagnosticsStatement() throws ParseException, ScriptException {
   String                    fileName = null;
   IntegerAttributeValuePair pair = null;
   Attribute                 attribute;
   int                       driveChannelId = -1;
    jj_consume_token(SAVE);
    jj_consume_token(DRIVE_CHANNEL);
    jj_consume_token(LBRACKET);
    driveChannelId = integerLiteral();
    jj_consume_token(RBRACKET);
    jj_consume_token(FAULT_DIAGNOSTICS);
        pair = new IntegerAttributeValuePair(Attribute.DRIVE_CHANNEL_FAULT_DIAGNOSTIC,
                                                driveChannelId);
        attribute = (Attribute)pair;
        m_AttributeList.addElement(attribute);
    jj_consume_token(FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.performUploadOperation(fileName, m_AttributeList);
      }
  }

/**
DESCRIPTION: <BR>
Currently we support stateCapture, saveConfig, performanceStats, 
RLScounts, SOCCounts, SASPHYError logs in save statement.
<BR><BR>
*/
  final public void saveStorageArrayStatement() throws ParseException, ScriptException {
   String    fileName = null;
    jj_consume_token(SAVE);
    jj_consume_token(STORAGE_ARRAY);
    uploadContentAttributeList();
   if (((Attribute)m_AttributeList.firstElement()).getAttributeType() == Attribute.DIAGNOSTIC_DATA)
   {
      saveDiagnosticDataAttribute();
   }
   else if (((Attribute)m_AttributeList.firstElement()).getAttributeType() == Attribute.ISCSI_STATISTICS)
   {
          saveIscsiStatisticsAttribute();
   }
    jj_consume_token(FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
      if (((Attribute)m_AttributeList.firstElement()).getAttributeType() == Attribute.ALL_EVENTS ||
            ((Attribute)m_AttributeList.firstElement()).getAttributeType() == Attribute.CRITICAL_EVENTS)
      {
         saveStorageArrayCountOperands();
      }
      else if (((Attribute)m_AttributeList.firstElement()).getAttributeType() == Attribute.CONFIGURATION)
      {
         saveConfigAttributeValueList();
      }
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SArrayExecutor.performUploadOperation(fileName, m_AttributeList);
      }
  }

/**
DESCRIPTION: <BR>
Saves the drive diagnostic data from all drives to file.
<BR><BR>
*/
  final public void saveDrivesLogStatement() throws ParseException, ScriptException {
    String fileName = null;
    jj_consume_token(SAVE);
    jj_consume_token(ALL_DRIVES);
    jj_consume_token(LOG_FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
    jj_consume_token(SEMICOLON);
        if (! m_SyntaxCheckOnly)
        {
            m_DriveExecutor.saveAllDrivesLogData(fileName);
        }
  }

/**
DESCRIPTION: <BR>
Starts a long running operation such as increasing volume capacity (DVE).
<BR><BR>
*/
  final public void startIncreaseVolumeCapacityStatement() throws ParseException, ScriptException {
   CapacityAttributeValuePair capacityPair = new CapacityAttributeValuePair();
   String                     volume;
    jj_consume_token(START);
    jj_consume_token(INCREASE_VOL_CAPACITY);
    jj_consume_token(VOLUME);
    jj_consume_token(EQUALS);
    volume = nameSpec();
    jj_consume_token(INCREMENTAL_CAPACITY);
    jj_consume_token(EQUALS);
    capacityPair = capacitySpec();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.increaseVolumeCapacity(volume, m_DriveList, capacityPair.getCapacity());
      }
  }

/**
DESCRIPTION: <BR>
Disable volume snapshot statement.  Must specify the volume name.
<BR><BR>
*/
  final public void disableSnapshotStatement() throws ParseException, ScriptException {
    jj_consume_token(DISABLE_SNAPSHOT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOLUME:
      jj_consume_token(VOLUME);
      break;
    case VOLUMES:
      jj_consume_token(VOLUMES);
      break;
    default:
      jj_la1[141] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SnapshotExecutor.disableSnapshot(m_NameSpecList);
      }
  }

/**
DESCRIPTION: <BR>
Disable volume snapshot statement.  Must specify the volume name.
<BR><BR>
*/
  final public void stopSnapshotStatement() throws ParseException, ScriptException {
    jj_consume_token(STOP);
    jj_consume_token(SNAPSHOT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOLUME:
      jj_consume_token(VOLUME);
      break;
    case VOLUMES:
      jj_consume_token(VOLUMES);
      break;
    default:
      jj_la1[142] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_SnapshotExecutor.disableSnapshot(m_NameSpecList);
      }
  }

/**
DESCRIPTION: <BR>
A recreate snapshot statement.  The snapshot is reconstituted from the base volume.
Any data on the repository volume is lost.  Must specify the volume name and
optionally several attributes.
<BR><BR>
*/
  final public void recreateSnapshotStatement() throws ParseException, ScriptException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RECREATE_SNAPSHOT:
      jj_consume_token(RECREATE_SNAPSHOT);
      break;
    case RECREATE:
      jj_consume_token(RECREATE);
      jj_consume_token(SNAPSHOT);
      break;
    default:
      jj_la1[143] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOLUME:
      jj_consume_token(VOLUME);
      break;
    case VOLUMES:
      jj_consume_token(VOLUMES);
      break;
    default:
      jj_la1[144] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER_LABEL:
    case REPOSITORY_FULL_POLICY:
    case WARNING_THRESHOLD_PERCENT:
    case ENFORCESOFTLIMIT:
      recreateSnapshotVolAttributeList();
      break;
    default:
      jj_la1[145] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_SnapshotExecutor.recreateSnapshotVolumes(m_NameSpecList, m_AttributePairList);
         }
  }

/**
DESCRIPTION: <BR>
Starts a volume copy operation.
<BR><BR>
*/
  final public void startVolumeCopyStatement() throws ParseException, ScriptException {
   String      source = null;
   String      target = null;
   int         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_2;
    jj_consume_token(START);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(SOURCE);
    jj_consume_token(EQUALS);
    source = nameSpec();
    jj_consume_token(TARGET);
    jj_consume_token(EQUALS);
    target = nameSpec();
    jj_consume_token(COPY_PRIORITY);
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOWEST:
      jj_consume_token(LOWEST);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_0;
      break;
    case LOW:
      jj_consume_token(LOW);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_1;
      break;
    case MEDIUM:
      jj_consume_token(MEDIUM);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_2;
      break;
    case HIGH:
      jj_consume_token(HIGH);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_3;
      break;
    case HIGHEST:
      jj_consume_token(HIGHEST);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_4;
      break;
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.startVolumeCopy(source, target, copyPriority);
      }
  }

/**
DESCRIPTION: <BR>
Start storage array related operations. Only supports locate at this moment.
<BR><BR>
*/
  final public void startSArrayStatement() throws ParseException, ScriptException {
    jj_consume_token(START);
    jj_consume_token(STORAGE_ARRAY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.startSArrayLocate();
      }
      break;
    case ISNS_SERVER_REFRESH:
      jj_consume_token(ISNS_SERVER_REFRESH);
      jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.startIsnsServerRefresh();
      }
      break;
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
Start controller related operations. Only supports start drive channel locate at this moment.
*/
  final public void startControllerStatement() throws ParseException, ScriptException {
    String       controllerName;
    int          iscsiChannel;
    jj_consume_token(START);
    jj_consume_token(CONTROLLER);
    jj_consume_token(LBRACKET);
    controllerName = controllerSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(ISCSI_HOST_PORT);
    jj_consume_token(LBRACKET);
    iscsiChannel = integerLiteral();
    jj_consume_token(RBRACKET);
    jj_consume_token(DHCP_REFRESH);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_ControllerExecutor.startIscsiRefresh(controllerName, iscsiChannel);
      }
  }

/**
Start drive channel related operations. Only supports start drive channel locate or
fault isolation diagnostics at this moment.
This procedure can run up to 9 minutes and at that time a controller does not except any operation
 but test cancellation and getSAData. IO in not allowed
 To cancel the operation a user can enter standard command break sequence, for example CTRL - c

<BR><BR>
*/
  final public void startDriveChannelStatement() throws ParseException, ScriptException {
    int          driveChannelId;
    String       controller = null;
    jj_consume_token(START);
    jj_consume_token(DRIVE_CHANNEL);
    jj_consume_token(LBRACKET);
    driveChannelId = integerLiteral();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_ControllerExecutor.startDriveChannelLocate(driveChannelId);
      }
      break;
    case CONTROLLER:
      jj_consume_token(CONTROLLER);
      jj_consume_token(LBRACKET);
      controller = controllerSpec();
      jj_consume_token(RBRACKET);
      jj_consume_token(FAULT_DIAGNOSTICS);
      DCFaultDiagnosticsAttributeValueList();
      jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_IsFaultIsolationDiagnosticsRun = true;
         m_SArrayExecutor.performDCFIDiagStart(driveChannelId, controller, m_AttributePairList);
      }
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Stop drive channel related operations. Only supports stop locate 
or fault isolation diagnostics for drive channel at this moment.
<BR><BR>
*/
  final public void stopDriveChannelStatement() throws ParseException, ScriptException {
    jj_consume_token(STOP);
    jj_consume_token(DRIVE_CHANNEL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.stopSArrayLocate();
      }
      break;
    case FAULT_DIAGNOSTICS:
      jj_consume_token(FAULT_DIAGNOSTICS);
      jj_consume_token(SEMICOLON);
        if ( !m_SyntaxCheckOnly )
        {
           m_SArrayExecutor.stopDCDFaultIsolation();
        }
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Start drive related operations.
<BR><BR>
*/
  final public void startDriveStatement() throws ParseException, ScriptException {
    jj_consume_token(START);
    jj_consume_token(DRIVE);
    jj_consume_token(LBRACKET);
    driveList();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INITIALIZE:
      jj_consume_token(INITIALIZE);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
               m_DriveExecutor.initializeDrive(m_DriveList);
         }
      break;
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
               m_DriveExecutor.locateDrive(m_DriveList);
         }
      break;
    case RECONSTRUCT:
      jj_consume_token(RECONSTRUCT);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
               m_DriveExecutor.reconstructDrive(m_DriveList);
         }
      break;
    default:
      jj_la1[150] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Start drive related operations.
<BR><BR>
*/
  final public void replaceDriveStatement() throws ParseException, ScriptException {
   String   driveWWN = null;
   String[] replacedDriveSpec = null;
   String[] replacementDriveSpec;
    jj_consume_token(REPLACE);
    jj_consume_token(DRIVE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      replacedDriveSpec = driveSpec();
      jj_consume_token(RBRACKET);
      break;
    case LESS_THAN:
      jj_consume_token(LESS_THAN);
      driveWWN = wwnStringSpec();
      jj_consume_token(GREATER_THAN);
      break;
    default:
      jj_la1[151] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(REPLACEMENT_DRIVE);
    jj_consume_token(EQUALS);
    replacementDriveSpec = driveSpec();
    jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
            if (driveWWN != null)
            {
                m_DriveExecutor.replaceDrive(driveWWN, replacementDriveSpec);
            }
            else
            {
                m_DriveExecutor.replaceDrive(replacedDriveSpec, replacementDriveSpec);
            }
         }
  }

/**
DESCRIPTION: <BR>
Stop drive related operations. Only supports stop locate drive and stop drive download
at this moment.
<BR><BR>
*/
  final public void stopDriveStatement() throws ParseException, ScriptException {
    jj_consume_token(STOP);
    jj_consume_token(DRIVE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
            m_SArrayExecutor.stopSArrayLocate();
         }
      break;
    case DOWNLOAD:
      jj_consume_token(DOWNLOAD);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
            m_DriveExecutor.stopDriveDownload();
         }
      break;
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Start tray related operations. Only support locate at this moment.
<BR><BR>
*/
  final public void startTrayStatement() throws ParseException, ScriptException {
    int        trayId;
    jj_consume_token(START);
    jj_consume_token(TRAY);
    jj_consume_token(LBRACKET);
    trayId = integerLiteral();
    jj_consume_token(RBRACKET);
    jj_consume_token(LOCATE);
    jj_consume_token(SEMICOLON);
     if (!m_SyntaxCheckOnly)
     {
        m_TrayExecutor.trayLocate(trayId);
     }
  }

/**
DESCRIPTION: <BR>
Start volume group related operations. Only supports start volume group defragmentation 
or start volume group locate at this moment.
<BR><BR>
*/
  final public void startVolumeGroupStatement() throws ParseException, ScriptException {
   int      volumeGroup = -1;
   String   volumeGroupName = null;
    jj_consume_token(START);
    jj_consume_token(VOLUME_GROUP);
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
    case IDENTIFIER:
      volumeGroupName = nameSpec();
      break;
    case INTEGER_LITERAL:
    case 469:
      volumeGroup = integerLiteral();
      break;
    default:
      jj_la1[153] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
      if (volumeGroupName == null)
      {
          volumeGroupName = Integer.toString(volumeGroup);
      }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
            m_VolumeGroupExecutor.locateVolumeGroup(volumeGroupName);
         }
      break;
    case DEFRAGMENT:
      jj_consume_token(DEFRAGMENT);
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_VolumeGroupExecutor.volumeGroupDefragment(volumeGroupName);
         }
      break;
    case EXPORT:
      jj_consume_token(EXPORT);
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            m_VolumeGroupExecutor.exportVolumeGroup(volumeGroupName);
         }
      break;
    case IMPORT:
      jj_consume_token(IMPORT);
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
           m_VolumeGroupExecutor.importVolumeGroup(volumeGroupName);
         }
      break;
    default:
      jj_la1[154] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Start volume related operations.
<BR><BR>
*/
  final public void startVolumeStatement() throws ParseException, ScriptException {
   String volume = null;
    jj_consume_token(START);
    jj_consume_token(VOLUME);
    jj_consume_token(LBRACKET);
    volume = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(INITIALIZE);
    jj_consume_token(SEMICOLON);
        if (!m_SyntaxCheckOnly)
        {
           m_VolumeExecutor.startVolumeInitialize(volume);
        }
  }

/**
DESCRIPTION: <BR>
Start remote mirror related operations. Only supports start synchronize at this moment. 
<BR><BR>
*/
  final public void startRemoteMirrorStatement() throws ParseException, ScriptException {
   String localVolume;
    jj_consume_token(START);
    jj_consume_token(REMOTE_MIRROR);
    jj_consume_token(PRIMARY);
    jj_consume_token(LBRACKET);
    localVolume = stringLiteral();
    jj_consume_token(RBRACKET);
    jj_consume_token(SYNCHRONIZE);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_RVMExecutor.synchronizeRemoteMirror(localVolume);
      }
  }

/**
DESCRIPTION: <BR>
Stop tray related operations. Only support stop locate tray at this moment.
<BR><BR>
*/
  final public void stopTrayStatement() throws ParseException, ScriptException {
    jj_consume_token(STOP);
    jj_consume_token(TRAY);
    jj_consume_token(LOCATE);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
        m_SArrayExecutor.stopSArrayLocate();
      }
  }

/**
DESCRIPTION: <BR>
Stop volume group related operations. Only support stop volumeGroup locate at this moment.
<BR><BR>
*/
  final public void stopVolumeGroupStatement() throws ParseException, ScriptException {
    jj_consume_token(STOP);
    jj_consume_token(VOLUME_GROUP);
    jj_consume_token(LOCATE);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
        m_SArrayExecutor.stopSArrayLocate();
      }
  }

/**
DESCRIPTION: <BR>
Stops a volume copy operation.
<BR><BR>
*/
  final public void stopVolumeCopyStatement() throws ParseException, ScriptException {
   String      source = null;
   String      target = null;
    jj_consume_token(STOP);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(TARGET);
    jj_consume_token(LBRACKET);
    target = nameSpec();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOURCE:
      jj_consume_token(SOURCE);
      jj_consume_token(LBRACKET);
      source = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[155] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.stopVolumeCopy(source, target);
      }
  }

/**
DESCRIPTION: <BR>
Stops a storage array operation. Only support locate operation at this moment.
<BR><BR>
*/
  final public void stopSArrayStatement() throws ParseException, ScriptException {
   int targetSessionHandle;
    jj_consume_token(STOP);
    jj_consume_token(STORAGE_ARRAY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCATE:
      jj_consume_token(LOCATE);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
            m_SArrayExecutor.stopSArrayLocate();
         }
      break;
    case DRIVE_FIRMWARE_DOWNLOAD:
      jj_consume_token(DRIVE_FIRMWARE_DOWNLOAD);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
            m_SArrayExecutor.stopSArrayDriveFirmwareDownload();
         }
      break;
    case ISCSI_SESSION:
      jj_consume_token(ISCSI_SESSION);
      jj_consume_token(LBRACKET);
      targetSessionHandle = integerLiteral();
      jj_consume_token(RBRACKET);
      jj_consume_token(SEMICOLON);
         if ( !m_SyntaxCheckOnly )
         {
           m_IscsiExecutor.stopSession(targetSessionHandle);
         }
      break;
    default:
      jj_la1[156] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Shows a volume copy pair.
<BR><BR>
*/
  final public void showVolumeCopyStatement() throws ParseException, ScriptException {
   String      source = null;
   String      target = null;
    jj_consume_token(SHOW);
    jj_consume_token(VOLUME_COPY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOURCE:
      jj_consume_token(SOURCE);
      jj_consume_token(LBRACKET);
      source = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    case ALL_VOLUMES:
      jj_consume_token(ALL_VOLUMES);
      break;
    case TARGET:
      jj_consume_token(TARGET);
      jj_consume_token(LBRACKET);
      target = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[157] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.showVolumeCopies(source, target);
      }
  }

/**
DESCRIPTION: <BR>
Displays the Host Ports known to this storage array.  Each port's ID, name,
and host type are displayed.  The name and type will be shown as undefined if
the host port is not yet defined.
<BR><BR>
*/
  final public void showHostPortsStatement() throws ParseException, ScriptException {
   {}
    jj_consume_token(SHOW);
    jj_consume_token(ALL_HOST_PORTS);
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.showHostPorts();
      }
  }

/**
DESCRIPTION: <BR>
Removes a volume copy pair.
<BR><BR>
*/
  final public void removeVolumeCopyStatement() throws ParseException, ScriptException {
   String      source = null;
   String      target = null;
    jj_consume_token(REMOVE);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(TARGET);
    jj_consume_token(LBRACKET);
    target = nameSpec();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOURCE:
      jj_consume_token(SOURCE);
      jj_consume_token(LBRACKET);
      source = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[158] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.removeCopyPair(source, target);
      }
  }

/**
DESCRIPTION: <BR>
Sets the volume copy pair's parameters.
<BR><BR>
*/
  final public void setVolumeCopyStatement() throws ParseException, ScriptException {
   String                     source = null;
   String                     target = null;
    jj_consume_token(SET);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(TARGET);
    jj_consume_token(LBRACKET);
    target = nameSpec();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOURCE:
      jj_consume_token(SOURCE);
      jj_consume_token(LBRACKET);
      source = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[159] = jj_gen;
      ;
    }
    volumeCopyAttributeValueList();
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.setVolumeCopy(source, target, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Sets the user label for the volume with the given volume id.
<BR><BR>
*/
  final public void setVolumeUserLabel() throws ParseException, ScriptException {
   String      id = null;
   String      userLabel = null;
    jj_consume_token(SET);
    jj_consume_token(VOLUME);
    jj_consume_token(LESS_THAN);
    id = wwnStringSpec();
    jj_consume_token(GREATER_THAN);
    jj_consume_token(USER_LABEL);
    jj_consume_token(EQUALS);
    userLabel = nameSpec();
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.setVolumeUserLabel(id, userLabel);
      }
  }

/**
DESCRIPTION: <BR>
Sets the remote mirror attributes.
<BR><BR>
*/
  final public void setRemoteMirrorStatement() throws ParseException, ScriptException {
    jj_consume_token(SET);
    jj_consume_token(REMOTE_MIRROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCAL_VOLUME:
      jj_consume_token(LOCAL_VOLUME);
      break;
    case LOCAL_VOLUMES:
      jj_consume_token(LOCAL_VOLUMES);
      break;
    default:
      jj_la1[160] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    remoteMirrorAttributeValueList();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_RVMExecutor.setRemoteMirror(m_NameSpecList, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Removes the volume mappings or reservations.
<BR><BR>
*/
  final public void removeVolumeAttributeStatement() throws ParseException, ScriptException {
    if (jj_2_109(2)) {
      removeSingleVolAttributeStatement();
    } else if (jj_2_110(2)) {
      removeMultiVolAttributeStatement();
    } else if (jj_2_111(2)) {
      removeAllVolsAttributeStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REMOVE:
        removeAccessVolAttributeStatement();
        break;
      default:
        jj_la1[161] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid iscsi initiator attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void iscsiInitiatorAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_4:
    while (true) {
      pair = iscsiInitiatorAttributeValuePair();
         if (pair != null)
         {
            m_AttributePairList.addElement(pair);
         }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOST:
      case USER_LABEL:
      case CHAP_SECRET:
        ;
        break;
      default:
        jj_la1[162] = jj_gen;
        break label_4;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid iscsi target attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void iscsiTargetAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_5:
    while (true) {
      pair = iscsiTargetAttributeValuePair();
         if (pair != null)
         {
            m_AttributePairList.addElement(pair);
         }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TARGET_ALIAS:
      case AUTHENTICATION_METHOD:
        ;
        break;
      default:
        jj_la1[163] = jj_gen;
        break label_5;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid iscsi initiator attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute iscsiInitiatorAttributeValuePair() throws ParseException {
   String   stringLiteral = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      stringLiteral = userLabelLiteral();
         {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral);}
      break;
    case HOST:
      jj_consume_token(HOST);
      jj_consume_token(EQUALS);
      stringLiteral = userLabelLiteral();
         {if (true) return new StringAttributeValuePair(Attribute.HOST_NAME, stringLiteral);}
      break;
    case CHAP_SECRET:
      jj_consume_token(CHAP_SECRET);
      jj_consume_token(EQUALS);
      stringLiteral = stringLiteral();
         {if (true) return new IscsiAuthenticationAttribute(
                        AuthenticationMethod.AUTH_METHOD_CHAP, stringLiteral.toCharArray());}
      break;
    default:
      jj_la1[164] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid iscsi target attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute iscsiTargetAttributeValuePair() throws ParseException {
   String   stringLiteral = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TARGET_ALIAS:
      jj_consume_token(TARGET_ALIAS);
      jj_consume_token(EQUALS);
      stringLiteral = userAssignedLabel();
         {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral);}
      break;
    case AUTHENTICATION_METHOD:
      jj_consume_token(AUTHENTICATION_METHOD);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHAP:
        jj_consume_token(CHAP);
        jj_consume_token(CHAP_SECRET);
        jj_consume_token(EQUALS);
        stringLiteral = stringLiteral();
         {if (true) return new IscsiAuthenticationAttribute(
                        AuthenticationMethod.AUTH_METHOD_CHAP, stringLiteral.toCharArray());}
        break;
      case NONE:
        jj_consume_token(NONE);
         {if (true) return new IscsiAuthenticationAttribute();}
        break;
      default:
        jj_la1[165] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[166] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Removes the volume mappings or reservations for one volume.
<BR><BR>
*/
  final public void removeSingleVolAttributeStatement() throws ParseException, ScriptException {
   String volume = null;
    jj_consume_token(REMOVE);
    jj_consume_token(VOLUME);
    jj_consume_token(LBRACKET);
    volume = stringLiteral();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LUN_MAPPING:
      jj_consume_token(LUN_MAPPING);
      hostOrHostGroupNameSpec();
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeMapping.setVolume(volume);
         m_VolumeExecutor.deleteVolumeMapping(m_VolumeMapping, true);
      }
      break;
    case RESERVATIONS:
      jj_consume_token(RESERVATIONS);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.removeVolumeReservation(volume);
      }
      break;
    default:
      jj_la1[167] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Removes the volume mappings or reservations for a list of volumes.
<BR><BR>
*/
  final public void removeMultiVolAttributeStatement() throws ParseException, ScriptException {
    jj_consume_token(REMOVE);
    jj_consume_token(VOLUMES);
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LUN_MAPPING:
      jj_consume_token(LUN_MAPPING);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.deleteVolumeMappings(m_NameSpecList);

      }
      break;
    case RESERVATIONS:
      jj_consume_token(RESERVATIONS);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.removeVolumeReservations(m_NameSpecList);
      }
      break;
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Removes the volume mappings or reservations for all volumes in the array.
<BR><BR>
*/
  final public void removeAllVolsAttributeStatement() throws ParseException, ScriptException {
    jj_consume_token(REMOVE);
    jj_consume_token(ALL_VOLUMES);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LUN_MAPPING:
      jj_consume_token(LUN_MAPPING);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.deleteAllVolumeMappings();
      }
      break;
    case RESERVATIONS:
      jj_consume_token(RESERVATIONS);
      jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeExecutor.removeAllVolumeReservations();
      }
      break;
    default:
      jj_la1[169] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Removes the volume mappings for access volume.
<BR><BR>
*/
  final public void removeAccessVolAttributeStatement() throws ParseException, ScriptException {
    jj_consume_token(REMOVE);
    jj_consume_token(ACCESS_VOLUME);
    jj_consume_token(LUN_MAPPING);
    hostOrHostGroupNameSpec();
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_VolumeMapping.setAccessVolumeMapping();
         m_VolumeExecutor.deleteVolumeMapping(m_VolumeMapping, true);
      }
  }

/**
DESCRIPTION: <BR>
Removes the mirror relationship(s).
<BR><BR>
*/
  final public void removeRemoteMirrorStatement() throws ParseException, ScriptException {
    jj_consume_token(REMOVE);
    jj_consume_token(REMOTE_MIRROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LOCAL_VOLUME:
      jj_consume_token(LOCAL_VOLUME);
      break;
    case LOCAL_VOLUMES:
      jj_consume_token(LOCAL_VOLUMES);
      break;
    default:
      jj_la1[170] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_RVMExecutor.removeRemoteMirror(m_NameSpecList);
      }
  }

/**
DESCRIPTION: <BR>
Perform diagnose controller process.
<BR><BR>
*/
  final public void diagnoseControllerStatement() throws ParseException, ScriptException {
   String      controllerName = null;
   String      filename = null;
   int         driveChannelId = -1;
   int         testId;
    jj_consume_token(DIAGNOSE);
    jj_consume_token(CONTROLLER);
    jj_consume_token(LBRACKET);
    controllerName = controllerSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(LOOPBACK_DRIVE_CHANNEL);
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case 469:
      driveChannelId = integerLiteral();
      break;
    case ALL_CHANNELS:
      jj_consume_token(ALL_CHANNELS);
      break;
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(TEST_ID);
    jj_consume_token(EQUALS);
    testId = integerLiteral();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PATTERN_FILE:
      jj_consume_token(PATTERN_FILE);
      jj_consume_token(EQUALS);
      filename = stringLiteral();
      break;
    default:
      jj_la1[172] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_ControllerExecutor.diagnoseController(controllerName, driveChannelId, testId, filename);
      }
  }

/**
DESCRIPTION: <BR>
Perform diagnose controller process.
<BR><BR>
*/
  final public void diagnoseDiscreteLinesStatement() throws ParseException, ScriptException {
   String      controllerName = null;
    jj_consume_token(DIAGNOSE);
    jj_consume_token(CONTROLLER);
    jj_consume_token(LBRACKET);
    controllerName = controllerSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(TEST_ID);
    jj_consume_token(EQUALS);
    jj_consume_token(DISCRETE_LINES);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_ControllerExecutor.runDiscreteLinesTest(controllerName);
      }
  }

/**
DESCRIPTION: <BR>
Perform revive drive operation.
<BR><BR>
*/
  final public void reviveDriveStatement() throws ParseException, ScriptException {
    jj_consume_token(REVIVE);
    jj_consume_token(DRIVE);
    jj_consume_token(LBRACKET);
    driveList();
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_DriveExecutor.reviveDrive(m_DriveList);
      }
  }

/**
DESCRIPTION: <BR>
Perform revive volume group operation.
<BR><BR>
*/
  final public void reviveVolumeGroupStatement() throws ParseException, ScriptException {
   int         volumeGroup = -1;
   String      volumeGroupName = null;
    jj_consume_token(REVIVE);
    jj_consume_token(VOLUME_GROUP);
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
    case IDENTIFIER:
      volumeGroupName = nameSpec();
      break;
    case INTEGER_LITERAL:
    case 469:
      volumeGroup = integerLiteral();
      break;
    default:
      jj_la1[173] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
    jj_consume_token(SEMICOLON);
      if (volumeGroupName == null)
      {
          volumeGroupName = Integer.toString(volumeGroup);
      }

      if (!m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.reviveVolumeGroup(volumeGroupName);
      }
  }

/**
DESCRIPTION: <BR>
Perform activate storage array feature. Only support activate RVM at this moment.
<BR><BR>
*/
  final public void activateSArrayStatement() throws ParseException, ScriptException {
   int         raidLevel;
   int         repositoryFreeCapacityArea = -1;
   int         driveCount = -1;
   int         physicalDriveType = PhysicalDriveType.PHY_DRIVE_TYPE_ALL;
   int         volumeGroup = -1;
   String      volumeGroupName = null;  // for indicating a destination volume group
   String      volumeGroupUserLabel = null;  // used when a new volume group is to be created
   boolean     trayLossProtect = false;
    jj_consume_token(ACTIVATE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FEATURE);
    jj_consume_token(EQUALS);
    jj_consume_token(REMOTE_MIRROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REPOSITORY_RAID_LEVEL:
      jj_consume_token(REPOSITORY_RAID_LEVEL);
      jj_consume_token(EQUALS);
      raidLevel = raidLevel();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REPOSITORY_DRIVES:
        jj_consume_token(REPOSITORY_DRIVES);
        jj_consume_token(EQUALS);
        jj_consume_token(LPAREN);
        driveList();
        jj_consume_token(RPAREN);
        break;
      case REPOSITORY_DRIVE_COUNT:
        jj_consume_token(REPOSITORY_DRIVE_COUNT);
        jj_consume_token(EQUALS);
        driveCount = integerLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DRIVE_TYPE:
          jj_consume_token(DRIVE_TYPE);
          jj_consume_token(EQUALS);
          physicalDriveType = physicalDriveType();
          break;
        default:
          jj_la1[174] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[175] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REPOSITORY_VOLUME_GROUP_LABEL:
        jj_consume_token(REPOSITORY_VOLUME_GROUP_LABEL);
        jj_consume_token(EQUALS);
        volumeGroupUserLabel = userLabelLiteral();
        break;
      default:
        jj_la1[176] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRAY_LOSS_PROTECT:
        jj_consume_token(TRAY_LOSS_PROTECT);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRUE:
          jj_consume_token(TRUE);
                  trayLossProtect = true;
          break;
        case FALSE:
          jj_consume_token(FALSE);
          break;
        default:
          jj_la1[177] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[178] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
         if (!m_SyntaxCheckOnly)
         {
            // volume group user label is an optional parameter, so it may not have been set -
            // the RVMExecutor will handle generating a label if necessary
            if (driveCount != -1)
            {
               m_RVMExecutor.activateRVMByDriveCount(raidLevel, driveCount, false,
                  physicalDriveType, trayLossProtect, volumeGroupUserLabel);
            }
            else
            {
               m_RVMExecutor.activateRVMBySelectDrives(raidLevel, m_DriveList, false,
                  trayLossProtect, volumeGroupUserLabel);
            }
         }
      break;
    case REPOSITORY_VOLUME_GROUP:
      jj_consume_token(REPOSITORY_VOLUME_GROUP);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case IDENTIFIER:
        volumeGroupName = nameSpec();
        break;
      case INTEGER_LITERAL:
      case 469:
        volumeGroup = integerLiteral();
        break;
      default:
        jj_la1[179] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FREE_CAPACITY_AREA:
        jj_consume_token(FREE_CAPACITY_AREA);
        jj_consume_token(EQUALS);
        repositoryFreeCapacityArea = integerLiteral();
        break;
      default:
        jj_la1[180] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
         if (volumeGroupName == null)
         {
            volumeGroupName = Integer.toString(volumeGroup);
         }

         if (!m_SyntaxCheckOnly)
         {
            m_RVMExecutor.activateRVMBySelectVolumeGroup(volumeGroupName, repositoryFreeCapacityArea,
                false);
         }
      break;
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*DESCRIPTION: <BR>
Perform deactivate storage array feature. Only support deactivate RVM at this moment.
<BR><BR>
*/
  final public void deactivateSArrayStatement() throws ParseException, ScriptException {
    jj_consume_token(DEACTIVATE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(FEATURE);
    jj_consume_token(EQUALS);
    jj_consume_token(REMOTE_MIRROR);
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_RVMExecutor.deactivateRVM();
      }
  }

/**
DESCRIPTION: <BR>
Perform recreate mirror repository operation.
<BR><BR>
*/
  final public void recreateMirrorRepositoryStatement() throws ParseException, ScriptException {
   int         raidLevel;
   int         driveCount = -1;
   int         volumeGroup = -1;
   int         repositoryFreeCapacityArea = -1;
   int         physicalDriveType = PhysicalDriveType.PHY_DRIVE_TYPE_ALL;
   boolean     trayLossProtect = false;
   String      volumeGroupName = null;  // for indicating a destination volume group
   String      volumeGroupUserLabel = null;
    jj_consume_token(RECREATE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(MIRROR_REPOSITORY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REPOSITORY_RAID_LEVEL:
      jj_consume_token(REPOSITORY_RAID_LEVEL);
      jj_consume_token(EQUALS);
      raidLevel = raidLevel();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REPOSITORY_DRIVES:
        jj_consume_token(REPOSITORY_DRIVES);
        jj_consume_token(EQUALS);
        jj_consume_token(LPAREN);
        driveList();
        jj_consume_token(RPAREN);
        break;
      case REPOSITORY_DRIVE_COUNT:
        jj_consume_token(REPOSITORY_DRIVE_COUNT);
        jj_consume_token(EQUALS);
        driveCount = integerLiteral();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DRIVE_TYPE:
          jj_consume_token(DRIVE_TYPE);
          jj_consume_token(EQUALS);
          physicalDriveType = physicalDriveType();
          break;
        default:
          jj_la1[182] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[183] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REPOSITORY_VOLUME_GROUP_LABEL:
        jj_consume_token(REPOSITORY_VOLUME_GROUP_LABEL);
        jj_consume_token(EQUALS);
        volumeGroupUserLabel = userLabelLiteral();
        break;
      default:
        jj_la1[184] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRAY_LOSS_PROTECT:
        jj_consume_token(TRAY_LOSS_PROTECT);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRUE:
          jj_consume_token(TRUE);
                     trayLossProtect = true;
          break;
        case FALSE:
          jj_consume_token(FALSE);
          break;
        default:
          jj_la1[185] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[186] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
            if (!m_SyntaxCheckOnly)
            {
               // volume group user label is an optional parameter, so it may not have been set -
               // the RVMExecutor will handle generating a label if necessary
               if (driveCount != -1)
               {
                  m_RVMExecutor.activateRVMByDriveCount(raidLevel, driveCount, true,
                     physicalDriveType, trayLossProtect, volumeGroupUserLabel);
               }
               else
               {
                  m_RVMExecutor.activateRVMBySelectDrives(raidLevel, m_DriveList, true,
                     trayLossProtect, volumeGroupUserLabel);
               }
            }
      break;
    case REPOSITORY_VOLUME_GROUP:
      jj_consume_token(REPOSITORY_VOLUME_GROUP);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case IDENTIFIER:
        volumeGroupName = nameSpec();
        break;
      case INTEGER_LITERAL:
      case 469:
        volumeGroup = integerLiteral();
        break;
      default:
        jj_la1[187] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FREE_CAPACITY_AREA:
        jj_consume_token(FREE_CAPACITY_AREA);
        jj_consume_token(EQUALS);
        repositoryFreeCapacityArea = integerLiteral();
        break;
      default:
        jj_la1[188] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
               if (volumeGroupName == null)
               {
                  volumeGroupName = Integer.toString(volumeGroup);
               }

               if (!m_SyntaxCheckOnly)
               {
                  m_RVMExecutor.activateRVMBySelectVolumeGroup(volumeGroupName,
                      repositoryFreeCapacityArea, true);
               }
      break;
    default:
      jj_la1[189] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*DESCRIPTION: <BR>
Perform suspend mirror operation.
<BR><BR>
*/
  final public void suspendMirrorStatement() throws ParseException, ScriptException {
    jj_consume_token(SUSPEND);
    jj_consume_token(REMOTE_MIRROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      break;
    case PRIMARIES:
      jj_consume_token(PRIMARIES);
      break;
    default:
      jj_la1[190] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WRITE_CONSISTENCY:
      suspendResumeAttributeList();
      break;
    default:
      jj_la1[191] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_RVMExecutor.suspendRemoteMirrors(m_NameSpecList, m_AttributePairList);
      }
  }

/*DESCRIPTION: <BR>
Perform suspend mirror operation.
<BR><BR>
*/
  final public void resumeMirrorStatement() throws ParseException, ScriptException {
    jj_consume_token(RESUME);
    jj_consume_token(REMOTE_MIRROR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIMARY:
      jj_consume_token(PRIMARY);
      break;
    case PRIMARIES:
      jj_consume_token(PRIMARIES);
      break;
    default:
      jj_la1[192] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACKET);
    nameSpecList();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WRITE_CONSISTENCY:
      suspendResumeAttributeList();
      break;
    default:
      jj_la1[193] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         m_RVMExecutor.resumeRemoteMirrors(m_NameSpecList, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void suspendResumeAttributeList() throws ParseException {
   Attribute            pair = null;
    label_6:
    while (true) {
      pair = suspendResumeMirrorAttributeValuePair();
         m_AttributePairList.addElement( pair );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WRITE_CONSISTENCY:
        ;
        break;
      default:
        jj_la1[194] = jj_gen;
        break label_6;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute suspendResumeMirrorAttributeValuePair() throws ParseException {
    jj_consume_token(WRITE_CONSISTENCY);
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
      break;
    case FALSE:
      jj_consume_token(FALSE);
      break;
    default:
      jj_la1[195] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return new BooleanAttributeValuePair(Attribute.WRITE_ORDER, token.image);}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Checks for one remote mirror status.
<BR><BR>
*/
  final public void checkRemoteMirrorStatus() throws ParseException, ScriptException {
   String       volumeLabel = null;
   int          timeoutMinutes = -1;
    jj_consume_token(CHECK);
    jj_consume_token(REMOTE_MIRROR);
    jj_consume_token(LOCAL_VOLUME);
    jj_consume_token(LBRACKET);
    volumeLabel = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(OPTIMAL_STATUS);
    jj_consume_token(TIME_OUT);
    jj_consume_token(EQUALS);
    timeoutMinutes = integerLiteral();
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_RVMExecutor.checkRemoteMirrorStatus(volumeLabel, timeoutMinutes);
      }
  }

/**
DESCRIPTION: <BR>
Checks for parity and media errors.
<BR><BR>
*/
  final public void checkVolumeParityStatement() throws ParseException, ScriptException {
   String       volume = null;
    jj_consume_token(CHECK);
    jj_consume_token(VOLUME);
    jj_consume_token(LBRACKET);
    volume = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(PARITY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PARITY_ERROR_FILE:
    case MEDIA_ERROR_FILE:
    case STARTING_LBA:
    case ENDING_LBA:
    case PRIORITY:
    case VERBOSE:
      volumeParityAttributeValueList();
      break;
    default:
      jj_la1[196] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
        m_VolumeExecutor.checkVolumeParity(volume, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Repairs parity errors.
<BR><BR>
*/
  final public void repairVolumeParityStatement() throws ParseException, ScriptException {
   String       volume = null;
   String       parityErrorFile = null;
   boolean  verbose = false;
    jj_consume_token(REPAIR);
    jj_consume_token(VOLUME);
    jj_consume_token(LBRACKET);
    volume = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(PARITY);
    jj_consume_token(PARITY_ERROR_FILE);
    jj_consume_token(EQUALS);
    parityErrorFile = stringLiteral();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case VERBOSE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VERBOSE:
        jj_consume_token(VERBOSE);
        jj_consume_token(EQUALS);
        jj_consume_token(TRUE);
       verbose = true;
        break;
      case FALSE:
        jj_consume_token(FALSE);
       verbose = false;
        break;
      default:
        jj_la1[197] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[198] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.repairVolumeParity(volume, parityErrorFile, verbose);
      }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid controller specification in the grammar.
Currently "a" and "b" are being used.  This will may have to be rethought for
n-way.
*/
  final public String controllerSpec() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    default:
      jj_la1[199] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid battery pack slot specification in the grammar.
Currently "left" and "right" are being used.
*/
  final public String batterySlotSpec() throws ParseException {
    jj_consume_token(BATTERY_SLOT);
      {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid host channel specification in the grammar.
Currently "a1" "a2" "a3" "a4" "b1" "b2" "b3" "b4"  are being used.  This will may have to be 
rethought for n-way. We return a String array of length two, where the first string 
represents the controller label and the second string represents the channel number.
<BR><BR>
*/
  final public String[] hostChannelSpec() throws ParseException {
   String[] pair = new String[2];
    jj_consume_token(HOST_CHANNEL_ID);
      pair[0]=token.image.substring(0,1);
      pair[1]=token.image.substring(1);
      {if (true) return pair;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid name specification in the grammar. These names 
can represent volumes, hosts, hostPorts, and hostGroups.  We currently support both 
a quoted string literal and a non quoted single word identifier.
<BR><BR>
*/
  final public String nameSpec() throws ParseException {
   String   stringLiteral = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      {if (true) return token.image;}
      break;
    case STRING_LITERAL:
      stringLiteral = stringLiteral();
      break;
    default:
      jj_la1[200] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return stringLiteral;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a list of valid name specifications in the grammar. These names 
can represent volumes, hosts, hostPorts, and hostGroups.  We currently support both 
a quoted string literal and a non quoted single word identifier.
<BR><BR>
*/
  final public void nameSpecList() throws ParseException {
   String   stringLiteral = null;
    label_7:
    while (true) {
      stringLiteral = nameSpec();
            m_NameSpecList.addElement(stringLiteral);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[201] = jj_gen;
        break label_7;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid world wide name specification in the grammar.
<BR><BR>
*/
  final public String wwnStringSpec() throws ParseException {
   String      stringLiteral = null;
   String      wwn = null;
    stringLiteral = stringLiteral();
      if ( stringLiteral.toLowerCase().startsWith(HEX_PREFIX) )
      {
         wwn = stringLiteral.substring(2);
      }
      else
      {
         wwn = stringLiteral;
      }
      {if (true) return wwn;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid ip address specification in the grammar.
<BR><BR>
*/
  final public String ipSpec() throws ParseException {
    jj_consume_token(IP);
      {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid time format specification in the grammar.
<BR><BR>
*/
  final public String timeSpec() throws ParseException {
    jj_consume_token(TIMEFORMAT);
      {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid day format specification in the grammar.
<BR><BR>
*/
  final public String daySpec() throws ParseException {
    jj_consume_token(DAYS_OF_WEEK);
      {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid ip address specification in the grammar.
<BR><BR>
*/
  final public String ipv6Spec() throws ParseException {
   Inet6Address ipv6Address = null;
   Object[]     twoArgs = new Object[2];
   String       errorString;
    jj_consume_token(IPV6);
      try
      {
         ipv6Address = ((Inet6Address)Inet6Address.getByName(token.image));
      }
      catch (UnknownHostException e)
      {
         twoArgs[0] = token.image;
         twoArgs[1] = getLine();
         errorString =
            MessageFormat.format(Resource.getString("SE_PARSE_EXCEPTION_INVALID_IPV6_ADDRESS"),
            twoArgs);
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }

      {if (true) return ipv6Address.getHostAddress();}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive list specification in the grammar. A drive list
contains one or more driveSpec's. Each drive spec parse is added to the driveList
vector.
<BR><BR>
*/
  final public void driveList() throws ParseException {
   String[] drive = null;
    label_8:
    while (true) {
      drive = driveSpec();
         m_DriveList.addElement( drive );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        ;
        break;
      default:
        jj_la1[202] = jj_gen;
        break label_8;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive list specification in the grammar. A drive list
contains one or more driveSpec's. Each drive spec parse is added to the driveList
vector. This is the same as a driveList but a second list is required for the replaceDrive command.
<BR><BR>
*/
  final public void replacementDriveList() throws ParseException {
   String [] drive = null;
    label_9:
    while (true) {
      drive = driveSpec();
         m_ReplacementDriveList.addElement( drive );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        ;
        break;
      default:
        jj_la1[203] = jj_gen;
        break label_9;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive specification in the grammar. A drive is
defined as an integer literal, a comma, and another integer literal.  When we parse
a valid drive specification we create a String array consisting of the tray number
as a string and the drive number as a string.
<BR><BR>
*/
  final public String[] driveSpec() throws ParseException {
   String[]          traySlot = new String[2];
   int               tray;
   int               slot;
    tray = integerLiteral();
    jj_consume_token(COMMA);
    slot = integerLiteral();
      traySlot[0] = String.valueOf(tray);
      traySlot[1] = String.valueOf(slot);
      {if (true) return traySlot;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid esm list specification in the grammar. A esm list
contains one or more esmSpec's. Each esm spec parse is added to the esmList
vector. 
<BR><BR>
*/
  final public Vector esmList() throws ParseException {
   String [] esm = null;
   Vector   esmList = new Vector();
    label_10:
    while (true) {
      esm = esmSpec();
         esmList.addElement( esm );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        ;
        break;
      default:
        jj_la1[204] = jj_gen;
        break label_10;
      }
    }
      {if (true) return esmList;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid esm specification in the grammar. An esm is
defined as an integer literal, a comma, and another integer literal.  When we parse
a valid esm specification we create a String array consisting of the tray number
as a string and the esm slot as a string.
<BR><BR>
*/
  final public String[] esmSpec() throws ParseException {
   String[]          traySlot = new String[2];
   int               tray;
   String            slot = "";
    tray = integerLiteral();
    jj_consume_token(COMMA);
    slot = esmDesc();
      traySlot[0] = String.valueOf(tray);
      traySlot[1] = slot;
      {if (true) return traySlot;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid Esm specification in the grammar.
Currently "left" and "right" are being used.  This will may have to be rethought for
n-way.
*/
  final public String esmDesc() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    default:
      jj_la1[205] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive channel list specification in the grammar. A drive list
contains one or more int. Each drive spec parse is added to the driveList
vector.
<BR><BR>
*/
  final public void driveChannelList() throws ParseException {
   int channel;
    label_11:
    while (true) {
      channel = integerLiteral();
         m_DriveChannelList.addElement( new Integer(channel) );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        ;
        break;
      default:
        jj_la1[206] = jj_gen;
        break label_11;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid controller attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void contAttributeValueList() throws ParseException {
   Attribute   pair = null;
    label_12:
    while (true) {
      pair = contAttributeValuePair();
         if (pair != null)
         {
                m_AttributePairList.addElement(pair);
         }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AVAILABILITY:
      case NVSRAM_BYTE:
      case BATTERY_INSTALL_DATE:
      case GLOBAL_NVSRAM_BYTE:
      case HOST_NVSRAM_BYTE:
      case REMOTE_ACCESS_ENABLED:
      case ETHERNET_PORT:
      case SERVICE_MODE:
      case SERVICE_ALLOWED_INDICATOR:
      case GATEWAY_IP:
      case IPV4_GATEWAY_IP:
      case IPV6_ROUTER_ADDRESS:
        ;
        break;
      default:
        jj_la1[207] = jj_gen;
        break label_12;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void iscsiPortAttributeValueList() throws ParseException {
   Attribute   pair = null;
    label_13:
    while (true) {
      pair = iscsiPortAttributeValuePair();
         m_AttributePairList.addElement(pair);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IPV4_ADDRESS:
      case IPV4_GATEWAY_IP:
      case IPV4_SUBNET_MASK:
      case IPV6_LOCAL_ADDRESS:
      case IPV6_ROUTABLE_ADDRESS:
      case IPV6_ROUTER_ADDRESS:
      case ENABLE_IPV4:
      case ENABLE_IPV6:
      case ENABLE_IPV4_VLAN:
      case ENABLE_IPV6_VLAN:
      case ENABLE_IPV4_PRIORITY:
      case ENABLE_IPV6_PRIORITY:
      case IPV4_CONFIGURATION_METHOD:
      case IPV6_CONFIGURATION_METHOD:
      case IPV6_HOP_LIMIT:
      case IPV6_ND_DETECT_DUPLICATE_ADDRESS:
      case IPV6_ND_REACHABLE_TIME:
      case IPV6_ND_RETRANSMIT_TIME:
      case IPV6_ND_TIME_OUT:
      case IPV4_PRIORITY:
      case IPV6_PRIORITY:
      case IPV4_VLAN_ID:
      case IPV6_VLAN_ID:
      case MAX_FRAME_PAYLOAD:
      case TCP_LISTENING_PORT:
        ;
        break;
      default:
        jj_la1[208] = jj_gen;
        break label_13;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid controller attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute iscsiPortAttributeValuePair() throws ParseException {
   String ipAddress = null;
   String ipv6Address = null;
   int    integer;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ENABLE_IPV4:
      jj_consume_token(ENABLE_IPV4);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[209] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENABLE_IPV4 , token.image);}
      break;
    case ENABLE_IPV6:
      jj_consume_token(ENABLE_IPV6);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[210] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENABLE_IPV6 , token.image);}
      break;
    case ENABLE_IPV4_VLAN:
      jj_consume_token(ENABLE_IPV4_VLAN);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[211] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENABLE_IPV4_VLAN , token.image);}
      break;
    case ENABLE_IPV6_VLAN:
      jj_consume_token(ENABLE_IPV6_VLAN);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[212] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENABLE_IPV6_VLAN , token.image);}
      break;
    case ENABLE_IPV4_PRIORITY:
      jj_consume_token(ENABLE_IPV4_PRIORITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[213] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENABLE_IPV4_PRIORITY , token.image);}
      break;
    case ENABLE_IPV6_PRIORITY:
      jj_consume_token(ENABLE_IPV6_PRIORITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[214] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENABLE_IPV6_PRIORITY , token.image);}
      break;
    case IPV4_CONFIGURATION_METHOD:
      jj_consume_token(IPV4_CONFIGURATION_METHOD);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case DHCP:
        jj_consume_token(DHCP);
        break;
      default:
        jj_la1[215] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair(Attribute.IPV4_CONFIGURATION_METHOD , token.image);}
      break;
    case IPV6_CONFIGURATION_METHOD:
      jj_consume_token(IPV6_CONFIGURATION_METHOD);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case AUTO:
        jj_consume_token(AUTO);
        break;
      default:
        jj_la1[216] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair(Attribute.IPV6_CONFIGURATION_METHOD , token.image);}
      break;
    case IPV4_ADDRESS:
      jj_consume_token(IPV4_ADDRESS);
      jj_consume_token(EQUALS);
      ipAddress = ipSpec();
      {if (true) return new StringAttributeValuePair(Attribute.IPV4_ADDRESS , ipAddress);}
      break;
    case IPV4_GATEWAY_IP:
      jj_consume_token(IPV4_GATEWAY_IP);
      jj_consume_token(EQUALS);
      ipAddress = ipSpec();
      {if (true) return new StringAttributeValuePair(Attribute.IPV4_GATEWAY_IP , ipAddress);}
      break;
    case IPV6_LOCAL_ADDRESS:
      jj_consume_token(IPV6_LOCAL_ADDRESS);
      jj_consume_token(EQUALS);
      ipv6Address = ipv6Spec();
      {if (true) return new StringAttributeValuePair(Attribute.IPV6_LOCAL_ADDRESS , ipv6Address);}
      break;
    case IPV6_ROUTABLE_ADDRESS:
      jj_consume_token(IPV6_ROUTABLE_ADDRESS);
      jj_consume_token(EQUALS);
      ipv6Address = ipv6Spec();
      {if (true) return new StringAttributeValuePair(Attribute.IPV6_ROUTABLE_ADDRESS , ipv6Address);}
      break;
    case IPV6_ROUTER_ADDRESS:
      jj_consume_token(IPV6_ROUTER_ADDRESS);
      jj_consume_token(EQUALS);
      ipv6Address = ipv6Spec();
      {if (true) return new StringAttributeValuePair(Attribute.IPV6_ROUTER_ADDRESS , ipv6Address);}
      break;
    case IPV6_HOP_LIMIT:
      jj_consume_token(IPV6_HOP_LIMIT);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV6_HOP_LIMIT , integer);}
      break;
    case IPV6_ND_DETECT_DUPLICATE_ADDRESS:
      jj_consume_token(IPV6_ND_DETECT_DUPLICATE_ADDRESS);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV6_ND_DETECT_DUPLICATE_ADDRESS , integer);}
      break;
    case IPV6_ND_REACHABLE_TIME:
      jj_consume_token(IPV6_ND_REACHABLE_TIME);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV6_ND_REACHABLE_TIME , integer);}
      break;
    case IPV6_ND_RETRANSMIT_TIME:
      jj_consume_token(IPV6_ND_RETRANSMIT_TIME);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV6_ND_RETRANSMIT_TIME , integer);}
      break;
    case IPV6_ND_TIME_OUT:
      jj_consume_token(IPV6_ND_TIME_OUT);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV6_ND_TIME_OUT , integer);}
      break;
    case IPV4_PRIORITY:
      jj_consume_token(IPV4_PRIORITY);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV4_PRIORITY , integer);}
      break;
    case IPV6_PRIORITY:
      jj_consume_token(IPV6_PRIORITY);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV6_PRIORITY , integer);}
      break;
    case IPV4_SUBNET_MASK:
      jj_consume_token(IPV4_SUBNET_MASK);
      jj_consume_token(EQUALS);
      ipAddress = ipSpec();
      {if (true) return new StringAttributeValuePair(Attribute.IPV4_SUBNET_MASK , ipAddress);}
      break;
    case IPV4_VLAN_ID:
      jj_consume_token(IPV4_VLAN_ID);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV4_VLAN_ID , integer);}
      break;
    case IPV6_VLAN_ID:
      jj_consume_token(IPV6_VLAN_ID);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.IPV6_VLAN_ID , integer);}
      break;
    case MAX_FRAME_PAYLOAD:
      jj_consume_token(MAX_FRAME_PAYLOAD);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.MAX_FRAME_PAYLOAD , integer);}
      break;
    case TCP_LISTENING_PORT:
      jj_consume_token(TCP_LISTENING_PORT);
      jj_consume_token(EQUALS);
      integer = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.TCP_LISTENING_PORT , integer);}
      break;
    default:
      jj_la1[217] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid controller attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. Currently
only the MODE attribute is supported for the set controller command.
<BR><BR>
*/
  final public Attribute contAttributeValuePair() throws ParseException {
   byte              mask = 0;
   byte              value = 0;
   int               offset = 0;
   int               hostType = 0;
   int               ethernetPort = 0;
   int                                  integer = -1;
   NVSRAMAttribute   attribute = null;
   String            gatewayIPAddress = null;
   String            ipv6RouterIpAddress = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AVAILABILITY:
      jj_consume_token(AVAILABILITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ONLINE:
        jj_consume_token(ONLINE);
        break;
      case OFFLINE:
        jj_consume_token(OFFLINE);
        break;
      case SERVICE_MODE:
        jj_consume_token(SERVICE_MODE);
        break;
      default:
        jj_la1[218] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair(Attribute.AVAILABILITY, token.image);}
      break;
    case BATTERY_INSTALL_DATE:
      jj_consume_token(BATTERY_INSTALL_DATE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[219] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.BATTERY_INSTALL_DATE, token.image);}
      break;
    case NVSRAM_BYTE:
      jj_consume_token(NVSRAM_BYTE);
      jj_consume_token(LBRACKET);
      offset = nvsramOffset(Attribute.NVSRAM_BYTE);
      jj_consume_token(RBRACKET);
      jj_consume_token(EQUALS);
      if (jj_2_112(2)) {
        mask = byteValue();
        jj_consume_token(COMMA);
        value = byteValue();
         attribute = new NVSRAMAttribute( offset );
         attribute.setValue(value);
         attribute.setMask(mask);
         {if (true) return attribute;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case 469:
          value = byteValue();
         attribute = new NVSRAMAttribute( offset );
         attribute.setValue(value);
         {if (true) return attribute;}
          break;
        default:
          jj_la1[220] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case HOST_NVSRAM_BYTE:
      jj_consume_token(HOST_NVSRAM_BYTE);
      jj_consume_token(LBRACKET);
      hostType = hostTypeIndex();
      jj_consume_token(COMMA);
      offset = nvsramOffset(Attribute.HOST_NVSRAM_BYTE);
      jj_consume_token(RBRACKET);
      jj_consume_token(EQUALS);
      if (jj_2_113(2)) {
        mask = byteValue();
        jj_consume_token(COMMA);
        value = byteValue();
            attribute = new HostNVSRAMAttribute( hostType, offset );
            attribute.setValue(value);
            attribute.setMask(mask);
            {if (true) return attribute;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case 469:
          value = byteValue();
            attribute = new HostNVSRAMAttribute( hostType, offset );
            attribute.setValue(value);
            {if (true) return attribute;}
          break;
        default:
          jj_la1[221] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case GLOBAL_NVSRAM_BYTE:
      jj_consume_token(GLOBAL_NVSRAM_BYTE);
      jj_consume_token(LBRACKET);
      offset = nvsramOffset(Attribute.GLOBAL_NVSRAM_BYTE);
      jj_consume_token(RBRACKET);
      jj_consume_token(EQUALS);
      if (jj_2_114(2)) {
        mask = byteValue();
        jj_consume_token(COMMA);
        value = byteValue();
         attribute = new GlobalNVSRAMAttribute( offset );
         attribute.setValue(value);
         attribute.setMask(mask);
         {if (true) return attribute;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case 469:
          value = byteValue();
         attribute = new GlobalNVSRAMAttribute( offset );
         attribute.setValue(value);
         {if (true) return attribute;}
          break;
        default:
          jj_la1[222] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case GATEWAY_IP:
    case IPV4_GATEWAY_IP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GATEWAY_IP:
        jj_consume_token(GATEWAY_IP);
        break;
      case IPV4_GATEWAY_IP:
        jj_consume_token(IPV4_GATEWAY_IP);
        break;
      default:
        jj_la1[223] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(EQUALS);
      gatewayIPAddress = ipSpec();
        {if (true) return new StringAttributeValuePair(Attribute.GATEWAY_IP_ADDRESS, token.image);}
      break;
    case REMOTE_ACCESS_ENABLED:
      jj_consume_token(REMOTE_ACCESS_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.REMOTE_ACCESS_ENABLED, token.image);}
      break;
    case ETHERNET_PORT:
      jj_consume_token(ETHERNET_PORT);
      jj_consume_token(LBRACKET);
      ethernetPort = integerLiteral();
      jj_consume_token(RBRACKET);
            ethernetPortAttributeValueList(ethernetPort);
        {if (true) return null;}
      break;
    case SERVICE_MODE:
      jj_consume_token(SERVICE_MODE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[225] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new StringAttributeValuePair(Attribute.SERVICE_MODE, token.image);}
      break;
    case SERVICE_ALLOWED_INDICATOR:
      jj_consume_token(SERVICE_ALLOWED_INDICATOR);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        jj_consume_token(ON);
        break;
      case OFF:
        jj_consume_token(OFF);
        break;
      default:
        jj_la1[226] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new StringAttributeValuePair(Attribute.SERVICE_ALLOWED_INDICATOR, token.image);}
      break;
    case IPV6_ROUTER_ADDRESS:
      jj_consume_token(IPV6_ROUTER_ADDRESS);
      jj_consume_token(EQUALS);
      ipv6RouterIpAddress = ipv6Spec();
        {if (true) return new StringAttributeValuePair(Attribute.IPV6_ROUTER_ADDRESS, ipv6RouterIpAddress);}
      break;
    default:
      jj_la1[227] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Parses multiple ethernet port attribute/value pairs in the grammer.
Each pair is aded to the list of attribute pairs.
<BR><BR>
*/
  final public void ethernetPortAttributeValueList(int ethernetPort) throws ParseException {
   Attribute   pair = null;
    label_14:
    while (true) {
      pair = ethernetPortAttributeValuePair(ethernetPort);
         m_AttributePairList.addElement(pair);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IP_ADDRESS:
      case SUBNET_MASK:
      case IPV4_ADDRESS:
      case IPV4_SUBNET_MASK:
      case IPV6_LOCAL_ADDRESS:
      case IPV6_ROUTABLE_ADDRESS:
      case ENABLE_IPV4:
      case ENABLE_IPV6:
      case IPV4_CONFIGURATION_METHOD:
      case IPV6_CONFIGURATION_METHOD:
      case DUPLEX_MODE:
      case PORT_SPEED:
        ;
        break;
      default:
        jj_la1[228] = jj_gen;
        break label_14;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid ethernet port attribute/value pair in the grammar.
When each pair is parsed a NetInterfaceAttribute object is created and returned.
<BR><BR>
*/
  final public Attribute ethernetPortAttributeValuePair(int ethernetPort) throws ParseException {
   String ipAddress = null;
   String subnetMask = null;
   String portSpeed = null;
   String ipv6Address = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IP_ADDRESS:
    case IPV4_ADDRESS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IP_ADDRESS:
        jj_consume_token(IP_ADDRESS);
        break;
      case IPV4_ADDRESS:
        jj_consume_token(IPV4_ADDRESS);
        break;
      default:
        jj_la1[229] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(EQUALS);
      ipAddress = ipSpec();
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.IP_ADDRESS, ethernetPort, ipAddress);}
      break;
    case SUBNET_MASK:
    case IPV4_SUBNET_MASK:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SUBNET_MASK:
        jj_consume_token(SUBNET_MASK);
        break;
      case IPV4_SUBNET_MASK:
        jj_consume_token(IPV4_SUBNET_MASK);
        break;
      default:
        jj_la1[230] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(EQUALS);
      subnetMask = ipSpec();
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.SUBNET_MASK, ethernetPort, subnetMask);}
      break;
    case IPV4_CONFIGURATION_METHOD:
      jj_consume_token(IPV4_CONFIGURATION_METHOD);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case DHCP:
        jj_consume_token(DHCP);
        break;
      default:
        jj_la1[231] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.IPV4_CONFIGURATION_METHOD, ethernetPort, token.image);}
      break;
    case DUPLEX_MODE:
      jj_consume_token(DUPLEX_MODE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[232] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.DUPLEX_MODE, ethernetPort, token.image);}
      break;
    case PORT_SPEED:
      jj_consume_token(PORT_SPEED);
      jj_consume_token(EQUALS);
      portSpeed = getPortSpeed();
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.PORT_SPEED, ethernetPort, portSpeed);}
      break;
    case IPV6_LOCAL_ADDRESS:
      jj_consume_token(IPV6_LOCAL_ADDRESS);
      jj_consume_token(EQUALS);
      ipv6Address = ipv6Spec();
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.IPV6_LOCAL_ADDRESS, ethernetPort, ipv6Address);}
      break;
    case IPV6_ROUTABLE_ADDRESS:
      jj_consume_token(IPV6_ROUTABLE_ADDRESS);
      jj_consume_token(EQUALS);
      ipv6Address = ipv6Spec();
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.IPV6_ROUTABLE_ADDRESS, ethernetPort, ipv6Address);}
      break;
    case IPV6_CONFIGURATION_METHOD:
      jj_consume_token(IPV6_CONFIGURATION_METHOD);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STATIC:
        jj_consume_token(STATIC);
        break;
      case AUTO:
        jj_consume_token(AUTO);
        break;
      default:
        jj_la1[233] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.IPV6_CONFIGURATION_METHOD, ethernetPort, token.image);}
      break;
    case ENABLE_IPV4:
      jj_consume_token(ENABLE_IPV4);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[234] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.ENABLE_IPV4, ethernetPort, token.image);}
      break;
    case ENABLE_IPV6:
      jj_consume_token(ENABLE_IPV6);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[235] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new NetInterfaceAttributeValuePair(
            Attribute.ENABLE_IPV6, ethernetPort, token.image);}
      break;
    default:
      jj_la1[236] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void sArrayAttributeValueList() throws ParseException {
   Attribute   pair = null;
    label_15:
    while (true) {
      pair = sArrayAttributeValuePair();
          m_AttributePairList.addElement(pair);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USER_LABEL:
      case TIME_OF_DAY:
      case BATTERY_INSTALL_DATE:
      case CACHE_BLOCK_SIZE:
      case CLEAR_EVENT_LOG:
      case DEMAND_FLUSH_AMOUNT:
      case DEMAND_FLUSH_THRESHOLD:
      case MEDIA_SCAN_RATE:
      case PASSWORD:
      case RESET_CONFIG:
      case DEFAULT_HOST_TYPE:
      case FAILOVER_ALERT_DELAY:
      case ALARM:
      case REDUNDANCYMODE:
        ;
        break;
      default:
        jj_la1[237] = jj_gen;
        break label_15;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute sArrayAttributeValuePair() throws ParseException {
   Object[]                      args = new Object[3];
   int                           demandFlushAmount = 0;
   int                           mediaScanRate = 0;
   int                           failoverAlertDelay = 0;
   int                           cacheBlockSize = 0;
   int                           defaultHostTypeIndex = 0;
   IntegerAttributeValuePair     integerPair = null;
   String                        errorString = null;
   String                        stringLiteral = null;
   int                           controllerRedundancyMode = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MEDIA_SCAN_RATE:
      jj_consume_token(MEDIA_SCAN_RATE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        mediaScanRate = integerLiteral();
         integerPair = new IntegerAttributeValuePair(Attribute.MEDIA_SCAN_RATE);
         integerPair.setValue( mediaScanRate );
         {if (true) return integerPair;}
        break;
      case DISABLED:
        jj_consume_token(DISABLED);
         integerPair = new IntegerAttributeValuePair(Attribute.MEDIA_SCAN_RATE);
         integerPair.setValue( 0 );
         {if (true) return integerPair;}
        break;
      default:
        jj_la1[238] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case ALARM:
      jj_consume_token(ALARM);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENABLE:
        jj_consume_token(ENABLE);
         integerPair = new IntegerAttributeValuePair(Attribute.ALARM, AlarmControl.ALARM_CONTROL_ENABLE);
         {if (true) return integerPair;}
        break;
      case DISABLE:
        jj_consume_token(DISABLE);
         integerPair = new IntegerAttributeValuePair(Attribute.ALARM, AlarmControl.ALARM_CONTROL_DISABLE);
         {if (true) return integerPair;}
        break;
      case MUTE:
        jj_consume_token(MUTE);
         integerPair = new IntegerAttributeValuePair(Attribute.ALARM, AlarmControl.ALARM_CONTROL_MUTE);
         {if (true) return integerPair;}
        break;
      default:
        jj_la1[239] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case FAILOVER_ALERT_DELAY:
      jj_consume_token(FAILOVER_ALERT_DELAY);
      jj_consume_token(EQUALS);
      failoverAlertDelay = integerLiteral();
        integerPair = new IntegerAttributeValuePair(Attribute.FAILOVER_ALERT_DELAY);
        integerPair.setValue( failoverAlertDelay );
        {if (true) return integerPair;}
      break;
    case BATTERY_INSTALL_DATE:
      jj_consume_token(BATTERY_INSTALL_DATE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[240] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.BATTERY_INSTALL_DATE, token.image);}
      break;
    case CACHE_BLOCK_SIZE:
      jj_consume_token(CACHE_BLOCK_SIZE);
      jj_consume_token(EQUALS);
      cacheBlockSize = integerLiteral();
        integerPair = new IntegerAttributeValuePair(Attribute.CACHE_BLOCK_SIZE, cacheBlockSize);
        {if (true) return integerPair;}
      break;
    case DEMAND_FLUSH_AMOUNT:
      jj_consume_token(DEMAND_FLUSH_AMOUNT);
      jj_consume_token(EQUALS);
      demandFlushAmount = integerLiteral();
        if ( demandFlushAmount < 0 || demandFlushAmount > 100 )
        {
           args[0] = new Integer(getLine());
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_DEMAND_FLUSH_VALUE"), args );
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
        }
        integerPair = new IntegerAttributeValuePair(Attribute.DEMAND_FLUSH_AMOUNT);
        integerPair.setValue(demandFlushAmount);
        {if (true) return integerPair;}
      break;
    case DEMAND_FLUSH_THRESHOLD:
      jj_consume_token(DEMAND_FLUSH_THRESHOLD);
      jj_consume_token(EQUALS);
      demandFlushAmount = integerLiteral();
         if ( demandFlushAmount < 0 || demandFlushAmount > 100 )
         {
            args[0] = new Integer(getLine());
            errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_DEMAND_FLUSH_VALUE"), args );
            m_ParseException = new ParseException(errorString);
            {if (true) throw m_ParseException;}
         }
         integerPair = new IntegerAttributeValuePair(Attribute.DEMAND_FLUSH_THRESHOLD);
         integerPair.setValue(demandFlushAmount);
         {if (true) return integerPair;}
      break;
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      stringLiteral = userLabelLiteral();
        {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral);}
      break;
    case RESET_CONFIG:
      jj_consume_token(RESET_CONFIG);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[241] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.RESET_CONFIG, token.image);}
      break;
    case TIME_OF_DAY:
      jj_consume_token(TIME_OF_DAY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[242] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.TIME_OF_DAY, token.image);}
      break;
    case PASSWORD:
      jj_consume_token(PASSWORD);
      jj_consume_token(EQUALS);
      stringLiteral = stringLiteral();
        {if (true) return new StringAttributeValuePair(Attribute.PASSWORD, stringLiteral);}
      break;
    case CLEAR_EVENT_LOG:
      jj_consume_token(CLEAR_EVENT_LOG);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[243] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CLEAR_EVENT_LOG, token.image);}
      break;
    case DEFAULT_HOST_TYPE:
      jj_consume_token(DEFAULT_HOST_TYPE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        defaultHostTypeIndex = integerLiteral();
        integerPair = new IntegerAttributeValuePair(Attribute.DEFAULT_HOST_TYPE);
        integerPair.setValue( defaultHostTypeIndex );
        {if (true) return integerPair;}
        break;
      case STRING_LITERAL:
        stringLiteral = stringLiteral();
        {if (true) return new StringAttributeValuePair(Attribute.DEFAULT_HOST_TYPE, stringLiteral);}
        break;
      default:
        jj_la1[244] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case REDUNDANCYMODE:
      jj_consume_token(REDUNDANCYMODE);
      jj_consume_token(EQUALS);
      controllerRedundancyMode = controllerRedundancyMode();
        {if (true) return new IntegerAttributeValuePair(Attribute.REDUNDANCY_MODE, controllerRedundancyMode);}
      break;
    default:
      jj_la1[245] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array session attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void sArraySessionAttributeValueList() throws ParseException {
   Attribute   pair = null;
    label_16:
    while (true) {
      pair = sArraySessionAttributeValuePair();
          m_AttributePairList.addElement(pair);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PASSWORD:
      case ERROR_ACTION:
      case PERFMON_INTERVAL:
      case PERFMON_ITERATIONS:
        ;
        break;
      default:
        jj_la1[246] = jj_gen;
        break label_16;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array session attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute sArraySessionAttributeValuePair() throws ParseException {
   String               password;
   int                  perfMonInterval;
   int                  perfMonIterations;
   Object []            formatArgs = new Object[3];
   String               errorString;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ERROR_ACTION:
      jj_consume_token(ERROR_ACTION);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STOP:
        jj_consume_token(STOP);
      {if (true) return new BooleanAttributeValuePair(Attribute.ERROR_ACTION, true);}
        break;
      case CONTINUE:
        jj_consume_token(CONTINUE);
      {if (true) return new BooleanAttributeValuePair(Attribute.ERROR_ACTION, false);}
        break;
      default:
        jj_la1[247] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case PASSWORD:
      jj_consume_token(PASSWORD);
      jj_consume_token(EQUALS);
      password = stringLiteral();
      {if (true) return new StringAttributeValuePair(Attribute.PASSWORD, password);}
      break;
    case PERFMON_INTERVAL:
      jj_consume_token(PERFMON_INTERVAL);
      jj_consume_token(EQUALS);
      perfMonInterval = integerLiteral();
         if( perfMonInterval < PERF_MON_INTERVAL_MIN || perfMonInterval > PERF_MON_INTERVAL_MAX )
            {
               formatArgs[0] = Integer.toString(getLine());
               formatArgs[1] = Integer.toString(PERF_MON_INTERVAL_MIN);
               formatArgs[2] = Integer.toString(PERF_MON_INTERVAL_MAX);
               errorString = MessageFormat.format(Resource.getString(
                              "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                              formatArgs);
               m_ParseException = new ParseException(errorString);
               {if (true) throw m_ParseException;}
            }

         {if (true) return new IntegerAttributeValuePair(Attribute.PERFMON_INTERVAL, perfMonInterval);}
      break;
    case PERFMON_ITERATIONS:
      jj_consume_token(PERFMON_ITERATIONS);
      jj_consume_token(EQUALS);
      perfMonIterations = integerLiteral();
       if( perfMonIterations < PERF_MON_ITERATIONS_MIN
               || perfMonIterations > PERF_MON_ITERATIONS_MAX )
       {
          formatArgs[0] = Integer.toString(getLine());
          formatArgs[1] = Integer.toString(PERF_MON_ITERATIONS_MIN);
          formatArgs[2] = Integer.toString(PERF_MON_ITERATIONS_MAX);
          errorString = MessageFormat.format(Resource.getString(
                         "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                         formatArgs);
          m_ParseException = new ParseException(errorString);
          {if (true) throw m_ParseException;}
       }
       {if (true) return new IntegerAttributeValuePair(Attribute.PERFMON_INTERATIONS, perfMonIterations);}
      break;
    default:
      jj_la1[248] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void uploadContentAttributeList() throws ParseException {
   Attribute      attribute = null;
    attribute = uploadContentAttribute();
         m_AttributeList.addElement(attribute);
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute uploadContentAttribute() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STATEDUMP:
      jj_consume_token(STATEDUMP);
        {if (true) return new Attribute(Attribute.STATEDUMP);}
      break;
    case STATECAPTURE:
      jj_consume_token(STATECAPTURE);
        {if (true) return new Attribute(Attribute.STATEDUMP);}
      break;
    case CONFIGURATION:
      jj_consume_token(CONFIGURATION);
        {if (true) return new ObjectAttributeValuePair(Attribute.CONFIGURATION, m_AttributePairList);}
      break;
    case PERFORMANCE_STATS:
      jj_consume_token(PERFORMANCE_STATS);
        {if (true) return new Attribute(Attribute.PERFORMANCE_STATS);}
      break;
    case RLS_COUNTS:
      jj_consume_token(RLS_COUNTS);
        {if (true) return new Attribute(Attribute.RLS_COUNTS);}
      break;
    case SOC_COUNTS:
      jj_consume_token(SOC_COUNTS);
        {if (true) return new Attribute(Attribute.SOC_COUNTS);}
      break;
    case CRITICAL_EVENTS:
      jj_consume_token(CRITICAL_EVENTS);
        {if (true) return new IntegerAttributeValuePair(Attribute.CRITICAL_EVENTS, 0);}
      break;
    case ALL_EVENTS:
      jj_consume_token(ALL_EVENTS);
        {if (true) return new IntegerAttributeValuePair(Attribute.ALL_EVENTS, 0);}
      break;
    case SUPPORT_DATA:
      jj_consume_token(SUPPORT_DATA);
        {if (true) return new Attribute(Attribute.GATHER_SUPPORT_DATA);}
      break;
    case SAS_PHYCOUNTS:
      jj_consume_token(SAS_PHYCOUNTS);
        {if (true) return new Attribute(Attribute.SAS_PHY_LOGS);}
      break;
    case DIAGNOSTIC_DATA:
      jj_consume_token(DIAGNOSTIC_DATA);
        {if (true) return new Attribute(Attribute.DIAGNOSTIC_DATA);}
      break;
    case ISCSI_STATISTICS:
      jj_consume_token(ISCSI_STATISTICS);
        {if (true) return new Attribute(Attribute.ISCSI_STATISTICS);}
      break;
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid save configuration attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void saveConfigAttributeValueList() throws ParseException {
   Attribute pair = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL_CONFIG:
      jj_consume_token(ALL_CONFIG);
      pair = new Attribute(Attribute.ALL_CONFIG);
      m_AttributePairList.addElement(pair);
      break;
    case HOST_TOPOLOGY:
    case GLOBAL_SETTINGS:
    case VOLUME_CONFIG_AND_SETTINGS:
    case LUN_MAPPINGS:
      label_17:
      while (true) {
        pair = saveConfigAttributeValuePair();
         if (pair != null)
         {
            m_AttributePairList.addElement( pair );
         }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HOST_TOPOLOGY:
        case GLOBAL_SETTINGS:
        case VOLUME_CONFIG_AND_SETTINGS:
        case LUN_MAPPINGS:
          ;
          break;
        default:
          jj_la1[250] = jj_gen;
          break label_17;
        }
      }
      break;
    default:
      jj_la1[251] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid save configuration attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute saveConfigAttributeValuePair() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GLOBAL_SETTINGS:
      jj_consume_token(GLOBAL_SETTINGS);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[252] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.GLOBAL_SETTINGS, token.image);}
      break;
    case VOLUME_CONFIG_AND_SETTINGS:
      jj_consume_token(VOLUME_CONFIG_AND_SETTINGS);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[253] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.VOLUME_CONFIG_AND_SETTINGS, token.image);}
      break;
    case HOST_TOPOLOGY:
      jj_consume_token(HOST_TOPOLOGY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[254] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.HOST_TOPOLOGY, token.image);}
      break;
    case LUN_MAPPINGS:
      jj_consume_token(LUN_MAPPINGS);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[255] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.LUN_MAPPINGS, token.image);}
      break;
    default:
      jj_la1[256] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
Describes what constitutes a valid iSCSI Statistics Attribute.
*/
  final public void saveIscsiStatisticsAttribute() throws ParseException {
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RAW:
      jj_consume_token(RAW);
      m_AttributeList.addElement(new Attribute(Attribute.RAW));
      break;
    case BASELINE:
      jj_consume_token(BASELINE);
      m_AttributeList.addElement(new Attribute(Attribute.BASELINE));
      break;
    default:
      jj_la1[257] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RBRACKET);
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid Drive Channel Fault Isolation Diagnostics (DCFID) 
attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void DCFaultDiagnosticsAttributeValueList() throws ParseException {
   Attribute pair = null;
    jj_consume_token(TEST_DEVICES);
    jj_consume_token(EQUALS);
    jj_consume_token(LBRACKET);
    testFaultIsolationDevices();
    jj_consume_token(RBRACKET);
    label_18:
    while (true) {
      pair = DCFaultDiagnosticsAttributeValuePair();
         if (pair != null)
         {
            m_AttributePairList.addElement( pair );
         }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIME_OUT:
      case DATA_PATTERN_TYPE:
      case PATTERN_NUMBER:
      case MAX_ERROR_COUNT:
      case TEST_ITERATIONS:
        ;
        break;
      default:
        jj_la1[258] = jj_gen;
        break label_18;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid start Drive Channel Fault Isolation Diagnostics 
attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute DCFaultDiagnosticsAttributeValuePair() throws ParseException {
   IntegerAttributeValuePair     integerPair = null;
   Attribute                     testAttribute = null;
   String                        stringLiteral = null;
   String                        cont = null;
   int                           maxInterval = -1;
   int                           driveChannelId = -1;
   int                           patternNumber = -1;
   int                           iterationsPerDevice = -1;
   int                           maxErrorsAllowed = -1;
   String                        controllerName = "";
   String                        controller = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEST_ITERATIONS:
      jj_consume_token(TEST_ITERATIONS);
      jj_consume_token(EQUALS);
      iterationsPerDevice = integerLiteral();
         {if (true) return new IntegerAttributeValuePair(Attribute.DCFID_TEST_ITERATIONS, iterationsPerDevice);}
      break;
    case MAX_ERROR_COUNT:
      jj_consume_token(MAX_ERROR_COUNT);
      jj_consume_token(EQUALS);
      maxErrorsAllowed = integerLiteral();
         {if (true) return new IntegerAttributeValuePair(Attribute.DCFID_MAX_ERROR_COUNT, maxErrorsAllowed);}
      break;
    case TIME_OUT:
      jj_consume_token(TIME_OUT);
      jj_consume_token(EQUALS);
      maxInterval = integerLiteral();
         {if (true) return new IntegerAttributeValuePair(Attribute.DCFID_TIMEOUT, maxInterval);}
      break;
    case DATA_PATTERN_TYPE:
      jj_consume_token(DATA_PATTERN_TYPE);
      jj_consume_token(EQUALS);
      jj_consume_token(FIXED_RANDOM_PATTERN);
         {if (true) return new StringAttributeValuePair(Attribute.DCFID_DATA_PATTERN, token.image);}
      break;
    case PATTERN_NUMBER:
      jj_consume_token(PATTERN_NUMBER);
      jj_consume_token(EQUALS);
      patternNumber = integerLiteral();
         {if (true) return new IntegerAttributeValuePair(Attribute.DCFID_PATTERN_NUMBER, patternNumber);}
      break;
    default:
      jj_la1[259] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes the devices for Drive Channel Fault Isolation Diagnostics (DCFID) through
attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void testFaultIsolationDevices() throws ParseException {
   Attribute pair = null;
    label_19:
    while (true) {
      pair = testDevicesDCFID();
         if (pair != null)
         {
            m_AttributePairList.addElement( pair );
         }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONTROLLER:
      case DRIVES:
      case ESM_LIST:
      case ALL_DEVICES:
        ;
        break;
      default:
        jj_la1[260] = jj_gen;
        break label_19;
      }
    }
  }

/**
Returns the attribute pair for each of the type of the DCFID test devices.
Assume that only one type of device can be specified
*/
  final public Attribute testDevicesDCFID() throws ParseException {
   boolean                       allDevicesFlag = true;
   Vector                        driveList = new Vector();
   Vector                        esmsList = new Vector();
   String                        testControllerName = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL_DEVICES:
      jj_consume_token(ALL_DEVICES);
         {if (true) return new BooleanAttributeValuePair(Attribute.ALL_DEVICES, allDevicesFlag);}
      break;
    case CONTROLLER:
      jj_consume_token(CONTROLLER);
      jj_consume_token(EQUALS);
      testControllerName = controllerSpec();
         {if (true) return new StringAttributeValuePair(Attribute.DCFID_TEST_CONTROLLER, testControllerName);}
      break;
    case ESM_LIST:
      jj_consume_token(ESM_LIST);
      jj_consume_token(EQUALS);
      jj_consume_token(LPAREN);
      esmsList = esmList();
      jj_consume_token(RPAREN);
         {if (true) return new ObjectAttributeValuePair(Attribute.DCFID_TEST_ESMS, esmsList);}
      break;
    case DRIVES:
      jj_consume_token(DRIVES);
      jj_consume_token(EQUALS);
      jj_consume_token(LPAREN);
      driveList();
      jj_consume_token(RPAREN);
         {if (true) return new ObjectAttributeValuePair(Attribute.DCFID_TEST_DRIVES, m_DriveList);}
      break;
    default:
      jj_la1[261] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
Describes what constitutes a valid save diagnostic data attribute. An attribute is added to
m_AttributeList if the appropriate token is found.
*/
  final public void saveDiagnosticDataAttribute() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONTROLLER:
    case ESM:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ESM:
        jj_consume_token(ESM);
      m_AttributeList.addElement(new Attribute(Attribute.ESM));
        break;
      case CONTROLLER:
        jj_consume_token(CONTROLLER);
      m_AttributeList.addElement(new Attribute(Attribute.CONTROLLER));
        break;
      default:
        jj_la1[262] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[263] = jj_gen;
      ;
    }
  }

/**
A conditional portion of the save storage array command that is valid if the command is 
save storageArray allEvents or criticalEvents. 
*/
  final public void saveStorageArrayCountOperands() throws ParseException {
   Object [] formatArg = new Object[1];
   int       eventCount;
   String    errorString = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COUNT:
      jj_consume_token(COUNT);
      jj_consume_token(EQUALS);
      eventCount = integerLiteral();
      if ((m_AttributeList.firstElement() instanceof IntegerAttributeValuePair)
           && (((IntegerAttributeValuePair) m_AttributeList.firstElement()).getAttributeType() ==
                  Attribute.ALL_EVENTS
               || ((IntegerAttributeValuePair)m_AttributeList.firstElement()).getAttributeType() ==
                  Attribute.CRITICAL_EVENTS ))
      {
         ((IntegerAttributeValuePair)m_AttributeList.firstElement()).setValue(eventCount);
      }
      else
      {
         formatArg[0] = Integer.toString(getLine());
         errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_COUNT"),
                           formatArg);
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }
      break;
    default:
      jj_la1[264] = jj_gen;
      ;
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void volumeAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_20:
    while (true) {
      pair = volumeAttributeValuePair();
         if (pair != null)
         {
            m_AttributePairList.addElement( pair );
         }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USER_LABEL:
      case CACHE_FLUSH_MODIFIER:
      case CACHE_WO_BATTERY_ENABLED:
      case MEDIA_SCAN_ENABLED:
      case MIRROR_ENABLED:
      case MIRROR_CACHE_ENABLED:
      case OWNER:
      case REDUNDANCY_CHECK_ENABLED:
      case READ_CACHE_ENABLED:
      case CACHE_READ_PREFETCH:
      case READ_AHEAD_MULTIPLIER:
      case SEGMENT_SIZE:
      case MODIFICATION_PRIORITY:
      case WRITE_CACHE_ENABLED:
      case REPOSITORY_FULL_POLICY:
      case WARNING_THRESHOLD_PERCENT:
      case LUN:
      case ROLE:
      case FORCE:
      case ADD_CAPACITY:
      case TRAY_LOSS_PROTECT:
      case ADD_MAPPING:
      case PRE_READ_REDUNDANCY_CHECK:
        ;
        break;
      default:
        jj_la1[265] = jj_gen;
        break label_20;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair list in the grammar for
commands using multiple volumes.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void multipleVolumeAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_21:
    while (true) {
      pair = multipleVolumeAttributeValuePair();
         if (pair != null)
         {
            m_AttributePairList.addElement( pair );
         }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CACHE_FLUSH_MODIFIER:
      case CACHE_WO_BATTERY_ENABLED:
      case MEDIA_SCAN_ENABLED:
      case MIRROR_ENABLED:
      case MIRROR_CACHE_ENABLED:
      case OWNER:
      case REDUNDANCY_CHECK_ENABLED:
      case READ_CACHE_ENABLED:
      case CACHE_READ_PREFETCH:
      case READ_AHEAD_MULTIPLIER:
      case MODIFICATION_PRIORITY:
      case WRITE_CACHE_ENABLED:
      case REPOSITORY_FULL_POLICY:
      case WARNING_THRESHOLD_PERCENT:
      case ROLE:
      case FORCE:
      case TRAY_LOSS_PROTECT:
        ;
        break;
      default:
        jj_la1[266] = jj_gen;
        break label_21;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute volumeAttributeValuePair() throws ParseException {
   int                           cacheFlushModifier = 0;
   int                           reconPriority = 0;
   boolean                       cacheReadPrefetch = true;
   int                           segmentSize = 0;
   CapacityAttributeValuePair    capacityPair = null;
   IntegerAttributeValuePair     integerPair = null;
   String                        stringLiteral = null;
   String                        cont = null;
   int                           percent = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CACHE_FLUSH_MODIFIER:
      jj_consume_token(CACHE_FLUSH_MODIFIER);
      jj_consume_token(EQUALS);
      cacheFlushModifier = cacheFlushValue();
       integerPair = new IntegerAttributeValuePair(Attribute.CACHE_FLUSH_MODIFIER);
       integerPair.setValue( cacheFlushModifier );
       {if (true) return integerPair;}
      break;
    case CACHE_READ_PREFETCH:
      jj_consume_token(CACHE_READ_PREFETCH);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[267] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, token.image);}
      break;
    case READ_AHEAD_MULTIPLIER:
      jj_consume_token(READ_AHEAD_MULTIPLIER);
      jj_consume_token(EQUALS);
      cacheReadPrefetch = integerLiteralToBoolean();
         {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, cacheReadPrefetch);}
      break;
    case CACHE_WO_BATTERY_ENABLED:
      jj_consume_token(CACHE_WO_BATTERY_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[268] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_WO_BATTERY_ENABLED, token.image);}
      break;
    case MEDIA_SCAN_ENABLED:
      jj_consume_token(MEDIA_SCAN_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[269] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.MEDIA_SCAN_ENABLED, token.image);}
      break;
    case REDUNDANCY_CHECK_ENABLED:
      jj_consume_token(REDUNDANCY_CHECK_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[270] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.REDUNDANCY_CHECK_ENABLED, token.image);}
      break;
    case READ_CACHE_ENABLED:
      jj_consume_token(READ_CACHE_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[271] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.READ_CACHE_ENABLED, token.image);}
      break;
    case MIRROR_ENABLED:
    case MIRROR_CACHE_ENABLED:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MIRROR_ENABLED:
        jj_consume_token(MIRROR_ENABLED);
        break;
      case MIRROR_CACHE_ENABLED:
        jj_consume_token(MIRROR_CACHE_ENABLED);
        break;
      default:
        jj_la1[272] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[273] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_MIRROR_ENABLED, token.image);}
      break;
    case WRITE_CACHE_ENABLED:
      jj_consume_token(WRITE_CACHE_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[274] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.WRITE_CACHE_ENABLED, token.image);}
      break;
    case MODIFICATION_PRIORITY:
      jj_consume_token(MODIFICATION_PRIORITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOWEST:
        jj_consume_token(LOWEST);
         reconPriority = 4;
        break;
      case LOW:
        jj_consume_token(LOW);
         reconPriority = 3;
        break;
      case MEDIUM:
        jj_consume_token(MEDIUM);
         reconPriority = 2;
        break;
      case HIGH:
        jj_consume_token(HIGH);
         reconPriority = 1;
        break;
      case HIGHEST:
        jj_consume_token(HIGHEST);
         reconPriority = 0;
        break;
      default:
        jj_la1[275] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         integerPair = new IntegerAttributeValuePair(Attribute.RECONSTRUCTION_PRIORITY);
         integerPair.setValue( reconPriority );
         {if (true) return integerPair;}
      break;
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      stringLiteral = userLabelLiteral();
       {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral);}
      break;
    case OWNER:
      jj_consume_token(OWNER);
      jj_consume_token(EQUALS);
      cont = controllerSpec();
       {if (true) return new StringAttributeValuePair(Attribute.OWNER, cont);}
      break;
    case WARNING_THRESHOLD_PERCENT:
      jj_consume_token(WARNING_THRESHOLD_PERCENT);
      jj_consume_token(EQUALS);
      percent = getPercent(WARNING_THRESH_PERCENT_MIN, WARNING_THRESH_PERCENT_MAX);
      {if (true) return new IntegerAttributeValuePair(Attribute.WARNING_THRESH_PERCENT, percent);}
      break;
    case REPOSITORY_FULL_POLICY:
      jj_consume_token(REPOSITORY_FULL_POLICY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FAIL_BASE_WRITES:
        jj_consume_token(FAIL_BASE_WRITES);
        break;
      case FAIL_SNAPSHOT:
        jj_consume_token(FAIL_SNAPSHOT);
        break;
      default:
        jj_la1[276] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair (Attribute.REPOSITORY_FULL_POLICY,
         token.image);}
      break;
    case ROLE:
      jj_consume_token(ROLE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIMARY:
        jj_consume_token(PRIMARY);
        break;
      case SECONDARY:
        jj_consume_token(SECONDARY);
        break;
      default:
        jj_la1[277] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair(Attribute.MIRROR_ROLE, token.image);}
      break;
    case FORCE:
      jj_consume_token(FORCE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[278] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.MIRROR_FORCE, token.image);}
      break;
    case LUN:
      LUNSpec();
      hostOrHostGroupNameSpec();
      {if (true) return new ObjectAttributeValuePair(Attribute.LUN_MAPPING, m_VolumeMapping );}
      break;
    case ADD_CAPACITY:
      jj_consume_token(ADD_CAPACITY);
      jj_consume_token(EQUALS);
      capacityPair = capacitySpec();
      {if (true) return capacityPair;}
      break;
    case SEGMENT_SIZE:
      jj_consume_token(SEGMENT_SIZE);
      jj_consume_token(EQUALS);
      segmentSize = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.SEGMENT_SIZE, segmentSize);}
      break;
    case TRAY_LOSS_PROTECT:
      jj_consume_token(TRAY_LOSS_PROTECT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[279] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.TRAY_LOSS_PROTECT, token.image);}
      break;
    case ADD_MAPPING:
      jj_consume_token(ADD_MAPPING);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[280] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ADD_MAPPING, token.image);}
      break;
    case PRE_READ_REDUNDANCY_CHECK:
      jj_consume_token(PRE_READ_REDUNDANCY_CHECK);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[281] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.PRE_READ_REDUNDANCY_CHECK, token.image);}
      break;
    default:
      jj_la1[282] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair in the grammar
for commands using multiple volumes.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute multipleVolumeAttributeValuePair() throws ParseException {
   int                           cacheFlushModifier = 0;
   int                           reconPriority = 0;
   boolean                       cacheReadPrefetch = true;
   IntegerAttributeValuePair     integerPair = null;
   String                        cont = null;
   int                           percent = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CACHE_FLUSH_MODIFIER:
      jj_consume_token(CACHE_FLUSH_MODIFIER);
      jj_consume_token(EQUALS);
      cacheFlushModifier = cacheFlushValue();
       integerPair = new IntegerAttributeValuePair(Attribute.CACHE_FLUSH_MODIFIER);
       integerPair.setValue( cacheFlushModifier );
       {if (true) return integerPair;}
      break;
    case CACHE_READ_PREFETCH:
      jj_consume_token(CACHE_READ_PREFETCH);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[283] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, token.image);}
      break;
    case READ_AHEAD_MULTIPLIER:
      jj_consume_token(READ_AHEAD_MULTIPLIER);
      jj_consume_token(EQUALS);
      cacheReadPrefetch = integerLiteralToBoolean();
         {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, cacheReadPrefetch);}
      break;
    case CACHE_WO_BATTERY_ENABLED:
      jj_consume_token(CACHE_WO_BATTERY_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[284] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_WO_BATTERY_ENABLED, token.image);}
      break;
    case MEDIA_SCAN_ENABLED:
      jj_consume_token(MEDIA_SCAN_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[285] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.MEDIA_SCAN_ENABLED, token.image);}
      break;
    case REDUNDANCY_CHECK_ENABLED:
      jj_consume_token(REDUNDANCY_CHECK_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[286] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.REDUNDANCY_CHECK_ENABLED, token.image);}
      break;
    case READ_CACHE_ENABLED:
      jj_consume_token(READ_CACHE_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[287] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.READ_CACHE_ENABLED, token.image);}
      break;
    case MIRROR_ENABLED:
    case MIRROR_CACHE_ENABLED:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MIRROR_ENABLED:
        jj_consume_token(MIRROR_ENABLED);
        break;
      case MIRROR_CACHE_ENABLED:
        jj_consume_token(MIRROR_CACHE_ENABLED);
        break;
      default:
        jj_la1[288] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[289] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_MIRROR_ENABLED, token.image);}
      break;
    case WRITE_CACHE_ENABLED:
      jj_consume_token(WRITE_CACHE_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[290] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(Attribute.WRITE_CACHE_ENABLED, token.image);}
      break;
    case MODIFICATION_PRIORITY:
      jj_consume_token(MODIFICATION_PRIORITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOWEST:
        jj_consume_token(LOWEST);
         reconPriority = 4;
        break;
      case LOW:
        jj_consume_token(LOW);
         reconPriority = 3;
        break;
      case MEDIUM:
        jj_consume_token(MEDIUM);
         reconPriority = 2;
        break;
      case HIGH:
        jj_consume_token(HIGH);
         reconPriority = 1;
        break;
      case HIGHEST:
        jj_consume_token(HIGHEST);
         reconPriority = 0;
        break;
      default:
        jj_la1[291] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         integerPair = new IntegerAttributeValuePair(Attribute.RECONSTRUCTION_PRIORITY);
         integerPair.setValue( reconPriority );
         {if (true) return integerPair;}
      break;
    case OWNER:
      jj_consume_token(OWNER);
      jj_consume_token(EQUALS);
      cont = controllerSpec();
       {if (true) return new StringAttributeValuePair(Attribute.OWNER, cont);}
      break;
    case WARNING_THRESHOLD_PERCENT:
      jj_consume_token(WARNING_THRESHOLD_PERCENT);
      jj_consume_token(EQUALS);
      percent = getPercent(WARNING_THRESH_PERCENT_MIN, WARNING_THRESH_PERCENT_MAX);
      {if (true) return new IntegerAttributeValuePair(Attribute.WARNING_THRESH_PERCENT, percent);}
      break;
    case REPOSITORY_FULL_POLICY:
      jj_consume_token(REPOSITORY_FULL_POLICY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FAIL_BASE_WRITES:
        jj_consume_token(FAIL_BASE_WRITES);
        break;
      case FAIL_SNAPSHOT:
        jj_consume_token(FAIL_SNAPSHOT);
        break;
      default:
        jj_la1[292] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair (Attribute.REPOSITORY_FULL_POLICY,
         token.image);}
      break;
    case ROLE:
      jj_consume_token(ROLE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIMARY:
        jj_consume_token(PRIMARY);
        break;
      case SECONDARY:
        jj_consume_token(SECONDARY);
        break;
      default:
        jj_la1[293] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair(Attribute.MIRROR_ROLE, token.image);}
      break;
    case FORCE:
      jj_consume_token(FORCE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[294] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.MIRROR_FORCE, token.image);}
      break;
    case TRAY_LOSS_PROTECT:
      jj_consume_token(TRAY_LOSS_PROTECT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[295] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.TRAY_LOSS_PROTECT, token.image);}
      break;
    default:
      jj_la1[296] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void createVolumeAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_22:
    while (true) {
      pair = createVolumeAttributeValuePair();
         m_AttributePairList.addElement( pair );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAPPING:
      case USER_LABEL:
      case VOLUME_GROUP_USER_LABEL:
      case CAPACITY:
      case OWNER:
      case CACHE_READ_PREFETCH:
      case READ_AHEAD_MULTIPLIER:
      case SEGMENT_SIZE:
      case RAID_LEVEL:
      case USAGE_HINT:
      case ENFORCESOFTLIMIT:
      case DRIVE_TYPE:
      case TRAY_LOSS_PROTECT:
      case FREE_CAPACITY_AREA:
      case DSS_PREALLOCATE:
        ;
        break;
      default:
        jj_la1[297] = jj_gen;
        break label_22;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void recoverVolumeAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_23:
    while (true) {
      pair = recoverVolumeAttributeValuePair();
         m_AttributePairList.addElement( pair );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OWNER:
      case CACHE_READ_PREFETCH:
      case READ_AHEAD_MULTIPLIER:
        ;
        break;
      default:
        jj_la1[298] = jj_gen;
        break label_23;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute createVolumeAttributeValuePair() throws ParseException {
   int                           integerLiteral = 0;
   CapacityAttributeValuePair    capacityPair = null;
   String                        stringLiteral = null;
   int                           segmentSize = 0;
   boolean                       cacheReadPrefetch = true;
   int                           physicalDriveType = 0;
   int                           repositoryFreeCapacityArea = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CAPACITY:
      jj_consume_token(CAPACITY);
      jj_consume_token(EQUALS);
      capacityPair = createCapacityPair();
         {if (true) return capacityPair;}
      break;
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      stringLiteral = userLabelLiteral();
         {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral);}
      break;
    case RAID_LEVEL:
      jj_consume_token(RAID_LEVEL);
      jj_consume_token(EQUALS);
      integerLiteral = raidLevel();
         {if (true) return new IntegerAttributeValuePair(Attribute.RAID_LEVEL, integerLiteral );}
      break;
    case USAGE_HINT:
      jj_consume_token(USAGE_HINT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIMEDIA:
        jj_consume_token(MULTIMEDIA);
        break;
      case DATABASE:
        jj_consume_token(DATABASE);
        break;
      case FILE_SYSTEM:
        jj_consume_token(FILE_SYSTEM);
        break;
      default:
        jj_la1[299] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new StringAttributeValuePair(Attribute.USAGE_HINT, token.image);}
      break;
    case OWNER:
      jj_consume_token(OWNER);
      jj_consume_token(EQUALS);
      stringLiteral = controllerSpec();
         {if (true) return new StringAttributeValuePair(Attribute.OWNER, stringLiteral);}
      break;
    case SEGMENT_SIZE:
      jj_consume_token(SEGMENT_SIZE);
      jj_consume_token(EQUALS);
      segmentSize = integerLiteral();
         {if (true) return new IntegerAttributeValuePair(Attribute.SEGMENT_SIZE, segmentSize);}
      break;
    case MAPPING:
      jj_consume_token(MAPPING);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MAPPING_DEFAULT:
        jj_consume_token(MAPPING_DEFAULT);
        break;
      case NONE:
        jj_consume_token(NONE);
        break;
      default:
        jj_la1[300] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new BooleanAttributeValuePair(
         Attribute.MAPPING, (token.image.equalsIgnoreCase(Resource.getString("SE_DEFAULT"))));}
      break;
    case CACHE_READ_PREFETCH:
      jj_consume_token(CACHE_READ_PREFETCH);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[301] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, token.image);}
      break;
    case READ_AHEAD_MULTIPLIER:
      jj_consume_token(READ_AHEAD_MULTIPLIER);
      jj_consume_token(EQUALS);
      cacheReadPrefetch = integerLiteralToBoolean();
         {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, cacheReadPrefetch);}
      break;
    case ENFORCESOFTLIMIT:
      jj_consume_token(ENFORCESOFTLIMIT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[302] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENFORCESOFTLIMIT, token.image);}
      break;
    case TRAY_LOSS_PROTECT:
      jj_consume_token(TRAY_LOSS_PROTECT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[303] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.TRAY_LOSS_PROTECT, token.image);}
      break;
    case DRIVE_TYPE:
      jj_consume_token(DRIVE_TYPE);
      jj_consume_token(EQUALS);
      physicalDriveType = physicalDriveType();
      {if (true) return new IntegerAttributeValuePair(Attribute.DRIVE_TYPE, physicalDriveType );}
      break;
    case FREE_CAPACITY_AREA:
      jj_consume_token(FREE_CAPACITY_AREA);
      jj_consume_token(EQUALS);
      repositoryFreeCapacityArea = integerLiteral();
      {if (true) return new IntegerAttributeValuePair(Attribute.FREE_CAPACITY_AREA,
          repositoryFreeCapacityArea );}
      break;
    case VOLUME_GROUP_USER_LABEL:
      jj_consume_token(VOLUME_GROUP_USER_LABEL);
      jj_consume_token(EQUALS);
      stringLiteral = userLabelLiteral();
      {if (true) return new StringAttributeValuePair(Attribute.VOLUME_GROUP_USER_LABEL, stringLiteral);}
      break;
    case DSS_PREALLOCATE:
      jj_consume_token(DSS_PREALLOCATE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[304] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.DSS_PREALLOCATE, token.image);}
      break;
    default:
      jj_la1[305] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute recoverVolumeAttributeValuePair() throws ParseException {
   boolean                       cacheReadPrefetch = true;
   String                        stringLiteral = null;
   Object[]                      formatArgs = new Object[3];
   String                        errorString = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OWNER:
      jj_consume_token(OWNER);
      jj_consume_token(EQUALS);
      stringLiteral = controllerSpec();
         {if (true) return new StringAttributeValuePair(Attribute.OWNER, stringLiteral);}
      break;
    case CACHE_READ_PREFETCH:
      jj_consume_token(CACHE_READ_PREFETCH);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[306] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, token.image);}
      break;
    case READ_AHEAD_MULTIPLIER:
      jj_consume_token(READ_AHEAD_MULTIPLIER);
      jj_consume_token(EQUALS);
      cacheReadPrefetch = integerLiteralToBoolean();
         {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, cacheReadPrefetch);}
      break;
    default:
      jj_la1[307] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes the repository specification parameters on a snapshot volume
create statement.
<BR><BR>
*/
  final public void createRepositorySpec() throws ParseException {
   int         volumeGroup = -1;
   int         driveCount;
   int         physicalDriveType;
   int             raidLevel;
   int         freeCapacityArea = -1;
   String      volumeGroupName = null;  // for indicating a destination volume group
   String      volumeGroupUserLabel = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REPOSITORY_RAID_LEVEL:
      jj_consume_token(REPOSITORY_RAID_LEVEL);
      jj_consume_token(EQUALS);
      raidLevel = raidLevel();
     m_AttributePairList.add(new IntegerAttributeValuePair(Attribute.RAID_LEVEL, raidLevel));
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case REPOSITORY_DRIVES:
        jj_consume_token(REPOSITORY_DRIVES);
        jj_consume_token(EQUALS);
        jj_consume_token(LPAREN);
        driveList();
        jj_consume_token(RPAREN);

        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case REPOSITORY_VOLUME_GROUP_LABEL:
          jj_consume_token(REPOSITORY_VOLUME_GROUP_LABEL);
          jj_consume_token(EQUALS);
          volumeGroupUserLabel = userLabelLiteral();
        m_AttributePairList.add(
           new StringAttributeValuePair(Attribute.VOLUME_GROUP_USER_LABEL, volumeGroupUserLabel));
          break;
        default:
          jj_la1[308] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRAY_LOSS_PROTECT:
          jj_consume_token(TRAY_LOSS_PROTECT);
          jj_consume_token(EQUALS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TRUE:
            jj_consume_token(TRUE);
            break;
          case FALSE:
            jj_consume_token(FALSE);
            break;
          default:
            jj_la1[309] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
         m_AttributePairList.add(new BooleanAttributeValuePair(Attribute.TRAY_LOSS_PROTECT, token.image));
          break;
        default:
          jj_la1[310] = jj_gen;
          ;
        }
        break;
      case REPOSITORY_DRIVE_COUNT:
        jj_consume_token(REPOSITORY_DRIVE_COUNT);
        jj_consume_token(EQUALS);
        driveCount = integerLiteral();
       m_AttributePairList.add(new IntegerAttributeValuePair(
          Attribute.REPOSITORY_DRIVE_COUNT, driveCount));
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case REPOSITORY_VOLUME_GROUP_LABEL:
          jj_consume_token(REPOSITORY_VOLUME_GROUP_LABEL);
          jj_consume_token(EQUALS);
          volumeGroupUserLabel = userLabelLiteral();
        m_AttributePairList.add(
           new StringAttributeValuePair(Attribute.VOLUME_GROUP_USER_LABEL, volumeGroupUserLabel));
          break;
        default:
          jj_la1[311] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DRIVE_TYPE:
          jj_consume_token(DRIVE_TYPE);
          jj_consume_token(EQUALS);
          physicalDriveType = physicalDriveType();
        m_AttributePairList.add(new IntegerAttributeValuePair(Attribute.DRIVE_TYPE, physicalDriveType));
          break;
        default:
          jj_la1[312] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRAY_LOSS_PROTECT:
          jj_consume_token(TRAY_LOSS_PROTECT);
          jj_consume_token(EQUALS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case TRUE:
            jj_consume_token(TRUE);
            break;
          case FALSE:
            jj_consume_token(FALSE);
            break;
          default:
            jj_la1[313] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
         m_AttributePairList.add(new BooleanAttributeValuePair(Attribute.TRAY_LOSS_PROTECT, token.image));
          break;
        default:
          jj_la1[314] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[315] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case REPOSITORY_VOLUME_GROUP:
      jj_consume_token(REPOSITORY_VOLUME_GROUP);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
      case IDENTIFIER:
        volumeGroupName = nameSpec();
        break;
      case INTEGER_LITERAL:
      case 469:
        volumeGroup = integerLiteral();
        break;
      default:
        jj_la1[316] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (volumeGroupName == null)
      {
          volumeGroupName = Integer.toString(volumeGroup);
      }
      m_AttributePairList.add (  new StringAttributeValuePair(Attribute.DRIVE_SPEC_VOLUME_GROUP, volumeGroupName) );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FREE_CAPACITY_AREA:
        jj_consume_token(FREE_CAPACITY_AREA);
        jj_consume_token(EQUALS);
        freeCapacityArea = integerLiteral();
      m_AttributePairList.add(new IntegerAttributeValuePair(Attribute.FREE_CAPACITY_AREA, freeCapacityArea));
        break;
      default:
        jj_la1[317] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[318] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Assembles a list of snapshot volume parameters for the snapshot volume
create statement.
<BR><BR>
*/
  final public void createSnapshotAttributeList() throws ParseException {
   Attribute pair = null;
    label_24:
    while (true) {
      pair = getSnapshotAttributePairs();
      if (pair != null)
      {
         m_AttributePairList.addElement( pair );
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USER_LABEL:
      case REPOSITORY_PERCENT_OF_BASE:
      case REPOSITORY_FULL_POLICY:
      case REPOSITORY_USER_LABEL:
      case WARNING_THRESHOLD_PERCENT:
      case ENFORCESOFTLIMIT:
        ;
        break;
      default:
        jj_la1[319] = jj_gen;
        break label_24;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid snapshot volume attribute list in the grammar. 
When each pair is parsed it is added to the m_AttributePair list.
<BR><BR>
*/
  final public Attribute getSnapshotAttributePairs() throws ParseException {
   int         percentBase;
   int         thresholdPercent;
   String      label;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      label = userLabelLiteral();
      {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, label);}
      break;
    case WARNING_THRESHOLD_PERCENT:
      jj_consume_token(WARNING_THRESHOLD_PERCENT);
      jj_consume_token(EQUALS);
      thresholdPercent = getPercent(WARNING_THRESH_PERCENT_MIN, WARNING_THRESH_PERCENT_MAX);
      {if (true) return new IntegerAttributeValuePair(
          Attribute.WARNING_THRESH_PERCENT, thresholdPercent);}
      break;
    case REPOSITORY_PERCENT_OF_BASE:
      jj_consume_token(REPOSITORY_PERCENT_OF_BASE);
      jj_consume_token(EQUALS);
      percentBase = getPercent(REPOSITORY_PERCENT_BASE_MIN, REPOSITORY_PERCENT_BASE_MAX);
      {if (true) return new IntegerAttributeValuePair(
          Attribute.REPOSITORY_PERCENT_OF_BASE, percentBase);}
      break;
    case REPOSITORY_USER_LABEL:
      jj_consume_token(REPOSITORY_USER_LABEL);
      jj_consume_token(EQUALS);
      label = userLabelLiteral();
      {if (true) return new StringAttributeValuePair(
          Attribute.REPOSITORY_USER_LABEL, label);}
      break;
    case REPOSITORY_FULL_POLICY:
      jj_consume_token(REPOSITORY_FULL_POLICY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FAIL_BASE_WRITES:
        jj_consume_token(FAIL_BASE_WRITES);
        break;
      case FAIL_SNAPSHOT:
        jj_consume_token(FAIL_SNAPSHOT);
        break;
      default:
        jj_la1[320] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new StringAttributeValuePair(
          Attribute.REPOSITORY_FULL_POLICY, token.image);}
      break;
    case ENFORCESOFTLIMIT:
      jj_consume_token(ENFORCESOFTLIMIT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[321] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.ENFORCESOFTLIMIT, token.image);}
      break;
    default:
      jj_la1[322] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid snapshot volume attribute list in the grammar. 
When each pair is parsed it is added to the m_AttributePair list.
<BR><BR>
*/
  final public void recreateSnapshotVolAttributeList() throws ParseException {
   Attribute      pair;
    label_25:
    while (true) {
      pair = recreateSnapshotVolAttributeValuePair();
         m_AttributePairList.addElement( pair);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case USER_LABEL:
      case REPOSITORY_FULL_POLICY:
      case WARNING_THRESHOLD_PERCENT:
      case ENFORCESOFTLIMIT:
        ;
        break;
      default:
        jj_la1[323] = jj_gen;
        break label_25;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid snapshot volume attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute recreateSnapshotVolAttributeValuePair() throws ParseException {
   int         thresholdPercent;
   String      label;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      label = userLabelLiteral();
        {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, label);}
      break;
    case WARNING_THRESHOLD_PERCENT:
      jj_consume_token(WARNING_THRESHOLD_PERCENT);
      jj_consume_token(EQUALS);
      thresholdPercent = getPercent(WARNING_THRESH_PERCENT_MIN, WARNING_THRESH_PERCENT_MAX);
        {if (true) return new IntegerAttributeValuePair(
            Attribute.WARNING_THRESH_PERCENT, thresholdPercent);}
      break;
    case REPOSITORY_FULL_POLICY:
      jj_consume_token(REPOSITORY_FULL_POLICY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FAIL_BASE_WRITES:
        jj_consume_token(FAIL_BASE_WRITES);
        break;
      case FAIL_SNAPSHOT:
        jj_consume_token(FAIL_SNAPSHOT);
        break;
      default:
        jj_la1[324] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new StringAttributeValuePair(
            Attribute.REPOSITORY_FULL_POLICY, token.image);}
      break;
    case ENFORCESOFTLIMIT:
      jj_consume_token(ENFORCESOFTLIMIT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[325] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
       {if (true) return new BooleanAttributeValuePair(Attribute.ENFORCESOFTLIMIT, token.image);}
      break;
    default:
      jj_la1[326] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume copy attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void volumeCopyAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_26:
    while (true) {
      pair = volumeCopyAttributeValuePair();
         m_AttributePairList.addElement( pair);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COPY_PRIORITY:
      case TARGET_READ_ONLY_ENABLED:
        ;
        break;
      default:
        jj_la1[327] = jj_gen;
        break label_26;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume copy attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute volumeCopyAttributeValuePair() throws ParseException {
   int   copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COPY_PRIORITY:
      jj_consume_token(COPY_PRIORITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOWEST:
        jj_consume_token(LOWEST);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_0;
        break;
      case LOW:
        jj_consume_token(LOW);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_1;
        break;
      case MEDIUM:
        jj_consume_token(MEDIUM);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_2;
        break;
      case HIGH:
        jj_consume_token(HIGH);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_3;
        break;
      case HIGHEST:
        jj_consume_token(HIGHEST);
         copyPriority = VolumeCopyPriority.VOLUME_COPY_PRIORITY_4;
        break;
      default:
        jj_la1[328] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         {if (true) return new IntegerAttributeValuePair(Attribute.COPY_PRIORITY, copyPriority);}
      break;
    case TARGET_READ_ONLY_ENABLED:
      jj_consume_token(TARGET_READ_ONLY_ENABLED);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[329] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.TARGET_READ_ONLY, token.image);}
      break;
    default:
      jj_la1[330] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume group attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void volGroupAttributeValueList() throws ParseException {
   Attribute      pair = null;
    pair = volGroupAttributeValuePair();
          m_AttributePairList.addElement( pair );
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume group attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. Currently the
only attribute supported for the set volume group command is the CONTROLLER attribute.
<BR><BR>
*/
  final public Attribute volGroupAttributeValuePair() throws ParseException {
   String      cont = null;
   int         raidLevel;
   String      stringLiteral;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OWNER:
      jj_consume_token(OWNER);
      jj_consume_token(EQUALS);
      cont = controllerSpec();
      {if (true) return new StringAttributeValuePair(Attribute.OWNER, cont);}
      break;
    case AVAILABILITY:
      jj_consume_token(AVAILABILITY);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ONLINE:
        jj_consume_token(ONLINE);
               {if (true) return new BooleanAttributeValuePair(Attribute.AVAILABILITY, "true");}
        break;
      case OFFLINE:
        jj_consume_token(OFFLINE);
               {if (true) return new BooleanAttributeValuePair(Attribute.AVAILABILITY, "false");}
        break;
      default:
        jj_la1[331] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case STATE:
      jj_consume_token(STATE);
      jj_consume_token(EQUALS);
      jj_consume_token(OPTIMAL);
      {if (true) return new StringAttributeValuePair(Attribute.STATE, token.image);}
      break;
    case RAID_LEVEL:
      jj_consume_token(RAID_LEVEL);
      jj_consume_token(EQUALS);
      raidLevel = raidLevel();
      {if (true) return new IntegerAttributeValuePair(Attribute.RAID_LEVEL, raidLevel);}
      break;
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      stringLiteral = userLabelLiteral();
      {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral);}
      break;
    default:
      jj_la1[332] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid autoConfig attribute list in the grammar. 
When each pair is parsed it is added to the m_AttributePair list.
<BR><BR>
*/
  final public void createAutoConfigAttributeList() throws ParseException {
   Attribute      pair;
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CACHE_READ_PREFETCH:
      case READ_AHEAD_MULTIPLIER:
      case SEGMENT_SIZE:
      case RAID_LEVEL:
      case DRIVE_TYPE:
      case VOLUME_GROUP_WIDTH:
      case VOLUME_GROUP_COUNT:
      case UNIFORM_VOLUME_COUNT:
      case HOT_SPARE_COUNT:
      case VOLUMES_PER_GROUP_COUNT:
        ;
        break;
      default:
        jj_la1[333] = jj_gen;
        break label_27;
      }
      pair = createAutoConfigAttributeValuePair();
         m_AttributePairList.addElement( pair);
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid autoConfig attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute createAutoConfigAttributeValuePair() throws ParseException {
   int          driveType = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   int          raidLevel = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   int          volumeGroupWidth = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   int          volumeGroupCount = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   int          uniformVolumeCount = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   int          volumesPerGroupCount = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   int          hotSpareCount = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   int          segmentSize = AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;
   boolean      cacheReadPrefetch = true;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DRIVE_TYPE:
      jj_consume_token(DRIVE_TYPE);
      jj_consume_token(EQUALS);
      driveType = physicalDriveType();
        {if (true) return new IntegerAttributeValuePair(Attribute.DRIVE_TYPE, driveType);}
      break;
    case RAID_LEVEL:
      jj_consume_token(RAID_LEVEL);
      jj_consume_token(EQUALS);
      raidLevel = raidLevel();
        {if (true) return new IntegerAttributeValuePair(Attribute.RAID_LEVEL, raidLevel);}
      break;
    case VOLUME_GROUP_WIDTH:
      jj_consume_token(VOLUME_GROUP_WIDTH);
      jj_consume_token(EQUALS);
      volumeGroupWidth = integerLiteral();
        {if (true) return new IntegerAttributeValuePair(Attribute.VOLUME_GROUP_WIDTH, volumeGroupWidth);}
      break;
    case VOLUME_GROUP_COUNT:
      jj_consume_token(VOLUME_GROUP_COUNT);
      jj_consume_token(EQUALS);
      volumeGroupCount = integerLiteral();
        {if (true) return new IntegerAttributeValuePair(Attribute.VOLUME_GROUP_COUNT, volumeGroupCount);}
      break;
    case UNIFORM_VOLUME_COUNT:
      jj_consume_token(UNIFORM_VOLUME_COUNT);
      jj_consume_token(EQUALS);
      uniformVolumeCount = integerLiteral();
        {if (true) return new IntegerAttributeValuePair(Attribute.UNIFORM_VOLUME_COUNT, uniformVolumeCount);}
      break;
    case VOLUMES_PER_GROUP_COUNT:
      jj_consume_token(VOLUMES_PER_GROUP_COUNT);
      jj_consume_token(EQUALS);
      volumesPerGroupCount = integerLiteral();
        {if (true) return new IntegerAttributeValuePair(Attribute.VOLUMES_PER_GROUP_COUNT, volumesPerGroupCount);}
      break;
    case HOT_SPARE_COUNT:
      jj_consume_token(HOT_SPARE_COUNT);
      jj_consume_token(EQUALS);
      hotSpareCount = integerLiteral();
       {if (true) return new IntegerAttributeValuePair(Attribute.HOT_SPARE_COUNT, hotSpareCount);}
      break;
    case SEGMENT_SIZE:
      jj_consume_token(SEGMENT_SIZE);
      jj_consume_token(EQUALS);
      segmentSize = integerLiteral();
       {if (true) return new IntegerAttributeValuePair(Attribute.SEGMENT_SIZE, segmentSize);}
      break;
    case CACHE_READ_PREFETCH:
      jj_consume_token(CACHE_READ_PREFETCH);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[334] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, token.image);}
      break;
    case READ_AHEAD_MULTIPLIER:
      jj_consume_token(READ_AHEAD_MULTIPLIER);
      jj_consume_token(EQUALS);
      cacheReadPrefetch = integerLiteralToBoolean();
         {if (true) return new BooleanAttributeValuePair(Attribute.CACHE_READ_PREFETCH, cacheReadPrefetch);}
      break;
    default:
      jj_la1[335] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void driveAttributeValueList() throws ParseException {
   Attribute      pair = null;
    label_28:
    while (true) {
      pair = driveAttributeValuePair();
         m_AttributePairList.addElement( pair );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOT_SPARE:
      case OPERATIONAL_STATE:
      case SERVICE_ALLOWED_INDICATOR:
        ;
        break;
      default:
        jj_la1[336] = jj_gen;
        break label_28;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. Currently the
only attribute supported for the set drive command is the HOT_SPARE attribute. This
command assigns or deassigns a drive as a hot spare.
<BR><BR>
*/
  final public Attribute driveAttributeValuePair() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOT_SPARE:
      jj_consume_token(HOT_SPARE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[337] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      {if (true) return new BooleanAttributeValuePair(Attribute.HOT_SPARE, token.image );}
      break;
    case OPERATIONAL_STATE:
      jj_consume_token(OPERATIONAL_STATE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTIMAL:
        jj_consume_token(OPTIMAL);
        break;
      case FAILED:
        jj_consume_token(FAILED);
        break;
      default:
        jj_la1[338] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new StringAttributeValuePair(Attribute.DRIVE_STATE, token.image );}
      break;
    case SERVICE_ALLOWED_INDICATOR:
      jj_consume_token(SERVICE_ALLOWED_INDICATOR);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ON:
        jj_consume_token(ON);
        break;
      case OFF:
        jj_consume_token(OFF);
        break;
      default:
        jj_la1[339] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        {if (true) return new StringAttributeValuePair(Attribute.SERVICE_ALLOWED_INDICATOR, token.image);}
      break;
    default:
      jj_la1[340] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void sArrayAttributeList() throws ParseException {
   Attribute      attribute = null;
    label_29:
    while (true) {
      attribute = sArrayAttribute();
         m_AttributeList.addElement(attribute);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HEALTH_STATUS:
      case PROFILE:
      case BATTERY_AGE:
      case VOLUME_DISTRIBUTION:
      case HOT_SPARE_COVERAGE:
      case HOST_TYPE_TABLE:
      case DEFAULT_HOST_TYPE:
      case PREFERRED_VOLUME_OWNERS:
      case FEATURES:
      case TIME:
      case ISCSI_NEGOTIATION_DEFAULTS:
      case UNCONFIGURED_ISCSI_INITIATORS:
        ;
        break;
      default:
        jj_la1[341] = jj_gen;
        break label_29;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid storage array attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute sArrayAttribute() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PROFILE:
      jj_consume_token(PROFILE);
        {if (true) return new Attribute(Attribute.PROFILE);}
      break;
    case BATTERY_AGE:
      jj_consume_token(BATTERY_AGE);
        {if (true) return new Attribute(Attribute.BATTERY_INSTALL_DATE);}
      break;
    case HEALTH_STATUS:
      jj_consume_token(HEALTH_STATUS);
        {if (true) return new Attribute(Attribute.HEALTH_STATUS);}
      break;
    case HOST_TYPE_TABLE:
      jj_consume_token(HOST_TYPE_TABLE);
        {if (true) return new HostTypeTableAttribute();}
      break;
    case DEFAULT_HOST_TYPE:
      jj_consume_token(DEFAULT_HOST_TYPE);
        {if (true) return new Attribute(Attribute.DEFAULT_HOST_TYPE);}
      break;
    case PREFERRED_VOLUME_OWNERS:
      jj_consume_token(PREFERRED_VOLUME_OWNERS);
        {if (true) return new Attribute(Attribute.PREFERRED_VOLUME_OWNERS);}
      break;
    case VOLUME_DISTRIBUTION:
      jj_consume_token(VOLUME_DISTRIBUTION);
        {if (true) return new Attribute(Attribute.VOLUME_DISTRIBUTION);}
      break;
    case FEATURES:
      jj_consume_token(FEATURES);
        {if (true) return new Attribute(Attribute.FEATURES);}
      break;
    case HOT_SPARE_COVERAGE:
      jj_consume_token(HOT_SPARE_COVERAGE);
         {if (true) return new Attribute(Attribute.HOT_SPARE_COVERAGE);}
      break;
    case TIME:
      jj_consume_token(TIME);
         {if (true) return new Attribute(Attribute.TIME);}
      break;
    case ISCSI_NEGOTIATION_DEFAULTS:
      jj_consume_token(ISCSI_NEGOTIATION_DEFAULTS);
         {if (true) return new Attribute(Attribute.ISCSI_NEGOTIATION_DEFAULTS);}
      break;
    case UNCONFIGURED_ISCSI_INITIATORS:
      jj_consume_token(UNCONFIGURED_ISCSI_INITIATORS);
         {if (true) return new Attribute(Attribute.UNCONFIGURED_ISCSI_INITIATORS);}
      break;
    default:
      jj_la1[342] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid controller attribute list in the grammar.
When each pair is parsed it is added to the m_AttributeList vector.
<BR><BR>
*/
  final public void contAttributeList() throws ParseException {
   Attribute      attribute = null;
    label_30:
    while (true) {
      attribute = contAttribute();
         m_AttributeList.addElement(attribute);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NVSRAM_BYTE:
      case NVSRAM:
      case GLOBAL_NVSRAM_BYTE:
      case HOST_NVSRAM_BYTE:
        ;
        break;
      default:
        jj_la1[343] = jj_gen;
        break label_30;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid controller attribute in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute contAttribute() throws ParseException {
   int       offset = 0;
   int       hostType = 0;
   String hostName = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NVSRAM_BYTE:
      jj_consume_token(NVSRAM_BYTE);
      jj_consume_token(LBRACKET);
      offset = nvsramOffset(Attribute.NVSRAM_BYTE);
      jj_consume_token(RBRACKET);
        {if (true) return new NVSRAMAttribute( offset );}
      break;
    case HOST_NVSRAM_BYTE:
      jj_consume_token(HOST_NVSRAM_BYTE);
      jj_consume_token(LBRACKET);
      hostType = hostTypeIndex();
      jj_consume_token(COMMA);
      offset = nvsramOffset(Attribute.HOST_NVSRAM_BYTE);
      jj_consume_token(RBRACKET);
        {if (true) return new HostNVSRAMAttribute( hostType, offset );}
      break;
    case GLOBAL_NVSRAM_BYTE:
      jj_consume_token(GLOBAL_NVSRAM_BYTE);
      jj_consume_token(LBRACKET);
      offset = nvsramOffset(Attribute.GLOBAL_NVSRAM_BYTE);
      jj_consume_token(RBRACKET);
        {if (true) return new GlobalNVSRAMAttribute( offset );}
      break;
    default:
      jj_la1[344] = jj_gen;
      if (jj_2_115(2)) {
        jj_consume_token(NVSRAM);
        jj_consume_token(HOST);
        jj_consume_token(EQUALS);
        hostName = stringLiteral();
        hostType = m_ExecutorUtils.getHostTypeIndexFromHostName(hostName);
        {if (true) return new HostNVSRAMAttribute(hostType);}
      } else if (jj_2_116(2)) {
        jj_consume_token(NVSRAM);
        jj_consume_token(HOST_TYPE);
        jj_consume_token(EQUALS);
        hostType = hostTypeIndex();
        {if (true) return new HostNVSRAMAttribute(hostType);}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NVSRAM:
          jj_consume_token(NVSRAM);
        {if (true) return new Attribute(Attribute.ALL_NVSRAM_REGIONS);}
          break;
        default:
          jj_la1[345] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute list in the grammar.
When each pair is parsed it is added to the m_AttributeList vector.
<BR><BR>
*/
  final public void volumeAttributeList() throws ParseException {
   Attribute      attribute = null;
    label_31:
    while (true) {
      attribute = volumeAttribute();
         m_AttributeList.addElement(attribute);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AVAILABILITY:
        ;
        break;
      default:
        jj_la1[346] = jj_gen;
        break label_31;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid premium feature attribute in the grammar.
When premium feature is parsed it is added to the m_AttributeList vector.
<BR><BR>
*/
  final public void premiumFeatureAttributeList() throws ParseException {
   Attribute      attribute = null;
    label_32:
    while (true) {
      attribute = premiumFeatureAttribute();
         m_AttributeList.addElement(attribute);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLUME_COPY:
      case SNAPSHOT:
      case REMOTE_MIRROR:
      case MIXED_DRIVE_TYPES:
      case GOLD_KEY:
      case STORAGEPARTITION2:
      case STORAGEPARTITION4:
      case STORAGEPARTITION8:
      case STORAGEPARTITION16:
      case STORAGEPARTITION32:
      case STORAGEPARTITION64:
      case STORAGEPARTITION96:
      case STORAGEPARTITION128:
      case STORAGEPARTITION192:
      case STORAGEPARTITION256:
      case STORAGEPARTITION512:
      case STORAGEPARTITIONMAX:
      case PERFORMANCE_TIER:
      case RAID6:
      case SNAPSHOT2:
      case SNAPSHOT4:
      case SNAPSHOT8:
      case SNAPSHOT16:
      case REMOTE_MIRROR16:
      case REMOTE_MIRROR32:
      case REMOTE_MIRROR64:
      case REMOTE_MIRROR128:
        ;
        break;
      default:
        jj_la1[347] = jj_gen;
        break label_32;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid premium feature in the grammar.
When each premium feature is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute premiumFeatureAttribute() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STORAGEPARTITION2:
      jj_consume_token(STORAGEPARTITION2);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION2);}
      break;
    case STORAGEPARTITION4:
      jj_consume_token(STORAGEPARTITION4);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION4);}
      break;
    case STORAGEPARTITION8:
      jj_consume_token(STORAGEPARTITION8);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION8);}
      break;
    case STORAGEPARTITION16:
      jj_consume_token(STORAGEPARTITION16);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION16);}
      break;
    case STORAGEPARTITION32:
      jj_consume_token(STORAGEPARTITION32);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION32);}
      break;
    case STORAGEPARTITION64:
      jj_consume_token(STORAGEPARTITION64);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION64);}
      break;
    case STORAGEPARTITION96:
      jj_consume_token(STORAGEPARTITION96);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION96);}
      break;
    case STORAGEPARTITION128:
      jj_consume_token(STORAGEPARTITION128);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION128);}
      break;
    case STORAGEPARTITION192:
      jj_consume_token(STORAGEPARTITION192);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION192);}
      break;
    case STORAGEPARTITION256:
      jj_consume_token(STORAGEPARTITION256);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION256);}
      break;
    case STORAGEPARTITION512:
      jj_consume_token(STORAGEPARTITION512);
        {if (true) return new Attribute(Attribute.STORAGEPARTITION512);}
      break;
    case STORAGEPARTITIONMAX:
      jj_consume_token(STORAGEPARTITIONMAX);
        {if (true) return new Attribute(Attribute.STORAGEPARTITIONMAX);}
      break;
    case SNAPSHOT:
      jj_consume_token(SNAPSHOT);
        {if (true) return new Attribute(Attribute.SNAPSHOT);}
      break;
    case SNAPSHOT2:
      jj_consume_token(SNAPSHOT2);
        {if (true) return new Attribute(Attribute.SNAPSHOT2);}
      break;
    case SNAPSHOT4:
      jj_consume_token(SNAPSHOT4);
        {if (true) return new Attribute(Attribute.SNAPSHOT4);}
      break;
    case SNAPSHOT8:
      jj_consume_token(SNAPSHOT8);
        {if (true) return new Attribute(Attribute.SNAPSHOT8);}
      break;
    case SNAPSHOT16:
      jj_consume_token(SNAPSHOT16);
        {if (true) return new Attribute(Attribute.SNAPSHOT16);}
      break;
    case REMOTE_MIRROR:
      jj_consume_token(REMOTE_MIRROR);
        {if (true) return new Attribute(Attribute.REMOTE_MIRROR);}
      break;
    case REMOTE_MIRROR16:
      jj_consume_token(REMOTE_MIRROR16);
        {if (true) return new Attribute(Attribute.REMOTE_MIRROR16);}
      break;
    case REMOTE_MIRROR32:
      jj_consume_token(REMOTE_MIRROR32);
        {if (true) return new Attribute(Attribute.REMOTE_MIRROR32);}
      break;
    case REMOTE_MIRROR64:
      jj_consume_token(REMOTE_MIRROR64);
        {if (true) return new Attribute(Attribute.REMOTE_MIRROR64);}
      break;
    case REMOTE_MIRROR128:
      jj_consume_token(REMOTE_MIRROR128);
        {if (true) return new Attribute(Attribute.REMOTE_MIRROR128);}
      break;
    case VOLUME_COPY:
      jj_consume_token(VOLUME_COPY);
        {if (true) return new Attribute(Attribute.VOLUME_COPY);}
      break;
    case MIXED_DRIVE_TYPES:
      jj_consume_token(MIXED_DRIVE_TYPES);
        {if (true) return new Attribute(Attribute.MIXED_DRIVE_TYPES);}
      break;
    case GOLD_KEY:
      jj_consume_token(GOLD_KEY);
        {if (true) return new Attribute(Attribute.GOLD_KEY);}
      break;
    case PERFORMANCE_TIER:
      jj_consume_token(PERFORMANCE_TIER);
        {if (true) return new Attribute(Attribute.PERFORMANCE_TIER);}
      break;
    case RAID6:
      jj_consume_token(RAID6);
        {if (true) return new Attribute(Attribute.RAID6);}
      break;
    default:
      jj_la1[348] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute volumeAttribute() throws ParseException {
    jj_consume_token(AVAILABILITY);
     {if (true) return new Attribute(Attribute.AVAILABILITY);}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume group attribute list in the grammar.
When each pair is parsed it is added to the m_AttributeList vector.
<BR><BR>
*/
  final public void volGroupAttributeList() throws ParseException {
   Attribute      attribute = null;
    label_33:
    while (true) {
      attribute = volGroupAttribute();
          m_AttributeList.addElement(attribute);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AVAILABILITY:
        ;
        break;
      default:
        jj_la1[349] = jj_gen;
        break label_33;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume group attribute in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute volGroupAttribute() throws ParseException {
    jj_consume_token(AVAILABILITY);
     {if (true) return new Attribute(Attribute.AVAILABILITY);}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive attribute list in the grammar.
When each pair is parsed it is added to the m_AttributeList vector.
<BR><BR>
*/
  final public void driveAttributeList() throws ParseException {
   Attribute      attribute = null;
    label_34:
    while (true) {
      attribute = driveAttribute();
         m_AttributeList.addElement(attribute);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AVAILABILITY:
        ;
        break;
      default:
        jj_la1[350] = jj_gen;
        break label_34;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid drive attribute in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public Attribute driveAttribute() throws ParseException {
    jj_consume_token(AVAILABILITY);
        {if (true) return new Attribute(Attribute.AVAILABILITY);}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Used to define which host type the host-specific NVSRAM setting applies.
<BR><BR>
*/
  final public int hostTypeIndex() throws ParseException {
   Object[]    args = new Object[3];
   String      errorString = null;
   Token       integerLiteral;
   int         typeIndex = 0;
   String      hostType;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case 469:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
        integerLiteral = jj_consume_token(INTEGER_LITERAL);
        break;
      case 469:
        integerLiteral = jj_consume_token(469);
        break;
      default:
        jj_la1[351] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if ( integerLiteral.image.toLowerCase().startsWith(HEX_PREFIX) )
      {
         try
         {
            typeIndex = Integer.parseInt(integerLiteral.image.substring(2), 16);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = HEX_PREFIX + Integer.toHexString(Integer.MIN_VALUE);
           args[2] = HEX_PREFIX + Integer.toHexString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
      }
      else // Doesn't start with "0x" so treat as decimal
      {
         try
         {
            typeIndex = Integer.parseInt(integerLiteral.image);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = Integer.toString(Integer.MIN_VALUE);
           args[2] = Integer.toString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
      }
      {if (true) return typeIndex;}
      break;
    case STRING_LITERAL:
      hostType = stringLiteral();
      typeIndex = m_ExecutorUtils.getHostTypeIndex(hostType);
      {if (true) return typeIndex;}
      break;
    default:
      jj_la1[352] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Used to describe a byte offset in the user config region of NVSRAM.
<BR><BR>
*/
  final public int nvsramOffset(int attributeType) throws ParseException {
   Object[]    args = new Object[3];
   String      errorString = null;
   Token       integerLiteral;
   int         offset = 0;
   int         max_offset = 64;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      integerLiteral = jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      integerLiteral = jj_consume_token(469);
      break;
    default:
      jj_la1[353] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      if ( integerLiteral.image.toLowerCase().startsWith(HEX_PREFIX) )
      {
         try
         {
            offset = Integer.parseInt(integerLiteral.image.substring(2), 16);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = HEX_PREFIX + Integer.toHexString(Integer.MIN_VALUE);
           args[2] = HEX_PREFIX + Integer.toHexString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
      }
      else // Doesn't start with "0x" so treat as decimal
      {
         try
         {
            offset = Integer.parseInt(integerLiteral.image);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = Integer.toString(Integer.MIN_VALUE);
           args[2] = Integer.toString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
      }

      switch (attributeType)
      {
         case Attribute.GLOBAL_NVSRAM_BYTE:
            max_offset = 160;
            break;

         case Attribute.HOST_NVSRAM_BYTE:
         case Attribute.NVSRAM_BYTE:
         default:
            max_offset = 64;
      }

      if ( offset < 0 || offset >= max_offset)
      {
         args[0] = new Integer(getLine());
         args[1] = HEX_PREFIX + Integer.toHexString(max_offset - 1);
         errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_NVSRAM_OFFSET"), args );
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }

      {if (true) return offset;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
This is used to strip off the quotes at the beginning and end of a <STRING_LITERAL> token.
<BR><BR>
*/
  final public String stringLiteral() throws ParseException {
    jj_consume_token(STRING_LITERAL);
     {if (true) return token.image.substring(1,token.image.length() - 1 );}
    throw new Error("Missing return statement in function");
  }

/**
This is used to strip off the quotes at the beginning and end of a <STRING_LITERAL> token,
and to verify the user label length is within the bounds defined in 
SYMbolAPIConstants.UAL_MAX_CHARS. The user label length has to be at least 0.
User label should not contain special characters except dash and underscore.
*/
  final public String userLabelLiteral() throws ParseException {
   Object[]    args = new Object[2];
   String      errorString = null;
   String          string = null;
   String          label = null;
    jj_consume_token(STRING_LITERAL);
      // The token has quotes at the start and end, but the user label is only
      // the part between the quotes.
      // Checks the length without quotes against the maximum user label length from SYMbol.
      label = token.image.substring(1,token.image.length() - 1);

      if ( (token.image.length() - 2) > SYMbolAPIConstants.UAL_MAX_CHARS )
      {
         args[0] = Integer.toString(getLine());
         args[1] = Integer.toString(SYMbolAPIConstants.UAL_MAX_CHARS);
         errorString = MessageFormat.format(
         Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_LENGTH"), args );
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }

      if (label.length() == 0) //0 length string not allowed
      {
         args[0] = Integer.toString(getLine());
         args[1] = Integer.toString(0);
         errorString = MessageFormat.format(
         Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_LENGTH_ZERO"), args);
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }
      string = userDefinedLabel(label);

      {if (true) return string;}
    throw new Error("Missing return statement in function");
  }

/**
This is used to strip off the quotes at the beginning and end of a <STRING_LITERAL> token,
and to verify the user label length is within the bounds defined in 
SYMbolAPIConstants.UAL_MAX_CHARS. However, the label length could be 0. 
It is used to clear name settings.
User label should not contain special characters except dash and underscore.
*/
  final public String userAssignedLabel() throws ParseException {
   Object[]    args = new Object[2];
   String      errorString = null;
   String          string = null;
   String      label = null;
    jj_consume_token(STRING_LITERAL);
      // The token has quotes at the start and end, but the user label is only
      // the part between the quotes.
      // Checks the length without quotes against the maximum user label length from SYMbol.
      label = token.image.substring(1,token.image.length() - 1);
      string = userDefinedLabel(label);

      if ( (token.image.length() - 2) > SYMbolAPIConstants.UAL_MAX_CHARS )
      {
         args[0] = Integer.toString(getLine());
         args[1] = Integer.toString(SYMbolAPIConstants.UAL_MAX_CHARS);
         errorString = MessageFormat.format(
         Resource.getString("SE_PARSE_EXCEPTION_INVALID_USER_LABEL_LENGTH"), args );
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }

      {if (true) return string;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
This is used to get the physical drive type.
<BR><BR>
*/
  final public int physicalDriveType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIBRE:
      jj_consume_token(FIBRE);
      {if (true) return PhysicalDriveType.PHY_DRIVE_TYPE_FIBRE;}
      break;
    case SATA:
      jj_consume_token(SATA);
      {if (true) return PhysicalDriveType.PHY_DRIVE_TYPE_SATA;}
      break;
    case PATA:
      jj_consume_token(PATA);
      {if (true) return PhysicalDriveType.PHY_DRIVE_TYPE_PATA;}
      break;
    case SAS:
      jj_consume_token(SAS);
      {if (true) return PhysicalDriveType.PHY_DRIVE_TYPE_SAS;}
      break;
    default:
      jj_la1[354] = jj_gen;
          {if (true) return AUTO_CONFIG_OPTIONAL_PARAMETER_VALUE;}
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
This is used to get the controller redundancy mode.
<BR><BR>
*/
  final public int controllerRedundancyMode() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SIMPLEX:
      jj_consume_token(SIMPLEX);
      {if (true) return ControllerRedundancyMode.CTLR_REDUNDANCY_MODE_SIMPLEX;}
      break;
    case DUPLEX:
      jj_consume_token(DUPLEX);
      {if (true) return ControllerRedundancyMode.CTLR_REDUNDANCY_MODE_DUPLEX;}
      break;
    default:
      jj_la1[355] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
This is used to validate the Raid level. If not a valid raid level then a parse exception
is thrown.
<BR><BR>
*/
  final public int raidLevel() throws ParseException {
   Object[]          args = new Object[2];
   String            errorString = null;
   int               raidLevel = 0;
   StorageArrayInfo  m_SArrayInfo = m_Facade.getStorageArrayInfo();
   RAIDLevel[]       supportedRaidLevels = m_SArrayInfo.getSupportedRAIDLevels();
   boolean           isSupportedRaidLevel = false;
   StringBuffer      raidLevelStringBuffer = new StringBuffer();
    raidLevel = integerLiteral();
      for (int i=0; i<supportedRaidLevels.length; i++ )
      {
         if (raidLevel == supportedRaidLevels[i].getValue())
         {
            isSupportedRaidLevel = true;
            break;
         }
      }

      if ( isSupportedRaidLevel == false )
      {
         for (int i = 0; i < supportedRaidLevels.length; i++)
         {
            if (i > 0)
            {
               raidLevelStringBuffer.append(", ");
            }

           raidLevelStringBuffer.append(supportedRaidLevels[i].getValue());
      }

      args[0] = new Integer(getLine());
      args[1] = raidLevelStringBuffer.toString();
      errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_RAID_LEVEL"), args );
      m_ParseException = new ParseException(errorString);
      {if (true) throw m_ParseException;}
   }

   {if (true) return raidLevel;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
This is used to validate the cache flush modifier. If not a valid cache flush modifier
then a parse exception is thrown.
<BR><BR>
*/
  final public int cacheFlushValue() throws ParseException {
   Object[]       args = new Object[3];
   String         errorString = null;
   int            returnVal = 0;
   int            intModifierValue = 0;
   double         doubleModifierValue = 0;
   Double         tmpDouble = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMMEDIATE:
      jj_consume_token(IMMEDIATE);
         {if (true) return CacheFlushModifier.CACHE_FLUSH_IMMEDIATE;}
      break;
    case INTEGER_LITERAL:
    case 469:
      intModifierValue = integerLiteral();
         doubleModifierValue = (double)intModifierValue;
         returnVal = getCacheFlushModifierValue( doubleModifierValue );
         if ( returnVal == -1 )
         {
            args[0] = new Integer(getLine());
            errorString = MessageFormat.format(Resource.getString(
                              "SE_PARSE_EXCEPTION_INVALID_CACHE_FLUSH_MODIFIER"), args );
            m_ParseException = new ParseException(errorString);
            {if (true) throw m_ParseException;}
         }
         else
         {
            {if (true) return returnVal;}
         }
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
         tmpDouble = Double.valueOf(token.image);
         doubleModifierValue = tmpDouble.doubleValue();
         returnVal = getCacheFlushModifierValue( doubleModifierValue );
         if ( returnVal == -1 )
         {
            args[0] = new Integer(getLine());
            errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_CACHE_FLUSH_MODIFIER"), args );
            m_ParseException = new ParseException(errorString);
            {if (true) throw m_ParseException;}
         }
         else
         {
            {if (true) return returnVal;}
         }
      break;
    case INFINITE:
      jj_consume_token(INFINITE);
         {if (true) return CacheFlushModifier.CACHE_FLUSH_INFINITE;}
      break;
    default:
      jj_la1[356] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
This is used to validate the port speed value. If not a valid value then a parse exception is thrown.
<BR><BR>
*/
  final public String getPortSpeed() throws ParseException {
   Object[]       args = new Object[1];
   String         errorString = null;
   boolean        invalidValue = false;
   int            intValue = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTO_NEGOTIATE:
      jj_consume_token(AUTO_NEGOTIATE);
         {if (true) return token.image;}
      break;
    case INTEGER_LITERAL:
    case 469:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
        jj_consume_token(INTEGER_LITERAL);
        break;
      case 469:
        jj_consume_token(469);
        break;
      default:
        jj_la1[357] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
         try
         {
            intValue = Integer.parseInt(token.image);
            if (intValue != 10 && intValue != 100 && intValue != 1000)
            {
                        invalidValue = true;
                }
         }
         catch(NumberFormatException nfe)
         {
            invalidValue = true;
         }
         if (invalidValue)
         {
            args[0] = new Integer(getLine());
            errorString = MessageFormat.format(Resource.getString(
                              "SE_PARSE_EXCEPTION_INVALID_PORT_SPEED_VALUE"), args );
            m_ParseException = new ParseException(errorString);
            {if (true) throw m_ParseException;}
         }
         else
         {
            {if (true) return token.image;}
         }
      break;
    default:
      jj_la1[358] = jj_gen;
         args[0] = new Integer(getLine());
         errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_PORT_SPEED_VALUE"), args );
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void hostPortAttributeValueList() throws ParseException {
   Attribute            pair = null;
    label_35:
    while (true) {
      pair = createHostPortAttributeValuePair();
          m_AttributePairList.addElement( pair );
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOST:
      case USER_LABEL:
      case HOST_TYPE:
      case HOST_IDENTIFIER:
      case INTERFACE_TYPE:
        ;
        break;
      default:
        jj_la1[359] = jj_gen;
        break label_35;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned. The appropriate
Attribute object type is created based on the type of the attribute parsed.
<BR><BR>
*/
  final public Attribute createHostPortAttributeValuePair() throws ParseException {
   IntegerAttributeValuePair integerPair = null;
   String                    hostName = null;
   String                    wwn = null;
   String                    hostPortName = null;
   int                       hostTypeIndex = 0;
   String                    stringLiteral = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOST:
      jj_consume_token(HOST);
      jj_consume_token(EQUALS);
      hostName = userLabelLiteral();
       {if (true) return new StringAttributeValuePair(Attribute.HOST_NAME, hostName);}
      break;
    case HOST_TYPE:
      jj_consume_token(HOST_TYPE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        hostTypeIndex = integerLiteral();
        integerPair = new IntegerAttributeValuePair(Attribute.HOST_TYPE);
        integerPair.setValue( hostTypeIndex );
        {if (true) return integerPair;}
        break;
      case STRING_LITERAL:
        stringLiteral = stringLiteral();
        {if (true) return new StringAttributeValuePair(Attribute.HOST_TYPE, stringLiteral);}
        break;
      default:
        jj_la1[360] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case HOST_IDENTIFIER:
      jj_consume_token(HOST_IDENTIFIER);
      jj_consume_token(EQUALS);
      wwn = wwnStringSpec();
       {if (true) return new StringAttributeValuePair(Attribute.IDENTIFIER, wwn);}
      break;
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      hostPortName = userLabelLiteral();
       {if (true) return new StringAttributeValuePair(Attribute.USER_LABEL, hostPortName);}
      break;
    case INTERFACE_TYPE:
      jj_consume_token(INTERFACE_TYPE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FC:
        jj_consume_token(FC);
        break;
      case SAS:
        jj_consume_token(SAS);
        break;
      case IB:
        jj_consume_token(IB);
        break;
      case ISCSI:
        jj_consume_token(ISCSI);
        break;
      case SCSI:
        jj_consume_token(SCSI);
        break;
      default:
        jj_la1[361] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
       {if (true) return new StringAttributeValuePair(Attribute.INTERFACE_TYPE, token.image);}
      break;
    default:
      jj_la1[362] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair list in the grammar.
When each pair is parsed it is added to the m_AttributePairList vector.
<BR><BR>
*/
  final public void hostAttributeValueList() throws ParseException {
    label_36:
    while (true) {
      createHostAttributeValuePair();

      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HOST_GROUP:
      case USER_LABEL:
      case HOST_TYPE:
        ;
        break;
      default:
        jj_la1[363] = jj_gen;
        break label_36;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid volume attribute/value pair in the grammar.
When each pair is parsed an Attribute object is created and returned.
<BR><BR>
*/
  final public void createHostAttributeValuePair() throws ParseException {
   String                     hostName = null;
   String                     hostGroup = null;
   IntegerAttributeValuePair  integerPair = null;
   int                        hostTypeIndex = 0;
   String                     stringLiteral = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USER_LABEL:
      jj_consume_token(USER_LABEL);
      jj_consume_token(EQUALS);
      hostName = userLabelLiteral();
       m_AttributePairList.addElement( new StringAttributeValuePair(Attribute.HOST_NAME, hostName));
      break;
    case HOST_GROUP:
      jj_consume_token(HOST_GROUP);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_GROUP:
        jj_consume_token(DEFAULT_GROUP);
               m_AttributePairList.addElement(
                     new BooleanAttributeValuePair(Attribute.DEFAULT_HOST_GROUP, true) );
        break;
      case NONE:
        jj_consume_token(NONE);
               m_AttributePairList.addElement(
                     new BooleanAttributeValuePair(Attribute.DEFAULT_HOST_GROUP, false) );
        break;
      default:
        jj_la1[364] = jj_gen;
               hostGroup = userLabelLiteral();
               m_AttributePairList.addElement(
                     new BooleanAttributeValuePair(Attribute.DEFAULT_HOST_GROUP, false) );
      }
       m_AttributePairList.addElement(
            new StringAttributeValuePair(Attribute.HOST_GROUP, hostGroup) );
      break;
    case HOST_TYPE:
      jj_consume_token(HOST_TYPE);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        hostTypeIndex = integerLiteral();
               integerPair = new IntegerAttributeValuePair(Attribute.HOST_TYPE);
               integerPair.setValue( hostTypeIndex );
               m_AttributePairList.addElement(integerPair);
        break;
      case STRING_LITERAL:
        stringLiteral = stringLiteral();
               m_AttributePairList.addElement(
                  new StringAttributeValuePair(Attribute.HOST_TYPE, stringLiteral));
        break;
      default:
        jj_la1[365] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[366] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
This is used to validate a byte value. If not a valid byte value then a parse exception
is thrown.
<BR><BR>
*/
  final public byte byteValue() throws ParseException {
   Object[]       args = new Object[3];
   String         errorString = null;
   byte           byteValue = 0;
   int            integerLiteral = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    default:
      jj_la1[367] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      if ( token.image.toLowerCase().startsWith(HEX_PREFIX) )
      {
         try
         {
            integerLiteral = Integer.parseInt(token.image.substring(2), 16);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = HEX_PREFIX + Integer.toHexString(Integer.MIN_VALUE);
           args[2] = HEX_PREFIX + Integer.toHexString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
      }
      else // Doesn't start with "0x" so treat as decimal
      {
         try
         {
            integerLiteral = Integer.parseInt(token.image);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = Integer.toString(Integer.MIN_VALUE);
           args[2] = Integer.toString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }

      }

      if ( integerLiteral >= 0 && integerLiteral <= 255 )
      {
         byteValue = (byte)integerLiteral;
         {if (true) return byteValue;}
      }
      else
      {
         args[0] = new Integer(getLine());
         errorString = MessageFormat.format(Resource.getString("SE_PARSE_EXCEPTION_INVALID_BYTE"),
                           args );
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Used to parse out a valid percentage value from the text.  If the value is not a legal
numeric or not in the legal range for this percentage, an exception is thrown.
<BR><BR>
@param lowValue The legal low value for this percentage.
@param highValue The legal high value for this percentage.
@return The int percentage value.
*/
  final public int getPercent(int lowValue, int highValue) throws ParseException {
    int         percent = 0;
    Object[]    args = new Object[3];
    String      errorString;
    percent = integerLiteral();
      if (percent < lowValue || percent > highValue)
      {
         args[0] = Integer.toString(getLine());
         args[1] = Integer.toString(lowValue);
         args[2] = Integer.toString(highValue);
         errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_PERCENTAGE_VALUE"),
                           args);
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }

      {if (true) return percent;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Parses out the LUN number specification used for creating or deleteing a LUN to host mapping.  
The m_VolumeMapping class variable is set with the value is parsed out.
*/
  final public void LUNSpec() throws ParseException {
   int         lun;
    jj_consume_token(LUN);
    jj_consume_token(EQUALS);
    lun = integerLiteral();
      m_VolumeMapping.setLun (lun);
  }

/**
DESCRIPTION: <BR>
Parses out the host or host group name used for creating or deleteing a LUN to host mapping.  
The m_VolumeMapping class variable is set with the value is parsed out.
*/
  final public void hostOrHostGroupNameSpec() throws ParseException {
   String      host = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HOST:
      jj_consume_token(HOST);
      jj_consume_token(EQUALS);
      host = stringLiteral();
      m_VolumeMapping.setMappingType(VolumeMapping.LUN_HOST);
      m_VolumeMapping.setClientName(host);
      break;
    case HOST_GROUP:
      jj_consume_token(HOST_GROUP);
      jj_consume_token(EQUALS);
      m_VolumeMapping.setMappingType(VolumeMapping.LUN_HOST_GROUP);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
        host = stringLiteral();
      m_VolumeMapping.setClientName(host);
        break;
      case DEFAULT_GROUP:
        jj_consume_token(DEFAULT_GROUP);
      m_VolumeMapping.setDefaultGroupMapping();
      m_VolumeMapping.setClientName(token.image);
        break;
      default:
        jj_la1[368] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[369] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Parses out the add capacity specification.
<BR><BR>

@return CapacityAttributeValuePair   The object that contains the capacity information.
*/
  final public CapacityAttributeValuePair createCapacityPair() throws ParseException {
   Object[]                   args = new Object[3];
   String                     errorString = null;
   int                        integerLiteral = 0;
   Token                      modifierToken = null;
   Double                     capacity = null;
   CapacityAttributeValuePair capacityPair = new CapacityAttributeValuePair(Attribute.CAPACITY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
      break;
    default:
      jj_la1[370] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          if ( token.image.toLowerCase().startsWith(HEX_PREFIX) )
      {
         try
         {
            integerLiteral = Integer.parseInt(token.image.substring(2), 16);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = HEX_PREFIX + Integer.toHexString(Integer.MIN_VALUE);
           args[2] = HEX_PREFIX + Integer.toHexString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
         capacity = new Double(integerLiteral);
      }
      else // Doesn't start with "0x" so treat as decimal
      {
        capacity = new Double(token.image);
      }
      capacityPair.setValue(capacity.doubleValue());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KB:
    case MB:
    case GB:
    case BYTES:
    case TB:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KB:
        modifierToken = jj_consume_token(KB);
        break;
      case MB:
        modifierToken = jj_consume_token(MB);
        break;
      case GB:
        modifierToken = jj_consume_token(GB);
        break;
      case BYTES:
        modifierToken = jj_consume_token(BYTES);
        break;
      case TB:
        modifierToken = jj_consume_token(TB);
        break;
      default:
        jj_la1[371] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[372] = jj_gen;
      ;
    }
      if ( modifierToken == null )
      {
         // Use Bytes as the default if no modifier is specified.
         capacityPair.setCapacityModifier(Resource.getString("SE_CAPACITY_MODIFIER_BYTES"));
      }
      else
      {
         capacityPair.setCapacityModifier(modifierToken.image);
      }
      {if (true) return capacityPair;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Parses out the add capacity specification.
<BR><BR>

@return CapacityAttributeValuePair   The object that contains the capacity information.
*/
  final public CapacityAttributeValuePair capacitySpec() throws ParseException {
   Object[]                   args = new Object[3];
   String                     errorString = null;
   int                        integerLiteral = 0;
   Token                      modifierToken = null;
   Double                     capacity = null;
   CapacityAttributeValuePair capacityPair = createCapacityPair();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DRIVES:
    case ADD_DRIVES:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ADD_DRIVES:
        jj_consume_token(ADD_DRIVES);
        break;
      case DRIVES:
        jj_consume_token(DRIVES);
        break;
      default:
        jj_la1[373] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(EQUALS);
      jj_consume_token(LPAREN);
      driveList();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[374] = jj_gen;
      ;
    }
      capacityPair.setDriveList(m_DriveList);

      {if (true) return capacityPair;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Set host attributes and move the host to a different host group.
command syntax:  set host userLabel=user-label hostGroup=(defaultGroup | user-label)
<BR><BR>
*/
  final public void setHostStatement() throws ParseException, ScriptException {
   String               hostName = null;
    jj_consume_token(SET);
    jj_consume_token(HOST);
    jj_consume_token(LBRACKET);
    hostName = nameSpec();
    jj_consume_token(RBRACKET);
    hostAttributeValueList();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
         m_HostTopologyExecutor.setHost( hostName, m_AttributePairList );
      }
  }

/**
DESCRIPTION: <BR>
Set host attributes and move the host to a different host group.
command syntax:  set host userLabel=user-label hostGroup=(defaultGroup | user-label)
<BR><BR>
*/
  final public void setHostGroupStatement() throws ParseException, ScriptException {
   String               hostGroupName = null;
    jj_consume_token(SET);
    jj_consume_token(HOST_GROUP);
    jj_consume_token(LBRACKET);
    hostGroupName = nameSpec();
    jj_consume_token(RBRACKET);
    hostAttributeValueList();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
           m_HostTopologyExecutor.setHostGroup( hostGroupName, m_AttributePairList );
      }
  }

/**
DESCRIPTION: <BR>
Set host attributes and move the host to a different host group.
command syntax:  set host userLabel=user-label hostGroup=(defaultGroup | user-label)
<BR><BR>
*/
  final public void setHostPortStatement() throws ParseException, ScriptException {
   String               hostPortName = null;
    jj_consume_token(SET);
    jj_consume_token(HOST_PORT);
    jj_consume_token(LBRACKET);
    hostPortName = nameSpec();
    jj_consume_token(RBRACKET);
    hostPortAttributeValueList();
    jj_consume_token(SEMICOLON);
      if ( ! m_SyntaxCheckOnly )
      {
           m_HostTopologyExecutor.setHostPort( hostPortName, m_AttributePairList );
      }
  }

/**
DESCRIPTION: <BR>
Create a volume copy operation.
<BR><BR>
*/
  final public void createVolumeCopyStatement() throws ParseException, ScriptException {
   String      source = null;
   String      target = null;
    jj_consume_token(CREATE);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(SOURCE);
    jj_consume_token(EQUALS);
    source = nameSpec();
    jj_consume_token(TARGET);
    jj_consume_token(EQUALS);
    target = nameSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COPY_PRIORITY:
    case TARGET_READ_ONLY_ENABLED:
      volumeCopyAttributeValueList();
      break;
    default:
      jj_la1[375] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.createVolumeCopy(source, target, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
The recopy command.
<BR><BR>
*/
  final public void recopyStatement() throws ParseException, ScriptException {
    recopyVolumeCopyStatement();
  }

/**
DESCRIPTION: <BR>
Recopy a volume copy operation.
<BR><BR>
*/
  final public void recopyVolumeCopyStatement() throws ParseException, ScriptException {
   String      source = null;
   String      target = null;
    jj_consume_token(RECOPY);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(TARGET);
    jj_consume_token(LBRACKET);
    target = nameSpec();
    jj_consume_token(RBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SOURCE:
      jj_consume_token(SOURCE);
      jj_consume_token(LBRACKET);
      source = nameSpec();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[376] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COPY_PRIORITY:
    case TARGET_READ_ONLY_ENABLED:
      volumeCopyAttributeValueList();
      break;
    default:
      jj_la1[377] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.recopyVolumeCopy(source, target, m_AttributePairList);
      }
  }

/**
DESCRIPTION: <BR>
Show the candiate volumes that can be the source of a volume copy operation.
<BR><BR>
*/
  final public void showVolumeCopyCandidatesSource() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(SOURCE_CANDIDATES);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.getVolumeCopySourceCandidates();
      }
  }

/**
DESCRIPTION: <BR>
Show the candiate volumes that can be the target of a volume copy operation.
<BR><BR>
*/
  final public void showVolumeCopyTargetCandidates() throws ParseException, ScriptException {
   String source = null;
    jj_consume_token(SHOW);
    jj_consume_token(VOLUME_COPY);
    jj_consume_token(SOURCE);
    jj_consume_token(LBRACKET);
    source = nameSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(TARGET_CANDIDATES);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_VolumeExecutor.getVolumeCopyTargetCandidates(source);
      }
  }

/**
DESCRIPTION: <BR>
Automatically assign the hot spare drives in the storage array.
<BR><BR>
*/
  final public void autoConfigureSArrayHotSparesStatement() throws ParseException, ScriptException {
    jj_consume_token(AUTOCONFIGURE);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(HOT_SPARES);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.autoConfigureHotSpares();
      }
  }

/**
DESCRIPTION: <BR>
Automatically configure the storage array.
<BR><BR>
*/
  final public void autoConfigureSArrayStatement() throws ParseException, ScriptException {
    jj_consume_token(AUTOCONFIGURE);
    jj_consume_token(STORAGE_ARRAY);
    createAutoConfigAttributeList();
    jj_consume_token(SEMICOLON);
                if ( !m_SyntaxCheckOnly )
                {
                        m_SArrayExecutor.autoConfigureArray(m_AttributePairList);
                }
  }

/**
DESCRIPTION: <BR>
Displays the default configuration the storage array would generate.
<BR><BR>
NOTES/ASSUMPTIONS:
None.
*/
  final public void showSArrayAutoConfigStatement() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(AUTO_CONFIGURATION);
    createAutoConfigAttributeList();
    jj_consume_token(SEMICOLON);
                if ( !m_SyntaxCheckOnly )
                {
                        m_SArrayExecutor.getAutoConfigPreview(m_AttributePairList);
                }
  }

/**
DESCRIPTION: <BR>
Pasers out a list of integers separated by spaces. Put them in the m_TrayIdList class
variable.
<BR><BR>
*/
  final public void trayIdList() throws ParseException {
   int                controllerId = -1;
   int                trayId;
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case 469:
        trayId = integerLiteral();
         m_TrayIdList.addElement(new Integer(trayId));
        break;
      case CONTROLLER:
        jj_consume_token(CONTROLLER);
         m_TrayIdList.addElement(new Integer(controllerId));
        break;
      default:
        jj_la1[378] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONTROLLER:
      case INTEGER_LITERAL:
      case 469:
        ;
        break;
      default:
        jj_la1[379] = jj_gen;
        break label_37;
      }
    }
  }

/**
DESCRIPTION: <BR>
Parse integer.
<BR><BR>
*/
  final public int integerLiteral() throws ParseException {
   Object[]    args = new Object[3];
   String      errorString = null;
   int         returnInt = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    default:
      jj_la1[380] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      if ( token.image.toLowerCase().startsWith(HEX_PREFIX) )
      {
         try
         {
            returnInt = Integer.parseInt(token.image.substring(2), 16);
         }
         catch(NumberFormatException nfe)
         {
           args[0] = Integer.toString(getLine());
           args[1] = HEX_PREFIX + Integer.toHexString(Integer.MIN_VALUE);
           args[2] = HEX_PREFIX + Integer.toHexString(Integer.MAX_VALUE);
           errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
           m_ParseException = new ParseException(errorString);
           {if (true) throw m_ParseException;}
         }
      }
      else // Doesn't start with "0x" so treat as decimal
      {
         try
         {
            returnInt = Integer.parseInt(token.image);
         }
         catch(NumberFormatException nfe)
         {
            args[0] = Integer.toString(getLine());
            args[1] = Integer.toString(Integer.MIN_VALUE);
            args[2] = Integer.toString(Integer.MAX_VALUE);
            errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
            m_ParseException = new ParseException(errorString);
            {if (true) throw m_ParseException;}
         }
      }
      {if (true) return returnInt;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Parse long.
<BR><BR>
*/
  final public long longLiteral() throws ParseException {
   Object[]    args = new Object[3];
   String      errorString = null;
   long        returnLong = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    default:
      jj_la1[381] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      try
      {
         returnLong = Long.parseLong(token.image);
      }
      catch(NumberFormatException nfe)
      {
         args[0] = Long.toString(getLine());
         args[1] = Long.toString(Long.MIN_VALUE);
         args[2] = Long.toString(Long.MAX_VALUE);
         errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }
      {if (true) return returnLong;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Parse integer and convert it to boolean, <=0 to false, >0 to true
<BR><BR>
*/
  final public boolean integerLiteralToBoolean() throws ParseException {
   Object[]    args = new Object[3];
   String      errorString = null;
   int         returnInt = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case 469:
      jj_consume_token(469);
      break;
    default:
      jj_la1[382] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      try
      {
         returnInt = Integer.parseInt(token.image);
      }
      catch(NumberFormatException nfe)
      {
         args[0] = Integer.toString(getLine());
         args[1] = Integer.toString(Integer.MIN_VALUE);
         args[2] = Integer.toString(Integer.MAX_VALUE);
         errorString = MessageFormat.format(Resource.getString(
                           "SE_PARSE_EXCEPTION_INVALID_INTEGER_NUMBER_FORMAT"),
                           args);
         m_ParseException = new ParseException(errorString);
         {if (true) throw m_ParseException;}
      }
      if (returnInt <= 0)
      {
         {if (true) return false;}
      }
      else
      {
         {if (true) return true;}
      }
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Show the unreadable sectors on the storage array.
<BR><BR>
*/
  final public void showSArrayUnreadableSectors() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(UNREADABLE_SECTORS);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.showUnreadableSectorDatabase();
      }
  }

/**
DESCRIPTION: <BR>
Describes what constitues a list of  drive download packages.
<BR><BR>
*/
  final public void drivePackageAttributeList() throws ParseException {
   Attribute   drivePackage = null;
    label_38:
    while (true) {
      drivePackage = drivePackageSpec();
        m_AttributePairList.addElement(drivePackage);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FILE:
        ;
        break;
      default:
        jj_la1[383] = jj_gen;
        break label_38;
      }
    }
  }

/**
DESCRIPTION: <BR>
Describes what constitutes a valid package specification in the grammer.
<BR><BR>
*/
  final public Attribute drivePackageSpec() throws ParseException {
   String fileName = null;
    jj_consume_token(FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
      {if (true) return new StringAttributeValuePair(Attribute.DRIVE_PACKAGE, fileName);}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Describes a drive download mode. Currently only FailedOnly mode is defined.
<BR><BR>
*/
  final public int driveDownloadMode() throws ParseException {
    jj_consume_token(FAILEDONLY);
       {if (true) return DRIVE_DOWNLOAD_MODE_FAILEDONLY;}
    throw new Error("Missing return statement in function");
  }

/**
DESCRIPTION: <BR>
Show the drive channel statistics on the storage array.
<BR><BR>
*/
  final public void showDriveChannelStatsStatement() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DRIVE_CHANNEL:
    case DRIVE_CHANNELS:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DRIVE_CHANNEL:
        jj_consume_token(DRIVE_CHANNEL);
        break;
      case DRIVE_CHANNELS:
        jj_consume_token(DRIVE_CHANNELS);
        break;
      default:
        jj_la1[384] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(LBRACKET);
      driveChannelList();
      jj_consume_token(RBRACKET);
      break;
    case ALL_DRIVE_CHANNELS:
      jj_consume_token(ALL_DRIVE_CHANNELS);
      break;
    default:
      jj_la1[385] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(STATS);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.showDriveChannelStatistics(m_DriveChannelList);
      }
  }

/**
DESCRIPTION: <BR>
Clear the drive channel statistics on the storage array.
<BR><BR>
*/
  final public void clearDriveChannelStatsStatement() throws ParseException, ScriptException {
    jj_consume_token(CLEAR);
    jj_consume_token(ALL_DRIVE_CHANNELS);
    jj_consume_token(STATS);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.clearDriveChannelStatistics();
      }
  }

/**
DESCRIPTION: <BR>
Set the status of the drive channel on the storage array.
<BR><BR>
*/
  final public void setDriveChannelStatusStatement() throws ParseException, ScriptException {
   int driveChannelId = -1;
   int driveChannelStatus = 0;
    jj_consume_token(SET);
    jj_consume_token(DRIVE_CHANNEL);
    jj_consume_token(LBRACKET);
    driveChannelId = integerLiteral();
    jj_consume_token(RBRACKET);
    jj_consume_token(STATUS);
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OPTIMAL:
      jj_consume_token(OPTIMAL);
         driveChannelStatus = DriveChannelState.DRIVE_CHANNEL_STATE_OPTIMAL;
      break;
    case DEGRADED:
      jj_consume_token(DEGRADED);
         driveChannelStatus = DriveChannelState.DRIVE_CHANNEL_STATE_DEGRADED;
      break;
    default:
      jj_la1[386] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.setDriveChannelStatus(driveChannelId, driveChannelStatus);
      }
  }

/**
DESCRIPTION: <BR>
Set the tray related properties.
<BR><BR>
*/
  final public void setTrayStatement() throws ParseException, ScriptException {
    int    trayId;
    int    component;
    int    alarmControl;
    String sn;
    String componentString;
    int    trayAttributeId;
    String tag;
    jj_consume_token(SET);
    jj_consume_token(TRAY);
    jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      sn = stringLiteral();
      jj_consume_token(RBRACKET);
      jj_consume_token(ID);
      jj_consume_token(EQUALS);
      trayId = integerLiteral();
      jj_consume_token(SEMICOLON);
          if (!m_SyntaxCheckOnly)
          {
             m_TrayExecutor.setTrayId(sn, trayId);
          }
      break;
    case INTEGER_LITERAL:
    case 469:
      trayId = integerLiteral();
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHASSIS_TAG:
      case ASSET_TAG:
      case SERVICE_TAG:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ASSET_TAG:
          jj_consume_token(ASSET_TAG);
                    trayAttributeId = TrayAttributeId.TRAY_ATTR_ASSET_TAG;
          break;
        case CHASSIS_TAG:
          jj_consume_token(CHASSIS_TAG);
                        trayAttributeId = TrayAttributeId.TRAY_ATTR_CHASSIS_NAME;
          break;
        case SERVICE_TAG:
          jj_consume_token(SERVICE_TAG);
                        trayAttributeId = TrayAttributeId.TRAY_ATTR_SERVICE_TAG;
          break;
        default:
          jj_la1[387] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(EQUALS);
        tag = stringLiteral();
        jj_consume_token(SEMICOLON);
                        if (!m_SyntaxCheckOnly)
                        {
                                m_TrayExecutor.setTrayAttributes(trayId, trayAttributeId, tag);
                        }
        break;
      case ALARM:
        jj_consume_token(ALARM);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ENABLE:
          jj_consume_token(ENABLE);
                          alarmControl = AlarmControl.ALARM_CONTROL_ENABLE;
          break;
        case DISABLE:
          jj_consume_token(DISABLE);
                          alarmControl = AlarmControl.ALARM_CONTROL_DISABLE;
          break;
        case MUTE:
          jj_consume_token(MUTE);
                          alarmControl = AlarmControl.ALARM_CONTROL_MUTE;
          break;
        default:
          jj_la1[388] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(SEMICOLON);
            if (!m_SyntaxCheckOnly)
            {
               m_TrayExecutor.setTrayAlarm(trayId, alarmControl);
            }
        break;
      case POWER_FAN:
        jj_consume_token(POWER_FAN);
        jj_consume_token(LBRACKET);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
          jj_consume_token(INTEGER_LITERAL);
          break;
        case 469:
          jj_consume_token(469);
          break;
        default:
          jj_la1[389] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
               componentString = token.image;
        jj_consume_token(RBRACKET);
        jj_consume_token(SERVICE_ALLOWED_INDICATOR);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ON:
          jj_consume_token(ON);
          jj_consume_token(SEMICOLON);
                 if ( !m_SyntaxCheckOnly )
                 {
                    m_TrayExecutor.setComponentRTRIndicator(trayId, TrayExecutor.SUPPORT_CRU, componentString, true);
                 }
          break;
        case OFF:
          jj_consume_token(OFF);
          jj_consume_token(SEMICOLON);
                 if ( !m_SyntaxCheckOnly )
                 {
                    m_TrayExecutor.setComponentRTRIndicator(trayId, TrayExecutor.SUPPORT_CRU, componentString, false);
                 }
          break;
        default:
          jj_la1[390] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case ESM:
        jj_consume_token(ESM);
        jj_consume_token(LBRACKET);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
          jj_consume_token(INTEGER_LITERAL);
          break;
        case 469:
          jj_consume_token(469);
          break;
        default:
          jj_la1[391] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
               componentString = token.image;
        jj_consume_token(RBRACKET);
        jj_consume_token(SERVICE_ALLOWED_INDICATOR);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ON:
          jj_consume_token(ON);
          jj_consume_token(SEMICOLON);
               if ( !m_SyntaxCheckOnly )
               {
                    m_TrayExecutor.setComponentRTRIndicator(trayId, TrayExecutor.ESM, componentString, true);
                   }
          break;
        case OFF:
          jj_consume_token(OFF);
          jj_consume_token(SEMICOLON);
            if ( !m_SyntaxCheckOnly )
                  {
                    m_TrayExecutor.setComponentRTRIndicator(trayId, TrayExecutor.ESM, componentString, false);
                  }
          break;
        default:
          jj_la1[392] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      case INTERCONNECT:
        jj_consume_token(INTERCONNECT);
        jj_consume_token(SERVICE_ALLOWED_INDICATOR);
        jj_consume_token(EQUALS);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ON:
          jj_consume_token(ON);
          jj_consume_token(SEMICOLON);
                  componentString = "";
               if ( !m_SyntaxCheckOnly )
               {
                    m_TrayExecutor.setComponentRTRIndicator(trayId, TrayExecutor.INTERCONNECT_CRU, componentString, true);
                   }
          break;
        case OFF:
          jj_consume_token(OFF);
          jj_consume_token(SEMICOLON);
                  componentString = "";
                  component = m_TrayExecutor.INTERCONNECT_CRU;
               if ( !m_SyntaxCheckOnly )
                  {
                    m_TrayExecutor.setComponentRTRIndicator(trayId, TrayExecutor.INTERCONNECT_CRU, componentString, false);
                  }
          break;
        default:
          jj_la1[393] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[394] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[395] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Save a description of the controller's NVSRAM values to a file.
<BR><BR>
*/
  final public void saveControllerNVSRAMStatement() throws ParseException, ScriptException {
   String fileName = null;
   String controller = null;
    jj_consume_token(SAVE);
    jj_consume_token(CONTROLLER);
    jj_consume_token(LBRACKET);
    controller = controllerSpec();
    jj_consume_token(RBRACKET);
    jj_consume_token(NVSRAM);
    jj_consume_token(FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_ControllerExecutor.saveControllerNVSRAM(controller, fileName);
      }
  }

/**
DESCRIPTION: <BR>
Clear volume persistent reservations.
*/
  final public void clearVolumeStatement() throws ParseException, ScriptException {
   String volume = null;
   Vector nameSpecList = new Vector();
    jj_consume_token(CLEAR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL_VOLUMES:
      jj_consume_token(ALL_VOLUMES);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESERVATIONS:
        jj_consume_token(RESERVATIONS);
        jj_consume_token(SEMICOLON);
                   if ( !m_SyntaxCheckOnly )
                   {
                      m_VolumeExecutor.removeAllVolumeReservations();
                   }
        break;
      case UNREADABLE_SECTORS:
        jj_consume_token(UNREADABLE_SECTORS);
        jj_consume_token(SEMICOLON);
                   if (!m_SyntaxCheckOnly)
                   {
                      m_VolumeExecutor.clearAllVolumesUnreadableSectors();
                   }
        break;
      default:
        jj_la1[396] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case VOLUME:
      jj_consume_token(VOLUME);
      jj_consume_token(LBRACKET);
      volume = nameSpec();
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESERVATIONS:
        jj_consume_token(RESERVATIONS);
        jj_consume_token(SEMICOLON);
                 if ( !m_SyntaxCheckOnly )
                 {
                    m_VolumeExecutor.removeVolumeReservation(volume);
                 }
        break;
      case UNREADABLE_SECTORS:
        jj_consume_token(UNREADABLE_SECTORS);
        jj_consume_token(SEMICOLON);
                     if ( !m_SyntaxCheckOnly )
                     {
                        nameSpecList.addElement(volume);
                        m_VolumeExecutor.clearUnreadableSectorsForVolumes(nameSpecList);
                     }
        break;
      default:
        jj_la1[397] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case VOLUMES:
      jj_consume_token(VOLUMES);
      jj_consume_token(LBRACKET);
      nameSpecList();
      jj_consume_token(RBRACKET);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RESERVATIONS:
        jj_consume_token(RESERVATIONS);
        jj_consume_token(SEMICOLON);
                 if ( !m_SyntaxCheckOnly )
                 {
                    m_VolumeExecutor.removeVolumeReservations(m_NameSpecList);
                 }
        break;
      case UNREADABLE_SECTORS:
        jj_consume_token(UNREADABLE_SECTORS);
        jj_consume_token(SEMICOLON);
                    if ( !m_SyntaxCheckOnly )
                    {
                       m_VolumeExecutor.clearUnreadableSectorsForVolumes(m_NameSpecList);
                    }
        break;
      default:
        jj_la1[398] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[399] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
DESCRIPTION: <BR>
Accepts pending hosts into the topology of the storage array.
*/
  final public void acceptPendingTopologyStatement() throws ParseException, ScriptException {
   String          hostName;
   String []       pendingHosts = null;
    jj_consume_token(ACCEPT);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(PENDING_TOPOLOGY);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL_HOSTS:
      jj_consume_token(ALL_HOSTS);
      break;
    case HOST:
      jj_consume_token(HOST);
      jj_consume_token(LBRACKET);
      hostName = nameSpec();
      jj_consume_token(RBRACKET);
         m_NameSpecList.addElement(hostName);
      break;
    case HOSTS:
      jj_consume_token(HOSTS);
      jj_consume_token(LBRACKET);
      nameSpecList();
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[400] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(SEMICOLON);
      if (!m_SyntaxCheckOnly)
      {
         if (m_NameSpecList.size() > 0)
         {
            pendingHosts = new String[m_NameSpecList.size()];
            m_NameSpecList.copyInto(pendingHosts);
         }
         m_HostTopologyExecutor.setPendingTopology(pendingHosts);
      }
  }

/**
DESCRIPTION: <BR>
Create a volume group based on a list of one or more drives supplied by the user.  A
list of parameters and values can be specified for manual volume group creation.
<BR><BR>
*/
  final public void createManualVolumeGroupStatement() throws ParseException, ScriptException {
   int         integerLiteral;
   String      stringLiteral;
    jj_consume_token(CREATE);
    jj_consume_token(VOLUME_GROUP);
    jj_consume_token(DRIVES);
    jj_consume_token(EQUALS);
    jj_consume_token(LPAREN);
    driveList();
    jj_consume_token(RPAREN);
    jj_consume_token(RAID_LEVEL);
    jj_consume_token(EQUALS);
    integerLiteral = raidLevel();
      m_AttributePairList.addElement(
                         new IntegerAttributeValuePair(Attribute.RAID_LEVEL, integerLiteral));
    jj_consume_token(USER_LABEL);
    jj_consume_token(EQUALS);
    stringLiteral = userLabelLiteral();
      m_AttributePairList.addElement(
                         new StringAttributeValuePair(Attribute.USER_LABEL, stringLiteral));
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRAY_LOSS_PROTECT:
      jj_consume_token(TRAY_LOSS_PROTECT);
      jj_consume_token(EQUALS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[401] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
       m_AttributePairList.addElement(
                         new BooleanAttributeValuePair(Attribute.TRAY_LOSS_PROTECT, token.image));
      break;
    default:
      jj_la1[402] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_VolumeGroupExecutor.createVolumeGroupManual(m_DriveList, m_AttributePairList);
      }
  }

/**
Displays hosts discovered by the HCA that have pending topology and
topology conflicts.
*/
  final public void showSArrayPendingTopologyStatement() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(PENDING_TOPOLOGY);
    jj_consume_token(SEMICOLON);
      if (! m_SyntaxCheckOnly)
      {
         m_HostTopologyExecutor.showPendingTopology();
      }
  }

/**
Save the tray log from the Env cards.
*/
  final public void saveTrayLogStatement() throws ParseException, ScriptException {
    String fileName = null;
    jj_consume_token(SAVE);
    jj_consume_token(ALL_TRAYS);
    jj_consume_token(LOG_FILE);
    jj_consume_token(EQUALS);
    fileName = stringLiteral();
    jj_consume_token(SEMICOLON);
        if (! m_SyntaxCheckOnly)
        {
            m_TrayExecutor.saveAllTraysLogData(fileName);
        }
  }

/**
DESCRIPTION: <BR>
Displays the support data automatic configuration settings of the storage array.
<BR><BR>
NOTES/ASSUMPTIONS:
None.
*/
  final public void showSArrayAutoSupportConfigStatement() throws ParseException, ScriptException {
    jj_consume_token(SHOW);
    jj_consume_token(STORAGE_ARRAY);
    jj_consume_token(AUTO_SUPPORT_CONFIG);
    jj_consume_token(SEMICOLON);
      if ( !m_SyntaxCheckOnly )
      {
         m_SArrayExecutor.showAutoDataCollectionSettings();
      }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_106(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_107(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_108(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_109(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_110(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_111(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_112(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_113(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_114(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_115(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_116(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  final private boolean jj_3_33() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(DOWNLOAD)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_69()) return true;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(DRIVE_CHANNEL)) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_3R_187()) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_3R_67()) return true;
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_3R_138()) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_127() {
    if (jj_scan_token(DIAGNOSE)) return true;
    if (jj_scan_token(CONTROLLER)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_181()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_scan_token(TEST_ID)) return true;
    return false;
  }

  final private boolean jj_3_104() {
    if (jj_3R_137()) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_65()) return true;
    return false;
  }

  final private boolean jj_3_103() {
    if (jj_3R_136()) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_103()) {
    jj_scanpos = xsp;
    if (jj_3_104()) {
    jj_scanpos = xsp;
    if (jj_3_105()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_63()) return true;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_scan_token(TARGET)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_scan_token(SOURCE)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_scan_token(CLEAR)) return true;
    if (jj_scan_token(ALL_DRIVE_CHANNELS)) return true;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(VOLUME_COPY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(AUTO_SUPPORT_CONFIG)) return true;
    return false;
  }

  final private boolean jj_3R_181() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(441)) {
    jj_scanpos = xsp;
    if (jj_scan_token(469)) return true;
    }
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_3R_134()) return true;
    if (jj_3R_135()) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(MAPPING)) return true;
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(SESSION)) return true;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_scan_token(CONFIGURATION)) return true;
    if (jj_scan_token(ALL_DEVICES)) return true;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(CONTROLLER)) return true;
    return false;
  }

  final private boolean jj_3R_173() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) return true;
    }
    return false;
  }

  final private boolean jj_3R_126() {
    if (jj_scan_token(DIAGNOSE)) return true;
    if (jj_scan_token(CONTROLLER)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_181()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_scan_token(LOOPBACK_DRIVE_CHANNEL)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(VOLUME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_scan_token(TRAY)) return true;
    return false;
  }

  final private boolean jj_3_116() {
    if (jj_scan_token(NVSRAM)) return true;
    if (jj_scan_token(HOST_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) return true;
    }
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_scan_token(CONFIGURATION)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_scan_token(SAVE)) return true;
    if (jj_scan_token(ALL_TRAYS)) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_scan_token(ALL_TRAYS)) return true;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_scan_token(CLEAR)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3_115() {
    if (jj_scan_token(NVSRAM)) return true;
    if (jj_scan_token(HOST)) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(DOWNLOAD)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(SNAPSHOT_VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_scan_token(STOP)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(REMOTE_MIRROR)) return true;
    if (jj_scan_token(CANDIDATES)) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3_106() {
    if (jj_scan_token(CONTROLLER)) return true;
    if (jj_scan_token(EQUALS)) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(PENDING_TOPOLOGY)) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_51()) return true;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(HOST_GROUP)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(ISCSI_INITIATOR)) return true;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_scan_token(STOP)) return true;
    if (jj_scan_token(VOLUME_COPY)) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(DOWNLOAD)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  final private boolean jj_3R_190() {
    if (jj_scan_token(REMOVE)) return true;
    if (jj_scan_token(ACCESS_VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_scan_token(CHECK)) return true;
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(HOST)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(HOST_PORT)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(RESET)) return true;
    if (jj_scan_token(CONTROLLER)) return true;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_scan_token(REPLACEABLE_DRIVES)) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(VOLUME_GROUP)) return true;
    if (jj_scan_token(DRIVES)) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(HOST_PORT)) return true;
    return false;
  }

  final private boolean jj_3R_171() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_scan_token(STOP)) return true;
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_3R_131()) return true;
    return false;
  }

  final private boolean jj_3R_207() {
    if (jj_scan_token(UNCONFIGURED_ISCSI_INITIATORS)) return true;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(VOLUME_COPY)) return true;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(RECREATE)) return true;
    if (jj_scan_token(SNAPSHOT)) return true;
    return false;
  }

  final private boolean jj_3R_206() {
    if (jj_scan_token(ISCSI_NEGOTIATION_DEFAULTS)) return true;
    return false;
  }

  final private boolean jj_3R_143() {
    if (jj_scan_token(REMOVE)) return true;
    if (jj_scan_token(ALL_VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(UNREADABLE_SECTORS)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(HOST_GROUP)) return true;
    return false;
  }

  final private boolean jj_3R_205() {
    if (jj_scan_token(TIME)) return true;
    return false;
  }

  final private boolean jj_3R_204() {
    if (jj_scan_token(HOT_SPARE_COVERAGE)) return true;
    return false;
  }

  final private boolean jj_3R_170() {
    if (jj_scan_token(ALL_DRIVES)) return true;
    return false;
  }

  final private boolean jj_3R_203() {
    if (jj_scan_token(FEATURES)) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(HOST_GROUP)) return true;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_170()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_202() {
    if (jj_scan_token(VOLUME_DISTRIBUTION)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(ISCSI_INITIATOR)) return true;
    return false;
  }

  final private boolean jj_3R_201() {
    if (jj_scan_token(PREFERRED_VOLUME_OWNERS)) return true;
    return false;
  }

  final private boolean jj_3R_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_3R_180()) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(HOST)) return true;
    return false;
  }

  final private boolean jj_3R_200() {
    if (jj_scan_token(DEFAULT_HOST_TYPE)) return true;
    return false;
  }

  final private boolean jj_3R_199() {
    if (jj_scan_token(HOST_TYPE_TABLE)) return true;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_scan_token(REMOVE)) return true;
    if (jj_scan_token(VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3R_198() {
    if (jj_scan_token(HEALTH_STATUS)) return true;
    return false;
  }

  final private boolean jj_3R_194() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(HOST)) return true;
    return false;
  }

  final private boolean jj_3R_197() {
    if (jj_scan_token(BATTERY_AGE)) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(PERFORMANCE_MONITOR)) return true;
    return false;
  }

  final private boolean jj_3R_196() {
    if (jj_scan_token(PROFILE)) return true;
    return false;
  }

  final private boolean jj_3R_195() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_140() {
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_scan_token(STOP)) return true;
    if (jj_scan_token(SNAPSHOT)) return true;
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_scan_token(VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(ISCSI_TARGET)) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3_92() {
    if (jj_3R_130()) return true;
    return false;
  }

  final private boolean jj_3R_193() {
    if (jj_3R_195()) return true;
    return false;
  }

  final private boolean jj_3R_141() {
    if (jj_scan_token(REMOVE)) return true;
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_189() {
    if (jj_scan_token(SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_3R_194()) return true;
    }
    return false;
  }

  final private boolean jj_3R_188() {
    Token xsp;
    if (jj_3R_193()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_193()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3_107() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(VOLUME)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_scan_token(ACTION_PROGRESS)) return true;
    return false;
  }

  final private boolean jj_3R_167() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_107()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_3R_129()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_108()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) return true;
    }
    return false;
  }

  final private boolean jj_3_108() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(VOLUMES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_140()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(ISCSI_INITIATOR)) return true;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(ALL_VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(INCREASE_VOL_CAPACITY)) return true;
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_3R_128()) return true;
    return false;
  }

  final private boolean jj_3R_158() {
    if (jj_scan_token(DRIVE)) return true;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_scan_token(CLEAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_157() {
    if (jj_scan_token(DRIVES)) return true;
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_3R_127()) return true;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_3R_126()) return true;
    return false;
  }

  final private boolean jj_3R_184() {
    if (jj_scan_token(HOST_GROUP)) return true;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_scan_token(SAVE)) return true;
    if (jj_scan_token(ALL_DRIVES)) return true;
    return false;
  }

  final private boolean jj_3R_156() {
    if (jj_scan_token(ALL_DRIVES)) return true;
    return false;
  }

  final private boolean jj_3R_146() {
    if (jj_scan_token(ALL_VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3R_183() {
    if (jj_scan_token(HOST)) return true;
    return false;
  }

  final private boolean jj_3R_135() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) return true;
    }
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3R_145() {
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(SET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3R_158()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_scan_token(VOLUME_GROUP)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_3R_125()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(VOLUME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_101()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) return true;
    }
    return false;
  }

  final private boolean jj_3_98() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(DELETE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_98()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_scan_token(CONTROLLER)) return true;
    return false;
  }

  final private boolean jj_3_114() {
    if (jj_3R_144()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_scan_token(LUN)) return true;
    if (jj_scan_token(EQUALS)) return true;
    if (jj_3R_182()) return true;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_3R_124()) return true;
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_scan_token(HOST_CHANNEL)) return true;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_3R_123()) return true;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(TRAY)) return true;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_3R_122()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(SET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    return false;
  }

  final private boolean jj_3R_182() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(441)) {
    jj_scanpos = xsp;
    if (jj_scan_token(469)) return true;
    }
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_3R_121()) return true;
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_scan_token(VOLUME_GROUP)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(RECOVER)) return true;
    if (jj_scan_token(VOLUME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_100()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_scan_token(SAVE)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3_82() {
    if (jj_3R_120()) return true;
    return false;
  }

  final private boolean jj_3_113() {
    if (jj_3R_144()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_scan_token(STOP)) return true;
    if (jj_scan_token(DRIVE)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_3R_119()) return true;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_3R_118()) return true;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_3R_190()) return true;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(AUTO_CONFIGURATION)) return true;
    return false;
  }

  final private boolean jj_3_111() {
    if (jj_3R_143()) return true;
    return false;
  }

  final private boolean jj_3_110() {
    if (jj_3R_142()) return true;
    return false;
  }

  final private boolean jj_3R_119() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_109()) {
    jj_scanpos = xsp;
    if (jj_3_110()) {
    jj_scanpos = xsp;
    if (jj_3_111()) {
    jj_scanpos = xsp;
    if (jj_3R_174()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_109() {
    if (jj_3R_141()) return true;
    return false;
  }

  final private boolean jj_3_112() {
    if (jj_3R_144()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(CONNECTIONS)) return true;
    return false;
  }

  final private boolean jj_3R_187() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(ACCESS_VOLUME)) return true;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(SAVE)) return true;
    if (jj_scan_token(DRIVE_CHANNEL)) return true;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_3R_117()) return true;
    return false;
  }

  final private boolean jj_3R_192() {
    if (jj_scan_token(ENABLE)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_3R_116()) return true;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_3R_115()) return true;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_3R_114()) return true;
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_3R_113()) return true;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_3R_112()) return true;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(HOST_TOPOLOGY)) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(REMOTE_MIRROR)) return true;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(LUN_MAPPINGS)) return true;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_3R_111()) return true;
    return false;
  }

  final private boolean jj_3R_133() {
    if (jj_scan_token(ENABLE)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(FEATURE)) return true;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_3R_110()) return true;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_3R_109()) return true;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_3R_108()) return true;
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_3R_192()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(ALL_TRAYS)) return true;
    return false;
  }

  final private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) return true;
    }
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_3R_133()) return true;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_scan_token(AUTOCONFIGURE)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(HOT_SPARES)) return true;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_3R_107()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_3R_106()) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_3R_161()) return true;
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_3R_105()) return true;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_3R_104()) return true;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_3R_103()) return true;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_3R_102()) return true;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_3R_101()) return true;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_3R_100()) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_3R_164()) return true;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_3R_99()) return true;
    return false;
  }

  final private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(441)) {
    jj_scanpos = xsp;
    if (jj_scan_token(469)) return true;
    }
    return false;
  }

  final private boolean jj_3R_191() {
    if (jj_scan_token(DISABLE)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_scan_token(SUMMARY)) return true;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(ALL_VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(START)) return true;
    if (jj_scan_token(DRIVE)) return true;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(VOLUME_COPY)) return true;
    if (jj_scan_token(SOURCE)) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_scan_token(TARGET_CANDIDATES)) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(VOLUME_COPY)) return true;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_scan_token(ALL_CONTROLLERS)) return true;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_3R_98()) return true;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_3R_97()) return true;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_3R_96()) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_3R_95()) return true;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_3R_94()) return true;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_3R_93()) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_3R_91()) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(TRAY)) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_90()) return true;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_scan_token(DISABLE)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(FEATURE)) return true;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_scan_token(LOCAL_VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_88()) return true;
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(VOLUMES)) return true;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_3R_87()) return true;
    return false;
  }

  final private boolean jj_3R_186() {
    if (jj_3R_164()) return true;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_scan_token(LOCAL_VOLUME)) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_scan_token(CONTROLLER)) return true;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_3R_85()) return true;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(VOLUME_COPY)) return true;
    if (jj_scan_token(SOURCE_CANDIDATES)) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_3R_84()) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_83()) return true;
    return false;
  }

  final private boolean jj_3R_185() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) return true;
    }
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_3R_82()) return true;
    return false;
  }

  final private boolean jj_3R_159() {
    if (jj_3R_188()) return true;
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(REMOTE_MIRROR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) return true;
    }
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3R_139() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) return true;
    }
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_120() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_96()) {
    jj_scanpos = xsp;
    if (jj_3R_175()) return true;
    }
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_scan_token(REMOVE)) return true;
    if (jj_scan_token(VOLUME_COPY)) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_3R_132()) return true;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_3R_191()) return true;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_scan_token(STOP)) return true;
    if (jj_scan_token(DRIVE_CHANNEL)) return true;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_128() {
    if (jj_scan_token(REVIVE)) return true;
    if (jj_scan_token(DRIVE)) return true;
    return false;
  }

  final private boolean jj_3R_149() {
    if (jj_scan_token(VOLUME_GROUP)) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(ALL_HOST_PORTS)) return true;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_scan_token(ACTIVATE)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    if (jj_scan_token(FIRMWARE)) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(STORAGE_ARRAY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_160()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  final private boolean jj_3R_148() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(DRIVE_CHANNEL)) return true;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(VOLUME)) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3_99() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(RECOVER)) return true;
    if (jj_scan_token(VOLUME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_99()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(REMOTE_MIRROR)) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_3R_72()) return true;
    return false;
  }

  public ScriptParserTokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[403];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static private int[] jj_la1_7;
  static private int[] jj_la1_8;
  static private int[] jj_la1_9;
  static private int[] jj_la1_10;
  static private int[] jj_la1_11;
  static private int[] jj_la1_12;
  static private int[] jj_la1_13;
  static private int[] jj_la1_14;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
      jj_la1_5();
      jj_la1_6();
      jj_la1_7();
      jj_la1_8();
      jj_la1_9();
      jj_la1_10();
      jj_la1_11();
      jj_la1_12();
      jj_la1_13();
      jj_la1_14();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0xff7c0440,0xff7c0440,0x8000000,0x40000,0x100000,0x200000,0x400000,0x400,0x4000000,0x80000000,0x8000000,0x10000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x40000000,0x0,0x0,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x1100,0x0,0x1100,0x0,0x30000,0x200,0x100,0x0,0x0,0x30000,0x200,0x30000,0x0,0x100,0x1100,0x0,0x0,0x0,0x0,0x30000,0x0,0x30000,0x30000,0x0,0x60000000,0x0,0x0,0x0,0x200000,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x30000,0x30000,0x30000,0x30000,0x30000,0x0,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x0,0x30000,0x30000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0x30000,0x30000,0x0,0x0,0x0,0x60000000,0x30000,0x30000,0x30000,0x30000,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x30000,0x30000,0x30000,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x30000,0x30000,0x30000,0x30000,0x0,0x30000,0x30000,0x0,0x0,0x0,0x30000,0x30000,0x30000,0x30000,0x0,0x30000,0x30000,0x30000,0x30000,0x30000,0x0,0x30000,0x30000,0x0,0x0,0x0,0x30000,0x30000,0x0,0x0,0x0,0x0,0x0,0x30000,0x30000,0x30000,0x30000,0x0,0x30000,0x0,0x0,0x30000,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x30000,0x0,0x0,0x0,0x0,0x30000,0x0,0x0,0x30000,0x0,0x1000000,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x60000000,0x0,0x1000000,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x7fff,0x7fff,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x2,0x4,0x80,0x8,0x800,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x30000,0x0,0x80000000,0x30000,0x30000,0x0,0x4030000,0x8000000,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x600000,0x30000,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70000,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x600000,0x600000,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x0,0xf0000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x40,0x2000000,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28000,0x28000,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x200000,0x400000,0x0,0x0,0x400000,0x0,0x0,0x600000,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x200000,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28000000,0x28000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x1,0x0,0x400,0x400,0x400000,0x400000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18112,0x18112,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60,0xe0,0x0,0x6800000,0x0,0x0,0x0,0x0,0x0,0x0,0x6aa0000,0x0,0x800,0x800,0x800,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x800030,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800030,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1300,0x10084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0092010,0x0,0x0,0x0,0x0,0x14,0x0,0x0,0x0,0x0,0x40010000,0x40020008,0x0,0x1080,0x0,0x1080,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10084,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0092010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0092010,0x0,0x0,0x0,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x500010,0x500000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x500010,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x500000,0x800030,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800030,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x10,0x10,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0xc000,0x14,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40020008,0x40020008,0x1080,0x80,0x1000,0x4,0x0,0x0,0x4,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x10,0x10,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x1f000000,0x1f000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x49c20000,0x0,0x0,0x0,0x0,0x0,0x0,0xc20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x49c20000,0x0,0x0,0x0,0x0,0x100000,0x100000,0x30004018,0x0,0x0,0x2,0x0,0x0,0x100000,0x0,0x30004018,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4082001,0x0,0x0,0x0,0x0,0x8020000,0x20,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30004018,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4082001,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x4082001,0x80000,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e79000,0x2e79000,0x0,0x0,0x0,0x0,0x0,0x18000,0x0,0x0,0x30004018,0x0,0x0,0x0,0x0,0x0,0x0,0x3e79000,0x0,0x0,0x0,0x0,0x0,0x18000,0x0,0x0,0x30004018,0x0,0x0,0x0,0x0,0x2e79000,0x49c20000,0xc20000,0x80000000,0xc00,0x0,0x0,0x0,0x0,0x49c20000,0x0,0xc20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30004018,0x0,0x0,0x0,0x8020000,0x9c00000,0x0,0x9c00000,0x20,0x0,0x0,0x0,0x20,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_5() {
      jj_la1_5 = new int[] {0x600000,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800,0x32400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x20,0x0,0x18,0x0,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x80000,0x400000,0x80000,0x22000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300,0x0,0x0,0x0,0x0,0x0,0x1800,0x0,0x300,0x0,0x0,0x0,0x0,0x0,0x1800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22004,0x22004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0x0,0x0,0x0,0x0,0x0,0x22004,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0x0,0x0,0x0,0x22004,0x0,0x0,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x300,0x0,0x0,0x1800,0x32400,0xc000,0x0,0x32400,0x22000,0xc000,0x0,0x22000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x18,0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0x0,0xc0000000,0x40000000,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,};
   }
   private static void jj_la1_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00,0x100,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x80000,0x1,0x0,0x2200,0x2200,0x0,0x0,0x0,0x0,0x1400,0x0,0x2200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200002,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x40002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x40c00000,0x400000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc00,0x0,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000000,0x18000000,0x8000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x18000000,0x200002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200002,0x0,0x0,0x0,0x30104,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2201,0x2200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400,0x0,0x0,0x0,0x0,0x2201,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1400,0x0,0x0,0x2200,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x80000,0x80000,0x0,0x0,0x80000,0x81000000,0x0,0x0,0x81000000,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x60,0x0,0x10,0x40002,0x40002,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81000000,0x400000,0x81000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,};
   }
   private static void jj_la1_7() {
      jj_la1_7 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x80000800,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x4000,0x34000,0x0,0x4000,0x0,0x4000,0x0,0xc000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70,0x0,0x70,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x900,0x900,0x0,0x0,0x0,0x0,0x7ff80000,0x7ff80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_8() {
      jj_la1_8 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1c00,0x26000,0x26000,0x0,0x18000,0xc0000,0x0,0x0,0x0,0x26000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x200,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x0,0x200,0x200,0x0,0x200,0x0,0x1c00,0x0,0x0,0x0,0x0,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x600000,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x80000000,0x80000000,0x600000,0x4,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x70000000,0x70000000,0x0,0x0,0x0,0x0,0x70000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_9() {
      jj_la1_9 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6002000,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x0,0x200,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x2000000,0x0,0x4000000,0x0,0x2000,0x0,0x0,0x0,0x2000000,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x2,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x6002000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6002000,0x0,0x0,0x0,0x0,0x2000000,0x0,0x2000,0x0,0x2000000,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3e000,0x0,0x3e000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x780000,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x20000000,0x0,0x10,0x10,0x10,0x0,0x0,0x0,0x2000000,};
   }
   private static void jj_la1_10() {
      jj_la1_10 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e,0x0,0x0,0x7e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80040100,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x340000,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x8000000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7e,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x190000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x8000,0x1000,0x0,0x0,0x4000,0x1000,0x60000000,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x600,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x0,0x0,};
   }
   private static void jj_la1_11() {
      jj_la1_11 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8820,0x0,0x0,0x0,0x0,0xc0,0x0,0x0,0x0,0x0,0x0,0x0,0x11,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x108,0x0,0x0,0x108,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8820,0xfffffc00,0x0,0x0,0x0,0x0,0x0,0x0,0xc0,0x80,0xfffffc00,0x0,0x0,0x0,0x0,0x0,0x820,0x0,0x0,0x0,0x8820,0xc37400,0x400,0x1000,0xc0,0x0,0x80,0x0,0x0,0xc37400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_12() {
      jj_la1_12 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xd00,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x0,0x100000,0x0,0x0,0x0,0x0,0x60000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x31,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x31,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc000,0x7400000,0x7400000,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x8000000,0x0,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000,0x60000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_13() {
      jj_la1_13 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x0,0x2000000,0x0,0x82000000,0x82000000,0x0,0x82000000,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x30000,0x0,0x8010,0x0,0x0,0x0,0x82000000,0x0,0x40,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x4,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x80000000,0x80000000,0x2000000,0x2000000,0x2000000,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f80,0x7f80,0x0,0x0,0x2000000,0x82000000,0x2000000,0x0,0x0,0x12000000,0x2000000,0x2000000,0x800000,0x82000000,0x780000,0x800000,0x0,0x0,0x82000000,0x0,0x2000000,0x80000000,0x0,0x12000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x2000000,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x2000000,0x0,0x0,0x0,0x82000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_14() {
      jj_la1_14 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200008,0x40400,0x0,0x20400,0x0,0x0,0x0,0x200008,0x0,0x0,0x200000,0x0,0x200008,0x200008,0x0,0x200008,0x200008,0x0,0x40400,0x40400,0x0,0x20400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40400,0x0,0x200008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200008,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40400,0x40400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40400,0x0,0x200008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x200008,0x0,0x0,0x0,0x0,0x0,0x200008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x8,0x8,0x200000,0x200000,0x200000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x0,0x200000,0x200000,0x200000,0x0,0x200000,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x200000,0x200000,0x200000,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x200000,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[116];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public ScriptParser(CharStream stream) {
    token_source = new ScriptParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 403; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 403; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ScriptParser(ScriptParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 403; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ScriptParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 403; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[470];
    for (int i = 0; i < 470; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 403; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
          if ((jj_la1_7[i] & (1<<j)) != 0) {
            la1tokens[224+j] = true;
          }
          if ((jj_la1_8[i] & (1<<j)) != 0) {
            la1tokens[256+j] = true;
          }
          if ((jj_la1_9[i] & (1<<j)) != 0) {
            la1tokens[288+j] = true;
          }
          if ((jj_la1_10[i] & (1<<j)) != 0) {
            la1tokens[320+j] = true;
          }
          if ((jj_la1_11[i] & (1<<j)) != 0) {
            la1tokens[352+j] = true;
          }
          if ((jj_la1_12[i] & (1<<j)) != 0) {
            la1tokens[384+j] = true;
          }
          if ((jj_la1_13[i] & (1<<j)) != 0) {
            la1tokens[416+j] = true;
          }
          if ((jj_la1_14[i] & (1<<j)) != 0) {
            la1tokens[448+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 470; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 116; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
