<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="vdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:variable name="isCluster">
				<xsl:choose>
					<xsl:when test="substring(/OMA/VirtualDisks/@AttributesMask,32,1)!='0'">1</xsl:when>
				  <xsl:otherwise>0</xsl:otherwise>
			 </xsl:choose>
		</xsl:variable>	
			
		<script language="javascript">
      function reloadPage()
      {
          document.location.href = top.gnv.appendVID(document.URL);
      }

      function getThisURL()
      {
      var cluster = <xsl:value-of select="$isCluster"/>;
			var confirmresponse = 0;
			
			if(cluster == 1)
			{ 									
					var msg = "<xsl:value-of select="$strClusterCreate"/>";
					confirmresponse = confirm(msg);
			}
			
			if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
      {
      var url = GetLocalUrl();
          document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.LaunchCreateVDWizardSubmitWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;OrigURL=" + url);
					document.dataarea.submit();
			}
		}
		
		
		</script>
	
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerWebPlugin" onLoad="true">
			<xsl:call-template name="scripts"/>
			<script language="javascript">
				function initializationRoutine()
				{
					<!-- DF27306 - Selecting vdisk does not display constituent array disks in aparticular scenario
						This defect was reported in 1.4. A fix for DFCT116290 actually broke the page. At this time, 
						the OMSA team is unable to root cause this issue. Reverting to original behavior since 
						original issue is cosmetic in nature. (GKV)
						Original defect: 
							DFCT116290 - OMSS1.0 Pointer to Storage Tree on Left not changing correponding to Page -->
					<!-- Commenting out
					var compid = "VD"+"<xsl:value-of select="/OMA/ControllerOID"/>";
					parent.ct._select(compid);
					-->
				}
			</script>
			<PageTitle>
				<xsl:choose>					
					<xsl:when test="VirtualDisks/@ControllerName=''">				
						<xsl:choose>
							<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
								<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
							</xsl:when>
						</xsl:choose>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="VirtualDisks/@ControllerName!=''">
						<xsl:choose>
							<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
								<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
							</xsl:when>
						</xsl:choose>						
						<xsl:attribute name="display"><xsl:value-of select="$strTitle2Part1"/><xsl:value-of select="VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitle2Part2"/></xsl:attribute>
					</xsl:when>
				</xsl:choose>
			</PageTitle>
			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin</xsl:attribute>
				</Data>
			</CustomButton>
			
			<!-- Check if the bit for CreateVD is true -->
			<xsl:variable name="isCreateVDOkay">
				<xsl:call-template name="IsCreateVDSupported">
					<xsl:with-param name="Mask">
						<xsl:value-of select="VirtualDisks/@CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>			
			

			<xsl:if test="$isCreateVDOkay='1'">
				<!--check to see if user had admin rights-->
					<CustomButton align="left">
						<Data formSubmit="true">
							<xsl:attribute name="display"><xsl:value-of select="$strCreateVDW"/></xsl:attribute>
							<xsl:attribute name="href">javascript:getThisURL()</xsl:attribute>
						</Data>
					</CustomButton>				
			</xsl:if>
			
			<xsl:call-template name="VirtualDiskTable">
				<xsl:with-param name="tasks">
					<xsl:value-of select="$checkAdmin"/>
				</xsl:with-param>
			</xsl:call-template>
		</DataArea>
	</xsl:template>
	<xsl:template name="VirtualDiskTable">
		<xsl:param name="tasks"/>
		<xsl:choose>
			<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
				<!--CR49916 - auto refresh code-->
				<xsl:if test="VirtualDisks/DCStorageObject/Progress">
	                         <HTMLData>
	                                  <script language="Javascript">
	                                  	<!--refresh page every 30secs when there is atleast one object with Progress associated with it -->
	                                          setTimeout("reloadPage()",30000) ;
	                                  </script>
	                         </HTMLData>
	                    </xsl:if>
				<TableData columnspacing="true">
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
					</SubHeader>
					<xsl:choose>
						<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
							<PromptText ignoreoncli="true">
								<xsl:value-of select="$strPrompt"/>
							</PromptText>
						</xsl:when>
						<xsl:otherwise>
							<PromptText ignoreoncli="true">
								<xsl:value-of select="$strPrompt2"/>
							</PromptText>
						</xsl:otherwise>
					</xsl:choose>
					<Header>
						<xsl:call-template name="VirtualDiskTableHeader">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$tasks"/>
							</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="VirtualDisks/DCStorageObject">
						<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
						<xsl:call-template name="VirtualDiskTableRows">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$tasks"/>
							</xsl:with-param>
							<xsl:with-param name="caller">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!ControllerName=<xsl:value-of select="/OMA/ControllerName"/>!help=vdprin</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strPrompt2"/></xsl:attribute>
				</SubHeader>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
