<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <!-- TEMP TABLE HEADER -->
    <xsl:template name="TempTableHeader">
        <xsl:param name="tasks">false</xsl:param>
        <xsl:param name="checkbox">false</xsl:param>
        <xsl:choose>
            <xsl:when test="/OMA/@cli = 'true'">
                <Header>
                    <Data>
                        <xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
                    </Data>
                    <Data name="Status" editable="false" type="ustring" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
                    </Data>
                    <Data name="Name" editable="false" type="ustring" align="left">
                        <xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
                    </Data>
                    <Data align="left">
                        <xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
                    </Data>
			<!--Data align="center"> MJR Removed for DFCT 100497
                        <xsl:attribute name="display"><xsl:value-of select="$strEnclID"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strEnclID"/></xsl:attribute>
                    </Data-->
                    <Data name="Reading" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strReading"/></xsl:attribute>
                    </Data>
                    <Data name="min" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMinWarnThresh"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMinWarnThresh"/></xsl:attribute>
                    </Data>
                    <Data name="max" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMaxWarnThresh"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMaxWarnThresh"/></xsl:attribute>
                    </Data>
                    <Data name="min" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMinFailureThresh"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMinFailureThresh"/></xsl:attribute>
                    </Data>
                    <Data name="max" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMaxFailureThresh"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMaxFailureThresh"/></xsl:attribute>
                    </Data>
                </Header>
            </xsl:when>
            <xsl:otherwise>
                <Header>
                    <Data name="" display="" value=""/>
                    <Data name="" display="" value=""/>
                    <Data name="" display="" value=""/>
                    <Data name="" display="" value=""/>
                    <!--Data name="" display="" value=""/--><!-- MJR Removed for DFCT 100497 -->
                    <Data name="WarningThreshold" colspan="3" italic="true" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strWarnThresh"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strWarnThresh"/></xsl:attribute>
                    </Data>
                    <Data name="FailureThreshold" colspan="3" italic="true" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strFailureThresh"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strFailureThresh"/></xsl:attribute>
                    </Data>
                </Header>
                <Header>
                    <xsl:choose>
                        <xsl:when test="$checkbox = 'true'">
                            <!-- Blank header for the checkbox-->
                            <Data name="Checkbox" editable="false" type="ustring" width="25" display="blank" value="" align="center"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <Data name="Status" editable="false" type="ustring" align="center">
                                <xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
                                <xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
                            </Data>
                        </xsl:otherwise>
                    </xsl:choose>
                    <Data name="Name" editable="false" type="ustring" align="left">
                        <xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
                    </Data>
                    <Data align="left"> 
                        <xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
                    </Data>
                    <!--Data align="center"> MJR Removed for DFCT 100497
                        <xsl:attribute name="display"><xsl:value-of select="$strEnclID"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strEnclID"/></xsl:attribute>
                    </Data-->
                    <Data name="Reading" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strReading"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strReading"/></xsl:attribute>
                    </Data>
                    <Data name="min" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMinimum"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMinimum"/></xsl:attribute>
                        <xsl:attribute name="append"><xsl:value-of select="$strWarnThresh"/></xsl:attribute>
                    </Data>
                    <Data name="max" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMaximum"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMaximum"/></xsl:attribute>
                        <xsl:attribute name="append"><xsl:value-of select="$strWarnThresh"/></xsl:attribute>
                    </Data>
                    <Data name="min" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMinimum"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMinimum"/></xsl:attribute>
                        <xsl:attribute name="append"><xsl:value-of select="$strFailureThresh"/></xsl:attribute>
                    </Data>
                    <Data name="max" align="center">
                        <xsl:attribute name="display"><xsl:value-of select="$strMaximum"/></xsl:attribute>
                        <xsl:attribute name="value"><xsl:value-of select="$strMaximum"/></xsl:attribute>
                        <xsl:attribute name="append"><xsl:value-of select="$strFailureThresh"/></xsl:attribute>
                    </Data>
                </Header>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- TEMP TABLE ROWS -->
    <xsl:template name="TempTableRows">
        <xsl:param name="tasks">false</xsl:param>
        <xsl:param name="checkbox">false</xsl:param>
        <xsl:param name="methodmask">00000000000000000000000000000000</xsl:param>
        <Row>
            <Data ignoreonweb="true">
                <xsl:attribute name="value"><xsl:value-of select="Index"/></xsl:attribute>
            </Data>
            <xsl:choose>
                <xsl:when test="$checkbox = 'true'">
					<xsl:choose>
						<xsl:when test="substring($methodmask,25,1)!='0'">
							<!-- If bit 25 is set, enclosure can not set temps for individual probes -->							
							<xsl:choose>
								<xsl:when test="substring(CurrentMethodMask,29,1)!='0'">
									<!-- This temperature probe is editable -->
									<xsl:choose>
										<xsl:when test="CurrentMethodMask">										
											<Data editable="true" type="checkbox" align="left" state="3">
												<xsl:attribute name="name">temp<xsl:value-of select="Index"/></xsl:attribute>
												<xsl:attribute name="value"/>
											</Data>
										</xsl:when>
										<xsl:otherwise>										
											<Data editable="true" type="checkbox" align="left" state="2">
												<xsl:attribute name="name">temp<xsl:value-of select="Index"/></xsl:attribute>
												<xsl:attribute name="value"/>
											</Data>
										</xsl:otherwise>
									</xsl:choose>									
								</xsl:when>
								<xsl:otherwise>
									<!-- This temperature probe is not editable -->									
									<Data editable="true" type="checkbox" align="left" state="2">
									<xsl:attribute name="name">temp<xsl:value-of select="Index"/></xsl:attribute>
									<xsl:attribute name="value"/>
									</Data>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<!-- If bit 25 is not set, enclosure can set temps for individual probes -->
							<Data editable="true" type="checkbox" align="left">
							<xsl:attribute name="name">temp<xsl:value-of select="Index"/></xsl:attribute>
							<xsl:attribute name="value"/>
							</Data>
						</xsl:otherwise>
					</xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <Data type="status" align="center">
                        <xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
                    </Data>
                </xsl:otherwise>
            </xsl:choose>
            <Data name="Test" editable="false" type="ustring" display="Test" align="left">
                <xsl:attribute name="value"><xsl:value-of select="$strTemperature"/><xsl:value-of select="Index"/></xsl:attribute>
            </Data>
            <Data align="left"> 
                <xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
            </Data>
            <!--Data align="center"> MJR Removed for DFCT 100497
                <xsl:attribute name="value"><xsl:value-of select="EnclosureID"/></xsl:attribute>
            </Data-->
			<xsl:choose>
				<xsl:when test="CurrentTemp">
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="CurrentTemp"/><xsl:value-of select="$strDegreesC"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="MinWarning">
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="MinWarning"/><xsl:value-of select="$strDegreesC"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="MaxWarning">
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="MaxWarning"/><xsl:value-of select="$strDegreesC"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="MinError">
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="MinError"/><xsl:value-of select="$strDegreesC"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="MaxError">
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="MaxError"/><xsl:value-of select="$strDegreesC"/></xsl:attribute>
					</Data>
				</xsl:when>
				<xsl:otherwise>
					<Data align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
					</Data>
				</xsl:otherwise>
			</xsl:choose>
        </Row>
        <script language="javascript">
			function onExecute(oid) {
				var encltasks = "encltasks" + oid;
				var action = document.getElementById(encltasks).value;		
				if (action == "-") { 
					alert("Error! Please select a valid task");
				}
				else {
					alert("Error! AD Function '"+action+"' not yet implemented");
				}
			}
		</script>
    </xsl:template>
</xsl:stylesheet>
