<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Information page.  The associated web plugin is the EnclosureInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:include href="temptbl.xsl"/>
	<xsl:include href="Utils.xsl"/>
	<xsl:template match="OMA">
		<script language="javascript">
      function getThisURL()
      {
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetTempProbeWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="/OMA/Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>" + "&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;Action=tempinfo&amp;help=entktmp");
			}
		</script>
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin">
			<PageTitle>
				<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="Name"/>
				<xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.TempInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;help=tpprin</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:if test="$checkAdmin='true'">
					<!--check to see if user had admin rights-->
			<CustomButton align="left">
				<Data formSubmit="true">
					<xsl:attribute name="display"><xsl:value-of select="$strSetTemp"/></xsl:attribute>
					<xsl:attribute name="href">javascript:getThisURL()</xsl:attribute>
				</Data>
			</CustomButton>
			</xsl:if>
			<xsl:call-template name="TempTable"/>
		</DataArea>
	</xsl:template>

	<xsl:template name="TempTable">
		<!-- DISPLAY THE TEMPERATURE INFORMATION IN A TABLE FORMAT-->
		<TableData columnspacing="true">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/></xsl:attribute>
			</SubHeader>
			<xsl:choose>
				<xsl:when test="count(TemperatureProbes/DCStorageObject)>0">
					<xsl:call-template name="TempTableHeader"/>
					<xsl:for-each select="TemperatureProbes/DCStorageObject">
						<xsl:sort select="Index" data-type="number" order="ascending"/>
						<xsl:call-template name="TempTableRows"/>
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>
		</TableData>
	</xsl:template>
</xsl:stylesheet>
