<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render replace member disk for copyback page. The associated web plugin is  ReplaceMemberSelectWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <!--The code below includes Utils.xsl and adtbl.xsl which contains commonly called templates which can be resused -->
  <xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>

  <xsl:param name="sourceDisk" select="/OMA/SourceDiskOID"/>
	<xsl:param name="destinationDisk" select="/OMA/DestinationDiskOID"/>

	<!-- ################################################### -->
	<!-- Main template -->
	<xsl:template match="OMA">
		<DataArea validate="true" onLoad="true" exportdata="false">
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin</xsl:attribute>
			<xsl:choose>
				<xsl:when test="//CopybackAvailDisks/ArrayDisks">
					<xsl:attribute name="submit">/servlet/DataArea?plugin=com.dell.sm.webplugins.ReplaceMemberSummaryWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="/OMA/VDiskName"/>&amp;help=adtkcb</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<!-- Load the javascripts used by this xsl.  I've put them into their own tempate to make the code more readable -->
			<xsl:call-template name="LocalScripts"/>
			<!-- ##### New error handling ##### -->
			<HiddenTable>
				<Data name="BackToLink" returnvalue=""/>
			</HiddenTable>
			<xsl:call-template name="errorhandling"/>
			<!-- ##### End new error handling ##### -->
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/><xsl:value-of select="VDiskName"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ReplaceMemberSelectWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="/OMA/VDiskName"/><!--&amp;SourceDiskOID=<xsl:value-of select="/OMA/SourceDiskOID"/>&amp;DestinationDiskOID=<xsl:value-of select="/OMA/DestinationDiskOID"/-->&amp;help=adtkcb</xsl:attribute>
				</Data>
			</CustomButton>

      <xsl:message>sourceDisk = <xsl:value-of select="$sourceDisk"/></xsl:message>
      <xsl:message>destinationDisk = <xsl:value-of select="$destinationDisk"/></xsl:message>
      <xsl:choose>
           <xsl:when test="//CopybackAvailDisks/ArrayDisks">
			<xsl:choose>
				<xsl:when test="//CopybackVDisks/ArrayDisks">
					<PromptText>
						<xsl:value-of select="$strExplTextSource"/>
					</PromptText>
                              <PromptText>
						<xsl:value-of select="$strExplTextDestination"/>
					</PromptText> 
				</xsl:when>
				<xsl:otherwise>
                            <PromptText>
	 		           <xsl:value-of select="$strExplTextNoDisks"/>
        	                </PromptText>
				</xsl:otherwise>
			</xsl:choose>
			

			<xsl:choose>
				<xsl:when test="//ArrayDisks">
					<xsl:call-template name="DiskTable"/>
					<HiddenTable>
						<xsl:for-each select="//CopybackVDisks/ArrayDisks/DCStorageObject">
							<Data>
								<xsl:attribute name="name">
								<xsl:choose>
									<xsl:when test="EnclosureID">SOBJID<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>SOBJID<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus"><xsl:value-of select="Nexus"/></xsl:with-param></xsl:call-template></xsl:attribute>
							</Data>
						</xsl:for-each>
					</HiddenTable>
					<HiddenTable>
						<xsl:for-each select="//CopybackAvailDisks/ArrayDisks/DCStorageObject">
							<xsl:variable name="isDHS">
								<!-- check to see if current disk is DHS -->
								<xsl:call-template name="IsDedicatedHotSpare">
									<xsl:with-param name="AttributesMask">
										<xsl:value-of select="AttributesMask"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="isGHS">
								<!-- check to see if current disk is GHS -->
								<xsl:call-template name="IsGlobalHotSpare">
									<xsl:with-param name="AttributesMask">
										<xsl:value-of select="AttributesMask"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="$isDHS = '1' or $isGHS = '1'">
								<Data>
									<xsl:attribute name="name">
										<xsl:choose>
											<xsl:when test="EnclosureID">HSIDRes<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
											<xsl:otherwise>HSIDRes<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
										</xsl:choose>
									</xsl:attribute>
									<xsl:attribute name="returnvalue">1</xsl:attribute>
								</Data>
							</xsl:if>
							<Data>
								<xsl:attribute name="name">
								<xsl:choose>
									<xsl:when test="EnclosureID">DOBJID<xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:when>
									<xsl:otherwise>DOBJID<xsl:value-of select="Channel"/>0<xsl:value-of select="TargetID"/></xsl:otherwise>
								</xsl:choose>
								</xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus"><xsl:value-of select="Nexus"/></xsl:with-param></xsl:call-template></xsl:attribute>
							</Data>
						</xsl:for-each>
					</HiddenTable>
					<HiddenTable>
						<Data>
							<xsl:attribute name="name">SourceDiskOID</xsl:attribute>
							<xsl:attribute name="returnvalue"/>
						</Data>
						<Data>
							<xsl:attribute name="name">DestinationDiskOID</xsl:attribute>
							<xsl:attribute name="returnvalue"/>
						</Data>
					</HiddenTable>
				</xsl:when>
			</xsl:choose>
	     </xsl:when>
           <xsl:otherwise>
         
              <PromptText>
	 		<xsl:value-of select="$strExplTextNoDisks"/>
        	  </PromptText>
           </xsl:otherwise>
       </xsl:choose>
	  </DataArea>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the two tables where the user selects their disks -->
	<xsl:template name="DiskTable">
		<!-- Create two tables side-by-side.  The first table (selection table) is used to display the disks that are 
         part of the virtual disk. The second table (result table) will display any available
         disks capable of being used as a replace member.  -->
		<SelectionData multitable="true" image="both">
			<SelectionTable>
				<!-- The header for the selection table will be the channel radio buttons -->
				<Header>
					<xsl:value-of select="$strAvailablePhysicalDisks"/>
					
				</Header>
        
        <!-- Loop through the Virtual disks -->
        <xsl:for-each select="//CopybackVDisks/ArrayDisks">
					<xsl:choose>
								<xsl:when test="DCStorageObject/EnclosureID">					
									<!-- SAS: use channel and enclosure id -->
									<xsl:call-template name="RenderAvailArrayDisksRow">
										<!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of select="@ProductID"/></xsl:with-param></xsl:call-template>(<xsl:value-of select="@ChannelName"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
										<!-- Not SAS: use channel and 0 -->
										<xsl:call-template name="RenderAvailArrayDisksRow">
										<!-- To render each channel's disks, we need to pass in some parameters
				                              These are used to give each row, etc a correct title to be used by the
				                              javascript when querying for the elements.  The KEY is used to sort
				                              the disks by channel for the radio buttons -->
										<xsl:with-param name="PARENT_NAME">Sel<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>
										<xsl:with-param name="CHILD_NAME_PREFIX">Sel</xsl:with-param>
										<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of select="@ProductID"/></xsl:with-param></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>					
				</xsl:for-each>
			</SelectionTable>
			<ResultTable>
				<Header>
					<Data name="ResHeader">
						<xsl:attribute name="value"><xsl:value-of select="$strResHeader"/></xsl:attribute>
					</Data>
				</Header>
        
        <!-- Loop through the Available disks -->
        <xsl:for-each select="//CopybackAvailDisks/ArrayDisks">				
					<xsl:choose>
						<xsl:when test="DCStorageObject/EnclosureID">	
							<xsl:call-template name="RenderResultsDisksRow">
								<!-- SAS: use channel and enclosure id  -->
								<!-- To render each channel's disks, we need to pass in some parameters
		                              These are used to give each row, etc a correct title to be used by the
		                              javascript when querying for the elements.  The KEY is used to sort
		                              the disks by channel for the radio buttons -->
								<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/><xsl:value-of select="DCStorageObject/EnclosureID"/></xsl:with-param>
								<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>
								<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of select="@ProductID"/></xsl:with-param></xsl:call-template>(<xsl:value-of select="@ChannelName"/>)</xsl:otherwise></xsl:choose></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!-- non-SAS: use channel and 0 -->
							<xsl:call-template name="RenderResultsDisksRow">
								<!-- To render each channel's disks, we need to pass in some parameters
		                              These are used to give each row, etc a correct title to be used by the
		                              javascript when querying for the elements.  The KEY is used to sort
		                              the disks by channel for the radio buttons -->
								<xsl:with-param name="PARENT_NAME">Res<xsl:value-of select="DCStorageObject/Channel"/>0</xsl:with-param>
								<xsl:with-param name="CHILD_NAME_PREFIX">Res</xsl:with-param>
								<xsl:with-param name="DISPLAY_NAME"><xsl:choose><xsl:when test="not(@EnclosureType) or (@EnclosureType = '')"><xsl:value-of select="$strDirectAttached"/></xsl:when><xsl:otherwise><xsl:call-template name="GetEnclosureType"><xsl:with-param name="type"><xsl:value-of select="@EnclosureType"/></xsl:with-param><xsl:with-param name="productid"><xsl:value-of select="@ProductID"/></xsl:with-param></xsl:call-template></xsl:otherwise></xsl:choose></xsl:with-param>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</ResultTable>
		</SelectionData>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the channel radio buttons on the top of the table  -->
	
	<!-- ################################################### -->
	<!-- This dispays the each enclosure with the +/- expansion -->
	<xsl:template name="RenderAvailArrayDisksRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<!-- The Row is the enclosure -->
		<Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<Data value="{$DISPLAY_NAME}"/>
			</ColumnData>
			<!-- The children rows are the individual disks -->
			<ChildrenRows>
				<!-- For each disk that matches the channel we're trying to display -->
				<xsl:for-each select="DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderArrayDiskSelectionRow">
						<xsl:with-param name="ArrayDiskSpace">
							<xsl:value-of select="Length"/>
						</xsl:with-param>
						<xsl:with-param name="PrefixName">
							<xsl:value-of select="$CHILD_NAME_PREFIX"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each disk under the enclosure row -->
	<xsl:template name="RenderArrayDiskSelectionRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<Row>
			<xsl:variable name="enclNum">
				<xsl:choose>
					<xsl:when test="EnclosureID"><xsl:value-of select="EnclosureID"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:value-of select="TargetID"/></xsl:attribute>
			<SelectDataItem>
				<Data type="checkbox" width="150" columnspacing="true">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:text/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!-- Different name depending on SAS or SATA -->
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="EnclosureID">
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:attribute>

					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$enclNum"/>','<xsl:value-of select="TargetID"/>','Sel')</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data columnspacing="true">
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data>
			</ColumnData>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each enclosure with the +/- expansion          -->
	<xsl:template name="RenderResultsDisksRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<!-- The Row is the enclosure -->
		<Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<Data value="{$DISPLAY_NAME}"/>
			</ColumnData>
			<!-- The children rows are the individual disks -->
			<ChildrenRows>
				<!-- For each disk that matches the channel we're trying to display -->
				<xsl:for-each select="DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>
					<xsl:call-template name="RenderResultsArrayDiskSelectionRow">
						<xsl:with-param name="ArrayDiskSpace">
							<xsl:value-of select="Length"/>
						</xsl:with-param>
						<xsl:with-param name="PrefixName">
							<xsl:value-of select="$CHILD_NAME_PREFIX"/>
						</xsl:with-param>
						<xsl:with-param name="isDHS">
							<!-- check to see if current disk is DHS -->
							<xsl:call-template name="IsDedicatedHotSpare">
								<xsl:with-param name="AttributesMask">
									<xsl:value-of select="AttributesMask"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:with-param>
						<xsl:with-param name="isGHS">
							<!-- check to see if current disk is GHS -->
							<xsl:call-template name="IsGlobalHotSpare">
								<xsl:with-param name="AttributesMask">
									<xsl:value-of select="AttributesMask"/>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<!-- This dispays the each disk under the enclosure row -->
	<xsl:template name="RenderResultsArrayDiskSelectionRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<xsl:param name="isDHS"/>
		<xsl:param name="isGHS"/>

		<Row>
			<xsl:variable name="enclNum">
				<xsl:choose>
					<xsl:when test="EnclosureID"><xsl:value-of select="EnclosureID"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:value-of select="TargetID"/></xsl:attribute>
			<SelectDataItem>
				<Data type="checkbox" width="150" state="0" columnspacing="true">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$enclNum"/><xsl:text/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!-- Different name if sas/sata -->
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="EnclosureID">
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/>
							</xsl:otherwise>
						</xsl:choose>				
					</xsl:attribute>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$enclNum"/>','<xsl:value-of select="TargetID"/>','Res')</xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data columnspacing="true">
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00 GB')"/><xsl:text> (</xsl:text><xsl:choose><xsl:when test="$isDHS='1'">DHS</xsl:when><xsl:when test="$isGHS='1'">GHS</xsl:when><xsl:otherwise>Free</xsl:otherwise></xsl:choose><xsl:text>)</xsl:text></xsl:attribute>
				</Data>
			</ColumnData>
		</Row>
	</xsl:template>
	<!-- ################################################### -->
	<xsl:template name="LocalScripts">
		<script language="javascript">
			<!-- ######################################################### -->
			
			var JS_GLOBAL_MaxNumChannels=4;
			var JS_GLOBAL_MaxNumEnclosures=3;
			var JS_GLOBAL_MaxNumTargets=24;
			
			<!-- Set DataArea onLoad='true' to call this function.  This will call all of
                  the routines that are required to display the two disk tables correctly -->                
	     function initializationRoutine()
			{		
				SetBackToButtonLink();
				<!--this function is called when the Selection table page is first loaded-->
				
				initializeSelectionTable();
							
				initializeResultTable(); 
				
				<!--get the first channel that has enclosure attached to it-->
				var channelNum = getDefaultChannelSelectionRadioButtonIndex();
				<!--show selection table with array disks attached to default channel identified 
				if(channelNum!=-1) {
					showSelectionTable(channelNum);
				}
				-->

				<!--Below set the default channel selection radio button-->
				setDefaultChannelSelectionRadioButton();

				<!--Below disable the Channel radio buttons that do not contain ArrayDisks-->
				disableChannelSelectionRadioButtonsWithNoArrayDisks();
			}
		
			<!-- ######################################################### -->
			<!-- ######################################################### -->
			<!--This function hides all the rows in the selection table-->
			function hideSelectionTable()
			{
				var elemName=""
				for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
					
						if(document.getElementById("parentrow_Sel"+i.toString()+e.toString())!=null)
						{
							document.getElementById("parentrow_Sel"+i.toString()+e.toString()).style.display="none";
						}
						else
						{
							continue;
						}
					
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{
							elemName = "parentrow_Sel"+i.toString()+ e.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none"
							}
						}
					}
				}
			}

            <!-- ######################################################### -->
			<!--This funtion displays all the rows associated with channel 'i'-->
			function showSelectionTable(i)
			{
				var numTargets=24;
				var dhs;
				for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
				{					
					for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
					{
						elemName="parentrow_Sel"+i.toString()+ e.toString()+j.toString();
						if(document.getElementById(elemName))
						{
						    dhs = document.getElementById("DHSSTATE" + i.toString()+ e.toString() + j.toString());
						    if (dhs != null) 
						    {
		        				    	document.getElementById("parentrow_Sel"+i.toString()+ e.toString()).style.display="";
				        		    	document.getElementById("parentrow_Sel"+i.toString()+ e.toString() + j.toString()).style.display="";
	   		         }
						}
					}
				}
			}

            	<!-- ######################################################### -->
			<!--This function hides all the rows in the selection table-->
			function hideResultTable()
			{
				var elemName=""
				for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
				{					
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{					
						if(document.getElementById("parentrow_Res"+i.toString()+e.toString())!=null)
						{
							document.getElementById("parentrow_Res"+i.toString()+e.toString()).style.display="none";
						}
						
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{
							elemName = "parentrow_Res"+i.toString()+e.toString()+j.toString();
							if(document.getElementById(elemName) != null)
							{
								document.getElementById(elemName).style.display="none"
							}
						}
					}
				}
			}
       
			<!-- ######################################################### -->	
			<!--This function returns the index of the default channel selected from the array of channels-->
			function getDefaultChannelSelectionRadioButtonIndex()
			{
				var RadioArray = document.getElementsByName("ChannelButton");
				for(var i=0;i&lt;RadioArray.length;i++)
				{			
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							return i;
						}
					}
				}
				return -1;<!--failure-->
			}

			<!-- ######################################################### -->
			<!--This function selects and sets the default channel-->
			function setDefaultChannelSelectionRadioButton()
			{
				var found=false;
				var RadioArray = document.getElementsByName("ChannelButton");
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					if(found == false)
					{
						for(var e=0;e&lt;RadioArray.length;e++)
						{							
							var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
							if(document.getElementById(elemName) != null)
							{							
								RadioArray[i].checked=true;
								found=true;
								break;
							}
						}
					}
				}
			}

	          <!-- ######################################################### -->
      <!--This function initializes the selection table-->
      function initializeSelectionTable()
      {
      var OIDSource;
      var sourceFound = false;
      for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{

							OIDSource = document.getElementById("SOBJID" + i.toString()+ e.toString() + j.toString());						
							if(OIDSource != null)
							{
								if(OIDSource.value == '<xsl:value-of select="$sourceDisk"/>') 
								{
			        			  		document.getElementById("Sel"+i.toString()+ e.toString() + j.toString()).checked = true;
									sourceFound = true;
								}
						      	else 
								{
									document.getElementById("Sel"+i.toString()+ e.toString()+j.toString()).checked = false;
								}
							}
						}
					}
				}

				if (sourceFound == true)
				{
					disableUnselectedCheckBoxes('Sel');
				}
			}

	          <!-- ######################################################### -->
      <!--This function initializes the result table-->
      function initializeResultTable()
      {
      var OIDDestination;
      var DestinationFound = false;
      for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++) 
				{
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++) 
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{

							OIDDestination = document.getElementById("DOBJID" + i.toString()+ e.toString() + j.toString());						
							if(OIDDestination != null)
							{
								if(OIDDestination.value == '<xsl:value-of select="$destinationDisk"/>') 
								{
			        			  		document.getElementById("Res"+i.toString()+ e.toString() + j.toString()).checked = true;
									DestinationFound = true;
								}
						      	else 
								{
									document.getElementById("Res"+i.toString()+ e.toString()+j.toString()).checked = false;
								}
							}
						}
					}
				}

				if (DestinationFound == true)
				{
					disableUnselectedCheckBoxes('Res');
				}
			}

     			<!-- ######################################################### -->
			<!--This function disables the channel radio buttons that do not have any array disks attached-->
			function disableChannelSelectionRadioButtonsWithNoArrayDisks()
			{
				var RadioArray = document.getElementsByName("ChannelButton");
				
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					var ArrayDisks = 0;
					for(var e=0;e&lt;JS_GLOBAL_MaxNumEnclosures;e++)
					{
						var elemName="parentrow_"+"Sel"+i.toString()+e.toString();
						if(document.getElementById(elemName) != null)
						{
							ArrayDisks = 1;
						}
					}
					if (ArrayDisks == 0)
					{
						RadioArray[i].disabled=true;
					}
				}
			}

			<!-- ######################################################### -->
			<!--This function is a handler that is called in response to a channel selection-->
			function OnChannelSelected()
			{
				hideSelectionTable();
				var RadioArray = document.getElementsByName("ChannelButton");
				for(var i=0;i&lt;RadioArray.length;i++)
				{
					if(RadioArray [i].checked)
					{
						showSelectionTable(i);
						break;
					}
				}
			}
			
			<!-- ######################################################### -->
                  <!-- This function is called when an array disk is selected/unselected -->
			function OnArrayDiskSelected(channel,encl,target, prefix)
			{
				if (isArrayDiskSelected(channel,encl,target,prefix))
                        {
					disableUnselectedCheckBoxes(prefix);
                        }
				else
				{
					enableAllCheckBoxes(prefix);
				}
			}

			<!-- This function returns true if the given array disk selection check box is checked, else false -->
			function isArrayDiskSelected(channel, enclosureId, targetId, prefix)
			{
				var elemName=prefix+channel+enclosureId+targetId;
				if(document.getElementById(elemName) != null)
				{
					return document.getElementById(elemName).checked;
				}
				return false;
			}

			<!-- This function enables all array disk selection check boxes -->
			function enableAllCheckBoxes(prefix)
			{
				for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
				{
					for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{
							enableArrayDiskCheckBox(i.toString(), k.toString(), j.toString(), prefix);
						}
					}
				}
			}

			<!--This function enables a single array disk selection check box-->
			function enableArrayDiskCheckBox(channel, enclosureId, targetId, prefix)
			{
				var elemName=prefix+channel+enclosureId+targetId;
				if(document.getElementById(elemName) != null)
				{
					document.getElementById(elemName).disabled=false;
				}
			}

			<!--This function disable all checkboxes that are not checked-->
			function disableUnselectedCheckBoxes(prefix)
			{
				for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
				{
					for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{
							if( isArrayDiskSelected(i.toString(), k.toString(), j.toString(), prefix) == false )
							{
								disableArrayDiskCheckBox(i.toString(), k.toString(), j.toString(), prefix);
							}
						}
					}
				}
			}

			<!--This function disables a single array disk selection check box-->
			function disableArrayDiskCheckBox(channel, enclosureId, targetId, prefix)
			{
				var elemName=prefix+channel+enclosureId+targetId;
				if(document.getElementById(elemName) != null)
				{
					document.getElementById(elemName).disabled=true;
				}
			}
			
			<!-- ######################################################### -->
      <!-- Validation routine - To ensure selection of single source and destination disks -->
			function validate() 
			{
				var sourceCount = 0;
				var destinationCount = 0;
				var hsd = "";
				var sDiskOID = "";
				var dDiskOID = "";
				var OIDSource = "";
				var OIDDestination = "";

				for(var i=0;i&lt;JS_GLOBAL_MaxNumChannels;i++)
				{
					for(var k=0;k&lt;JS_GLOBAL_MaxNumEnclosures;k++)
					{
						for(var j=0;j&lt;JS_GLOBAL_MaxNumTargets;j++)
						{
							if(isArrayDiskSelected(i.toString(), k.toString(), j.toString(), "Sel") == true)
							{
								sourceCount = sourceCount + 1 ;
								OIDSource = document.getElementById("SOBJID" + i.toString()+ k.toString() + j.toString());						
								if(OIDSource != null) 
								{
									sDiskOID = OIDSource.value;
								}
							}

							if(isArrayDiskSelected(i.toString(), k.toString(), j.toString(), "Res") == true)
							{
								destinationCount = destinationCount + 1 ;
								OIDDestination = document.getElementById("DOBJID" + i.toString()+ k.toString() + j.toString());						
								if(OIDDestination != null) 
								{
									dDiskOID = OIDDestination.value;
								}

							    	hsd = document.getElementById("HSIDRes" + i.toString() + k.toString() + j.toString());
							    	if (hsd != null) 
							    	{
							    		hsd = hsd.value;
								}
							}
						}
					}
				}

				if (sourceCount != 1 || destinationCount != 1)
				{
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strNoSelect"/>");
					return false;
				}	

				if (hsd != '' &amp;&amp; hsd != null)
				{

					var Confirm = confirm("<xsl:value-of select="$strConfirm"/>");
					if (Confirm == false ) 
					{	
						return false;
					}
				}
				
				document.getElementById("SourceDiskOID").value = sDiskOID;
				document.getElementById("DestinationDiskOID").value = dDiskOID;

				disableButtons("submit","back" ,"");

				return true;
			}			
			<!-- ######################################################### -->
		</script>
	</xsl:template>
</xsl:stylesheet>
