<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be reused/-->
	<xsl:include href="Utils.xsl"/>
	<xsl:include href="cvdutils.xsl"/>

	
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="/OMA/SSDAResponse/DCStorageObject">
				<!-- Check that DA didn't return an empty set -->
				<xsl:call-template name="RenderMainFrame"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="RenderErrorFrame"/>
			</xsl:otherwise>			
		</xsl:choose>

	</xsl:template>


	<xsl:template name="RenderErrorFrame">
		<!--Error page -->
		<DataArea validate="false" Refresh="false">
		
			<PageTitle alert="true" status="4">
				<xsl:attribute name="display"><xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/> <xsl:value-of select="$strReconfigureErr"/> </xsl:attribute>
			</PageTitle>
			<PromptText>
					<xsl:value-of select="$strNoReconfig"/>
			</PromptText>
			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason1"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason2"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason3"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strReason4"/></xsl:attribute>
				</Data>
			</ListData>
			
			<BottomCustomButton>
					<Data>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VDiskName=<xsl:value-of select="//VDiskName"/>&amp;VDeviceName=<xsl:value-of select="DeviceName"/>&amp;help=vdtkrcn1
						</xsl:attribute>
						<xsl:attribute name="display"><xsl:value-of select="$strBack"/></xsl:attribute>
				</Data>
			</BottomCustomButton>

			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	
	
	<xsl:template name="RenderMainFrame">
		<!-- Page 2 of Reconfig -->
			<DataArea onLoad="true" validate="true" exportdata="false" printable="false" email="false">
			<xsl:attribute name="submit">javascript:submitReconfigureVD()</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strContinue"/></xsl:attribute>
			<xsl:variable name="GLOBAL_PARAM_Oslimit"><xsl:value-of select="/OMA/Controllers/DCStorageObject/MaxOsLimitForLogicalDriveSize"/></xsl:variable>
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:call-template name="getScriptsForExpress"/>
			</script>
			<script language="javascript">
				function initializationRoutine()
				{
					setValueForMinField("");
					setValueForMaxField("");
					document.getElementById("RaidDescTextArea").value="<xsl:value-of select="$strTextBoxHelpDefaultMsgCVDU"/>";
				}
				function submitReconfigureVD()
				{
					var layout=getInputRaidLayoutValue();										
					var size=ConvertInputSizeToBytesForExpress();
					var IDList = "<xsl:value-of select="/OMA/IDList"/>";
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDSummaryWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;Layout="+layout+"&amp;Length="+size+"&amp;IDList="+IDList+"&amp;help=vdtkrcn3");
				}
				function OnRaidLayoutSelected()
				{
					var layoutValue = getInputRaidLayoutValue();
					
					UpdateRaidDescriptionTextBox(layoutValue);
					
					<!--get min and max values in GB-->
					var minValue = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxValue = getMaxSizeForGivenLayout(layoutValue,"GB");
					<!--Set user input VD size field to max value-->
					setInputVDSizeValue(maxValue);
					if ( getMinSizeForGivenLayout(layoutValue,"BYTES") == getMaxSizeForGivenLayout(layoutValue,"BYTES"))
					{
						setValueForMinField(maxValue);
						setValueForMaxField(maxValue);
						disableInputVDSizeField();
					}
					else
					{
						setValueForMinField(minValue);
						setValueForMaxField(maxValue);
						enableInputVDSizeField();
					}
				}
				function ConvertInputSizeToBytes()
				{
					var layoutValue=getInputRaidLayoutValue();
					var maxSizeInBytes = getMaxSizeForGivenLayout(layoutValue,"BYTES");
					var maxSize = getMaxSizeForGivenLayout(layoutValue,"GB");
					var sizeValue = getInputVDSizeValue();
					if( (maxSize-sizeValue) &lt;= 0.01)
					{
						sizeValue=maxSizeInBytes;
					}
					else
					{
						sizeValue=parseInt(sizeValue*1024*1024*1024);
					}
					return sizeValue;
				}

				function validate()
				{
					if(IsRaidLayoutSelected()==false)
					{
						HandleRaidLayoutNotSelectedError();
						return false;
					}
					if(IsInputSizeForVDSpecified()==false)
					{
						HandleInputSizeNotSpecifiedError();
						return false;
					}
					if(IsInputSizeForVDNaN()==true)
					{
						HandleInputSizeNotANumberErrorForReconfig();
						return false;
					}
					if(IsInputSizeForVDWithinRange()==false)
					{	
						HandleInputSizeRangeErrorForExpress();
						return false;
					}
					if ( HandleInputSizeGreaterThanOsLimit() == false )
					{
						return false;
					}
					return true;
				}
				function HandleInputSizeGreaterThanOsLimit()
				{
					
					var sizeValue = getElementNameForVDSize();
					var osLimitValueinGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Oslimit div (1024*1024*1024), '###0.00')"/>";
					var sizeValueDecFormat = parseFloat(document.getElementById(sizeValue).value);
					var osLimitValueDecFormat = parseFloat(ConvertToDecValString(osLimitValueinGB));

					if ( sizeValueDecFormat &gt; osLimitValueDecFormat)
					{
						<!-- This means that the virtual disk size is greater than the os limit-->
						if (confirm ("<xsl:value-of select="$strOsLimitWarn"/>"))
						{
							return true;
						}
						else
						{
							return false;
						}
					}
					else
					{
						return true; 
					}
					return true;
				}
				function IsInputSizeForVDWithinRange()
				{
					<!-- get selected raid layout value-->
					var layoutValue=getInputRaidLayoutValue();
					<!--get max size for selected raid layout in GB-->
					var minSize = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxSize = getMaxSizeForGivenLayout(layoutValue,"GB");
					
					if( getMinSizeForGivenLayout(layoutValue,"BYTES") == getMaxSizeForGivenLayout(layoutValue,"BYTES"))					{
						minSize = maxSize;
					}
					<!--get input size value in GB-->
					var elemNameForSizeValue = getElementNameForVDSize();
					var sizeValue = parseFloat(document.getElementById(elemNameForSizeValue ).value);
					<!--Do a range check-->
					if( sizeValue &lt; minSize || sizeValue &gt; maxSize)
					{
						return false;
					}
					return true;
				}


			</script>
			
			
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strReconfigure"/><xsl:value-of select="//VirtualDisks/DCStorageObject/Name"/> <xsl:value-of select="$strStep2"/></xsl:attribute>
			</PageTitle>
			
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ReconfigureVDSizeWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;Rules=<xsl:value-of select="/OMA/Rules"/>&amp;IDList=<xsl:value-of select="/OMA/IDList"/>&amp;help=vdtkrcn2</xsl:attribute>
				</Data>
			</CustomButton>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>&amp;Action=blank&amp;help=vdprin</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>
				</Data>
			</BottomCustomButton>
			<TableData>
				<Header>
					<Data colspan="3" align="center">
						<xsl:attribute name="value"><xsl:value-of select="$strSelectAttributes"/></xsl:attribute>
					</Data>
				</Header>
				<Row>
					<Data type="custom" colspan="3" align="center">
						<textarea rows="5" cols="95" name="RaidDescTextArea" id="RaidDescTextArea" readonly="true"/>
					</Data>
				</Row>
				<xsl:for-each select="//SSDAResponse/DCStorageObject">
					<Row>
						<xsl:if test="position()=1">
							<Data>
								<xsl:attribute name="value"><xsl:value-of select="$strTypeCVDU"/></xsl:attribute>
							</Data>
						</xsl:if>
						<xsl:if test="position()!=1">
							<Data value="&#160;"/>
						</xsl:if>
						<Data name="VDLayout" type="radio" handler="OnRaidLayoutSelected()" event="onclick">
					       	<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
					      		<xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
					      		<xsl:message><xsl:value-of select="Layout"/></xsl:message>					                 
						</Data>
						<Data>
							<!-- Raid description -->
							<xsl:attribute name="value">
								<xsl:call-template name="GetRaidLayoutHelpOneLiner">
										<xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param>
								</xsl:call-template>								
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:for-each>
				<Row width="100%">
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strSize"/></xsl:attribute>
					</Data>
					<Data name="VDSize" type="editbox" maxlength="7">
						<xsl:attribute name="unit"><xsl:value-of select="$strGB"/></xsl:attribute>
					</Data>
					<!-- Empty data to equalize rows -->
					<Data></Data>
				</Row>
				<Row width="100%">
					<Data name="Min" value="Minimum Size: 0000.00 GB"/>
					<Data name="Max" value="Maximum Size: 0000.00 GB"/>
					<!-- Empty data to equalize rows -->
					<Data></Data>
				</Row>
			</TableData>
			<HiddenTable>
				<xsl:for-each select="//SSDAResponse/DCStorageObject">
						<xsl:call-template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/>
						<xsl:call-template name="getHelpText_HIDDEN_TABLE"/>
						<xsl:call-template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/>
						<xsl:call-template name="getMaxSizeInGBForGivenLayoutType_HIDDEN_TABLE"/>
						<xsl:call-template name="getMinSizeInGBForGivenLayoutType_HIDDEN_TABLE"/>
				</xsl:for-each>
			</HiddenTable>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
