<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Enclosure Information page.  The associated web plugin is the EnclosureInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:include href="pstbl.xsl"/>
	<xsl:include href="Utils.xsl"/>
	<xsl:template match="OMA">
		<DataArea ignorejumpbar="true" backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin">
			<PageTitle>
				<xsl:attribute name="status"><xsl:value-of select="/OMA/Health/Component/@status"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1Part1"/><xsl:value-of select="Name"/><xsl:value-of select="$strTitle1Part2"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.PSInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;Name=<xsl:value-of select="Name"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;help=psprin</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:call-template name="PSTable"/>
		</DataArea>
	</xsl:template>
	<xsl:template name="PSTable">
		<!-- DISPLAY THE FAN INFORMATION IN A TABLE FORMAT-->
		<TableData columnspacing="true">
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/></xsl:attribute>
			</SubHeader>
			<xsl:choose>
				<xsl:when test="count(PowerSupply/DCStorageObject)>0">
					<Header>
						<xsl:call-template name="PSTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="PowerSupply/DCStorageObject">
						<xsl:sort select="Index" data-type="number" order="ascending"/>
						<xsl:call-template name="PSTableRows">
							<xsl:with-param name="tasks">false</xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>
		</TableData>
	</xsl:template>
</xsl:stylesheet>
