<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
     	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:variable name="checkAdmin">
				<xsl:choose>
					<xsl:when test="OMAUserRights = '7'">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

		
                  <DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin" printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="true">
                  <xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=268435456&amp;help=cnprin&amp;</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strDiscardPinnedCache"/></xsl:attribute>
                  <xsl:variable name="dfltBkPg">/servlet/DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=stprhl</xsl:variable >
                  <xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
                  <xsl:attribute name="backpagetarget"><xsl:call-template name="BackPagePinned"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>
                     
			
			<xsl:call-template name="scripts"/>
                  
			<script language="javascript">
                  function initializationRoutine()
                  {
                   ;
                  }
			function validate()
                  {   
                       if(document.getElementById("DiscardCacheMessage")!=null &amp;&amp; document.getElementById("DiscardCacheMessage").checked==true)
                       {

                                    if((document.getElementById("offlinecheckbox") == null &amp;&amp; (document.getElementById("foreigncheckbox")!=null &amp;&amp; document.getElementById("foreigncheckbox").checked==true)) || ((document.getElementById("offlinecheckbox") != null &amp;&amp;document.getElementById("offlinecheckbox").checked==true) &amp;&amp;  document.getElementById("foreigncheckbox")==null))
                                     {
                                          return true;
                                     }  
                                    if((document.getElementById("offlinecheckbox")!=null &amp;&amp; document.getElementById("offlinecheckbox").checked==true) &amp;&amp; (document.getElementById("foreigncheckbox")!=null &amp;&amp; document.getElementById("foreigncheckbox").checked==true))
                                     {
                                            
                                             return true;
                                     } 
                        } 
                        if( (document.getElementById("offlinecheckbox") != null) || (document.getElementById("foreigncheckbox")!=null ))
                        {
                          alert('<xsl:value-of select="$strPinnedCacheConfirmation"/>'); 
                        }
                        else if(document.getElementById("DiscardCacheMessage")!=null &amp;&amp; document.getElementById("DiscardCacheMessage").checked==true)
                        {
                          return true;
                        }
                        else
                        {
                         alert('<xsl:value-of select="$strLastPinnedCacheconfirmation"/>');
                        }  
                        return false;


                      
                  }
				<!-- embed your scripts here -->			

		      </script>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitle"/><xsl:value-of select="ControllerName"/></xsl:attribute>
			</PageTitle>

			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				</Data>
			</CustomButton>

     
            <xsl:if test="substring(/OMA/Controllers/DCStorageObject/CurrentMethodMask,3,1)='1'">
		<TableData name="T1" display="{$strForeignConfigDetails}">
			<Header><Data colspan="4" align="center"><xsl:attribute name="value"><xsl:value-of select="$strForeignConfigDetails"/></xsl:attribute></Data></Header>
				<Row>
					<Data type="checkbox" colspan="3" rowspan="3" align="center" name="foreigncheckbox" id="foreigncheckbox">
						<xsl:attribute name="value"></xsl:attribute>
					</Data>
					<Data colspan="3" rowspan="3" align="left" name="foreigntext">
						<xsl:attribute name="value"><xsl:value-of select="$strForeignConfigMessage"/></xsl:attribute>
					</Data>
                        </Row>
                        <Row>
					<Data colspan="2" align="center" name="foreigntext2">
						<xsl:attribute name="value"><xsl:value-of select="$strForeignConfig"/></xsl:attribute>
					</Data>
					<Data>
						<xsl:attribute  name="value"><xsl:value-of select="$strPreview"/></xsl:attribute>
						<xsl:attribute name="link">true</xsl:attribute>
				            <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=16777216&amp;help=cntkipfc&amp;pinnedcache=true</xsl:attribute>
          				</Data>
				</Row>
		</TableData>	
            </xsl:if>
            <xsl:if test="count(VirtualDisks/DCStorageObject[VDiskPinnedCache = '1'])!='0'"> 
		<TableData name="T2" display="{$strOfflineDisks}">
			<Header><Data colspan="4" align="center">
                          <xsl:attribute name="value"><xsl:value-of select="$strOfflineDisks"/></xsl:attribute></Data></Header>
				<Row>
					<Data type="checkbox" colspan="3" rowspan="3" align="center" name="offlinecheckbox" id="offlinecheckbox">
						<xsl:attribute name="value"></xsl:attribute>
					</Data>
					<Data colspan="3" rowspan="3" align="left" name="offlinetext">
						<xsl:attribute name="value"><xsl:value-of select="$strOfflineDisksMessage"/></xsl:attribute>
					</Data>
                           </Row>
                           <Row>
					<Data colspan="2" align="center" name="offlinetext2">
						<xsl:attribute name="value"><xsl:value-of select="$strOfflineVDs"/></xsl:attribute>
					</Data>
                              <Data>
						<xsl:attribute name="value"><xsl:value-of select="$strClick"/></xsl:attribute>
						<xsl:attribute name="link">true</xsl:attribute>
				            <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.OfflineVDsWithPinnedCacheWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=cntkimfc</xsl:attribute>
          				</Data>
 
				</Row>
		
		</TableData>
            </xsl:if>	

		<TableData name="T3" display="{$strDiscardPinnedCacheMessage}">
			<Header><Data colspan="4" align="center"><xsl:attribute name="value"><xsl:value-of select="$strDiscardPinnedCacheMessage"/></xsl:attribute></Data></Header>
				<Row>
					<Data type="checkbox" colspan="3" rowspan="3" align="center" name="DiscardCacheMessage" id="DiscardCacheMessage">
						<xsl:attribute name="value"></xsl:attribute>
					</Data>
					<Data colspan="3" align="left" name="foreigntext">
						<xsl:attribute name="value"><xsl:value-of select="$strConfirmMessage"/></xsl:attribute>
					</Data>
				</Row>
		</TableData>	

		
          
      

    </DataArea>
	</xsl:template>

        <xsl:template name="BackPagePinned" match="OMA">
          <xsl:param name="defaultBackPage">
          </xsl:param>
          <xsl:choose>
            <xsl:when test="BackTo and BackTo!='' and (contains(BackTo, 'ControllerInfoWebPlugin') or contains(BackTo, 'OMSSHealthWebPlugin'))">
              <xsl:value-of select="BackTo"/>
            </xsl:when>

            <xsl:otherwise><xsl:value-of select="$defaultBackPage"/></xsl:otherwise>
          </xsl:choose>
        </xsl:template>

     <xsl:template match="*">
</xsl:template>
</xsl:stylesheet>
