<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:variable name="isCluster">
			<xsl:choose>
				<xsl:when test="substring(/OMA/ArrayInfo/Controllers/DCStorageObject/AttributesMask,32,1)!='0'">1</xsl:when>
				<xsl:otherwise>0</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="checkAdmin">
				<xsl:choose>
					<xsl:when test="OMAUserRights = '7'">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

		<DataArea exportdata="false">
			<!-- The call to the scripts template is needed to include the new common javascript function GetLocalUrl( ) for error handling -->
			<!-- This call must reside within the <DataArea> tag -->
			<xsl:call-template name="scripts"/>
			<script language="javascript">

			function onExecuteController(name, oid)
			{
			       var cluster = document.getElementById("ClusterMode"+oid).value;
				var confirmreponse = 0;

				var action = document.getElementById("CtrlTasks" + oid).value;
				if (action == "-")
				{
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
				else if (action =="64")
				{ //create vd

					// need a cluster check.
					if(cluster == 1)
					{
							msg = "<xsl:value-of select="$strClusterCreate"/>";
							confirmresponse = confirm(msg);
					}

					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
					{
				   	var origurl = GetLocalUrl(); //original URL
						<!--document.location.href ="/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=vdmgmt&amp;OrigURL="+origurl;-->
        document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.LaunchCreateVDWizardSubmitWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;OrigURL=" + origurl );
					document.dataarea.submit();
					}
				}
				else if (action == "128")
				{  //reset config
					// need a cluster check.
					if(cluster == 1)
					{
							msg = "<xsl:value-of select="$strClusterResetCnfg"/>";
							confirmresponse = confirm(msg);
					}

					if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
        {
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmResetConfWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntkrset");
        }
        }
        else if (action == "32") { //set rebuild rate
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetRebuildRateWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntkrbld&amp;RebuildRate=" + document.getElementById("RebuildRate"+oid).value);
        }
        else if (action == "8192") { //set bgi rate
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkbgi&amp;Rate=" + document.getElementById("BGIRate"+oid).value);
        }
        else if (action == "16384")  { //set checkconsistency rate
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkchk&amp;Rate=" + document.getElementById("CheckConsistencyRate"+oid).value);
        }
        else if (action == "65536")  { //set reconstruct rate
        document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlRateAttribWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;help=cntkrcn&amp;Rate=" + document.getElementById("ReconstructRate"+oid).value);
        }
        else if (action == "1") { //controller rescan
          document.location.href  = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmCtrlRescanWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action="+action+"&amp;help=cnprin");
        }
        else if ((action == "4") || (action == 8) || (action == 16) || (action == 1024) || (action == 2048)) {
        //will eventually make this default...rescan, enable, disable, quiet alarm, resume, test alarm i/o
        document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action="+action+"&amp;help=cnprin");
        document.dataarea.submit();
        }
        else if (action == "256") { //export log
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlExportLogWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;help=cntklog");
        }
        else if (action == "8388608") { //clear foreign config
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkclfc");
        }
        else if (action == "16777216") { //import foreign config
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc");
        }
        else if (action == "33554432") { //forced import foreign config
          
          
          //document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc");
            document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkimfc");
        }
        else if (action == "536870912") { //foreign config operations
            var origurl = GetLocalUrl(); //original URL
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkipfc"+"&amp;OrigUrl="+origurl);
        }
        else if (action == "2097152") { //start patrol read
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmStartStopPatReadWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkpats");
        }
        else if (action == "4194304") { //stop patrol read
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmStartStopPatReadWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action +"&amp;help=cntkpats");
        }
        else if (action == "1048576") { //set patrol read mode
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.SetCtrlPatReadModeWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;Action=" + action + "&amp;PatrolReadMode="+ document.getElementById("PatrolReadMode"+oid).value + "&amp;PatrolReadModeMask="+ document.getElementById("PatrolReadModeMask"+oid).value + "&amp;help=cntkpatm");
	}
        else if (action == "67108864") { //change controller properties 6.0 changes
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ChangeControllerPropertiesWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName="+ name+"&amp;OrigURL=" + origurl+"&amp;help=cntkchcp");
        }
        else if (action == "268435456") { //Pinned Cached
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlManagePinnedCacheWebPlugin&amp;ControllerOID=" + oid + "&amp;ControllerName=" + name + "&amp;OrigURL=" + origurl+"&amp;help=cntkpats");
        }
        
	else {
	      // Should never get here
	      alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
        }
        }


        function RedirectToAlertLog()
        {
          document.location.href =top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.oma.webplugins.AlertLogWebPlugin&amp;help=AlertLog&amp;app=hip&amp;ct=System&amp;snb=Logs&amp;lsnb=AlertLog");
        }

		      </script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strStorageDashboard"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				</Data>
			</CustomButton>
      <xsl:choose>
        <xsl:when test="count(.//ArrayInfo) = '0'">
          <PromptText>
            <xsl:value-of select="$strNoStorageController"/>
          </PromptText>
        </xsl:when>
        <xsl:otherwise>
          <PromptText><xsl:value-of select="$strDescriptionDetail"/></PromptText>
			    <SelectionData>
				    <SelectionTable>
					    <Header>
						    <Data>
							    <xsl:attribute name="value"><xsl:value-of select="$strSeverity"/></xsl:attribute>
						    </Data>
					    </Header>
				      <xsl:choose>
					      <xsl:when test="SortHealthComp='true'">
						      <xsl:for-each select="ArrayInfo/Controllers">
							      <xsl:sort select="@ControllerName" order="ascending"/>
								<xsl:sort select="DCStorageObject/PCISlot"/>
							      <xsl:call-template name="Component">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:when>
					      <xsl:otherwise>
						      <xsl:for-each select="ArrayInfo/Controllers">
								<xsl:sort select="DCStorageObject/PCISlot"/>
							      <xsl:call-template name="Component">
								      <xsl:with-param name="DCSObject" select="DCStorageObject"/>
								      <xsl:with-param name="tasks"><xsl:value-of select="$checkAdmin"/></xsl:with-param>
							      </xsl:call-template>
						      </xsl:for-each>
					      </xsl:otherwise>
				      </xsl:choose>
				  </SelectionTable>
			</SelectionData>
        </xsl:otherwise>
      </xsl:choose>

      <HiddenTable>
				<!--This creates a hidden table that maps a "controller oid" to the "max size possible" for that layout/-->
				<xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getClusterModeGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getRebuildRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getReconstructRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getBGIRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getChkConsistencyRateGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getPatrolReadModeGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
        <xsl:for-each select="/OMA/ArrayInfo/Controllers/DCStorageObject"><xsl:call-template name="getPatrolReadModeMaskGivenControllerOID_HIDDEN_TABLE"/></xsl:for-each>
			</HiddenTable>

    </DataArea>
	</xsl:template>

  <xsl:template name="getPatrolReadModeGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">PatrolReadMode<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="PatrolReadMode"><xsl:value-of select="PatrolReadMode"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getPatrolReadModeMaskGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">PatrolReadModeMask<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="PatrolReadModeMask"><xsl:value-of select="PatrolReadModeMask"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getChkConsistencyRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">CheckConsistencyRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="CheckConsistencyRate"><xsl:value-of select="CheckConsistencyRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getBGIRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">BGIRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="BGIRate"><xsl:value-of select="BGIRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getReconstructRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">ReconstructRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="ReconstructRate"><xsl:value-of select="ReconstructRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getRebuildRateGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">RebuildRate<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:choose><xsl:when test="RebuildRate"><xsl:value-of select="RebuildRate"/></xsl:when><xsl:otherwise><xsl:value-of select="$strUnknown"/></xsl:otherwise></xsl:choose></xsl:attribute>
    </Data>
  </xsl:template>

  <xsl:template name="getClusterModeGivenControllerOID_HIDDEN_TABLE">
    <xsl:variable name="OID"><xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template></xsl:variable>
    <Data type="hidden">
      <xsl:attribute name="name">ClusterMode<xsl:value-of select="$OID"/></xsl:attribute>
      <xsl:attribute name="returnvalue"><xsl:value-of select="substring(AttributesMask,32,1)"/></xsl:attribute>
    </Data>
  </xsl:template>

	<xsl:template name="Component">
		<xsl:param name="DCSObject"/>
		<xsl:param name="tasks"/>
		<xsl:variable name="ObjID">
			<xsl:call-template name="ModNexus">
				<xsl:with-param name="nexus" select="$DCSObject/Nexus"/>
			</xsl:call-template>
		</xsl:variable>

		<Row tree="expand">
			<xsl:attribute name="name">controllergroup<xsl:value-of select="$ObjID"/>treecontrol</xsl:attribute>
			<SelectDataItem>
				<Data type="icon" align="left" width="12" height="1">
					<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="$DCSObject/TreeStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data align="left" width="170" height="1">
					<xsl:attribute name="value"><xsl:value-of select="@ControllerName"/></xsl:attribute>
					<xsl:attribute name="link">true</xsl:attribute>
					<xsl:attribute name="href">javascript:parent.ct.select('Controller<xsl:value-of select="$ObjID"/>', 'Properties<xsl:value-of select="$ObjID"/>', 'Health<xsl:value-of select="$ObjID"/>');</xsl:attribute>
				</Data>
			</ColumnData>

			<xsl:variable name="checkAdmin">
				<xsl:choose>
					<xsl:when test="OMAUserRights = '7'">true</xsl:when>
					<xsl:otherwise>false</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<!-- var used for hiding tasks menu option -->
			<xsl:variable name="isEmpty">
				<xsl:call-template name="IsCurrentMethodMaskEmpty">
					<xsl:with-param name="Mask">
						<xsl:value-of select="$DCSObject/CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>

			<xsl:if test="$tasks='true'">
			<ColumnData>
				<xsl:choose>
					<xsl:when test="$isEmpty='0'">
						<!-- currentmethod mask isn't empty -->
						<Data type="select" align="left" width="258">
							<xsl:attribute name="name">CtrlTasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<Choice>
								<xsl:attribute name="value"><xsl:value-of select="$strSelectTask"/></xsl:attribute>
							</Choice>
							<xsl:if test="string-length($DCSObject/MasterMethodMask) = 32">
								<xsl:call-template name="for-loop-list-box">
									<xsl:with-param name="Mask" select="$DCSObject/CurrentMethodMask"/>
									<xsl:with-param name="templateName" select="5"/>
								</xsl:call-template>

							</xsl:if>
						</Data>
						<Data type="button">
							<xsl:attribute name="href">javascript:onExecuteController(\"<xsl:value-of select="@ControllerName"/>\",\"<xsl:value-of select="$ObjID"/>\");</xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strExecute"/></xsl:attribute>
							<xsl:attribute name="tablebutton">true</xsl:attribute>
							<!-- The above property should be set for the table button to get rid of white spaces on the edges -->
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data type="select" align="left" boxwidth="width:400px">
							<xsl:attribute name="name">CtrlTasks<xsl:value-of select="$ObjID"/></xsl:attribute>
							<Choice returnvalue="" default="true">
								<xsl:attribute name="value"><xsl:value-of select="$strNoTask"/></xsl:attribute>
							</Choice>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</ColumnData>
			</xsl:if>



			<ColumnData editable="false" align="left" width="200">
				<!-- Only show alert log link when controller roll-up status is not OK -->
				<xsl:variable name="controllerstatus">
					<xsl:value-of select="$DCSObject/TreeStatus"/>
				</xsl:variable>
				<xsl:if test="$controllerstatus!='2'">
					<Data>
						<xsl:attribute name="value"><xsl:value-of select="$strAlertLog"/></xsl:attribute>
						<xsl:attribute name="link">true</xsl:attribute>
            <xsl:attribute name="href">javascript:parent.ct.select('System', 'Logs', 'AlertLog');</xsl:attribute>
          </Data>
				</xsl:if>
			</ColumnData>

			<!-- virtual disk -->
			<ChildrenRows>
				<xsl:choose>
					<xsl:when test="../VirtualDisks/DCStorageObject">
					<Row>
						<ColumnData>
						<!-- VD details link -->
							<Data>
							<xsl:attribute name="value"><xsl:value-of select="$strVDDetails"/></xsl:attribute>
							<xsl:attribute name="link">true</xsl:attribute>
							<xsl:attribute name="href">javascript:parent.ct.select('VD<xsl:value-of select="$ObjID"/>', 'VDSNB<xsl:value-of select="$ObjID"/>', 'Information<xsl:value-of select="$ObjID"/>');</xsl:attribute>
							</Data>
						</ColumnData>
					</Row>


						<xsl:for-each select="../VirtualDisks/DCStorageObject">
							<xsl:choose>
								<xsl:when test="SpanNum"></xsl:when><!-- do not show child span vds -->
								<xsl:otherwise>
									<Row>
										<SelectDataItem>
											<Data type="icon" align="left" width="12" height="1">
												<xsl:attribute name="value"><xsl:call-template name="getIcon1"><xsl:with-param name="status"><xsl:value-of select="TreeStatus"/></xsl:with-param></xsl:call-template></xsl:attribute>
											</Data>
										</SelectDataItem>
										<ColumnData>
											<Data width="150">
												<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
                                                                                                <xsl:if test="TreeStatus!=2">
                                                                                                <xsl:attribute name="link">true</xsl:attribute>
                                                                                                <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ArrayWebPlugin&amp;ControllerOID=.<xsl:value-of select="GlobalNo"/>&amp;ControllerName=<xsl:value-of select="../../@ControllerName"/>&amp;VirtualDiskOID=<xsl:call-template name="ModNexus"><xsl:with-param name="nexus" select="Nexus"/></xsl:call-template>&amp;VirtualDiskName=<xsl:value-of select="Name"/>&amp;RaidLayout=<xsl:value-of select="Layout"/>&amp;BackTo=/servlet/DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin!help=stprhl&amp;help=adprin</xsl:attribute>
                                                                                                </xsl:if>
											</Data>
										</ColumnData>
										<ColumnData>
											<Data>
												<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType" 		select="Layout"/></xsl:call-template></xsl:attribute>
											</Data>
										</ColumnData>
									</Row>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
				  <!-- No VD. This is is needed to keep alignment in the table, otherwise alignment will be off if a controller has a VD and another one doesn't. -->
					<Row>
						<ColumnData>
								<Data width="150">
									<xsl:attribute name="value">No Virtual Disks</xsl:attribute>
								</Data>
						</ColumnData>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
			</ChildrenRows>

		</Row>
	</xsl:template>
	<xsl:template name="getIcon1">
		    <xsl:param name="status"/>
		    <xsl:if test="$status='0'">/oma/images/blank.gif</xsl:if>
		    <xsl:if test="$status='1'">/oma/images/blank.gif</xsl:if>
		    <xsl:if test="$status='2'">/oma/images/ok.gif</xsl:if>
		    <xsl:if test="$status='3'">/oma/images/non-critical.gif</xsl:if>
		    <xsl:if test="$status='4'">/oma/images/critical.gif</xsl:if>
		    <xsl:if test="$status='5'">/oma/images/non-recoverable.gif</xsl:if>
		    <xsl:if test="$status='6'">/oma/images/abort.gif</xsl:if>
		    <xsl:if test="$status='7'">/oma/images/progress.gif</xsl:if>
		    <xsl:if test="$status='8'">/oma/images/suspend.gif</xsl:if>
		    <xsl:if test="$status='9'">/oma/images/resume.gif</xsl:if>
		    <xsl:if test="$status='10'">/oma/images/pending.gif</xsl:if>
     </xsl:template>
     <xsl:template match="*">
</xsl:template>
</xsl:stylesheet>
