<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
        <xsl:import href="offlinevdtbl.xsl"/>

	<xsl:output method="xml"/>
     
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
                  <DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin" printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="true">
                  <xsl:variable name="dfltBkPg">/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:variable >
                  <xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
                  <xsl:attribute name="backpagetarget"><xsl:call-template name="BackPage"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>
			<xsl:call-template name="scripts"/>

			<script language="javascript">
			function validate()
                         {
                         return true;
                          }
			function initializationRoutine()
                        {
                        ;
                        }

		      </script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strOfflineVDswithPinnedCache"/><xsl:value-of select="/OMA/ControllerName"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				</Data>
			</CustomButton>
		
		<TableData name="T" columnspacing="true">
			<Header>
			  <xsl:call-template name="OfflineVDTableHeader" />
			</Header>
                      <xsl:for-each select="VirtualDisks/DCStorageObject[VDiskPinnedCache='1']">
                              <xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
					<xsl:call-template name="OfflineVDTableRows">
						<xsl:with-param name="tasks">
							<xsl:value-of select="$checkAdmin"/>
						</xsl:with-param>
					</xsl:call-template>
                              
					</xsl:for-each>
		</TableData>	
</DataArea>
</xsl:template>
</xsl:stylesheet>


