<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="importpreviewvdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<xsl:variable name="CANCEL_LINK"><xsl:value-of select="/OMA/OrigUrl"/></xsl:variable>
                <xsl:variable name="isCluster">
				<xsl:choose>
					<xsl:when test="substring(/OMA/VirtualDisks/@AttributesMask,32,1)!='0'">1</xsl:when>
				  <xsl:otherwise>0</xsl:otherwise>
			 </xsl:choose>
		</xsl:variable>

		<script language="javascript">
      function reloadPage()
      {
          document.location.href = top.gnv.appendVID(document.URL);
      }

      function getThisURL()
      {
      var cluster = <xsl:value-of select="$isCluster"/>;
			var confirmresponse = 0;

			if(cluster == 1)
			{
					var msg = "<xsl:value-of select="$strClusterCreate"/>";
					confirmresponse = confirm(msg);
			}

			if((cluster == 1 &amp;&amp; confirmresponse) || cluster == 0)
      {
      var url = GetLocalUrl();
          document.dataarea.action = top.gnv.appendVID("/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;OrigURL=" + url);
					document.dataarea.submit();
			}
		}


		</script>

		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
                <xsl:variable name="PinnedCache"><xsl:value-of select="/OMA/PinnedCache"/></xsl:variable>
 		<DataArea onLoad="true">
                  <!--xsl:attribute name="submit">javascript:importRecover()</xsl:attribute>
                  <xsl:attribute name="submitdisplay"><xsl:value-of select="$strImportRecover"/></xsl:attribute-->
                  
                  
			<xsl:call-template name="scripts"/>
			<script language="javascript">
				function initializationRoutine()
				{
					<!-- DF27306 - Selecting vdisk does not display constituent array disks in aparticular scenario
						This defect was reported in 1.4. A fix for DFCT116290 actually broke the page. At this time,
						the OMSA team is unable to root cause this issue. Reverting to original behavior since
						original issue is cosmetic in nature. 
						Original defect:
							DFCT116290 - OMSS1.0 Pointer to Storage Tree on Left not changing correponding to Page -->
					<!-- Commenting out
					var compid = "VD"+"<xsl:value-of select="/OMA/ControllerOID"/>";
					parent.ct._select(compid);
					-->
				}

				function importRecover()
				{

					<xsl:if test="(VirtualDisks//DCStorageObject/Layout = '4') and (VirtualDisks//DCStorageObject/ObjStatus = '3')">
						if (confirm ("<xsl:value-of select="$strDegradedRaid1ConfirmMsg"/>") == false)
							return;

					</xsl:if>
					
					document.dataarea.action = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=33554432&amp;help=cntkimfc");

					document.dataarea.submit();

				}
                                 function reloadPage()
                                {    
                                     document.location.href = top.gnv.appendVID(document.URL);
                                }
			</script>
			<PageTitle>
				<xsl:if test="count(VirtualDisks/DCStorageObject) > 0">
					<xsl:choose>
						<xsl:when test="ControllerName != ''">
							<xsl:attribute name="display"><xsl:value-of select="$strTitle2Part1"/><xsl:value-of select="ControllerName"/><xsl:value-of select="$strTitle2Part2"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="display"><xsl:value-of select="$strTitle"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</PageTitle>
			
			<xsl:if test="(count(VirtualDisks/DCStorageObject) &gt; 0) and (VirtualDisks/DCStorageObject/NoOfGUIDForImport &gt;= 8)">
				<PromptText alert="true"><xsl:value-of select="$strMoreConfigMsg"/></PromptText>
			</xsl:if>
	
			<xsl:if test="(VirtualDisks//DCStorageObject/Layout = '4') and (VirtualDisks//DCStorageObject/ObjStatus = '3')">
				<PromptText alert="true"><xsl:value-of select="$strDegradedRaid1Msg"/></PromptText>
			</xsl:if>

			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">javascript:reloadPage()</xsl:attribute>
					
				</Data>
			</CustomButton>

			<BottomCustomButton>
				<Data formSubmit="true">
					<xsl:attribute name="display"><xsl:value-of select="$strImportRecover"/></xsl:attribute>
					<xsl:attribute name="href">javascript:importRecover()</xsl:attribute>
				</Data>
			</BottomCustomButton>
			<BottomCustomButton>
				<Data formSubmit="true">
					<xsl:attribute name="display"><xsl:value-of select="$strClear"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlConfirmForeignConfigWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;Action=8388608&amp;help=cntkclfc</xsl:attribute>
				</Data>
			</BottomCustomButton>
			<BottomCustomButton>
				<Data formSubmit="true">
                                    <xsl:choose>
                                    <xsl:when test="$PinnedCache ='true'">
                                        <xsl:attribute name="display"><xsl:value-of select="$strPrev"/></xsl:attribute>
                                        <xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.CtrlManagePinnedCacheWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cntkmpic</xsl:attribute>
                                    </xsl:when>
                                    <xsl:otherwise>
					<xsl:attribute name="display"><xsl:value-of select="$strCancel"/></xsl:attribute>
					<xsl:attribute name="href"><xsl:value-of select="translate($CANCEL_LINK,'!','&amp;')"/>&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:attribute>
                                    </xsl:otherwise>
                                    </xsl:choose>
				</Data>
			</BottomCustomButton>
			<xsl:call-template name="VirtualDiskTable1">
				<xsl:with-param name="tasks">
					<xsl:value-of select="$checkAdmin"/>
				</xsl:with-param>
			</xsl:call-template>
			<xsl:if test="GlobalHotSpares">
				<xsl:for-each select="GlobalHotSpares">
					<xsl:call-template name="Table">
						<xsl:with-param name="Display">
							<xsl:value-of select="$strGHSTitle"/>
						</xsl:with-param>
						<xsl:with-param name="filterOutDHS">false</xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:if>
		</DataArea>
	</xsl:template>
	<xsl:template name="VirtualDiskTable1">
		<xsl:param name="tasks"/>
		<xsl:choose>
			<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
				<!--CR49916 - auto refresh code-->
				<xsl:if test="VirtualDisks/DCStorageObject/Progress">
	                         <HTMLData>
	                                  <script language="Javascript">
	                                  	<!--refresh page every 30secs when there is atleast one object with Progress associated with it -->
	                                          setTimeout("reloadPage()",30000) ;
	                                  </script>
	                         </HTMLData>
	                    </xsl:if>
				<TableData columnspacing="true">
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader"/></xsl:attribute>
					</SubHeader>
					<xsl:choose>
						<xsl:when test="count(VirtualDisks/DCStorageObject)>0">
							<PromptText ignoreoncli="true">
								<xsl:value-of select="$strPrompt"/>
							</PromptText>
						</xsl:when>
						<xsl:otherwise>
							<PromptText ignoreoncli="true">
								<xsl:value-of select="$strPrompt2"/>
							</PromptText>
						</xsl:otherwise>
					</xsl:choose>
					<Header>
						<xsl:call-template name="ImportPreviewVDTableHeader" />
					</Header>
                                        <xsl:variable name="CANCEL_LINK"><xsl:value-of select="/OMA/OrigUrl"/></xsl:variable>
					<xsl:for-each select="VirtualDisks/DCStorageObject">
						<xsl:sort select="LogicalDriveNum" data-type="number" order="ascending"/>
						<xsl:call-template name="ImportPreviewVDTableRows">
							<xsl:with-param name="tasks">
								<xsl:value-of select="$tasks"/>
							</xsl:with-param>
							<xsl:with-param name="caller">/servlet/DataArea?plugin=com.dell.sm.webplugins.ImportPreviewWebPlugin!ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>!ControllerName=<xsl:value-of select="/OMA/ControllerName"/>!Action=536870912!help=cntkipfc!pinnedcache=<xsl:value-of select="/OMA/PinnedCache"/>!OrigUrl=<xsl:value-of select="translate($CANCEL_LINK,'&amp;','!')"/></xsl:with-param>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:when>
			<xsl:otherwise>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strPrompt2"/></xsl:attribute>
				</SubHeader>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="Table">
		<xsl:param name="Display"/>
		<xsl:param name="filterOutDHS"/>
		<TableData name="{$Display}" display="{$Display}" ignoreJumpBar="true" columnspacing="true">
			<xsl:variable name="showtasks">false</xsl:variable>

			<SubHeader display="{$Display}"/>
			<xsl:choose>
				<xsl:when test="DCStorageObject">
					<Header>
						<xsl:call-template name="ArrayDiskTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="DCStorageObject">
						<xsl:sort select="Channel" data-type="number" order="ascending"/>
						<xsl:sort select="TargetID" data-type="number" order="ascending"/>
						<xsl:variable name="isDHS">
							<xsl:choose>
								<xsl:when test="$filterOutDHS = 'true'">
									<!-- check to see if current disk is DHS -->
									<xsl:call-template name="IsDedicatedHotSpare">
										<xsl:with-param name="AttributesMask">
											<xsl:value-of select="AttributesMask"/>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>0</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:if test="$isDHS='0'">
							<xsl:call-template name="ArrayDiskTableRows">
								<xsl:with-param name="tasks">false</xsl:with-param>
								<xsl:with-param name="expanded">true</xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<Row>
						<Data type="ustring" columnspacing="true">
							<xsl:attribute name="value"><xsl:value-of select="$strNoDisks"/></xsl:attribute>
						</Data>
					</Row>
				</xsl:otherwise>
			</xsl:choose>
		</TableData>
	</xsl:template>

</xsl:stylesheet>
