<!-- This is the XSL to render the Controller Information page.  The associated web plugin is the ControllerInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<!-- Define a bunch of global variables-->
	<xsl:variable name="GLOBAL_VAR_CurrentFirmwareVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/FirmwareVer"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_RequiredFirmwareVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/RequiredFirmwareVersion"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_CurrentDriverVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/CurrentDriverVersion"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_RequiredDriverVersion"><xsl:value-of select="/OMA/Controllers/DCStorageObject/RequiredDriverVersion"/></xsl:variable>
	
	<!-- Define Global variable for health status that can be used by other XSL files. Currently this variables are used to display status in Firmware/Driver version info page-->
	<xsl:variable name="HEALTH_STATUS_UNKNOWN_0">0</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_UNKNOWN_1">1</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_OK">2</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_NON_CRITICAL">3</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_CRITICAL">4</xsl:variable>
	<xsl:variable name="HEALTH_STATUS_NON_RECOVERABLE">5</xsl:variable>
	
	<xsl:template match="OMA">          
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/OMA/Controllers/DCStorageObject/Name"/></xsl:attribute>
			</PageTitle>
			<!-- Checks if the firmware and/or driver versions are out of date, if so displays appropriate message informing that they are out of date -->
			<SubHeader>
				<xsl:choose>
					<xsl:when test="$GLOBAL_VAR_RequiredFirmwareVersion and $GLOBAL_VAR_RequiredDriverVersion">
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderFwDriverVerOutOfDate"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$GLOBAL_VAR_RequiredFirmwareVersion">
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderFwVerOutOfDate"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>
					</xsl:when>
					<xsl:when test="$GLOBAL_VAR_RequiredDriverVersion">
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderDriverVerOutOfDate"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="$HEALTH_STATUS_NON_CRITICAL"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise><!-- Do Nothing--></xsl:otherwise>
				</xsl:choose>
			</SubHeader>
			
			<TableData>
				     <!--If the node FirmwareVer is missing continue to display the row that informs that FirmwareVersion is not appicable. This is for non-raid scsi controllers -->
					<Row>
						<Data value="{$strFW}"/>
						<Data>
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="$GLOBAL_VAR_CurrentFirmwareVersion">
										<xsl:choose>
											<xsl:when test="$GLOBAL_VAR_CurrentFirmwareVersion= '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="$GLOBAL_VAR_CurrentFirmwareVersion"/></xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</Row>
				
				<xsl:if test="$GLOBAL_VAR_RequiredFirmwareVersion ">
					<Row>
						<Data value="{$strReqFW}"/>
						<Data>
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="$GLOBAL_VAR_RequiredFirmwareVersion">
										<xsl:choose>
											<xsl:when test="$GLOBAL_VAR_RequiredFirmwareVersion= '(null)' ">
												<xsl:value-of select="$strUnknown"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$GLOBAL_VAR_RequiredFirmwareVersion"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$strNotApplicable"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:if>
								     <!--If the node DriverVer is missing continue to display the row that informs that DriverVersion is not appicable. This is for non-raid scsi controllers -->
					<Row>
						<Data value="{$strDvr}"/>
						<Data>
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="$GLOBAL_VAR_CurrentDriverVersion">
										<xsl:choose>
											<xsl:when test="$GLOBAL_VAR_CurrentDriverVersion= '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when>
											<xsl:otherwise><xsl:value-of select="$GLOBAL_VAR_CurrentDriverVersion"/></xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</Row>
				<xsl:if test="$GLOBAL_VAR_RequiredDriverVersion">
					<Row>
						<Data value="{$strReqDvr}" width="200"/>
						<Data align="left" width="75">
							<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="$GLOBAL_VAR_RequiredDriverVersion">
										<xsl:choose>
											<xsl:when test="$GLOBAL_VAR_RequiredDriverVersion= '(null)' ">
												<xsl:value-of select="$strUnknown"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="$GLOBAL_VAR_RequiredDriverVersion"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$strNotApplicable"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
						</Data>
					</Row>
				</xsl:if>
			</TableData>
			
			<CustomButton>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.FirmwareDriverInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=fwprin</xsl:attribute>
				</Data>
			</CustomButton>
		</DataArea>
	</xsl:template>
			
</xsl:stylesheet>
