<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- the xsl included below contains messages for error codes-->
	<xsl:include href="smmsgs.xsl"/>
	<xsl:variable name="GLOBAL_PARAM_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_ExitWizardHREFValue"><xsl:value-of select="translate($GLOBAL_PARAM_OrigURL,'!','&amp;')"/></xsl:variable>
	<xsl:template match="/">
		<DataArea exportdata="false">
			<PageTitle alert="true" status="4">
				<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
			</PageTitle>
			<SubHeader><xsl:attribute name="display"><xsl:value-of select="$strTitle2"/><xsl:call-template name="GetMessage"><xsl:with-param name="ErrorID" select="/OMA/ErrorCode"/></xsl:call-template></xsl:attribute></SubHeader>
			<!-- Removed Refresh button as a part of fix for DFCT119759-->
			<!--CustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.HandleErrorWebPlugin&amp;ErrorCode=<xsl:value-of select="/OMA/ErrorCode"/></xsl:attribute>
				</Data>
			</CustomButton-->
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strExitWizard"/></xsl:attribute>

					<xsl:choose>
						<xsl:when test="$GLOBAL_PARAM_OrigURL != 'null' or $GLOBAL_PARAM_OrigURL != ''">
					                <xsl:attribute name="href"><xsl:value-of select="$GLOBAL_VAR_ExitWizardHREFValue"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.OMSSHealthWebPlugin&amp;help=adprin</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
