<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- EMM TABLE HEADER -->
	<xsl:template name="EMMTableHeader">
		<xsl:param name="tasks">false</xsl:param>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- ignore on web is set to true since it's only needed for scripts using the cli -->
		<Data name="ID" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring" align="center">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring" align="left">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
		<!--Data> MJR Removed for DFCT 100497
			<xsl:attribute name="display"><xsl:value-of select="$strEnclID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strEnclID"/></xsl:attribute>
		</Data-->
		<xsl:if test="//PartNo or $dynamicView='false'">
			<Data name="PartNo" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strPartNo"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strPartNo"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//FirmwareVer or $dynamicView='false'">
			<Data name="FW" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strFW"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strFW"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//MaxSCSISpeed or $dynamicView='false'">
			<Data name="ScsiSpeed" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strSCSIRate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSCSIRate"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//PropTypeString or $dynamicView='false'">
			<Data name="proptype" editable="false" type="ustring" align="center">
				<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
			</Data>
		</xsl:if>
	</xsl:template>
	<!-- EMM TABLE ROWS -->
	<xsl:template name="EMMTableRows">
		<xsl:param name="tasks"/>
		<!-- The current implementation is to have the UI be dynamic in the data it shows.  Only the columns applicable
to the objects will be displayed.  The CLI will display all columns of data however to ease script parsing. -->
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
			<Data ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="Index"/></xsl:attribute>
			</Data>
			<Data type="status" align="center">
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</Data>
			<Data name="Test" editable="false" type="ustring" display="Test" align="left">
				<xsl:attribute name="value"><xsl:value-of select="$strEMM"/><xsl:value-of select="Index"/></xsl:attribute>
			</Data>
			<Data align="left">
				<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<!--Data> MJR Removed for DFCT 100497
				<xsl:attribute name="value"><xsl:value-of select="EnclosureID"/></xsl:attribute>
			</Data-->
			<xsl:if test="//PartNo or $dynamicView='false'">
				<xsl:choose>
					<xsl:when test="PartNo">
						<Data align="center">
							<xsl:attribute name="value"><xsl:value-of select="PartNo"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//FirmwareVer or $dynamicView='false'">
				<xsl:choose>
					<xsl:when test="FirmwareVer">
						<Data align="center">
							<xsl:attribute name="value"><xsl:value-of select="FirmwareVer"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:if test="//MaxSCSISpeed or $dynamicView='false'">
				<xsl:choose>
					<xsl:when test="MaxSCSISpeed">
						<Data align="center">
							<xsl:attribute name="value"><xsl:value-of select="MaxSCSISpeed"/></xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
				<xsl:if test="//PropTypeString or $dynamicView='false'">
				<xsl:choose>
					<xsl:when test="PropTypeString">
						<Data align="center">
							<xsl:attribute name="value">
								<xsl:call-template name="GetEMMType">
								   <xsl:with-param name="emmtype">
								   	<xsl:value-of select="PropTypeString"/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data align="center">
							<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
						</Data>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			
		</Row>
		<script language="javascript">
			function onExecute(oid) {
				var encltasks = "encltasks" + oid;
				var action = document.getElementById(encltasks).value;		
				if (action == "-") { 
					alert("Error! Please select a valid task");
				}
				else {
					alert("Error! AD Function '"+action+"' not yet implemented");
				}
			}
		</script>
	</xsl:template>
</xsl:stylesheet>
