<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the dedicated hot spare page.  The associated web plugin is the DedicatedHotSpareWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<xsl:import href="vdtbl.xsl"/>
	<xsl:template match="OMA">
		<DataArea backpagetarget="/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerWebPlugin">
			<xsl:call-template name="scripts"/>
			<xsl:choose>
				<xsl:when test="/OMA/ChangeMade='true'">
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle1"/></xsl:attribute>
					</PageTitle>
					<SelectionData multitable="true" image="none">
						<SelectionTable>
							<Header>
								<Data>
									<xsl:attribute name="value"><xsl:value-of select="$strAssignHdr"/></xsl:attribute>
								</Data>
							</Header>
							<xsl:if test="count(AssignedDHS/ArrayDisks/DCStorageObject) > 0">
								<Row tree="expand" name="assigneddisks">
									<ColumnData>
										<xsl:for-each select="VirtualDisks/DCStorageObject">
											<xsl:call-template name="VDisk"/>
										</xsl:for-each>
									</ColumnData>
									<!-- The children rows are the individual disks -->
									<ChildrenRows>
										<xsl:for-each select="AssignedDHS/ArrayDisks/DCStorageObject">
											<xsl:call-template name="AssignedDisks"/>
										</xsl:for-each>
									</ChildrenRows>
								</Row>
							</xsl:if>
						</SelectionTable>
						<ResultTable>
							<Header>
								<Data>
									<xsl:attribute name="value"><xsl:value-of select="$strUnassignHdr"/></xsl:attribute>
								</Data>
							</Header>
							<xsl:for-each select="UnassignedDHS/ArrayDisks/DCStorageObject">
								<xsl:call-template name="UnassignedDisks"/>
							</xsl:for-each>
						</ResultTable>
					</SelectionData>
				</xsl:when>
				<xsl:otherwise>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strTitle2"/></xsl:attribute>
					</PageTitle>
				</xsl:otherwise>
			</xsl:choose>
			<BottomCustomButton>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strBackToVDInfo"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;HREF=<xsl:value-of select="/OMA/HREF"/>&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;help=vdprin</xsl:attribute>
				</Data>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	<xsl:template name="VDisk">
		<Data editable="false" type="ustring">
			<xsl:attribute name="name"><xsl:value-of select="$strName"/><xsl:value-of select="position()"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="AssignedDisks">
		<xsl:variable name="ArrayDiskSize">
			<xsl:value-of select="Length"/>
		</xsl:variable>
		<Row>
			<ColumnData>
				<Data name="Test" columnspacing="true" editable="false" type="usting" display="Test">
					<xsl:choose>
						<xsl:when test="EnclosureID">
							<!-- SAS -->
							<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<!-- SCSI -->
							<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			</ColumnData>
			<ColumnData>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSize div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data>
			</ColumnData>
		</Row>
	</xsl:template>
	<xsl:template name="UnassignedDisks">
		<xsl:variable name="ArrayDiskSize">
			<xsl:value-of select="Length"/>
		</xsl:variable>
		<Row tree="fixed" name="unassigneddisks">
			<SelectDataItem>
				<Data name="Test" columnspacing="true" editable="false" type="usting" display="Test">
					<xsl:choose>
						<xsl:when test="EnclosureID">
							<!-- SAS -->
							<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<!-- SCSI -->
							<xsl:attribute name="value"><xsl:value-of select="$strADName"/><xsl:value-of select="Channel"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
				<!--Data>
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSize div (1024*1024*1024)),'#,##0.00 GB')"/></xsl:attribute>
				</Data-->
			</SelectDataItem>
		</Row>
	</xsl:template>
</xsl:stylesheet>
