<!-- This is the XSL to render the Array Disks belonging to a Virtual Disk page.  The associated web plugin is the ArrayWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<!-- Create a variable to set the appropriate delete action.  This is used when setting the submit button href on the DataArea tag -->
	<xsl:variable name="DeleteAction">
		<xsl:choose>
			<xsl:when test="//NumBootPart>0">deletevdforce</xsl:when>
			<xsl:otherwise>deletevd</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="canBlink">
		<xsl:choose>
			<xsl:when test="/OMA/Blink='true'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="ADPresent">
		<xsl:choose>
			<xsl:when test="/OMA/ArrayDisks/DCStorageObject">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>


	<xsl:template match="OMA">
		<DataArea>
			<xsl:attribute name="validate">true</xsl:attribute>
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.VDExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Action=<xsl:value-of select="$DeleteAction"/>&amp;help=vdtkdel</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strDelete"/></xsl:attribute>
			<xsl:if test="Blink='true'">
				<xsl:if test="ArrayDisks/DCStorageObject">
					<!-- extra check for DFCT104927 -->
					<!-- We needed the ability to disable (hide) the bottom buttons when a user executes an action (DFCT117103) -->
					<!-- but we currently only have the ability to hide the submit, cancel, and back buttons.  Since this page only -->
					<!-- uses the cancel and submit buttons, I have changed the <BottomCustomButton> for Blink to be a cancel -->
					<!-- button as a way to hide it when the user selects submit.  This will need to change when the framework allows -->
					<!-- other buttons to be disabled.   - Michael Regert, 06/15/04 -->
					<xsl:attribute name="cancel">true</xsl:attribute>
					<xsl:attribute name="canceldisplay"><xsl:value-of select="$strBlink"/></xsl:attribute>
					<xsl:attribute name="canceltarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDBlinkBeforeDeleteWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;NumBootPart=<xsl:value-of select="NumBootPart"/>&amp;Blink=<xsl:value-of select="Blink"/>&amp;Action=blinkvd&amp;help=vdtkdel</xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
			<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDInfoWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=vdprin</xsl:attribute>

			<xsl:choose>
				<xsl:when test="NumBootPart>0">
					<PageTitle alert="true" status="3">
						<xsl:attribute name="display"><xsl:value-of select="$strTitleBootPart1"/><!--xsl:value-of select="ArrayDisks/@VirtualDiskName"/--><xsl:value-of select="$strTitleBootPart2"/></xsl:attribute>
					</PageTitle>
				</xsl:when>
				<xsl:otherwise>
					<PageTitle alert="true" status="3">
						<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><!--xsl:value-of select="ArrayDisks/@VirtualDiskName"/--><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
					</PageTitle>
				</xsl:otherwise>
			</xsl:choose>
			<CustomButton>
				<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href"></xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmDeleteVDWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VDiskOID=<xsl:value-of select="/OMA/VDiskOID"/>&amp;VDiskName=<xsl:value-of select="/OMA/VDiskName"/>&amp;VDeviceName=<xsl:value-of select="VDeviceName"/>&amp;Blink=<xsl:value-of select="Blink"/>&amp;NumBootPart=<xsl:value-of select="NumBootPart"/>&amp;help=vdtkdel</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true">
				<xsl:variable name="showtasks">false</xsl:variable>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strSubHeaderPart1"/><xsl:value-of select="VDiskName"/><xsl:value-of select="$strSubHeaderPart2"/></xsl:attribute>
				</SubHeader>
				<xsl:choose>
					<xsl:when test="ArrayDisks/DCStorageObject">
						<Header>
							<xsl:call-template name="ArrayDiskTableHeader">
								<xsl:with-param name="tasks">false</xsl:with-param>
								<xsl:with-param name="expanded">true</xsl:with-param>
							</xsl:call-template>
						</Header>
						<xsl:for-each select="ArrayDisks/DCStorageObject">
							<xsl:call-template name="ArrayDiskTableRows">
								<xsl:with-param name="tasks">false</xsl:with-param>
								<xsl:with-param name="expanded">true</xsl:with-param>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<Row>
							<Data type="ustring" columnspacing="true">
								<xsl:attribute name="value"><xsl:value-of select="$strNoDisks"/></xsl:attribute>
							</Data>
						</Row>
					</xsl:otherwise>
				</xsl:choose>
			</TableData>
			
		
			<!-- show if blink is supported -->
			<!--xsl:if test="Blink='true'"-->
				<!--xsl:if test="ArrayDisks/DCStorageObject"-->
					<!-- extra check for DFCT104927 -->
					<!-- We needed the ability to disable (hide) the bottom buttons when a user executes an action (DFCT117103) -->
					<!-- but we currently only have the ability to hide the submit, cancel, and back buttons.  Since this page only -->
					<!-- uses the cancel and submit buttons, I have changed the <BottomCustomButton> for Blink to be a cancel -->
					<!-- button as a way to hide it when the user selects submit.  This will need to change when the framework allows -->
					<!-- other buttons to be disabled.   - Michael Regert, 06/15/04 -->
					<!--BottomCustomButton>
						<Data>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.VDBlinkBeforeDeleteWebPlugin&amp;HREF=<xsl:value-of select="HREF"/>&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;VDiskOID=<xsl:value-of select="VDiskOID"/>&amp;VDiskName=<xsl:value-of select="VDiskName"/>&amp;Blink=<xsl:value-of select="Blink"/>&amp;Action=blinkvd&amp;help=vdtkdel</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strBlink"/></xsl:attribute>
						</Data>
					</BottomCustomButton-->
				<!--/xsl:if-->
			<!--/xsl:if-->
			<script language="javascript">
			function validate() 
			{
				// Validate doesn't need to validate any data, but just needs to prompt the user
				// to verify the want to continue with the delete.  confirm( ) will return true when
				// the user selects OK and false when the user selects CANCEL.
				var delmsg = "<xsl:value-of select="$strRUSure"/><xsl:value-of select="$strRUSure2"/><xsl:value-of select="/OMA/VDiskName"/><xsl:value-of select="$strRUSure3"/>
				<xsl:value-of select="$strQuestionMark"/>";
				var cfrm = confirm(delmsg);
				var isblink = "<xsl:value-of select="$canBlink"/>";
				var isADPresent = "<xsl:value-of select="$ADPresent"/>";

				if(cfrm)
				{
					if(isblink == 1)
					{
						//disableButtons("submit","back" ,"cancel");
						if (isADPresent == 1)
						{
							disableButtons("submit","back" ,"cancel");
						}
						else
						{
							disableButtons("submit","back" ,"");
						}
					}
					else
					{
						disableButtons("submit","back" ,"");
					}
				}
				return (cfrm);
			}

		</script>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
