<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- DFCT139044 - Indravijay J. Gohil  GUI:Adisk with no free space is listed in CreateVD wizard on PERC /2QC -->
	<!-- Creating hash variable for use within conditional for check on minimum drive size allowable to be visible  -->
	<xsl:variable name="MinDriveSpace"><xsl:value-of select="0.005 * 1024 * 1024"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Oslimit"><xsl:value-of select="//Controllers/DCStorageObject/MaxOsLimitForLogicalDriveSize"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_SCSIEnclosureID">0</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_SCSI">1</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_SATA">7</xsl:variable>
  <xsl:variable name="GLOBAL_VAR_SAS">8</xsl:variable>
  <!--xsl:template name="RenderLayoutSelectionRadioButton">
		<Row>
			<xsl:choose>
				<xsl:when test="position()=1"><Data value="Type"></Data></xsl:when>
				<xsl:otherwise><Data value="&#160; "></Data></xsl:otherwise>
			</xsl:choose>
			<Data name="VDLayout" type="radio" handler="OnRaidLayoutSelected()" event="onclick" state="2">
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayout">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="."/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="."/></xsl:attribute>
			</Data>
			<Data name="VDLayoutHelpOneLiner" align="left">
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayoutHelpOneLiner">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="."/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template-->

	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:template name="RenderLayoutSelectionRadioButton">
		<xsl:param name="i"/>
		<xsl:param name="BitValue"/>
		<xsl:param name="InterpreterFunc"/>
		<Row>
			<xsl:choose>
				<xsl:when test="$i='32'"><Data value="{$strTypeCVDU}" width="175"/></xsl:when>
				<xsl:otherwise><Data value="&#160;" width="175"/></xsl:otherwise>
			</xsl:choose>
			<Data name="VDLayout" type="radio" handler="OnRaidLayoutSelected()" event="onclick" state="0" width="175">
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayout">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="$BitValue"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
			</Data>
			<Data name="VDLayoutHelpOneLiner" align="left" width="175">
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayoutHelpOneLiner">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="$BitValue"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<!-- Separate template to disable concatenated, raid-1-concatenated and Raid-50 types for DSA-->
	<xsl:template name="DSARenderLayoutSelectionRadioButton">
		<xsl:param name="i"/>
		<xsl:param name="BitValue"/>
		<xsl:param name="InterpreterFunc"/>
		<Row>
			<xsl:choose>
				<xsl:when test="$i='31'"><Data value="{$strTypeCVDU}" width="175"/></xsl:when>
				<xsl:otherwise><Data value="&#160;" width="175"/></xsl:otherwise>
			</xsl:choose>
			<Data name="VDLayout" type="radio" handler="OnRaidLayoutSelected()" event="onclick" state="0" width="175">
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayout">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="$BitValue"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
				<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
			</Data>
			<Data name="VDLayoutHelpOneLiner" align="left" width="175">
				<xsl:attribute name="value">
					<xsl:call-template name="GetRaidLayoutHelpOneLiner">
						<xsl:with-param name="RaidType">
							<xsl:value-of select="$BitValue"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>

	<xsl:template name="for-loop">
		<xsl:param name="Mask"/>
		<xsl:param name="BitValue" select="1"/>
		<xsl:param name="i"	select="32"/>
		<xsl:param name="increment" select="-1"/>
		<xsl:param name="testValue" select="1"/>
		<xsl:param name="RULES" />
		<xsl:if test="$i >= '1' ">
			<xsl:if test="substring($Mask,$i,1)='1'  ">
				<xsl:choose>
					<xsl:when test="$RULES='0' ">
						<xsl:call-template name="RenderLayoutSelectionRadioButton">
							<xsl:with-param name="i" select="$i"/>
							<xsl:with-param name="BitValue" select="$BitValue"/>
						</xsl:call-template>
					</xsl:when>
					<!-- Filter out RAID-50, CONCAT-RAID-1 and RAID-60 in DSA mode -->
					<xsl:when test="$RULES ='1' and $BitValue != '2048' and $BitValue !='4096' and $BitValue != '262144' and $BitValue != '1' ">
						<xsl:call-template name="DSARenderLayoutSelectionRadioButton">
							<xsl:with-param name="i" select="$i"/>
							<xsl:with-param name="BitValue" select="$BitValue"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="for-loop">
				<xsl:with-param name="Mask" select="$Mask"/>
				<xsl:with-param name="BitValue" select="$BitValue*2"/>
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
				<xsl:with-param name="RULES" select="$RULES"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "max size possible in bytes" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  123456789./-->
		<!--Layout2 .....  567891011/ -->
		<!--Layout4 .....  121314156 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMaxSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMaxSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMaxSizeInBytesFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Length"/></xsl:attribute>
		</Data>
	</xsl:template>
	<xsl:template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "min size possible in bytes" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  123456789./-->
		<!--Layout2 .....  567891011/ -->
		<!--Layout4 .....  121314156 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMaxSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMaxSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMinSizeInBytesFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="MinimumLength"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="getMaxSizeInGBForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "max size possible" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  33.33 ./-->
		<!--Layout2 .....  44.65 / -->
		<!--Layout4 .....  55.65 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMaxSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMaxSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMaxSizeInGBFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="format-number((Length div (1024*1024*1024)),'###0.00')"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="getMinSizeInGBForGivenLayoutType_HIDDEN_TABLE">
		<!--This creates a hidden table that maps a "raid layout type" to the "min size possible" for that layout/-->
		<!--The table would look like below /-->
		<!--Layout1 .....  33.33 ./-->
		<!--Layout2 .....  44.65 / -->
		<!--Layout4 .....  55.65 / -->
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/-->
		<Data type="hidden">
			<!--The name below would appear as "getMinSizeFor_Layout_1_HIDDEN_TABLE_DATA", "getMinSizeFor_Layout_2_HIDDEN_TABLE_DATA" etc/-->
			<xsl:attribute name="name">getMinSizeInGBFor_Layout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="format-number((MinimumLength div (1024*1024*1024)),'###0.00')"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="getHelpText_HIDDEN_TABLE">
		<Data type="hidden">
			<xsl:attribute name="name">getHelpText_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<!--The Template in Utils.xsl is called below/-->
			<xsl:attribute name="returnvalue"><xsl:call-template name="GetRaidLayoutHelp"><xsl:with-param name="RaidType"><xsl:value-of select="Layout"/></xsl:with-param></xsl:call-template></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="AvailableRaidLayout_HIDDEN_TABLE">
		<Data type="hidden">
			<xsl:attribute name="name">RadioButtonsForRaidLayoutSelection_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue"><xsl:value-of select="Layout"/></xsl:attribute>
		</Data>
	</xsl:template>

	<xsl:template name="GetRaidLayoutHelpOneLiner">
		<xsl:param name="RaidType"/>
		<xsl:choose>
			<xsl:when test="$RaidType='1'"><xsl:value-of select="$strOneLineHelpConcatCVDU"/></xsl:when>
			<xsl:when test="$RaidType='2'"><xsl:value-of select="$strOneLineHelpRaid0CVDU"/></xsl:when>
			<xsl:when test="$RaidType='4'"><xsl:value-of select="$strOneLineHelpRaid1CVDU"/></xsl:when>
			<xsl:when test="$RaidType='64'"><xsl:value-of select="$strOneLineHelpRaid5CVDU"/></xsl:when>
			<xsl:when test="$RaidType='512'"><xsl:value-of select="$strOneLineHelpRaid10CVDU"/></xsl:when>
			<xsl:when test="$RaidType='2048'"><xsl:value-of select="$strOneLineHelpRaid50CVDU"/></xsl:when>
			<xsl:when test="$RaidType='4096'"><xsl:value-of select="$strOneLineHelpRaid1ConcatCVDU"/></xsl:when>
			<xsl:when test="$RaidType='128'"><xsl:value-of select="$strOneLineHelpRaid6CVDU"/></xsl:when>
			<xsl:when test="$RaidType='262144'"><xsl:value-of select="$strOneLineHelpRaid60CVDU"/></xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="NewLine">
		<xsl:text>
		</xsl:text>
	</xsl:template>
	<xsl:template name="GetRaidLayoutHelp">
		<xsl:param name="RaidType"/>
		<xsl:choose>
			<xsl:when test="$RaidType='1'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpConcatCVDU"/></xsl:when>
			<xsl:when test="$RaidType='2'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid0CVDU"/></xsl:when>
			<xsl:when test="$RaidType='4'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid1CVDU"/></xsl:when>
			<xsl:when test="$RaidType='64'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid5CVDU"/></xsl:when>
			<xsl:when test="$RaidType='128'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid6CVDU"/></xsl:when>
			<xsl:when test="$RaidType='512'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid10CVDU"/></xsl:when>
			<xsl:when test="$RaidType='2048'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid50CVDU"/></xsl:when>
			<xsl:when test="$RaidType='262144'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid60CVDU"/></xsl:when>
			<xsl:when test="$RaidType='4096'"><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpRaid1ConcatCVDU"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strTextBoxHelpHeaderCVDU"/><xsl:call-template name="NewLine"/><xsl:value-of select="$strTextBoxHelpConcatCVDU"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="RenderCreateVDTable">
		<xsl:param name="RAIDMask"/>
		<xsl:param name="READMask"/>
		<xsl:param name="WRITEMask"/>
		<xsl:param name="CACHEMask"/>
                <xsl:param name="DISKCACHEMask"/>
		<xsl:param name="STRIPESMask"/>
		<xsl:param name="HIDE_NAME_ROW"/>
		<xsl:param name="HIDE_SIZE_ROW"/>
		<xsl:param name="HIDE_MIN_MAX_ROW"/>
		<xsl:param name="HIDE_RAID_DESC_ROW"/>
		<xsl:param name="RULES"/>
		<xsl:param name="SELECT_RAID_HEADER"/>
		<xsl:param name="VD_NAME_LENGTH" select="10"/>
		<TableData name="T">
			<Header><Data value="{$SELECT_RAID_HEADER}" colspan="3" align="center"/></Header>
			<xsl:if test="$HIDE_RAID_DESC_ROW != 'true'">
				<Row>
					<Data type="custom" colspan="3" align="center">
						<textarea rows="5" cols="95" name="RaidDescTextArea" id="RaidDescTextArea" readonly="true"/>
					</Data>
				</Row>
			</xsl:if>
			<xsl:call-template name="for-loop">
				<xsl:with-param name="Mask" select="$RAIDMask"/>
				<xsl:with-param name="RULES" select="$RULES"/>
			</xsl:call-template>
			<xsl:if test="$HIDE_NAME_ROW != 'true' ">
				<Row>
					<Data value="{$strNameCVDU}"/>
					<Data name="VDName" type="editbox" maxlength="{$VD_NAME_LENGTH}" returnvalue="0"/>
					<Data value="&#160;"/>
				</Row>
			</xsl:if>
			<xsl:if test="$HIDE_SIZE_ROW != 'true' ">
				<Row>
					<Data value="{$strSizeCVDU}"/>
					<Data name="VDSize" type="editbox" maxlength="7" returnvalue="0">
						<xsl:attribute name="unit"><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute></Data>
					<Data value=" &#160;"/>
				</Row>
			</xsl:if>
			<xsl:if test="$HIDE_MIN_MAX_ROW != 'true' ">
				<Row>
					<Data name="Min" value="{$strMinSizeZeroCVDU}" />
					<Data name="Max" value="{$strMaxSizeZeroCVDU}" />
					<Data value="&#160;"/>
				</Row>
			</xsl:if>
			<xsl:if test="$STRIPESMask != ''">
				<Row>
					<Data value="{$strStripeSizeCVDU}"/>
					<Data name="StripeSize" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$STRIPESMask"/>
							<xsl:with-param name="templateName" select="1"/>
						</xsl:call-template>
					</Data>
					<Data value="&#160;"/>
				</Row>
			</xsl:if>
			<xsl:if test="$READMask != ''">
				<Row>
					<Data value="{$strReadPolicyCVDU}"/>
					<Data name="ReadPolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$READMask"/>
							<xsl:with-param name="templateName" select="2"/>
						</xsl:call-template>
					</Data>
					<Data value="&#160;"/>
				</Row>
			</xsl:if>
			<xsl:if test="$WRITEMask != ''">
				<Row>
					<Data value="{$strWritePolicyCVDU}"/>
					<Data name="WritePolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$WRITEMask"/>
							<xsl:with-param name="templateName" select="3"/>
						</xsl:call-template>
					</Data>
					<Data value="&#160;"/>
				</Row>
			</xsl:if>
			<xsl:if test="$CACHEMask != ''">
				<Row>
					<Data value="{$strCachePolicyCVDU}"/>
					<Data name="CachePolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$CACHEMask"/>
							<xsl:with-param name="templateName" select="4"/>
						</xsl:call-template>
					</Data>
					<Data value="&#160;"/>
				</Row>
			</xsl:if>
                        <xsl:if test="$DISKCACHEMask != ''">
				<Row>
					<Data value="{$strDiskCachePolicyCVDU}"/>
					<Data name="DiskCachePolicy" type="select">
						<xsl:call-template name="for-loop-list-box">
							<xsl:with-param name="Mask" select="$DISKCACHEMask"/>
							<xsl:with-param name="templateName" select="20"/>
						</xsl:call-template>
					</Data>
					<Data value="&#160;"/>
				</Row>
			</xsl:if>
		</TableData>
	</xsl:template>
	<xsl:template name="RenderVDConfigTable">
		<xsl:param name="KEY_NAME_VDNODES"/>
		<xsl:param name="KEY_MATCH_VDNODES"/>
		<xsl:param name="CONTROLLER_NAME"/>
		<xsl:param name="KEY_NAME_ADNODES"/>
		<TableData>
			<!-- RS - DFCT155243/CHNG129635: Add Existing RAID configuration section and change text type to Array disk -->
			<!-- Main header -->
			<Header>
				<Data value="{$strExistingRaidCVDU}" colspan="6" align="center"/>
			</Header>
			<!-- Sub header -->
			<Header>
				<!-- AS - DF54481: Aligning Header to look like DSA. Removing Empty cell. -->
				<!-- AS - CR30001: Add Status of existing virtual disk  -->
				<Data value="{$strStatus}"/>
				<Data value="{$strVirtualDiskCVDU}"/>
				<Data value="{$strType}"/>
				<Data value="{$strDeviceCVDU}"/>
				<Data value="{$strLevelCVDU}"/>
				<Data value="{$strSizeCVDU}"/>
				<Data value="{$strArrayDiskIDCVDU}"/>
			</Header>
			<xsl:for-each select="key($KEY_NAME_VDNODES,$KEY_MATCH_VDNODES)/DCStorageObject[not(ParentVDID)]">
					<xsl:call-template name="RenderVDConfigInfo">
						<xsl:with-param name="LOGICAL_DRIVE_NUM"><xsl:value-of select="LogicalDriveNum"/></xsl:with-param>
						<xsl:with-param name="CONTROLLER_NAME"><xsl:value-of select="$CONTROLLER_NAME"/></xsl:with-param>
						<xsl:with-param name="BUSPROTOCOL"><xsl:value-of select="BusProtocol"/></xsl:with-param>
						<xsl:with-param name="LAYOUT"><xsl:value-of select="Layout"/></xsl:with-param>
						<xsl:with-param name="LENGTH"><xsl:value-of select="Length"/></xsl:with-param>
						<xsl:with-param name="KEY_NAME"><xsl:value-of select="$KEY_NAME_ADNODES"/></xsl:with-param>
						<xsl:with-param name="KEY_MATCH">Virtual Disk <xsl:value-of select="LogicalDriveNum"/></xsl:with-param>
					</xsl:call-template>
			</xsl:for-each>
		</TableData>
	</xsl:template>
	<xsl:template name="RenderVDConfigInfo">
		<xsl:param name="LOGICAL_DRIVE_NUM"/>
		<xsl:param name="CONTROLLER_NAME"/>
		<xsl:param name="BUSPROTOCOL"/>
		<xsl:param name="LAYOUT"/>
		<xsl:param name="LENGTH"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Row>
			<!-- AS - DF54481: Aligning Row to look like DSA. Removing Empty cell. -->
			<!-- AS - CR30001: Add Status of existing virtual disk  -->
			<!-- AS - DF54481: Removing the align center option for Status icon.  -->
			<Data type="status">
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$LOGICAL_DRIVE_NUM"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:call-template name="GetBusProtocol"><xsl:with-param name="Bus"><xsl:value-of select="$BUSPROTOCOL"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$CONTROLLER_NAME"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType"><xsl:value-of select="$LAYOUT"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value"><xsl:call-template name="DecimalSep"><xsl:with-param name="Size"><xsl:value-of select="$LENGTH"/></xsl:with-param></xsl:call-template> <xsl:value-of select="$strGBUnitCVDU"/>
				</xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value">
					<xsl:for-each select="key($KEY_NAME, $KEY_MATCH)/DCStorageObject">
						<xsl:variable name="DiskInEnclosure">
							<xsl:call-template name="IsDiskInEnclosure">
								<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
								<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/><xsl:if test="position()!=last()"><xsl:text>, </xsl:text></xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/><xsl:if test="position()!=last()"><xsl:text>, </xsl:text></xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	<xsl:template name="RenderResultTableParentRow">
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<xsl:param name="RULES"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<xsl:param name="DISPLAY_ZERO_FREESPACE_AD"/>
		<xsl:param name="SPAN_MODE"/>
		<xsl:param name="HIDE_DHS" select="0"/>
		<!--ACTIVE_DISK_PROTOCOL has 4th, 7th, 8th bit set based on the protocols supported when this template is called from createVD page-->
		<!--ACTIVE_DISK_PROTOCOL is not set when called from reconfig page and hence gets initialized to 0 below-->
		<xsl:param name="ACTIVE_DISK_PROTOCOL" select="0"/>
		<!-- DF42943 01/13/2006: Adding a flag for reconfigure because reconfigure should receive disks that have smart alerts -->
		<xsl:param name="ALLDISKS"/>
		<xsl:param name="CLEAR_FOREIGN_CONFIGENABLE"/>
		<xsl:param name="MIN_DRIVES_FOR_SELECTED_LAYOUT" select="0"/>
		<xsl:param name="SCSIFreeDisks" select="0"/>
		<xsl:param name="SASFreeDisks" select="0"/>
		<xsl:param name="SATAFreeDisks" select="0"/>
            <xsl:param name="SpanEditMode">false</xsl:param>
		<xsl:param name="SpanEditModeProtocol" select="0"/>
    <Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<xsl:choose>
					<xsl:when test="$SPAN_MODE = 'true' ">
						<Data type="checkbox"  width="150">
							<xsl:attribute name="name"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDeleteSpan('<xsl:value-of select="$DISPLAY_NAME"/>')</xsl:attribute>
						</Data>
					</xsl:when>
					<xsl:otherwise>
						<Data value="{$DISPLAY_NAME}"/>
					</xsl:otherwise>
				</xsl:choose>
			</ColumnData>
			<ChildrenRows>
				<xsl:for-each select="key($KEY_NAME,$KEY_MATCH)/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>

          <xsl:variable name="isEnoughDisk">
            <xsl:choose>
              <xsl:when test="($RULES = '1') or (VendorID = '1')">1</xsl:when>
              <xsl:when test="(UsedSpace != 0) or ((BusProtocol = $GLOBAL_VAR_SCSI and $SCSIFreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT) or (BusProtocol = $GLOBAL_VAR_SAS and $SASFreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT) or (BusProtocol = $GLOBAL_VAR_SATA and $SATAFreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT))">1</xsl:when>
              <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>

          <xsl:variable name="isDHS">
						<!-- check to see if current disk is DHS -->
						<xsl:call-template name="IsDedicatedHotSpare">
							<xsl:with-param name="AttributesMask">
								<xsl:value-of select="AttributesMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>

					<!-- Chethan 11/15/04: Added to fix DFCT126643-->
					<xsl:variable name="AD_STATE">
						<!-- Get the current disk state -->
						<xsl:value-of select="ObjState"/>
					</xsl:variable>
					<xsl:variable name="AD_STATUS">
						<!-- Get the current disk status -->
						<xsl:value-of select="ObjStatus"/>
					</xsl:variable>
					<xsl:variable name="tempBusProtocolPower">
						<xsl:call-template name="Power">
							<xsl:with-param name="num1" select="2"/>
							<xsl:with-param name="num2" select="BusProtocol"/>
						</xsl:call-template>
					</xsl:variable>
					<!-- To fix DF133160 -->
					<xsl:variable name="clearDiskAllowed">
						<xsl:choose>
							<xsl:when test="($AD_STATE = '549755813888') and (ArrayNum != '')">1</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:variable name="IsAdiskProtocolActive"><xsl:call-template name="bitAnd"><xsl:with-param name="num1" select="$tempBusProtocolPower"/><xsl:with-param name="num2" select="$ACTIVE_DISK_PROTOCOL"/></xsl:call-template></xsl:variable>

					<!-- In DSA mode if there are any foreign drives, allow/keep them for RAID configuration based on User inputs -->
					<xsl:variable name="DSAFOREIGNCLEAR">
					<xsl:choose>
					<xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '274877906944' and $CLEAR_FOREIGN_CONFIGENABLE='1'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>

					<xsl:variable name="ACTIVE_CONTROLLER_PROTOCOL"><xsl:value-of select="//Controllers/DCStorageObject/BusProtocol"/></xsl:variable>
					<!-- In DSA mode if there are any drives in resynching (rebuild) state, allow/keep them for RAID configuration -->
					<!-- Only applicable for SAS 5/IR. Getcaps filters out based on model number -->
					<xsl:variable name="DSAREBUILDSTATE">
					<xsl:choose>
					<xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '8388608' and $ACTIVE_CONTROLLER_PROTOCOL='8'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>

					<xsl:choose>
						<!-- IMPORTANT: The first condition to be checked must be whether the row
						     should be hidden because it is a DHS (dedicated hotspare) and whether
						     we should be checking for DHS. Therefore this condition must always
						     be the first to be checked. -->
						<xsl:when test="$HIDE_DHS='1' and $isDHS='1'"><!-- DO NOTHING --></xsl:when>
						<!--ACTIVE_DISK_PROTOCOL != 0 for createVD case only. When this template is called from reconfig page, this value will be 0.-->
						<!--Continue normal processing for reconfig case-->
						<xsl:when test="$IsAdiskProtocolActive = '0' and $ACTIVE_DISK_PROTOCOL != '0' " ><!-- DO NOTHING --></xsl:when>


						<!-- Filtering out disks that are not ready and not online and in not OK status. Fix for DFCT126643, DF28585 -->
            <!-- DF128929 - allow disks in rebuilding state -->
						<!-- Not applicable for Reconfigure -->
						<xsl:when test="($isEnoughDisk != '1') or ($ALLDISKS != '1' and $DSAFOREIGNCLEAR='0' and $DSAREBUILDSTATE='0' and $clearDiskAllowed != '1' and ($AD_STATUS != '2' or ($AD_STATE != '1' and $AD_STATE != '4' and $AD_STATE != '8388608')))">
							<!-- DO NOTHING -->
						</xsl:when>

						<xsl:when test="$RULES='1'">
							<xsl:call-template name="RenderArrayDiskResultRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="Length"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$DISPLAY_ZERO_FREESPACE_AD='1'">
							<xsl:call-template name="RenderArrayDiskResultRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!--Filter array disks with zero freespace-->
							<!-- DFCT139044 - Indravijay J. Gohil GUI:Adisk with no free space is listed in CreateVD wizard on PERC /2QC -->
							<!-- Using hash variable  for comparison to make sure a adisk with >= .01g is shown -->
							<xsl:if test="ContiguousFree >= $MinDriveSpace">
								<xsl:call-template name="RenderArrayDiskResultRow">
									<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
									<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
								</xsl:call-template>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<xsl:template name="RenderArrayDiskResultAndSpanRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/>:<xsl:value-of select="Channel"/>:<xsl:value-of select="EnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					<SelectDataItem>
						<Data type="checkbox"  width="150">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="EnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/>:<xsl:value-of select="Channel"/>:<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>:<xsl:value-of select="TargetID"/></xsl:attribute>
					<SelectDataItem>
						<Data type="checkbox"  width="150">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
				</xsl:otherwise>
			</xsl:choose>
			<ColumnData>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
				</Data>
			</ColumnData>
		</Row>
	</xsl:template>
	<xsl:template name="RenderArrayDiskResultRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
		<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
				<Row>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!--SelectDataItem>
						<Data>
							<xsl:attribute name="value"><xsl:text>Array Disk </xsl:text><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</SelectDataItem-->
					<SelectDataItem>
						<Data type="checkbox"  width="150">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="EnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
						</Data>
					</ColumnData>
					<!--ColumnData>
						<Data type="icon" value="/ss/images/delete.gif" event="onclick">
							<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
						</Data>
					</ColumnData-->
					<!--ColumnData>
						<Data name="delete" type="icon" value="/ss/images/delete.gif" alt="delete">
							<EventHandler event="onclick">
								<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
							</EventHandler>
						</Data>
					</ColumnData-->
				</Row>
			</xsl:when>
			<xsl:otherwise>
				<Row>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
					<!--SelectDataItem>
						<Data>
							<xsl:attribute name="value"><xsl:text>Array Disk </xsl:text><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</Data>
					</SelectDataItem-->
					<SelectDataItem>
						<Data type="checkbox"  width="150">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
							<xsl:attribute name="event">onClick</xsl:attribute>
							<xsl:attribute name="handler">javascript:OnDelete('<xsl:value-of select="Channel"/>','<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</Data>
					</SelectDataItem>
					<ColumnData>
						<Data>
							<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/></xsl:attribute>
						</Data>
					</ColumnData>
					<!--ColumnData>
						<Data type="icon" value="/ss/images/delete.gif" event="onclick">
							<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
						</Data>
					</ColumnData-->
					<!--ColumnData>
						<Data name="delete" type="icon" value="/ss/images/delete.gif" alt="delete">
							<EventHandler event="onclick">
								<xsl:attribute name="handler">javascript:OnDelete("<xsl:value-of select="Channel"/>","<xsl:value-of select="TargetID"/>")</xsl:attribute>
							</EventHandler>
						</Data>
					</ColumnData-->
				</Row>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="RenderSelectionTableParentRow">
            <xsl:param name="Channel"/>   
		<xsl:param name="PARENT_NAME"/>
		<xsl:param name="CHILD_NAME_PREFIX"/>
		<xsl:param name="DISPLAY_NAME"/>
		<xsl:param name="RULES"/>
		<xsl:param name="KEY_NAME"/>
		<xsl:param name="KEY_MATCH"/>
		<xsl:param name="DISPLAY_ZERO_FREESPACE_AD"/>
            <xsl:param name="LAYOUT_SELECTED"/>
		<xsl:param name="HIDE_DHS" select="0"/>
		<xsl:param name="ACTIVE_DISK_PROTOCOL" select="0"/>
			<!-- DF42943 01/13/2006: Adding a flag for reconfigure because reconfigure should receive disks that have smart alerts -->
		<xsl:param name="ALLDISKS"/>
		<xsl:param name="CLEAR_FOREIGN_CONFIGENABLE"/>
		<xsl:param name="MIN_DRIVES_FOR_SELECTED_LAYOUT" select="0"/>
		<xsl:param name="SCSIFreeDisks" select="0"/>
		<xsl:param name="SASFreeDisks" select="0"/>
		<xsl:param name="SATAFreeDisks" select="0"/>
            <xsl:param name="EnclosureID" select="0"/>
            <xsl:param name="CntrlAttributesMask" select="0"/>
            <xsl:param name="SpanEditMode">false</xsl:param>
		<xsl:param name="SpanEditModeProtocol" select="0"/>
    <Row tree="expand" name="{$PARENT_NAME}">
			<ColumnData>
				<xsl:choose>
				<xsl:when test="$LAYOUT_SELECTED='512' and substring($CntrlAttributesMask,11,1)='1' and $SpanEditMode != 'true'">
					<Data type="checkbox" width="150">
						<xsl:attribute name="name">Sel<xsl:value-of select="$Channel"/>:<xsl:value-of select="$EnclosureID"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$DISPLAY_NAME"/></xsl:attribute>
						<xsl:attribute name="returnvalue"><xsl:value-of select="$EnclosureID"/></xsl:attribute>
						<xsl:attribute name="event">onClick</xsl:attribute>
						<xsl:attribute name="handler">javascript:OnEnclosureSelected('<xsl:value-of select="$Channel"/>','<xsl:value-of select="$EnclosureID"/>')</xsl:attribute>
						<!-- Note: there is a space between tags <xsl:text></xsl:text> in the above line and needs to remain that way for delete span to work. Need to come up with a better idea to fix this.-->
					</Data>
                        </xsl:when>
                        <xsl:otherwise>
					<Data value="{$DISPLAY_NAME}"/>
                        </xsl:otherwise>
                        </xsl:choose>
			</ColumnData>
			<ChildrenRows>
				<xsl:for-each select="key($KEY_NAME,$KEY_MATCH)/DCStorageObject">
					<xsl:sort select="Channel" data-type="number" order="ascending"/>
					<xsl:sort select="EnclosureID" data-type="number" order="ascending"/>
					<xsl:sort select="TargetID" data-type="number" order="ascending"/>

          <xsl:variable name="isEnoughDisk">
            <xsl:choose>
              <xsl:when test="($RULES = '1') or (VendorID = '1')">1</xsl:when>
              <xsl:when test="(UsedSpace != 0) or ((BusProtocol = $GLOBAL_VAR_SCSI and $SCSIFreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT) or (BusProtocol = $GLOBAL_VAR_SAS and $SASFreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT) or (BusProtocol = $GLOBAL_VAR_SATA and $SATAFreeDisks &gt;= $MIN_DRIVES_FOR_SELECTED_LAYOUT))">1</xsl:when>
              <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>

          <xsl:variable name="isDHS">
						<!-- check to see if current disk is DHS -->
						<xsl:call-template name="IsDedicatedHotSpare">
							<xsl:with-param name="AttributesMask">
								<xsl:value-of select="AttributesMask"/>
							</xsl:with-param>
						</xsl:call-template>
					</xsl:variable>

					<!-- Chethan 11/15/04: Added to fix DFCT126643-->
					<xsl:variable name="AD_STATE">
						<!-- Get the current disk state -->
						<xsl:value-of select="ObjState"/>
					</xsl:variable>
					<xsl:variable name="AD_STATUS">
						<!-- Get the current disk state -->
						<xsl:value-of select="ObjStatus"/>
					</xsl:variable>

					<xsl:variable name="tempBusProtocolPower">
						<xsl:call-template name="Power">
							<xsl:with-param name="num1" select="2"/>
							<xsl:with-param name="num2" select="BusProtocol"/>
						</xsl:call-template>
					</xsl:variable>
					<!-- To fix DF133160 -->
					<xsl:variable name="clearDiskAllowed">
						<xsl:choose>
							<xsl:when test="($AD_STATE = '549755813888') and (ArrayNum != '')">1</xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:variable name="IsAdiskProtocolActive"><xsl:call-template name="bitAnd"><xsl:with-param name="num1" select="$tempBusProtocolPower"/><xsl:with-param name="num2" select="$ACTIVE_DISK_PROTOCOL"/></xsl:call-template></xsl:variable>


					<xsl:variable name="ACTIVE_CONTROLLER_PROTOCOL"><xsl:value-of select="//Controllers/DCStorageObject/BusProtocol"/></xsl:variable>
					<!-- In DSA mode if there are any foreign drives, allow/keep them for RAID configuration based on User inputs -->
					<xsl:variable name="DSAFOREIGNCLEAR">
					<xsl:choose>
					<xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '274877906944' and $CLEAR_FOREIGN_CONFIGENABLE='1'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>

					<!-- In DSA mode if there are any drives in resynching (rebuild) state, allow/keep them for RAID configuration -->
					<!-- Only applicable for SAS 5/IR. Getcaps filters out based on model number -->
					<xsl:variable name="DSAREBUILDSTATE">
					<xsl:choose>
					<xsl:when test="$ALLDISKS!='1' and $RULES = '1' and $AD_STATE = '8388608' and $ACTIVE_CONTROLLER_PROTOCOL='8'">1</xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>

					<xsl:variable name="CurrProtoAllowed">
						<xsl:choose>
							<xsl:when test="$SpanEditMode = 'true' and $SpanEditModeProtocol != BusProtocol">0</xsl:when>
							<xsl:otherwise>1</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>

					<xsl:choose>
						<!-- IMPORTANT: The first condition to be checked must be whether the row
						     should be hidden because it is a DHS (dedicated hotspare) and whether
						     we should be checking for DHS. Therefore this condition must always
						     be the first to be checked. -->
						<xsl:when test="$HIDE_DHS='1' and $isDHS='1'"></xsl:when>

						<!--ACTIVE_DISK_PROTOCOL != 0 for createVD case only. When this template is called from reconfig page, this value will be 0.-->
						<!--Continue normal processing for reconfig case-->
						<xsl:when test="$IsAdiskProtocolActive = '0' and $ACTIVE_DISK_PROTOCOL != '0' " ><!-- DO NOTHING --></xsl:when>

						<!-- Filtering out disks that are not ready or not online. Fix for DFCT126643 -->
						<!-- Not applicable for reconfigure -->
            <!-- DF128929 - allow disks in rebuilding state -->
            <!-- Allow AD_STATE Ready, Online and Clear -->
						<xsl:when test="($isEnoughDisk != '1') or ($ALLDISKS != '1' and $DSAFOREIGNCLEAR='0' and $DSAREBUILDSTATE='0' and $clearDiskAllowed != '1' and ($AD_STATUS != '2' or ($AD_STATE != '1' and $AD_STATE != '4' and $AD_STATE != '8388608'))) "><!-- DO NOTHING --><xsl:message>[1]</xsl:message></xsl:when>


						<xsl:when test="$RULES='1'">
							<xsl:call-template name="RenderArrayDiskSelectionRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="Length"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$DISPLAY_ZERO_FREESPACE_AD='1'">
							<xsl:call-template name="RenderArrayDiskSelectionRow">
								<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
								<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<!--Filter array disks with zero freespace-->
							<!-- DFCT139044 - Indravijay J. Gohil GUI:Adisk with no free space is listed in CreateVD wizard on PERC /2QC -->
							<!-- Using hash variable  for comparison to make sure a adisk with >= .01g is shown -->
							<xsl:if test="ContiguousFree >= $MinDriveSpace and $CurrProtoAllowed = '1'">
								<xsl:call-template name="RenderArrayDiskSelectionRow">
									<xsl:with-param name="ArrayDiskSpace"><xsl:value-of select="ContiguousFree"/></xsl:with-param>
									<xsl:with-param name="PrefixName"><xsl:value-of select="$CHILD_NAME_PREFIX"/></xsl:with-param>
								</xsl:call-template>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>

				</xsl:for-each>
			</ChildrenRows>
		</Row>
	</xsl:template>
	<xsl:template name="RenderArrayDiskSelectionRow">
		<xsl:param name="ArrayDiskSpace"/>
		<xsl:param name="PrefixName"/>
				<xsl:variable name="SASorSATA">
			<xsl:call-template name="IsSASorSATA">
				<xsl:with-param name="BusProtocol"><xsl:value-of select="BusProtocol"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="DiskInEnclosure">
			<xsl:call-template name="IsDiskInEnclosure">
				<xsl:with-param name="AttributesMask"><xsl:value-of select="AttributesMask"/></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<Row>
			<xsl:choose>
				<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="EnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:value-of select="TargetID"/></xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<SelectDataItem>
				<Data type="checkbox"  width="150">
					<xsl:choose>
						<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="EnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name"><xsl:value-of select="$PrefixName"/><xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strArrayDiskCVDU"/>&#160;<xsl:value-of select="Channel"/><xsl:text>:</xsl:text><xsl:value-of select="TargetID"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="returnvalue"><xsl:value-of select="ObjID"/></xsl:attribute>
					<xsl:attribute name="event">onClick</xsl:attribute>
					<xsl:choose>
						<xsl:when test="$SASorSATA='1' and $DiskInEnclosure='1'">
							<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="EnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="handler">javascript:OnArrayDiskSelected('<xsl:value-of select="Channel"/>','<xsl:value-of select="$GLOBAL_VAR_SCSIEnclosureID"/>','<xsl:value-of select="TargetID"/>')</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</Data>
			</SelectDataItem>
			<ColumnData>
				<Data>
					<xsl:attribute name="value"><xsl:value-of select="format-number(($ArrayDiskSpace div (1024*1024*1024)),'#,##0.00')"/><xsl:value-of select="$strGBUnitCVDU"/> (<xsl:value-of select="$strFreeCVDU"/>)</xsl:attribute>
				</Data>
			</ColumnData>
		</Row>
	</xsl:template>

	<xsl:template name="GetLocalDecSeparator">
		<xsl:choose>
			<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,</xsl:when>
			<xsl:otherwise>.</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getCommonScripts">
				var JS_GLOBAL_UnivDecSeparator=".";
				var JS_GLOBAL_LocalDecSeparator="<xsl:call-template name="GetLocalDecSeparator"/>";

				function RestoreInputNameFieldToBlank()
				{
					try{
						var elemName = getElementNameForVDName();
						document.getElementById(elemName).value = "";
						return;
					}catch(e){}
				}

				function ConvertToDecValString(locString)
				{
					return locString.replace(/,/g,".");
				}

				function FormatNumber(num,decimalPlaces,bRoundUp)
				{
					if(bRoundUp=="true")
					{
						var temp = num;
						temp *= Math.pow(10,decimalPlaces);
						temp = Math.ceil(temp);
						temp /= Math.pow(10,decimalPlaces);
	       				return temp;
					}
					else
					{
						var temp = num;
						temp *= Math.pow(10,decimalPlaces);
	       				temp = Math.floor(temp );
	       				temp /= Math.pow(10,decimalPlaces);
	       				return temp;
       				}
				}
				function getElementNameForVDName()
				{
					return "VDName";
				}
				function getElementNameForVDSize()
				{
					return "VDSize";
				}
				function getElementNameForRaidLayout()
				{
					return "VDLayout";
				}
				function HandleRaidLayoutNotSelectedError()
				{
					try{
						var strMsg = "<xsl:value-of select="$strSelectRaidLevelCVDU"/>";
						var strError = "<xsl:value-of select="$strError"/>";
						alert(strError + strMsg);
						document.getElementById("VDSize").value="";
					}catch(e){}
				}
				function HandleInputSizeNotSpecifiedError()
				{
					var strMsg = "<xsl:value-of select="$strSpecifyVDSizeCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
				}
				function HandleInputSizeNotANumberError()
				{
					var strMsg = "<xsl:value-of select="$strVDSizeNotNumberMsgCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
				}

				// start reconfigure specific code.
				function HandleInputSizeNotANumberErrorForReconfig()
				{
					var layoutValue=getInputRaidLayoutValue()
					var strMsg = "<xsl:value-of select="$strVDSizeNotNumberMsgCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
					document.getElementById(getElementNameForVDSize()).value=getMaxSizeForGivenLayout(layoutValue,"GB");
				}

				// end reconfig specific code.

				function HandleInputVDNameSizeOutOfRange()
				{
					var strMsg = "<xsl:value-of select="$strVDNameSizeExceedMsgCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
				}
				function IsRaidLayoutSelected()
				{
					if(getInputRaidLayoutValue()==-1)
						return false;
					return true;
				}
				function IsInputSizeForVDSpecified()
				{
					if(getInputVDSizeValue()=="")
						return false;
					return true;
				}
				function IsInputSizeForVDNaN()
				{
					var sizeValue = getInputVDSizeValue();
					<!--Make sure to check for trailing spaces, leading spaces and spaces in between a number -->
					<!-- The above check can be accomplished by "isNaN(sizeValue)" that checks spaces in between a number
						and "isNaN(parseFloat(sizeValue)" checks leading and trailing spaces-->
					var sizeValueDecFormat = ConvertToDecValString(sizeValue);
					if( isNaN(sizeValueDecFormat ) )
						return true;
					else if( isNaN(parseFloat(sizeValueDecFormat )) )
						return true;
					else return false;
				}
				function IsInputVDNameSizeWithinRange()
				{
					var nameVal = getInputVDNameValue();
					var str = new String(nameVal);
					if(str.length >24)
						return false;
					return true;
				}
				function getInputVDSizeValue()
				{
					var elemName=getElementNameForVDSize();
					return document.getElementById(elemName).value;
				}
				function getInputVDNameValue()
				{
					try{
						var elemName = getElementNameForVDName();
						return document.getElementById(elemName).value;
					}catch(e){}
				}
				function getInputRaidLayoutValue()
				{
					var elemName = getElementNameForRaidLayout();
					var RadioArray=document.getElementsByName(elemName);
					for(var i=0; i&lt;RadioArray.length; i++)
					{
						if(RadioArray[i].checked == true)
						{
							return RadioArray[i].value;
						}
					}
					return -1;
					<!--return 0;-->
				}
				function commonInitializationRoutine()
				{
					var raidDescMsg = "<xsl:value-of select="$strTextBoxHelpHeaderCVDU"/>"+"\n"+"<xsl:value-of select="$strTextBoxHelpDefaultMsgCVDU"/>";
					document.getElementById("RaidDescTextArea").value =raidDescMsg;
					ClearAllRadioButtonsForRaidLayoutSelection();
					DisableAllRadioButtonsForRaidLayoutSelection()
					EnableAllValidRaidLayoutRadioButtons();
				}
				function ClearAllRadioButtonsForRaidLayoutSelection()
				{
					var elemNameForRaidLayout=getElementNameForRaidLayout();
					var RadioArray=document.getElementsByName(getElementNameForRaidLayout());
					for(var i=0; i&lt;RadioArray.length; i++)
					{
						RadioArray[i].checked = false;
					}
				}
				function EnableAllValidRaidLayoutRadioButtons()
				{
					var RadioArray=document.getElementsByName(getElementNameForRaidLayout());
					var prefix = "RadioButtonsForRaidLayoutSelection_";
					var layoutValue = "";
					var postfix = "_HIDDEN_TABLE_DATA";
					var elemName = "";
					for(var i=0; i&lt;RadioArray.length; i++)
					{
						layoutValue = RadioArray[i].value;
						elemName = prefix+layoutValue+postfix;
						if(document.getElementById(elemName) != null)
						{
							RadioArray[i].disabled = false;
						}
					}
				}
				function DisableAllRadioButtonsForRaidLayoutSelection()
				{
					var RadioArray=document.getElementsByName(getElementNameForRaidLayout());
					for(var i=0; i&lt;RadioArray.length; i++)
					{
							RadioArray[i].disabled = true;
					}
				}

				function EnableRaidSelectionRadioButtonsGivenRaidLayoutValue(layoutValue)
				{
					var prefix = "RadioButtonsForRaidLayoutSelection_";
					var postfix = "_HIDDEN_TABLE_DATA";
					var elemName =prefix+layoutValue+postfix;
					if(document.getElementById(elemName)!=null)
					{
						EnableRadioButtonForGivenRaidLayout(layoutValue);
					}
				}
				function EnableRadioButtonForGivenRaidLayout(layoutValue)
				{
					var elemName = getElementNameForRaidLayout();
					var RadioArray = document.getElementsByName(elemName);
					var len = RadioArray.length;
					for(var i=0;i&lt;len;i++)
					{
						if(layoutValue == RadioArray[i].value)
						{
							RadioArray[i].disabled = false;
							break;
						}
					}
				}
				function DisableRadioButtonForGivenRaidLayout(layoutValue)
				{
					var elemName = getElementNameForRaidLayout();
					var RadioArray = document.getElementsByName(elemName);
					var len = RadioArray.length;
					for(var i=0;i&lt;len;i++)
					{
						if(layoutValue == RadioArray[i].value)
						{
							RadioArray[i].disabled = true;
							break;
						}
					}
				}
				function IsRadioButtonEnabledForGivenRaidLayoutValue(layoutValue)
				{
					var elemName = getElementNameForRaidLayout();
					var RadioArray = document.getElementsByName(elemName);
					var len = RadioArray.length;
					for(var i=0;i&lt;len;i++)
					{
						if(layoutValue == RadioArray[i].value &amp;&amp; RadioArray[i].disabled == false)
						{
							return true;
						}
					}
					return false;
				}
				function UpdateRaidDescriptionTextBox(layoutValue)
				{
					document.getElementById("RaidDescTextArea").value = document.getElementById("getHelpText_"+layoutValue+"_HIDDEN_TABLE_DATA").value;
				}
				function setInputRaidLayoutValue(layoutValue)
				{
					var elemName = getElementNameForRaidLayout();
					var RadioArray = document.getElementsByName(elemName);
					var len = RadioArray.length;
					for(var i=0;i&lt;len;i++)
					{
						if(layoutValue == RadioArray[i].value)
						{
							RadioArray[i].checked = true;
							break;
						}
					}
				}
				function setInputVDNameField(nameStr)
				{
					var elemName = getElementNameForVDName();
					document.getElementById(elemName).value = nameStr;
				}
				function disableInputVDSizeField()
				{
					var elemName=getElementNameForVDSize();
					document.getElementById(elemName).disabled = true;
				}
				function enableInputVDSizeField()
				{
					var elemName=getElementNameForVDSize();
					document.getElementById(elemName).disabled = false;
				}
				function setInputVDSizeValue(value)
				{
					var elemName=getElementNameForVDSize();
					document.getElementById(elemName).value = value;
				}
				function setValueForMinField(minValue)
				{
					document.getElementById("Min").innerHTML = "<xsl:value-of select="$strMinSizeLabelCVDU"/>"+ getFormattedStringForMinMaxFields(minValue)+" <xsl:value-of select="$strGBUnitCVDU"/>" ;
				}
				function setValueForMaxField(maxValue)
				{
					document.getElementById("Max").innerHTML = "<xsl:value-of select="$strMaxSizeLabelCVDU"/>"+getFormattedStringForMinMaxFields(maxValue)+" <xsl:value-of select="$strGBUnitCVDU"/>";
				}
				function getPaddingStringForMinMaxFields(origString,fieldWidth)
				{
					var str = new String(origString);
					var len = str.length;
					var maxLen = fieldWidth;
					var paddingLen = maxLen - len;
					var paddingStr = "";
					for(var i=0;i &lt;paddingLen; i++)
					{
						<!-- &#160; is the escape character for &nbsp;-->
						<!--paddingStr  =paddingStr+ "&#160;"; -->
						paddingStr = paddingStr+"0";
					}
					return paddingStr;
				}
				function getFormattedStringForMinMaxFields(origString)
				{
					<!--String to be formatted can be categorized as follows; -->
					<!--a)Integers eg;  "500" etc with no decimal points-->
					<!--b)Floats with a integer part and a decimal part separated by a decimal point. eg;"1234.56", "0.56" -->
					<!--c)Floats with a integer part, no decimal part but have a decimal point. eg; "5." -->
					<!--d)Floats with a decimal part, no integet part but have a decimal point. e.g; ".39"-->
					<!--The above strings after formatting should look like follows "0500.00","1234.56","0000.56","0005.00","0000.39", -->
					<!--They have to be in 4.2 format-->
					<!--The idea is to separate the integer and decimal parts. Format the integer and decimal parts separately, then combine them as one whole string-->
					var formattedString="";
					var intPart="";
					var decPart="";
					var tmpArray = new String(origString).split(JS_GLOBAL_LocalDecSeparator);
					if(tmpArray.length == 1)<!--refer case a) above-->
					{
						intPart = getPaddingStringForMinMaxFields(tmpArray[0],4)+tmpArray[0];
						decPart = "00";
						formattedString = intPart+JS_GLOBAL_LocalDecSeparator+decPart;
					}
					else if(tmpArray.length==2)<!--refer case b,c,d above-->
					{
						intPart = getPaddingStringForMinMaxFields(tmpArray[0],4)+tmpArray[0];
						decPart = tmpArray[1]+getPaddingStringForMinMaxFields(tmpArray[1],2);
						formattedString = intPart+JS_GLOBAL_LocalDecSeparator+decPart;
					}
					else
					{
						formattedString=origString;
					}
					return formattedString;
				}
	</xsl:template>
	<xsl:template name="getScriptsForExpress">
				function getMinSizeForGivenLayout(layoutValue,units)
				{
					if(units=="BYTES")
					{
						var minStr = "getMinSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						var minValue = document.getElementById(minStr).value;
						return minValue;
					}
					if(units == "GB")
					{
						var minStr = "getMinSizeInGBFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						var minValue = document.getElementById(minStr).value;
						return minValue;
					}
					return "0";
				}
				function getMaxSizeForGivenLayout(layoutValue,units)
				{
					if(units=="BYTES")
					{
						var maxStr = "getMaxSizeInBytesFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						var maxValue = document.getElementById(maxStr).value;
						return maxValue;
					}
					if(units == "GB")
					{
						var maxStr = "getMaxSizeInGBFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
						var maxValue = document.getElementById(maxStr).value;
						return maxValue;
					}
					return "0";
				}
				function OnRaidLayoutSelected()
				{
					<!--This function is called when the raid type is selected by the user. Depending on the raid type chosen the Size field is updated, the max and min fields are updated as well/-->
					<!--The result table is updated to reflect the new set of array disks chosen for the raid type/-->
					<!--DFCT121856 - Express Wizard broken - vdisk min and max size is always zero. Need try catch blocks-->
					try
					{
						var layoutValue = getInputRaidLayoutValue();
						var isNameFieldAllowed = document.getElementById("isNameFieldAllowedForLayout_"+layoutValue+"_HIDDEN_TABLE_DATA").value;

						if(parseInt(isNameFieldAllowed) == 0)
						{
							document.getElementById("VDName").value="";<!-- clears existing value in name field-->
							document.getElementById("VDName").style.display="none";<!-- hides the name field edit box-->
							document.getElementById("VDName").disabled=true;
						}
						else
						{
							document.getElementById("VDName").style.display="";
							document.getElementById("VDName").disabled=false;
						}
					}
					catch(e){}

					<!--get min and max values in GB-->
					var minValue = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxValue = getMaxSizeForGivenLayout(layoutValue,"GB");

					<!--Set user input VD size field to max value-->
					setInputVDSizeValue(maxValue);
					if( getMinSizeForGivenLayout(layoutValue,"BYTES") == getMaxSizeForGivenLayout(layoutValue,"BYTES"))
					{
						setValueForMinField(maxValue);
						setValueForMaxField(maxValue);
						disableInputVDSizeField();
					}
					else
					{
						setValueForMinField(minValue);
						setValueForMaxField(maxValue);
						enableInputVDSizeField();
					}
					<!--Update Raid description text area-->
					UpdateRaidDescriptionTextBox(layoutValue);
				}
				function IsInputSizeForVDWithinRangeForExpress()
				{
					<!-- get selected raid layout value-->
					var layoutValue=getInputRaidLayoutValue();
					<!--get max size for selected raid layout in GB-->
					var minSize = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxSize = getMaxSizeForGivenLayout(layoutValue,"GB");

					if(  getMinSizeForGivenLayout(layoutValue,"BYTES") == getMaxSizeForGivenLayout(layoutValue,"BYTES"))					{
						minSize = maxSize;
					}
					<!--get input size value in GB-->
					var elemNameForSizeValue = getElementNameForVDSize();
					var sizeValue = getInputVDSizeValue();<!--parseFloat(document.getElementById(elemNameForSizeValue ).value);-->

					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var minSizeDecFormat = parseFloat(ConvertToDecValString(minSize));
					var maxSizeDecFormat = parseFloat(ConvertToDecValString(maxSize));

					<!--Do a range check-->
					if( sizeValueDecFormat &lt; minSizeDecFormat || sizeValueDecFormat &gt; maxSizeDecFormat )
					{
						return false;
					}
					return true;
				}
				function HandleInputSizeGreaterThanOsLimitExpress()
				{
					var sizeValue = getInputVDSizeValue();
					var osLimitValueinGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Oslimit div (1024*1024*1024), '###0.00')"/>";
					var sizeValueDecFormat = parseFloat(ConvertToDecValString(sizeValue));
					var osLimitValueDecFormat = parseFloat(ConvertToDecValString(osLimitValueinGB));

					if ( sizeValueDecFormat &gt; osLimitValueDecFormat)
					{
						<!-- This means that the virtual disk size is greater than the os limit-->
						if (confirm ("<xsl:value-of select="$strOsLimitWarn"/>"))
						{
							return true;
						}
						else
						{
							return false;
						}
					}
					else
					{
						return true;
					}
				}
				function HandleInputSizeRangeErrorForExpress()
				{
					var layoutValue=getInputRaidLayoutValue();
					var nameStr = "getMaxSizeFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
					var strMsg = "<xsl:value-of select="$strInvalidSizeMsgCVDU"/>";
					var strError = "<xsl:value-of select="$strError"/>";
					alert(strError + strMsg);
					document.getElementById(getElementNameForVDSize()).value=getMaxSizeForGivenLayout(layoutValue,"GB");
				}
				function ConvertInputSizeToBytesForExpress()
				{
					var layoutValue=getInputRaidLayoutValue();
					var inputSizeValue = getInputVDSizeValue();
					var minSizeInBytes = getMinSizeForGivenLayout(layoutValue,"BYTES");
					var maxSizeInBytes = getMaxSizeForGivenLayout(layoutValue,"BYTES");
					var minSizeInGB = getMinSizeForGivenLayout(layoutValue,"GB");
					var maxSizeInGB = getMaxSizeForGivenLayout(layoutValue,"GB");
					var outputSizeValueInBytes="";

					var maxSizeInGBDecFormat = ConvertToDecValString(maxSizeInGB);
					var minSizeInGBDecFormat = ConvertToDecValString(minSizeInGB);
					var inputSizeValueDecFormat = ConvertToDecValString(inputSizeValue);

					if(  minSizeInBytes == maxSizeInBytes)
					{
						outputSizeValueInBytes=maxSizeInBytes;
					}
					else if(parseFloat(maxSizeInGBDecFormat ) == parseFloat(inputSizeValueDecFormat ) )
					{
						outputSizeValueInBytes=maxSizeInBytes;
					}
					else if( parseFloat(minSizeInGBDecFormat ) ==parseFloat(inputSizeValueDecFormat ))
					{
						outputSizeValueInBytes=minSizeInBytes;
					}
					else
					{
						outputSizeValueInBytes=parseInt(inputSizeValueDecFormat *1024*1024*1024);
					<!--RS - DFCT134412: Check if the RAID size Boundary value in Express wizard falls betn getcaps max size and displayed size/-->
						if( outputSizeValueInBytes &gt; maxSizeInBytes )
							outputSizeValueInBytes = maxSizeInBytes;

					}
					return outputSizeValueInBytes;
				}
				function submitExpressCreateVD()
				{
					if(validate()==false)
						return;<!-- NOTE: Just "return" is used instead of "return false". This is intentional, using "return false" would cause HTML page to display a text "false" whenver validate fails(VISH:4/29/04)-->
					var Rules ="<xsl:value-of select="//Rules"/>";
					<!--This function is called when the submit button is selected in the express mode, this validates user input/-->

					var layoutValue=getInputRaidLayoutValue();

					<!--var sizeValue=ConvertInputSizeToBytesForGivenLayout(layoutValue);-->
					var sizeValue=ConvertInputSizeToBytesForExpress();

					<!--10/11/04. For DSA, if user selected size is equal to max size for the layout selected, set the flag to let web-plugin know to write VD size=max in raidcli script-->
					var isMaxSizeUsed="0";
					var maxSizeInBytes = getMaxSizeForGivenLayout(layoutValue,"BYTES");
					if(Rules == "1" &amp;&amp; maxSizeInBytes==sizeValue)
					{
						isMaxSizeUsed="1";
					}

					<!--Next get the name of the virtual disk-->
					var name="";
					if(Rules != "1")
					{
						name=getInputVDNameValue();
					}

					<!-- Fetch the DSA params -->
					var ParamClearForeignConfigEnable="<xsl:value-of select="//ClearForeignConfigEnable"/>";
					var ParamForeignAdiskFound="<xsl:value-of select="//ForeignAdiskFound"/>";

					<!--Next call the submit webplugin for DSA pass additional parameters-->
					if(Rules == "1" &amp;&amp; ParamClearForeignConfigEnable != null &amp;&amp; ParamForeignAdiskFound != null )
					{
						<!--Ashesh - CR54430: Values entered in the Raid configuration pages need to be cached-->
						<!--Ashesh: Flush the cache to make sure that the cache gets overwritten with new selection-->
    cachePageInDSA();
    document.getElementById("dataarea").action = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="//OrigURL"/>&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>"+"&amp;Layout="+layoutValue+"&amp;Length="+sizeValue+"&amp;VDName="+name+"&amp;Rules=<xsl:value-of select="//Rules"/>"+"&amp;DisplayVDConfig=<xsl:value-of select="//DisplayVDConfig"/>"+"&amp;OutputFileName=<xsl:value-of select="//OutputFileName"/>&amp;UseMaxSize="+isMaxSizeUsed+"&amp;Minosdrivesize=<xsl:value-of select="//Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="//Maxosdrivesize"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="//ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="//ForeignAdiskFound"/>");
    document.getElementById("dataarea").submit();
    return true;
    }
    else
    {
      document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDExpressSummaryWebPlugin&amp;OrigURL=<xsl:value-of select="//OrigURL"/>&amp;ControllerOID=<xsl:value-of select="//ControllerOID"/>&amp;ControllerName=<xsl:value-of select="//ControllerName"/>"+"&amp;Layout="+layoutValue+"&amp;Length="+sizeValue+"&amp;VDName="+name+"&amp;Rules=<xsl:value-of select="//Rules"/>"+"&amp;DisplayVDConfig=<xsl:value-of select="//DisplayVDConfig"/>"+"&amp;OutputFileName=<xsl:value-of select="//OutputFileName"/>&amp;UseMaxSize="+isMaxSizeUsed+"&amp;Minosdrivesize=<xsl:value-of select="//Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="//Maxosdrivesize"/>");
		}

				}
	</xsl:template>
	<xsl:template name="BitOr">
		<xsl:param name="num1"/>
		<xsl:param name="num2"/>
		<xsl:param name="result" select="0"/>
		<xsl:param name="pow2" select="1"/>
		<!--xsl:value-of select="'384'"/-->
		<xsl:message>BITOR: NEW ITERATION</xsl:message>
		<xsl:message>num1 is <xsl:value-of select="$num1"/></xsl:message>
		<xsl:message>num2 is <xsl:value-of select="$num2"/></xsl:message>
		<xsl:message>pow2 is <xsl:value-of select="$pow2"/></xsl:message>
		<xsl:message>result is <xsl:value-of select="$result"/></xsl:message>
		<xsl:choose>
			<xsl:when test="$num1 &lt; 1 and $num2 &lt; 1">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:when test="boolean($num1 mod 2) or boolean($num2 mod 2)">
				<xsl:call-template name="BitOr">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result + $pow2"/>
					<xsl:with-param name="pow2" select="$pow2 * 2"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="BitOr">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result"/>
					<xsl:with-param name="pow2" select="$pow2 * 2"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--Returns the bit of num1 in bit place num2-->
	<xsl:template name="BitCheck">
		<xsl:param name="num1"/>
		<xsl:param name="num2"/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="$num2=0">
				<xsl:value-of select="$num1 mod 2"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="BitCheck">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="$num2 - 1"/>
					<xsl:with-param name="result" select="$result"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--Returns the number of 1's in num1-->
	<xsl:template name="NumBits">
		<xsl:param name="num1"/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="$num1=0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:when test="($num1 mod 2) = '1'">
				<xsl:call-template name="NumBits">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="result" select="$result+1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="NumBits">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="result" select="$result"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
        
          <xsl:template name="GetNumberFromMask">
		<xsl:param name="num"/>
		<xsl:param name="count" select="0"/>
                <xsl:variable name="result">
                    <xsl:call-template name="Power">
			<xsl:with-param name="num1" select="2"/>
			<xsl:with-param name="num2" select="$count"/>
		    </xsl:call-template>
                </xsl:variable>    
		<xsl:choose>
			<xsl:when test="$result=$num">
				<xsl:value-of select="$count"/>
			</xsl:when>
			<xsl:when test="$count &lt; 31">
                            <xsl:call-template name="GetNumberFromMask">
					<xsl:with-param name="num" select="$num"/>
					<xsl:with-param name="count" select="$count + 1"/>
                            </xsl:call-template>
			</xsl:when>
                        <xsl:otherwise>0</xsl:otherwise>    
		</xsl:choose>
	</xsl:template>
        
		<!--Returns num1 to the power of num2-->
	<xsl:template name="Power">
		<xsl:param name="num1"/>
		<xsl:param name="num2"/>
		<xsl:param name="result" select="1"/>
		<xsl:choose>
			<xsl:when test="$num2=0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Power">
					<xsl:with-param name="num1" select="$num1"/>
					<xsl:with-param name="num2" select="$num2 - 1"/>
					<xsl:with-param name="result" select="$result * $num1"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--Uses busprotocol to get a protocol mask of all the protocols exisiting-->
	<xsl:template name="GetProtocolMask">
		<xsl:param name="nodes" select="/.."/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="not($nodes)">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="GetProtocolMask">
					<xsl:with-param name="nodes" select="$nodes[position() != 1]"/>
					<xsl:with-param name="result"><xsl:call-template name="BitOr">
						<xsl:with-param name="num1"><xsl:call-template name="Power">
							<xsl:with-param name="num1" select="2"/>
							<xsl:with-param name="num2"><xsl:value-of select="$nodes[1]"/></xsl:with-param></xsl:call-template></xsl:with-param>
						<xsl:with-param name="num2" select="$result"/>
					</xsl:call-template></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="getScriptsForAdvanced">
				function getElementNameForReadPolicy()
				{
					return "ReadPolicy";
				}
				function getElementNameForWritePolicy()
				{
					return "WritePolicy";
				}
				function getElementNameForCachePolicy()
				{
					return "CachePolicy";
				}
                                function getElementNameForDiskCachePolicy()
				{
					return "DiskCachePolicy";
				}
				function getElementNameForStripeSize()
				{
					return "StripeSize";
				}
				function getInputReadPolicyValue()
				{
					var elemName = getElementNameForReadPolicy();
					return document.getElementById(elemName).value;
				}
				function getInputWritePolicyValue()
				{
					var elemName = getElementNameForWritePolicy();
					return document.getElementById(elemName).value;
				}
				function getInputCachePolicyValue()
				{
					var elemName = getElementNameForCachePolicy();
					return document.getElementById(elemName).value;
				}
                                function getInputDiskCachePolicyValue()
				{
					var elemName = getElementNameForDiskCachePolicy();
					return document.getElementById(elemName).value;
				}
				function getInputStripeSizeValue()
				{
					var elemName = getElementNameForStripeSize();
					return document.getElementById(elemName).value;
				}
				function setStripeSize(defStripeSizeVal )
				{
					try
					{
						var elemName = getElementNameForStripeSize();
						var optionsArray=document.getElementById(elemName).options;
						for(var i=0; i &lt; optionsArray.length; i++)
						{
							if(defStripeSizeVal==optionsArray[i].value)
							{
								document.getElementById(elemName).selectedIndex=i;
								break;
							}
						}
					}catch(e){}
				}
				function setReadPolicy(defReadPolicy )
				{
					try
					{
						var elemName = getElementNameForReadPolicy();
						var optionsArray=document.getElementById(elemName).options;
						for(var i=0; i &lt; optionsArray.length; i++)
						{
							if(defReadPolicy==optionsArray[i].value)
							{
								document.getElementById(elemName).selectedIndex=i;
								break;
							}
						}
					}catch(e){}
				}
				function setWritePolicy(defWritePolicy )
				{
					try
					{
						var elemName = getElementNameForWritePolicy();
						var optionsArray=document.getElementById(elemName).options;
						for(var i=0; i &lt; optionsArray.length; i++)
						{
							if(defWritePolicy==optionsArray[i].value)
							{
								document.getElementById(elemName).selectedIndex=i;
								break;
							}
						}
					}catch(e){}
				}
				function setCachePolicy(defCachePolicy )
				{
					try
					{
							var elemName = getElementNameForCachePolicy();
							var optionsArray=document.getElementById(elemName).options;
							for(var i=0; i &lt; optionsArray.length; i++)
							{
								if(defCachePolicy==optionsArray[i].value)
								{
									document.getElementById(elemName).selectedIndex=i;
									break;
								}
							}
					}catch(e){}
				}
                                function setDiskCachePolicy(defDiskCachePolicy )
				{
					try
					{
							var elemName = getElementNameForDiskCachePolicy();
							var optionsArray=document.getElementById(elemName).options;
							for(var i=0; i &lt; optionsArray.length; i++)
							{
								if(defDiskCachePolicy==optionsArray[i].value)
								{
									document.getElementById(elemName).selectedIndex=i;
									break;
								}
							}
					}catch(e){}
				}

	</xsl:template>
</xsl:stylesheet>
