<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--The code below includes Utils.xsl which contains commonly called templates to get layout, read policy, write policy etc which can be resused/-->
	<xsl:include href="Utils.xsl"/>
	<!-- cvdutils.xsl contains reusable templates and javascript functions used by the express and advanced create virtual disk wizard-->
	<xsl:include href="cvdutils.xsl"/>
	<xsl:include href="dsautils.xsl"/>
	<xsl:key name="ADsForVD" match="//ArrayDisks" use="@LDN"/>
	<xsl:key name="VDs" match="//VirtualDisks" use="@ControllerName"/>
	
	<!-- Declare Global variables and parameters-->
	<xsl:variable name="GLOBAL_VAR_GetCapsSMStatus">
		<xsl:choose>
			<xsl:when test="//ExpressResults/SMStatus"><xsl:value-of select="//ExpressResults/SMStatus"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_IsAnyFreeAdiskAvailable">
		<xsl:choose>
			<xsl:when test="/OMA/ArrayDisks/DCStorageObject">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_IsAnyAdiskUninited">
		<xsl:choose>
			<xsl:when test="$GLOBAL_VAR_IsAnyFreeAdiskAvailable='1' and $GLOBAL_PARAM_Rules='1'">
				<xsl:call-template name="CheckForUnInitializedDisks">
					<xsl:with-param name="nodes" select="/OMA/ArrayDisks/DCStorageObject/Length"/>
					<xsl:with-param name="result" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise><!--If no array disks were found, set GLOBAL_VAR_IsAnyAdiskUninited value to zero, to indicate that no uninited disks were found -->
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_VAR_RaidLevelsMask"><xsl:value-of select="//Controllers/DCStorageObject/RAIDLevelsMask"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_FastInitMode"><xsl:value-of select="//Controllers/DCStorageObject/FastInitMode"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_NumVirtualDisks"><xsl:value-of select="count(//VirtualDisks/DCStorageObject)"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_MaxVirtualDiskNameLength"><xsl:value-of select="//Controllers/DCStorageObject/MaxNameLength"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Rules">
		<xsl:choose>
			<xsl:when test="/OMA/Rules"><xsl:value-of select="/OMA/Rules"/></xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ClearForeignConfigEnable">
		<xsl:choose>
			<xsl:when test="/OMA/ClearForeignConfigEnable">
				<xsl:value-of select="/OMA/ClearForeignConfigEnable"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IsAnyAdiskForeign">
		<xsl:choose>
			<xsl:when test="/OMA/ForeignAdiskFound">
				<xsl:value-of select="/OMA/ForeignAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_IsAnyAdiskRebuild">
		<xsl:choose>
			<xsl:when test="/OMA/RebuildAdiskFound">
				<xsl:value-of select="/OMA/RebuildAdiskFound"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="GLOBAL_PARAM_ControllerName"><xsl:value-of select="/OMA/ControllerName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_OutputFileName"><xsl:value-of select="/OMA/OutputFileName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_DisplayVDConfig"><xsl:value-of select="/OMA/DisplayVDConfig"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_OrigURL"><xsl:value-of select="/OMA/OrigURL"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_ControllerOID"><xsl:value-of select="/OMA/ControllerOID"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Layout"><xsl:value-of select="/OMA/Layout"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Length"><xsl:value-of select="/OMA/Length"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_VDName"><xsl:value-of select="/OMA/VDName"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_BusProtocol"><xsl:value-of select="//Controllers/DCStorageObject/BusProtocol"/></xsl:variable>
	<xsl:variable name="GLOBAL_VAR_IsAdvancedWizardButtonDisabled">
		<xsl:choose>
			<xsl:when test="contains($GLOBAL_PARAM_ControllerName,'PERC 4/im')">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Minosdrivesize"><xsl:value-of select="/OMA/Minosdrivesize"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Maxosdrivesize"><xsl:value-of select="/OMA/Maxosdrivesize"/></xsl:variable>

	<xsl:variable name="REGULAR_PARAMS">ControllerOID=<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$GLOBAL_PARAM_ControllerName"/>&amp;OrigURL=<xsl:value-of select="$GLOBAL_PARAM_OrigURL"/>&amp;Minosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Maxosdrivesize"/></xsl:variable>
	<xsl:variable name="DSA_PARAMS">Rules=<xsl:value-of select="$GLOBAL_PARAM_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$GLOBAL_PARAM_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$GLOBAL_PARAM_OutputFileName"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Screen_Name">cvdexp_<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/></xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Prev_Page_URL">
		<xsl:if test="$GLOBAL_PARAM_Rules ='1'">
			<xsl:choose>
				<xsl:when test="$GLOBAL_PARAM_IsAnyAdiskForeign='1'">/servlet/DataArea?plugin=com.dell.sm.webplugins.DSAClearForeignConfigWebPlugin&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/></xsl:when>
				<xsl:otherwise>/servlet/SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Exit_Wizard_URL">
		<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_Rules='1'">/servlet/DSASwitch?exitRAID=1</xsl:when>
			<xsl:otherwise><xsl:value-of select="translate($GLOBAL_PARAM_OrigURL,'!','&amp;')"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="GLOBAL_PARAM_Advanced_Wizard_URL">/servlet/DataArea?plugin=com.dell.sm.webplugins.CreateVDAdvancedRaidLayoutSelectionWebPlugin&amp;OrigURL=<xsl:value-of select="$GLOBAL_PARAM_OrigURL"/>&amp;ControllerOID=<xsl:value-of select="$GLOBAL_PARAM_ControllerOID"/>&amp;ControllerName=<xsl:value-of select="$GLOBAL_PARAM_ControllerName"/>&amp;Rules=<xsl:value-of select="$GLOBAL_PARAM_Rules"/>&amp;DisplayVDConfig=<xsl:value-of select="$GLOBAL_PARAM_DisplayVDConfig"/>&amp;OutputFileName=<xsl:value-of select="$GLOBAL_PARAM_OutputFileName"/>&amp;Minosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Minosdrivesize"/>&amp;Maxosdrivesize=<xsl:value-of select="$GLOBAL_PARAM_Maxosdrivesize"/>&amp;ClearForeignConfigEnable=<xsl:value-of select="$GLOBAL_PARAM_ClearForeignConfigEnable"/>&amp;ForeignAdiskFound=<xsl:value-of select="$GLOBAL_PARAM_IsAnyAdiskForeign"/></xsl:variable>

	<!--main entry point into this XSL,  /-->
	<xsl:template match="/">
		<!--Following situations need to be handled before launcing the express wizard-->
		<!--Situation One: GetCaps returns null because there is no array disk available with FreeSpace-->
		<!--Situation Two: GetCaps returns null because "Length" property for array disk is zero. 
			This happens on Adaptec controllers, when controller mode is changed from RAID to SCSI to RAID.
			The array disks needs to be inited from BIOS before it can be used as part of Virtual Disk-->
		<!--Situation Three: GetCaps returns non-null but some array disks on controller have "Length" property value as zero.
			This happens on Adaptec controllers, when controller mode is changed from RAID to SCSI to RAID.
			The user may not have inited all the arraydisks from the BIOS-->
		<!--Situation four: FAST init is disabled in the controller BIOS
			This situation should only be checked for in DSA mode -->
			
		<!--First check if there are any uninitialized arraydisks-->
		<!-- A value of zero indicates no uninitialized array disk were found. A nonzero value indicates that uninited disks were found-->
		<xsl:choose>
			<xsl:when test="$GLOBAL_VAR_IsAnyAdiskUninited != 0">
				<xsl:call-template name="HandleUninitedAdisks"/>
			</xsl:when>
			<xsl:when test="$GLOBAL_PARAM_Rules != '1' and $GLOBAL_VAR_GetCapsSMStatus='-1'">
					<!-- The current situation should never occur for DSA. DSA makes sure free disks are available before launching the wizard.-->
					<xsl:call-template name="HandleGetCapsFailureError"/>
			</xsl:when>
			<xsl:when test="//Controllers/DCStorageObject/FastInitMode and $GLOBAL_PARAM_Rules ='1' and $GLOBAL_VAR_FastInitMode='0'">
					<!--Check for the fast init tag and DSA mode and that the FAST init attribute is not set -->
					<xsl:call-template name="HandleFastInitModeDisabled"/>
			</xsl:when>
			<xsl:when test="$GLOBAL_PARAM_Rules = '1' and $GLOBAL_PARAM_IsAnyAdiskRebuild='1' and $GLOBAL_PARAM_BusProtocol='1' and $GLOBAL_VAR_IsAdvancedWizardButtonDisabled='0'">
					<!-- Devendra: DF63645. In DSA Mode if any of the drives is rebuilding and it is SCSI(except PERC 4im) we need to give an error page. BusProtocol =1 means SCSI & BusProtocol=8 means SAS.-->
					<xsl:call-template name="HandleAdiskRebuild"/>
			</xsl:when>
			<xsl:when test="$GLOBAL_PARAM_Rules = '1' and $GLOBAL_VAR_GetCapsSMStatus='-1'">
				<!-- DSA can invoke CreateVD thru' LaunchCreateVDWizard or DSAClearForeignConfig plugin. The error handling below handles latter situation. -->
					<xsl:call-template name="HandleDSAExpressGetCapsFailureError"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="RenderMainFrame"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="HandleUninitedAdisks">
		<DataArea exportdata="false" printable="false" email="false" ignoreJumpBar="false">
			<!--Handling DSA case-->
			<xsl:if test="$GLOBAL_PARAM_Rules ='1' ">
				<BottomCustomButton>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strRebootCVDE"/></xsl:attribute>
						<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.cdu.webplugins.CDUParentWebPlugin&amp;component=sysreboot</xsl:attribute>
					</Data>
				</BottomCustomButton>
			</xsl:if>
			<PageTitle status="4"><xsl:attribute name="display"><xsl:value-of select="$strPageTitleUnInitDiskCVDE"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/></xsl:attribute></PageTitle>
			<SubHeader display="{$strPossibleReasonsCVDE}"/>
			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strControllerModeChangeCVDE"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strPhysicalDisksMovedCVDE"/></xsl:attribute>
				</Data>
				<Data value=""/>
				<Data value="{$strInitDrivesFromBiosCVDE}" colspan="6" align="left"/>
			</ListData>
		</DataArea>
	</xsl:template>
	
	<xsl:template name="HandleDSAExpressGetCapsFailureError">
		<DataArea exportdata="false" printable="false" email="false" ignoreJumpBar="false">
			<script language="javascript">
			function backToDSAPageGetCapsFailureError()
			{
				document.getElementById("dataarea").action = top.getFrame("OMA_gnv").appendDataAreaVID("/servlet/SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin");
				document.getElementById("dataarea").submit();
				return true;
			}
			
			function backToDSACLRFGPageGetCapsFailureError()
			{
				document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.DSAClearForeignConfigWebPlugin&amp;<xsl:value-of select="$DSA_PARAMS"/>&amp;<xsl:value-of select="$REGULAR_PARAMS"/>");
			}
			
			function rebootDSAGetCapsFailureError()
			{
				document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("/servlet/DataArea?plugin=com.dell.cdu.webplugins.CDUParentWebPlugin&amp;component=sysreboot");
			}
			</script>
			<xsl:choose>
			<xsl:when test="$GLOBAL_PARAM_IsAnyAdiskForeign='1'">
				<BottomCustomButton>
					<Data display="{$strBackButtonDisplayCVDE}" formSubmit="true" href="javascript:backToDSACLRFGPageGetCapsFailureError()"/>
				</BottomCustomButton>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$GLOBAL_PARAM_Rules ='1'">
					<BottomCustomButton>
						<Data display="{$strBackButtonDisplayCVDE}" formSubmit="true" href="javascript:backToDSAPageGetCapsFailureError()"/>
					</BottomCustomButton>
				</xsl:if>
			</xsl:otherwise>
			</xsl:choose>

			<!--Handling DSA case-->
			<xsl:if test="$GLOBAL_PARAM_Rules ='1' ">
				<BottomCustomButton>
					<Data display="{$strRebootCVDE}" formSubmit="true" href="javascript:rebootDSAGetCapsFailureError()"/>
				</BottomCustomButton>
			</xsl:if>

			<PageTitle status="4"><xsl:attribute name="display"><xsl:value-of select="$strTitle2UnableToLaunchWizardCVDE"/> -<xsl:text>&#160;</xsl:text><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/></xsl:attribute></PageTitle>
			<SubHeader display="{$strPossibleReasonsCVDE}"/>
			<ListData>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strMinDrivesForRAIDCVDE"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strSASSATAPhysicalDrivesCVDE"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display">-</xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strFreeDisksUnavailableCVDE"/></xsl:attribute>
				</Data>
				<Data value=""/>
				<Data value="{$strAddPhysicalDrivesCVDE}" colspan="6" align="left"/>
			</ListData>
		</DataArea>
	</xsl:template>
	
	<xsl:template name="HandleFastInitModeDisabled">
		<DataArea exportdata="false" printable="false" email="false" ignoreJumpBar="false">
			<script language="javascript">
				function backToDSAPageFastInitError()
				{
					document.getElementById("dataarea").action = top.getFrame("OMA_gnv").appendDataAreaVID("/servlet/SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin");
					document.getElementById("dataarea").submit();
					return true;
				}
				
				function rebootDSAFastInitModeDisabled()
				{
					document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("/servlet/DataArea?plugin=com.dell.cdu.webplugins.CDUParentWebPlugin&amp;component=sysreboot");
				}
      		</script>
			<BottomCustomButton>
				<Data display="{$strBackButtonDisplayCVDE}" formSubmit="true" href="javascript:backToDSAPageFastInitError()"/>
			</BottomCustomButton>
			<BottomCustomButton>
				<Data display="{$strRebootCVDE}" formSubmit="true" href="javascript:rebootDSAFastInitModeDisabled()"/>
			</BottomCustomButton>
			<PageTitle status="4"><xsl:attribute name="display"><xsl:value-of select="$strPageTitleFastInitDisableCVDE"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/></xsl:attribute></PageTitle>
			<SubHeader status="4" display="{$strFastInitDisableCVDE}"/>
		</DataArea>	
	</xsl:template>


		<!-- Devendra: DF63645. In DSA Mode if any of the drives is rebuilding and it is SCSI we need to give an error page.-->
	
		<xsl:template name="HandleAdiskRebuild">
		<DataArea exportdata="false" printable="false" email="false" ignoreJumpBar="false">
			<script language="javascript">
				function backToDSAPageFastInitError()
				{
					document.getElementById("dataarea").action = top.getFrame("OMA_gnv").appendDataAreaVID("/servlet/SubmitForm?plugin=com.dell.cdu.webplugins.PreviousScreenWebPlugin");
					document.getElementById("dataarea").submit();
					return true;
				}
				
				function rebootDSAFastInitError()
				{
					document.location.href = top.getFrame("OMA_gnv").appendDataAreaVID("/servlet/DataArea?plugin=com.dell.cdu.webplugins.CDUParentWebPlugin&amp;component=sysreboot");
				}
			</script>

			<BottomCustomButton>
				<Data display="{$strBackButtonDisplayCVDE}" formSubmit="true" href="javascript:backToDSAPageFastInitError()"/>
			</BottomCustomButton>
				<BottomCustomButton>
					<Data display="{$strRebootCVDE}" formSubmit="true" href="javascript:rebootDSAFastInitError()"/>
				</BottomCustomButton>
			<PageTitle status="4"><xsl:attribute name="display"><xsl:value-of select="$strTitleUnableToLaunchWizardCVDE"/><xsl:text>&#160;</xsl:text><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/></xsl:attribute></PageTitle>
			<SubHeader status="4" display="{$strCVDRebuildCVDE}"/>
		</DataArea>	
	</xsl:template>
	

	<xsl:template name="HandleGetCapsFailureError">
		<DataArea exportdata="false" printable="false" email="false">
			<!--PageTitle display="{$strTitleFreeDisksUnavailableCVDE}"/-->
			<PageTitle display="{$strTitleUnableToLaunchWizardCVDE}"/>
			<SubHeader display="{$strFreeDisksUnavailableCVDE}"></SubHeader>
			<SubHeader display="{$strNoEnclosureAvailableCVDE}"></SubHeader>
			<SubHeader display="{$strMaxVDsReachedCVDE}"></SubHeader>
			<SubHeader display="{$strControllerBusyCVDE}"></SubHeader>
			<SubHeader display="{$strControllerRescanInProgressCVDE}"></SubHeader>
			
			<!--PromptText><xsl:value-of select="$strFreeDisksUnavailableCVDE"/></PromptText>
			<PromptText><xsl:value-of select="$strNoEnclosureAvailableCVDE"/></PromptText>
			<PromptText><xsl:value-of select="$strMaxVDsReachedCVDE"/></PromptText>
			<PromptText><xsl:value-of select="$strControllerBusyCVDE"/></PromptText>
			<PromptText><xsl:value-of select="$strControllerRescanInProgressCVDE"/></PromptText-->
			<BottomCustomButton>
				<Data formSubmit="true" display="{$strCancelCVDE}" href="{$GLOBAL_PARAM_Exit_Wizard_URL}"/>
			</BottomCustomButton>
		</DataArea>
	</xsl:template>
	<xsl:template name="CheckForUnInitializedDisks">
		<!-- Init nodes to empty node set-->
		<xsl:param name="nodes" select="/.."/>
		<xsl:param name="result" select="0"/>
		<xsl:choose>
			<xsl:when test="not($nodes)">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="value">
					<xsl:choose>
						<xsl:when test="$nodes[1] > 0">0</xsl:when>
						<xsl:otherwise>1</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="CheckForUnInitializedDisks">
					<xsl:with-param name="nodes" select="$nodes[position() != 1]"/>
					<xsl:with-param name="result" select="$result+$value"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="RenderBottomCustomButtons">
		<!-- Render the "Continue" button followed by the "Exit Wizard" button in that order-->
		<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
		<!-- Removing the back buttons as they are handled in DataArea for DSA  caching -->
		
		<BottomCustomButton>
			<Data formSubmit="true" display="{$strContinueCVDE}" href="javascript:submitExpressCreateVD() "/>
		</BottomCustomButton>
		<BottomCustomButton>
			<Data formSubmit="true" display="{$strCancelCVDE}">
				<xsl:attribute name="href">
					<xsl:choose>
						<!-- We use the DSA caching javascript function to exit the wizard in case of DSA. -->
						<xsl:when test="$GLOBAL_PARAM_Rules ='1'">javascript:exitWizardInDSA();</xsl:when>
						<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>
		</BottomCustomButton>	
	</xsl:template>
		
	<xsl:template name="RenderCustomButtons">
		<xsl:if test="$GLOBAL_VAR_IsAdvancedWizardButtonDisabled !='1'">
		<CustomButton align="left">
			<Data>
				<xsl:attribute name="href">
					<xsl:choose>
						<!-- We use the DSA caching javascript function to go to the advanced wizard in case of DSA. -->
						<xsl:when test="$GLOBAL_PARAM_Rules ='1'">javascript:advancedWizardInDSA();</xsl:when>
						<xsl:otherwise><xsl:value-of select="$GLOBAL_PARAM_Advanced_Wizard_URL"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strAdvancedCVDE"/></xsl:attribute>
			</Data>
		</CustomButton>
		</xsl:if>
	</xsl:template>
	<xsl:template name="RenderMainFrame">
		<!-- Ashesh: DF63251: Pressing Enter key clears selected RAID level in configuration wizard. -->
		<!-- Added nosubmitfordsa attribute to disable <Enter> key -->
		<DataArea onLoad="true" validate="true" exportdata="false" email="false" printable="false" nosubmitfordsa="true" ignoreJumpBar="true">
			<xsl:if test="$GLOBAL_PARAM_Rules ='1'">
				<!-- CR54430: Values entered in the Raid configuration pages need to be cached -->
				<!-- In DSA mode, we want to enable the DSA caching mechanism so storeonback and screenname are defined. -->
				<xsl:attribute name="storeonback">true</xsl:attribute>
				<xsl:attribute name="screenname"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:attribute>
				
				<!-- OMSS does not have a back button but OMSS Lite does. We use the DSA caching javascript function. -->
				<xsl:attribute name="custombackpagedisplay"><xsl:value-of select="$strBackButtonDisplayCVDE"/></xsl:attribute> 
				<xsl:attribute name="backpagetarget">javascript:goToPreviousPageInDSA();</xsl:attribute>
			</xsl:if>
	
			<script language="javascript">
				
				function initializationRoutine()
				{
					commonInitializationRoutine();
					setValueForMinField("");
					setValueForMaxField("");
					UpdateWithUserSelectedInputs();

					<!-- DSA uses different function to append VID -->
					var Rules = "<xsl:value-of select="$GLOBAL_PARAM_Rules"/>";
					if (Rules == "1")
					{
						top.gnv.appendVID = top.getFrame("OMA_gnv").appendDataAreaVID;
					}
				}
				
				function UpdateWithUserSelectedInputs()
				{
					<!-- Need to see if anything special needs to be done for DSA here-->
					var raidFlag = "false";
					var sizeFlag = "false";
					var UserSelectedLayoutValue = "";
	
					UserSelectedLayoutValue = '<xsl:value-of select="$GLOBAL_PARAM_Layout"/>';
					if(UserSelectedLayoutValue !="null" &amp;&amp; UserSelectedLayoutValue !="" )
					{
						<!-- Make sure the user selected raid layout is still valid after page load.(when back button on wizard is used)-->
						if(IsRadioButtonEnabledForGivenRaidLayoutValue(UserSelectedLayoutValue ) == true)
						{
							raidFlag = "true";
						}
						else
						{
							var alertStrCfgChng = "<xsl:value-of select="$strCfgChngDetectCVDE"/>";
							var alertStrInvalidRaid = "<xsl:value-of select="$strRaidSelectionInvalidCVDE"/>";
							var alertStrReselectRaid = "<xsl:value-of select="$strReselectRaidTypeCVDE"/>";
							var alertStrRaidCfgChange = alertStrCfgChng+"\n"+alertStrInvalidRaid+"\n"+alertStrReselectRaid;
							alert(alertStrRaidCfgChange);
							return;
						}
					}
					else
					{
						return;
					}
					
					var minValue = getMinSizeForGivenLayout(UserSelectedLayoutValue ,"BYTES");
					var maxValue = getMaxSizeForGivenLayout(UserSelectedLayoutValue ,"BYTES");
					var userInputSizeValue = "";
					userInputSizeValue ='<xsl:value-of select="$GLOBAL_PARAM_Length"/>';
					if(userInputSizeValue != "null" &amp;&amp; userInputSizeValue !="" )
					{
						<!--Make sure the user input size is still valid after page load.(when back button on wizard is used)-->
						if( parseInt(minValue) &gt; parseInt(userInputSizeValue) || parseInt(userInputSizeValue) &gt; parseInt(maxValue) )
						{
							var alertStrCfgChng = "<xsl:value-of select="$strCfgChngDetectCVDE"/>";
							var alertStrInvalidSize = "<xsl:value-of select="$strSizeSelectionInvalidCVDE"/>";
							var alertStrReselectSize = "<xsl:value-of select="$strReselectSizeCVDE"/>";
							var alertStrSizeCfgChange = alertStrCfgChng+"\n"+alertStrInvalidSize +"\n"+alertStrReselectSize;
							alert(alertStrSizeCfgChange);
							return;
						}
						else
						{
							sizeFlag = "true";
						}
					}
					
					if( raidFlag == "true" &amp;&amp; sizeFlag == "true" )
					{
						<!--First set the raid layout -->
						setInputRaidLayoutValue(UserSelectedLayoutValue );
						OnRaidLayoutSelected();
						<!--Next set the size-->
						var sizeInGB = "<xsl:value-of select="format-number($GLOBAL_PARAM_Length div (1024*1024*1024), '###0.00')"/>";
						setInputVDSizeValue(sizeInGB );



						var Rules = "<xsl:value-of select="$GLOBAL_PARAM_Rules"/>";
						<!-- then set the name field--><!-- For DSA name field is not applicable-->
						if(Rules != "1")
						{
							var VDName = '<xsl:value-of select="$GLOBAL_PARAM_VDName"/>';
							setInputVDNameField(VDName);
					}
					}
				}
				function validate()
				{
					var Rules = "<xsl:value-of select="$GLOBAL_PARAM_Rules"/>";

					if(IsRaidLayoutSelected()==false)
					{
						HandleRaidLayoutNotSelectedError();
						return false;
					}
					if(IsInputSizeForVDSpecified()==false)
					{
						HandleInputSizeNotSpecifiedError();
						RestoreInputSizeFieldToMaxValueInExpWizard();
						return false;
					}
					if(IsInputSizeForVDNaN()==true)
					{
						HandleInputSizeNotANumberError();
						RestoreInputSizeFieldToMaxValueInExpWizard();
						return false;
					}
					if(IsInputSizeForVDWithinRangeForExpress()==false)
					{	
						HandleInputSizeRangeErrorForExpress();
						return false;
					}
					if(Rules==0 &amp;&amp; isValidName(getInputVDNameValue())==false)
					{
						RestoreInputNameFieldToBlank();
						return false;
					}
					if ( HandleInputSizeGreaterThanOsLimitExpress() == false )
					{
						return false;
					}
					return true;
				}
				function RestoreInputSizeFieldToMaxValueInExpWizard()
				{
					var layoutValue=getInputRaidLayoutValue();
					var nameStr = "getMaxSizeFor_Layout_"+layoutValue+"_HIDDEN_TABLE_DATA";
					document.getElementById(getElementNameForVDSize()).value=getMaxSizeForGivenLayout(layoutValue,"GB");
				}
			</script>
			<xsl:call-template name="scripts"/><!--includes scripts from utils.xsl...This is to invoke isNameValid(text) function to test VD name input -->
			<script language="javascript">
				<xsl:call-template name="getCommonScripts"/>
				<xsl:if test="$GLOBAL_PARAM_Rules='1'">
					<!-- Include the DSA caching scripts if OMSS Lite mode. Specify relevant parameters to the template. -->
					<xsl:call-template name="getDSAScripts">
						<xsl:with-param name="PARAM_Screen_Name"><xsl:value-of select="$GLOBAL_PARAM_Screen_Name"/></xsl:with-param>
						<xsl:with-param name="PARAM_Prev_Page_URL"><xsl:value-of select="$GLOBAL_PARAM_Prev_Page_URL"/></xsl:with-param>
						<xsl:with-param name="PARAM_Exit_Wizard_URL"><xsl:value-of select="$GLOBAL_PARAM_Exit_Wizard_URL"/></xsl:with-param>
					</xsl:call-template>

					function advancedWizardInDSA()
					{
						cachePageInDSA();
						document.dataarea.action = top.getFrame("OMA_gnv").appendDataAreaVID("<xsl:value-of select="$GLOBAL_PARAM_Advanced_Wizard_URL"/>");
						document.dataarea.submit();
					}
				</xsl:if>
				<xsl:call-template name="getScriptsForExpress"/>
			</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitleMainStartCVDE"/><xsl:value-of select="$GLOBAL_PARAM_ControllerName"/><xsl:value-of select="$strTitleMainEndCVDE"/></xsl:attribute>
			</PageTitle>
			
			<xsl:call-template name="RenderBottomCustomButtons"/>
			<xsl:call-template name="RenderCustomButtons"/>
			
			<!--Below is displayed only on DSA screens-->
			<xsl:if test="$GLOBAL_PARAM_DisplayVDConfig='true' and $GLOBAL_VAR_NumVirtualDisks != 0">
				<xsl:call-template name="RenderVDConfigTable">
					<xsl:with-param name="CONTROLLER_NAME"><xsl:value-of select="//VirtualDisks/@ControllerName"/></xsl:with-param>
					<xsl:with-param name="KEY_NAME_VDNODES">VDs</xsl:with-param>
					<xsl:with-param name="KEY_MATCH_VDNODES"><xsl:value-of select="//VirtualDisks/@ControllerName"/></xsl:with-param>
					<xsl:with-param name="KEY_NAME_ADNODES">ADsForVD</xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="RenderCreateVDTable">
				<xsl:with-param name="RAIDMask"><xsl:value-of select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:with-param>
				<xsl:with-param name="SELECT_RAID_HEADER"><xsl:value-of select="$strTblHeaderCVDE"/></xsl:with-param>
				<xsl:with-param name="VD_NAME_LENGTH"><xsl:value-of select="$GLOBAL_VAR_MaxVirtualDiskNameLength"/></xsl:with-param>
				<xsl:with-param name="RULES"><xsl:value-of select="$GLOBAL_PARAM_Rules"/></xsl:with-param>
				<!-- For DSA do not show the name field-->
				<xsl:with-param name="HIDE_NAME_ROW">
					<xsl:choose>
						<xsl:when test="$GLOBAL_PARAM_Rules='1' ">true</xsl:when>
						<xsl:otherwise>false</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
			</xsl:call-template>
			<HiddenTable>
				<!--This creates a hidden table that maps a "raid layout type" to the "max size possible" for that layout/-->
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMaxSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMinSizeInBytesForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMaxSizeInGBForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getMinSizeInGBForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="getHelpText_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="AvailableRaidLayout_HIDDEN_TABLE"/></xsl:for-each>
				<xsl:for-each select="//ExpressResults/DCStorageObject"><xsl:call-template name="isNameFieldAllowedForGivenLayoutType_HIDDEN_TABLE"/></xsl:for-each>
			</HiddenTable>
		</DataArea>
	</xsl:template>
	<xsl:template name="isNameFieldAllowedForGivenLayoutType_HIDDEN_TABLE">
		<!--This hidden table makes it easier for javascript functions to display and retrieve values dynamically/--><!-- fix for DFCT 120553-->
		<Data type="hidden">
			<xsl:attribute name="name">isNameFieldAllowedForLayout_<xsl:value-of select="Layout"/>_HIDDEN_TABLE_DATA</xsl:attribute>
			<xsl:attribute name="returnvalue">
				<xsl:call-template name="bitAnd">
					<xsl:with-param name="num1">
						<xsl:choose>
							<xsl:when test="not(//Controllers//DCStorageObject/VdiskNameAllowedForRaidLevelMask)">
								<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="$GLOBAL_VAR_RaidLevelsMask"/></xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="ConvertBinaryToDecimal"><xsl:with-param name="BinaryStr" select="//Controllers/DCStorageObject/VdiskNameAllowedForRaidLevelMask"/>		</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
					<xsl:with-param name="num2" select="Layout"/>
				</xsl:call-template>
			</xsl:attribute>
		</Data>
	</xsl:template>
</xsl:stylesheet>
