<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- CONTROLLER TABLE HEADER -->
	<xsl:template name="ControllerTableHeader">
		<xsl:param name="tasks"/>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Data name="Id" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Status" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
		</Data>
		<Data name="ID" editable="false" type="ustring" ignoreoncli="true">
			<xsl:attribute name="display"><xsl:value-of select="$strID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strID"/></xsl:attribute>
		</Data>
		<Data name="Name" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strName"/></xsl:attribute>
		</Data>
		<Data name="SlotID" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strSlotID"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSlotID"/></xsl:attribute>
		</Data>
		<Data name="State" editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
		</Data>
		
		<xsl:if test="//FirmwareVer or $dynamicView = 'false'">
			<Data name="FW" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strFW"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strFW"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//RequiredFirmwareVersion or $dynamicView = 'false'">
			<Data name="ReqFW" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strReqFW"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strReqFW"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//CurrentDriverVersion or $dynamicView = 'false'">
			<Data name="Dvr" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strDvr"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strDvr"/></xsl:attribute>
			</Data>
		</xsl:if>
		<xsl:if test="//RequiredDriverVersion or $dynamicView = 'false'">
			<Data name="ReqFW" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strReqDvr"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strReqDvr"/></xsl:attribute>
			</Data>
		</xsl:if>
		<Data name="NumChannels" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strNumChannels"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strNumChannels"/></xsl:attribute>
		</Data>
		<Data name="RbldRate" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strRebuildRate"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strRebuildRate"/></xsl:attribute>
		</Data>
		<Data name="BGIRate" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strBGIRate"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strBGIRate"/></xsl:attribute>
		</Data>
		<Data name="CheckConsistencyRate" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strChkConsistencyRate"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strChkConsistencyRate"/></xsl:attribute>
		</Data>
		<Data name="ReconstructRate" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strReconstructRate"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strReconstructRate"/></xsl:attribute>
		</Data>
    <Data name="AlarmState" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strAlarmState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAlarmState"/></xsl:attribute>
		</Data>
		<Data name="ClusterMode" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strClusterMode"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strClusterMode"/></xsl:attribute>
		</Data>
		<Data name="ScsiTgId" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strScsiTgId"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strScsiTgId"/></xsl:attribute>
		</Data>
		<Data name="CacheSize" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strCacheSize"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCacheSize"/></xsl:attribute>
		</Data>
		<Data name="PatReadMode" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadMode"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPatrolReadMode"/></xsl:attribute>
		</Data>
		<Data name="PatReadState" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadState"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPatrolReadState"/></xsl:attribute>
		</Data>
		<Data name="PatReadRate" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadRate"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPatrolReadRate"/></xsl:attribute>
		</Data>
		<Data name="PatReadIterations" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strPatrolReadIterations"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strPatrolReadIterations"/></xsl:attribute>
		</Data>

		<Data name="AbortCheckConsistencyOnError" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strAbortCConError"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAbortCConError"/></xsl:attribute>
		</Data>
		<Data name="Copyback" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strCopyback"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strCopyback"/></xsl:attribute>
		</Data>

		<Data name="AutoCopybackOnPredictiveFailure" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strSmarterErrorDisk"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strSmarterErrorDisk"/></xsl:attribute>
		</Data>
		<Data name="Loadbalance" editable="false" type="ustring" ignoreonweb="true">
			<xsl:attribute name="display"><xsl:value-of select="$strLoadBalancing"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strLoadBalancing"/></xsl:attribute>
		</Data>

		
		<!--xsl:if test="$tasks='true'">
			<Data name="Delete" editable="false" type="ustring">
				<xsl:attribute name="display"><xsl:value-of select="$strTasks"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strTasks"/></xsl:attribute>
			</Data-->
		<!-- The Rows have one extra row for the execute button.  Including a blank <Data> tag here keeps the line that underlines the headers continuous -->
		<Data/>
		<!--/xsl:if-->
	</xsl:template>
	<!-- CONTROLLER TABLE ROWS -->
	<xsl:template name="ControllerTableRows">
	<xsl:param name="ObjID">
		<xsl:call-template name="ModNexus">
			<xsl:with-param name="nexus">
				<xsl:value-of select="Nexus"/>
			</xsl:with-param>
		</xsl:call-template>
        </xsl:param>
		<xsl:param name="tasks"/>
		<xsl:variable name="isCluster">
			<xsl:if test="substring(AttributesMask,32,1)!='0'">true</xsl:if>
		</xsl:variable>
		<xsl:variable name="dynamicView">
			<xsl:choose>
				<xsl:when test="/OMA/@cli = 'true' ">false</xsl:when>
				<xsl:otherwise>true</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<Row>
			<Data type="ustring" align="center" ignoreonweb="true">
				<xsl:attribute name="value"><xsl:value-of select="GlobalNo"/></xsl:attribute>
			</Data>
			<Data type="status" align="center">
				<xsl:attribute name="value"><xsl:value-of select="ObjStatus"/></xsl:attribute>
			</Data>
			<Data ignoreoncli="true">
				<xsl:attribute name="value"><xsl:value-of select="GlobalNo"/></xsl:attribute>
			</Data>
			<Data name="Name" editable="false" type="ustring" display="Test" link="true">
				<xsl:attribute name="value"><xsl:value-of select="Name"/></xsl:attribute>
				<xsl:attribute name="href">javascript:newSelect('<xsl:value-of select="$ObjID"/>')</xsl:attribute>
			</Data>
			<Data>
				<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="PCISlot and PCISlot !=''">
						<xsl:choose>
							<xsl:when test="PCISlot = '-1' or PCISlot = '2147483648' or PCISlot = '0' ">
								<xsl:value-of select="$strEmbedded"/>
							</xsl:when>
							<xsl:when test="PCISlot = '2147483649' ">
								<xsl:value-of select="$strNoSlot"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strPCI"/><xsl:value-of select="PCISlot"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$strNoSlot"/></xsl:otherwise>
				</xsl:choose>
				</xsl:attribute>
			</Data>
			<Data name="State" editable="false" type="ustring" display="Test">
				<xsl:attribute name="value"><xsl:call-template name="GetState"><xsl:with-param name="state"><xsl:value-of select="ObjState"/></xsl:with-param></xsl:call-template></xsl:attribute>
			</Data>
			<xsl:if test="//FirmwareVer or $dynamicView = 'false'">
				<Data>
					<xsl:attribute name="value"><xsl:choose><xsl:when test="FirmwareVer"><xsl:choose><xsl:when test="FirmwareVer = '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="FirmwareVer"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="//RequiredFirmwareVersion or $dynamicView = 'false'">
				<Data>
					<xsl:attribute name="value"><xsl:choose><xsl:when test="RequiredFirmwareVersion"><xsl:choose><xsl:when test="RequiredFirmwareVersion= '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="RequiredFirmwareVersion"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="//CurrentDriverVersion or $dynamicView = 'false'">
				<Data>
					<xsl:attribute name="value"><xsl:choose><xsl:when test="CurrentDriverVersion"><xsl:choose><xsl:when test="CurrentDriverVersion = '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="CurrentDriverVersion"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
				</Data>
			</xsl:if>
			<xsl:if test="//RequiredDriverVersion or $dynamicView = 'false'">
				<Data>
					<xsl:attribute name="value"><xsl:choose><xsl:when test="RequiredDriverVersion"><xsl:choose><xsl:when test="RequiredDriverVersion= '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="RequiredDriverVersion"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
				</Data>
			</xsl:if>
			<Data name="NumChannels" editable="false" type="ustring" ignoreonweb="true">
				<xsl:choose>
					<xsl:when test="Channels">
						<xsl:attribute name="value"><xsl:value-of select="Channels"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNotAvailable"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>

			<Data name="RbldRate" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="display"><xsl:value-of select="$strRebuildRate"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:choose><xsl:when test="count(RebuildRate)>0"><xsl:choose><xsl:when test="RebuildRate = '(null)' "><xsl:value-of select="$strUnknown"/></xsl:when><xsl:otherwise><xsl:value-of select="RebuildRate"/>%</xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="$strNotApplicable"/></xsl:otherwise></xsl:choose></xsl:attribute>
			</Data>

			<!--BGI Rate - if BGIRate tag exists, then display the value. Else display N/A -->
			<Data name="BGIRate" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="BGIRate"><xsl:value-of select="BGIRate"/>%</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

			<!--Check Consistency Rate - if CheckConsistencyRate tag exists, then display the value. Else display N/A -->
			<Data name="CheckConsistencyRate" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="CheckConsistencyRate"><xsl:value-of select="CheckConsistencyRate"/>%</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

			<!--Reconstruct Rate - if ReconstructionRate tag exists, then display the value. Else display N/A -->
			<Data name="ReconstructRate" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="ReconstructRate"><xsl:value-of select="ReconstructRate"/>%</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

      <!--Alarm State - If xmltag AlarmState is  defined in controller xml, then call GetAlarmState template with AlarmState as the parameter-->
			<!--Otherwise, call GetControllerAlarm with CurrentMethodMask as the paarmeter-->
			<Data name="Alarm" editable="false" type="ustring" ignoreonweb="true">
				<xsl:choose>
					<xsl:when test="AlarmState">
						<xsl:attribute name="value">
							<xsl:call-template name="GetAlarmState"><xsl:with-param name="state"><xsl:value-of select="AlarmState"/></xsl:with-param></xsl:call-template>									</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value">
							<xsl:call-template name="GetControllerAlarm"><xsl:with-param name="MethodValue"><xsl:value-of select="CurrentMethodMask"/></xsl:with-param></xsl:call-template>							</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</Data>
			
			<!--ClusterMode - If xmltag ClusterMode is  defined in controller xml, then call GetClusterMode template-->
			<!--ClusterMode - Otherwise, use isCluster variable which looks at controller's AttribMask tag-->
			<Data name="ClusterMode" editable="false" type="ustring" ignoreonweb="true">
				<xsl:choose>
					<xsl:when test="ClusterMode">
						<xsl:attribute name="value">
							<xsl:call-template name="GetClusterMode"><xsl:with-param name="mode"><xsl:value-of select="ClusterMode"/></xsl:with-param></xsl:call-template>
						</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$isCluster='true'">
									<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
									<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</Data>

			<Data name="ScsiTgId" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="TargetID"><xsl:value-of select="TargetID"/></xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

			<!--Cache Size - if CacheSize tag exists, then display cache size. Else display N/A -->
			<Data name="CacheSize" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="CacheSize"><xsl:value-of select="CacheSize"/> MB</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

			<!--Patrol Read Mode - check if PatrolReadMode tag exists. If yes, call GetPatrolReadMode template. Display N/A otherwise-->
			<Data name="PatReadMode" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="PatrolReadMode">
							<xsl:call-template name="GetPatrolReadMode"><xsl:with-param name="mode"><xsl:value-of select="PatrolReadMode"/></xsl:with-param></xsl:call-template>
						</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

			<!--Patrol Read State - check if PatrolReadState tag exists. If yes, call GetPatrolReadState template. Display N/A otherwise-->
			<Data name="PatReadState" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="PatrolReadState">
							<xsl:call-template name="GetPatrolReadState"><xsl:with-param name="state"><xsl:value-of select="PatrolReadState"/></xsl:with-param></xsl:call-template>
						</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

			<!--Patrol Read Rate - if PatrolReadRate tag exists, then display the value. Else display N/A -->
			<Data name="PatReadRate" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="PatrolReadRate"><xsl:value-of select="PatrolReadRate"/>%</xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

			<!--Patrol Read Iterations - if PatrolReadIterations tag exists, then display the value. Else display N/A -->
			<Data name="PatReadIterations" editable="false" type="ustring" ignoreonweb="true">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="PatrolReadIterations"><xsl:value-of select="PatrolReadIterations"/></xsl:when>
						<xsl:otherwise>	<xsl:value-of select="$strNotApplicable"/></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</Data>

      <Data name="AbortCheckConsistencyOnError" editable="false" type="ustring" ignoreonweb="true">
           <xsl:attribute name="value">
        <xsl:choose>
          <xsl:when test="AbortCheckConsistencyOnError">
              <xsl:call-template name="CLIGetAbortCConError">
                <xsl:with-param name="state">
                  <xsl:value-of select="AbortCheckConsistencyOnError"/>
                </xsl:with-param>
              </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
                 <xsl:value-of select="$strNotApplicable"/>
          </xsl:otherwise>
        </xsl:choose>
            </xsl:attribute>
      </Data>


      <Data name="Copyback" editable="false" type="ustring" ignoreonweb="true">
           <xsl:attribute name="value">
        <xsl:choose>
          <xsl:when test="Copyback">
              <xsl:call-template name="CLIGetCopyback">
                <xsl:with-param name="state">
                  <xsl:value-of select="Copyback"/>
                </xsl:with-param>
              </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
                 <xsl:value-of select="$strNotApplicable"/>
          </xsl:otherwise>
        </xsl:choose>
            </xsl:attribute>
      </Data>

      <Data name="AutoCopybackOnPredictiveFailure" editable="false" type="ustring" ignoreonweb="true">
           <xsl:attribute name="value">
        <xsl:choose>
          <xsl:when test="AutoCopybackOnPredictiveFailure">
              <xsl:call-template name="CLIGetSmarter">
                <xsl:with-param name="state">
                  <xsl:value-of select="AutoCopybackOnPredictiveFailure"/>
                </xsl:with-param>
              </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
                 <xsl:value-of select="$strNotApplicable"/>
          </xsl:otherwise>
        </xsl:choose>
            </xsl:attribute>
      </Data>


      <Data name="Loadbalance" editable="false" type="ustring" ignoreonweb="true">
           <xsl:attribute name="value">
        <xsl:choose>
          <xsl:when test="Loadbalance">
              <xsl:call-template name="CLIGetLoadbalance">
                <xsl:with-param name="state">
                  <xsl:value-of select="Loadbalance"/>
                </xsl:with-param>
              </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
                 <xsl:value-of select="$strNotApplicable"/>
          </xsl:otherwise>
        </xsl:choose>
            </xsl:attribute>
      </Data>



		</Row>
	</xsl:template>
</xsl:stylesheet>
