<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the xsl page to set controller rate attributes.  The associated web plugin is the ControllerExecWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>

	<xsl:variable name="rateType">
		<xsl:choose>
			<xsl:when test="/OMA/Action = '8192'">
				<xsl:value-of select="$strRateTypeBGI"/>
			</xsl:when>
			<xsl:when test="/OMA/Action = '16384'">
				<xsl:value-of select="$strRateTypeChkCon"/>
			</xsl:when>
			<xsl:when test="/OMA/Action = '65536'">
				<xsl:value-of select="$strRateTypeReconstr"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="changeRateType">
		<xsl:choose>
			<xsl:when test="/OMA/Action = '8192'">
				<xsl:value-of select="$strChangeRateTypeBGI"/>
			</xsl:when>
			<xsl:when test="/OMA/Action = '16384'">
				<xsl:value-of select="$strChangeRateTypeChkCon"/>
			</xsl:when>
			<xsl:when test="/OMA/Action = '65536'">
				<xsl:value-of select="$strChangeRateTypeReconstr"/>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>


	<!-- The java webplugin keys off the actiontype -->
	<xsl:variable name="actionType">
		<xsl:choose>
			<xsl:when test="/OMA/Action = '8192'">bgirate</xsl:when>
			<xsl:when test="/OMA/Action = '16384'">checkconsistencyrate</xsl:when>
			<xsl:when test="/OMA/Action = '65536'">reconstructrate</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:template match="OMA">

		<xsl:call-template name="scripts"/>
		<DataArea printable="false" email="false" validate="true" Refresh="false" exportdata="false" onLoad="true">
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=<xsl:value-of select="$actionType"/>&amp;help=cnprin&amp;</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strApply"/></xsl:attribute>

			<xsl:variable name="dfltBkPg">/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:variable >
			<xsl:attribute name="backpagedisplayfull"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			<xsl:attribute name="backpagetarget"><xsl:call-template name="BackPage"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>

			<PageTitle>
				<xsl:attribute name="display">
					<xsl:value-of select="ControllerName"/><xsl:value-of select="$strColon"/><xsl:value-of select="$strSpace"/> <xsl:value-of select="$changeRateType"/>
				</xsl:attribute>
			</PageTitle>

			<PromptText>
				<xsl:choose>
					<xsl:when test="Action = '8192'">
						<xsl:value-of select="$strSubBGIHeader1"/>
					</xsl:when>
					<xsl:when test="Action = '16384'">
						<xsl:value-of select="$strSubChkConHeader1"/>
					</xsl:when>
					<xsl:when test="Action = '65536'">
						<xsl:value-of select="$strSubReconstrHeader1"/>
					</xsl:when>
				</xsl:choose>
			</PromptText>

			<xsl:call-template name="CtrlAttribRate"/>
		</DataArea>
	</xsl:template>
	<xsl:template name="CtrlAttribRate">

		<!-- Create string depending on rate -->
		<xsl:variable name="strCurrentRate">
			<xsl:choose>
				<xsl:when test="/OMA/Action = '8192'">
					<xsl:value-of select="$strCurrBGI"/>
				</xsl:when>
				<xsl:when test="/OMA/Action = '16384'">
					<xsl:value-of select="$strCurrCheck"/>
				</xsl:when>
				<xsl:when test="/OMA/Action = '65536'">
					<xsl:value-of select="$strCurrRec"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<!-- Create string depending on rate -->
		<xsl:variable name="strNewRate">
			<xsl:choose>
				<xsl:when test="/OMA/Action = '8192'">
					<xsl:value-of select="$strNewBGI"/>
				</xsl:when>
				<xsl:when test="/OMA/Action = '16384'">
					<xsl:value-of select="$strNewCheck"/>
				</xsl:when>
				<xsl:when test="/OMA/Action = '65536'">
					<xsl:value-of select="$strNewRec"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>


		<ComboData>
			<ListData>
				<xsl:variable name="showtasks">false</xsl:variable>

				<Data name="currentrate" editable="false" type="ustring" align="right">
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentRate"/><xsl:value-of select="$strColon"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="/OMA/Rate"/></xsl:attribute>
					<xsl:attribute name="unit"> %</xsl:attribute>
				</Data>

				<Data name="newrate" type="editbox" maxlength="3" size="3" align="right">
					<xsl:attribute name="display">
						<xsl:value-of select="$strNewRate"/><xsl:value-of select="$strNewRateVal"/><xsl:value-of select="$strColon"/>									</xsl:attribute>
					<xsl:attribute name="value"/>
					<xsl:attribute name="unit"> %</xsl:attribute>
				</Data>

			</ListData>
		</ComboData>
		<script language="javascript">
		function initializationRoutine()
		{
			document.getElementById("newrate").focus();
			return;
		}

		function validate()
		{
			var text = document.getElementById("newrate").value;
			var inputval = document.dataarea.newrate.value;
			var oldval = '<xsl:value-of select="/OMA/Rate"/>';

      inputval = removeLeadingZeros(inputval);

      // check that this isn't zero.
      if (text.length &lt; 1)
			{
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strErrorNumeric"/>");
					return false;
			}

			if( /^[0-9]*$/.test(text))
			{  //make sure it's a number you are dealing with
				if( text > 100 || 0 > text )
				{  //make sure the # is not greater than 100 or less than 0
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strErrorNumeric"/>");
					document.getElementById("newrate").value = "";
					document.getElementById("newrate").focus();
					return false;
				}
				else
				{
					// make sure the new value and old value are different
					if ( inputval == oldval)
					{
						alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strErrorEqual"/>");
						document.getElementById("newrate").value = "";
						document.getElementById("newrate").focus();
						return false;
					}
					else
					{
						disableButtons("submit","back" ,"");
						return true;
					}
				}
			}
			else
			{
					alert("<xsl:value-of select="$strError"/>"  + "<xsl:value-of select="$strErrorNumeric"/>");
					document.getElementById("newrate").value = "";
					document.getElementById("newrate").focus();
					return false;
			}
		}

	</script>

	</xsl:template>
</xsl:stylesheet>
