<?xml version="1.0" encoding="UTF-8"?>
<!-- This is the XSL to render the Virtual Disks Information page.  The associated web plugin is the VDInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="vdtbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:template match="OMA">
		<DataArea printable="false" email="false" validate="false" Refresh="false" export="false" exportdata="false">
			<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ControllerExecWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;Action=exportlog&amp;help=cnprin</xsl:attribute>
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strExpLog"/></xsl:attribute>

			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><xsl:value-of select="/*/VirtualDisks/@ControllerName"/><xsl:value-of select="$strTitlePart2"/></xsl:attribute>
			</PageTitle>

			<PromptText ignoreoncli="true">
				<xsl:value-of select="$strSubHeader"/>
			</PromptText>

			<PromptText ignoreoncli="true">
				<xsl:value-of select="ServerHostName"/>
			</PromptText>

			<PromptText ignoreoncli="true">
				<xsl:value-of select="LoggingPath/DCStorageObject/LoggingPath"/>
			</PromptText>

			<xsl:call-template name="Export"/>

		</DataArea>

	</xsl:template>
	<xsl:template name="Export">
		<BottomCustomButton>
			<Data>
				<xsl:variable name="dfltBkPg">/servlet/DataArea?plugin=com.dell.sm.webplugins.ControllerInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="ControllerOID"/>&amp;ControllerName=<xsl:value-of select="ControllerName"/>&amp;help=cnprin</xsl:variable >
				<xsl:attribute name="href"><xsl:call-template name="BackPage"><xsl:with-param name="defaultBackPage" select="$dfltBkPg"/></xsl:call-template></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="$strPrevPage"/></xsl:attribute>
			</Data>
		</BottomCustomButton>
	</xsl:template>
</xsl:stylesheet>
