<!-- This is the XSL to render the Controller Information page.  The associated web plugin is the ControllerInfoWebPlugin. -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="chnltbl.xsl"/>
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="encltbl.xsl"/>
	<xsl:template match="OMA">
		<xsl:variable name="checkAdmin">
			<xsl:choose>
				<xsl:when test="OMAUserRights = '7'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<DataArea>
		<xsl:call-template name="scripts"/>
			<script language="javascript">
			function onExecute(oid, channame) {
				var action = document.getElementById('Chtasks').value;
				if (action == '-') {
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
        }
        else if (action == '1') { //rescan
          document.location.href = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.sm.webplugins.ConfirmChanRescanWebPlugin&amp;ControllerOID=<xsl:value-of select="ID"/>&amp;ChannelOID=<xsl:value-of select="CHID"/>&amp;ChannelName=" + channame + "&amp;Action=rescan&amp;help=chprin");
				}
				else {
					alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strSelectValidTask"/>");
				}
			}
		</script>
			<PageTitle>
				<xsl:attribute name="display"><xsl:choose><xsl:when test="substring(/*/Channels/DCStorageObject/AttributesMask,26,1)='1'"><xsl:value-of select="$strTitleLogicalPart1"/></xsl:when><xsl:otherwise><xsl:value-of select="$strTitle1Part1"/></xsl:otherwise></xsl:choose><xsl:value-of select="/*/Channels/DCStorageObject/Channel"/><xsl:value-of select="$strTitle1Part2"/><xsl:value-of select="$strTitle1Part3"/><xsl:value-of select="/*/Channels/@ControllerName"/><xsl:value-of select="$strTitle1Part4"/></xsl:attribute>
			</PageTitle>
			<CustomButton>
			<!-- The refresh button cannot use the below javascript to perform the refresh.  The issue is the  javascript calls the last webplug which was called
			      to render this page.  The problem is that the page can be rendered by two webplugins: the info webplugin and the action execute web plugin.
			      If the action execute webplugin was the last webplugin to render the page, pressing refresh would cause that action to be re-executed. -->
				<!--Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">#</xsl:attribute>
					<xsl:attribute name="onclick">javascript:location.reload ()</xsl:attribute>
				</Data-->
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ChannelInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/CHID"/>&amp;Action=none&amp;help=chprin</xsl:attribute>
				</Data>
			</CustomButton>
			<xsl:apply-templates select="Channels/DCStorageObject">
				<xsl:with-param name="tasks">
					<xsl:value-of select="$checkAdmin"/>
				</xsl:with-param>
			</xsl:apply-templates>
		</DataArea>
	</xsl:template>
	<xsl:template match="Channels/DCStorageObject">
		<xsl:param name="tasks"/>
		<ComboData ignoreJumpBar="true">
			<ListData>
				<xsl:variable name="showtasks">
					<xsl:value-of select="$tasks"/>
				</xsl:variable>
				<SubHeader>
					<xsl:attribute name="display"><xsl:value-of select="$strSubHeader1"/></xsl:attribute>
					<xsl:attribute name="status"><xsl:value-of select="ObjStatus"/></xsl:attribute>
				</SubHeader>
				<xsl:call-template name="ChannelList">
					<xsl:with-param name="tasks" select="$showtasks"/>
				</xsl:call-template>
			</ListData>
			
			<!-- Check if Path Health is applicable (is connector in multipath) -->
			<xsl:if test="substring(AttributesMask,26,1)='1'">
				<TableData columnspacing="false">
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader5"/></xsl:attribute>
					</SubHeader>
					<xsl:call-template name="PathHealthTable"/>
				</TableData>
			</xsl:if>

			<xsl:if test="count(../../Enclosures)>0">
				<TableData columnspacing="true">
					<xsl:variable name="showtasks">false</xsl:variable>
					<SubHeader>
						<xsl:attribute name="display"><xsl:value-of select="$strSubHeader4"/></xsl:attribute>
					</SubHeader>
					<Header>
						<xsl:call-template name="EnclosureTableHeader">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</Header>
					<xsl:for-each select="../../Enclosures/DCStorageObject">
						<xsl:call-template name="EnclosureTableRows">
							<xsl:with-param name="tasks" select="$showtasks"/>
						</xsl:call-template>
					</xsl:for-each>
				</TableData>
			</xsl:if>
		</ComboData>
	</xsl:template>
</xsl:stylesheet>
