<!-- 
Confirm page for AD actions: online/offline/prepare to remove.  The associated web plugin is the ConfirmADActionWebPlugin. 
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- Include some common templates created by SS -->
	<xsl:import href="Utils.xsl"/>
	<xsl:import href="adtbl.xsl"/>
	<xsl:template match="OMA">
		<DataArea exportdata="false" email="false" printable="false">
			<xsl:attribute name="validate">true</xsl:attribute>
			
			<!-- We needed the ability to disable (hide) the bottom buttons when a user executes an action (DFCT117103) -->
			<!-- but we currently only have the ability to hide the submit, cancel, and back buttons.  Since this page only -->
			<!-- uses the cancel and submit buttons, I have changed the <BottomCustomButton> for Blink to be a cancel -->
			<!-- button as a way to hide it when the user selects submit.  This will need to change when the framework allows -->
			<!-- other buttons to be disabled.   - Michael Regert, 06/15/04 -->
			<xsl:variable name="CanBlink">
				<xsl:call-template name="CanADBlink">
					<xsl:with-param name="Mask"><xsl:value-of select="/OMA/ArrayDisks/DCStorageObject/CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$CanBlink='1'">
				<xsl:attribute name="cancel">true</xsl:attribute>
				<xsl:attribute name="canceldisplay"><xsl:value-of select="$strBlink"/></xsl:attribute>
				<xsl:attribute name="canceltarget">
					<xsl:choose>
						<xsl:when test="/OMA/VDMemberPage = 'true'">/servlet/DataArea?plugin=com.dell.sm.webplugins.ADBlinkBeforeActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ADiskOID=<xsl:value-of select="/OMA/ADiskOID"/>&amp;Action=<xsl:value-of select="/OMA/Action"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;BackTo=<xsl:value-of select="/OMA/BackToKey"/>&amp;VDMemberPage=<xsl:value-of select="/OMA/VDMemberPage"/>&amp;RaidLayout=<xsl:value-of select="/OMA/RaidLayout"/>&amp;Force=false&amp;help=adprin</xsl:when>
						<xsl:otherwise>/servlet/DataArea?plugin=com.dell.sm.webplugins.ADBlinkBeforeActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ADiskOID=<xsl:value-of select="/OMA/ADiskOID"/>&amp;Action=<xsl:value-of select="/OMA/Action"/>&amp;help=adprin</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:if>
			<!-- DFCT139174 - GUI: Incorrect Prepare to Remove page for Hard Disks connected to NRS channel -->
			<!-- Indravijay J. Gohil Using conditionals on  non raid drives to see which title/headers/button id's to use-->
			<xsl:variable name="nonRaid">
				<xsl:call-template name="IsObjectNonRaid">
					<xsl:with-param name="Mask">
						<xsl:value-of select="ArrayDisks/DCStorageObject/AttributesMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$nonRaid = '1' ">
					<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel2"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="/OMA/VDMemberPage = 'true'">
							<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.ArrayWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;RaidLayout=<xsl:value-of select="/OMA/RaidLayout"/>&amp;help=adprin</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
					<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;help=adprin</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strCancel"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="/OMA/VDMemberPage = 'true'">
							<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.ArrayWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;RaidLayout=<xsl:value-of select="/OMA/RaidLayout"/>&amp;help=adprin</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
					<xsl:attribute name="backpagetarget">/servlet/DataArea?plugin=com.dell.sm.webplugins.ADInfoWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;help=adprin</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>			
			<!-- Setting strings on XML page that varies depending on what the action is -->
			<xsl:variable name="warningtitle">
					<xsl:choose>
						<xsl:when test="/OMA/Action = 64">
							<!-- online -->
							<xsl:value-of select="$strOnlineWarningTitle"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 128">
							<!-- offline -->
							<xsl:value-of select="$strOfflineWarningTitle"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 256">
							<!-- prepare to remove -->
							<!-- DFCT139368 - GUI: Incomplete Warning and pop up when a disk is prepared for removal -->
							<!-- Indravijay J. Gohil Adding in the word adisk/hdisk as part of the remove adisk message -->
							<xsl:choose>
								<xsl:when test="$nonRaid = '1' ">
									<xsl:value-of select="$strPrepareWarningTitleHard"/>	
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$strPrepareWarningTitle"/>			
								</xsl:otherwise>
							</xsl:choose>						
						</xsl:when>
						<xsl:when test="/OMA/Action = 65536">
							<!-- clear -->
							<xsl:value-of select="$strClearWarningTitle"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 131072">
							<!-- cancel clear -->
							<xsl:value-of select="$strCancelClearWarningTitle"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 16">
							<!-- assign ghs -->
							<xsl:value-of select="$strGHSWarningTitle"/>
						</xsl:when>
					</xsl:choose>
			</xsl:variable>

			<xsl:variable name="areyousure">
					<xsl:choose>
						<xsl:when test="/OMA/Action = 64">
							<!-- online -->
							<xsl:value-of select="$strRUSureOnline"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 128">
							<!-- offline -->
							<xsl:value-of select="$strRUSureOffline"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 16">
							<!-- assign ghs -->
							<xsl:value-of select="$strRUSureGHS"/>
						</xsl:when>						
						<xsl:when test="/OMA/Action = 256">
							<!-- prepare to remove -->
							<!-- DFCT139368 - GUI: Incomplete Warning and pop up when a disk is prepared for removal -->
							<!-- Indravijay J. Gohil Adding in the word adisk/hdisk as part of the remove adisk message -->
							<xsl:choose>
								<xsl:when test="$nonRaid = '1' ">
									<xsl:value-of select="$strRUSurePrepareHard"/>	
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$strRUSurePrepare"/>			
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="/OMA/Action = 65536">
							<!-- clear -->
							<xsl:value-of select="$strRUSureClear"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 131072">
							<!-- cancel clear -->
							<xsl:value-of select="$strRUSureCancelClear"/>
						</xsl:when>
					</xsl:choose>
			</xsl:variable>
			
			<xsl:variable name="strAction">
					<xsl:choose>
						<xsl:when test="/OMA/Action = 64">
							<!-- online -->
							<xsl:value-of select="$strOnline"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 128">
							<!-- offline -->
							<xsl:value-of select="$strOffline"/>
						</xsl:when>
						<xsl:when test="/OMA/Action = 16">
							<!-- assign ghs -->
							<xsl:value-of select="$strGHS"/>
						</xsl:when>						
						<xsl:when test="/OMA/Action = 256">
							<!-- prepare to remove -->
							<!-- DFCT139368 - GUI: Incomplete Warning and pop up when a disk is prepared for removal -->
							<!-- Indravijay J. Gohil Adding in the word adisk/hdisk as part of the remove adisk message -->
							<xsl:choose>
								<xsl:when test="$nonRaid = '1' ">
									<xsl:value-of select="$strPrepareHard"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$strPrepare"/>		
								</xsl:otherwise>
							</xsl:choose>	
						</xsl:when>
						<xsl:when test="/OMA/Action = 65536">
							<!-- clear -->
							<xsl:value-of select="$strClear"/>		
						</xsl:when>
						<xsl:when test="/OMA/Action = 131072">
							<!-- cancel clear -->
							<xsl:value-of select="$strCancelClear"/>		
						</xsl:when>
					</xsl:choose>
			</xsl:variable>
			
			<!-- End setting strings -->

			<xsl:attribute name="submit">
				<xsl:choose>
					<xsl:when test="/OMA/VDMemberPage = 'true'">/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ADExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=<xsl:value-of select="/OMA/ADiskOID"/>&amp;ADiskName=<xsl:value-of select="/OMA/ADiskName"/>&amp;Action=<xsl:value-of select="/OMA/Action"/>&amp;VirtualDiskOID=<xsl:value-of select="/OMA/VirtualDiskOID"/>&amp;VirtualDiskName=<xsl:value-of select="/OMA/VirtualDiskName"/>&amp;BackTo=<xsl:value-of select="/OMA/BackToKey"/>&amp;VDMemberPage=<xsl:value-of select="/OMA/VDMemberPage"/>&amp;Force=false&amp;help=adprin</xsl:when>
					<xsl:otherwise>/servlet/SubmitForm?plugin=com.dell.sm.webplugins.ADExecuteActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ControllerName=<xsl:value-of select="/OMA/ControllerName"/>&amp;ADiskOID=<xsl:value-of select="/OMA/ADiskOID"/>&amp;ADiskName=<xsl:value-of select="/OMA/ADiskName"/>&amp;Action=<xsl:value-of select="/OMA/Action"/>&amp;Force=false&amp;help=adprin</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>			
			<xsl:attribute name="submitdisplay"><xsl:value-of select="$strAction"/></xsl:attribute>


			<PageTitle alert="true" status="3">
				<xsl:attribute name="display"><xsl:value-of select="$strTitlePart1"/><!--xsl:value-of select="ArrayDisks/@VirtualDiskName"/--><xsl:value-of select="$warningtitle"/></xsl:attribute>
			</PageTitle>


		<TableData name="Test1" display="Test2" columnspacing="true">
			<xsl:variable name="showtasks">false</xsl:variable>
			<!-- DFCT139174 - GUI: Incorrect Prepare to Remove page for Hard Disks connected to NRS channel -->
			<!-- Indravijay J. Gohil Using conditionals on  non raid drives to see which title/headers/button id's to use-->
			<xsl:choose>
				<xsl:when test="$nonRaid = '1' ">
					<!--SubHeader display="{$strHardDisk}" /-->
						<Header>
							<xsl:call-template name="ArrayDiskTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
							</xsl:call-template>
						</Header>
						<!-- should be only one array disk -->
						<xsl:for-each select="ArrayDisks/DCStorageObject">
						<xsl:call-template name="ArrayDiskTableRows">
						<xsl:with-param name="tasks">false</xsl:with-param>
						<xsl:with-param name="expanded">true</xsl:with-param>
				 		</xsl:call-template>
 						</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<!--SubHeader display="{$strArrayDisk}" /-->
						<Header>
							<xsl:call-template name="ArrayDiskTableHeader">
							<xsl:with-param name="tasks">false</xsl:with-param>
							<xsl:with-param name="expanded">true</xsl:with-param>
							</xsl:call-template>
						</Header>
						<!-- should be only one array disk -->
						<xsl:for-each select="ArrayDisks/DCStorageObject">
						<xsl:call-template name="ArrayDiskTableRows">
						<xsl:with-param name="tasks">false</xsl:with-param>
						<xsl:with-param name="expanded">true</xsl:with-param>
				 		</xsl:call-template>
 						</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
			
		</TableData>



			<!-- check if can blink first. -->
			<!-- We needed the ability to disable (hide) the bottom buttons when a user executes an action (DFCT117103) -->
			<!-- but we currently only have the ability to hide the submit, cancel, and back buttons.  Since this page only -->
			<!-- uses the cancel and submit buttons, I have changed the <BottomCustomButton> for Blink to be a cancel -->
			<!-- button as a way to hide it when the user selects submit.  This will need to change when the framework allows -->
			<!-- other buttons to be disabled.   - Michael Regert, 06/15/04 -->
			<!--xsl:variable name="CanBlink">
				<xsl:call-template name="CanADBlink">
					<xsl:with-param name="Mask"><xsl:value-of select="/OMA/ArrayDisks/DCStorageObject/CurrentMethodMask"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			
			<xsl:if test="$CanBlink='1'">
					<BottomCustomButton>
						<Data>
							<xsl:attribute name="href">/servlet/DataArea?plugin=com.dell.sm.webplugins.ADBlinkBeforeActionWebPlugin&amp;ControllerOID=<xsl:value-of select="/OMA/ControllerOID"/>&amp;ChannelOID=<xsl:value-of select="/OMA/ChannelOID"/>&amp;EnclosureOID=<xsl:value-of select="/OMA/EnclosureOID"/>&amp;ADiskOID=<xsl:value-of select="/OMA/ADiskOID"/>&amp;Action=<xsl:value-of select="/OMA/Action"/>&amp;help=adprin";</xsl:attribute>
							<xsl:attribute name="display"><xsl:value-of select="$strBlink"/></xsl:attribute>
						</Data>
					</BottomCustomButton>
			</xsl:if-->


			<script language="javascript">
			function validate() 
			{
				// Validate doesn't need to validate any data, but just needs to prompt the user
				// to verify the want to continue with the delete.  confirm( ) will return true when
				// the user selects OK and false when the user selects CANCEL.				
				var warnmsg = "<xsl:value-of select="$areyousure"/>";
				var canBlink = <xsl:value-of select="$CanBlink"/>;
				var cfrm = confirm(warnmsg);
		                if(cfrm)
				{
					if (canBlink == 1)
					{
						disableButtons("submit","back" ,"cancel");
					}
					else
					{
						disableButtons("submit","back" ,"");
					}
				}					
				return (cfrm);
			}				
		</script>
		
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
