<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template name="GetRaidLayout">
		<xsl:param name="RaidType"/>
		<xsl:choose>
			<xsl:when test="$RaidType='1'">
				<xsl:value-of select="$strRAIDC"/>
			</xsl:when>
			<xsl:when test="$RaidType='2'">
				<xsl:value-of select="$strRAID0"/>
			</xsl:when>
			<xsl:when test="$RaidType='4'">
				<xsl:value-of select="$strRAID1"/>
			</xsl:when>
			<xsl:when test="$RaidType='64'">
				<xsl:value-of select="$strRAID5"/>
			</xsl:when>
				<xsl:when test="$RaidType='128'">
				<xsl:value-of select="$strRAID6"/>
			</xsl:when>
			<xsl:when test="$RaidType='512'">
				<xsl:value-of select="$strRAID10"/>
			</xsl:when>
			<xsl:when test="$RaidType='1024'">
				<xsl:value-of select="$strRAID30"/>
			</xsl:when>
			<xsl:when test="$RaidType='2048'">
				<xsl:value-of select="$strRAID50"/>
			</xsl:when>
			<xsl:when test="$RaidType='262144'">
				<xsl:value-of select="$strRAID60"/>
			</xsl:when>
			<xsl:when test="$RaidType='4096'">
				<xsl:value-of select="$strRAID1C"/>
			</xsl:when>
			<xsl:when test="$RaidType='8192'">
				<xsl:value-of select="$strRAID5C"/>
			</xsl:when>
			<xsl:when test="$RaidType='16384'">
				<xsl:value-of select="$strNoRAID"/>
			</xsl:when>
			<xsl:when test="$RaidType='32768'">
				<xsl:value-of select="$strVolume"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetCLIRaidLayoutValue">
		<xsl:param name="RaidType"/>
		<xsl:choose>
			<xsl:when test="$RaidType='1'">
				<!--XLATESTART-->c<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='2'">
				<!--XLATESTART-->r0<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='4'">
				<!--XLATESTART-->r1<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='64'">
				<!--XLATESTART-->r5<!--XLATESTOP-->
			</xsl:when>
      <xsl:when test="$RaidType='128'">
        <!--XLATESTART-->r6<!--XLATESTOP-->
      </xsl:when>
      <xsl:when test="$RaidType='512'">
				<!--XLATESTART-->r10<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='1024'">
				<!--XLATESTART-->r30<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='2048'">
				<!--XLATESTART-->r50<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='4096'">
				<!--XLATESTART-->r1c<!--XLATESTOP-->
			</xsl:when>
			<xsl:when test="$RaidType='8192'">
				<!--XLATESTART-->r5c<!--XLATESTOP-->
			</xsl:when>
      <xsl:when test="$RaidType='262144'">
        <!--XLATESTART-->r60<!--XLATESTOP-->
      </xsl:when>
      <xsl:otherwise>
				<!--XLATESTART-->UnKnown<!--XLATESTOP-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetRaidLayoutValue">
		<xsl:param name="RaidDescription"/>
		<xsl:choose>
			<xsl:when test="$RaidDescription='Concatenated'">1</xsl:when>
			<xsl:when test="$RaidDescription='RAID-0'">2</xsl:when>
			<xsl:when test="$RaidDescription='RAID-1'">4</xsl:when>
			<xsl:when test="$RaidDescription='RAID-5'">64</xsl:when>
			<xsl:when test="$RaidDescription='RAID-6'">128</xsl:when>
			<xsl:when test="$RaidDescription='RAID-10'">512</xsl:when>
			<xsl:when test="$RaidDescription='RAID-30'">1024</xsl:when>
			<xsl:when test="$RaidDescription='RAID-50'">2048</xsl:when>
			<xsl:when test="$RaidDescription='RAID-60'">262144</xsl:when>
			<xsl:when test="$RaidDescription='RAID-1-Concatenated'">4096</xsl:when>
			<xsl:when test="$RaidDescription='RAID-5-Concatenated'">8192</xsl:when>
			<xsl:otherwise>-1</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetSpareInfoForArrayDisk">
		<xsl:param name="AttribsMask"/>
		<xsl:choose>
			<xsl:when test="$AttribsMask='0'">
				<xsl:value-of select="$strNo"/>
			</xsl:when>
			<xsl:when test="$AttribsMask='128'">
				<xsl:value-of select="$strGlobalHS"/>
			</xsl:when>
			<xsl:when test="$AttribsMask='256'">
				<xsl:value-of select="$strDedHS"/>
			</xsl:when>
			<xsl:when test="substring($AttribsMask,25,1)='1'">
				<xsl:value-of select="$strGlobalHS"/>
			</xsl:when>
			<xsl:when test="substring($AttribsMask,24,1)='1'">
				<xsl:value-of select="$strDedHS"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNo"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetReadPolicy">
		<xsl:param name="readpolicy"/>
		<xsl:choose>
			<xsl:when test="$readpolicy='1'">
				<xsl:value-of select="$strReadCEnabled"/>
			</xsl:when>
			<xsl:when test="$readpolicy='2'">
				<xsl:value-of select="$strReadCDisabled"/>
			</xsl:when>
			<xsl:when test="$readpolicy='4'">
				<xsl:value-of select="$strReadAhead"/>
			</xsl:when>
			<xsl:when test="$readpolicy='8'">
				<xsl:value-of select="$strAdapReadAhead"/>
			</xsl:when>
			<xsl:when test="$readpolicy='16'">
				<xsl:value-of select="$strNoReadAhead"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetWritePolicy">
		<xsl:param name="writepolicy"/>
		<xsl:choose>
			<xsl:when test="$writepolicy='1'">
				<xsl:value-of select="$strWriteCEnabled"/>
			</xsl:when>
			<xsl:when test="$writepolicy='2'">
				<xsl:value-of select="$strWriteCDisabled"/>
			</xsl:when>
			<xsl:when test="$writepolicy='4'">
				<xsl:value-of select="$strWriteBack"/>
			</xsl:when>
			<xsl:when test="$writepolicy='8'">
				<xsl:value-of select="$strWriteThrough"/>
			</xsl:when>
			<xsl:when test="$writepolicy='16'">
				<xsl:value-of select="$strWriteAlways"/>
			</xsl:when>
			<xsl:when test="$writepolicy='32'">
				<xsl:value-of select="$strForceWriteBack"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetCachePolicy">
		<xsl:param name="cachepolicy"/>
		<xsl:choose>
			<xsl:when test="$cachepolicy='1'">
				<xsl:value-of select="$strDirectIO"/>
			</xsl:when>
			<xsl:when test="$cachepolicy='2'">
				<xsl:value-of select="$strCacheIO"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:template name="GetDiskCachePolicy">
		<xsl:param name="DiskCachePolicy"/>
		<xsl:choose>
			<xsl:when test="$DiskCachePolicy='1'">
				<xsl:value-of select="$strEnabled"/>
			</xsl:when>
			<xsl:when test="$DiskCachePolicy='2'">
				<xsl:value-of select="$strDisabled"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$DiskCachePolicy"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>



	<xsl:template name="GetStripeSize">
		<xsl:param name="stripesize"/>
		<xsl:choose>
			<xsl:when test="$stripesize='0'">
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:when>
			<xsl:when test="$stripesize='1'">
				<xsl:value-of select="$str512B"/>
			</xsl:when>
			<xsl:when test="$stripesize='2'">
				<xsl:value-of select="$str1KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='4'">
				<xsl:value-of select="$str2KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='8'">
				<xsl:value-of select="$str4KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='16'">
				<xsl:value-of select="$str8KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='32'">
				<xsl:value-of select="$str16KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='64'">
				<xsl:value-of select="$str32KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='128'">
				<xsl:value-of select="$str64KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='256'">
				<xsl:value-of select="$str128KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='512'">
				<xsl:value-of select="$str256KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='1024'">
				<xsl:value-of select="$str512KB"/>
			</xsl:when>
			<xsl:when test="$stripesize='2048'">
				<xsl:value-of select="$str1MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='4096'">
				<xsl:value-of select="$str2MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='8192'">
				<xsl:value-of select="$str4MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='16384'">
				<xsl:value-of select="$str8MB"/>
			</xsl:when>
			<xsl:when test="$stripesize='32768'">
				<xsl:value-of select="$str16MB"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetEnclosureType">
		<xsl:param name="type"/>
		<xsl:param name="productid"/>
		<xsl:choose>
			<xsl:when test="$type='1'">
				<!-- GEM318 PB - Show the string Backplane only -->
				<xsl:value-of select="$strBackPlane"/>
			</xsl:when>
			<xsl:when test="$type='2'">
				<xsl:value-of select="$strBackPlane"/>
			</xsl:when>
			<xsl:when test="$type='3'">
				<xsl:value-of select="$strHendrix8"/>
			</xsl:when>
			<xsl:when test="$type='4'">
				<xsl:value-of select="$strHendrix12"/>
			</xsl:when>
			<xsl:when test="$type='5'">
				<xsl:value-of select="$strZappa"/>
			</xsl:when>
			<xsl:when test="$type='6'">
				<xsl:value-of select="$strCandy"/>
			</xsl:when>
			<xsl:when test="$type='7'">
				<xsl:choose>
					<xsl:when test="$productid != ''">
						<xsl:value-of select="$productid"/>
			                </xsl:when>
					<xsl:otherwise>
				                <xsl:value-of select="ProductID"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetEnclosureConfig">
		<xsl:param name="config"/>
		<xsl:choose>
			<xsl:when test="$config='1'">
				<xsl:value-of select="$strJoined"/>
			</xsl:when>
			<xsl:when test="$config='2'">
				<xsl:value-of select="$strSplit"/>
			</xsl:when>
			<xsl:when test="$config='3'">
				<xsl:value-of select="$strClustered"/>
			</xsl:when>
			<xsl:when test="$config='4'">
				<xsl:value-of select="$strUnified"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- EMM type, Zappa only -->
	<xsl:template name="GetEMMType">
		<xsl:param name="emmtype"/>
		<xsl:choose>
			<xsl:when test="$emmtype='Expander'">
				<xsl:value-of select="$strscsicontroller"/>
			</xsl:when>
			<xsl:when test="$emmtype='Terminator'">
				<xsl:value-of select="$strscsiterminator"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetFanSpeed">
		<xsl:param name="speed"/>
		<xsl:choose>
			<xsl:when test="$speed='1'">
				<xsl:value-of select="$strStopped"/>
			</xsl:when>
			<xsl:when test="$speed='2'">
				<xsl:value-of select="$strSlow"/>
			</xsl:when>
			<xsl:when test="$speed='3'">
				<xsl:value-of select="$strMedium"/>
			</xsl:when>
			<xsl:when test="$speed='4'">
				<xsl:value-of select="$strFast"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DecimalSep">
		<xsl:param name="Size"/>
		<xsl:variable name="formatval">
			<xsl:value-of select="format-number(($Size div (1024*1024*1024)),'#,##0.00')"/>
		</xsl:variable>
		<xsl:variable name="univdecsep">
			<xsl:choose>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = '.'">.;,</xsl:when>
				<xsl:when test="substring(format-number(1.1,'##0.0'), 2, 1) = ','">,;.</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<!--It is important that the statement below be in one single line, else it will mess the formating in GUI, the decimal operator will not show up-->
		<xsl:variable name="localdecsep"><!--XLATESTART-->.;,<!--XLATESTOP--></xsl:variable>
		<xsl:value-of select="translate($formatval,$univdecsep,$localdecsep)"/>
	</xsl:template>

	<xsl:template name="GetBusProtocol">
	<xsl:param name="Bus"/>
		<xsl:choose>
			<xsl:when test="$Bus=1">
				<xsl:value-of select="$strSCSI"/>
			</xsl:when>
			<xsl:when test="$Bus=2">
				<xsl:value-of select="$strIDE"/>
			</xsl:when>
			<xsl:when test="$Bus=7">
				<xsl:value-of select="$strSATA"/>
			</xsl:when>
			<xsl:when test="$Bus=8">
				<xsl:value-of select="$strSAS"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetTerminationType">
		<xsl:param name="termination"/>
		<xsl:choose>
			<xsl:when test="$termination='1'">
				<xsl:value-of select="$strWideTerm"/>
			</xsl:when>
			<xsl:when test="$termination='2'">
				<xsl:value-of select="$strNarrowTerm"/>
			</xsl:when>
			<xsl:when test="$termination='3'">
				<xsl:value-of select="$strNoTerm"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="imagedesc">
		<xsl:if test="ObjStatus='0'">
			<xsl:value-of select="$strOther"/>
		</xsl:if>
		<xsl:if test="ObjStatus='1'">
			<xsl:value-of select="$strUnknown"/>
		</xsl:if>
		<xsl:if test="ObjStatus='2'">
			<xsl:value-of select="$strOK"/>
		</xsl:if>
		<xsl:if test="ObjStatus='3'">
			<xsl:value-of select="$strNonCritical"/>
		</xsl:if>
		<xsl:if test="ObjStatus='4'">
			<xsl:value-of select="$strCritical"/>
		</xsl:if>
		<xsl:if test="ObjStatus='5'">
			<xsl:value-of select="$strNonRecoverable"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="nullpossible">
		<xsl:param name="field"/>
		<xsl:if test="$field='(null)'">
			<xsl:value-of select="$strNA"/>
		</xsl:if>
		<xsl:if test="$field!='(null)'">
			<xsl:value-of select="$field"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="GetState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strReady"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strOnline"/>
			</xsl:when>
			<xsl:when test="$state='8'">
				<xsl:value-of select="$strOffline"/>
			</xsl:when>
			<xsl:when test="$state='16'">
				<xsl:value-of select="$strNotInstalledState"/>
			</xsl:when>
			<xsl:when test="$state='32'">
				<xsl:value-of select="$strDegraded"/>
			</xsl:when>
			<xsl:when test="$state='64'">
				<xsl:value-of select="$strRecovering"/>
			</xsl:when>
			<xsl:when test="$state='128'">
				<xsl:value-of select="$strIOErrorState"/>
			</xsl:when>
			<xsl:when test="$state='256'">
				<xsl:value-of select="$strInactiveState"/>
			</xsl:when>
			<xsl:when test="$state='512'">
				<xsl:value-of select="$strPowerLowState"/>
			</xsl:when>
			<xsl:when test="$state='1024'">
				<xsl:value-of select="$strRemoved"/>
			</xsl:when>
			<xsl:when test="$state='2048'">
				<xsl:value-of select="$strReconditioning"/>
			</xsl:when>
			<xsl:when test="$state='4096'">
				<xsl:value-of select="$strSpeedIncreasing"/>
			</xsl:when>
			<xsl:when test="$state='8192'">
				<xsl:value-of select="$strSpeedDecreasing"/>
			</xsl:when>
			<xsl:when test="$state='16384'">
				<xsl:value-of select="$strResyncing"/>
			</xsl:when>
			<xsl:when test="$state='16388'">
				<xsl:value-of select="$strOnlineResync"/>
			</xsl:when>
			<xsl:when test="$state='32768'">
				<xsl:value-of select="$strRegen"/>
			</xsl:when>
			<xsl:when test="$state='32772'">
				<xsl:value-of select="$strOnlineRegen"/>
			</xsl:when>
			<xsl:when test="$state='65536'">
				<xsl:value-of select="$strFailing"/>
			</xsl:when>
			<xsl:when test="$state='131072'">
				<xsl:value-of select="$strFailedRedundancy"/>
			</xsl:when>
			<xsl:when test="$state='262144'">
				<xsl:value-of select="$strFailedRedFailed"/>
			</xsl:when>
			<xsl:when test="$state='524288'">
				<xsl:value-of select="$strFailingRedundancy"/>
			</xsl:when>
			<xsl:when test="$state='1048576'">
				<xsl:value-of select="$strMissing"/>
			</xsl:when>
			<xsl:when test="$state='2097152'">
				<xsl:value-of select="$strPDCopyback"/>
			</xsl:when>
			<xsl:when test="$state='4194304'">
				<xsl:value-of select="$strSpinDown"/>
			</xsl:when>
			<xsl:when test="$state='8388608'">
				<xsl:value-of select="$strRebuilding"/>
			</xsl:when>
			<xsl:when test="$state='16777216'">
				<xsl:value-of select="$strNoMedia"/>
			</xsl:when>
			<xsl:when test="$state='33554432'">
				<xsl:value-of select="$strFormatting"/>
			</xsl:when>
			<xsl:when test="$state='67108864'">
				<xsl:value-of select="$strBlinking"/>
			</xsl:when>
			<xsl:when test="$state='134217728'">
				<xsl:value-of select="$strDiags"/>
			</xsl:when>
			<xsl:when test="$state='33587204'">
				<xsl:value-of select="$strOnlineRegenFormat"/>
			</xsl:when>
			<xsl:when test="$state='268435456'">
				<xsl:value-of select="$strInitializing"/>
			</xsl:when>
			<xsl:when test="$state='2147483648'">
				<xsl:value-of select="$strReconstructing"/>
			</xsl:when>
			<xsl:when test="$state='4294967296'">
				<xsl:value-of select="$strRescanning"/>
			</xsl:when>
			<!--xsl:when test="$state='549755813888'">
				<xsl:value-of select="$strNotReady"/>
			</xsl:when-->
			<xsl:when test="$state='17179869184'">
				<xsl:value-of select="$strInitializing"/>
			</xsl:when>
			<xsl:when test="$state='274877906944'">
				<xsl:value-of select="$strForeignState"/>
			</xsl:when>
			<xsl:when test="$state='549755813888'">
				<xsl:value-of select="$strClearState"/>
			</xsl:when>
			<xsl:when test="$state='1099511627776'">
				<xsl:value-of select="$strUnsupportedState"/>
			</xsl:when>

			<xsl:when test="$state='549755813892'">
				<xsl:value-of select="$strOnlineUnreadable"/>
			</xsl:when>
			<xsl:when test="$state='536870912'">
				<xsl:value-of select="$strRescanning"/>
			</xsl:when>
			<xsl:when test="$state='1073741824'">
				<xsl:value-of select="$strRefresh"/>
			</xsl:when>
			<xsl:when test="$state='2147483648'">
				<xsl:value-of select="$strRelayout"/>
			</xsl:when>
			<xsl:when test="$state='8589934592'">
				<xsl:value-of select="$strSmartAlert"/>
			</xsl:when>
			<xsl:when test="$state='1152921504606846976'">
				<xsl:value-of select="$strMinWarnState"/>
			</xsl:when>
			<xsl:when test="$state='2305843009213693952'">
				<xsl:value-of select="$strMinFailureState"/>
			</xsl:when>
			<xsl:when test="$state='4611686018427387904'">
				<xsl:value-of select="$strMaxWarnState"/>
			</xsl:when>
			<xsl:when test="$state='9223372036854775808'">
				<xsl:value-of select="$strMaxFailureState"/>
			</xsl:when>
			<xsl:when test="$state='34359738368'">
				<xsl:value-of select="$strBGIInitState"/>
			</xsl:when>
			<xsl:when test="$state='68719476736'">
				<xsl:value-of select="$strPauseFormat"/>
			</xsl:when>
			<xsl:when test="$state='137438953472'">
				<xsl:value-of select="$strPauseResynch"/>
			</xsl:when>
			<xsl:when test="$state='281474976710656'">
				<xsl:value-of select="$strLearning"/>
			</xsl:when>
			<xsl:when test="$state='562949953421312'">
				<xsl:value-of select="$strPowerLowState"/> <!-- battery specific -->
			</xsl:when>
			<xsl:when test="$state='1048576'">
				<xsl:value-of select="$strMissing"/>
			</xsl:when>
			<xsl:when test="$state='1125899906842624'">
				<xsl:value-of select="$strCharging"/>
			</xsl:when>
			<xsl:when test="$state='2251799813685248'">
				<xsl:value-of select="$strPermanentlyDegraded"/>
			</xsl:when>
			<xsl:when test="$state='4503599627370496'">
				<xsl:value-of select="$strIncompatible"/>
			</xsl:when>
      <xsl:when test="$state='9007199254740992'">
        <xsl:value-of select="$strDegradedRedundancy"/>
      </xsl:when>
      		<xsl:when test="$state='18014398509481984'">
        			<xsl:value-of select="$strCommunicationLost"/>
      		</xsl:when>
      <xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--manipulation for AttributesMask-->
	<xsl:template name="IsClustered">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,32,1='1')">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsBatteryPresent">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,31,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsBusIDE">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,30,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsRLDSupported">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,29,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsInUseByVD">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,28,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsPartitionsAllowed">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,27,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsChannelRedundant">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,26,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsGlobalHotSpare">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,25,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsDedicatedHotSpare">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,24,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsObjectNonRaid">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,23,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	<xsl:template name="IsDiskInEnclosure">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,22,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	<xsl:template name="SmartAlertDetected">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,21,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
  	<xsl:template name="IsCreateVDSupported">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,26,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	 <xsl:template name="IsRaidIntegratedMirror">
		<xsl:param name="AttributesMask"/>
		<xsl:choose>
			<xsl:when test="substring($AttributesMask,20,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	 </xsl:template>
	<xsl:template name="CanVDBlink">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,24,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="CanADBlink">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,32,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsMasterMethodMaskEmpty">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="$Mask='00000000000000000000000000000000'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Added by NL for CurrentMethodMask -->
	<xsl:template name="IsCurrentMethodMaskEmpty">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="$Mask='00000000000000000000000000000000'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="IsWriteCacheEnabled">
		<xsl:param name="Mask"/>
		<xsl:choose>
			<xsl:when test="substring($Mask,27,1)='1'">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="IsSASorSATA">
		<xsl:param name="BusProtocol"/>
		<xsl:choose>
			<xsl:when test="$BusProtocol=7">1</xsl:when>
			<xsl:when test="$BusProtocol=8">1</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--needed to add this to translate 'unknown' coming from lower layers for scsi rate -->
	<xsl:template name="GetSCSIRateUnknown">
		<xsl:param name="Rate"/>
		<xsl:choose>
			<xsl:when test="$Rate='Unknown'"><xsl:value-of select="$strUnknown"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$Rate"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--  CurrentMethodMask for Controller-->
	<xsl:template name="GetControllerMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strRescan"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strFlush"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strEnableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strDisableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16'">
				<xsl:value-of select="$strQuietAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32'">
				<xsl:value-of select="$strSetRebuildRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strCreateVD"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strResetConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strExportLog"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='512'">
				<xsl:value-of select="$strPauseIO"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1024'">
				<xsl:value-of select="$strResumeIO"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2048'">
				<xsl:value-of select="$strTestAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8192'">
				<xsl:value-of select="$strSetBGIRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16384'">
				<xsl:value-of select="$strSetCheckConRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32768'">
				<xsl:value-of select="$strSetPatReadRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='65536'">
				<xsl:value-of select="$strSetReconstructRate"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<!--xsl:when test="$MethodValue='131072'">
				<xsl:value-of select="$strEnableCluster"/>
			</xsl:when>
			<xsl:when test="$MethodValue='262144'">
				<xsl:value-of select="$strDisableCluster"/>
			</xsl:when>
			<xsl:when test="$MethodValue='524288'">
				<xsl:value-of select="$strDumpEvents"/>
			</xsl:when-->
			<xsl:when test="$MethodValue='1048576'">
				<xsl:value-of select="$strSetPatReadMode"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2097152'">
				<xsl:value-of select="$strStartPatRead"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4194304'">
				<xsl:value-of select="$strStopPatRead"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8388608'">
				<xsl:value-of select="$strClearForeignConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16777216'">
				<xsl:value-of select="$strImportForeignConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='33554432'">
				<xsl:value-of select="$strForcedImportForeignConfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='67108864'">
				<xsl:value-of select="$strChangeControllerProperties"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='536870912'">
				<xsl:value-of select="$strForeignConfigOperations"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
                  <xsl:when test="$MethodValue='268435456'">
				<xsl:value-of select="$strPinnedCache"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>

			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetControllerAlarm">
		<xsl:param name="MethodValue"/>
		<xsl:if test="string-length($MethodValue) = 32">
			<!--problem w/ screen not displaying; making sure mask comes back as bit values-->
			<xsl:choose>
				<xsl:when test="substring($MethodValue,30,1)='0' and substring($MethodValue,29,1)='0' and substring($MethodValue,28,1)='0' ">
					<!--if the masks are never set; then assume alarm function is not applicable-->
					<xsl:value-of select="$strNotApplicable"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="substring($MethodValue,30,1)='0'">
							<xsl:value-of select="$strEnabled"/>
						</xsl:when>
						<xsl:when test="substring($MethodValue,29,1)='0'">
							<xsl:value-of select="$strDisabled"/>
						</xsl:when>
						<xsl:when test="substring($MethodValue,28,1)='0'">
							<xsl:value-of select="$strQuiet"/>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	<!-- ENCLOSURE ALARM STATE -->
	<xsl:template name="GetEnclosureAlarm">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state = 0">
				<xsl:value-of select="$strDisabled"/>
			</xsl:when>
			<xsl:when test="$state = 1">
				<xsl:value-of select="$strEnabled"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetBatteryMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strRechargeBattery"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
			    <xsl:value-of select="$strStartLearn"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
			    <xsl:value-of select="$strDelayLearn"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetChannelMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strRescan"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strPauseIO"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strResumeIO"/>
			</xsl:when>
			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetEnclosureMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strEnableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strDisableAlarm"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strSetTagData"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strSetTempData"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strSetAllTempData"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strUnBlink"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="GetVirtualDiskMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strReconfig"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strFormat"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strCancelFormat"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strRecover"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16'">
				<xsl:value-of select="$strDelete"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32'">
				<xsl:value-of select="$strCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strInitialize"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strConfigDedHS"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='512'">
				<xsl:value-of select="$strUnBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1024'">
				<xsl:value-of select="$strRename"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2048'">
				<xsl:value-of select="$strCancelCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4096'">
				<xsl:value-of select="$strCancelInit"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8192'">
				<xsl:value-of select="$strSplitMirror"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16384'">
				<xsl:value-of select="$strUnMirror"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32768'">
				<xsl:value-of select="$strCancelRebuild"/>
			</xsl:when>
			<xsl:when test="$MethodValue='65536'">
				<xsl:value-of select="$strPauseCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='131072'">
				<xsl:value-of select="$strResumeCheckConsistency"/>
			</xsl:when>
			<xsl:when test="$MethodValue='262144'">
				<xsl:value-of select="$strCancelReconfig"/>
			</xsl:when>
			<xsl:when test="$MethodValue='524288'">
				<xsl:value-of select="$strChangePolicy"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1048576'">
				<xsl:value-of select="$strCancelBGI"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4194304'">
				<xsl:value-of select="$strSlowInitialize"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8388608'">
				<xsl:value-of select="$strFastInitialize"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16777216'">
				<xsl:value-of select="$strReplaceMemberDisk"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetStorageMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strGlobalRescan"/><xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strEnableSTS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strDisableSTS"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetArrayDiskMethods">
		<xsl:param name="MethodValue"/>
		<xsl:choose>
			<xsl:when test="$MethodValue='1'">
				<xsl:value-of select="$strBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2'">
				<xsl:value-of select="$strUnBlink"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4'">
				<xsl:value-of select="$strDiags"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8'">
				<xsl:value-of select="$strCancelDiags"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16'">
				<xsl:value-of select="$strAssignGlobalHS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32'">
				<xsl:value-of select="$strUnassignGlobalHS"/>
			</xsl:when>
			<xsl:when test="$MethodValue='64'">
				<xsl:value-of select="$strOnline"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='128'">
				<xsl:value-of select="$strOffline"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='256'">
				<xsl:value-of select="$strPreparetoRemove"/>
			</xsl:when>
			<xsl:when test="$MethodValue='512'">
				<xsl:value-of select="$strFormat"/>
			</xsl:when>
			<xsl:when test="$MethodValue='1024'">
				<xsl:value-of select="$strRebuild"/>
			</xsl:when>
			<xsl:when test="$MethodValue='2048'">
				<xsl:value-of select="$strCancelRebuild"/>
			</xsl:when>
			<xsl:when test="$MethodValue='4096'">
				<xsl:value-of select="$strInitialize"/>
			</xsl:when>
			<xsl:when test="$MethodValue='8192'">
				<xsl:value-of select="$strVerify"/>
			</xsl:when>
			<xsl:when test="$MethodValue='16384'">
				<xsl:value-of select="$strCancelVerify"/>
			</xsl:when>
			<xsl:when test="$MethodValue='32768'">
				<xsl:value-of select="$strRemoveDeadDisks"/>
			</xsl:when>
			<xsl:when test="$MethodValue='65536'">
				<xsl:value-of select="$strAdiskClear"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='131072'">
				<xsl:value-of select="$strAdiskCancelClear"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<xsl:when test="$MethodValue='524288'">
				<xsl:value-of select="$strCancelCopyback"/>
				<xsl:value-of select="$strEllipse"/>
			</xsl:when>
			<!-- MJR - 5/28/03 - I removed the otherwise case which put a task item of 'Unknown' in the drop down menu.  It's probably best to not show anything rather than unknown' -->
		</xsl:choose>
	</xsl:template>
        <!--6.0 changes-->
        <xsl:template name="GetControllerProperty">
	         <xsl:param name="PropertyMode"/>
	            <xsl:choose>			
		       <xsl:when test="$PropertyMode='4096' or $PropertyMode='32768' or  $PropertyMode='4'">
			    <xsl:value-of select="$strEnabled"/>
		       </xsl:when>
                   <xsl:when test="$PropertyMode='1'">
			    <xsl:value-of select="$strDetected"/>
		       </xsl:when>
                   <xsl:when test="$PropertyMode='2'">
			    <xsl:value-of select="$strClear"/>
		       </xsl:when>
                   <xsl:when test="$PropertyMode='262144'">
			    <xsl:value-of select="$strAuto"/>
		       </xsl:when>
 
  
  
		       <xsl:when test="$PropertyMode='1048576' or $PropertyMode='131072' or $PropertyMode='524288' or  $PropertyMode='8'">
			     <xsl:value-of select="$strDisabled"/>
		       </xsl:when>
		 </xsl:choose>
        </xsl:template>
         
      <!--6.0 changes-->
      <!-- Bharath Changes 6.0 for cli-->
       <xsl:template name="CLIGetAbortCConError">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strEnabled"/>
      </xsl:when>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="CLIGetCopyback">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strEnabled"/>
      </xsl:when>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


  <xsl:template name="CLIGetSmarter">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strEnabled"/>
      </xsl:when>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="CLIGetLoadbalance">
    <xsl:param name="state"/>
    <xsl:choose>
      <xsl:when test="$state='0'">
        <xsl:value-of select="$strAuto"/>
      </xsl:when>
      <xsl:when test="$state='1'">
        <xsl:value-of select="$strDisabled"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$state"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
<!--BharathChanges-->
      <xsl:template name="ConvertBinaryToDecimal">
		<xsl:param name="BinaryStr"/>
		<xsl:param name="DecValue" select="0"/>
		<xsl:param name="BitVal" select="1"/>
		<xsl:param name="increment" select="-1"/>
		<xsl:param name="i" select="32"/>
		<xsl:param name="testValue" select="1"/>
		<xsl:if test="$i >= $testValue">
			<xsl:call-template name="ConvertBinaryToDecimal">
				<xsl:with-param name="BinaryStr" select="$BinaryStr"/>
				<xsl:with-param name="DecValue">
					<xsl:choose>
						<xsl:when test="substring($BinaryStr,$i,1)='1'">
							<xsl:value-of select="$DecValue+$BitVal"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$DecValue"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="BitVal" select="$BitVal*2"/>
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="$i = '0'">
			<xsl:value-of select="$DecValue"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="for-loop-list-box">
		<xsl:param name="Mask"/>
		<xsl:param name="currPolicy"/>
		<xsl:param name="BitValue" select="1"/>
		<xsl:param name="i" select="32"/>
		<xsl:param name="increment" select="-1"/>
		<xsl:param name="testValue" select="1"/>
		<xsl:param name="templateName"/>
		<xsl:if test="$i >= $testValue">
			<xsl:if test="substring($Mask,$i,1)='1' ">
				<xsl:choose>
					<xsl:when test="$templateName='1'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetStripeSize"><xsl:with-param name="stripesize" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='2'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetReadPolicy"><xsl:with-param name="readpolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='3'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetWritePolicy"><xsl:with-param name="writepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='4'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetCachePolicy"><xsl:with-param name="cachepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='5'">
                                          <xsl:choose>
                                             <xsl:when test="substring($Mask,6,1)='1'">
                                                 <xsl:if test="$BitValue != '4096'and $BitValue != '32'and $BitValue != '8192'and $BitValue != '16384'and $BitValue != '65536'">
							<!--do not show change scsi id in GUI CTRL PROPS-->
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetControllerMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
                                            </xsl:when>
                                            <xsl:when test="substring($Mask,6,1)='0'">
						<xsl:if test="$BitValue != '4096'">
							<!--do not show change scsi id in GUI-->
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetControllerMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
                                            </xsl:when>
                                            </xsl:choose>
					</xsl:when>
					<xsl:when test="$templateName='6'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetBatteryMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='7'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetChannelMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='8'">
						<!--Bit 16 corresponds to Encl_power_down which has no corresponding task -->
						<xsl:if test="$BitValue != '16'">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetEnclosureMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='9'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetVirtualDiskMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='10'">
                                            <xsl:if test="$BitValue != '1048576'">
                          			<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetArrayDiskMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
                                            </xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='11'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetRaidLayout"><xsl:with-param name="RaidType" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
					<xsl:when test="$templateName='12'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetReadPolicy"><xsl:with-param name="readpolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='13'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetWritePolicy"><xsl:with-param name="writepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='14'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetCachePolicy"><xsl:with-param name="cachepolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$templateName='15'">
						<Choice>
							<xsl:attribute name="value"><xsl:call-template name="GetStorageMethods"><xsl:with-param name="MethodValue" select="$BitValue"/></xsl:call-template></xsl:attribute>
							<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
						</Choice>
					</xsl:when>
                                        <xsl:when test="$templateName='16'">
                                               <xsl:if test="substring($Mask,17,1)='1' and $BitValue = '32768'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">131072</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">2</xsl:attribute>
                                                    </Choice>
                                                  </xsl:if>
                                                <xsl:if test="substring($Mask,17,1)='0' and $BitValue='131072'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">32768</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">1</xsl:attribute>
                                                    </Choice>
                                                 </xsl:if>  
                                         </xsl:when>
                                         <xsl:when test="$templateName='17'">
                                            <xsl:if test="substring($Mask,14,1)='1' and $BitValue = '262144'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">524288</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">2</xsl:attribute>
                                                    </Choice>
                                             </xsl:if>
                                             <xsl:if test="substring($Mask,14,1)='0' and $BitValue='524288'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">262144</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">1</xsl:attribute>
                                                    </Choice>
                                            </xsl:if>
                                          </xsl:when>
                                          <xsl:when test="$templateName='18'">
                                            <xsl:if test="substring($Mask,30,1)='1' and $BitValue = '4'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">8</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">2</xsl:attribute>
                                                    </Choice>
                                             </xsl:if>
                                             <xsl:if test="substring($Mask,30,1)='0' and $BitValue='8'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">4</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">1</xsl:attribute>
                                                    </Choice>
                                            </xsl:if>
                                           </xsl:when>
                                           <xsl:when test="$templateName='19'">
                                            <xsl:if test="substring($Mask,20,1)='1' and $BitValue = '4096'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">1048576</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">2</xsl:attribute>
                                                    </Choice>
                                             </xsl:if>
                                             <xsl:if test="substring($Mask,20,1)='0' and $BitValue='1048576'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">4096</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">1</xsl:attribute>
                                                    </Choice>
                                            </xsl:if>
                                           </xsl:when>
                                           <xsl:when test="$templateName='20'">
						<xsl:if test="$BitValue != $currPolicy">
							<Choice>
								<xsl:attribute name="value"><xsl:call-template name="GetDiskCachePolicy"><xsl:with-param name="DiskCachePolicy" select="$BitValue"/></xsl:call-template></xsl:attribute>
								<xsl:attribute name="returnvalue"><xsl:value-of select="$BitValue"/></xsl:attribute>
							</Choice>
						</xsl:if>
					</xsl:when>
                                        <xsl:when test="$templateName='21'">
                                            <xsl:if test="substring($Mask,32,1)='1' and $BitValue = '1'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">2</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">2</xsl:attribute>
                                                    </Choice>
                                             </xsl:if>
                                             <xsl:if test="substring($Mask,32,1)='0' and $BitValue='2'">
                                                    <Choice>
                                                       <xsl:attribute name="value"><xsl:call-template name="GetControllerProperty"><xsl:with-param name="PropertyMode">1</xsl:with-param></xsl:call-template></xsl:attribute>
		                                           <xsl:attribute name="returnvalue">1</xsl:attribute>
                                                    </Choice>
                                            </xsl:if>
                                         </xsl:when>
  				</xsl:choose>
			</xsl:if>
			<xsl:call-template name="for-loop-list-box">
				<xsl:with-param name="Mask" select="$Mask"/>
				<xsl:with-param name="currPolicy" select="$currPolicy"/>
				<xsl:with-param name="BitValue" select="$BitValue*2"/>
				<xsl:with-param name="i" select="$i+$increment"/>
				<xsl:with-param name="increment" select="$increment"/>
				<xsl:with-param name="testValue" select="$testValue"/>
				<xsl:with-param name="templateName" select="$templateName"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
    <xsl:template name="ModNexus">
	<xsl:param name="nexus"/>
<!--uncomment the following to use nexus .....
		<xsl:value-of select="ObjID"/>
-->
	<xsl:if test="contains($nexus, '&#92;')">
		<xsl:value-of select="translate($nexus, '&#92;','&#46;')"/>
	</xsl:if>
	<xsl:if test="not(contains($nexus, '&#92;'))">
		<xsl:message>not <xsl:value-of select="$nexus"/></xsl:message>
		<xsl:value-of select="$nexus"/>
	</xsl:if>

    </xsl:template>
	<xsl:template name="errorhandling">
		<script language="javascript">
			function SetBackToButtonLink() {
		 		// Set the BackToLink for error handling
		 		var url = "";
		 		url += document.location;
				var split_url = url.split("servlet");
				url = "/servlet" + split_url[1];
				var link = document.getElementById("BackToLink");
				if(link != null) {
					link.value = url;
				}
			}
		</script>
	</xsl:template>
	<xsl:template name="scripts">
	<!--xsl:template match="/"-->
		<script language="javascript">
		    function GetLocalUrl() {
				// Need to retrieve the URL for the current page to pass to the web plugin.  This is needed for
				// the error handling which will bring the user back to this page if an error has occured.
				var url = "";
				url += document.location;

				// The URL needs to be passed into the web plugin, but passing an entire URL with &amp; in it as a parameter confuses
				// the calling URL.  Tokenize this and replace the &amp; with !!.  The error.xsl will reverse this back to a callable URL.  Also
				// strip off the https://hostname:port/ piece of the URL.  Originally, I tokenized off of the prot # 1311, but since this could
				// change, it's better to tokenize off of the word "servlet", then just add that back in.
				var split_url = url.split("servlet");
				url = "/servlet" + split_url[1];
				split_url = url.split("&amp;");
				var end_count = split_url.length;
				var new_url = "";
				for(count=0; count &lt; end_count-1; count++)
				{
					new_url += split_url[count] + "!!";
				}
				new_url += split_url[end_count-1];
				return new_url;
		    }

		    function UnMungeURL(url)
		    {
					// The HREF URL passed in has !! in place of the &amp;.  this was need to be able to pass it to the web plugin.
					// Reverse this and replace the !! with &amp; here.
					var split_url = url.split("!!");
					var end_count = split_url.length;
					var href = "";
					for(count=0; count &lt; end_count-1; count++)
					{
						href += split_url[count] + "&amp;";
				 	}
					href += split_url[end_count-1];
					return href;
			 }

		   // Checks to make sure that text only contains alphanumeric and space, dash and underscores.
		   // Also name cannot begin or end with a space.
		   function isValidName(text)
			 {
				var validchars = /^[a-zA-Z0-9_ -]*$/;
				if( validchars.test(text))
				{

					// cannot start or end with a space.
					if(/^ /.test(text) || / $/.test(text))
					{
					   alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strStartSpace"/>");
					   return false
					}

					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidString"/>");
				return false;
			}

		   // Checks to make sure that text only contains alphanumeric and space, dash and underscores.
		   function isValidNameWithSpace(text)
			 {
				var validchars = /^[a-zA-Z0-9_ -]*$/;
				if( validchars.test(text))
				{
					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidString"/>");
				return false;
			}

		   // Checks to make sure that text only contains alphanumeric and  dash and underscores.  NO SPACE
		   function isValidNameNoSpace(text)
			 {
			  	var validchars = /^[a-zA-Z0-9_-]*$/;
				if( validchars.test(text))
				{
					return true;
				}
				alert("<xsl:value-of select="$strError"/>" + "<xsl:value-of select="$strInvalidStringNoSpace"/>");
      return false;
      }

      //Removes the leading zeros example: for 009 give it as 9
      function removeLeadingZeros(inputval)
      {
        while (inputval.charAt(0)=='0')
        {
          inputval = inputval.substring(1, inputval.length);
        }
        if (inputval == '')
        {
          inputval = 0;
        }
        return inputval;
      }

    </script>
	</xsl:template>

	<!--bitwise and operator-->
	<xsl:template name="bitAnd">
		<xsl:param name="num1" />
		<xsl:param name="num2" />
		<xsl:param name="result" select="0"/>
		<xsl:param name="pow2" select="1"/>

		<xsl:choose>
			<xsl:when test="$num1 &lt; 1 or $num2 &lt; 1">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:when test="$num1 mod 2 and $num2 mod 2">
				<xsl:call-template name="bitAnd">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result+$pow2"/>
					<xsl:with-param name="pow2" select="$pow2*2"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="bitAnd">
					<xsl:with-param name="num1" select="floor($num1 div 2)"/>
					<xsl:with-param name="num2" select="floor($num2 div 2)"/>
					<xsl:with-param name="result" select="$result"/>
					<xsl:with-param name="pow2" select="$pow2*2"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when ClusterMode tag is available in the controller xml-->
	<xsl:template name="GetClusterMode">
		<xsl:param name="mode"/>
		<xsl:choose>
			<!--check if Cluster Allowed bit (0x00000004) is ON -->
			<xsl:when test="substring($mode,30,1)='1'">
				<xsl:choose>
					<!--check if Cluster Enabled bit (0x00000002) is ON-->
					<xsl:when test="substring($mode,31,1)='1'">
						<xsl:choose>
							<!--check if Cluster Active bit (0x00000001) is ON-->
							<xsl:when test="substring($mode,32,1)='1'">
								<xsl:value-of select="$strActive"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$strEnabled"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!--Cluster Enabled bit is Off-->
					<xsl:otherwise>
						<xsl:value-of select="$strDisabled"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!--Cluster Allowed bit is disabled-->
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when PatrolReadMode tag is available in the controller xml-->
	<xsl:template name="GetPatrolReadMode">
		<xsl:param name="mode"/>
		<xsl:choose>
			<!--Patrol Read Enabled bit (0x00000001) is ON-->
			<xsl:when test="substring($mode,32,1)='1'">
				<xsl:choose>
					<!--check if Patrol Read Auto bit (0x00000002) is ON-->
					<xsl:when test="substring($mode,31,1)='1'">
						<xsl:value-of select="$strAuto"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$strManual"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!--Patrol Read Enabled bit is disabled-->
			<xsl:otherwise>
				<xsl:value-of select="$strDisabled"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when PatrolReadState tag is available in the controller xml-->
	<xsl:template name="GetPatrolReadState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strStopped"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strReady"/>
			</xsl:when>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strActive"/>
			</xsl:when>
			<xsl:when test="$state='8'">
				<xsl:value-of select="$strAborted"/>
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called only when AlarmState tag is available in the controller xml-->
	<xsl:template name="GetAlarmState">
		<xsl:param name="state"/>
		<xsl:choose>
			<!--Alarm State Present bit (0x00000002) is On-->
			<xsl:when test="substring($state,31,1)='1'">
				<xsl:choose>
					<!--check if Alarm State Enabled bit (0x00000001) is ON-->
					<xsl:when test="substring($state,32,1)='1'">
						<xsl:value-of select="$strEnabled"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$strDisabled"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!--Alarm State Present bit is Off-->
			<xsl:otherwise>
				<xsl:value-of select="$strNotApplicable"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!--This template gets called for battery capacity state in the battery xsl
		 Capacity state = Failed/Ready/Unknown
	-->
	<xsl:template name="getBtryCapacityState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strUnknown"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strReady"/>
			</xsl:when>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!--This template gets called for learn state in the battery xsl
       Learn state =  Failed/Active/Timed Out/Requested/Idle
	-->
	<xsl:template name="getBtryLearnState">
		<xsl:param name="state"/>
		<xsl:choose>
			<xsl:when test="$state='1'">
				<xsl:value-of select="$strFailed"/>
			</xsl:when>
			<xsl:when test="$state='2'">
				<xsl:value-of select="$strActive"/>
			</xsl:when>
			<xsl:when test="$state='4'">
				<xsl:value-of select="$strTimedOut"/>
			</xsl:when>
			<xsl:when test="$state='8'">
				<xsl:value-of select="$strRequested"/>
			</xsl:when>
			<xsl:when test="$state='16'">
				<xsl:value-of select="$strIdle"/>
			</xsl:when>
			<xsl:when test="$state='32'">
				<xsl:value-of select="$strDue"/>
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- This template is called by the battery reporting to convert hours into days.
	     It shows the singular or plural form of days and hours.
	     The empty <xsl:text> </xsl:text> are to put in whitespaces so the output is
	      not all run in together.
	  -->
	<xsl:template name="formatHoursToDays">
		<xsl:param name="time"/>
		<xsl:choose>
			<xsl:when test="$time &gt; 24 ">
					<xsl:value-of select="floor($time div 24)"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="floor($time div 24)=1">
							<xsl:value-of select="$strDay"/>
						</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$strDays"/>
					</xsl:otherwise>
					</xsl:choose>

					<xsl:text> </xsl:text><xsl:value-of select="$time mod 24"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="($time mod 24)=1">
							<xsl:value-of select="$strHour"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$strHours"/>
						</xsl:otherwise>
					</xsl:choose>
			</xsl:when>

			<xsl:otherwise>
					<xsl:value-of select="$time"/><xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="$time=1">
							<xsl:value-of select="$strHour"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$strHours"/>
						</xsl:otherwise>
					</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetLearnMode">
		<xsl:param name="learnMode"/>
		<xsl:choose>
			<xsl:when test="$learnMode=1">
				<xsl:value-of select="$strAuto"/>
			</xsl:when>
			<xsl:when test="$learnMode=2">
				<xsl:value-of select="$strWarn"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

        <!--
        This template should be called to get the Back Page link.
        XML should contain BackTo tag under OMA for this template to give
        correct value. In webplugin to add the BackTo tag in XML it is required
        to call CreateReturnLink(..) method should be called inside
        public String getXMLStringFromWebPlugin(HttpServletRequest req) and also
        Method BackToLink should be called at the end eg.
                    sXML += backToLink("",req);

        -->
        <xsl:template name="BackPage" match="OMA">
          <xsl:param name="defaultBackPage">
          </xsl:param>
          <xsl:choose>
            <xsl:when test="BackTo and BackTo!=''">
              <xsl:value-of select="BackTo"/>
            </xsl:when>

            <xsl:otherwise><xsl:value-of select="$defaultBackPage"/></xsl:otherwise>
          </xsl:choose>
        </xsl:template>

        <xsl:template name="GetForeignErrorDetails">
          <xsl:param name="ErrorCode"/>
		<xsl:choose>
			<xsl:when test="$ErrorCode='2249'">
				<xsl:value-of select="$strExceedMaxVDLimit"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2250'">
				<xsl:value-of select="$strUnsupportedRAIDLevel"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2251'">
				<xsl:value-of select="$strMissingSpan"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2252'">
				<xsl:value-of select="$strMissingPD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2253'">
				<xsl:value-of select="$strStalePD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2254'">
				<xsl:value-of select="$strOrphanDrive"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2255'">
				<xsl:value-of select="$strIncompatiblePD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='2256'">
				<xsl:value-of select="$strPartialForeignVD"/>
			</xsl:when>
			<xsl:when test="$ErrorCode='0'">
				<!-- Do not display anything -->
			</xsl:when>
			<xsl:otherwise>
				<!--should never fall here-->
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
        </xsl:template>

</xsl:stylesheet>
