<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:include href="../common/Utils.xsl"/>
	<xsl:include href="../en/globals.xsl"/>
	<xsl:template match="/">
		<DataArea>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strGlobalStorageProperties"/></xsl:attribute>
			</PageTitle>
			<TableData>
				<!--Valid values for STS - N/A, enabled, disabled -->
				<Header>
				        <Data name="STS" editable="false" type="ustring" align="left">
				            <xsl:attribute name="display"><xsl:value-of select="$strSmartThermalShutdown"/></xsl:attribute>
				            <xsl:attribute name="value"><xsl:value-of select="$strSmartThermalShutdown"/></xsl:attribute>
				        </Data>
				</Header>
			       <Row>
			            <Data  editable="false" type="ustring" ignoreonweb="true">
			            		<xsl:attribute name="name"><xsl:value-of select="$strSTS"/></xsl:attribute>
			            		<xsl:attribute name="value">
			            			<xsl:choose>
			            				<xsl:when test="/OMA/ArrayInfo/STSMode/DCStorageObject/SmartThermalShutdownMode">
			            					<xsl:choose>
			            						<xsl:when test="/OMA/ArrayInfo/STSMode/DCStorageObject/SmartThermalShutdownMode='1'">
			            							<xsl:value-of select="$strEnabled"/>
			            						</xsl:when>
					            				<xsl:otherwise>
			            							<xsl:value-of select="$strDisabled"/>
					            				</xsl:otherwise>
									</xsl:choose>
			            				</xsl:when>
			            				<xsl:otherwise>
	            							<xsl:value-of select="$strNotApplicable"/>
			            				</xsl:otherwise>
							</xsl:choose>
			            		</xsl:attribute>
			            </Data>
			       </Row>
			</TableData>
		</DataArea>
	</xsl:template>
</xsl:stylesheet>
