<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" />

<xsl:template match="SystemInfo">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	</head>
	<body class="system-info">
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td>
					<div align="right" class="system-info-data">
						<xsl:apply-templates />
					</div>
				</td>
				<td style="width: 15px"/>
			</tr>
		</table>
	</body>
	</html>
</xsl:template>
<xsl:template match="System">
	<xsl:value-of select="ChassisInfo/ChassisProps1/ChassModel" />
	<br />
</xsl:template>
<xsl:template match="User">
	<xsl:value-of select="@name" />, <xsl:value-of select="@rights" />
</xsl:template>

</xsl:stylesheet>
