<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="html" />
<xsl:template match="/MenuList">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	<script language="javascript">
	var g_nLastItem = 1;
	var g_nMenuItem = 0;
	var g_vMenuItemName = new Array();
	var g_sDefaultItem = '<xsl:value-of select="@lsnb" />';
	var g_nDefaultItem= 1;
	var g_sDefaultTarget = "";
	var g_sDefaultHelp = "";
	var g_sDefaultApp = "";
	var g_bIE55 = false;
	var g_bInitInProgress = false;
	var g_nDataAreaLoadStart;
	var g_hCalculateLatency;
	var g_hClearLock;
	var g_bsmallfontreq = false;

	function init () {
		parent.ct.lsnbLoad = true;
		if (g_nMenuItem > 0) {
			iBlank = new Image ();
			iBlank.src = "/oma/images/blank.gif"
			document.images["img_" + g_nMenuItem].src = iBlank.src;
		}
		if (g_sDefaultTarget == "")
			g_sDefaultTarget = "/oma/loading.html";
		if (navigator.appName == "Microsoft Internet Explorer") {
			var sAppVersion = navigator.appVersion
			sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
			sAppVersion = sAppVersion.split (';')[0];
			if (sAppVersion >= "5.5")
				g_bIE55 = true;
		}
		if (g_nMenuItem > 0) {
			g_bInitInProgress = true;
			select  (g_nDefaultItem, g_sDefaultTarget, g_sDefaultHelp,g_sDefaultApp);
			//DFCT101452 - When the text in any LSNB istem wraps, set font to 8pt
			for (i = 0; i &lt; g_nMenuItem; i++) {
				var anchor = document.getElementById("link_" + (i + 1));
				if (anchor.offsetHeight > 16) {
					g_bsmallfontreq = true;
					setsmallfont(g_nMenuItem);
					break;
				}
			}			
			g_bInitInProgress = false;
		}
	}
	
	//DFCT101452 - When the text in any LSNB istem wraps, set font to 8pt
	function setsmallfont(nMenuItem){
		for (i = 0; i &lt; g_nMenuItem; i++) {
			var anchor = document.getElementById("link_" + (i + 1));
			anchor.className = "lsnb-item lsnb-item-small-font";
		}
	}	
	function clearLock () {
		parent.ct.clearLock ();
		window.clearInterval (g_hClearLock);
	}
	function calculateDALatency () {
		if (parent.ct.g_bLoadInProgress == false) {
			var now = new Date ();
			parent.ct.g_nDataAreaLatency = now.getTime () - g_nDataAreaLoadStart;
			window.clearInterval (g_hCalculateLatency);
		}
	}
	function select (nItem, sTarget, sHelp, sApp) {
		if (parent.ct.g_bLoadInProgress == false || g_bInitInProgress == true) {
			parent.ct.setLock ();
			if (_performSelect (nItem) == true) {
			var vvid = top.gnv.getVID();
				if (parent.ct.g_bLSNBGoingBack == false) {
					var sTemp = sTarget;
					if (sTemp.indexOf ("?") != -1)
						sTemp += "&amp;";
					else
						sTemp += "?";
					if (g_bIE55 == false || 
					    (( typeof (parent.ct.g_sLastLink) != "undefined") &amp;&amp;
					     ( typeof (parent.snb.g_vMenuItemName) != "undefined") &amp;&amp;
					     ( typeof (parent.snb.g_nLastMenuItem) != "undefined")))
						sTemp = sTemp + "help=" + sHelp + "&amp;app=" + sApp + "&amp;ct=" + parent.ct.g_sLastLink + "&amp;snb=" + parent.snb.g_vMenuItemName[parent.snb.g_nLastMenuItem - 1] + "&amp;lsnb=" + g_vMenuItemName[nItem - 1] + "&amp;vid=" + vvid;

					if(navigator.appName == "Netscape") {
						g_nDataAreaLoadStart = (new Date ()).getTime ();
						parent.da.location.href = sTemp;
						g_hCalculateLatency = window.setInterval (calculateDALatency, 100);
						if (parent.ct.g_nDataAreaLatency > 0)
							g_hClearLock = window.setInterval (clearLock , parent.ct.g_nDataAreaLatency);
					}
					else {
						parent.da.location.href = sTemp;
					}
					
					try {
						if (sTemp.indexOf ("servlet/DataArea") == -1) {
							// [jj] A non-data area servlet call, so unlock the frameset.
							parent.ct.clearLock ();
						}
					}
					catch (e) {
					}
				}
				else {
					parent.ct.g_bLSNBGoingBack = false;
					_select (parent.ct.g_sLSNB);
					// Trigger the reload of the SNB frame.
					if (parent.ct.g_bSNBGoingBack == true) {
						parent.ct.history.back ();
					}
					else
						parent.ct.clearLock ();
				}
			}
		}
	}
	function _select (sSelectItem) {
		for (i = 0; i &lt;  g_vMenuItemName.length; i++) {
			if (g_vMenuItemName[i] == sSelectItem) {
				_performSelect (i + 1);
			}
		}
	}
	function _performSelect (nItem) {
		if (g_bIE55 == false || ( typeof (parent.ct.g_bModal) != "undefined") ) {
			if (parent.ct.g_bModal == false) {
				//DFCT101452 - When the text in any LSNB istem wraps, set font to 8pt
				if (g_bsmallfontreq == true){
					document.getElementById ("link_" + g_nLastItem).className = "lsnb-item lsnb-item-small-font";
					document.getElementById ("link_" + nItem).className = "lsnb-item lsnb-selection lsnb-item-small-font";
				}
				else {
					document.getElementById ("link_" + g_nLastItem).className = "lsnb-item";
					document.getElementById ("link_" + nItem).className = "lsnb-item lsnb-selection";
				}
				g_nLastItem= nItem;
				return true;
			}
		}
		return false;
	}
	</script>
	</head>
	<body class="lsnb" onLoad="javascript:init()">
		<table cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td align="center" valign="middle" style="height: 22px; width: 14px"><img src="/oma/images/blank.gif" style="height: 1px; width: 1px" /></td>
			<xsl:apply-templates />
		</tr>
		</table>
	</body>
	</html>
</xsl:template>

<xsl:template match="*">
	<script language="javascript">
	g_vMenuItemName[g_nMenuItem++] = '<xsl:value-of select="name()" />';
	if (g_sDefaultTarget == "") {
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp= '<xsl:value-of select="@app"/>';

	}
	if ('<xsl:value-of select="@default"/>' == 'true' || '<xsl:value-of select="name()"/>' == g_sDefaultItem) {
		g_nDefaultItem = g_nMenuItem;
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp= '<xsl:value-of select="@app"/>';

	}
	document.write ('&lt;td id="data_' + g_nMenuItem+ '" style="height=22px" align="center" valign="bottom" class="lsnb-item">');
	document.write ('&lt;a id="link_' + g_nMenuItem+ '" name="link_' + g_nMenuItem+ '" href="#" onclick="javascript:select(' + g_nMenuItem + ', \'<xsl:value-of select="@href" />\', \'<xsl:value-of select="@help" />\', \'<xsl:value-of select="@app"/>\')" class="lsnb-item">');
	</script >
	<xsl:choose>
		<xsl:when test="@display">
			<xsl:choose>
				<xsl:when test="@display='#'"></xsl:when>
				<xsl:otherwise><xsl:value-of select="@display" />&#160;</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise><xsl:value-of select="name()" />&#160;</xsl:otherwise>
	</xsl:choose>
	<script language="javascript">document.write ('&lt;/a>&lt;/td>');</script >
	<td align="center" valign="bottom" style="height: 22px; width: 17px">
		<script language="javascript">document.write ('&lt;img id="img_' + g_nMenuItem + '" src="/oma/<xsl:if test="/MenuList/@skin != ''">skins/<xsl:value-of select="/MenuList/@skin"/>/<xsl:if test="/MenuList/@scheme != ''">schemes/<xsl:value-of select="/MenuList/@scheme"/>/</xsl:if></xsl:if>images/lsnbsp.gif" style="height: 22px; width: 1px">');</script >
	</td>
</xsl:template>

</xsl:stylesheet>
