<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<xsl:template match="/OMA">
<html>
<head>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
	</xsl:if>
	<xsl:if test="Caller != '' ">
		<script language="javascript">
			function loadOrigPage()
			{
				document.location.href = '<xsl:value-of select="translate(Caller, ';', '&amp;amp;' )"/>' ;
			}
		</script>
	</xsl:if>
</head>
<body>
<center>
<br></br>
<span class="data-area-page-title"><xsl:value-of select="$strTheActionPerformed"/><xsl:if test="Failure/@reason != ''"><xsl:value-of select="$strBecause"/><xsl:call-template name="failure-reason" /></xsl:if><xsl:value-of select="$str"/></span>
<br></br>
<br></br>
<table border="0" cellpadding="0" cellspacing="0">
	<tr>
		<td align="left" valign="middle">
			 <table width="100" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<td width="14" height="25">
					<img style="width: 14px; height:25">
					<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lbutton.gif</xsl:attribute>
					</img>
					</td>
					<td class="data-area-button" align="center" valign="middle">
						<xsl:choose>
							<xsl:when test="Caller !=''">
								<a href="javascript:loadOrigPage();"><xsl:value-of select="$strBack"/></a>
							</xsl:when>
							<xsl:otherwise>
								<a href="javascript:history.back();"><xsl:value-of select="$strBack"/></a>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td width="14" height="25">
						<img style="width: 14px; height:25">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of 	select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rbutton.gif</xsl:attribute>
						</img>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</center>
</body>
</html>
</xsl:template>

<xsl:template name="failure-reason">
	<xsl:choose>
		<xsl:when test="Failure/@reason = 'UploadFileSizeExceedsLimit'"><xsl:value-of select="$strTheFileSize"/></xsl:when>
		<xsl:when test="Failure/@reason = 'NotEnoughSpaceForUpload'"><xsl:value-of select="$strNoSpaceForUpload"/></xsl:when>
	</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
