<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMTPHost = ''">
				<DataArea email="false" cancel="true" exportdata="false">
					<xsl:if test="OMAUserRights='7'">
						<xsl:attribute name="submitdisplay"><xsl:value-of select="$strGoToServer"/></xsl:attribute>
						<xsl:attribute name="submit">/servlet/DataArea?plugin=com.dell.oma.webplugins.SvrPrefWebPlugin&amp;help=Serverpreferences</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="canceltarget"><xsl:value-of select="translate(//Caller, ';', '&amp;amp;')"/></xsl:attribute>
					<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strEmailFailed"/></xsl:attribute>
					</PageTitle>
					<PromptText>
						<xsl:choose>
							<xsl:when test="OMAUserRights='7'"><xsl:value-of select="$strSetUpSMTP"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$strAskYourSystem"/></xsl:otherwise>
						</xsl:choose>
					</PromptText>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea email="false"  exportdata="false">
					<xsl:if test="Success != 'true'">
						<xsl:attribute name="cancel">true</xsl:attribute>
						<xsl:attribute name="canceltarget">javascript:cancel();</xsl:attribute>
					</xsl:if>
					<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
						<xsl:choose>
							<xsl:when test="Success ='true'">
								<xsl:attribute name="submit"><xsl:value-of select="translate(Caller, &apos;;&apos;,&apos;&amp;&apos;)"/></xsl:attribute>
								<xsl:attribute name="submitdisplay"><xsl:value-of select="$strGoBack"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="submit">/servlet/SubmitForm?plugin=com.dell.oma.webplugins.SendEmailWebPlugin</xsl:attribute>
								<xsl:attribute name="submitdisplay"><xsl:value-of select="$strSendEmail"/></xsl:attribute>
								<xsl:attribute name="validate">true</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strSendEmailMessage"/></xsl:attribute>
					</PageTitle>
					<xsl:choose>
						<xsl:when test="Success ='true'">
				<PromptText><xsl:value-of select="$strTheEmailMessage"/><xsl:value-of select="ToAddress"/><xsl:value-of select="$str"/></PromptText>
						</xsl:when>
						<xsl:when test="Exception != ''">
							<xsl:choose>
								<xsl:when test="Exception = '1'">
									<PromptText><xsl:value-of select="$strTheEmailMessage1"/><xsl:value-of select="ToAddress"/><xsl:value-of select="$strSince"/><xsl:value-of select="ToAddress"/><xsl:text> </xsl:text><xsl:value-of select="$strOr"/><xsl:text> </xsl:text><xsl:value-of select="FromAddress"/><xsl:value-of select="$strIsInvalidEnter"/></PromptText>
								</xsl:when>
								<xsl:otherwise>
									<PromptText><xsl:value-of select="$strTheEmailMessage2"/><xsl:value-of select="ToAddress"/><xsl:value-of select="$strEmailAddressMay"/></PromptText>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<PromptText></PromptText>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="Success !='true'">
						<ListData>
							<Data name="to" type="editbox" size="40"><xsl:attribute name="display"><xsl:value-of select="$strTo"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="ToAddress"/></xsl:attribute>
							</Data>
							<Data name="from"><xsl:attribute name="display"><xsl:value-of select="$strFrom"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="FromAddress"/></xsl:attribute>
							</Data>
							<Data name="subject" type="editbox" size="50"><xsl:attribute name="display"><xsl:value-of select="$strSubject"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Subject"/></xsl:attribute>
							</Data>
							<Data name="desc" type="textarea" cols="35" rows="5"><xsl:attribute name="display"><xsl:value-of select="$strMessage"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="Message"/></xsl:attribute>
							</Data>
						</ListData>
						<ListData>
							<Data name="Attach"><xsl:attribute name="display"><xsl:value-of select="$strAttachments"/></xsl:attribute></Data>
							<xsl:for-each select="Attachment/File">
								<xsl:variable name="filename"><xsl:value-of select="."/></xsl:variable>
								<xsl:if test="($filename != 'blank.html') and ($filename != 'calendar.html') and ($filename != 'pre.html')">
									<Data name="attachment" type="checkbox" state="3">
										<xsl:attribute name="returnvalue"><xsl:value-of select="@count"/></xsl:attribute>
										<xsl:attribute name="splcase">true</xsl:attribute>
										<xsl:if test="@href != ''">
											<ExtraItem link="true">
												<xsl:attribute name="href">javascript:showFile('<xsl:value-of select="@href"/>');</xsl:attribute>
												<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
											</ExtraItem>
										</xsl:if>
									</Data>
								</xsl:if>
							</xsl:for-each>
						</ListData>
						<ListData>
							<Data type="file" name="file" splcase="true"><xsl:attribute name="display"><xsl:value-of select="$strAddAttachment"/></xsl:attribute>
								<ExtraItem  type="button" href="javascript:uploadFile();"><xsl:attribute name="display"><xsl:value-of select="$strAddAttachment1"/></xsl:attribute></ExtraItem>
							</Data>
						</ListData>
						<HiddenTable>
							<Data type="hidden" name="smtp">
								<xsl:attribute name="returnvalue"><xsl:value-of select="SMTPHost"/></xsl:attribute>
							</Data>
							<Data type="hidden" name="pageTitle">
								<xsl:attribute name="returnvalue"><xsl:value-of select="PageName"/></xsl:attribute>
							</Data>
							<Data type="hidden" name="redirectURL">
								<xsl:attribute name="returnvalue"></xsl:attribute>
							</Data>
							<Data type="hidden" name="prevPage">
								<xsl:attribute name="returnvalue"><xsl:value-of select="Caller"/></xsl:attribute>
							</Data>
							<Data type="hidden" name="fileName"/>
						</HiddenTable>
					</xsl:if>
					<script language="javascript">
						function showFile(url)
						{
							url = top.gnv.appendVID(url);
							window.open(url, 'joe', config='scrollbars=yes,toolbar=no,menubar=no,resizable=no,location=no,directories=no,status=no');
						}
						function cancel()
						{
							location.href ='<xsl:value-of select="translate(//Caller, ';', '&amp;amp;')"/>';
						}
						
						function validate()
						{
							var inLength = <xsl:value-of select="string-length(Message)"/>
							if((document.getElementById("desc").value.length - inLength) > 256)
							{
								alert("<xsl:value-of select="$strErrorLessThan"/>");
								document.getElementById("desc").select();
								return false;
							}
							if(!isAlphaNumeric(document.getElementById("to").value, "to"))
							{
								return false;
							}
							if(!validateEmail(document.getElementById("to").value, "to"))
							{
								return false;
							}														
							if(!isAlphaNumeric(document.getElementById("subject").value, "subject"))
							{
								return false;
							}
							if(!isAlphaNumeric(document.getElementById("desc").value, "desc"))
							{
								return false;
							}
							if(!isAlphaNumeric(document.getElementById("file").value, "file"))
							{
								return false;
							}
							if (((document.getElementById("to").value).indexOf(',') != "-1") || ((document.getElementById("to").value).indexOf(';') != "-1")) {
								alert(<xsl:value-of select="$strXLATESTARTToDoesNot"/>);
								var to = "";
								var toVal = document.getElementById("to").value;
								if (toVal.indexOf(',') != "-1")
								{
									to = trim(toVal.substring(0 , toVal.indexOf(',')));
								}
								if (toVal.indexOf(';') != "-1")
								{
									to = trim(toVal.substring(0 , toVal.indexOf(';')));
								}
								document.getElementById("to").value = to;
								document.getElementById("to").focus();
								return false;
							}
							return true;
						}

         					// CHNG86594 Validate email address
						function validateEmail(str) 
						{
							var at = "@"
							var dot = "."
							var lat = str.indexOf(at);
							var lstr = str.length;
							var ldot = str.indexOf(dot);
						     var error = 0;
						
							if (str.indexOf(at) == -1)
							{
							      error = 1
						     }
							if (str.indexOf(at) == -1 || str.indexOf(at) == 0 || str.indexOf(at) == lstr)
							{
							      error = 1
						     }
							if (str.indexOf(dot) == -1 || str.indexOf(dot) == 0 || str.indexOf(dot) == lstr)
							{
							      error = 1
							}
							if (str.indexOf(at,(lat+1)) != -1)
							{
							      error = 1
						     }
							if (str.substring(lat-1,lat) == dot || str.substring(lat+1,lat+2) == dot)
							{
							     error = 1
						     }
							if (str.indexOf(dot,(lat+2)) == -1)
							{
							     error = 1
							}	
							if (str.indexOf(" ") != -1)
							{
							     error = 1
							}        
						     if (error == 1) 
						     {
						           alert ( "<xsl:value-of select="$strErrorEmailAddress"/>" + str  );
								 document.getElementById("to").focus();
						 	       return false					
						     } 
						     else
						     { 
						 	       return true					
						     }
                              }

						function isAlphaNumeric(text, context){
							var validValue = "&gt;&lt;&amp;?\"#%";
							var ok = "yes";
							var temp;
							for (var i=0; i&lt;text.length; i++)
							{
								temp = "" + text.substring(i, i+1);
								if (validValue.indexOf(temp) != "-1")
								{
									ok = "no";
									break;
								}
							}
							if (ok == "no")
							{
								if(context == "to")
								{
									msg = "<xsl:value-of select="$strErrorAlphanumericOr"/>";
								}
								else if(context == "subject")
								{
									msg = "<xsl:value-of select="$strErrorAlphanumericOr1"/>";

								}
								else if(context == "desc")
								{
									msg = "<xsl:value-of select="$strErrorAlphanumericOr2"/>";
								}
								else if(context == "file")
								{
									msg = "<xsl:value-of select="$strErrorAlphanumericOr3"/>";
								}

								alert ("<xsl:value-of select="$strError1"/>" + temp + "<xsl:value-of select="$strIsInvalid"/>" + msg + text);
								return false;
							}
							return true;
						}

						function ltrim ( s )
						{
							return s.replace( /^\s*/, "" )
						}

						function rtrim ( s )
						{
							return s.replace( /\s*$/, "" );
						}

						function trim ( s )
						{
							return rtrim(ltrim(s));
						}

						function uploadFile()
						{
							if(document.getElementById("file").value == '')
							{
								alert("<xsl:value-of select="$strYouMustSelect"/>");
								return;
							}

							if(!isAlphaNumeric(document.getElementById("file").value, "file"))
							{
								return;
							}
							else
							{
								var _fname = document.getElementById("file").value;
								var _ext = ".gif";

								if(_fname.indexOf(_ext) != -1)
								{
									alert(<xsl:value-of select="$strXLATESTARTYouShouldNot"/>);
									return;
								}
							}

							var count = <xsl:value-of select="Attachment/Count"/>;
							document.getElementById("dataarea").encoding = "multipart/form-data";
							document.getElementById("dataarea").enctype = "multipart/form-data";
							var regQuote = /\'/g;
							var PageName = "<xsl:value-of select="PageName"/>";
							PageName = PageName.replace (regQuote, "\\\'");
							var url = "/servlet/DataArea?plugin=com.dell.oma.webplugins.ShowSendEmailWebPlugin" +
								"&amp;pageTitle="+PageName ;
							if(count == 1)
							{
								url = url + '&amp;attachment=' +  document.getElementById("attachment").value;
							}
							else
							{
								for(i=0; i &lt;document.dataarea.attachment.length; i++)
								{
									if(document.dataarea.attachment[i].checked == true)
									{
										url = url + '&amp;attachment=' +  document.dataarea.attachment[i].value;
									}
								}
							}
							url = url +  '&amp;toAddr=' + document.getElementById("to").value;
							url = url +  '&amp;sendto=' + document.getElementById("to").value;
							document.getElementById("dataarea").redirectURL.value = url;
							document.getElementById("dataarea").action = "/servlet/UploadServlet?caller=email";
							uploadStart (document.dataarea.file.value, '');
							formSubmit();
						}
					</script>
					<script language="JavaScript" src="/oma/js/Upload.js" />
					<HTMLData>
						<iframe id="uploadtest" name="uploadtest" style="visibility: hidden; height: 1px; width: 1px; top: 0px; left: 0px; position: absolute; z-index: -1" src="/oma/blank.html"></iframe>
					</HTMLData>
				</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
