<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<xsl:template match="/OMA">
	<HTML>
	<HEAD>
	<TITLE><xsl:value-of select="$strLogout"/></TITLE>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	</HEAD>
	<script language="javascript">
		var id = 0;
		function init() {
			if(id == 1)
			{
					 //[ pp 03/18/2003 ] DFCT 75148: Adding code to determine if server is being rebooted
				  	 // or shutdown so that appropriate message can be displayed during log out.
					 // Changes for this defect are also included in shtdwnWebPlugin.java, OMSALogoutServlet.java,
				  	 // ClBrowserWebPlugin.java, locond.xsl, clbrowser.xsl(code and str)			
				<xsl:variable name="action"><xsl:value-of select="SvrAction"/></xsl:variable>
				<xsl:choose>
					<xsl:when test="$action='reboot'">document.getElementById("shtdwn").innerHTML=<xsl:value-of select="$strRebootMsg"/>;</xsl:when>
					<xsl:otherwise>document.getElementById("shtdwn").innerHTML=<xsl:value-of select="$strShtdwnMsg"/>;
					</xsl:otherwise>
				</xsl:choose>
				
				
			}
			if(id == 0)
			{
				id++;
			}
			var t1 = window.setTimeout("init()", 2000);
		}
	</script>
	<BODY onload="javascript:init()">
		<br />
		<div align="center" class="logout-header">
			<!-- WARNING: Three-part order-dependent message goes here. -->
			<!-- Japanese wants the product name first; all other languages want it last. -->
			<xsl:value-of select="$strThankYouFor_Part1"/>
			<!-- Part2 of the three-part message is not used. -->
			<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="ProdName"/></xsl:with-param></xsl:call-template>
			<xsl:value-of select="$strThankYouFor_Part3"/>
		</div>
		<br />
		<div id="shtdwn" align="center" class="logout-prompt-text">
			<!-- WARNING: Three-part order-dependent message goes here. -->
				<!-- Japanese wants the product name first; all other languages want it last. -->
			    <xsl:value-of select="$strYouHaveSuccessfully_Part1"/>
			    <!-- Part2 of the three-part message is not used. -->
				<xsl:call-template name="ProdName">
					<xsl:with-param name="prodname">
						<xsl:value-of select="ProdName"/>
					</xsl:with-param>
				</xsl:call-template>
			    <xsl:value-of select="$strYouHaveSuccessfully_Part3"/>					
		</div>
		<br />
		<br />
	</BODY>
	</HTML>
</xsl:template>
<xsl:template name="ProdName">
	<xsl:param name="prodname"/>
	<xsl:choose>
		<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
