<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:template match="/MenuList">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	<script language="javascript">
	var g_nLastMenuItem = 0;
	var g_nMenuItem = 0;
	var g_nDefaultItem= 1;
	var g_sDefaultTarget = "";
	var g_sDefaultHelp = "";
	var g_sDefaultApp = "";
	var g_vMenuItemName = new Array();
	var g_sCurrentComponent = "";
	var g_iLeftCorner;
	var g_iRightCorner;
	var g_iBlank;
	var g_sDefaultItem = '<xsl:value-of select="@snb" />';
	var g_sDefaultLSNB = '<xsl:value-of select="@lsnb" />';

	function init () {
		g_iLeftCorner = new Image ();
		g_iLeftCorner.src = "/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/snbltab.gif";
		g_iRightCorner = new Image ();
		g_iRightCorner.src = "/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/snbrtab.gif";
		g_iBlank = new Image ();
		g_iBlank.src = "/oma/images/blank.gif";
		select  (g_nDefaultItem, g_sDefaultTarget, g_sDefaultHelp, g_sDefaultApp);

		// For each item on the list, if required, increase the size of the table element until it is displayed in a single row.
		for (i = 0; i &lt; g_nMenuItem; i++) {
			var anchor = document.getElementById("anchor_" + (i + 1));
			var td = document.getElementById("data_" + (i + 1));
			var nFirstWidth = anchor.offsetHeight;
			while (anchor.offsetHeight > 16) {
				td.width++;
				// Verify that the resize of the TD element is actually working.  If it isn't supported by the browser, exit the loop.
				if  (nFirstWidth == anchor.offsetHeight) break;
			}
		}
	}
	function select (nSelectedItem, sTarget, sHelp, sApp) {
		if (_performSelect (nSelectedItem) == true) {
			if (sTarget != "") {
				var sTemp = sTarget;
				if (sTemp.indexOf ("?") != -1) {
					sTemp += "&amp;";
				}
				else {
					sTemp += "?";
				}
				sTemp = sTemp + "help=" + sHelp + "&amp;app=" + sApp + '&amp;component=' + g_sCurrentComponent + '&amp;snb=' + sSelectedItem + '&amp;lsnb=' + g_sDefaultLSNB;
				parent.lsnb.location.href = sTemp;
			}
			else {
				var sSelectedItem = '';
				if (g_nMenuItem > 0)
					sSelectedItem = g_vMenuItemName[nSelectedItem - 1]
				parent.lsnb.location.href = '/servlet/LoadLSNB?component=' + g_sCurrentComponent + '&amp;snb=' + sSelectedItem + '&amp;lsnb=' + g_sDefaultLSNB;
			}
		}
	}
	function _select (sSelectItem) {
		for (i = 0; i &lt;  g_vMenuItemName.length; i++) {
			if (g_vMenuItemName[i] == sSelectItem)
				_performSelect (i + 1);
		}
	}
	function _performSelect (nSelectedItem) {
		if (parent.ct.g_bModal == false) {
			unHighlight (g_nLastMenuItem);
			g_nLastMenuItem = nSelectedItem;
			if (g_nMenuItem > 0) {
				document.images["img1_" + g_nLastMenuItem].src = g_iLeftCorner.src;
				document.images["img2_" + g_nLastMenuItem].src = g_iRightCorner.src;
				document.getElementById ("anchor_" + g_nLastMenuItem).className= "snb-item snb-selection";
				document.getElementById("data_" + g_nLastMenuItem).className = "snb-item snb-selection";
			}
			return true;
		}
		return false;
	}
	function unHighlight (nSelectedItem) {
		if (nSelectedItem == 0) return;
		document.images["img1_" + nSelectedItem].src = g_iBlank.src;
		document.images["img2_" + nSelectedItem].src = g_iBlank.src;
		document.getElementById("data_" + nSelectedItem).className = "snb-item";
		document.getElementById ("anchor_" + nSelectedItem).className = 'snb-item';
	}
	function reloadTree () {
		parent.ct.location.href='/servlet/ComponentTree'
	}
	</script>
	</head>
	<body class="snb" onLoad="javascript:init()">
		<table height="30" cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td style="width: 18px">&#160;</td>
			<xsl:apply-templates />
		</tr>
		</table>
	</body>
	</html>
</xsl:template>

<xsl:template match="Server">
</xsl:template>

<xsl:template match="Selection">
	<script language="javascript">
	g_sCurrentComponent = '<xsl:value-of select="@name" />';
	</script>
</xsl:template>

<xsl:template match="*">
	<script language="javascript">
	g_vMenuItemName[g_nMenuItem++] = '<xsl:value-of select="name()" />';
	if (g_nMenuItem == 1) {
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp = '<xsl:value-of select="@app"/>';
	}
	if ('<xsl:value-of select="@default"/>' == 'true' || '<xsl:value-of select="name()"/>' == g_sDefaultItem) {
		g_nDefaultItem = g_nMenuItem;
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
	}
	</script>
	<td valign="bottom">
		<table cellpadding="0" cellspacing="0" border="0">
		<tr >
			<td style="width: 13px; height: 24px" align="right">
				<script language="javascript">
					document.write ('&lt;img id="img1_' + g_nMenuItem + '" src="/oma/images/blank.gif" style="width: 10px; height: 24px">');
				</script >
			</td>
			<script language="javascript">
				document.write ('&lt;td id="data_' + g_nMenuItem+ '" class="snb-item" style="height: 24px; width: 80px" valign="middle" align="center">');
				document.write ('&lt;a id="anchor_' + g_nMenuItem+ '" name="anchor_' + g_nMenuItem+ '" href="#" onclick="javascript:select(' + g_nMenuItem + ', \'<xsl:value-of select="@href" />\', \'<xsl:value-of select="@help" />\', \'<xsl:value-of select="@app" />\')" class="snb-item">');
			</script >
			<xsl:choose>
				<xsl:when test="@display"><xsl:value-of select="@display" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="name()" /></xsl:otherwise>
			</xsl:choose>
			<script language="javascript">document.write ('&lt;/a>&lt;/td>');</script >
			<td style="width: 13px; height: 24px" align="left">
				<script language="javascript">document.write ('&lt;img id="img2_' + g_nMenuItem + '" src="/oma/images/blank.gif" style="width: 10px; height: 24px">');</script>
			</td>
		</tr>
		</table>
	</td>
</xsl:template>

</xsl:stylesheet>
