<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<xsl:template match="/OMA">
	<HTML>
	<HEAD>
	<TITLE>
		<xsl:choose>
			<xsl:when test="StopWebServer"><xsl:value-of select="$strStopServer"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$strLogout"/></xsl:otherwise>
		</xsl:choose>
	</TITLE>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	</HEAD>
	
	<script language="javascript">
		function init() {
			var div_CloseBrowser = document.getElementById ("button_CloseBrowser");
			<xsl:if test="RestartWebServer/@login='true'">
				document.getElementById("login").noWrap = true;
			</xsl:if>
			document.getElementById("clbr").noWrap = true;
			window.opener=top;
			//window.opener is still null we cannot close the window so lets hide "Close Browser" button
			if ( window.opener == null )
			{
				div_CloseBrowser.style.display = "none";
			}
		}

	</script>
	<BODY onload="javascript:init();">
		<br />
		<xsl:if test="not(StopWebServer)">
			<div align="center" class="logout-header">
				<!-- WARNING: Three-part order-dependent message goes here. -->
				<!-- Japanese wants the product name first; all other languages want it last. -->
				<xsl:value-of select="$strThankYouFor_Part1"/>
				<!-- Part2 of the three-part message is not used. -->
				<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="ProdName"/></xsl:with-param></xsl:call-template>
				<xsl:value-of select="$strThankYouFor_Part3"/>
			</div>
		</xsl:if>
		
		<br />
		<div align="center">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="StopWebServer='true'">logout-header</xsl:when>
					<xsl:otherwise>logout-prompt-text</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:choose>		
				<xsl:when test="RestartWebServer='true' and RestartWebServer/@login = 'true'"> 
					<xsl:value-of select="$strTheWebServer"/> 
				</xsl:when>

				<xsl:when test="RestartWebServer='true' and RestartWebServer/@login != 'true'"> 
					<xsl:value-of select="$strRestartWebServer"/><xsl:text> </xsl:text><xsl:value-of select="$strRelaunchBrowserBefore"/>
				</xsl:when>

				<!--xsl:when test="RestartWebServer='true'">
					<xsl:value-of select="$strTheWebServer"/>
					<xsl:if test="RestartWebServer/@login != 'true'">
						<br/><br/>
						<xsl:value-of select="$strRelaunchBrowserBefore"/>
					</xsl:if>					
				</xsl:when-->
				
				<xsl:when test="StopWebServer='true'">
					<xsl:value-of select="$strStopWebServer"/>
				</xsl:when>
				<xsl:otherwise>
    				<!-- WARNING: Three-part order-dependent message goes here. -->
    				<!-- Japanese wants the product name first; all other languages want it last. -->
				    <xsl:value-of select="$strYouHaveSuccessfully_Part1"/>
				    <!-- Part2 of the three-part message is not used. -->
					<xsl:call-template name="ProdName">
						<xsl:with-param name="prodname">
							<xsl:value-of select="ProdName"/>
						</xsl:with-param>
					</xsl:call-template>
				    <xsl:value-of select="$strPeriod"/>
				    <xsl:text> </xsl:text>
				    <xsl:value-of select="$strYouHaveSuccessfully_Part3"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>
		<br />
		<br />
		<div align="center">
			<table width="100" border="0" cellpadding="0" cellspacing="0">
				<tr>
					<xsl:if test="RestartWebServer/@login='true'">
						<td>
							<table width="100" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td width="14" height="25">
										<img style="width: 14px; height:25">
											<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if 	test="/OMA/@scheme != ''">schemes/	<xsl:value-of 		select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lbutton.gif</xsl:attribute>
										</img>
									</td>
									<td id="login" class="data-area-button" align="center" valign="middle">
										<a target="_top">
											<xsl:attribute name="href"><xsl:value-of select="Scheme"/>://<xsl:value-of select="RestartWebServer/@ipaddress"/>:<xsl:value-of select="RestartWebServer/@port"/>/servlet/OMSALogin?msgStatus=null</xsl:attribute>
											<xsl:value-of select="$strLog160in"/>
										</a>
									</td>
									<td width="14" height="25">
										<img style="width: 14px; height:25">
											<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if 	test="/OMA/@scheme != ''">schemes/	<xsl:value-of 		select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rbutton.gif</xsl:attribute>
										</img>
									</td>
								</tr>
							</table>
						</td>
						<td>
							<table width="100" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td width="15" height="25"></td>								
								</tr>
							</table>
						</td>
					</xsl:if>
					<td>
						<div id="button_CloseBrowser">
							<table width="100" border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td width="14" height="25">
										<img style="width: 14px; height:25">
											<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/	<xsl:value-of 		select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lbutton.gif</xsl:attribute>
										</img>
									</td>
									<td id="clbr" class="data-area-button" align="center" valign="middle"><a href="javascript:window.close()" target="_top"><xsl:value-of select="$strClose160Browser"/></a></td>
									<td width="14" height="25">
										<img style="width: 14px; height:25">
											<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/	<xsl:value-of 		select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rbutton.gif</xsl:attribute>
										</img>
									</td>
								</tr>
							</table>
						</div>
					</td>
				</tr>
			</table>
		</div>
	</BODY>
	</HTML>
</xsl:template>

<xsl:template name="ProdName">
		<xsl:param name="prodname"/>
		<xsl:choose>
			<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
		</xsl:choose>
</xsl:template>
	
<xsl:template match="*"/>
</xsl:stylesheet>
