<?xml version="1.0" encoding="UTF-8"?>  
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" encoding="UTF-8"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
				<script language="javascript">
				function g_appendVid_InvokeAction(var1)
				{
					var1 = top.gnv.appendVID(var1);
					document.location.href = var1;
						
				}
				</script>
				
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="DataArea">
		<html>
			<head>
				<title/>
				<!-- Comment 1: -->
				<xsl:choose>
					<xsl:when test="ProgressBar/@progressdata='true'"><!-- Do nothing here --></xsl:when>
					<xsl:otherwise>
						<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css"/>
						<xsl:if test="/OMA/@skin != ''">
							<link rel="stylesheet" type="text/css">
								<xsl:attribute name="href">/oma/skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
							</link>
							<xsl:if test="/OMA/@language != ''">
								<link rel="stylesheet" type="text/css">
									<xsl:attribute name="href">/oma/skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if><xsl:value-of select="/OMA/@language"/>/scheme.css</xsl:attribute>
								</link>
								<xsl:if test="/OMA/@country != ''">
									<link rel="stylesheet" type="text/css">
										<xsl:attribute name="href">/oma/skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if><xsl:value-of select="/OMA/@language"/>/<xsl:value-of select="/OMA/@country"/>/scheme.css</xsl:attribute>
									</link>
								</xsl:if>
							</xsl:if>
						</xsl:if>
						<xsl:if test="/OMA/@component != ''">
							<script language="javascript" src="/oma/js/dabb.js" />
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Comment 1: END-->
				<script language="javascript">
					var g_bSubmit = false;
					var g_bStopOldRefresh = false; 
					var numOfTables = 0;
					var g_sPrintURL = '<xsl:value-of select="@printURL"/>';
					<!-- Comment 2: -->
					<xsl:choose>
						<xsl:when test="@onLoad ='true'">
							moreFuncInInit = new Boolean(true);
						</xsl:when>
						<xsl:otherwise>
							moreFuncInInit = new Boolean(false);
						</xsl:otherwise>
					</xsl:choose>
					<!-- Comment 2: END-->
					<!-- Comment 3: -->
					<xsl:choose>
						<!-- Comment 4: -->
						<xsl:when test="@progressbar='true'">
							<xsl:choose>
								<!-- Comment 5: -->
								<xsl:when test="ProgressBar/@progressdata='true'">
									function init()
									{
										<xsl:for-each select="ProgressBar/ProgressData/DataBar">
											parent.updateProgressBar('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', '<xsl:value-of select="@percentcomplete"/>', <xsl:value-of select="@execstatus"/>, '<xsl:value-of select="@allpassesdone"/>', '<xsl:value-of select="@passnum"/>', '<xsl:value-of select="@totalpasses"/>','<xsl:value-of select="@message"/>', '<xsl:value-of select="@statusmsg"/>');
										</xsl:for-each>
										<xsl:if test="ProgressBar/ProgressData/@iscomplete='true'">
											parent.update(false);
											<xsl:if test="ProgressBar/ProgressData/@reset">
												document.location.href = '<xsl:value-of select="ProgressBar/ProgressData/@reset"/>';
											</xsl:if>
										</xsl:if>
									}
								</xsl:when>
								<!-- Comment 5:END -->
								<!-- Comment 6: -->
								<xsl:when test="ProgressBar/@uidata='true'">
									var flag 				= false;
									var updateStatus = true;
									var isRunning 		= false;

									var complete 		= new Image();
									var fail 				= new Image();
									var abort 			= new Image();
									var suspend 		= new Image();
									var warning 		= new Image();
									var running 		= new Image();

									complete.src 		= "/oma/images/ok.gif";
									fail.src 				= "/oma/images/critical.gif";
									abort.src 			= "/oma/images/abort.gif";
									suspend.src 		= "/oma/images/suspend.gif";
									warning.src 		= "/oma/images/non-critical.gif";
									running.src 		= "/oma/images/progress.gif";

									function init()
									{
										try{
											parent.ct.daLoad = true;
										}
										catch(e) {
										}
										<xsl:choose>
											<xsl:when test="@ignoreJumpBar"></xsl:when>
											<xsl:otherwise>
												var tmp_div	= document.getElementById("tableBar");

												if(numOfTables &gt; 1)
												{
													tmp_div.style.display = "";
												}
											</xsl:otherwise>
										</xsl:choose>

										if(moreFuncInInit.toString() == "true")
										{
											initializationRoutine();
										}

										getProgress();
									}

									function getProgress()
									{
										if (updateStatus == true)
										{
											var timer1 = setTimeout("getProgress()", <xsl:value-of select="ProgressBar/@frequency"/>);

											if (isRunning != true)
											{
												isRunning = true;
												window.frames[0].location.href="<xsl:value-of select="ProgressBar/UIData/Update/@href"/>";
												var timer2 = setTimeout("resetProgress()", 30000);
											}
										}
									}

									function resetProgress()
									{
										isRunning = false;
									}

									function update(value)
									{
										if (value == false)
										{
											updateStatus = false;
											updateButton('none');
										}
									}

									function updateProgressBar(obj, progress, code, isComplete, start, end, msg, statusmsg)
									{
										isRunning = false;

										var a = document.getElementById("statusPercentage" + obj);
										if (a == null || a == "") return;
										if (a.innerHTML != progress + "%")
										{
											a.innerHTML = progress + "%";

											var bars = Math.floor(progress / 4);

											for (var i = 1; 25 &gt;= i; i++)
											{
												var a = document.getElementById("bar" + i + "_" + obj);
												if (a == null || a == "") return;

												if (bars &gt;= i) a.style.backgroundColor = "#000084";
												else a.style.backgroundColor = "";
											}
										}

										if (isComplete == "true")
										{
											c_Success = 2;
											c_Failed = 0;
											c_Aborted = 1;
											c_Warning = 5;
											
											if (code == c_Success)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = complete.src;
												a.title = '<xsl:value-of select="$strStatusCompleted"/>';
											}
											else if (code == c_Aborted)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = abort.src;
												a.title = '<xsl:value-of select="$strStatusAborted"/>';
											}
											else if (code == c_Failed)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = fail.src;
												a.title = '<xsl:value-of select="$strStatusFailed"/>';

												a = document.getElementById("statusText" + obj);
												if (a == null || a == "") return;
												a.innerHTML = "&lt;a href='#' onclick='javascript:alert(<xsl:value-of select="$strMsg"/>)' style='color: blue'&gt;<xsl:value-of select="$strDetails"/>&lt;/a&gt;";
											}
										     <!-- 96791 add warning icon capability to progress bar -->
											else if (code == c_Warning)
											{
												var a = document.images["statusImage" + obj];
												if (a == null || a == "") return;
												a.src = warning.src;
												a.title = '<xsl:value-of select="$strStatusNonCritical"/>';

												a = document.getElementById("statusText" + obj);
												if (a == null || a == "") return;
												a.innerHTML = "&lt;a href='#' onclick='javascript:alert(<xsl:value-of select="$strMsg"/>)' style='color: blue'&gt;<xsl:value-of select="$strDetails"/>&lt;/a&gt;";
											}

										}
										<!-- C68431 - Adding support for multiple Interrupt Actions -->
										else
										{
											c_Suspended = 4;
											c_Running = 3;
											if(code == c_Suspended)
											{
												var a = document.images["statusImage" + obj];
												if ( a == null || a =="") return;
												a.src = suspend.src;
												a.title = '<xsl:value-of select="$strSuspended"/>';
											}
											else if(code == c_Running)
											{
												var a = document.images["statusImage" + obj];
												if ( a == null || a =="") return;
												a.src = running.src;
												a.title = '<xsl:value-of select="$strRunning"/>';											}
											
										}
										<!-- MOH change 75429 . Only display pass if number of passes greater than 0 -->
										if ( end > 0 )
										{
											var a = document.getElementById("statusPass" + obj);
											if (a == null || a == "") 
												return;
											// 75556 - if custom status msg is not provided, display standard 'pass x of y' else display custom msg
											if(statusmsg == ""){
												if (a.innerHTML != <xsl:value-of select="$strPass" />) 
													a.innerHTML = <xsl:value-of select="$strPass1"/>;
											}
											else{
												if (a.innerHTML != statusmsg) 
													a.innerHTML = statusmsg;
											}
										}
									}
									
									<!-- C68431 - Adding support for multiple Interrupt Actions -->
									function updateButton(name)
									{
										var abortBtn		= document.getElementById("abortbutton");
										var suspendBtn	= document.getElementById("suspendbutton");
										var resumeBtn		= document.getElementById("resumebutton");
										var resultBtn		= document.getElementById("resultbutton");
										
										<!--case 1: Abort has been clicked. Hide Abort, Suspend, Resume and display Results--> 
										if (name == 'abort')
										{
											if (abortBtn != null &amp;&amp; abortBtn !="")
											{
												abortBtn.style.display = "none";
											}
											if (suspendBtn != null &amp;&amp; suspendBtn !="")
											{
											    suspendBtn.style.display = "none";
											}
   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
											{
												resumeBtn.style.display = "none";
											}
   											if (resultBtn != null &amp;&amp; resultBtn !="")
											{
												resultBtn.style.display = "";
											}
										}
										
										<!-- case 2 : Suspend has been clicked. Hide Suspend, Results and Display resume, abort -->
										else if(name == 'suspend')
										{
											if (abortBtn != null &amp;&amp; abortBtn !="")
											{
												abortBtn.style.display = "";
											}
											if (suspendBtn != null &amp;&amp; suspendBtn !="")
											{
											    suspendBtn.style.display = "none";
											}
   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
											{
												resumeBtn.style.display = "";
											}
   											if (resultBtn != null &amp;&amp; resultBtn !="")
											{
												resultBtn.style.display = "none";
											}
										}
										
										<!-- case 3 : Resume has been clicked. Hide Resume, results and display abort, suspend -->
										
										else if(name == 'resume')
										{
											if (abortBtn != null &amp;&amp; abortBtn !="")
											{
												abortBtn.style.display = "";
											}
											if (suspendBtn != null &amp;&amp; suspendBtn !="")
											{
											    suspendBtn.style.display = "";
											}
   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
											{
												resumeBtn.style.display = "none";
											}
   											if (resultBtn != null &amp;&amp; resultBtn !="")
											{
												resultBtn.style.display = "none";
											}
										}										
										<!-- Case 4 : Default existing code, added code to hide suspend and resume
												This case will be exceuted when test is complete. -->
										else if(name == 'none')
										{
											if (abortBtn != null &amp;&amp; abortBtn != "")
											{
												if(abortBtn.style.display == "")
												{
													abortBtn.style.display = "none";
												}
												if (suspendBtn != null &amp;&amp; suspendBtn !="")
												{
												    suspendBtn.style.display = "none";
												}
	   											if (resumeBtn != null &amp;&amp; resumeBtn !="")
												{
													resumeBtn.style.display = "none";
												}
											}										
	
											if (resultBtn != null &amp;&amp; resultBtn != "")
											{
												if(resultBtn.style.display == "none")
												{
													resultBtn.style.display = "";
												}
											}
	
											flag = true;
										}
										
										<!-- Old code to be deleted 
										if (abutton != null &amp;&amp; abutton != "")
										{
											if(abutton.style.display == "")
											{
												a.style.display = "none";
											}
										}

										var b = document.getElementById("resultbutton");
										if (b != null &amp;&amp; b != "")
										{
											if(b.style.display == "none")
											{
												b.style.display = "";
											}
										}

										flag = true; 
										Code to be deleted ends -->

										<!--following code is only used by local update. -->
										<xsl:if test="ProgressBar/@autoredirect">
											var redirecttimer = setTimeout('autoRedirect()',3000);
										</xsl:if>
									}

									<!--following code is only used by local update. -->
									<xsl:if test="ProgressBar/@autoredirect">
										function autoRedirect()
										{
											document.location.href = '<xsl:value-of select="ProgressBar/UIData/Result/@href"/>;
										}
									</xsl:if>

									function buttonCall(action, href)
									{
										if (flag)
										{
											document.location.href = <xsl:value-of select="ProgressBar/UIData/Result/@href"/>;
										}
										else
										{
											var pgbar = document.getElementById("progressbar");
											if (pgbar == null || pgbar == "") return;
											pgbar.src = href;
											<!-- Call updateButton only if action is suspend or resume since it was not being done for legacy abort code -->
											if(action == 'suspend')
												updateButton('suspend');
											else if(action == 'resume')
												updateButton('resume');
										}
									}
								</xsl:when>
								<!-- [pp] 10/09/03 - adding empty init function when ProgressBar is not defined to prevent javascript 
									   error from ocuuring when Progressbr is not defined -->
								<xsl:when test="not(ProgressBar)">
									function init(){}
								</xsl:when>
								<xsl:otherwise></xsl:otherwise>
								<!-- Comment 6: END-->
							</xsl:choose>
						</xsl:when>
						<!-- Comment 4: END-->
						<!-- Comment 7: -->
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="PerformanceData/@type='realdata'">
									function init()
									{
										<xsl:for-each select="PerformanceData/UpdateData/Graph">
											parent.reDrawGraphs('<xsl:value-of select="@name"/>', '<xsl:value-of select="@percent"/>', <xsl:value-of select="Data/@ptime"/>,
																		<xsl:value-of select="Data/@utime"/>, <xsl:value-of select="Data/@pvtime"/>, <xsl:value-of select="Data/@interrupts"/>);
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/DiskData">
											parent.reDrawDisk('<xsl:value-of select="@name"/>', '<xsl:value-of select="Data/@wrs"/>', '<xsl:value-of select="Data/@bwps"/>',
																		'<xsl:value-of select="Data/@rps"/>', '<xsl:value-of select="Data/@brps"/>');
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/MemData">
											parent.reDrawMem('<xsl:value-of select="@name"/>', '<xsl:value-of select="Data/@pfps"/>', <xsl:value-of select="Data/@pps"/>,
																		<xsl:value-of select="Data/@ab"/>, <xsl:value-of select="Data/@cb"/>, <xsl:value-of select="Data/@cl"/>);
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/VirMemData">
											parent.reDrawVirMem('<xsl:value-of select="@name"/>', '<xsl:value-of select="Data/@pu"/>', <xsl:value-of select="Data/@pup"/>);
										</xsl:for-each>

										<xsl:for-each select="PerformanceData/UpdateData/BoxData/NTWData">
											parent.reDrawNtw('<xsl:value-of select="@name"/>',  '<xsl:value-of select="Data/@btps"/>', '<xsl:value-of select="Data/@pps"/>',
																	'<xsl:value-of select="Data/@prps"/>', '<xsl:value-of select="Data/@psps"/>', '<xsl:value-of select="Data/@cb"/>',
																	'<xsl:value-of select="Data/@brps"/>', '<xsl:value-of select="Data/@bsps"/>');
										</xsl:for-each>
									}
								</xsl:when>
								<xsl:otherwise>
									function init()
									{
										try{
											parent.ct.daLoad = true;
										}
										catch(e) {
										}
										<xsl:choose>
											<xsl:when test="@ignoreJumpBar"></xsl:when>
											<xsl:otherwise>
												var tmp_div	= document.getElementById("tableBar");

												if(numOfTables &gt; 1)
												{
													tmp_div.style.display = "";
												}
											</xsl:otherwise>
										</xsl:choose>

										if(moreFuncInInit.toString() == "true")
										{
											initializationRoutine();
										}
										try {
											g_bStopOldRefresh = false;
											// [jj] A data area servlet call, so unlock the frameset.
											parent.ct.clearLock ();
										}
										catch (e) {
										}
										<!-- 
										      C81980
										      Allow the user to refresh the view when component updates are available in the server.
										-->
										<xsl:if test="/OMA/@update-available='true'">
											component_update();
										</xsl:if>
									}
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
						<!-- Comment 7: END-->
					</xsl:choose>
					<!-- Comment 3: END-->
					<!-- Comment 8: -->

			<xsl:choose>
				<xsl:when test="ProgressBar/@progressdata='true'"><!-- Do nothing here --></xsl:when>
				<xsl:otherwise>
					<!-- C107102 - Need ability to disable buttons -->
					function disableButtons(sSubmit, sBack, sCancel){
						if (sSubmit == 'submit'){
							document.getElementById("submitbuttoncontent").style.display='none';
					  	}
					  	if (sBack == 'back'){
							document.getElementById("backbutton").style.display='none';									
                              }
					  	if (sCancel == 'cancel'){
							document.getElementById("cancelbutton").style.display='none';									
                              }
                                        }
					function DataAreaPrint(expandFlag)
					{
						if (g_sPrintURL != '') {
							g_sPrintURL = top.gnv.appendVID(g_sPrintURL);
							parent.pf.document.location.replace (g_sPrintURL);
							window.setTimeout (printCallback(expandFlag), 100);
						}
						else {
							<!--  expand all the divs  -->
							if (expandFlag == true){
								alterImage("plus" , "minus");
								expandDiv(document.getElementsByTagName("HTML")[0]);
							}

							parent.da.focus();
							parent.da.print();

							<!--  collapse all the divs  -->
							
							if (expandFlag == true){
								parent.da.location.reload();
								/*alterImage("minus" , "plus");
								collapseDiv(document.getElementsByTagName("HTML")[0]);*/
							}
						}
					}

					function printCallback (expandFlag) {
						if (parent.pf.document.readyState != 'complete') {
							window.setTimeout (printCallback(expandFlag), 100);
						}
						else {

							<!--  expand all the divs  -->
							if (expandFlag == true){
								alterImage("plus" , "minus");
								expandDiv(document.getElementsByTagName("HTML")[0]);
							}

							parent.pf.focus ();
							parent.pf.print ();

							<!--  collapse all the divs  -->
							if (expandFlag == true){
								parent.da.location.reload();
								/*alterImage("minus" , "plus");
								collapseDiv(document.getElementsByTagName("HTML")[0]);*/
							}
						}
					}
					<!-- Comment 8: END-->
					<!-- Comment 9: -->
					function changeStateTbl(name, numofitems)
					{
						var changeImgTo = "";
						numofitems++;
						for(var item=1; numofitems &gt; item; item++)
						{
							var tableID	= document.getElementById("div"+item+name);

							if(tableID.style.display == "none")
							{
								tableID.style.display = "";
								changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctminus.gif";
							}
							else
							{
								tableID.style.display = "none";
								changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif" ;
							}
						}

						document.images["image_" + name].src =  changeImgTo;
					}
					<!-- Comment 9: END-->

					<!-- Comment 10: Add this script only in the presence of date objects.-->
					<xsl:if test="@date='true'">
					
						<!--89828 Allow initialize of date value-->
					     function convertDate(  dateName, dateInit, srvoffset  )
						{
							if ( ( dateInit.length != 0 ) &amp;&amp; ( !isNaN( dateInit ) ) )
							{
								var initNum =  Number( dateInit );
								var date_var1 = new Date( initNum );
								if ( ( srvoffset.length != 0 ) &amp;&amp; ( !isNaN( srvoffset ) ) )
								{
									var client_offset_cal = new Date();
									var clientOffsetMins = client_offset_cal.getTimezoneOffset();
									
									var adjustedFinalTime = new Number( dateInit ) + new Number( srvoffset ) + new Number( clientOffsetMins * 60 * 1000 );
									date_var1 = new Date( adjustedFinalTime );									
								}
														
								var sdispLongDate = date_var1.toString();
								var sdateString1 = sdispLongDate.substr(0,sdispLongDate.indexOf(':')-2);
								var sYear = date_var1.getYear();
								if (navigator.appName == 'Netscape')
						        	{
						        	    var sdispDate = sdateString1;
						        	}
						        	else
						        	{
								var sdispDate = sdateString1 + sYear;
						        	}								
								if ( typeof sdispDate != "undefined")
								{
			                                        document.getElementById( dateName + "Hid" ).value = sdispDate ;
       		                              document.getElementById( dateName ).value = date_var1.getTime();
								}				    						
							}
						}
					
						function validateDate( userdate )
						{
							<!-- any date after [January 18, 19:14:07, 2038] is invalid on a 32 bit machine.-->
							
							var restrictedDateOn32BitMachine = new Date( 2038, 0, 18, "19", "14", "07" );

							if( userdate &gt; restrictedDateOn32BitMachine.getTime() )
							{
								if( parent.ct.machineArchType == 32 )
								{
									alert("<xsl:value-of select="$strInvalidDateMsg"/>");
							   		return false;
								}
								else
								{
									return true;
								}
							}
							else
							{
								return true;
							}
						}

						function showCalendar(img, datebox)
						{
							document.getElementById("currentDateObj").value = datebox;

							var state = document.getElementById("calendar");
							if (state.style.display == "")
							{
								state.style.display = "none";
							}
							else
							{
								var el = document.images[img];
								var height;

								if (document.all) height = document.body.clientHeight;
								else height = eval(window.innerHeight);

								var x = y = 0;
								do
								{
									x += el.offsetLeft;
									y += el.offsetTop;
								}
								while ((el = el.offsetParent));

								if (height - y - 21 &gt; 161)
								{
									<!-- display the calendar below the image -->
									state.style.left = x + 1 + 34;
									state.style.top = y;
								}
								else
								{
									<!-- display the calendar above the image -->
									state.style.left = x + 1 + 34;
									state.style.top = y - 162 + 22;
								}
								state.style.display = "";
								state.focus();
							}
						}
					</xsl:if>
					<!-- Comment 10: END-->
					<!-- Comment 11: -->
					function incTableCount()
					{
						numOfTables = numOfTables + 1;
					}
					<!-- Comment 11: END-->
					<!-- Comment 12: -->
					var g_bFirstItemAdded = false;
					var g_sCurrentJumpDataSelection = "";
					var g_cellNumber = 0;

					function addJumpDataItem (sName, sDisplay)
					{
						var oJumpDataRow = document.getElementById ("oJumpDataRow");

						if (oJumpDataRow == null) return;

						if (g_bFirstItemAdded == true)
						{
							/* Add a spacer cell */
							var cell = oJumpDataRow.insertCell (g_cellNumber++);
							var sImage = '/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/cbullet.gif';

							cell.innerHTML = '&lt;a class="data-area-jump-bar">&lt;img style="height: 10px;width: 20px" src="' + sImage + '">&lt;/a>';
							cell.className = "data-area-jump-bar";
						}

						g_bFirstItemAdded = true;
						var cell = oJumpDataRow.insertCell (g_cellNumber++);

						/* Add an anchor element in the following format: <A href="#Hardware">Ware duro</A> */
						/* MM : Begin - D040 - Fix for id issue -- add 'name' attribute because SilkTest doesnt use 'id' for HREFs */
						cell.innerHTML = '&lt;a id="a_' + sName + '" name="a_' + sName + '" class="data-area-jump-bar" href="#' + sName + '" onclick="javascript:selectJumpDataItem (\'' + sName + '\')">' + sDisplay + '&lt;/a>';
						/* MM : End - D040 - Fix for id issue -- add 'name' attribute because SilkTest doesnt use 'id' for HREFs */
						cell.className = "data-area-jump-bar";
					}

					function selectJumpDataItem (sName)
					{
						if (g_sCurrentJumpDataSelection != "") {
							var oSelectedAnchor = document.getElementById ("a_" + g_sCurrentJumpDataSelection);
							oSelectedAnchor.className = "data-area-jump-bar";
						}
						g_sCurrentJumpDataSelection = sName;
						var oSelectedAnchor = document.getElementById ("a_" + sName);
						oSelectedAnchor.className = "data-area-jump-bar data-area-jump-bar-selection";
					}

					<!-- Start of  email script -->
					function sendEmail(expandFlag)
					{
						document.getElementById("dataarea").encoding="application/x-www-form-urlencoded";
						document.getElementById("dataarea").enctype= "application/x-www-form-urlencoded";
						<!--  clears cache content and loads the page -->
						<xsl:choose>
							<xsl:when test="@callerReplace = 'true'">
								var locRef = document.location.href;
								locRef = locRef.replace('<xsl:value-of select="@paramReplaced"/>', '<xsl:value-of select="@paramReplacing"/>');
								locRef = top.gnv.appendVID(locRef);
								document.getElementById("caller").value = locRef;
							</xsl:when>
							<xsl:otherwise>document.getElementById("caller").value=document.location.href;</xsl:otherwise>
						</xsl:choose>
						document.getElementById("dataarea").action = top.gnv.appendVID("/servlet/DataArea?plugin=com.dell.oma.webplugins.ShowSendEmailWebPlugin");
						document.getElementById("pageCode").value = "";

						<!--  dynamically load the content of the page with all the divs opened  -->
						if (expandFlag == true){
							alterImage("plus" , "minus");
							expandDiv(document.getElementsByTagName("HTML")[0]);
						}
						
						document.getElementById("pageCode").value = document.getElementsByTagName("HTML")[0].innerHTML;
						document.getElementById("pageName").value = document.getElementById("pagetitle").innerHTML;

						<!-- collapse all the divs -->
						if (expandFlag == true){
							alterImage("minus" , "plus");
							collapseDiv(document.getElementsByTagName("HTML")[0]);
						}

						document.getElementById("dataarea").submit();
					}
					<!-- End of email script -->
					
					<!-- 
					      C81980
					      This function allows the user to refresh their current view based on
					      changes in the component tree representation in the server.  It is
					      invoked by the init function when updates are available.
					-->
					function component_update ()
					{
						if (confirm (<xsl:value-of select="$strComponentUpdate" />)) {
							parent.ct.location.href=top.gnv.appendVID('/servlet/ComponentTree?refresh=true');
						}
					}

					function alterImage(orgImg , altImg){
						temp = new Array();
						<xsl:for-each select="CustomTable/CustomRow">
							var val = "<xsl:value-of select="@name"/>";
							temp = temp.concat(val);
						</xsl:for-each>
						var changeImgTo;
						if (altImg == "plus"){
							changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of 	select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif";
						}
						else if (altImg == "minus"){
							changeImgTo = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of 	select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctminus.gif";
						}

						var obj = document.images;
						for(i = 0 ; i &lt; obj.length ; i++)
						{
							if(obj[i].src.indexOf("ct" + orgImg + ".gif") != -1)
							{
								obj[i].src = changeImgTo;
							}
						}

					}

					function expandDiv(doc){
						var aDivs;
						aDivs = doc.getElementsByTagName("DIV");
						for(var j = 0 ; j  &lt; aDivs.length ; j++){
							if (aDivs[j].id !="tableBar")
								aDivs[j].style.display="block";
						}
					}

					function collapseDiv(doc){
						var aDivs;
						aDivs = doc.getElementsByTagName("DIV");
						for(var j = 1 ; j  &lt; aDivs.length ; j++){
								aDivs[j].style.display="none";
						}
					}
					<!-- This script is enabled only when requested -->
					<xsl:if test="@stringValidation = 'true'">

					</xsl:if>
					<!-- This script is only for data elements of IP address type -->
					<xsl:if test="@ipbox='true'">
						var mj = false;

						function rchar(name, a, b)
						{
							var x = document.getElementById(name + a);
							var y = document.getElementById(name + b);

							var i = eval(x).value.indexOf(".");
							if (i &gt;= 0)
							{
								eval(x).value = eval(x).value.substring(0,i);
								eval(y).focus();
								eval(y).select();
							}
							else if (eval(x).value.length == 3 &amp;&amp; mj)
							{
								eval(y).focus();
								eval(y).select();
							}
						}
					</xsl:if>

					</xsl:otherwise>
				</xsl:choose>
					<!-- Comment 12: END-->
					<!-- This script is required for guage template. -->
						<xsl:if test="Guage">
							var value	= '<xsl:value-of select="Guage/Reading"/>';
							var cmax	= '<xsl:value-of select="Guage/MXFThresh"/>';
							var cmin	   	= '<xsl:value-of select="Guage/MFThresh"/>';
							var ncmax	= '<xsl:value-of select="Guage/MXWThresh"/>';
							var ncmin	= '<xsl:value-of select="Guage/MWThresh"/>';
							var units		= '<xsl:value-of select="Guage/@units"/>';
							var numdec	= '<xsl:value-of select="Guage/@digits"/>';
              var hideminthresh	= '<xsl:value-of select="Guage/@hideminthresh"/>';
              
              var showcmax = cmax;
              var showcmin = cmin;

              value					= parseFloat(value);
              cmax					= parseFloat(cmax);
              cmin					= parseFloat(cmin);
              var total				= parseFloat((cmax - cmin) * (1.25));
              var max				= parseFloat(cmax + parseFloat(total / 10));
              var min				= parseFloat(cmin - parseFloat(total / 10));
              var tempncmax	= parseFloat(ncmax);
              var tempncmin		= parseFloat(ncmin);
              var five_percent	= parseFloat(total / 20);
              var a 					= parseFloat(cmax - ncmax);
              var b					= parseFloat(ncmax - ncmin);
              var c					= parseFloat(ncmin - cmin);

              var autoAdjust		= 0;

              <!-- This code is to snap the reading pointer to either the center of max or the center of min -->
								tempvalue = value;

								if( (tempvalue &gt; max) || ( tempvalue &gt; cmax))
								{
									value = parseFloat(max - five_percent);
								}
								else if( (tempvalue &lt; min) || (tempvalue &lt; cmin) )
								{
									value = parseFloat(parseFloat(min) + five_percent);
								}

							<!-- End here.  -->

							if( (a &lt; five_percent)  &amp;&amp; (b &gt;= five_percent) &amp;&amp; (c &lt; five_percent) )
							{
								autoAdjust = 1;
								tempncmax = parseFloat(parseFloat(cmax) - five_percent);
								tempncmin = parseFloat(parseFloat(cmin) + five_percent);
							}
							else if( (a &gt;= five_percent)  &amp;&amp; (b &lt; five_percent) &amp;&amp; (c &gt;= five_percent) )
							{
								autoAdjust = 2;
								if( a &lt; c)
								{
									tempncmin = parseFloat(parseFloat(ncmax) - five_percent);
								}
								else if( a &gt; c)
								{
									tempncmax = parseFloat(parseFloat(ncmin) + five_percent);
								}
								else if( a == c)
								{
									tempncmax = parseFloat(parseFloat(ncmin) + five_percent);
								}
							}
							else if( (a &lt; five_percent)  &amp;&amp; (b &lt; five_percent) &amp;&amp; (c &gt;= five_percent) )
							{
								autoAdjust = 3;
								tempncmax = parseFloat(parseFloat(cmax) - five_percent);
								tempncmin = parseFloat( tempncmax - five_percent );
							}
							else if( (a &gt;= five_percent)  &amp;&amp; (b &lt; five_percent) &amp;&amp; (c &lt; five_percent) )
							{
								autoAdjust = 4;
								tempncmin = parseFloat( parseFloat(cmin) + five_percent );
								tempncmax = parseFloat( tempncmin + five_percent );
							}
							else if( (a &lt; five_percent)  &amp;&amp; (b &gt;= five_percent) &amp;&amp; (c &gt;= five_percent) )
							{
								autoAdjust = 5;
								tempncmax = parseFloat(parseFloat(cmax) - five_percent);
							}
							else if( (a &gt;= five_percent)  &amp;&amp; (b &gt;= five_percent) &amp;&amp; (c &lt; five_percent) )
							{
								autoAdjust = 6;
								tempncmin = parseFloat( parseFloat(cmin) + five_percent );
							}
							
							<!-- 104463 - If the warn thresh and Fail thresh are same, Gauge still shows them at different points
								  Hence, checking to see if they are same. -->
							if (cmin == ncmin)
								{
									tempncmin = parseFloat(cmin);
								}
								if (cmax == ncmax)
								{
									tempncmax = parseFloat(cmax);
								}

							// Auto adjustment of reading pointer.
							if(autoAdjust == 1)
							{
								// Reading may be pointing between (cmax-ncmax) and (ncmin-cmin)
								if((value &lt;= cmax) &amp;&amp; (value &gt;= ncmax))
								{
									value = parseFloat(parseFloat(cmax) - parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmax) &amp;&amp; (value &gt;= tempncmax))
								{
									value = parseFloat(tempncmax - parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmin) &amp;&amp; (value &gt;= cmin))
								{
									value = parseFloat(parseFloat(cmin) + parseFloat(five_percent/2));
								}
								else if((value &lt;= tempncmin) &amp;&amp; (value &gt;= ncmin))
								{
									value = parseFloat( tempncmin + parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 2)
							{
								// Reading may be pointing between (ncmax-ncmin)

								if( a &lt; c)
								{
									if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
									{
										value = parseFloat(parseFloat(tempncmin) + parseFloat(five_percent/2));
									}
									else if((value &lt; ncmin) &amp;&amp; (value &gt;= tempncmin))
									{
										value = parseFloat(parseFloat(tempncmin) - parseFloat(five_percent/2));
									}
								}
								else if( a &gt; c)
								{
									if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
									{
										value = parseFloat(parseFloat(ncmin) + parseFloat(five_percent/2));
									}
									else if((value &lt;= tempncmax) &amp;&amp; (value &gt; ncmax))
									{
										value = parseFloat(tempncmax + parseFloat(five_percent/2));
									}
								}
								else if( a == c)
								{
									if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
									{
										value = parseFloat(parseFloat(ncmin) + parseFloat(five_percent/2));
									}
									else if((value &lt;= tempncmax) &amp;&amp; (value &gt; ncmax))
									{
										value = parseFloat(tempncmax + parseFloat(five_percent/2));
									}
								}
							}
							else if(autoAdjust == 3)
							{
								// Reading may be pointing between (cmax-ncmax) and (ncmax-ncmin)
								if((value &lt; ncmin) &amp;&amp; (value &gt;= tempncmin))
								{
									value = parseFloat(parseFloat(tempncmin) - parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
								{
									value = parseFloat(parseFloat(tempncmin) + parseFloat(five_percent/2));
								}
								else if((value &lt;= cmax) &amp;&amp; (value &gt;ncmax))
								{
									value = parseFloat(parseFloat(cmax) - parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 4)
							{
								// Reading may be pointing between (ncmax-ncmin) and (ncmin-cmin)

								if((value &gt; ncmax) &amp;&amp; (value &lt;= tempncmax))
								{
									value = parseFloat(tempncmax + parseFloat(five_percent/2));
								}
								else if((value &lt;= ncmax) &amp;&amp; (value &gt;= ncmin))
								{
									value = parseFloat(parseFloat(tempncmax) - parseFloat(five_percent/2));
								}
								else if((value &gt;= cmin) &amp;&amp; (value &lt; ncmin))
								{
									value = parseFloat(parseFloat(cmin) + parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 5)
							{
								// Reading may be pointing between (cmax-ncmax)
								if((value &lt;= cmax) &amp;&amp; (value &gt;= ncmax))
								{
									value = parseFloat(parseFloat(cmax) - parseFloat(five_percent/2));
								}
								else if((value &lt; ncmax) &amp;&amp; (value &gt;= tempncmax))
								{
									value = parseFloat(tempncmax - parseFloat(five_percent/2));
								}
							}
							else if(autoAdjust == 6)
							{
								// Reading may be pointing between (ncmin-cmin)
								if((value &gt;= cmin) &amp;&amp; (value &lt;= ncmin))
								{
									value = parseFloat(parseFloat(cmin) + parseFloat(five_percent/2));
								}
								else if((value &gt; ncmin) &amp;&amp; (value &lt;= tempncmin))
              {
              value = parseFloat(tempncmin + parseFloat(five_percent/2));
              }
              }

              var pointer 			= Math.round(parseFloat(((value - min) / (max - min)) * 250));
              var cmaxmark 		= Math.round(parseFloat(((cmax - min) / (max - min)) * 250));
              var ncmaxmark 	= Math.round(parseFloat(((tempncmax - min) / (max - min)) * 250));
              var cminmark 		= Math.round(parseFloat(((cmin - min) / (max - min)) * 250));
              var ncminmark 	= Math.round(parseFloat(((tempncmin - min) / (max - min)) * 250));
              var minmark			= 0;
              var counter 		= 1;

              <!-- If we do not want to display the minimum threshold values, set the ncminmark (non-critical minimum)
                   and cminmark (critical minimum) to zero. This is to bring down the ncminmark to the end of guage -->
              if("true" == hideminthresh)
              {
                ncminmark = 0;
                cminmark = 0;
                <!-- If the non-critical maximum itself is zero, then set ncmaxmark to zero so that this will be the end of guage -->
                if(0 == ncmax)
                {
                  ncmaxmark = 0;
                }
              }

              function numberFormat(number, places)
              {
              <xsl:choose>
									<xsl:when test="Guage/@showdecsep !='.'">
										var temp = new String(number);
										var index = temp.indexOf(".");
										if(index &gt;= 0)
										{
											temp = temp.replace(".", '<xsl:value-of select="Guage/@showdecsep"/>');
										}
									</xsl:when>
									<xsl:otherwise>
										var temp = new String(number);
										var index = temp.indexOf(".");
									</xsl:otherwise>
								</xsl:choose>

								if (index &lt; 0)
								{
									temp += ".";
									for (var i = 0; i &lt; places; i++) temp += "0";
									return temp;
								}
								else if ((temp.length - index - 1) &lt; places)
								{
									for (var i = 0; i &lt; places - (temp.length - index - 1); i++) temp += "0";
									return temp;
								}
								else if ((temp.length - index - 1) == places)
								{
									return temp;
								}
								else
								{
									var str = "";
									for (var i = 0; i &lt;= (index + places); i++) str += temp.charAt(i);
									return str;
								}
							}
						</xsl:if>
					<!-- End of Guage template script -->
					<!-- Start Performance script -->
						<xsl:if test="PerformanceData/@type='uidata'">
							function reDrawGraphs(name, percent, ptime, utime, pvtime, interrupts)
							{
								var temp = percent;
								percent = Math.ceil(percent/2);
								percent = Math.round(50 - percent);

								for(var y=1; y&lt;51; y++)
								{
									if(y &lt;= percent)
									{
										document.getElementById(name + y + "_1").style.backgroundColor = "#004000";
										document.getElementById(name + y + "_2").style.backgroundColor = "#004000";
									}
									else
									{
										document.getElementById(name + y + "_1").style.backgroundColor = "#00DC00";
										document.getElementById(name + y + "_2").style.backgroundColor = "#00DC00";
									}
								}

								document.getElementById(name + "_text").innerHTML = temp + "%";
								document.getElementById(name + "_ptime").innerHTML = ptime + "%";
								document.getElementById(name + "_utime").innerHTML = utime + "%";
								document.getElementById(name + "_pvtime").innerHTML = pvtime + "%";
								document.getElementById(name + "_intrpts").innerHTML = interrupts;
							}

							function reDrawDisk(name, wrs, bwps, rps, brps)
							{
								document.getElementById(name + "_wrs").innerHTML = wrs;
								document.getElementById(name + "_bwps").innerHTML = bwps;
								document.getElementById(name + "_rps").innerHTML = rps;
								document.getElementById(name + "_brps").innerHTML = brps;
							}

							function reDrawMem(name, pfps, pps, ab, cb, cl)
							{
								document.getElementById(name + "_pfps").innerHTML = pfps;
								document.getElementById(name + "_pps").innerHTML = pps;
								document.getElementById(name + "_ab").innerHTML = ab;
								document.getElementById(name + "_cb").innerHTML = cb;
								document.getElementById(name + "_cl").innerHTML = cl;
							}

							function reDrawVirMem(name, pu, pup)
							{
								document.getElementById(name + "_pu").innerHTML = pu;
								document.getElementById(name + "_pup").innerHTML = pup;
							}

							function reDrawNtw(name, btps, pps, prps, psps, cb, brps, bsps)
							{
								document.getElementById(name + "_btps").innerHTML = btps;
								document.getElementById(name + "_pps").innerHTML = pps;
								document.getElementById(name + "_prps").innerHTML = prps;
								document.getElementById(name + "_psps").innerHTML = psps;
								document.getElementById(name + "_cb").innerHTML = cb;
								document.getElementById(name + "_brps").innerHTML = brps;
								document.getElementById(name + "_bsps").innerHTML = bsps;
							}

						</xsl:if>
					<!-- End Performance script-->
					<!-- Start SelectionData script-->
						function selectionData(name)
						{
							var selectedRow = document.getElementById(name);
							var selectedRowImage = document.getElementById( "img_" + name );

							if (selectedRow.style.display == "")
							{
								selectedRowImage.src = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif" ;

								selectedRow.style.display = "none";
							}
							else
							{
								selectedRowImage.src = "/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctminus.gif";

								selectedRow.style.display = "";
							}
						}

						function expandSelectionData()
						{
							<xsl:if test="SelectionData">
								<xsl:for-each select="SelectionData/SelectionTable/Row">
									<xsl:call-template name="SelectionDataRowExpandFunction">
										<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
									</xsl:call-template>
								</xsl:for-each>
							</xsl:if>
						}

					<!-- End SelectionData script-->
					<!-- SelectionDataUI script -->
					<!-- C97788 - need to set default iframe height to 66% for screen resolution less than 800x600 -->
						function SetDefaultFrameHeight(iframe)
						{
							var x = screen.width;
							var defaultheight;
							var iframeobj = document.getElementById(iframe);
							
							if (x &lt; 640)	{
								iframeobj.height="66%";
							}
						}
					<!-- End SelectionDataUI script -->
					
					<xsl:if test="(/OMA/@userrights = '7' or /OMA/@userrights = '3')">
					<!-- Export Data script Start: Export button is not available to users group.-->
						var originalFormAction;
						var count = 0;
						var storedHref = new String(document.location.href);
						storedHref = top.gnv.appendVID(storedHref);
                                                var bEnableExportSpecialHandling = false;

						function saveExportDataSP(delimiteddata) {
                                                  bEnableExportSpecialHandling = true;
                                                  saveExportData(delimiteddata);
                                                }

						function saveExportData( delimiteddata )
						{
							document.getElementById("exportdatacontent").value = delimiteddata;
							originalFormAction = top.gnv.appendVID(document.dataarea.action);
                                                        if (bEnableExportSpecialHandling) {
							  document.dataarea.action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.oma.webplugins.ExportDataWebPlugin&amp;exportsp=true');
                                                        }
                                                        else {
                                                          document.dataarea.action=top.gnv.appendVID('/servlet/SubmitForm?plugin=com.dell.oma.webplugins.ExportDataWebPlugin');
                                                        }
							document.dataarea.submit();
							document.dataarea.action = originalFormAction;
						}
					
						function exportCustomDelimitedData()
						{
							storedHref = top.gnv.appendVID(storedHref);
							if( count == 0 )
							{
								if( storedHref.indexOf("#") != -1 )
								{
									if( (storedHref.length - 1) == (storedHref.indexOf("#")))
									{
	 	 								storedHref = storedHref.substring(0, (storedHref.length) - 1);
									}
								}
								
								count++;
								var pageHref = storedHref;
								storedHref = pageHref + "&amp;fmt=cdsv";
								document.getElementById( "exportdataiframe" ).src = storedHref;
								
							}
							else
							{
								var exportFrameID = 0;
								for(var frameIndex = 0; frameIndex &lt; window.frames.length; frameIndex++)
								{
									if(window.frames[frameIndex].name == "exportdataiframe")
									{
										exportFrameID = frameIndex;
										break;
									}
								}
								window.frames[exportFrameID].location.href = storedHref;
							}
						}
					 <!--Export Data script End-->
					</xsl:if>				</script>
				<!-- Comment 13: -->
				<script language="javascript">
					function formSubmit()
					{
						document.dataarea.action = top.gnv.appendVID(document.dataarea.action);
						<xsl:choose>
						<xsl:when test="@validate='true'">
								if(validate())
									document.dataarea.submit();
							</xsl:when>
						<xsl:otherwise>
								document.dataarea.submit();
							</xsl:otherwise>
					</xsl:choose>
					}
				</script>
				<!-- Comment 13: END-->
				<xsl:apply-templates select="script"/>
			</head>
			<!-- Have different bodies for Progressbar progress data and everything else -->
			<xsl:choose>
				<xsl:when test="ProgressBar/@progressdata='true'">
					<!-- Progress data does not need any html data to render the page.
						   It just needs few javascript functions for the iframe to update the progress bar.
						   Inserting unnecessary html data causes significant delay between consecutive
						   requests to the server. This delay in turn effects the performance of
						   progress bar.
					 -->
					<body onload="javascript:init();"></body>
				</xsl:when>
				<xsl:otherwise>
<!-- Begin Html body -->
			<body class="data-area" onload="javascript:init();">
				<xsl:choose>
					<xsl:when test="SelectionData/@scrollablecontent= 'true'"></xsl:when>
					<xsl:otherwise>
						<a name="top" id="top"></a>
						<table border="0" cellpadding="0" cellspacing="0">
							<tr style="height: 20px">
								<td><img src='/oma/images/blank.gif'/></td>
							</tr>
						</table>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Comment 14: -->
				<xsl:if test="@date='true'">
					<!--102436 - Localization of calendar -->
					<iframe id='calendar' marginheight='0' marginwidth='0' frameborder='0' style='display: none; position: absolute; width: 157px; height: 161px; z-index: 100' scrolling='no'>
						<xsl:variable name="lang"><xsl:value-of select="/OMA/@language"/></xsl:variable>
						<xsl:variable name="country"><xsl:value-of select="/OMA/@country"/></xsl:variable>
						<xsl:attribute name="src">
							<xsl:choose>
	                            <xsl:when test="$lang='en'">/oma/calendar.html</xsl:when>
								<xsl:when test="$country='tw'">/oma/calendar.html</xsl:when>
								<xsl:otherwise>/oma/<xsl:value-of select="$lang"/>/calendar.html</xsl:otherwise>
	                        </xsl:choose>
						</xsl:attribute>
					</iframe>
					<xsl:element name="input">
						<xsl:attribute name="type">hidden</xsl:attribute>
						<xsl:attribute name="name">currentDateObj</xsl:attribute>
						<xsl:attribute name="id">currentDateObj</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<!-- Comment 14: END-->
				<!-- Comment 15: -->
				<xsl:if test="ProgressBar/@uidata='true'">
					<iframe id='progressbar' marginheight='0' marginwidth='0' frameborder='0' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;' scrolling='no'>
						<xsl:attribute name="src"><xsl:value-of select="ProgressBar/UIData/Update/@href"/></xsl:attribute>
					</iframe>
				</xsl:if>
				<!-- Comment 15: END-->
				<xsl:choose>
					<xsl:when test="SelectionData/@scrollablecontent= 'true'"></xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="PageTitle"/>
						<br/>
						<!-- Comment 16: Custom Buttons start with a default print button on the top right hand corner  (unless otherwise printable is set to false)-->

						<!--C88778 Added Custom buttons on left of frame-->
						<td valign="top">
						<table cellpadding="0" cellspacing="0" width="100%">
  							<tbody>
							<tr>
							<td style="width: 15px" />
							<td valign="top" align="left">
							<table border="0" cellpadding="0" cellspacing="0">
								<tr>
									<xsl:apply-templates select="CustomButton[@align='left']"/>
								</tr>
							</table>
							</td>
							<td valign="top" align="right">
							<table border="0" cellpadding="0" cellspacing="0">
								<tr>
									<xsl:choose>
										<xsl:when test="@printable">
											<xsl:if test="@printable != 'false'">
												<xsl:choose>
													<xsl:when test="@expand">
														<xsl:call-template name="button_details">
															<xsl:with-param name="href">#</xsl:with-param>
															<xsl:with-param name="onclick">javascript:DataAreaPrint(<xsl:value-of select="@expand"/>);</xsl:with-param>
															<xsl:with-param name="display"><xsl:value-of select="$strPrint"/></xsl:with-param>
															<!-- MM : Begin - D0191  - Fix for id issue -->
															<xsl:with-param name="id">printbutton</xsl:with-param>
															<!-- MM : End - D0191 - Fix for id issue -->
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="button_details">
															<xsl:with-param name="href">#</xsl:with-param>
															<xsl:with-param name="onclick">javascript:DataAreaPrint(false);</xsl:with-param>
															<xsl:with-param name="display"><xsl:value-of select="$strPrint1"/></xsl:with-param>
															<!-- MM : Begin - D0191 - Fix for id issue -->
															<xsl:with-param name="id">printbutton</xsl:with-param>
															<!-- MM : End - D0191 - Fix for id issue -->
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:choose>
												<xsl:when test="@expand">
													<xsl:call-template name="button_details">
														<xsl:with-param name="href">#</xsl:with-param>
														<xsl:with-param name="onclick">javascript:DataAreaPrint(<xsl:value-of select="@expand"/>);</xsl:with-param>
														<xsl:with-param name="display"><xsl:value-of select="$strPrint2"/></xsl:with-param>
															<!-- MM : Begin - D0191 - Fix for id issue -->
															<xsl:with-param name="id">printbutton</xsl:with-param>
															<!-- MM : End - D0191 - Fix for id issue -->
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:call-template name="button_details">
														<xsl:with-param name="href">#</xsl:with-param>
														<xsl:with-param name="onclick">javascript:DataAreaPrint(false);</xsl:with-param>
														<xsl:with-param name="display"><xsl:value-of select="$strPrint3"/></xsl:with-param>
															<!-- MM : Begin - D0191 - Fix for id issue -->
															<xsl:with-param name="id">printbutton</xsl:with-param>
															<!-- MM : End - D0191 - Fix for id issue -->
													</xsl:call-template>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:if test="(/OMA/@userrights = '7' or /OMA/@userrights = '3')">
										<xsl:choose>
											<xsl:when test="@exportdata">
												<xsl:if test="@exportdata != 'false'">
													<xsl:call-template name="button_details">
														<xsl:with-param name="href">javascript:exportCustomDelimitedData();</xsl:with-param>
														<xsl:with-param name="display"><xsl:value-of select="$strExport"/></xsl:with-param>
														<xsl:with-param name="formSubmit">true</xsl:with-param>
															<!-- MM : Begin - D0192 - Fix for id issue -->
															<xsl:with-param name="id">exportbutton</xsl:with-param>
															<!-- MM : End - D0192 - Fix for id issue -->
													</xsl:call-template>
												</xsl:if>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="button_details">
													<xsl:with-param name="href">javascript:exportCustomDelimitedData();</xsl:with-param>
													<xsl:with-param name="display"><xsl:value-of select="$strExport"/></xsl:with-param>
													<xsl:with-param name="formSubmit">true</xsl:with-param>
													<!-- MM : Begin - D0192 - Fix for id issue -->
													<xsl:with-param name="id">exportbutton</xsl:with-param>
													<!-- MM : End - D0192 - Fix for id issue -->
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="@email">
											<xsl:if test="(@email != 'false') and (/OMA/@userrights = '7' or /OMA/@userrights = '3')">
												<xsl:choose>
													<xsl:when test="@expand">
														<xsl:call-template name="button_details">
															<xsl:with-param name="href">javascript:sendEmail(<xsl:value-of select="@expand"/>);</xsl:with-param>
															<xsl:with-param name="display"><xsl:value-of select="$strEmail"/></xsl:with-param>
															<xsl:with-param name="formSubmit">true</xsl:with-param>
															<!-- MM : Begin - D0193 - Fix for id issue -->
															<xsl:with-param name="id">emailbutton</xsl:with-param>
															<!-- MM : End - D0193 - Fix for id issue -->
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="button_details">
															<xsl:with-param name="href">javascript:sendEmail(false);</xsl:with-param>
															<xsl:with-param name="display"><xsl:value-of select="$strEmail1"/></xsl:with-param>
															<xsl:with-param name="formSubmit">true</xsl:with-param>
															<!-- MM : Begin - D0193 - Fix for id issue -->
															<xsl:with-param name="id">emailbutton</xsl:with-param>
															<!-- MM : End - D0193 - Fix for id issue -->
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:if>
										</xsl:when>
										<xsl:otherwise>
											<xsl:if test="/OMA/@userrights = '7' or /OMA/@userrights = '3'">
												<xsl:choose>
													<xsl:when test="@expand">
														<xsl:call-template name="button_details">
															<xsl:with-param name="href">javascript:sendEmail(<xsl:value-of select="@expand"/>);</xsl:with-param>
															<xsl:with-param name="display"><xsl:value-of select="$strEmail2"/></xsl:with-param>
															<xsl:with-param name="formSubmit">true</xsl:with-param>
															<!-- MM : Begin - D0193 - Fix for id issue -->
															<xsl:with-param name="id">emailbutton</xsl:with-param>
															<!-- MM : End - D0193 - Fix for id issue -->
														</xsl:call-template>
													</xsl:when>
													<xsl:otherwise>
														<xsl:call-template name="button_details">
															<xsl:with-param name="href">javascript:sendEmail(false);</xsl:with-param>
															<xsl:with-param name="display"><xsl:value-of select="$strEmail3"/></xsl:with-param>
															<xsl:with-param name="formSubmit">true</xsl:with-param>
															<!-- MM : Begin - D0193  - Fix for id issue -->
															<xsl:with-param name="id">emailbutton</xsl:with-param>
															<!-- MM : End - D0193 - Fix for id issue -->
														</xsl:call-template>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:if>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:apply-templates select="CustomButton[  not ( @align ) or ( @align and not (@align = 'left' ))]"/>
									<td style="width: 15px"/>
									<!--/div-->
								</tr>
							</table>
							</td>
							</tr>
							 </tbody>
						</table>
						<br/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
				<!-- Comment 16: END-->
				<xsl:if test="PromptText">
					<xsl:apply-templates select="PromptText"/>
				</xsl:if>
				<xsl:apply-templates select="SubHeader"/>
				<!-- Comment 17: -->
				<form>
					<xsl:if test="@enctype = 'true'">
						<xsl:attribute name="ENCTYPE">multipart/form-data</xsl:attribute>
					</xsl:if>
					<xsl:if test="@validate='true'">
						<xsl:attribute name="onsubmit">return(validate());</xsl:attribute>
					</xsl:if>
					<xsl:attribute name="action"><xsl:choose><xsl:when test="contains(@submit, 'javascript') = false"><xsl:value-of select="@submit"/><xsl:choose><xsl:when test="contains(@submit, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@submit"/></xsl:otherwise></xsl:choose></xsl:attribute>
					<xsl:attribute name="name">dataarea</xsl:attribute>
					<xsl:attribute name="id">dataarea</xsl:attribute>
					<xsl:attribute name="method">post</xsl:attribute>
					<input type="hidden" name="caller" id="caller" value=""/>
					<input type="hidden" name="pageCode" id="pageCode" value=""/>
					<input type="hidden" name="pageName" id="pageName" value=""/>
					<xsl:apply-templates select="CustomMessage"/>
					<xsl:apply-templates select="ProgressBar"/>
					<xsl:choose>
						<xsl:when test="(@ignoreJumpBar) or (SelectionData/@scrollablecontent ='true')"></xsl:when>
						<xsl:otherwise>
							<div id="tableBar" style="DISPLAY: none">
								<table width="100%" cellpadding="0" cellspacing="0" border="0">
									<tr>
										<td style="width: 15px" />
										<td align="right" style="width: 11px">
											<img style="width: 11px; height: 20px">
												<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/dajblc.gif</xsl:attribute>
											</img>
										</td>
										<td class="data-area-jump-bar">
											<table height="20" cellpadding="0" cellspacing="0" border="0">
												<tr valign="middle" id="oJumpDataRow"/>
											</table>
										</td>
										<td style="width: 11px">
											<img style="width: 11px; height: 20px">
												<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/dajbrc.gif</xsl:attribute>
											</img>
										</td>
										<td style="width: 15px" />
									</tr>
								</table>
								<br/>
							</div>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:apply-templates select="TextArea"/>
					<xsl:apply-templates select="ListData"/>
					<xsl:apply-templates select="ComboData"/>
					<xsl:apply-templates select="TableData"/>
					<xsl:apply-templates select="SummaryData"/>
					<xsl:apply-templates select="HealthData"/>
					<xsl:apply-templates select="CustomTable"/>
					<xsl:apply-templates select="HTMLData"/>
					<xsl:apply-templates select="Guage"/>
					<xsl:apply-templates select="PerformanceData"/>
					<xsl:apply-templates select="SelectionData"/>
					<xsl:apply-templates select="SelectionDataUI"/>
				<!-- Comment 17: END-->
				<xsl:choose>
					<xsl:when test="(SelectionData/@scrollablecontent = 'true')"></xsl:when>
					<xsl:otherwise>
						<!-- Comment 18: -->
						<center>
							<table border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td style="height: 30px" />
								</tr>
								<tr>
									<xsl:if test="@backpagedisplay">
										<td align="left" valign="middle"  id="backbutton">
											<xsl:call-template name="button">
												<xsl:with-param name="href">
<xsl:choose><xsl:when test="contains(@backpagetarget, 'javascript') = false"><xsl:value-of select="@backpagetarget"/><xsl:choose><xsl:when test="contains(@backpagetarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@backpagetarget"/></xsl:otherwise></xsl:choose></xsl:with-param>
												<xsl:with-param name="display"><xsl:value-of select="$strGoBackToPage_part1"/><xsl:value-of select="@backpagedisplay"/> <xsl:value-of select="$strGoBackToPage_part3"/></xsl:with-param>
												<!-- MM : Begin - D0194 - Fix for id issue -->
												<xsl:with-param name="id">backbutton</xsl:with-param>
												<!-- MM : End - D0194- Fix for id issue -->
											</xsl:call-template>
										</td>
									</xsl:if>
									<!--Addding new attribute to display the whole string incase plugins (i.e OMSS)need to display the whole string -->
									<xsl:if test="@backpagedisplayfull">
										<td align="left" valign="middle" id="backbutton">
											<xsl:call-template name="button">
													<xsl:with-param name="href">
<xsl:choose><xsl:when test="contains(@backpagetarget, 'javascript') = false"><xsl:value-of select="@backpagetarget"/><xsl:choose><xsl:when test="contains(@backpagetarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@backpagetarget"/></xsl:otherwise></xsl:choose></xsl:with-param>

													<xsl:with-param name="display"><xsl:value-of select="@backpagedisplayfull"/></xsl:with-param>
												<xsl:with-param name="formSubmit">true</xsl:with-param>
											</xsl:call-template>
										</td>
									</xsl:if>						
									<!--End of backpagedisplayfull-->									
									<xsl:if test="@submit">
										<td align="left" valign="middle" id="submitbuttoncontent">
											<xsl:call-template name="button">
												<xsl:with-param name="href">javascript:formSubmit ()</xsl:with-param>
												<xsl:with-param name="formSubmit">true</xsl:with-param>
												<xsl:with-param name="display">
													<xsl:choose>
														<xsl:when test="@submitdisplay != ''"><xsl:value-of select="@submitdisplay"/></xsl:when>
														<xsl:otherwise><xsl:value-of select="$strApplyChanges"/></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<!-- MM : Begin - D0196 - Fix for id issue -->
												<xsl:with-param name="id">submitbuttoncontent</xsl:with-param>
												<!-- MM : End - D0196- Fix for id issue -->
											</xsl:call-template>
										</td>
									</xsl:if>
									<xsl:if test="@cancel = 'true'">
                                                    <td align="left" valign="middle" id="cancelbutton">
											<xsl:call-template name="button">
												<xsl:with-param name="href">
													<xsl:choose>
														<xsl:when test="@canceltarget != ''"><xsl:choose><xsl:when test="contains(@canceltarget, 'javascript') = false"><xsl:value-of select="@canceltarget"/><xsl:choose><xsl:when test="contains(@canceltarget, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@canceltarget"/></xsl:otherwise></xsl:choose></xsl:when>
														<xsl:otherwise>javascript:history.back ()</xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="formSubmit">true</xsl:with-param>
												<!-- MM : Begin - D0195 - Fix for id issue -->
												<xsl:with-param name="id">cancelbutton</xsl:with-param>
												<!-- MM : End - D0195 - Fix for id issue -->
												<xsl:with-param name="display">
													<xsl:choose>
													<xsl:when test="@canceldisplay!= ''"><xsl:value-of select="@canceldisplay"/></xsl:when>
                                                                    <xsl:otherwise><xsl:value-of select="$strCancel"/></xsl:otherwise>
     	                                                           </xsl:choose>
          	                                                  </xsl:with-param>
											</xsl:call-template>
										</td>
									</xsl:if>
									<xsl:if test="BottomCustomButton">
										<xsl:for-each select="BottomCustomButton/Data">
											<!-- MM :Begin - D014 - fix for id issue -->
											<xsl:variable name="guid"><xsl:number count="node()" level="single"/></xsl:variable>
											<!-- MM :End - D014 - fix for id issue -->
											<xsl:call-template name="button_details">
												<xsl:with-param name="href">
													<xsl:choose>
														<xsl:when test="@name='Refresh'">
															<xsl:choose>
																<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
																<xsl:when test="@href"><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:when>
																<xsl:otherwise>#</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="onclick">
													<xsl:choose>
														<xsl:when test="@onclick"><xsl:value-of select="@onclick"/></xsl:when>
														<xsl:when test="@name='Refresh'">
															<xsl:choose>
																<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
																<xsl:when test="@href"></xsl:when>
																<xsl:otherwise>javascript:location.reload ()</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<xsl:with-param name="formSubmit"><xsl:value-of select="@formSubmit"/></xsl:with-param>
												<xsl:with-param name="display"><xsl:value-of select="@display"/></xsl:with-param>
												<!-- MM : Begin - D014 - Fix for id issue -->
												<xsl:with-param name="id">
													<xsl:choose>
														<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
														<xsl:otherwise>bottomcustombutton_<xsl:value-of select="$guid"/></xsl:otherwise>
													</xsl:choose>
												</xsl:with-param>
												<!-- MM : End - D014 - Fix for id issue -->
											</xsl:call-template>
										</xsl:for-each>
									</xsl:if>
								</tr>
							</table>
						</center>
						<!-- Comment 18: END-->
					</xsl:otherwise>
				</xsl:choose>
				<!--  Start Performance Iframe -->
				<xsl:if test="PerformanceData/@type='uidata'">
					<iframe id='perfmgnt' marginheight='0' marginwidth='0' frameborder='0' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;' scrolling='no'>
						<xsl:attribute name="src"><xsl:value-of select="PerformanceData/UIData/Update/@href"/></xsl:attribute>
					</iframe>
				</xsl:if>
				<xsl:if test="(/OMA/@userrights = '7' or /OMA/@userrights = '3')">
					<xsl:choose>
						<xsl:when test="@exportdata">
							<xsl:if test="@exportdata != 'false'">
								<iframe id='exportdataiframe' name="exportdataiframe" marginheight='0' marginwidth='0' frameborder='0' scrolling='no' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;'>
									<xsl:attribute name="src">javascript:top.gnv.appendVID('/servlet/DataArea?plugin=com.dell.oma.webplugins.EmptyDataWebPlugin')</xsl:attribute>
								</iframe>
								<input type="hidden" name="exportdatacontent" id="exportdatacontent" value=""/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<iframe id='exportdataiframe' name="exportdataiframe" marginheight='0' marginwidth='0' frameborder='0' scrolling='no' style='visibility: hidden; position: absolute;  width: 0px; height: 0px; z-index: -1;'>
								<xsl:attribute name="src">javascript:top.gnv.appendVID('/servlet/DataArea?plugin=com.dell.oma.webplugins.EmptyDataWebPlugin')</xsl:attribute>
							</iframe>
							<input type="hidden" name="exportdatacontent" id="exportdatacontent" value=""/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if> 
				<!--  End Performance Iframe -->
					<xsl:apply-templates select="HiddenTable"/>
				</form>
			</body>
<!-- End of Html Body -->
				</xsl:otherwise>
			</xsl:choose>
		</html>
	</xsl:template>
	<xsl:template name="SelectionDataRowExpandFunction">
		<xsl:param name="childrows"/>
		<xsl:if test=" $childrows &gt; 0 ">
			document.getElementById( '<xsl:value-of select="@name"/>' ).style.display = "";
		</xsl:if>

		<xsl:for-each select="ChildrenRows/Row">
			<xsl:call-template name="SelectionDataRowExpandFunction">
				<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="HiddenTable">
		<xsl:for-each select="Data">
			<xsl:call-template name="datatype">
				<xsl:with-param name="type">hidden</xsl:with-param>
				<xsl:with-param name="name"><xsl:value-of select="@name"/></xsl:with-param>
				<xsl:with-param name="returnvalue"><xsl:value-of select="@returnvalue"/></xsl:with-param>
				<!-- MM :Begin - D015 - fix for id issue -->
				<xsl:with-param name="id"><xsl:value-of select="@id"/></xsl:with-param>
				<!-- MM :End - D015 - fix for id issue -->
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="HealthData">
		<!-- MM :Begin - D016 - fix for id issue -->
		<xsl:variable name="row_id"><xsl:number count="node()" level="single"/></xsl:variable>
		<!-- MM :End - D016 - fix for id issue -->		
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<th style="width: 15px" />
				<th align="left" class="data-area-header">
					<!-- MM : Begin - D016 - fix for id issue -->
					<xsl:attribute name="id">hdr_severity_<xsl:value-of select="$row_id"/></xsl:attribute>
					<!-- MM : End - D016 - fix for id issue -->
					<xsl:value-of select="$strSeverity"/>
				</th>
				<th style="width: 5px"/>
				<th align="left" class="data-area-header">
					<!-- MM : Begin - D016 - fix for id issue -->
					<xsl:attribute name="id">hdr_component_<xsl:value-of select="$row_id"/></xsl:attribute>
					<!-- MM : End - D016 - fix for id issue -->				
					<xsl:value-of select="$strComponent"/>
				</th>
				<th style="width: 15px" class="data-area-header"/>
			</tr>
			<xsl:for-each select="Data">
				<!-- MM :Begin - D017 - fix for id issue -->
				<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
				<xsl:variable name="guid"><xsl:value-of select="$row_id"/>_<xsl:value-of select="$col_id"/></xsl:variable>
				<xsl:variable name="uid">
					<xsl:choose>
						<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
						<xsl:when test="@name != ''">link_<xsl:value-of select="@name"/></xsl:when>
						<xsl:otherwise>link_<xsl:value-of select="$guid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="img_uid">
					<xsl:choose>
						<xsl:when test="@id != ''">img_<xsl:value-of select="@id"/></xsl:when>
						<xsl:otherwise>img_<xsl:value-of select="$guid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>				
				<!-- MM :End - D017 - fix for id issue -->
				<tr>
					<xsl:choose>
						<xsl:when test="(position() mod 2)=1">
							<td style="width: 15px" />
							<td class="data-area-canvas-odd" align="center">
								<xsl:call-template name="display-status">
									<xsl:with-param name="name" select="@name" />
									<xsl:with-param name="status" select="@status" />
									<!-- MM :Begin - D017 - fix for id issue -->
									<xsl:with-param name="id"><xsl:value-of select="$img_uid"/></xsl:with-param>
									<!-- MM :End - D017 - fix for id issue -->
								</xsl:call-template>
							</td>
							<td style="width: 5px" />
							<td class="data-area-canvas-odd">
								<xsl:element name="a">
									<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
									<xsl:if test="@onclick">
										<xsl:attribute name="onclick"><xsl:value-of select="@onclick"/></xsl:attribute>
									</xsl:if>
									<!-- MM : Begin - D017 - fix for id issue -->
									<xsl:attribute name="id"><xsl:value-of select="$uid"/></xsl:attribute>
									<!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
									<xsl:attribute name="name"><xsl:value-of select="$uid"/></xsl:attribute>
									<!-- MM : End - D017 - fix for id issue -->
									<xsl:value-of select="@display"/>
								</xsl:element>
							</td>
							<td style="width: 15px" class="data-area-canvas-odd"/>
						</xsl:when>
						<xsl:otherwise>
							<td style="width: 15px" />
							<td align="center">
								<xsl:call-template name="display-status">
									<xsl:with-param name="name" select="@name" />
									<xsl:with-param name="status" select="@status" />
									<!-- MM :Begin - D017 - fix for id issue -->
									<xsl:with-param name="id"><xsl:value-of select="$img_uid"/></xsl:with-param>
									<!-- MM :End - D017 - fix for id issue -->
								</xsl:call-template>
							</td>
							<td style="width: 5px" />
							<td>
								<xsl:element name="a">
									<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
									<xsl:if test="@onclick">
										<xsl:attribute name="onclick"><xsl:value-of select="@onclick"/></xsl:attribute>
									</xsl:if>
									<!-- MM : Begin - D017 - fix for id issue -->
									<xsl:attribute name="id"><xsl:value-of select="$uid"/></xsl:attribute>
									<!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
									<xsl:attribute name="name"><xsl:value-of select="$uid"/></xsl:attribute>
									<!-- MM : End - D017 - fix for id issue -->
									<xsl:value-of select="@display"/>
								</xsl:element>
							</td>
							<td style="width: 15px" />
						</xsl:otherwise>
					</xsl:choose>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	<xsl:template match="ListData">
	  <!--C106630 Allow script inside ListData-->
		<xsl:apply-templates select="script"/>
		<!-- MM :Begin - D033 - fix for id issue -->
		<xsl:variable name="guid">
			<xsl:choose>
				<!-- @name is required if more than one ListData is there and position() is required if more than one ListData has the same name. -->
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/><xsl:value-of select="position()"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM :End - D033 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@type='custom'">
				<xsl:apply-templates select="SubHeader">
					<xsl:with-param name="puid" select="$guid"/>
				</xsl:apply-templates>
				<table width="100%" cellpadding="0" cellspacing="0" border="0">
					<tr>
						<td style="width: 15px" />
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
							</img>
						</td>
						<td style="height: 10px" class="data-area-canvas">
							<img   style="width: 1px; height: 1px"/>
						</td>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
							</img>
						</td>
						<td style="width: 15px" />
					</tr>
					<tr>
						<td style="width: 15px" />
						<td style="height: 10px" class="data-area-canvas">
							<img   style="width: 1px; height: 1px"/>
						</td>
						<td class="data-area-canvas">
							<table width="100%" cellpadding="0" cellspacing="0" border="0">
								<tr>
									<!-- MM : Begin - D034 - fix for id issue -->
									<th class="data-area-header" valign="middle" align="left"><xsl:attribute name="id"><xsl:value-of select="$guid"/>_attribute</xsl:attribute>	<xsl:value-of select="$strAttribute"/></th>
									<th class="data-area-header" valign="middle" align="left"><xsl:attribute name="id"><xsl:value-of select="$guid"/>_value</xsl:attribute><xsl:value-of select="$strValue"/></th>
									<!-- MM : End - D034 - fix for id issue -->
								</tr>
								<tr>
									<td class="data-area-separator" style="height: 1px">
										<img   style="width: 1px; height: 1px"/>
									</td>
									<td class="data-area-separator" style="height: 1px">
										<img   style="width: 1px; height: 1px"/>
									</td>
								</tr>
								<xsl:call-template name="ListDataEntries">
									<xsl:with-param name="caller">custom</xsl:with-param>
									<!-- MM : Begin - D033 - fix -->
									<xsl:with-param name="puid" select="$guid"></xsl:with-param>
									<!-- MM : End - D033 - fix -->
								</xsl:call-template>
							</table>
						</td>
						<td style="height: 10px" class="data-area-canvas">
							<img   style="width: 1px; height: 1px"/>
						</td>
						<td style="width: 15px" />
					</tr>
					<tr>
						<td style="width: 15px" />
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
							</img>
						</td>
						<td style="height: 10px" class="data-area-canvas">
							<img   style="width: 1px; height: 1px"/>
						</td>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
							</img>
						</td>
						<td style="width: 15px" />
					</tr>
				</table>
				<br/>
			</xsl:when>
			<xsl:otherwise>
				<table border="0" cellpadding="1" cellspacing="1">
					<!--
						When the parent node is a Section element, use 100% as the width of the table to provide
						proper alignment of  the columns of the summary report.
					-->
					<xsl:if test="name(..) = 'Section'">
						<xsl:attribute name="width">100%</xsl:attribute>
					</xsl:if>
					<xsl:if test="@jumpbar!='true'">
						<script language="javascript">
							addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>'
            , "<xsl:value-of select='@display'/>");
						</script>
						<br/>
						<a>
							<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
						</a>
					</xsl:if>
					<tr>
						<th style="width: 15px" />
						<th align="left" class="data-area-header">
							<!-- MM : Begin - D033 - fix -->
							<xsl:attribute name="id">header_<xsl:value-of select="$guid"/></xsl:attribute>
							<!-- MM : End - D033 - fix -->
							<xsl:choose>
								<xsl:when test="@display!=''">
									<xsl:value-of select="@display"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</th>
						<th style="width: 5px" />
					</tr>
					<xsl:call-template name="ListDataEntries">
						<xsl:with-param name="caller">plain</xsl:with-param>
						<!-- MM : Begin - D033 - fix -->
						<xsl:with-param name="puid" select="$guid"></xsl:with-param>
						<!-- MM : End - D033 - fix -->
					</xsl:call-template>
				</table>
				<br/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="ListDataEntries">
		<xsl:param name="caller"/>
		<!-- MM : Begin - D035 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:variable name="table_id"><xsl:value-of select="$puid"/></xsl:variable>
		<!-- MM : End - D035 - fix for id issue -->
		<xsl:for-each select="Data">
			<!-- MM : Begin - D035 - fix for id issue -->
			<xsl:variable name="nameAttr" select="@name"/>
			<xsl:variable name="num">
				<xsl:choose>
					<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//ListData/Data[@name=$nameAttr])"/></xsl:when>
					<xsl:otherwise>0</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
			<xsl:variable name="luid">
				<xsl:choose>
					<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
					<xsl:when test="$num = '0'">
						<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$col_id"/>
					</xsl:when>
					<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
					<xsl:when test="$num != '1'">
						<xsl:choose>
						<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
							<xsl:when test="$nameAttr=preceding::Data[ancestor::ListData]/@name">
								<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$col_id"/>
							</xsl:when>
							<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id-->
							<xsl:otherwise>
								<xsl:value-of select="@name"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
					<xsl:when test="$num = '1'">
						<xsl:value-of select="@name"/>								
					</xsl:when>
				</xsl:choose>
			</xsl:variable>
			<!-- MM : End - D035 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@ignoreonweb='true'"></xsl:when>
			<xsl:otherwise>
				<tr>
					<xsl:if test="$caller = 'plain'">
						<td style="width: 15px" />
					</xsl:if>
					<xsl:choose>
						<xsl:when test="$caller = 'custom'">
							<xsl:choose>
								<xsl:when test="(position() mod 2)=1">
									<td class="data-area-canvas-odd">
										<xsl:if test="@width">
											<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
										</xsl:if>
										<!-- MM : Begin - D035 - fix for id issue -->
										<xsl:choose>
											<xsl:when test="@id != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@id"/></xsl:attribute>
											</xsl:when>
											<!--xsl:when test="@name != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when-->
											<xsl:otherwise>
												<xsl:attribute name="id">name_<xsl:value-of select="$luid"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<!-- MM : End - D035 - fix for id issue -->
										<xsl:value-of select="@display"/>
									</td>
								</xsl:when>
								<xsl:otherwise>
								    <!--C88676 fix smallfont font size -->
									<td class="data-area-canvas">
										<xsl:if test="@width">
											<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
										</xsl:if>
										<!-- MM : Begin - D035 - fix for id issue -->
										<xsl:choose>
											<xsl:when test="@id != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@id"/></xsl:attribute>
											</xsl:when>
											<!--xsl:when test="@name != ''">
												<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when-->
											<xsl:otherwise>
												<xsl:attribute name="id">name_<xsl:value-of select="$luid"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<!-- MM : End - D035 - fix for id issue -->										
										<xsl:value-of select="@display"/>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<td>
								<!--
									When the parent of the parent is a Section element, use 50% as the width of the
									element to align the columns of the summary report.
								-->
								<xsl:if test="name(../..) = 'Section'">
									<xsl:attribute name="style">width: 50%</xsl:attribute>
								</xsl:if>
								<!-- MM : Begin - D035 - fix for id issue -->
								<xsl:choose>
									<xsl:when test="@id != ''">
										<xsl:attribute name="id">name_<xsl:value-of select="@id"/></xsl:attribute>
									</xsl:when>								
									<!--xsl:when test="@name != ''">
										<xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute>
									</xsl:when-->
									<xsl:otherwise>
										<xsl:attribute name="id">name_<xsl:value-of select="$luid"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<!-- MM : End - D035 - fix for id issue -->
								<xsl:value-of select="@display"/>
							</td>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="$caller = 'plain'">
						<td style="width: 5px" />
					</xsl:if>
						<xsl:choose>
							<xsl:when test="@splcase = 'true'">
								<td>
									<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
									<xsl:call-template name="datatype">
										<!-- MM : Begin - D035- fix for id issue -->
										<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
										<xsl:with-param name="ignoreName">true</xsl:with-param>
										<!-- MM : End - D035 - fix for id issue -->
										<xsl:with-param name="display">
											<xsl:value-of select="@display"/>
										</xsl:with-param>
										<xsl:with-param name="type">
											<xsl:value-of select="@type"/>
										</xsl:with-param>
										<xsl:with-param name="name">
											<xsl:value-of select="@name"/>
										</xsl:with-param>
										<xsl:with-param name="id">
										<!-- MM : Begin - D035 - fix for id issue -->
											<xsl:value-of select="@id"/>
											<!-- xsl:value-of select="@name"/ -->
										<!-- MM : End - D035 - fix for id issue -->
										</xsl:with-param>
										<xsl:with-param name="value">
											<xsl:value-of select="@value"/>
										</xsl:with-param>
										<xsl:with-param name="returnvalue">
											<xsl:value-of select="@returnvalue"/>
										</xsl:with-param>
										<xsl:with-param name="state">
											<xsl:value-of select="@state"/>
										</xsl:with-param>
										<xsl:with-param name="size">
											<xsl:value-of select="@size"/>
										</xsl:with-param>
										<xsl:with-param name="uparrscript">
											<xsl:value-of select="@uparrscript"/>
										</xsl:with-param>
										<xsl:with-param name="downarrscript">
											<xsl:value-of select="@downarrscript"/>
										</xsl:with-param>
										<xsl:with-param name="sep">
											<xsl:value-of select="@sep"/>
										</xsl:with-param>
										<xsl:with-param name="value1">
											<xsl:value-of select="@value1"/>
										</xsl:with-param>
										<xsl:with-param name="value2">
											<xsl:value-of select="@value2"/>
										</xsl:with-param>
										<xsl:with-param name="value3">
											<xsl:value-of select="@value3"/>
										</xsl:with-param>
										<xsl:with-param name="value4">
											<xsl:value-of select="@value4"/>
										</xsl:with-param>
										<xsl:with-param name="event">
											<xsl:value-of select="@event"/>
										</xsl:with-param>
										<xsl:with-param name="handler">
											<xsl:value-of select="@handler"/>
										</xsl:with-param>
										<!--C91707 Ability to set selection box width-->
										<xsl:with-param name="width">
											<xsl:value-of select="@boxwidth"/>
										</xsl:with-param>
									</xsl:call-template>
								</td>
								<!-- This is a special case, right now used for probe object settings only -->
								<xsl:for-each select="ExtraItem">
									<xsl:choose>
										<xsl:when test="@link='true'">
											<td>
										          <!--MOH-->
												<xsl:if test="$caller = 'custom'">
													<xsl:choose>
														<xsl:when test="(position() mod 2)=1">
															<xsl:attribute name="class">data-area-canvas-odd</xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="class">data-area-canvas</xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:if>
    												<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
												<xsl:element name="a">
													<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
													<xsl:call-template name="datatype">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
														<xsl:with-param name="ignoreName">true</xsl:with-param>
														<!-- MM : End - D035 - fix for id issue -->
														<xsl:with-param name="display">
															<xsl:value-of select="@display"/>
														</xsl:with-param>
														<xsl:with-param name="type">
															<xsl:value-of select="@type"/>
														</xsl:with-param>
														<xsl:with-param name="name">
															<xsl:value-of select="@name"/>
														</xsl:with-param>
														<xsl:with-param name="id">
															<!-- MM : Begin - D035 - fix for id issue -->
															<xsl:value-of select="@id"/>
															<!-- xsl:value-of select="@name"/ -->
															<!-- MM : End - D035 - fix for id issue -->
														</xsl:with-param>
														<xsl:with-param name="value">
															<xsl:value-of select="@value"/>
														</xsl:with-param>
														<xsl:with-param name="returnvalue">
															<xsl:value-of select="@returnvalue"/>
														</xsl:with-param>
														<xsl:with-param name="state">
															<xsl:value-of select="@state"/>
														</xsl:with-param>
													</xsl:call-template>
												</xsl:element>
											</td>
										</xsl:when>
										<xsl:otherwise>
										    <!-- 87536 prevent word wrap of label ("No" radio button in asset pages) -->
											<td nowrap="nowrap">
											<!--87536 end -->
											<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D035 - fix for id issue -->
													<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D035 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D035 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D035 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="size">
														<xsl:value-of select="@size"/>
													</xsl:with-param>
													<xsl:with-param name="uparrscript">
														<xsl:value-of select="@uparrscript"/>
													</xsl:with-param>
													<xsl:with-param name="downarrscript">
														<xsl:value-of select="@downarrscript"/>
													</xsl:with-param>
													<xsl:with-param name="sep">
														<xsl:value-of select="@sep"/>
													</xsl:with-param>
													<xsl:with-param name="value1">
														<xsl:value-of select="@value1"/>
													</xsl:with-param>
													<xsl:with-param name="value2">
														<xsl:value-of select="@value2"/>
													</xsl:with-param>
													<xsl:with-param name="value3">
														<xsl:value-of select="@value3"/>
													</xsl:with-param>
													<xsl:with-param name="value4">
														<xsl:value-of select="@value4"/>
													</xsl:with-param>
													<xsl:with-param name="event">
														<xsl:value-of select="@event"/>
													</xsl:with-param>
													<xsl:with-param name="handler">
														<xsl:value-of select="@handler"/>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
												</xsl:call-template>
												<xsl:value-of select="@unit"/>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
							</xsl:when>
							<xsl:when test="@link='true'">
								<td>
									<xsl:if test="$caller = 'custom'">
										<xsl:choose><!--C88676 fix smallfont font size -->
											<xsl:when test="(position() mod 2)=1">
												<xsl:attribute name="class">data-area-canvas-odd</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">data-area-canvas</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:if>
									<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
									<xsl:element name="a">
										<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
										<xsl:call-template name="datatype">
											<!-- MM : Begin - D035 - fix for id issue -->
											<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
											<xsl:with-param name="ignoreName">true</xsl:with-param>
											<!-- MM : End - D035 - fix for id issue -->
											<xsl:with-param name="display">
												<xsl:value-of select="@display"/>
											</xsl:with-param>
											<xsl:with-param name="type">
												<xsl:value-of select="@type"/>
											</xsl:with-param>
											<xsl:with-param name="name">
												<xsl:value-of select="@name"/>
											</xsl:with-param>
											<xsl:with-param name="id">
												<!-- MM : Begin - D035 - fix for id issue -->
												<xsl:value-of select="@id"/>
												<!-- xsl:value-of select="@name"/ -->
												<!-- MM : End - D035 - fix for id issue -->
											</xsl:with-param>
											<xsl:with-param name="value">
												<xsl:value-of select="@value"/>
											</xsl:with-param>
											<xsl:with-param name="returnvalue">
												<xsl:value-of select="@returnvalue"/>
											</xsl:with-param>
											<xsl:with-param name="state">
												<xsl:value-of select="@state"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:element>
								</td>
							</xsl:when>
							<xsl:otherwise>
								<td>
									<xsl:if test="$caller = 'custom'">
										<xsl:choose><!--C88676 fix smallfont font size -->
											<xsl:when test="(position() mod 2)=1">
												<xsl:attribute name="class">data-area-canvas-odd</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">data-area-canvas</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:if>
									<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
									<xsl:call-template name="datatype">
										<!-- MM : Begin - D035 - fix for id issue -->
										<xsl:with-param name="uid"><xsl:value-of select="$luid"/></xsl:with-param>
										<xsl:with-param name="ignoreName">true</xsl:with-param>
										<!-- MM : End - D035 - fix for id issue -->
										<xsl:with-param name="display">
											<xsl:value-of select="@display"/>
										</xsl:with-param>
										<xsl:with-param name="type">
											<xsl:value-of select="@type"/>
										</xsl:with-param>
										<xsl:with-param name="name">
											<xsl:value-of select="@name"/>
										</xsl:with-param>
										<xsl:with-param name="id">
											<!-- MM : Begin - D035 - fix for id issue -->
											<xsl:value-of select="@id"/>
											<!-- xsl:value-of select="@name"/ -->
											<!-- MM : End - D035 - fix for id issue -->
										</xsl:with-param>
										<xsl:with-param name="value">
											<xsl:value-of select="@value"/>
										</xsl:with-param>
										<xsl:with-param name="returnvalue">
											<xsl:value-of select="@returnvalue"/>
										</xsl:with-param>
										<xsl:with-param name="state">
											<xsl:value-of select="@state"/>
										</xsl:with-param>
										<xsl:with-param name="size">
											<xsl:value-of select="@size"/>
										</xsl:with-param>
										<xsl:with-param name="uparrscript">
											<xsl:value-of select="@uparrscript"/>
										</xsl:with-param>
										<xsl:with-param name="downarrscript">
											<xsl:value-of select="@downarrscript"/>
										</xsl:with-param>
										<xsl:with-param name="sep">
											<xsl:value-of select="@sep"/>
										</xsl:with-param>
										<xsl:with-param name="value1">
											<xsl:value-of select="@value1"/>
										</xsl:with-param>
										<xsl:with-param name="value2">
											<xsl:value-of select="@value2"/>
										</xsl:with-param>
										<xsl:with-param name="value3">
											<xsl:value-of select="@value3"/>
										</xsl:with-param>
										<xsl:with-param name="value4">
											<xsl:value-of select="@value4"/>
										</xsl:with-param>
										<xsl:with-param name="event">
											<xsl:value-of select="@event"/>
										</xsl:with-param>
										<xsl:with-param name="handler">
											<xsl:value-of select="@handler"/>
										</xsl:with-param>
										<!--C91707 Ability to set selection box width-->
										<xsl:with-param name="width">
											<xsl:value-of select="@boxwidth"/>
										</xsl:with-param>
									</xsl:call-template>
									<xsl:if test="ValueList">
										<xsl:for-each select="ValueList/value">
											<xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if>
										</xsl:for-each>
									</xsl:if>
									<xsl:value-of select="@unit"/>
								</td>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="$caller = 'plain'">
							<td style="width: 15px" />
						</xsl:if>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="TableData">
		<!-- MM :Begin - D030- fix for id issue -->
		<xsl:variable name="guid">
			<xsl:choose>
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : This value will be used to generate id for back to top -->
		<xsl:variable name="backToTopId" select="$guid"/>
		<!-- MM :End - D030 - fix for id issue -->

		<!-- fix for logs taking longer time to display - this is because of xsl functions (count, preceding) used in Row -->
		<!-- template to check for duplicate values, take longer time to complete. -->
		<!-- pass attribute to enable/disable unique ID generation. nouniqueids is an optional attribute. defaults to false -->
		<xsl:variable name="noUniqIDs">
			<xsl:choose>
				<xsl:when test="@nouniqueids ='true' ">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="@ignoreJumpBar"></xsl:when>
			<xsl:otherwise>
				<script language="javascript">
					addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">		\\</xsl:with-param></xsl:call-template>'
            , "<xsl:value-of select='@display'/>");
					incTableCount();
				</script>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="script"/>
		<a>
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:apply-templates select="SubHeader">
				<!-- MM :Begin - D030- fix for id issue -->
				<xsl:with-param name="puid" select="$guid"/>
				<!-- MM :End - D030- fix for id issue -->
			</xsl:apply-templates>
			<xsl:apply-templates select="PromptText">
				<!-- MM :Begin - D030- fix for id issue -->
				<xsl:with-param name="puid" select="$guid"/>
				<!-- MM :End - D030- fix for id issue -->
			</xsl:apply-templates>
			<table width="100%" cellpadding="0" cellspacing="0" border="0">
				<tr>
					<td style="width: 15px" />
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
						</img>
					</td>
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
						</img>
					</td>
					<td style="width: 15px" />
				</tr>
				<tr>
					<td style="width: 15px" />
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td class="data-area-canvas">
						<table width="100%" cellpadding="0" cellspacing="0" border="0">
							<xsl:choose>
								<xsl:when test="@columnspacing='true'">
									<xsl:apply-templates select="Header">
										<xsl:with-param name="columnspacing">true</xsl:with-param>
										<!-- MM : Begin - D030 - fix  for id issue -->
										<xsl:with-param name="puid" select="$guid"></xsl:with-param>
										<!-- MM : End - D030 - fix for id issue -->
									</xsl:apply-templates>
									<xsl:apply-templates select="Row">
										<xsl:with-param name="columnspacing">true</xsl:with-param>
										<!-- MM : Begin - D030 - fix for id issue -->
										<xsl:with-param name="puid" select="$guid"></xsl:with-param>
										<!-- MM : End - D030 - fix  for id issue-->
										<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
									</xsl:apply-templates>
								</xsl:when>
								<xsl:otherwise>
									<xsl:apply-templates select="Header">
										<!-- MM : Begin - D030 - fix for id issue -->
										<xsl:with-param name="puid" select="$guid"></xsl:with-param>
										<!-- MM : End - D030 - fix for id issue -->
									</xsl:apply-templates>
									<xsl:apply-templates select="Row">
										<!-- MM : Begin - D030 - fix for id issue -->
										<xsl:with-param name="puid" select="$guid"></xsl:with-param>
										<!-- MM : End - D030 - fix for id issue -->
										<xsl:with-param name="noUniqIDs" select="$noUniqIDs" ></xsl:with-param>
									</xsl:apply-templates>
								</xsl:otherwise>
							</xsl:choose>
						</table>
					</td>
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td style="width: 15px" />
				</tr>
				<tr>
					<td style="width: 15px" />
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
						</img>
					</td>
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
						</img>
					</td>
					<td style="width: 15px" />
				</tr>
			</table>
			<br/>
		</a>
		<xsl:choose>
			<xsl:when test="/OMA/DataArea/@ignoreJumpBar"></xsl:when>
			<xsl:otherwise>
				<xsl:if test="count( /OMA/DataArea/TableData ) > 1">
					<table width="100%" cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td style="width: 15px" />
							<td>
								<div>
									[<a class="data-area-back-to-top" href="#top">
										<!-- MM :Begin - D041 - fix for id issue -->
										<!-- Add 'id' and 'name' attribute -->
										<xsl:attribute name="id">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
										<xsl:attribute name="name">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
										<!-- MM :End - D041 - fix for id issue -->
										<xsl:value-of select="$strBackToTop"/>
									</a>]
								</div>
							</td>
							<td style="width: 15px" />
						</tr>
					</table>
					<br/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="SummaryData">
		<script language="javascript">
				var tmp_div	= document.getElementById("tableBar");
				tmp_div.style.display = "";
		</script>
		<br/>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="Section">
		<!-- MM : Begin - D024 - fix -->
		<!-- xsl:variable name="guid"><xsl:number count="node()" level="single"/></xsl:variable -->
		<xsl:variable name="guid"><xsl:value-of select="position()"/></xsl:variable>
		<!-- Jump Data Item already has id in the form of id=name, since this will be unique, id will not be required -->
		<!-- MM : This value will be used to generate id for back to top -->
		<xsl:variable name="backToTopId">
			<xsl:choose>
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : End - D024 - fix -->
		<script language="javascript">
			addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>'
, "<xsl:value-of select='@display'/>");
		</script>
		<a>
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
		</a>
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td style="width: 15px" />
				<td class="data-area-separator" style="height: 2px">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td align="right">
					<!-- MM : Begin - D024 - fix -->
					<xsl:attribute name="id">section_header_<xsl:value-of select="$guid"/></xsl:attribute>
					<!-- MM : End - D024 - fix -->
					<span class="data-area-summary-section-header">
						<xsl:value-of select="@display"/>
					</span>
				</td>
				<td style="width: 15px" />
			</tr>
		</table>
		<xsl:apply-templates />
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td style="width: 15px" />
				<td>
					<div>
						[<a class="data-area-back-to-top" href="#top">
							<!-- MM :Begin - D041 - fix for id issue -->
							<!-- Add 'id' and 'name' attribute -->
							<xsl:attribute name="id">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
							<xsl:attribute name="name">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
							<!-- MM :End - D041 - fix for id issue -->
							<xsl:value-of select="$strBackToTop1"/>
						</a>]
					</div>
				</td>
				<td style="width: 15px" />
			</tr>
		</table>
		<br/>
	</xsl:template>
	<xsl:template match="Header">
		<xsl:param name="columnspacing"/>
		<!-- MM : Begin - D031 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:variable name="table_id"><xsl:value-of select="$puid"/></xsl:variable>
		<xsl:variable name="row_id"><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM : End - D031 - fix for id issue -->
		<tr>
			<xsl:for-each select="Data">
				<!-- MM : Begin - D031 - fix for id issue -->						
				<xsl:variable name="nameAttr" select="@name"/>
				<xsl:variable name="num">
					<xsl:choose>
						<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//TableData/Header/Data[@name=$nameAttr])"/></xsl:when>
						<xsl:otherwise>0</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
				<xsl:variable name="luid">
					<xsl:choose>
						<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
						<xsl:when test="$num = '0'">
							<xsl:value-of select="$table_id"/>_hdr<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
						</xsl:when>
						<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
						<xsl:when test="$num != '1'">
							<xsl:choose>
							<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
								<xsl:when test="$nameAttr=preceding::Data[ancestor::TableData]/@name">
									<xsl:value-of select="$table_id"/>_hdr<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
								</xsl:when>
								<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id-->
								<xsl:otherwise>
									<xsl:value-of select="@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
						<xsl:when test="$num = '1'">
							<xsl:value-of select="@name"/>								
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<!-- MM : End - D031 - fix for id issue -->
				<xsl:choose>
					<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
					<xsl:otherwise>
						<th class="data-area-header" valign="middle" align="left">
							<xsl:if test="@width !=''">
								<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
							</xsl:if>
							<xsl:if test="@colspan">
								<xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
							<xsl:choose>
								<xsl:when test="@link='true'">
									<a class="data-area-header">
										<xsl:attribute name="href">javascript:g_appendVid_InvokeAction('<xsl:value-of select="@href"/>')</xsl:attribute>
										<xsl:choose>
											<xsl:when test="@underlined='true'">
												<!-- MM : Begin - D031 - fix for id issue -->
												<xsl:attribute name="id">
													<xsl:choose>
														<!-- when id is given -->
														<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
														<!-- when name is given -->
														<!--xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when -->
														<!-- neither id nor name is given -->
														<xsl:otherwise><xsl:value-of select="$luid"/></xsl:otherwise>
													</xsl:choose>
												</xsl:attribute>
												<!-- We add 'name' attribute here for 2 reasons.  -->
												<!-- 1. SilkTest doesnt identify 'id' or 'name' for <span>, which means we have to provide 'id' attribute for <a> -->
												<!-- 2. SilkTest doesnt identify 'id' attribute for <a> which means we have to provide 'name' attribute for <a> -->
												<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
												<!-- MM : End - D031 - fix for id issue -->
												<span style="text-decoration: underline">
													<xsl:call-template name="datatype">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:with-param name="uid" select="$luid"></xsl:with-param>
  														<xsl:with-param name="ignoreName">true</xsl:with-param>
														<!-- MM : End - D031 - fix for id issue -->
														<xsl:with-param name="display">
															<xsl:value-of select="@display"/>
														</xsl:with-param>
														<xsl:with-param name="type">
															<xsl:value-of select="@type"/>
														</xsl:with-param>
														<xsl:with-param name="name">
															<xsl:value-of select="@name"/>
														</xsl:with-param>
														<xsl:with-param name="id">
															<!-- MM : Begin - D031 - fix for id issue -->
															<xsl:value-of select="@id"/>
															<!-- xsl:value-of select="@name"/ -->
															<!-- MM : End - D031 - fix for id issue -->
														</xsl:with-param>
														<xsl:with-param name="value">
															<xsl:value-of select="@value"/>
														</xsl:with-param>
														<xsl:with-param name="returnvalue">
															<xsl:value-of select="@returnvalue"/>
														</xsl:with-param>
														<xsl:with-param name="state">
															<xsl:value-of select="@state"/>
														</xsl:with-param>
													</xsl:call-template>
												</span>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D031 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D031 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
										<!-- Start CHNG99370 - Visual cue for sort order -->
										<xsl:variable name="lowercase">abcdefghijklmnopqrstuvwxyz</xsl:variable>
										<xsl:variable name="uppercase">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>										
										<xsl:choose>
											<xsl:when test="translate(@srtIdentifier,$lowercase, $uppercase)=translate(@name,$lowercase, $uppercase)">
												<xsl:call-template name="display-sortorder">
													<xsl:with-param name="name" select="@name" />												
													<xsl:with-param name="sortorder" select="@sortorder" />
												</xsl:call-template>
											</xsl:when>
										</xsl:choose>
										<!-- End CHNG99370 - Visual cue for sort order -->
									</a>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="@underlined='true'">
											<!-- MM : Begin - D031 - fix for id issue -->
											<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
											<xsl:attribute name="id">
												<xsl:choose>
													<!-- when id is given -->
													<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
													<!-- when name is given -->
													<!--xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when-->
													<!-- neither id nor name is given -->
													<xsl:otherwise><xsl:value-of select="$luid"/></xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<!-- MM : End - D031 - fix for id issue -->
											<span style="text-decoration: underline">
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D031 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D031 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
												</xsl:call-template>
											</span>
										</xsl:when>
										<!--C72949.  Add italic attribute -->
										<xsl:when test="@italic='true'">
											<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
											<!-- MM : Begin - D031 - fix for id issue -->
											<xsl:attribute name="id">
												<xsl:choose>
													<!-- when id is given -->
													<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
													<!-- when name is given -->
													<!--xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when-->
													<!-- neither id nor name is given -->
													<xsl:otherwise><xsl:value-of select="$luid"/></xsl:otherwise>
												</xsl:choose>
											</xsl:attribute>
											<!-- MM : End - D031 - fix for id issue -->
											<span style="font-style: italic">
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D031 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D031 - fix for id issue -->
														<xsl:value-of select="@id"/>
														<!-- xsl:value-of select="@name"/ -->
														<!-- MM : End - D031 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
												</xsl:call-template>
											</span>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D031 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D031 - fix for id issue -->											
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D031 - fix for id issue -->
													<xsl:value-of select="@id"/>
													<!-- xsl:value-of select="@name"/ -->
													<!-- MM : End - D031 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</th>
					<!-- add empty data items -->
					<xsl:if test="($columnspacing='true') and (position() != last())">
						<td class="data-area-canvas" style="height: 1px"><img src='/oma/images/blank.gif'/></td>
					</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</tr>
		<xsl:if test="position() = last()">
			<tr>
				<xsl:for-each select="Data">
					<xsl:choose>
						<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="@underlined='true'">
									<td class="data-area-canvas" style="height: 1px">
										<img   style="width: 1px; height: 1px"/>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="@display!=''">
										<xsl:call-template name="sep">
											<xsl:with-param name="colspan">
												<xsl:value-of select="@colspan"/>
											</xsl:with-param>
										</xsl:call-template>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
							<!-- add empty data items -->
							<xsl:if test="($columnspacing='true') and (position() != last())">
								<td class="data-area-separator" style="height: 1px"><img   style="width: 1px; height: 1px"/></td>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template match="Row">
		<xsl:param name="columnspacing"/>
		<xsl:param name="noUniqIDs"/>
		<!-- MM : Begin - D032 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:variable name="table_id"><xsl:value-of select="$puid"/></xsl:variable>
		<xsl:variable name="row_id"><xsl:value-of select="position()"/></xsl:variable>		
		<!-- MM : End - D032 - fix for id issue -->
		<tr>
			<xsl:if test="@height">
				<xsl:attribute name="style">height:<xsl:value-of select="@height"/></xsl:attribute>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="(position() mod 2)=1">
					<xsl:for-each select="Data">
						<!-- MM : Begin - D032 - fix for id issue  -->
						<xsl:variable name="nameAttr" select="@name"/>
						<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
						<xsl:variable name="luid">
							<!-- if noUniqIDs is set to true, disable the generation of unique IDs -->
							<xsl:choose>
								<xsl:when test="$noUniqIDs='true'"><xsl:value-of select="@name"/></xsl:when>
								<xsl:otherwise>
									<xsl:variable name="num">
										<xsl:choose>
											<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//TableData/Row/Data[@name=$nameAttr])"/></xsl:when>
											<xsl:otherwise>0</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:choose>
										<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
										<xsl:when test="$num = '0'">
											<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
										</xsl:when>
										<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
										<xsl:when test="$num != '1'">
											<xsl:choose>
											<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
												<xsl:when test="$nameAttr=preceding::Data[ancestor::TableData]/@name">
													<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
												</xsl:when>
												<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id.-->
												<xsl:otherwise>
													<xsl:value-of select="@name"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
										<xsl:when test="$num = '1'">
											<xsl:value-of select="@name"/>
										</xsl:when>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>							
						</xsl:variable>
						<!-- MM : End - D032 - for id issue  -->
						<xsl:choose>
							<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
							<xsl:otherwise>
								<td class="data-area-canvas-odd" valign="middle">
									<xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
									<xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
									<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
									<xsl:if test="@width !=''">
										<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="@link='true'">
											<xsl:element name="a">
												<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D032 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D032 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D032 - fix for id issue -->
														<!-- xsl:value-of select="@name"/ -->
														<xsl:value-of select="@id"/>
														<!-- MM : End - D032 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="preserve_format">
														<xsl:if test="@name = 'Description'">yes</xsl:if>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:element>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D032 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D032 - fix for id issue -->
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D032 - fix for id issue -->
													<!-- xsl:value-of select="@name"/ -->
													<xsl:value-of select="@id"/>
													<!-- MM : End - D032 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
												<xsl:with-param name="size">
													<xsl:value-of select="@size"/>
												</xsl:with-param>
												<xsl:with-param name="uparrscript">
													<xsl:value-of select="@uparrscript"/>
												</xsl:with-param>
												<xsl:with-param name="downarrscript">
													<xsl:value-of select="@downarrscript"/>
												</xsl:with-param>
												<xsl:with-param name="sep">
													<xsl:value-of select="@sep"/>
												</xsl:with-param>
												<xsl:with-param name="value1">
													<xsl:value-of select="@value1"/>
												</xsl:with-param>
												<xsl:with-param name="value2">
													<xsl:value-of select="@value2"/>
												</xsl:with-param>
												<xsl:with-param name="value3">
													<xsl:value-of select="@value3"/>
												</xsl:with-param>
												<xsl:with-param name="value4">
													<xsl:value-of select="@value4"/>
												</xsl:with-param>
												<xsl:with-param name="event">
													<xsl:value-of select="@event"/>
												</xsl:with-param>
												<xsl:with-param name="handler">
													<xsl:value-of select="@handler"/>
												</xsl:with-param>
												<xsl:with-param name="preserve_format">
													<xsl:if test="@name = 'Description'">yes</xsl:if>
												</xsl:with-param>
												<!--C91707 Ability to set selection box width-->
												<xsl:with-param name="width">
													<xsl:value-of select="@boxwidth"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:value-of select="@unit"/>
									<xsl:variable name="novalue"><xsl:choose>
										<xsl:when test="@value">
											<xsl:choose>
												<xsl:when test="@value='' ">true</xsl:when>
												<xsl:otherwise>false</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>true</xsl:otherwise>
									</xsl:choose></xsl:variable>
									<xsl:if test="ValueList">
										<xsl:for-each select="ValueList/value">
											<xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if>
										</xsl:for-each>
									</xsl:if>
								</td>
								<!-- add empty data items -->
								<xsl:if test="($columnspacing='true') and (position() != last())">
									<td class="data-area-canvas-odd" style="height: 1px"><img src='/oma/images/blank.gif'/></td>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="Data">
						<!-- MM : Begin - D032 fix for id issue-->
						<xsl:variable name="nameAttr" select="@name"/>
						<xsl:variable name="col_id"><xsl:number count="node()" level="single"/></xsl:variable>
						<xsl:variable name="luid">
							<!-- if noUniqIDs is set to true, disable the generation of unique IDs -->
							<xsl:choose>
								<xsl:when test="$noUniqIDs='true'"><xsl:value-of select="@name"/></xsl:when>
								<xsl:otherwise>						
									<xsl:variable name="num">
										<xsl:choose>
											<xsl:when test="$nameAttr != ''"><xsl:value-of select="count(//TableData/Row/Data[@name=$nameAttr])"/></xsl:when>
											<xsl:otherwise>0</xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:choose>
										<!-- if num is 0, it means the name attr is not present. In this case, generate the id -->
										<xsl:when test="$num = '0'">
											<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
										</xsl:when>
										<!-- if num is not 1, it means the name attr is repeated (duplicate), In this case, generate the id -->
										<xsl:when test="$num != '1'">
											<xsl:choose>
												<!-- if this returns true, then the attribute value is already present. In this case, generate the id -->
												<xsl:when test="$nameAttr=preceding::Data[ancestor::TableData]/@name">
													<xsl:value-of select="$table_id"/>_row<xsl:value-of select="$row_id"/>.<xsl:value-of select="$col_id"/>
												</xsl:when>
												<!-- if false, then this is the first instance of the attribute value. In this case, use the name as is for id -->
												<xsl:otherwise>
													<xsl:value-of select="@name"/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<!-- if num is 1, it means the name attr is not repeated. In this case, use the name as is for id.-->
										<xsl:when test="$num = '1'">
											<xsl:value-of select="@name"/>
										</xsl:when>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<!-- MM : End - D032 - fix for id issue-->
						<xsl:choose>
							<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
							<xsl:otherwise>
								<td class="data-area-canvas" valign="middle">
									<xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
									<xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
									<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
									<xsl:if test="@width !=''">
										<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
									</xsl:if>
									<xsl:choose>
										<xsl:when test="@link='true'">
											<xsl:element name="a">
												<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
												<xsl:call-template name="datatype">
													<!-- MM : Begin - D032 - fix for id issue -->
													<xsl:with-param name="uid" select="$luid"></xsl:with-param>
													<xsl:with-param name="ignoreName">true</xsl:with-param>
													<!-- MM : End - D032 - fix for id issue -->
													<xsl:with-param name="display">
														<xsl:value-of select="@display"/>
													</xsl:with-param>
													<xsl:with-param name="type">
														<xsl:value-of select="@type"/>
													</xsl:with-param>
													<xsl:with-param name="name">
														<xsl:value-of select="@name"/>
													</xsl:with-param>
													<xsl:with-param name="id">
														<!-- MM : Begin - D032 - fix for id issue -->
														<!-- xsl:value-of select="@name"/ -->
														<xsl:value-of select="@id"/>
														<!-- MM : End - D032 - fix for id issue -->
													</xsl:with-param>
													<xsl:with-param name="value">
														<xsl:value-of select="@value"/>
													</xsl:with-param>
													<xsl:with-param name="returnvalue">
														<xsl:value-of select="@returnvalue"/>
													</xsl:with-param>
													<xsl:with-param name="state">
														<xsl:value-of select="@state"/>
													</xsl:with-param>
													<xsl:with-param name="preserve_format">
														<xsl:if test="@name = 'Description'">yes</xsl:if>
													</xsl:with-param>
													<!--C91707 Ability to set selection box width-->
													<xsl:with-param name="width">
														<xsl:value-of select="@boxwidth"/>
													</xsl:with-param>
												</xsl:call-template>
											</xsl:element>
										</xsl:when>
										<xsl:otherwise>
											<xsl:call-template name="datatype">
												<!-- MM : Begin - D032 - fix for id issue -->
												<xsl:with-param name="uid" select="$luid"></xsl:with-param>
												<xsl:with-param name="ignoreName">true</xsl:with-param>
												<!-- MM : End - D032 - fix for id issue -->
												<xsl:with-param name="display">
													<xsl:value-of select="@display"/>
												</xsl:with-param>
												<xsl:with-param name="type">
													<xsl:value-of select="@type"/>
												</xsl:with-param>
												<xsl:with-param name="name">
													<xsl:value-of select="@name"/>
												</xsl:with-param>
												<xsl:with-param name="id">
													<!-- MM : Begin - D032 - fix for id issue -->
													<!-- xsl:value-of select="@name"/ -->
													<xsl:value-of select="@id"/>
													<!-- MM : End - D032 - fix for id issue -->
												</xsl:with-param>
												<xsl:with-param name="value">
													<xsl:value-of select="@value"/>
												</xsl:with-param>
												<xsl:with-param name="returnvalue">
													<xsl:value-of select="@returnvalue"/>
												</xsl:with-param>
												<xsl:with-param name="state">
													<xsl:value-of select="@state"/>
												</xsl:with-param>
												<xsl:with-param name="size">
													<xsl:value-of select="@size"/>
												</xsl:with-param>
												<xsl:with-param name="uparrscript">
													<xsl:value-of select="@uparrscript"/>
												</xsl:with-param>
												<xsl:with-param name="downarrscript">
													<xsl:value-of select="@downarrscript"/>
												</xsl:with-param>
												<xsl:with-param name="sep">
													<xsl:value-of select="@sep"/>
												</xsl:with-param>
												<xsl:with-param name="value1">
													<xsl:value-of select="@value1"/>
												</xsl:with-param>
												<xsl:with-param name="value2">
													<xsl:value-of select="@value2"/>
												</xsl:with-param>
												<xsl:with-param name="value3">
													<xsl:value-of select="@value3"/>
												</xsl:with-param>
												<xsl:with-param name="value4">
													<xsl:value-of select="@value4"/>
												</xsl:with-param>
												<xsl:with-param name="event">
													<xsl:value-of select="@event"/>
												</xsl:with-param>
												<xsl:with-param name="handler">
													<xsl:value-of select="@handler"/>
												</xsl:with-param>
												<xsl:with-param name="preserve_format">
													<xsl:if test="@name = 'Description'">yes</xsl:if>
												</xsl:with-param>
												<!-- C91707 Ability to set selection box width-->
												<xsl:with-param name="width">
													<xsl:value-of select="@boxwidth"/>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:value-of select="@unit"/>
									<xsl:variable name="novalue"><xsl:choose>
										<xsl:when test="@value">
											<xsl:choose>
												<xsl:when test="@value='' ">true</xsl:when>
												<xsl:otherwise>false</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>true</xsl:otherwise>
									</xsl:choose></xsl:variable>
									<xsl:if test="ValueList">
										<xsl:for-each select="ValueList/value">
											<xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if>
										</xsl:for-each>
									</xsl:if>
								</td>
								<!-- add empty data items -->
								<xsl:if test="($columnspacing='true') and (position() != last())">
									<td class="data-area-canvas" style="height: 1px"><img src='/oma/images/blank.gif'/></td>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</tr>
	</xsl:template>
	
	<xsl:template match="PageTitle">
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td style="width: 15px" />
				<xsl:if test="@status!=''">
					<td align="center" valign="middle">
						<xsl:call-template name="display-status">
							<xsl:with-param name="status" select="@status" />
							<!-- MM : Begin - D020 - fix for id issue -->
							<xsl:with-param name="id">pagetitle_img</xsl:with-param>
							<!-- MM : End - D020 - fix for id issue -->
						</xsl:call-template>
					</td>
					<td style="width: 5px" />
				</xsl:if>
				<!-- MM : Begin - D020 - fix for id issue -->
				<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
				<!--NOTE : The id value for td and span should be different -->
				<td id="pagetitle_text">
				<!-- MM : End - D020 - fix for id issue -->
					<span id="pagetitle">
						<xsl:choose>
							<xsl:when test="@alert='true'">
								<xsl:attribute name="class">data-area-page-title-alert</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="class">data-area-page-title</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:value-of select="@display"/>
					</span>
				</td>
				<td style="width: 15px" />
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template match="PromptText">
		<!-- MM :Begin - D021 - fix for id issue -->
		<xsl:param name="puid" select="1"></xsl:param>
		<!-- puid is used to assign unique id -->
		<xsl:variable name="guid"><xsl:value-of select="$puid"/><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :End - D021 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@ignoreonweb = 'true'"></xsl:when>
			<xsl:otherwise>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 15px" />
						<xsl:if test="@status!=''">
							<td align="left" valign="center">
								<xsl:call-template name="display-status"><xsl:with-param name="status" select="@status" />
									<!-- MM : Begin - D021 - fix for id issue -->
									<xsl:with-param name="id">prompttext_img_<xsl:value-of select="$guid"/></xsl:with-param>
									<!-- MM : End - D021 - fix for id issue -->
								</xsl:call-template>
							</td>
						</xsl:if>
						<td style="width: 5px" />
						<td>
							<!-- MM : Begin - D021 - fix for id issue -->
							<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
							<xsl:attribute name="id">prompttext_<xsl:value-of select="$guid"/></xsl:attribute>
							<!-- MM : End - D021 - fix for id issue -->
							<span id="prompttext">
								<xsl:choose>
									<xsl:when test="@alert='true'">
										<xsl:attribute name="class">data-area-prompt-text-alert</xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="class">data-area-prompt-text</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="."/>								
							</span>
						</td>
						<td style="width: 15px" />
					</tr>
				</table>
				<br/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="SubHeader">
		<!-- MM :Begin - D025 - fix for id issue -->
		<xsl:param name="puid" select="1"></xsl:param>
		<!-- puid is used to assign unique id -->
		<xsl:variable name="guid"><xsl:value-of select="$puid"/><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :End - D025 - fix for id issue -->	
		<xsl:choose>
			<xsl:when test="@ignoreonweb='true'"></xsl:when>
			<xsl:otherwise>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 15px" />
						<td align="left" valign="center">
							<xsl:if test="@status!=''">
								<xsl:call-template name="display-status">
									<xsl:with-param name="status" select="@status" />
									<!-- MM : Begin - D025 - fix for id issue -->
									<xsl:with-param name="id">subheader_img_<xsl:value-of select="$guid"/></xsl:with-param>
									<!-- MM : End - D025 - fix for id issue -->
								</xsl:call-template>
							</xsl:if>
						</td>
						<td style="width: 5px" />
						<td align="left" valign="center">
							<!-- MM : Begin - D025 - fix -->
							<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
							<xsl:choose>
								<xsl:when test="@id != ''">
									<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<!-- position is used to keep the id unique -->
									<xsl:attribute name="id">subheader_<xsl:value-of select="$guid"/></xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<!-- MM : End - D025 - fix -->
							<span class="data-area-sub-header">
								<xsl:value-of select="@display"/>
							</span>
						</td>
						<td style="width: 15px" />
					</tr>
				</table>
				<br/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="CustomButton">
		<!-- MM :Begin - D012 - fix for id issue -->
		<xsl:variable name="uid"><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :Begin - D012 - fix for id issue -->
		<xsl:for-each select="Data">
			<!-- MM :Begin - D012 - fix for id issue -->
			<xsl:variable name="guid"><xsl:value-of select="$uid"/><xsl:value-of select="position()"/></xsl:variable>
			<!-- MM :End - D012 - fix for id issue -->
			<xsl:call-template name="button_details">
				<xsl:with-param name="href">
					<xsl:choose>
						<xsl:when test="@name='Refresh'">
							<xsl:choose>
								<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
								<xsl:when test="@href"><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:when>
								<xsl:otherwise>#</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise><xsl:choose><xsl:when test="contains(@href, 'javascript') = false"><xsl:value-of select="@href"/><xsl:choose><xsl:when test="contains(@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="@href"/></xsl:otherwise></xsl:choose></xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="onclick">
					<xsl:choose>
						<xsl:when test="@onclick"><xsl:value-of select="@onclick"/></xsl:when>
						<xsl:when test="@name='Refresh'">
							<xsl:choose>
								<!-- On a refresh button without href, use the onclick to run the javascript reload. -->
								<xsl:when test="@href"></xsl:when>
								<xsl:otherwise>javascript:location.reload ()</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<xsl:with-param name="formSubmit"><xsl:value-of select="@formSubmit"/></xsl:with-param>
				<xsl:with-param name="display"><xsl:value-of select="@display"/></xsl:with-param>
				<!-- MM : Begin - D012 - Fix for id issue -->
				<xsl:with-param name="id">
					<xsl:choose>
						<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
						<xsl:otherwise>custombutton_<xsl:value-of select="$guid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:with-param>
				<!-- MM : End - D012 - Fix for id issue -->
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="CustomMessage">
		<!-- MM : Begin - D022 - Fix for id issue -->
		<xsl:variable name="guid"><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM : End - D022 - Fix for id issue -->
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
					</img>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td class="data-area-canvas">
					<table width="100%" cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td valign="top" align="center" style="width: 16px" class="data-area-canvas">
								<xsl:call-template name="display-status"><xsl:with-param name="status" select="@status" />
									<!-- MM : Begin - D022 - Fix for id issue -->
									<xsl:with-param name="id">img_<xsl:value-of select="guid"/></xsl:with-param>
									<!-- MM : End - D022 - Fix for id issue -->
								</xsl:call-template>
							</td>
							<td style="height: 10px" class="data-area-canvas">
								<img   style="width: 1px; height: 1px"/>
							</td>
							<!-- MM : Begin - D022 - fix for id issue -->
							<th valign="top" align="left" class="data-area-header">
								<xsl:choose>
									<xsl:when test="@id != ''">
										<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<!-- position is used to keep the id unique -->
										<xsl:attribute name="id">custommessage_<xsl:value-of select="$guid"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:value-of select="."/>
							</th>
							<!-- MM : End - D022 - fix for id issue -->
						</tr>
					</table>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
					</img>

				</td>
				<td style="width: 15px" />
			</tr>
		</table>
		<br/>
	</xsl:template>
	<xsl:template match="CustomTable">
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
					</img>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td class="data-area-canvas">
					<table width="100%" cellpadding="0" cellspacing="1" border="0">
						<xsl:if test="Header">
							<tr>
								<td valign="top" align="center" style="width: 20px" class="data-area-canvas"></td>
								<td valign="top" align="center" style="width: 16px" class="data-area-canvas"></td>
								<xsl:for-each select="Header/Data">
									<th valign="top" align="left" class="data-area-header"><xsl:value-of select="."/></th>
								</xsl:for-each>
							</tr>
							<tr>
								<td style="height: 1px" class="data-area-separator"><img   style="width: 1px; height: 1px"/></td>
								<td style="height: 1px" class="data-area-separator"><img   style="width: 1px; height: 1px"/></td>
								<xsl:for-each select="Header/Data">
									<td style="height: 1px" class="data-area-separator"><img   style="width: 1px; height: 1px"/></td>
								</xsl:for-each>
							</tr>
							<tr>
								<td style="height: 3px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
								<td style="height: 3px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
								<xsl:for-each select="Header/Data">
									<td style="height: 3px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
								</xsl:for-each>
							</tr>
						</xsl:if>
						<xsl:for-each select="CustomRow">
							<xsl:variable name="numofcolitems" select="count(ColumnItem)"/>
							<xsl:variable name="name"><xsl:value-of select="@name"/></xsl:variable>
							<tr>
								<td valign="top" align="left" style="width: 20px" class="data-area-canvas">
									<a>
										<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
										<xsl:attribute name="href">#<xsl:value-of select="@name"/></xsl:attribute>
										<xsl:attribute name="onclick">javascript:changeStateTbl('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">\\</xsl:with-param></xsl:call-template>', '<xsl:value-of select="$numofcolitems"/>')</xsl:attribute>
										<img>
											<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/ctplus.gif</xsl:attribute>
											<xsl:attribute name="id">image_<xsl:value-of select="@name"/></xsl:attribute>
										</img>
									</a>
			    				</td>
								<td valign="top" align="center" style="width: 16px" class="data-area-background">
									<xsl:call-template name="display-status"><xsl:with-param name="status" select="@status" /></xsl:call-template>
								</td>
								<xsl:for-each select="ColumnItem">
									<xsl:variable name="pos"><xsl:value-of select="position()"/></xsl:variable>
									<td valign="top" align="left" class="data-area-background"><xsl:value-of select="@header"/>
										<div style="display:none">
											<xsl:attribute name="id">div<xsl:value-of select="$pos"/><xsl:value-of select="$name"/></xsl:attribute>
											<table width="100%" border="0" cellspacing="1" cellpadding="1">
												<xsl:for-each select="Row">
													<tr>
														<xsl:for-each select="Data">
															<td class="data-area-canvas" valign="top" align="left" style="width: 30%">
																<xsl:choose>
																	<xsl:when test="ValueList">
																		<xsl:for-each select="ValueList/value"><xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if></xsl:for-each>
																	</xsl:when>
																	<xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
																</xsl:choose>
															</td>
														</xsl:for-each>
													</tr>
												</xsl:for-each>
											</table>
										</div>
									</td>
								</xsl:for-each>
							</tr>
						</xsl:for-each>
					</table>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 15px" />
			</tr>
			<tr>
				<td style="width: 15px" />
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
					</img>
				</td>
				<td style="width: 15px" />
			</tr>
		</table>
		<br/>
	</xsl:template>
	<xsl:template match="ProgressBar">
		<xsl:choose>
			<xsl:when test="@uidata='true'">
				<xsl:if test="UIData/Title">
					<table border='0' cellpadding='0' cellspacing='0'>
						<tr>
							<td style='width: 15px'> </td>
							<td class='data-area-title' align='left' valign='middle'><xsl:value-of select="UIData/Title"/></td>
						</tr>
					</table>
					<br/>
				</xsl:if>
							
			<!-- C68431 - Adding support for Multiple Interrupt Actions. -->
				<!--C86792 Change width to 200-->
				<table width="200" border="0" cellpadding="1" cellspacing="1">
					<tr>
						<td style="width: 15px">
							<img alt=""   style="height: 1px; width: 15px"/>
						</td>
						<xsl:for-each select="UIData/InterruptAction">
							<td style="width: 120px" align="left" valign="middle">
								<div>
								<xsl:attribute name="id"><xsl:value-of select="@action"/>button</xsl:attribute>
									<xsl:choose>
										<!-- suspend/resume actions will have hide attrib -->
										<xsl:when test="@hide">
											<xsl:choose>
												<xsl:when test="@hide='true'">
													<xsl:attribute name="style">DISPLAY: none</xsl:attribute>					
												</xsl:when>
												<xsl:when test="@hide='false'">
														<xsl:attribute name="style">DISPLAY: </xsl:attribute>
												</xsl:when>
											</xsl:choose>										
										</xsl:when>
										<!-- abort action will not have hide attrib -->
										<xsl:otherwise> 
											<xsl:choose>
												<xsl:when test="@href != ''">
													<xsl:attribute name="style">DISPLAY: </xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:otherwise>
									</xsl:choose>
									
									<xsl:call-template name="button">
										<xsl:with-param name="href">javascript:buttonCall('<xsl:value-of select="@action"/>','<xsl:value-of select="@href"/>')</xsl:with-param>
										<xsl:with-param name="id">pgbar<xsl:value-of select="@action"/>intaction</xsl:with-param>
										<xsl:with-param name="display"><xsl:value-of select="@display"/></xsl:with-param>
									</xsl:call-template>
								</div>
							</td>
						</xsl:for-each>
					</tr>
				</table>
						
				<!-- Old code to be deleted -->			
				<!--<xsl:if test="UIData/InterruptAction">
					<div  id="abortbutton">
						<xsl:choose>
							<xsl:when test="UIData/InterruptAction/@href != ''">
								<xsl:attribute name="style">DISPLAY: </xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<table width='200' border='0' cellpadding='0' cellspacing='0'>
							<tr>
								<td style='width: 15px'><img alt='' src='' style="height: 1px; width: 15px"/></td>
								<td style='width: 185px' align='left' valign='middle'>
									<xsl:call-template name="button">
										<xsl:with-param name="href">javascript:buttonCall()</xsl:with-param>
										<xsl:with-param name="id">pgbarintaction</xsl:with-param>
										<xsl:with-param name="display"><xsl:value-of select="UIData/InterruptAction/@display"/></xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</div>
					<br/>
				</xsl:if> -->
				
				<xsl:if test="UIData/Result"><xsl:value-of select="ProgressBar/UIData/Result/@href"/>
					<div  id="resultbutton" style="DISPLAY: none">
						<!--C86792 Change width to 200-->
						<table width='200' border='0' cellpadding='0' cellspacing='0'>
							<tr>
								<td style='width: 15px'><img alt='' src='' style="height: 1px; width: 15px"/></td>
								<td style='width: 185px' align='left' valign='middle'>
									<xsl:call-template name="button">
										<xsl:with-param name="href"><xsl:value-of select="UIData/Result/@href"/></xsl:with-param>
										<xsl:with-param name="id">pgbarresult</xsl:with-param>
										<xsl:with-param name="display"><xsl:value-of select="UIData/Result/@display"/></xsl:with-param>
									</xsl:call-template>
								</td>
							</tr>
						</table>
					</div>
					<br/>
				</xsl:if>
				<table summary='' width='555' cellpadding='0' cellspacing='0' border='0'>
					<tr>
						<td style='width: 15px' rowspan='3'><img alt='' src='' style="height: 1px; width: 15px"/></td>
						<td style='width 10px; height: 10px'>
							<img alt='' style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
							</img>
						</td>
						<td style='width: 100%; height: 10px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
						<td style='width 10px; height: 10px'>
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
							</img>
						</td>
					</tr>
					<tr>
						<td class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
							<td class='data-area-canvas' align='left' valign='middle'>
								<table summary='' border='0' cellpadding='0' cellspacing='0'>
									<xsl:apply-templates select="UIData"/>
								</table>
							</td>
						<td class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
					</tr>
					<tr>
						<td style='width: 10px; height: 10px'>
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
							</img>
						</td>
						<td style='width: 40%; height: 10px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
						<td style='width: 10px; height: 10px'>
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
							</img>
						</td>
					</tr>
				</table>
				<br/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="UIData">
		<xsl:apply-templates	/>
	</xsl:template>
	<xsl:template match="ProgressBarList">
		<xsl:apply-templates	/>
	</xsl:template>
	<xsl:template match="UIBar">
		<tr>
		<td class='data-area-canvas' align='left' valign='middle'>
			<table border='0' cellpadding='0' cellspacing='0'>
				<tr>
					<td class='data-area-background' colspan='79' align='left' valign='middle'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
						<div id='titleText'><xsl:value-of select="@display"/></div>
					</td>
					<td class='data-area-background' colspan='2' align='left' valign='middle' width='200px'>
						<!-- MOH change 75429 . Only display pass if number of passes greater than 0 -->
						<div style='font-size: 8pt'>
							<xsl:attribute name="id">statusPass<xsl:value-of select="@name"/></xsl:attribute>
						</div>
					</td>
				</tr>
				<tr>
					<td style='height: 1px' class='data-area-canvas' colspan='81'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
					<td style='width: 40px; height: 23px' class='data-area-background' rowspan='5' align='center' valign='middle'>
						<div style='font-size: 8pt'><xsl:attribute name="id">statusPercentage<xsl:value-of select="@name"/></xsl:attribute>0%</div>
					</td>
					<td style='width: 1px; height: 1px' class='data-area-shadow'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
					</td>
					<td style='width: 350px; height: 1px' class='data-area-shadow' colspan='75'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
					</td>
					<td style='width: 1px; height: 1px' class='data-area-background'>
						<img alt='' src='' style="width: 1px; height: 1px"/>
					</td>
					<td style='width: 30px; height: 23px' class='data-area-canvas' rowspan='5' align='center' valign='middle'>
						<img src='/oma/images/blank.gif'>
							<xsl:attribute name="id">statusImage<xsl:value-of select="@name"/></xsl:attribute>
						</img>
					</td>
					<td style='width: 55px' class='data-area-canvas' rowspan='5' align='center' valign='middle'>
						<div><xsl:attribute name="id">statusText<xsl:value-of select="@name"/></xsl:attribute></div>
					</td>
				</tr>
				<tr>
					<td style='width: 1px; height: 21px' class='data-area-shadow' rowspan='3'><img alt='' src='' style="width: 1px; height: 1px"/></td>
					<td style='width: 350px; height: 1px' class='data-area-canvas' colspan='75'><img alt='' src='' style="width: 1px; height: 1px"/></td>
					<td style='width: 1px; height: 21px' class='data-area-background' rowspan='3'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
					<xsl:call-template name="draw_bars">
						<xsl:with-param name="index" select="1" />
					</xsl:call-template>
				</tr>
				<tr>
					<td style='width: 350px; height: 1px' class='data-area-canvas' colspan='75'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
				    <td style='width: 1px; height: 1px' class='data-area-background'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				    <td style='width: 350x; height: 1px' class='data-area-background' colspan='75'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				    <td style='width: 1px; height: 1px' class='data-area-background'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				</tr>
				<tr>
					<td style='height: 7px' class='data-area-canvas' colspan='81'><img alt='' src='' style="width: 1px; height: 7px"/></td>
				</tr>
				</table>
		</td>
		</tr>
	</xsl:template>
	<xsl:template name="draw_bars">
		<xsl:param name="index" />
			<xsl:if test="$index &lt; 26">
				<td style='width: 1px; height: 19px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				<td style='width: 12px; height: 19px' class='data-area-canvas' align='center' valign='middle'>
					<xsl:attribute name="id">bar<xsl:value-of select="$index" />_<xsl:value-of select="@name"/></xsl:attribute>
					<img alt='' src='/oma/images/blank.gif' style="width: 12px; height: 19px"/>
				</td>
				<td style='width: 1px; height: 19px' class='data-area-canvas'><img alt='' src='' style="width: 1px; height: 1px"/></td>
				<xsl:call-template name="draw_bars">
					<xsl:with-param name="index" select="$index + 1" />
				</xsl:call-template>
			</xsl:if>
	</xsl:template>
	<xsl:template match="TextArea">
		<table>
			<tr>
				<td style="width: 10px" />
				<td>
					<!-- MM : Begin - D027 - fix for id issue -->
					<xsl:attribute name="id">header_<xsl:value-of select="position()"/></xsl:attribute>
					<!-- MM : End - D027 - fix for id issue -->
					<xsl:value-of select="@display"/></td>
			</tr>
		</table>
		<table>
			<tr>
				<td style="width: 10px" />
				<td>
					<textarea>
						<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
						<!-- MM : Begin - D027 - fix for id issue -->
						<!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
						<xsl:choose>
							<xsl:when test="@id != ''">
								<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<!-- position is used to keep the id unique -->
								<xsl:attribute name="id"><xsl:value-of select="@name"/>_<xsl:value-of select="position()"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<!-- MM : End - D027 - fix for id issue -->						
						<xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute>
						<xsl:attribute name="cols"><xsl:value-of select="@cols"/></xsl:attribute>
						<xsl:if test="@state = '2'">
							<xsl:attribute name="disabled"/>
						</xsl:if>
						<xsl:value-of select="@value"/>
					</textarea>
				</td>
			</tr>
		</table>
		<br/>
	</xsl:template>
	<xsl:template match="HTMLData">
		<xsl:apply-templates />
	</xsl:template>
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="Guage">
		<!-- MM :Begin - D026 - fix for id issue -->
		<xsl:variable name="table_id">
			<xsl:choose>
				<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM :End - D026 - fix for id issue -->
		<table border="0" cellspacing="0" cellpadding="0" width="550">
		<tr>
			<td style="width: 15px"><img alt=""   height="1" width="15"/></td>
			<td style="height: 10px; width: 10px">
				<img alt="" height="10" width="10">
					<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
				</img>
			</td>
			<td style="height: 10px" class="data-area-canvas"><img alt="" width="1" height="1"  /></td>
			<td style="height: 10px; width: 10px">
				<img alt="" height="10" width="10">
					<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
				</img>
			</td>
			<td style="width: 15px"><img alt="" src="/oma/images/blank.gif" height="1" width="15"/></td>
		</tr>
		<tr>
			<td style="width: 15px"><img alt="" src="/oma/images/blank.gif" height="1" width="15"/></td>
			<td style="height: 10px" class="data-area-canvas"><img alt="" width="1" height="1" src="/oma/images/blank.gif"/></td>
			<td class="data-area-canvas">
			<table border="0" cellpadding="0" cellspacing="0" width="100%">
				<tr>
				<script language="javascript">
					document.write('<td style="width: 20px" rowspan="' + Math.floor(250 - pointer - 8) + '" valign="middle" align="left"></td>');
				</script>
				<td style="width: 1px"></td>
				<td style="height: 9px; width: 18px"></td>
				<td style="width: 1px"></td>
				<td style="width: 70px" valign="middle" align="left" class="sensor-table-text"/>
				<td rowspan="252" align="right" valign="top">
					<table cellpadding="0" cellspacing="0" style="border-style: solid; border-color:gray">
					<xsl:for-each select="ListData/Data">
					<!-- MM :Begin - D026 - fix for id issue -->
					<xsl:variable name="row_id"><xsl:number count="node()" level="single"/></xsl:variable>
					<xsl:variable name="guid"><xsl:value-of select="$table_id"/>_row<xsl:value-of select="$row_id"/></xsl:variable>
					<!-- MM :End - D026 - fix for id issue -->
						<xsl:choose>
							<xsl:when test="@type = 'radio'">
								<tr>
									<td style="width: 3px"></td>
									<td style="font-weight:bold; width: 150px">
										<!-- MM :Begin - D0261 - fix for id issue -->
										<xsl:choose>
											<xsl:when test="@id != ''"><xsl:attribute name="id">name_<xsl:value-of select="@id"/></xsl:attribute></xsl:when>
											<xsl:otherwise><xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute></xsl:otherwise>
										</xsl:choose>
										<!-- MM :End - D0261 - fix for id issue -->
										<xsl:value-of select="@display"/>
									</td>
									<td style="width: 10px">:</td>
									<td align="left">
										<input type="radio">
											<!--C88676 fix smallfont font size -->
											<xsl:attribute name="class">data-area</xsl:attribute>
											<xsl:if test="@state=1">
												<xsl:attribute name="checked"/>
											</xsl:if>
											<xsl:if test="@state=2">
												<xsl:attribute name="disabled"/>
											</xsl:if>
											<xsl:if test="@state=3">
												<xsl:attribute name="disabled"/>
												<xsl:attribute name="checked"/>
											</xsl:if>
											<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
											<!-- MM :Begin - D0261 - fix for id issue -->
											<!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
											<xsl:choose>
												<xsl:when test="@id != ''">
													<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<!-- MM :End - D0261 - fix for id issue -->
											<xsl:attribute name="value"><xsl:value-of select="@returnvalue"/></xsl:attribute>
											<xsl:attribute name="onClick"><xsl:value-of select="@handler"/></xsl:attribute>
											<xsl:value-of select="@value"/>
										</input>
									</td>
									<td style="width: 3px"></td>
								</tr>
							</xsl:when>
							<xsl:when test="@type = 'editbox'">
								<tr>
									<td style="width: 3px"></td>
									<td style="width: 150px">
										<!-- MM :Begin - D0262 - fix for id issue -->
										<xsl:choose>
											<xsl:when test="@id != ''"><xsl:attribute name="id">name_<xsl:value-of select="@id"/></xsl:attribute></xsl:when>
											<xsl:otherwise><xsl:attribute name="id">name_<xsl:value-of select="@textboxname"/></xsl:attribute></xsl:otherwise>
										</xsl:choose>
										<!-- MM :End - D0262 - fix for id issue -->
										<xsl:value-of select="@display"/>
									</td>
									<td style="width: 10px">:</td>
									<td>
										<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
										<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
										<input size="7">
											<!--C88676 fix smallfont font size -->
											<xsl:attribute name="class">data-area</xsl:attribute>
											<xsl:attribute name="name"><xsl:value-of select="@textboxname"/></xsl:attribute>
											<!-- MM :Begin - D0262 - fix for id issue -->
											<!-- xsl:attribute name="id"><xsl:value-of select="@textboxname"/></xsl:attribute -->	
											<xsl:choose>
												<xsl:when test="@id != ''">
													<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="id"><xsl:value-of select="@textboxname"/></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<!-- MM :End - D0262 - fix for id issue -->
											<xsl:attribute name="value"><xsl:value-of select="@textboxvalue"/></xsl:attribute> <xsl:value-of select="@unit"/>
											<xsl:if test="@maxlength">
												<xsl:attribute name="maxlength"><xsl:value-of select="@maxlength"/></xsl:attribute>
											</xsl:if>
										</input>
									</td>
									<td style="width: 3px"></td>
								</tr>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="@reading='true'">
										<tr>
										<td class="data-area-canvas-odd" style="width: 3px; font-weight:bold"></td>
										<td class="data-area-canvas-odd" style="width: 150px; font-weight:bold">
											<!-- MM :Begin - D0263 - fix for id issue -->
											<xsl:choose>
												<xsl:when test="@id != ''"><xsl:attribute name="id">name_<xsl:value-of select="@id"/></xsl:attribute></xsl:when>
												<xsl:otherwise><xsl:attribute name="id">name_<xsl:value-of select="@name"/></xsl:attribute></xsl:otherwise>
											</xsl:choose>
											<!-- MM :End - D0263 - fix for id issue -->
											<xsl:value-of select="@display"/>
										</td>
										<td class="data-area-canvas-odd" style="width: 10px; font-weight:bold">:</td>
										<td class="data-area-canvas-odd" style="font-weight:bold" align="left">
											<!-- MM :Begin - D0263 - fix for id issue -->
											<xsl:choose>
												<xsl:when test="@id != ''">
													<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="id">value_<xsl:value-of select="$guid"/></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<!-- MM :End - D0263 - fix for id issue -->										
											<xsl:value-of select="@value"/>
										</td>
										<td class="data-area-canvas-odd" style="width: 3px; font-weight:bold"><img src='/oma/images/blank.gif'/></td>
										</tr>
									</xsl:when>
									<xsl:otherwise>
										<tr>
										<!--C88676 fix smallfont font size -->
										<td class="data-area-canvas" style="width: 3px"></td>
										<td class="data-area-canvas" style="width: 150px">
											<!-- MM :Begin - D0263 - fix for id issue -->
											<xsl:attribute name="id">name_<xsl:value-of select="$guid"/></xsl:attribute>
											<!-- MM :End - D0263 - fix for id issue -->
											<xsl:value-of select="@display"/>
										</td>
										<td class="data-area-canvas" style="width: 10px">:</td>
										<td>
											<!-- MM :Begin - D0263 - fix for id issue -->
											<xsl:choose>
												<xsl:when test="@id != ''">
													<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="id">value_<xsl:value-of select="$guid"/></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<!-- MM :End - D0263 - fix for id issue -->										
											<xsl:choose>
												<xsl:when test="@align">
													<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="align">left</xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<xsl:choose>
												<xsl:when test="@type = 'status-text'">
													<xsl:call-template name="display-status-text">
														<xsl:with-param name="status" select="@value" />
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise><xsl:value-of select="@value"/></xsl:otherwise>
											</xsl:choose>
										</td>
										<td style="width: 3px"></td>
										</tr>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					</table>
					</td>
				</tr>
				<tr>
				<td rowspan="251" style="width: 1px; background-color: black"><img alt="" src="/oma/images/dot.gif" width="1" border="0"/></td>
				<td align="center" valign="middle" style="height; 1px; background-color: red"><img alt="" src="/oma/images/dot.gif" height="1" width="18" border="0"/></td>
				<td rowspan="251" style="width: 1px; background-color: black"><img alt="" src="/oma/images/dot.gif" width="1" border="0"/></td>
				</tr>
				<script language="javascript">

					for (var i = 0; i &lt; 50; i++)
					{
						for (var j = 0; j &lt; 5; j++)
						{
							count = Math.floor((i * 5) + j + 1);

							if( ((count &gt; (250 - cmaxmark)) &amp;&amp; (count &lt; (250 - ncmaxmark))) || ((count &gt; (250 - ncminmark)) &amp;&amp; (count &lt; (250 - cminmark))) )
							{
								color = "yellow";
							}
							else if( (count &gt; (250 - ncmaxmark)) &amp;&amp; (count &lt; (250 - ncminmark)) )
							{
								color = "green";
							}
							else
							{
								color = "red";
							}

							if (count == Math.floor(250 - pointer - 9))
							{
								document.write('&lt;tr&gt;&lt;td rowspan="19"&gt;&lt;img alt="" src="/oma/images/sensor_arrow.gif"/&gt;&lt;/td&gt;');
							}
							else if (count == Math.floor(250 - pointer + 10))
							{
								document.write('&lt;tr&gt;&lt;td rowspan="' + Math.floor(pointer - 8) + '"&gt;&lt;/td&gt;');
							}
							else document.write('&lt;tr&gt;');

							if (j == 4)
							{
								if (i + 1 == 50)
								{
									document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
									document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="18" border="0"/&gt;&lt;/td&gt;&lt;/tr&gt;');
								}
								else
								{
									if( (count == (250 - cmaxmark)) || (count == (250 - ncmaxmark)) || (count == (250 - cminmark)) || (count == (250 - ncminmark)) )
									{
										document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
										document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="14" border="0"/&gt;');
										document.write('&lt;/td&gt;');
										document.write('&lt;/tr&gt;');
									}
									else if(count == (250 - cmaxmark - 4))
									{
										document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
										document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="7" border="0"/&gt;');
										document.write('&lt;/td&gt;');
										if(numdec &gt; 0)
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncmaxmark)-(250 - cmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + numberFormat(showcmax, numdec) + ' ' + units + '&lt;/td&gt;');
										}
										else
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncmaxmark)-(250 - cmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5" /&gt;' + showcmax + ' ' + units + '&lt;/td&gt;');
										}
										document.write('&lt;/tr&gt;');
									}
									else if( count == (250 - ncmaxmark - 4))
									{
										document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
										document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="7" border="0"/&gt;');
										document.write('&lt;/td&gt;');
										if(numdec &gt; 0)
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncminmark)-(250 - ncmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + numberFormat(ncmax, numdec) +  ' ' + units + '&lt;/td&gt;');
										}
										else
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncminmark)-(250 - ncmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + ncmax +  ' ' + units + '&lt;/td&gt;');
										}
										document.write('&lt;/tr&gt;');
									}
									else if(count == (250 - ncminmark - 4))
									{
										document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
										document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="7" border="0"/&gt;');
										document.write('&lt;/td&gt;');
										if(numdec &gt; 0)
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - cminmark)-(250 - ncminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + numberFormat(ncmin, numdec) +  ' ' + units + '&lt;/td&gt;');
										}
										else
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - cminmark)-(250 - ncminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + ncmin +  ' ' + units + '&lt;/td&gt;');
										}
										document.write('&lt;/tr&gt;');
									}
									else if(count == (250 - cminmark - 4))
									{
										document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
										document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="7" border="0"/&gt;');
										document.write('&lt;/td&gt;');
										if(numdec &gt; 0)
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - minmark)-(250 - cminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + numberFormat(showcmin, numdec) +  ' ' + units + '&lt;/td&gt;');
										}
										else
										{
											document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - minmark)-(250 - cminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + showcmin +  ' ' + units + '&lt;/td&gt;');
										}
										document.write('&lt;/tr&gt;');
									}
									else
									{
										document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
										document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="7" border="0"/&gt;')
										document.write('&lt;/td&gt;&lt;/tr&gt;');
									}
								}
							}
							else
							{
								if( (count == (250 - cmaxmark)) || (count == (250 - ncmaxmark)) || (count == (250 - cminmark)) || (count == (250 - ncminmark)) )
								{
									document.write('&lt;td align="left" valign="middle" style="height; 1px; background-color: ' + color + '"&gt;');
									document.write('&lt;img alt="" src="/oma/images/dot.gif" height="1" width="14" border="0"/&gt;');
									document.write('&lt;/td&gt;');
									document.write('&lt;/tr&gt;');
								}
								else if(count == (250 - cmaxmark - 4))
								{
									document.write('&lt;td style="height: 1px; width: 18px; background-color: ' + color + '"&gt;&lt;img alt="" src="/oma/images/blank.gif" height="1" width="1"/&gt;');
									document.write('&lt;/td&gt;');
									if(numdec &gt; 0)
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncmaxmark)-(250 - cmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5" /&gt;' + numberFormat(showcmax, numdec) +  ' ' + units + '&lt;/td&gt;');
									}
									else
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncmaxmark)-(250 - cmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5" /&gt;' + showcmax +  ' ' + units + '&lt;/td&gt;');
									}
									document.write('&lt;/tr&gt;');
								}
								else if( count == (250 - ncmaxmark - 4))
								{
									document.write('&lt;td style="height: 1px; width: 18px; background-color: ' + color + '"&gt;&lt;img alt="" src="/oma/images/blank.gif" height="1" width="1"/&gt;');
									document.write('&lt;/td&gt;');
									if(numdec &gt; 0)
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncminmark)-(250 - ncmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + numberFormat(ncmax, numdec) +  ' ' + units + '&lt;/td&gt;');
									}
									else
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - ncminmark)-(250 - ncmaxmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + ncmax +  ' ' + units + '&lt;/td&gt;');
									}
									document.write('&lt;/tr&gt;');
								}
								else if(count == (250 - ncminmark - 4))
								{
									document.write('&lt;td style="height: 1px; width: 18px; background-color: ' + color + '"&gt;&lt;img alt="" src="/oma/images/blank.gif" height="1" width="1"/&gt;');
									document.write('&lt;/td&gt;');
									if(numdec &gt; 0)
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - cminmark)-(250 - ncminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + numberFormat(ncmin, numdec) +  ' ' + units + '&lt;/td&gt;');
									}
									else
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - cminmark)-(250 - ncminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + ncmin +  ' ' + units + '&lt;/td&gt;');
									}
									document.write('&lt;/tr&gt;');
								}
								else if(count == (250 - cminmark - 4))
								{
									document.write('&lt;td style="height: 1px; width: 18px; background-color: ' + color + '"&gt;&lt;img alt="" src="/oma/images/blank.gif" height="1" width="1"/&gt;');
									document.write('&lt;/td&gt;');
									if(numdec &gt; 0)
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - minmark)-(250 - cminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + numberFormat(showcmin, numdec) +  ' ' + units + '&lt;/td&gt;');
									}
									else
									{
										document.write('&lt;td class="sensor-table-text" rowspan="' + ((250 - minmark)-(250 - cminmark)) + '" valign="top" align="left"&gt;&lt;img src="/oma/images/blank.gif" width="5"/&gt;' + showcmin +  ' ' + units + '&lt;/td&gt;');
									}
									document.write('&lt;/tr&gt;');
								}
								else
								{
									document.write('&lt;td style="height: 1px; width: 18px; background-color: ' + color + '"&gt;&lt;img alt="" src="/oma/images/blank.gif" height="1" width="1"/&gt;');
									document.write('&lt;/td&gt;&lt;/tr&gt;');
								}
							}
						}
					}
				</script>
					<tr>
						<td></td>
						<td style="height: 9px"></td>
						<td></td>
					</tr>
				</table>
			</td>
			<td style="height: 10px" class="data-area-canvas"><img alt="" width="1" height="1" src="/oma/images/blank.gif"/></td>
			<td style="width: 15px"><img alt="" src="/oma/images/blank.gif" height="1" width="15"/></td>
		</tr>
		<tr>
			<td style="width: 15px"><img alt="" src="/oma/images/blank.gif" height="1" width="15"/></td>
			<td style="height: 10px; width: 10px">
				<img alt="" height="10" width="10">
					<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
				</img>
			</td>
			<td style="height: 10px" class="data-area-canvas"><img alt="" width="1" height="1" src="/oma/images/blank.gif"/></td>
			<td style="height: 10px; width: 10px">
				<img alt="" height="10" width="10" src="/oma/images/br.gif">
					<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
				</img>
			</td>
			<td style="width: 15px"><img alt="" src="/oma/images/blank.gif" height="1" width="15"/></td>
		</tr>
		</table>
	</xsl:template>
	<xsl:template match="ComboData">
		<!-- MM :Begin - D028 - fix for id issue -->
		<xsl:variable name="guid">
			<xsl:choose>
				<xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when>
				<xsl:otherwise>table<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : This value will be used to generate id for back to top -->
		<xsl:variable name="backToTopId" select="$guid"/>
		<!-- MM :End - D028 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@ignoreJumpBar"></xsl:when>
			<xsl:otherwise>
				<script language="javascript">
					addJumpDataItem ('<xsl:call-template name="replace-substring"><xsl:with-param name="text" select="@name" /><xsl:with-param name="from">\</xsl:with-param><xsl:with-param name="to">		\\</xsl:with-param></xsl:call-template>'
        , "<xsl:value-of select='@display'/>");
					incTableCount();
				</script>
			</xsl:otherwise>
		</xsl:choose>
		<a>
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
			<br/>
			<!-- This is the main table -->
			<table cellpadding="0" cellspacing="0" border="0"  width="100%">
				<tr>
					<td style="width: 15px" />
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
						</img>
					</td>
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
						</img>
					</td>
					<td style="width: 15px" />
				</tr>
				<tr>
					<td style="width: 15px" />
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td class="data-area-canvas">
						<!-- This is the table enclosing both listdata and tabledata -->
						<table width="100%">
							<tr>
								<td>
									<!-- This is ListData border table -->
									<table width="50%" cellpadding="0" cellspacing="0" style="border-style: solid; border-left-width:thin; border-right-width:thin ; border-top-width:thin; border-bottom-width:thin; border-color:gray">
										<tr>
											<td style="width: 10px; height: 10px"></td>
											<td style="height: 10px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
											<td style="width: 10px; height: 10px"></td>
										</tr>
										<tr>
											<td style="height: 10px" class="data-area-canvas">
												<img   style="width: 1px; height: 1px"/>
											</td>
											<td class="data-area-canvas">
												<!-- This is the table enclosing ListData and its SubHeader-->
												<table  width="100%" cellpadding="5" cellspacing="0" border="0">
													<tr>
														<td>
															<!-- This is the table enclosing ListData SubHeader-->
															<table border="0" cellpadding="0" cellspacing="0">
																<tr>
																	<td align="left" valign="center">
																		<xsl:if test="ListData/SubHeader/@status!=''">
																			<xsl:call-template name="display-status">
																				<xsl:with-param name="status" select="ListData/SubHeader/@status" />
																				<!-- MM : Begin - D0282 - Fix for id issue -->
																				<xsl:with-param name="id">img_<xsl:value-of select="$guid"/></xsl:with-param>
																				<!-- MM : End - D0282 - Fix for id issue -->
																			</xsl:call-template>
																		</xsl:if>
																	</td>
																	<td style="width: 5px" />
																	<td align="left" valign="center">
																		<!-- MM : Begin - D0281 - Fix for id issue -->
																		<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
																		<xsl:attribute name="id">header_<xsl:value-of select="$guid"/></xsl:attribute>
																		<!-- MM : End - D0281 - Fix for id issue -->
																		<span class="data-area-sub-header">
																			<xsl:value-of select="ListData/SubHeader/@display"/>
																		</span>
																	</td>
																</tr>
															</table>
															<br></br>
														</td>
													</tr>
													<xsl:for-each select="ListData">
														<xsl:call-template name="ListDataEntries">
															<xsl:with-param name="caller">custom</xsl:with-param>
															<!-- MM :Begin - D0283 - fix for id issue -->
															<xsl:with-param name="puid"><xsl:value-of select="$guid"/></xsl:with-param>
															<!-- MM :End - D0283 - fix for id issue -->
														</xsl:call-template>
													</xsl:for-each>
												</table>
											</td>
											<td style="height: 10px" class="data-area-canvas">
												<img   style="width: 1px; height: 1px"/>
											</td>
										</tr>
										<tr>
											<td style="width: 10px; height: 10px"></td>
											<td style="height: 10px" class="data-area-canvas">
												<img   style="width: 1px; height: 1px"/>
											</td>
											<td style="width: 10px; height: 10px"></td>
										</tr>
									</table>
									<br></br>
								</td>
							</tr>
						<xsl:if test="count(TableData) &gt; 0">
							<xsl:for-each select="TableData">
								<!-- MM :Begin - D028 - fix for id issue -->
								<xsl:variable name="tuid">
									<xsl:choose>
										<xsl:when test="@name != ''"><xsl:value-of select="@name"/></xsl:when>
										<xsl:otherwise><xsl:value-of select="position()"/></xsl:otherwise>
									</xsl:choose>
								</xsl:variable>								
								<!-- MM :End - D028 - fix for id issue -->
							<tr>
							    <td>
									<!-- This is the table for TableData SubHeader--><!--89085 Add new line in ComboData-->
									<br></br>
									<table border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td align="left" valign="center">
												<xsl:if test="SubHeader/@status!=''">
													<xsl:call-template name="display-status">
														<xsl:with-param name="status" select="SubHeader/@status" />
														<!-- MM : Begin - D0282 - Fix for id issue -->
														<xsl:with-param name="id">img_<xsl:value-of select="$tuid"/></xsl:with-param>
														<!-- MM : End - D0282 - Fix for id issue -->
													</xsl:call-template>
												</xsl:if>
											</td>
											<td style="width: 5px" />
											<td align="left" valign="center">
												<!-- MM : Begin - D0281 - Fix for id issue -->
												<xsl:attribute name="id">header_<xsl:value-of select="$tuid"/></xsl:attribute>
												<!-- We provide 'id' here because SilkTest doesnt identify 'id' or 'name' for <span>. -->
												<!-- MM : End - D0281 - Fix for id issue -->
												<span class="data-area-sub-header">
													<xsl:value-of select="SubHeader/@display"/>
												</span>
											</td>
										</tr>
										<xsl:if test="count(DescText) &gt; 0">
											<tr>
												<td align="left" valign="center"></td>
												<td align="left" valign="center"></td>
												<td align="left" valign="center">
													<i>
														<xsl:value-of select="DescText/@display"/>
													</i>
												</td>
											</tr>
										</xsl:if>
									</table>
								</td>
							</tr>
							<tr>
								<td>
									<!-- This is the table enclosing TableData-->
									<table cellpadding="0" cellspacing="0" width="100%" style="border-style: solid; border-left-width:thin; border-right-width:thin ; border-top-width:thin; border-bottom-width:thin; border-color:gray">
										<tr>
											<td style="width: 10px; height: 10px"></td>
											<td style="height: 10px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
											<td style="width: 10px; height: 10px"></td>
										</tr>
										<tr>
											<td style="height: 10px" class="data-area-canvas">
												<img   style="width: 1px; height: 1px"/>
											</td>
											<td class="data-area-canvas">
												<table width="100%" cellpadding="0" cellspacing="0" border="0">
												<xsl:choose>
													<xsl:when test="@columnspacing='true'">
														<xsl:apply-templates select="Header">
															<xsl:with-param name="columnspacing">true</xsl:with-param>
															<!-- MM :Begin - D0281 - fix for id issue -->
															<xsl:with-param name="puid"><xsl:value-of select="$tuid"/></xsl:with-param>
															<!-- MM :End - D0281 - fix for id issue -->
														</xsl:apply-templates>
														<xsl:apply-templates select="Row">
															<xsl:with-param name="columnspacing">true</xsl:with-param>
															<!-- MM :Begin - D0283 - fix for id issue -->
															<xsl:with-param name="puid"><xsl:value-of select="$tuid"/></xsl:with-param>
															<!-- MM :End - D0283 - fix for id issue -->
														</xsl:apply-templates>
													</xsl:when>
													<xsl:otherwise>
														<xsl:apply-templates select="Header">
															<!-- MM :Begin - D0281 - fix for id issue -->
															<xsl:with-param name="puid"><xsl:value-of select="$tuid"/></xsl:with-param>
															<!-- MM :End - D0281 - fix for id issue -->
														</xsl:apply-templates>
														<xsl:apply-templates select="Row">
															<!-- MM :Begin - D0283 - fix for id issue -->
															<xsl:with-param name="puid"><xsl:value-of select="$tuid"/></xsl:with-param>
															<!-- MM :End - D0283 - fix for id issue -->
														</xsl:apply-templates>														
													</xsl:otherwise>
												</xsl:choose>
												</table>
											</td>
											<td style="height: 10px" class="data-area-canvas">
												<img   style="width: 1px; height: 1px"/>
											</td>
										</tr>
										<tr>
											<td style="width: 10px; height: 10px"></td>
											<td style="height: 10px" class="data-area-canvas">
												<img   style="width: 1px; height: 1px"/>
											</td>
											<td style="width: 10px; height: 10px"></td>
										</tr>
									</table>
								</td>
							</tr>
							</xsl:for-each>
						</xsl:if>
						</table>
					</td>
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td style="width: 15px" />
				</tr>
				<tr>
					<td style="width: 15px" />
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
						</img>
					</td>
					<td style="height: 10px" class="data-area-canvas">
						<img   style="width: 1px; height: 1px"/>
					</td>
					<td style="width: 10px; height: 10px">
						<img style="width: 10px; height: 10px">
							<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
						</img>
					</td>
					<td style="width: 15px" />
				</tr>
			</table>
			<br/>
		</a>
		<!-- 86033 Add back to top links-->
		<xsl:choose>
			<xsl:when test="/OMA/DataArea/@ignoreJumpBar"></xsl:when>
			<xsl:otherwise>
			     <!--MOH Insert links even for first combodata -->
				<xsl:if test="count( /OMA/DataArea/ComboData ) > 1">
					<table width="100%" cellpadding="0" cellspacing="0" border="0">
						<tr>
							<td style="width: 15px" />
							<td>
								<div>
									<!-- MM :Begin - D041 - fix for id issue -->
									<!-- Add 'id' and 'name' attribute -->
									[<a class="data-area-back-to-top" href="#top">
										<xsl:attribute name="id">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
										<xsl:attribute name="name">backtotop_<xsl:value-of select="$backToTopId"/></xsl:attribute>
										<xsl:value-of select="$strBackToTop"/>
									</a>]
									<!-- MM :End - D041 - fix for id issue -->
								</div>
							</td>
							<td style="width: 15px" />
						</tr>
					</table>
					<br/>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="PerformanceData">
		<xsl:if test="@type='uidata'">
			<!-- start processor graphs -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Processor(s)</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/Graph">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">graph</xsl:with-param><xsl:with-param name="obj">proc</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end processor graphs -->
			<!-- start disk -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Disk(s)</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/BoxData/DiskData">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">box</xsl:with-param><xsl:with-param name="obj">disk</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end disk -->
			<!-- start memory -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Memory</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/BoxData/MemData">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">box</xsl:with-param><xsl:with-param name="obj">mem</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end memory -->
			<!-- start network -->
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">start</xsl:with-param></xsl:call-template>
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td align="left" valign="center">
							<span class="data-area-sub-header">Network</span>
						</td>
					</tr>
					<xsl:for-each select="UIData/BoxData/NTWData">
						<xsl:call-template name="PerfElement"><xsl:with-param name="type">box</xsl:with-param><xsl:with-param name="obj">network</xsl:with-param></xsl:call-template>
					</xsl:for-each>
				</table>
			<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			<!-- end network -->
		</xsl:if>
	</xsl:template>
	<xsl:template name="PerfElement">
		<xsl:param name="type"/>
		<xsl:param name="obj"/>
			<xsl:if test="(position() mod 2)='1'">
				<script language="javascript">
					document.write('&lt;tr&gt;');
				</script>
			</xsl:if>
			<td>
				<table>
					<tr>
						<td>
							<table  cellpadding="0" cellspacing="0" style="border-style: solid; border-left-width:thin; border-right-width:thin ; border-top-width:thin; border-bottom-width:thin; border-color:gray">
								<xsl:if test="$type='graph'">
									<xsl:attribute name="height">200</xsl:attribute>
								</xsl:if>
								<xsl:if test="$obj='mem'">
									<xsl:attribute name="height">165</xsl:attribute>
								</xsl:if>
								<tr>
									<xsl:if test="$type='graph'">
										<td>
											<xsl:call-template name="DrawGraph"/>
										</td>
									</xsl:if>
									<td valign="top">
										<table>
											<tr>
												<td>
													<xsl:apply-templates select="SubHeader"/>
												</td>
											</tr>
											<tr>
												<td>
													<table>
														<tr>
															<td style="width: 10px; height: 10px"></td>
															<td style="height: 10px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
															<td style="width: 10px; height: 10px"></td>
														</tr>
														<tr>
															<td style="width: 10px; height: 10px"></td>
															<td>
															<table>
															<xsl:for-each select="ListData/Data">
															<tr>
																<td ><xsl:value-of select="@display"/>: </td>
																<td width="50">
																<div><xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute><xsl:value-of select="@value"/></div>
																</td>
															</tr>
															</xsl:for-each>
															</table>
															</td>
															<td style="width: 10px; height: 10px"></td>
														</tr>
														<tr>
															<td style="width: 10px; height: 10px"></td>
															<td style="height: 10px" class="data-area-canvas"><img   style="width: 1px; height: 1px"/></td>
															<td style="width: 10px; height: 10px"></td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
			<xsl:if test="((position() mod 2)='0') or (position() = last())">
				<script language="javascript">
					document.write('&lt;/tr&gt;');
				</script>
			</xsl:if>
	</xsl:template>
	<xsl:template name="Lozenge">
		<xsl:param name="location"/>
		<xsl:param name="beginpadding">true</xsl:param>
		<xsl:param name="endpadding">true</xsl:param>
		<xsl:param name="ignorespacing">false</xsl:param>
		<xsl:choose>
			<xsl:when test="$location='start'">
				<xsl:if test="$ignorespacing = 'false'">
					<br/>
				</xsl:if>
					<!-- Start outer most lozenge -->
					<script language="javascript">
						document.write('&lt;table width="100%" cellpadding="0" cellspacing="0" border="0"&gt;');
					</script>
						<tr>
							<xsl:if test="$beginpadding = 'true'">
								<td style="width: 15px" />
							</xsl:if>
							<td style="width: 10px; height: 10px">
								<img style="width: 10px; height: 10px">
<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
								</img>
							</td>
							<td style="height: 10px" class="data-area-canvas">
								<img   style="width: 1px; height: 1px"/>
							</td>
							<td style="width: 10px; height: 10px">
								<img style="width: 10px; height: 10px">
<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of 	select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
								</img>
							</td>
							<xsl:if test="$endpadding = 'true'">
								<td style="width: 15px" />
							</xsl:if>
						</tr>
					<script language="javascript">
						document.write('&lt;tr&gt;');
					</script>
							<xsl:if test="$beginpadding = 'true'">
								<td style="width: 15px" />
							</xsl:if>
							<td style="height: 10px" class="data-area-canvas">
								<img   style="width: 1px; height: 1px"/>
							</td>
					<script language="javascript">
						document.write('&lt;td class="data-area-canvas"&gt;');
					</script>
			</xsl:when>
			<xsl:otherwise>
				<script language="javascript">
					document.write('&lt;/td&gt;');
				</script>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<xsl:if test="$endpadding = 'true'">
					<td style="width: 15px" />
				</xsl:if>
			<script language="javascript">
				document.write('&lt;/tr&gt;');
			</script>
			<tr>
				<xsl:if test="$beginpadding = 'true'">
					<td style="width: 15px" />
				</xsl:if>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
					</img>
				</td>
				<td style="height: 10px" class="data-area-canvas">
					<img   style="width: 1px; height: 1px"/>
				</td>
				<td style="width: 10px; height: 10px">
					<img style="width: 10px; height: 10px">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
					</img>
				</td>
				<xsl:if test="$endpadding = 'true'">
					<td style="width: 15px" />
				</xsl:if>
			</tr>
			<script language="javascript">
				document.write('&lt;/table&gt;');
			</script>
			<!-- End outer most lozenge -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="DrawGraph">
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td style="height: 9px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td style="background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td style="height: 9px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
			</tr>
			<tr>
				<td style="height: 3px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td>
					<div>
						<xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
						<table border="0" cellpadding="0" cellspacing="0">
							<xsl:call-template name="insertBars">
								<xsl:with-param name="id" select="@name"/>
								<xsl:with-param name="loop_var" select="1"/>
								<xsl:with-param name="prct" select="(50 - ceiling(@percent div 2))"/>
							</xsl:call-template>
						</table>
					</div>
				</td>
				<td style="height: 3px; width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
			</tr>
			<tr>
				<td style="width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
				<td style="background-color: black; color: #00D500" align="right">
					<div><xsl:attribute name="id"><xsl:value-of select="@name"/>_text</xsl:attribute><xsl:value-of select="@percent"/>%</div>
				</td>
				<td style="width: 9px; background-color: black">
					<script language="javascript">	document.write ("&amp;nbsp;");</script>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="insertBars">
		<xsl:param name="id"/>
		<xsl:param name="loop_var"/>
		<xsl:param name="prct"/>
		<xsl:if test="$loop_var &lt; '51'">
			<xsl:choose>
				<xsl:when test="$loop_var &lt; $prct">
					<tr>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #004000">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_1</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
						<td style="height: 2px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="3" width="1"/></td>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #004000">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_2</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #00DC00">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_1</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
						<td style="height: 2px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="3" width="1"/></td>
						<td style="height: 2px; width: 17px;">
							<div style="background-color: #00DC00">
								<xsl:attribute name="id"><xsl:value-of select="$id"/><xsl:value-of select="$loop_var"/>_2</xsl:attribute>
								<img alt="" src="/oma/images/blank.gif" height="3" width="1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 1px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
						<td style="height: 1px; width: 17px; background-color: black"><img alt="" src="/oma/images/blank.gif" height="1" width="1"/></td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:call-template name="insertBars">
				<xsl:with-param name="id" select="$id"/>
				<xsl:with-param name="loop_var" select="$loop_var + 1"/>
				<xsl:with-param name="prct" select="$prct"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="SelectionDataUI">
		<xsl:choose>
			<xsl:when test="@tile = 'vertical' ">
				<xsl:choose>
					<xsl:when test=" @order='resultfirst' ">
						<iframe frameborder="0">
							<!--70936 - Adding code to allow user defined IFrame width and height. If user has not defined then take default -->
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
						<iframe frameborder="0">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</xsl:when>
					<!-- Selection Iframe is positioned first by default -->
					<xsl:otherwise>
						<iframe frameborder="0">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
						<iframe frameborder="0">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>38%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>90%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- Iframes are tiled horizontally by default -->
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test=" @order='resultfirst' ">
						<iframe frameborder="0" name="ResultFrame" onload="javascript:SetDefaultFrameHeight('ResultFrame');">
							<!-- 70936 - Adding code to allow user defined IFrame width and height. If user has not defined then take default -->
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>76%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>45%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
						<iframe frameborder="0" name="SelectionFrame" onload="javascript:SetDefaultFrameHeight('SelectionFrame');">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>76%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>45%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</xsl:when>
					<!-- Selection Iframe is positioned first by default -->
					<xsl:otherwise>
						<iframe frameborder="0" name="SelectionFrame" onload="javascript:SetDefaultFrameHeight('SelectionFrame');">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@height"><xsl:value-of select="SelectionTableUI/@height"/></xsl:when>
									<xsl:otherwise>76%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="SelectionTableUI/@width"><xsl:value-of select="SelectionTableUI/@width"/></xsl:when>
									<xsl:otherwise>45%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="SelectionTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, 'javascript') = false"><xsl:value-of select="SelectionTableUI/@href"/><xsl:choose><xsl:when test="contains(SelectionTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="SelectionTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
						<iframe frameborder="0" name="ResultFrame" onload="javascript:SetDefaultFrameHeight('ResultFrame');">
							<xsl:attribute name="height">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@height"><xsl:value-of select="ResultTableUI/@height"/></xsl:when>
									<xsl:otherwise>76%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="width">
								<xsl:choose>
									<xsl:when test="ResultTableUI/@width"><xsl:value-of select="ResultTableUI/@width"/></xsl:when>
									<xsl:otherwise>45%</xsl:otherwise>
								</xsl:choose>
							</xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="name"><xsl:value-of select="ResultTableUI/@id"/></xsl:attribute>
							<xsl:attribute name="src"><xsl:choose><xsl:when test="contains(ResultTableUI/@href, 'javascript') = false"><xsl:value-of select="ResultTableUI/@href"/><xsl:choose><xsl:when test="contains(ResultTableUI/@href, '?')">&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:when><xsl:otherwise>?vid=<xsl:value-of select="/OMA/@vid" /></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="ResultTableUI/@href"/></xsl:otherwise></xsl:choose></xsl:attribute>
						</iframe>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="SelectionData">
		<!-- MM :Begin - D035 - fix for id issue -->
		<xsl:variable name="table_id"><xsl:value-of select="position()"/></xsl:variable>
		<!-- MM :End - D035 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@multitable = 'true' ">
				<table border="0" cellpadding="0" cellspacing="0">
					<TR>
						<TD rowspan="5" style="width: 15px">
							<IMG alt="" height="1"   width="15"/>
						</TD>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
							</img>
						</td>
						<TD class="data-area-canvas" style="width: 50%; height: 10px">
							<IMG alt="" height="1"   width="1"/>
						</TD>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
							</img>
						</td>
						<TD rowspan="5" style="width: 20px" valign="middle">
							<xsl:choose>
								<xsl:when test="not(@image) or @image = 'right'">
									<img alt="" src="/oma/images/arrow_right.gif" height="25" width="20"/>
								</xsl:when>
								<xsl:when test="@image = 'left'">
									<img alt="" src="/oma/images/arrow_left.gif" height="25" width="20"/>
								</xsl:when>
								<xsl:when test="@image = 'both'">
									<img alt="" src="/oma/images/arrow_left_right.gif" height="50" width="20"/>
								</xsl:when>
								<xsl:when test="@image = 'none'">
									<img alt="" src="/oma/images/spacer_Transparent.gif" height="25" width="20"/>
								</xsl:when>
								<xsl:otherwise>
									<img alt="" src="/oma/images/arrow_right.gif" height="25" width="20"/>
								</xsl:otherwise>
							</xsl:choose>
						</TD>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tl.gif</xsl:attribute>
							</img>
						</td>
						<TD class="data-area-canvas" style="width: 50%; height: 10px">
							<IMG alt="" height="1"   width="1"/>
						</TD>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/tr.gif</xsl:attribute>
							</img>
						</td>
						<TD rowspan="5" style="width: 15px">
							<IMG alt="" height="1"   width="15"/>
						</TD>
					</TR>
					<TR>
						<TD class="data-area-canvas" rowspan="3">
							<IMG alt="" height="1"   width="1"/>
						</TD>
						<TD align="left" class="data-area-canvas" valign="middle">
							<!--SelectionTable Header table goes here -->
							<table>
								<tr>
									<xsl:for-each select="SelectionTable/Header/Data">
										<td class="data-area-canvas" valign="top">
											<xsl:call-template name="calldatatype">
												<!-- MM :Begin - D035 - fix for id issue -->
												<xsl:with-param name="puid">header_<xsl:value-of select="$table_id"/><xsl:value-of select="position()"/></xsl:with-param>
												<!-- MM :End - D035 - fix for id issue -->
											</xsl:call-template>
										</td>
									</xsl:for-each>
								</tr>
							</table>
						</TD>
						<TD class="data-area-canvas" rowspan="3">
							<IMG alt="" height="1"   width="1"/>
						</TD>
						<TD class="data-area-canvas" rowspan="3">
							<IMG alt="" height="1"   width="1"/>
						</TD>
						<TD align="left" class="data-area-canvas" valign="top">
							<!--ResultTable Header table goes here -->
							<table>
								<tr>
									<xsl:for-each select="ResultTable/Header/Data">
										<td class="data-area-canvas" valign="top">
											<xsl:call-template name="calldatatype">
												<!-- MM :Begin - D035 - fix for id issue -->
												<xsl:with-param name="puid">header_<xsl:value-of select="$table_id"/><xsl:value-of select="position()"/></xsl:with-param>
												<!-- MM :End - D035 - fix for id issue -->
											</xsl:call-template>
										</td>
									</xsl:for-each>
								</tr>
							</table>
						</TD>
						<TD class="data-area-canvas" rowspan="3">
							<IMG alt="" height="1"   width="1"/>
						</TD>
					</TR>
					<TR>
						<td style="height: 1px" class="data-area-separator" valign="middle">
							<img style="width: 1px; height: 1px"  />
						</td>
						<td style="height: 1px" class="data-area-separator" valign="middle">
							<img style="width: 1px; height: 1px"  />
						</td>
					</TR>
					<TR>
						<TD align="left" class="data-area-canvas" valign="top">
							<!--SelectionTable Data Tree goes here-->
							<table  border="0" width="100%">
								<xsl:for-each select="SelectionTable/Row">
									<xsl:call-template name="SelectionDataRow">
										<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
										<!-- MM :Begin - D035 - fix for id issue -->
										<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
										<!-- MM :End - D035 - fix for id issue -->
									</xsl:call-template>
								</xsl:for-each>
							</table>
						</TD>
						<TD align="left" class="data-area-canvas" valign="top">
							<!--ResultTable Data Tree goes here-->
							<xsl:for-each select="ResultTable/Row">
								<div>
									<xsl:attribute name="id">rt_row_<xsl:value-of select="@name"/></xsl:attribute>
									<xsl:choose>
										<xsl:when test="@state = 'hide' ">
											<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="style">DISPLAY:</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<table width="100%">
										<xsl:call-template name="SelectionDataRow">
											<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
											<!-- MM :Begin - D035 - fix for id issue -->
											<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
											<!-- MM :End - D035 - fix for id issue -->
										</xsl:call-template>
									</table>
								</div>
							</xsl:for-each>
						</TD>
					</TR>
					<TR>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
							</img>
						</td>
						<TD class="data-area-canvas" style="width: 40%; height: 10px">
							<IMG alt="" height="1"   width="1"/>
						</TD>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
							</img>
						</td>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/bl.gif</xsl:attribute>
							</img>
						</td>
						<TD class="data-area-canvas" style="width: 40%; height: 10px">
							<IMG alt="" height="1"   width="1"/>
						</TD>
						<td style="width: 10px; height: 10px">
							<img style="width: 10px; height: 10px">
								<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/		<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/br.gif</xsl:attribute>
							</img>
						</td>
					</TR>
				</table>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="Lozenge">
					<xsl:with-param name="location">start</xsl:with-param>
					<xsl:with-param name="ignorespacing">true</xsl:with-param>
				</xsl:call-template>
					<table width="100%" border="0" cellpadding="0" cellspacing="0">
						<xsl:if test="SelectionTable/Header">
							<!-- Header Row -->
							<xsl:variable name="headerFont"><xsl:choose>
								<xsl:when test="SelectionTable/Header/@style = 'bold'"><xsl:value-of select="SelectionTable/Header/@style"/></xsl:when>
								<xsl:otherwise>plain</xsl:otherwise>
							</xsl:choose></xsl:variable>
							<tr>
								<td>
									<table>
										<tr>
											<xsl:for-each select="SelectionTable/Header/Data">
											<xsl:choose>
												<xsl:when test="$headerFont = 'bold'">
													<th class="data-area-header" valign="middle" align="left">
														<xsl:call-template name="calldatatype">
															<!-- MM :Begin - D035 - fix for id issue -->
															<xsl:with-param name="puid">header_<xsl:value-of select="$table_id"/><xsl:value-of select="position()"/></xsl:with-param>
															<!-- MM :End - D035 - fix for id issue -->
														</xsl:call-template>
													</th>
												</xsl:when>
												<xsl:otherwise>
													<td class="data-area-canvas" valign="middle" align="left">
														<xsl:call-template name="calldatatype">
															<!-- MM :Begin - D035 - fix for id issue -->
															<xsl:with-param name="puid">header_<xsl:value-of select="$table_id"/><xsl:value-of select="position()"/></xsl:with-param>
															<!-- MM :End - D035 - fix for id issue -->
														</xsl:call-template>
													</td>
												</xsl:otherwise>
											</xsl:choose>
											</xsl:for-each>
										</tr>
									</table>
								</td>
							</tr>
							<!-- Separator Row -->
							<tr>
								<td style="height: 1px" class="data-area-separator" valign="middle">
									<img style="width: 1px; height: 1px"  />
								</td>
							</tr>
							<tr>
								<td style="height: 5px" valign="middle"></td>
							</tr>
						</xsl:if>
						<!-- Data Rows  -->
						<xsl:for-each select="SelectionTable/Row">
							<xsl:call-template name="SelectionDataRow">
								<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
								<!-- MM :Begin - D035 - fix for id issue -->
								<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
								<!-- MM :End - D035 - fix for id issue -->
							</xsl:call-template>
						</xsl:for-each>
					</table>
				<xsl:call-template name="Lozenge"><xsl:with-param name="location">end</xsl:with-param></xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="SelectionDataRow">
		<xsl:param name="childrows"/>
		<!-- MM :Begin - D036 - fix for id issue -->
		<xsl:param name="puid" select="1"/>
		<xsl:variable name="guid"><xsl:value-of select="$puid"/></xsl:variable>
		<!-- MM :End - D036 - fix for id issue -->
		<xsl:variable name="id"><xsl:value-of select="@name"/></xsl:variable>
		<xsl:choose>
			<xsl:when test="@type='header'">
				<tr>
					<td>
						<table border="0" cellpadding="1" cellspacing="1"  width="100%">
							<tr>								
								<td  align="center" class="data-area-canvas" style="width: 20px; height: 25px" valign="top">
									<img border="0" alt="">
										<xsl:attribute name="id">img_<xsl:value-of select="@name"/></xsl:attribute>
											<!-- MM :Begin - D037 - fix for id issue -->
											<!-- provide name attribute as well as SilkTest doesnt use 'id' attribute for img -->
											<xsl:attribute name="name">img_<xsl:value-of select="@name"/></xsl:attribute>
											<!-- MM :End - D037 - fix for id issue -->
										<xsl:attribute name="src">/oma/skins/modern/images/blank.gif</xsl:attribute>
									</img>
								</td>
								<td>
									<xsl:attribute name="class">data-area-background</xsl:attribute>
									<table border="0" width="100%">
										<tr>
											<xsl:for-each select="ColumnData/Data">
													<xsl:choose>
														<xsl:when test="@style='bold'">
															<th valign="top">
																<xsl:attribute name="class">data-area-header</xsl:attribute>
																<xsl:call-template name="calldatatype">
																	<!-- MM :Begin - D036 - fix for id issue -->
																	<xsl:with-param name="puid"><xsl:value-of select="../../SelectDataItem/Data/@name"/>_text<xsl:value-of select="$guid"/></xsl:with-param>
																	<!-- MM :End - D036 - fix for id issue -->
																</xsl:call-template>
															</th>
														</xsl:when>
														<xsl:otherwise>
															<td valign="top">
															<xsl:choose>
																<xsl:when test="$childrows > 0">
																	<xsl:attribute name="class">data-area-background</xsl:attribute>
																</xsl:when>
																<xsl:otherwise>
																	<!--xsl:attribute name="class">data-area-canvas</xsl:attribute-->
																	<xsl:choose>
																		<xsl:when test="(position() mod 2)=1">
																			<xsl:attribute name="class">data-area-canvas-odd</xsl:attribute>
																		</xsl:when>
																		<xsl:otherwise>
																			<xsl:attribute name="class">data-area-canvas</xsl:attribute>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:otherwise>
															</xsl:choose>
															<xsl:call-template name="calldatatype">
																<!-- MM :Begin - D036 - fix for id issue -->
																<xsl:with-param name="puid"><xsl:value-of select="../../SelectDataItem/Data/@name"/>_text<xsl:value-of select="$guid"/></xsl:with-param>
																<!-- MM :End - D036 - fix for id issue -->
															</xsl:call-template>
															</td>
														</xsl:otherwise>
													</xsl:choose>
											</xsl:for-each>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</xsl:when>
			<xsl:otherwise>
			<tr>
					<td>
						<xsl:if test="$childrows > 0">
							<script language="javascript">
								document.write('&lt;table border="0" cellpadding="0" cellspacing="0"  width="100%"&gt;');
								document.write('&lt;tr&gt;');
								document.write('&lt;td class="data-area-canvas"&gt;');
							</script>
						</xsl:if>
						<div>
							<xsl:if test="@state='hide'">
								<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
							</xsl:if>
							<xsl:attribute name="id">parentrow_<xsl:value-of select="$id"/></xsl:attribute>
						<table border="0" cellpadding="1" cellspacing="1"  width="100%">
							<tr>
								<!-- Column 1 : Tree control image [plus, minus]  -->
								<xsl:if test="($childrows > 0)">
									<xsl:choose>
										<xsl:when test=" @tree = 'fixed' "></xsl:when>
										<xsl:otherwise>
											<td  align="center" class="data-area-canvas" style="width: 20px; height: 25px" valign="top">
												<img border="0" alt="">
													<xsl:attribute name="id">img_<xsl:value-of select="@name"/></xsl:attribute>
													<!-- MM :Begin - D037 - fix for id issue -->
													<!-- provide name attribute as well as SilkTest doesnt use 'id' attribute for img -->
													<xsl:attribute name="name">img_<xsl:value-of select="@name"/></xsl:attribute>
													<!-- MM :End - D037 - fix for id issue -->
													<xsl:choose>
														<xsl:when test="@tree = 'expand' "><xsl:attribute name="src">/oma/skins/modern/images/ctminus.gif</xsl:attribute></xsl:when>
														<xsl:otherwise><xsl:attribute name="src">/oma/skins/modern/images/ctplus.gif</xsl:attribute></xsl:otherwise>
													</xsl:choose>
													<xsl:attribute name="OnClick">javascript:selectionData('<xsl:value-of select="$id"/>')</xsl:attribute>
												</img>
											</td>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:if>
								<!-- Column 2 : Selection Indicator data Item like.. check box or radio button, etc-->
								<xsl:for-each select="SelectDataItem/Data">
									<td valign="top">
										<xsl:choose>
											<xsl:when test="$childrows > 0">
												<xsl:attribute name="class">data-area-background</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">data-area-canvas</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:call-template name="calldatatype"/>
									</td>
								</xsl:for-each>
								<!-- Column 3 : Parent data Items -->
								<td>
									<xsl:choose>
										<xsl:when test="$childrows > 0">
											<xsl:attribute name="class">data-area-background</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">data-area-canvas</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
									<table border="0" width="100%">
										<tr>
											<xsl:for-each select="ColumnData/Data">
													<xsl:choose>
														<xsl:when test="@style='bold'">
															<th valign="top">
																<xsl:attribute name="class">data-area-header</xsl:attribute>
																<xsl:call-template name="calldatatype">
																	<!-- MM :Begin - D036 - fix for id issue -->
																	<xsl:with-param name="puid"><xsl:value-of select="../../SelectDataItem/Data/@name"/>_text<xsl:value-of select="$guid"/></xsl:with-param>
																	<!-- MM :End - D036 - fix for id issue -->
																</xsl:call-template>
															</th>
														</xsl:when>
														<xsl:otherwise>
															<td valign="top">
															<xsl:choose>
																<xsl:when test="$childrows > 0">
																	<xsl:attribute name="class">data-area-background</xsl:attribute>
																</xsl:when>
																<xsl:otherwise>
																	<xsl:attribute name="class">data-area-canvas</xsl:attribute>
																</xsl:otherwise>
															</xsl:choose>
															<xsl:call-template name="calldatatype">
																<!-- MM :Begin - D036 - fix for id issue -->
																<xsl:with-param name="puid"><xsl:value-of select="../../SelectDataItem/Data/@name"/>_text<xsl:value-of select="$guid"/></xsl:with-param>
																<!-- MM :End - D036 - fix for id issue -->
															</xsl:call-template>
															</td>
														</xsl:otherwise>
													</xsl:choose>
											</xsl:for-each>
										</tr>
									</table>
									<xsl:if test="$childrows > 0">
										<div>
											<xsl:choose>
												<xsl:when test="@tree = 'collapse' ">
													<xsl:attribute name="style">DISPLAY: none</xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="style">DISPLAY: </xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
											<table width="100%" border="0" cellpadding="0" cellspacing="0">
												<xsl:for-each select="ChildrenRows/Row">
													<xsl:call-template name="SelectionDataRow">
														<xsl:with-param name="childrows"><xsl:value-of select="count(ChildrenRows/Row)"/></xsl:with-param>
														<!-- MM :Begin - D036 - fix for id issue -->
														<xsl:with-param name="puid"><xsl:number count="node()" level="any"/></xsl:with-param>
														<!-- MM :End - D036 - fix for id issue -->
													</xsl:call-template>
												</xsl:for-each>
											</table>
										</div>
									</xsl:if>
								</td>
							</tr>
						</table>
						</div>
						<xsl:if test="$childrows > 0">
							<script language="javascript">
								document.write('&lt;/table&gt;');
								document.write('&lt;/tr&gt;');
								document.write('&lt;/td&gt;');
							</script>
						</xsl:if>
					</td>
				</tr>	
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	<xsl:template name="calldatatype">
		<!-- MM : Begin - D034 - fix for id issue -->
		<xsl:param name="puid"/>
		<!-- MM : End - D034 - fix for id issue -->
		<xsl:choose>
			<xsl:when test="@align != '' ">
				<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="align">left</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="@width !=''">
			<xsl:attribute name="width"><xsl:value-of select="@width"/>px</xsl:attribute>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="@link='true'">
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:call-template name="add-href-data" /></xsl:attribute>
					<xsl:call-template name="datatype">
						<!-- MM : Begin - D034 - fix for id issue -->
						<xsl:with-param name="uid" select="$puid"/>
						<!-- MM : End - D034 - fix for id issue -->
						<xsl:with-param name="display">
							<xsl:value-of select="@display"/>
						</xsl:with-param>
						<xsl:with-param name="type">
							<xsl:value-of select="@type"/>
						</xsl:with-param>
						<xsl:with-param name="name">
							<xsl:value-of select="@name"/>
						</xsl:with-param>
						<xsl:with-param name="id">
							<!-- MM : Begin - D034 - fix for id issue -->
							<xsl:value-of select="@id"/>
							<!-- xsl:value-of select="@name"/ -->
							<!-- MM : End - D034 - fix for id issue -->
						</xsl:with-param>
						<xsl:with-param name="value">
							<xsl:value-of select="@value"/>
						</xsl:with-param>
						<xsl:with-param name="returnvalue">
							<xsl:value-of select="@returnvalue"/>
						</xsl:with-param>
						<xsl:with-param name="state">
							<xsl:value-of select="@state"/>
						</xsl:with-param>
						<xsl:with-param name="preserve_format">
							<xsl:if test="@name = 'Description'">yes</xsl:if>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="datatype">
					<!-- MM : Begin - D034 - fix for id issue -->
					<xsl:with-param name="uid" select="$puid"/>
					<!-- MM : End - D034 - fix for id issue -->				
					<xsl:with-param name="display">
						<xsl:value-of select="@display"/>
					</xsl:with-param>
					<xsl:with-param name="type">
						<xsl:value-of select="@type"/>
					</xsl:with-param>
					<xsl:with-param name="name">
						<xsl:value-of select="@name"/>
					</xsl:with-param>
					<xsl:with-param name="id">
						<!-- MM : Begin - D034 - fix for id issue -->
						<xsl:value-of select="@id"/>
						<!-- xsl:value-of select="@name"/ -->
						<!-- MM : End - D034 - fix for id issue -->
					</xsl:with-param>
					<xsl:with-param name="value">
						<xsl:value-of select="@value"/>
					</xsl:with-param>
					<xsl:with-param name="returnvalue">
						<xsl:value-of select="@returnvalue"/>
					</xsl:with-param>
					<xsl:with-param name="state">
						<xsl:value-of select="@state"/>
					</xsl:with-param>
					<xsl:with-param name="size">
						<xsl:value-of select="@size"/>
					</xsl:with-param>
					<xsl:with-param name="uparrscript">
						<xsl:value-of select="@uparrscript"/>
					</xsl:with-param>
					<xsl:with-param name="downarrscript">
						<xsl:value-of select="@downarrscript"/>
					</xsl:with-param>
					<xsl:with-param name="sep">
						<xsl:value-of select="@sep"/>
					</xsl:with-param>
					<xsl:with-param name="value1">
						<xsl:value-of select="@value1"/>
					</xsl:with-param>
					<xsl:with-param name="value2">
						<xsl:value-of select="@value2"/>
					</xsl:with-param>
					<xsl:with-param name="value3">
						<xsl:value-of select="@value3"/>
					</xsl:with-param>
					<xsl:with-param name="value4">
						<xsl:value-of select="@value4"/>
					</xsl:with-param>
					<xsl:with-param name="event">
						<xsl:value-of select="@event"/>
					</xsl:with-param>
					<xsl:with-param name="handler">
						<xsl:value-of select="@handler"/>
					</xsl:with-param>
					<xsl:with-param name="preserve_format">
						<xsl:if test="@name = 'Description'">yes</xsl:if>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:value-of select="@unit"/>
									<xsl:variable name="novalue"><xsl:choose>
										<xsl:when test="@value">
											<xsl:choose>
												<xsl:when test="@value='' ">true</xsl:when>
												<xsl:otherwise>false</xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise>true</xsl:otherwise>
									</xsl:choose></xsl:variable>
									<xsl:if test="ValueList">
										<xsl:for-each select="ValueList/value">
											<xsl:value-of select="."/><xsl:if test="position() != last()"><br/></xsl:if>
										</xsl:for-each>
									</xsl:if>
	</xsl:template>
	<xsl:template name="datatype">
		<!-- MM : Begin - D005 - fix for id issue -->
		<xsl:param name="uid"/>
		<xsl:param name="ignoreName" select="false"/>
		<!-- MM : End - D005 - fix for id issue -->
		<xsl:param name="display"/>
		<xsl:param name="type"/>
		<xsl:param name="name"/>
		<xsl:param name="id"/>
		<xsl:param name="value"/>
		<xsl:param name="value1"/>
		<xsl:param name="value2"/>
		<xsl:param name="value3"/>
		<xsl:param name="value4"/>
		<xsl:param name="returnvalue"/>
		<xsl:param name="state"/>
		<xsl:param name="size"/>
		<xsl:param name="uparrscript"/>
		<xsl:param name="downarrscript"/>
		<xsl:param name="sep"/>
		<xsl:param name="event"/>
		<xsl:param name="handler"/>
		<xsl:param name="preserve_format"/>
		<!--C91707 Ability to set selection box width-->
		<xsl:param name="width"/>
		<xsl:choose>
			<xsl:when test="$type='password'">
				<xsl:element name="input">
					<!-- C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:attribute name="type">password</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D001 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D001 - Fix for id issue -->
					<xsl:choose>
						<xsl:when test="$size !=''">
							<xsl:attribute name="size"><xsl:value-of select="$size + 5"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="size">10</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="maxlength"><xsl:value-of select="$size"/></xsl:attribute>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='textarea'">
				<xsl:element name="textarea">
					<xsl:if test="@state = '2'">
						<xsl:attribute name="disabled"/>
					</xsl:if>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D002 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D002 - Fix for id issue -->
					<xsl:choose>
						<xsl:when test="@cols !=''">
							<xsl:attribute name="cols"><xsl:value-of select="@cols"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="cols">30</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="@rows !=''">
							<xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="rows">1</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="$value"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='editbox'">
				<xsl:element name="input">
					<!-- C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D003 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D003 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
					<xsl:if test="@maxlength"><xsl:attribute name="maxlength"><xsl:value-of select="@maxlength"/></xsl:attribute></xsl:if>
					<xsl:choose>
						<xsl:when test="$size !=''">
							<xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="size">10</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="@state=2">
						<xsl:attribute name="disabled"/>
					</xsl:if>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='checkbox'">
				<xsl:element name="input">
					<!--C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="type">checkbox</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D004 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D004 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$returnvalue"/></xsl:attribute>
					<xsl:if test="@state=1">
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:if test="@state=2">
						<xsl:attribute name="disabled"/>
					</xsl:if>
					<xsl:if test="@state=3">
						<xsl:attribute name="disabled"/>
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:value-of select="$value"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='radio'">
				<xsl:element name="input">
				<!-- 102437 UI:Disable Radio Button are not clear -->
				<xsl:attribute name="style"><xsl:value-of select="'background-color:transparent'"/></xsl:attribute>
					<!--88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<xsl:attribute name="type">radio</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D005 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D005 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$returnvalue"/></xsl:attribute>
					<xsl:if test="@state=1">
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:if test="@state=2">
						<xsl:attribute name="disabled"/>
					</xsl:if>
					<xsl:if test="@state=3">
						<xsl:attribute name="disabled"/>
						<xsl:attribute name="checked"/>
					</xsl:if>
					<xsl:value-of select="$value"/>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='hidden'">
				<xsl:element name="input">
					<!--C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:attribute name="type">hidden</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D006  - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D006 - Fix for id issue -->
					<xsl:attribute name="value"><xsl:value-of select="$returnvalue"/></xsl:attribute>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='select'">
				<xsl:element name="select">
					<!--C88676 fix smallfont font size -->
					<xsl:attribute name="class">data-area</xsl:attribute>
					<xsl:if test="@event">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:if>
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
					<!--C91707 Ability to set selection box width-->
					<xsl:attribute name="style"><xsl:value-of select="$width"/></xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D011 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D011 - Fix for id issue -->
					<xsl:for-each select="Choice">
						<xsl:element name="option">
							<xsl:if test="@default = 'true'">
								<xsl:attribute name="selected"/>
							</xsl:if>
							<xsl:attribute name="value"><xsl:value-of select="@returnvalue"/></xsl:attribute>
							<xsl:value-of select="@value"/>
						</xsl:element>
					</xsl:for-each>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='icon'">
				<!-- MM : Begin - D008 - Fix for id issue -->
				<xsl:variable name="idval">
					<xsl:choose>
						<!-- when id is given -->
						<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
						<!-- when name is given -->
						<xsl:when test="$name != ''"><xsl:value-of select="$name"/></xsl:when>
						<!-- neither id nor name is given -->
						<xsl:otherwise>icon_<xsl:value-of select="$uid"/></xsl:otherwise>
					</xsl:choose>				
				</xsl:variable>
				<!-- MM : End - D008 - Fix for id issue -->
				<xsl:element name="img">
					<!-- MM : Begin - D008 - Fix for id issue -->
					<!-- xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<!-- for img, silktest requires name attribute, hence ensure name attribute is not null -->
					<xsl:choose>
						<xsl:when test="$name != ''">
							<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name"><xsl:value-of select="$idval"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:attribute name="id"><xsl:value-of select="$idval"/></xsl:attribute>
					<!-- MM : End - D008 - Fix for id issue -->
					<xsl:attribute name="src"><xsl:value-of select="$value"/></xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
					<xsl:attribute name="title"><xsl:value-of select="@alt"/></xsl:attribute>
					<xsl:attribute name="border">0</xsl:attribute>
					<!-- C73437 - Added EventHandling capability to status icon -->
					<xsl:for-each select="EventHandler">
						<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
					</xsl:for-each>
				</xsl:element>
			</xsl:when>
			<xsl:when test="$type='status'">
				<xsl:call-template name="display-status">
					<xsl:with-param name="name" select="$name" />
					<xsl:with-param name="status" select="$value" />
					<!-- MM : Begin - D023 - Fix for id issue -->
					<xsl:with-param name="id">
						<xsl:choose>
							<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$uid"/></xsl:otherwise>
						</xsl:choose>						
					</xsl:with-param>
					<!-- MM : End - D023 - Fix for id issue -->
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='status-text'">
				<xsl:call-template name="display-status-text">
					<xsl:with-param name="status" select="$value" />
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='button'">
				<xsl:call-template name="button">
					<xsl:with-param name="href">
						<xsl:choose>
							<xsl:when test="@href"><xsl:value-of select="@href"/></xsl:when>
							<xsl:otherwise>javascript:history.go(0)</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
					<xsl:with-param name="formSubmit">true</xsl:with-param>
					<xsl:with-param name="display"><xsl:value-of select="@display" /></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$type='spincontrol'">
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:if test="@event">
									<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
								</xsl:if>
								<xsl:for-each select="EventHandler">
									<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
								</xsl:for-each>
								<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
								<!-- MM : Begin - D009 - Fix for id issue -->
								<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
								<xsl:choose>
									<xsl:when test="$id != ''">
										<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<!-- MM : End - D009 - Fix for id issue -->
								<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
								<xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@state=3">
									<xsl:attribute name="readonly"/>
								</xsl:if>
							</xsl:element>
						</td>
						<td style="height: 10px">
							<img   style="width: 1px; height: 1px"/>
						</td>
						<td>
							<table border="0" cellpadding="0" cellspacing="0">
								<tr>
									<td>
										<xsl:element name="a">
											<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
											<xsl:choose>
												<xsl:when test="contains($uparrscript, 'javascript')">
													<xsl:attribute name="href">#spincontrolanchor</xsl:attribute>
													<!-- 108933 - Upper button highlighted when lower button clicked -->
													<!-- MM : Begin - D009 - Fix for id issue -->
													<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
													<xsl:choose>
														<xsl:when test="$id != ''">
															<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
													<!-- MM : End - D009 - Fix for id issue -->
													<xsl:attribute name="onclick"><xsl:value-of select="$uparrscript" /></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="href"><xsl:value-of select="$uparrscript" /></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<img src="/oma/images/ar1.gif" style="width: 16px; height: 11px" />
										</xsl:element>
									</td>
								</tr>
								<tr>
									<td>
										<xsl:element name="a">
											<!-- 108933 - Upper button highlighted when lower button clicked -->
											<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
											<xsl:choose>
												<xsl:when test="contains($downarrscript, 'javascript')">
													<xsl:attribute name="href">#spincontrolanchor</xsl:attribute>
													<!-- 108933 - Upper button highlighted when lower button clicked -->
													<!-- MM : Begin - D009 - Fix for id issue -->
													<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
													<xsl:choose>
														<xsl:when test="$id != ''">
															<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
														</xsl:when>
														<xsl:otherwise>
															<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
														</xsl:otherwise>
													</xsl:choose>
													<!-- MM : End - D009 - Fix for id issue -->
													<xsl:attribute name="onclick"><xsl:value-of select="$downarrscript" /></xsl:attribute>
												</xsl:when>
												<xsl:otherwise>
													<xsl:attribute name="href"><xsl:value-of select="$downarrscript" /></xsl:attribute>
												</xsl:otherwise>
											</xsl:choose>
											<img src="/oma/images/ar2.gif" style="width: 16px; height: 11px" />
										</xsl:element>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="$type='ipaddrbox'">
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>1</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>1</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value1"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',1,2);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
						<td valign="bottom"><xsl:value-of select="$sep"/></td>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>2</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>2</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value2"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',2,3);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
						<td valign="bottom"><xsl:value-of select="$sep"/></td>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>3</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>3</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value3"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',3,4);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
						<td valign="bottom"><xsl:value-of select="$sep"/></td>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="name"><xsl:value-of select="$name"/>4</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>4</xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value4"/></xsl:attribute>
								<xsl:attribute name="size">4</xsl:attribute>
								<xsl:attribute name="maxlength">3</xsl:attribute>
								<xsl:if test="@state=2">
									<xsl:attribute name="disabled"/>
								</xsl:if>
								<xsl:if test="@autocursoroff != 'true'">
									<xsl:attribute name="onfocus">if (this.value.length==3) {mj=false;}else{mj=true;}</xsl:attribute>
									<xsl:attribute name="onkeypress">mj=true</xsl:attribute>
									<xsl:attribute name="onkeyup">javascript:rchar('<xsl:value-of select="$name"/>',4,4);</xsl:attribute>
								</xsl:if>
							</xsl:element>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="$type='date'">
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td style="width: 14px; height: 25px">
							<xsl:element name="input">
								<xsl:attribute name="style">font-weight:bold</xsl:attribute>
								<xsl:attribute name="name"><xsl:value-of select="$name"/>Hid</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>Hid</xsl:attribute>
								<xsl:choose>
									<xsl:when test="@width">
										<xsl:attribute name="size"><xsl:value-of select="@width"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="size">29</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:attribute name="disabled"/>
							</xsl:element>
							<xsl:element name="input">
								<xsl:attribute name="type">hidden</xsl:attribute>
								<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
							</xsl:element>
						</td>
						<script language="javascript">
							<xsl:choose>
								<xsl:when test="$value = 'Please set the value'">
									document.getElementById('<xsl:value-of select="$name"/>Hid').value = '<xsl:value-of select="$value"/>';
								</xsl:when>
								<xsl:otherwise>
									{
										var client_offset_cal = new Date();
										var date_var1 = new Date ('<xsl:value-of select="$value"/>');
										var clientOffsetMins = client_offset_cal.getTimezoneOffset();
										
										<xsl:if test="@srvOffset">
											var finalTime = '<xsl:value-of select="$value"/>';
											var adjustedFinalTime = new Number(finalTime) + new Number(<xsl:value-of select="@srvOffset"/>) + new Number(clientOffsetMins * 60 * 1000);
											date_var1 = new Date(adjustedFinalTime);											
										</xsl:if>
										
										var sdispLongDate = date_var1.toString();
										
										var sdateString1 = sdispLongDate.substr(0,sdispLongDate.indexOf(':')-2);
										var sYear = date_var1.getYear();
										if (navigator.appName == 'Netscape')
								        	{
								        	    var sdispDate = sdateString1;
								        	}
								        	else
								        	{
								        	    var sdispDate = sdateString1 + sYear;
								        	}
										if (sdispDate != "NaN")
										{
											document.getElementById('<xsl:value-of select="$name"/>Hid').value = sdispDate;
										}
									}

								</xsl:otherwise>
                        				</xsl:choose>
						</script>
						<td>
							<img>
								<xsl:attribute name="name"><xsl:value-of select="$name"/>Img</xsl:attribute>
								<xsl:attribute name="id"><xsl:value-of select="$name"/>Img</xsl:attribute>
								<xsl:attribute name="src">/oma/images/calendar.gif</xsl:attribute>
								<xsl:attribute name="onClick">javascript:showCalendar('<xsl:value-of select="$name"/>Img', '<xsl:value-of select="$name"/>')</xsl:attribute>
								<xsl:attribute name="border">0</xsl:attribute>
							</img>
						</td>
					</tr>
				</table>
				<!-- 89828 Allow initialize of date value-->
		         <script language="javascript">
			           convertDate('<xsl:value-of select="@name"/>', '<xsl:value-of select="@value"/>', '<xsl:value-of select="@srvOffset"/>');
			    </script>				
			</xsl:when>
			<!-- input tag with type=file will display a text box with a "Browse..." button for file sytem exploring -->
			<xsl:when test="$type='file'">
				<xsl:element name="input">
					<xsl:attribute name="type">file</xsl:attribute>
					<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
					<!-- MM : Begin - D010 - Fix for id issue -->
					<!-- xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute -->
					<xsl:choose>
						<xsl:when test="$id != ''">
							<xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="id"><xsl:value-of select="$name"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
					<!-- MM : End - D010 - Fix for id issue -->
				</xsl:element>
			</xsl:when>
			<!--88595 OMSS Fix custom data type -->
               <xsl:when test="@type='custom'">
				<xsl:apply-templates/>
			</xsl:when>
			<xsl:otherwise>
				<!-- MM : Begin - D007 - Fix for id issue -->
				<xsl:variable name="idval">
					<xsl:choose>
						<!-- when id is given -->
						<xsl:when test="@id != ''"><xsl:value-of select="@id"/></xsl:when>
						<!-- when name is given -->
						<xsl:when test="@name != '' and $ignoreName ='false'"><xsl:value-of select="@name"/></xsl:when>
						<!-- neither id nor name is given -->
						<xsl:otherwise><xsl:value-of select="$uid"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!-- MM : End - D007 - Fix for id issue -->
				<xsl:choose>
					<xsl:when test="$preserve_format = 'yes'">
						<!-- MM : Begin - D007 - Fix for id issue -->
						<!-- id is set for <td> and not for <pre>, because if set for <pre>, silktest is not able to identify it. -->
						<xsl:choose>
							<!-- when id is given -->
							<xsl:when test="@id != ''">
								<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>							
							</xsl:when>
							<!-- when id is not given -->
							<xsl:otherwise>
								<xsl:attribute name="id"><xsl:value-of select="$uid"/></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<!-- MM : End - D007 - Fix for id issue -->
						<pre class="data-area-information">
							<xsl:choose>
								<xsl:when test="@value">
									<xsl:choose>
										<xsl:when test="@value=''">
											<xsl:choose>
												<xsl:when test="ValueList"></xsl:when>
												<xsl:otherwise><img src='/oma/images/blank.gif'/></xsl:otherwise>
											</xsl:choose>
										</xsl:when>
										<xsl:otherwise><xsl:value-of select="@value"/></xsl:otherwise>
									</xsl:choose>
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test="ValueList"></xsl:when>
										<xsl:otherwise><img src='/oma/images/blank.gif'/></xsl:otherwise>
									</xsl:choose>
								</xsl:otherwise>
							</xsl:choose>
						</pre>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@value">
								<xsl:choose>
									<xsl:when test="@value=''">
										<xsl:choose>
											<xsl:when test="ValueList"></xsl:when>
											<xsl:otherwise>
												<!-- MM : Begin - D007 - Fix for id issue -->
												<!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
												<!-- xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute-->
												<xsl:attribute name="id"><xsl:value-of select="$idval"/></xsl:attribute>
												<xsl:choose>
													<xsl:when test="@name != ''">
														<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
													</xsl:when>
													<xsl:otherwise>
														<!-- we ensure 'name' attribute is not null because SilkTest doesnt use id for Hrefs -->
														<xsl:attribute name="name"><xsl:value-of select="$idval"/></xsl:attribute>
													</xsl:otherwise>
												</xsl:choose>
												<!-- MM : End - D007 - Fix for id issue -->
												<img src='/oma/images/blank.gif'/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:otherwise>
										<!-- MM : Begin - D007 - Fix for id issue -->
										<!-- xsl:attribute name="id"><xsl:value-of select="@name"/></xsl:attribute -->
										<!-- xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute -->
										<xsl:attribute name="id"><xsl:value-of select="$idval"/></xsl:attribute>
										<xsl:choose>
											<xsl:when test="@name != ''">
												<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<!-- we ensure 'name' attribute is not null because SilkTest doesnt use id for Hrefs -->
												<xsl:attribute name="name"><xsl:value-of select="$idval"/></xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<!-- MM : End - D007 - Fix for id issue -->
										<xsl:value-of select="@value"/>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="ValueList"></xsl:when>
									<xsl:otherwise><img src='/oma/images/blank.gif'/></xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="sep">
		<xsl:param name="colspan"/>
		<td class="data-area-separator" style="height: 1px">
			<img   style="width: 1px; height: 1px"/>
		</td>
		<xsl:if test="$colspan > 0">
			<xsl:call-template name="sep">
				<xsl:with-param name="colspan">
					<xsl:value-of select="($colspan)-1"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template match="script">
		<xsl:copy-of select="." />
	</xsl:template>


	<xsl:template name="button">
		<xsl:param name="href" />
		<xsl:param name="display" />
		<xsl:param name="value" />
		<xsl:param name="onclick" />
		<xsl:param name="formSubmit" />
		<xsl:param name="tablebutton" />
		<xsl:param name="id" />
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<xsl:call-template name="button_details">
					<xsl:with-param name="href"><xsl:value-of select="$href" /></xsl:with-param>
					<xsl:with-param name="display">
						<xsl:choose>
							<xsl:when test="@value !=''"><xsl:value-of select="@value"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$display"/></xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
					<xsl:with-param name="onclick"><xsl:value-of select="$onclick" /></xsl:with-param>
					<xsl:with-param name="formSubmit"><xsl:value-of select="$formSubmit" /></xsl:with-param>
					<xsl:with-param name="tablebutton"><xsl:value-of select="$tablebutton" /></xsl:with-param>
					<xsl:with-param name="id"><xsl:value-of select="$id" /></xsl:with-param>
				</xsl:call-template>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="button_details">
		<xsl:param name="href" />
		<xsl:param name="display" />
		<xsl:param name="onclick" />
		<xsl:param name="formSubmit" />
		<xsl:param name="tablebutton" />
		<xsl:param name="id" />


		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
			<xsl:choose>
				<xsl:when test="@tablebutton='true'">
					<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/table_lbutton.gif</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/lbutton.gif</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
		</img>
		</td>
		<!-- MM : Begin - D013 - Fix for id issue -->
		<xsl:variable name="uid">
			<xsl:choose>
				<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
				<xsl:otherwise><!-- check if you need to assign some default id --></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : End - D013 - Fix for id issue -->
		<td class="data-area-button" align="center" valign="middle">
			<xsl:choose>
				<xsl:when test="$formSubmit = 'true'">
					<script language="javascript">
						document.write ("&lt;a");
						if (navigator.appName == "Microsoft Internet Explorer") {
							var sAppVersion = navigator.appVersion;
							sAppVersion = sAppVersion.replace (/.*MSIE /i, "");
							sAppVersion = sAppVersion.split (';')[0];
							if (sAppVersion >= "5.5") {
								<xsl:choose>
									<xsl:when test="contains($href, 'javascript')">
										document.write (" href='#' onclick='<xsl:value-of select="$href" />'");
									</xsl:when>
									<xsl:otherwise>document.write (" href='<xsl:value-of select="$href" />'");</xsl:otherwise>
								</xsl:choose>
							}
							else
								document.write (" href='<xsl:value-of select="$href" />'");
						}
						else {
							document.write (" href='<xsl:value-of select="$href" />'");
						}
						<!-- MM : Begin - D013 - Fix for id issue -->
						<!-- document.write ("<xsl:if test="$id != ''"> id='<xsl:value-of select="$id" />'</xsl:if>&gt;"); -->
						<!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
						document.write ("<xsl:if test="$uid != ''"> name='<xsl:value-of select="$uid" />'</xsl:if>");
						document.write ("<xsl:if test="$uid != ''"> id='<xsl:value-of select="$uid" />'</xsl:if>&gt;");
						<!-- MM : End - D013 - Fix for id issue -->
						document.write ("<xsl:value-of select="$display" />");
						document.write ("&lt;/a>");
					</script>
				</xsl:when>
				<xsl:otherwise>
					<a>
						<xsl:choose>
							<xsl:when test="contains($href, 'javascript')">
								<xsl:attribute name="href">#</xsl:attribute>
								<xsl:attribute name="onclick"><xsl:value-of select="$href" /></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute>
								<xsl:if test="$onclick != ''"><xsl:attribute name="onclick"><xsl:value-of select="$onclick" /></xsl:attribute></xsl:if>
							</xsl:otherwise>
						</xsl:choose>
						<!-- MM : Begin - D013 - Fix for id issue -->
						<!-- xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id" /></xsl:attribute></xsl:if -->
						<xsl:attribute name="id"><xsl:value-of select="$uid" /></xsl:attribute>
						<!-- we give 'name' attribute as well as SilkTest doesnt use id for Hrefs -->
						<xsl:attribute name="name"><xsl:value-of select="$uid" /></xsl:attribute>
						<!-- MM : End - D013 - Fix for id issue -->
						<xsl:value-of select="$display" />
					</a>
				</xsl:otherwise>
			</xsl:choose>
		</td>
		<td style="width: 14px; height: 25px">
			<img style="width: 14px; height: 25px">
				<xsl:choose>
				<xsl:when test="@tablebutton='true'">
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/table_rbutton.gif</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="src">/oma/<xsl:if test="/OMA/@skin != ''">skins/<xsl:value-of select="/OMA/@skin"/>/<xsl:if test="/OMA/@scheme != ''">schemes/<xsl:value-of select="/OMA/@scheme"/>/</xsl:if></xsl:if>images/rbutton.gif</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</img>
		</td>
	</xsl:template>

	<!--<xsl:template name="replace-substring">
		<xsl:param name="text" />
		<xsl:param name="from" />
		<xsl:param name="to" />
		<xsl:call-template name="_replace-substring">
			<xsl:with-param name="text"><xsl:value-of select="$text" /></xsl:with-param>
			<xsl:with-param name="from" select="$from" />
			<xsl:with-param name="to" select="$to" />
		</xsl:call-template>
	</xsl:template>-->

	<xsl:template name="replace-substring">
		<xsl:param name="text" />
		<xsl:param name="from"/>
		<xsl:param name="to"/>
		<xsl:variable name="backslash">
			<xsl:call-template name="_replace-substring">
				<xsl:with-param name="text"><xsl:value-of select="$text" /></xsl:with-param>
				<xsl:with-param name="from">\</xsl:with-param>
				<xsl:with-param name="to">\\</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="singlequote">
			<xsl:call-template name="_replace-substring">
				<xsl:with-param name="text"><xsl:value-of select="$backslash" /></xsl:with-param>
				<xsl:with-param name="from">'</xsl:with-param>
				<xsl:with-param name="to">\'</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="doublequote">
			<xsl:call-template name="_replace-substring">
				<xsl:with-param name="text"><xsl:value-of select="$singlequote" /></xsl:with-param>
				<xsl:with-param name="from">"</xsl:with-param>
				<xsl:with-param name="to">\"</xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="$doublequote"/>
	</xsl:template>

	<xsl:template name="_replace-substring">
		<xsl:param name="text" />
		<xsl:param name="from" />
		<xsl:param name="to" />
		<xsl:choose>
			<xsl:when test="contains($text, $from)">
				<xsl:value-of select="substring-before ($text, $from)" />
				<xsl:value-of select="$to" />
				<xsl:call-template name="_replace-substring">
					<xsl:with-param name="text" select="substring-after($text, $from)" />
					<xsl:with-param name="from" select="$from" />
					<xsl:with-param name="to" select="$to" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="display-status">
		<xsl:param name="name" />
		<xsl:param name="status" />
		<!-- MM : Begin - D023 - Fix for id issue -->
		<xsl:param name="id"/>
		<xsl:variable name="idval">
			<xsl:choose>
				<!-- when id is given -->
				<xsl:when test="$id != ''"><xsl:value-of select="$id"/></xsl:when>
				<!-- if id not given -->
				<xsl:otherwise>img_<xsl:value-of select="position()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="nameval">
			<xsl:choose>
				<xsl:when test="$name != ''"><xsl:value-of select="$name"/></xsl:when>
				<!-- if name not  given, we ensure 'name' attribute is not null because SilkTest doesnt use id for Hrefs -->
				<xsl:otherwise><xsl:value-of select="$idval"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- MM : End - D023 - Fix for id issue -->
		
		<xsl:element name="img">
			<xsl:attribute name="name"><xsl:value-of select="$nameval" /></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="$idval" /></xsl:attribute>
			<xsl:attribute name="src">
				<xsl:choose>
					<xsl:when test="$status='0'">/oma/images/blank.gif</xsl:when>
					<xsl:when test="$status='1'">/oma/images/blank.gif</xsl:when>
					<xsl:when test="$status='2'">/oma/images/ok.gif</xsl:when>
					<xsl:when test="$status='3'">/oma/images/non-critical.gif</xsl:when>
					<xsl:when test="$status='4'">/oma/images/critical.gif</xsl:when>
					<xsl:when test="$status='5'">/oma/images/non-recoverable.gif</xsl:when>
					<xsl:when test="$status='6'">/oma/images/abort.gif</xsl:when>
					<xsl:when test="$status='7'">/oma/images/progress.gif</xsl:when>
					<xsl:when test="$status='8'">/oma/images/suspend.gif</xsl:when>
					<xsl:when test="$status='9'">/oma/images/resume.gif</xsl:when>
					<xsl:when test="$status='10'">/oma/images/pending.gif</xsl:when>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="border">0</xsl:attribute>
			<xsl:attribute name="align">absmiddle</xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="$strStatus2"/><xsl:call-template name="display-status-text"><xsl:with-param name="status" select="$status" /></xsl:call-template></xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="$strStatus3"/><xsl:call-template name="display-status-text"><xsl:with-param name="status" select="$status" /></xsl:call-template></xsl:attribute>
		<!-- C73437 - Added EventHandling capability to status icon -->
		<xsl:for-each select="EventHandler">
			<xsl:attribute name="{@event}"><xsl:value-of select="@handler"/></xsl:attribute>
		</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<!-- Start CHNG99370 - Visual cue for sort order -->
	<xsl:template name="display-sortorder">
		<xsl:param name="name" />	
		<xsl:param name="sortorder" />
		<img name="sortOrderImg">
			<xsl:choose>
				<xsl:when test="$sortorder='ascending'">
					<xsl:attribute name="src">/oma/images/ascend.gif</xsl:attribute>
				</xsl:when>
				<xsl:when test="$sortorder!='ascending'">
					<xsl:attribute name="src">/oma/images/descend.gif</xsl:attribute>
				</xsl:when> 
			</xsl:choose>
		</img>
	</xsl:template>
	<!-- End CHNG99370 - Visual cue for sort order -->

	<xsl:template name="display-status-text">
		<xsl:param name="status" />
			<xsl:choose>
				<xsl:when test="$status='0'"><xsl:value-of select="$strUnknown"/></xsl:when>
				<xsl:when test="$status='1'"><xsl:value-of select="$strUnknown1"/></xsl:when>
				<xsl:when test="$status='2'"><xsl:value-of select="$strOK"/></xsl:when>
				<xsl:when test="$status='3'"><xsl:value-of select="$strNonCritical"/></xsl:when>
				<xsl:when test="$status='4'"><xsl:value-of select="$strCritical"/></xsl:when>
				<xsl:when test="$status='5'"><xsl:value-of select="$strNonRecoverable"/></xsl:when>
				<xsl:when test="$status='6'"><xsl:value-of select="$strAborted"/></xsl:when>
				<xsl:when test="$status='7'"><xsl:value-of select="$strProgress"/></xsl:when>
				<xsl:when test="$status='8'"><xsl:value-of select="$strSuspended"/></xsl:when>
				<xsl:when test="$status='9'"><xsl:value-of select="$strResume"/></xsl:when>
				<xsl:when test="$status='10'"><xsl:value-of select="$strPending"/></xsl:when>
			</xsl:choose>
	</xsl:template>

	<!--
		This template re-writes the URL to add the menu selection data; this is needed to support the browser's back button
		Keep in one line!!!
	 -->
	<xsl:template name="add-href-data">
		<xsl:value-of select="@href"/><xsl:if test="contains(@href, 'javascript') = false"><xsl:choose><xsl:when test="contains(@href, '?')">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose>ct=<xsl:value-of select="/OMA/@component" />&amp;snb=<xsl:value-of select="/OMA/@snb" />&amp;lsnb=<xsl:value-of select="/OMA/@lsnb" />&amp;vid=<xsl:value-of select="/OMA/@vid" /></xsl:if>
	</xsl:template>

	<!-- This template is commented because.... Identity transformation is not possible in it's presence.
	<xsl:template match="*"/>-->
</xsl:stylesheet>
